/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BayesFactorSubDlg
extends BaseSubDialog
implements DocumentListener {
    static final String ROUNDER_METHOD = "IDS_ROUNDER_METHOD";
    static final String GONEN_METHOD = "IDS_GONEN_METHOD";
    static final String GONEN_MEAN = "IDS_GONEN_MEAN";
    static final String GONEN_VALRIANCE = "IDS_GONEN_VARIANCE";
    static final String HYPER_PRIOR = "IDS_HYPER_PRIOR";
    static final String HYPER_SHAPE_PARAM = "IDS_SHAPE_PARAM_LABEL";
    private JRadioButton mRouderRadio;
    private JRadioButton mGonenRadio;
    private JRadioButton mHyperRadio;
    private SpssButtonGroup mEstimatingGroup;
    private JLabel mMeanLabel;
    private FloatTextField mMeanField;
    private JLabel mVarianceLabel;
    private FloatTextField mVarianceField;
    private JLabel mShapeParamLabel;
    private FloatTextField mShapeParamField;
    private boolean mIsDistRadioSelected;

    public BayesFactorSubDlg(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, true);
        this.mIsDistRadioSelected = bl;
        this.setDefaults();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_independent_sample_bayes";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    protected void initVars() {
        this.mRouderRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_INDEPT_FACTOR_ROUDER"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BayesFactorSubDlg.this.onGonenMethod(BayesFactorSubDlg.this.mGonenRadio.isSelected());
                BayesFactorSubDlg.this.onHyperMethod(BayesFactorSubDlg.this.mHyperRadio.isSelected());
                BayesFactorSubDlg.this.enableContinue(BayesFactorSubDlg.this.canEnableContinue());
            }
        });
        this.mGonenRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_INDEPT_FACTOR_GONEN"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BayesFactorSubDlg.this.onGonenMethod(BayesFactorSubDlg.this.mGonenRadio.isSelected());
                BayesFactorSubDlg.this.onHyperMethod(BayesFactorSubDlg.this.mHyperRadio.isSelected());
                BayesFactorSubDlg.this.enableContinue(BayesFactorSubDlg.this.canEnableContinue());
            }
        });
        this.mHyperRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_INDEPT_FACTOR_HYPER"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BayesFactorSubDlg.this.onHyperMethod(BayesFactorSubDlg.this.mHyperRadio.isSelected());
                BayesFactorSubDlg.this.onGonenMethod(BayesFactorSubDlg.this.mGonenRadio.isSelected());
                BayesFactorSubDlg.this.enableContinue(BayesFactorSubDlg.this.canEnableContinue());
            }
        });
        this.mMeanLabel = DialogUtil.createLabel(this, "IDS_INDEPT_FACTOR_MEAN");
        this.mMeanField = new FloatTextField(Double.NaN, Double.NaN, 5, false);
        this.mMeanField.setAllowMinMax(false, false);
        this.mMeanField.setColumns(8);
        this.mMeanField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_INDEPT_FACTOR_MEAN"));
        this.mMeanLabel.setLabelFor((Component)this.mMeanField);
        this.mVarianceLabel = DialogUtil.createLabel(this, "IDS_INDEPT_FACTOR_VARIANCE");
        this.mVarianceField = new FloatTextField(0.0, Double.NaN, 5, true);
        this.mVarianceField.setAllowMinMax(false, false);
        this.mVarianceField.setColumns(8);
        this.mVarianceField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_INDEPT_FACTOR_VARIANCE"));
        this.mVarianceLabel.setLabelFor((Component)this.mVarianceField);
        this.mShapeParamLabel = DialogUtil.createLabel(this, "IDS_INDEPT_FACTOR_SHAPE");
        this.mShapeParamField = new FloatTextField(-1.0, -0.5, 5, false);
        this.mShapeParamField.setAllowMinMax(false, true);
        this.mShapeParamField.setColumns(8);
        this.mShapeParamField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_INDEPT_FACTOR_SHAPE"));
        this.mShapeParamLabel.setLabelFor((Component)this.mShapeParamField);
        this.mEstimatingGroup = new SpssButtonGroup();
        this.mEstimatingGroup.add(this.mRouderRadio);
        this.mEstimatingGroup.add(this.mGonenRadio);
        this.mEstimatingGroup.add(this.mHyperRadio);
        this.mVarianceField.getDocument().addDocumentListener(this);
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        this.onGonenMethod(this.mGonenRadio.isEnabled() && this.mGonenRadio.isSelected());
        this.onHyperMethod(this.mHyperRadio.isEnabled() && this.mHyperRadio.isSelected());
    }

    public static String getByesFactorSyntax(DialogDataModel dialogDataModel, boolean bl) {
        if (bl) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/ESTBF"));
        Boolean bl2 = dialogDataModel.containsBooleanKey("IDS_INDEPT_FACTOR_ROUDER") ? dialogDataModel.getBoolean("IDS_INDEPT_FACTOR_ROUDER") : true;
        Boolean bl3 = dialogDataModel.containsBooleanKey("IDS_INDEPT_FACTOR_GONEN") ? dialogDataModel.getBoolean("IDS_INDEPT_FACTOR_GONEN") : false;
        String string = dialogDataModel.getString("IDS_INDEPT_FACTOR_MEAN");
        String string2 = dialogDataModel.getString("IDS_INDEPT_FACTOR_VARIANCE");
        String string3 = dialogDataModel.getString("IDS_INDEPT_FACTOR_SHAPE");
        stringBuffer.append(" COMPUTATION=");
        if (bl2.booleanValue()) {
            stringBuffer.append("ROUDER");
        } else if (bl3.booleanValue()) {
            stringBuffer.append("GONEN(");
            stringBuffer.append(string != null && string.length() > 0 ? string : "0");
            if (string2 != null && string2.length() > 0) {
                stringBuffer.append(" ").append(string2);
            }
            stringBuffer.append(")");
        } else {
            stringBuffer.append("HYPER(");
            stringBuffer.append(string3 != null && string3.length() > 0 ? string3 : "-0.75");
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private void setDefaults() {
        this.mRouderRadio.setSelected(true);
        this.mGonenRadio.setSelected(false);
        this.onGonenMethod(false);
        this.onHyperMethod(false);
        this.mMeanField.setText("0");
        this.mVarianceField.setText("");
        this.mShapeParamField.setText("-0.75");
        this.mRouderRadio.setEnabled(!this.mIsDistRadioSelected);
        this.mGonenRadio.setEnabled(!this.mIsDistRadioSelected);
        this.mHyperRadio.setEnabled(!this.mIsDistRadioSelected);
    }

    private void setupPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = (Insets)insets.clone();
        insets2.left += 20;
        gridBagConstraints.fill = 2;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mRouderRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mGonenRadio, gridBagConstraints, 0, 1, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mMeanLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMeanField, gridBagConstraints, 1, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mVarianceLabel, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mVarianceField, gridBagConstraints, 1, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mHyperRadio, gridBagConstraints, 0, 4, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mShapeParamLabel, gridBagConstraints, 0, 5, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mShapeParamField, gridBagConstraints, 1, 5, 1, 1, n, insets);
    }

    private void onGonenMethod(boolean bl) {
        this.mMeanLabel.setEnabled(bl);
        this.mMeanField.setEnabled(bl);
        this.mVarianceLabel.setEnabled(bl);
        this.mVarianceField.setEnabled(bl);
    }

    private void onHyperMethod(boolean bl) {
        this.mShapeParamLabel.setEnabled(bl);
        this.mShapeParamField.setEnabled(bl);
    }

    private boolean canEnableContinue() {
        boolean bl = true;
        if (this.mGonenRadio.isSelected()) {
            bl = this.mVarianceField.getText().length() > 0;
        }
        return bl;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mEstimatingGroup);
        vector.add(this.mMeanField);
        vector.add(this.mVarianceField);
        vector.add(this.mShapeParamField);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }
}

