/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.CoreFrequencies;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BULRBayesFactorSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BULRCriteriaSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BULRFTestsSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BULRPlotsSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BULRPredictSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BULRPriorsSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BULRSaveSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.ScanBaseDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class BULRStatsDlg
extends ScanBaseDlg
implements ListDataListener {
    static final String BURL_DEP_VAR_LIST = "IDS_BULR_DEP_VAR_LIST";
    static final String BULR_FACTOR_LIST = "IDS_BULR_FACTOR_LIST";
    static final String BULR_COVARIATE_LIST = "IDS_BULR_COVARIATE_LIST";
    static final String BULR_WEIGHT_LIST = "IDS_BULR_WEIGHT_LIST";
    private ArrowButton mDepVarListArrow;
    private ArrowButton mFactorListArrow;
    private ArrowButton mCovarListArrow;
    private ArrowButton mWeightVarListArrow;
    private TargetVariableList mDepVarList;
    private TargetVariableList mFactorList;
    private TargetVariableList mCovarList;
    private TargetVariableList mWeightVarList;

    public BULRStatsDlg(JFrame jFrame) {
        super(jFrame);
        this.setTitle(this.getResString("IDS_BULR_TITLE"));
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    public ArrayList<ISpssVariable> getSrcVariables() {
        return this.mSrcVarList.getAllVariables();
    }

    @Override
    public String generateSyntax() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("BAYES")).append(" REGRESSION ");
        stringBuffer.append(this.mDepVarList.getVariablesStringList());
        String string = BULRBayesFactorSubDlg.getAdditonalFactorsOrCovSyntax(dialogDataModel, this.mFactorList.getModel(), this.mDistributionRadio.isSelected(), true);
        String string2 = this.mFactorList.getVariablesStringList() + (string.length() > 0 ? " " + string : "");
        if (string2.length() > 0) {
            stringBuffer.append(" BY ");
            stringBuffer.append(string2);
        }
        String string3 = BULRBayesFactorSubDlg.getAdditonalFactorsOrCovSyntax(dialogDataModel, this.mCovarList.getModel(), this.mDistributionRadio.isSelected(), false);
        String string4 = this.mCovarList.getVariablesStringList() + (string3.length() > 0 ? " " + string3 : "");
        if (string4.length() > 0) {
            stringBuffer.append(" WITH ");
            stringBuffer.append(string4);
        }
        stringBuffer.append("\n");
        this.addBayesianBodySyntax(stringBuffer, dialogDataModel);
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    public static String getSyntaxVarString(ISpssVariable[] iSpssVariableArray) {
        String string = "";
        for (ISpssVariable iSpssVariable : iSpssVariableArray) {
            if (iSpssVariable == null) continue;
            string = string + iSpssVariable.getName() + " ";
        }
        return string;
    }

    protected void addBayesianBodySyntax(StringBuffer stringBuffer, DialogDataModel dialogDataModel) {
        stringBuffer.append(BULRCriteriaSubDlg.getCriteriaDlgSyntax(dialogDataModel, this.mDistributionRadio.isSelected()));
        String string = this.mFactorList.getVariablesStringList();
        String string2 = this.mCovarList.getVariablesStringList();
        String string3 = this.mWeightVarList.getVariablesStringList();
        if (string.length() > 0 || string2.length() > 0 || string3.length() > 0) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/DESIGN"));
            if (string.length() > 0) {
                stringBuffer.append(" FACTORS=").append(string);
            }
            if (string2.length() > 0) {
                stringBuffer.append(" COVARIATES=").append(string2);
            }
            if (string3.length() > 0) {
                stringBuffer.append(" REGWGT=").append(string3);
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append(SyntaxUtil.getSubCommand("/INFERENCE"));
        String string4 = "";
        Boolean bl = dialogDataModel.getBoolean("IDS_BAYES_FACTOR");
        Boolean bl2 = dialogDataModel.getBoolean("IDS_USE_BOTH");
        string4 = bl != null && bl != false ? "BAYESFACTOR" : (bl2 != null && bl2 != false ? "BOTH" : "POSTERIOR");
        stringBuffer.append(" ANALYSIS=").append(string4);
        stringBuffer.append(BULRPriorsSubDlg.getPriorsDlgSyntax(dialogDataModel, this.mBayesFactorRadio.isSelected()));
        stringBuffer.append(BULRBayesFactorSubDlg.getByesFactorSyntax(dialogDataModel, this.mDistributionRadio.isSelected()));
        stringBuffer.append(BULRSaveSubDlg.getSaveDlgSyntax(dialogDataModel));
        stringBuffer.append(BULRPredictSubDlg.getPredictDlgSyntax(dialogDataModel, this.mFactorList.getModel(), this.mCovarList.getModel()));
        stringBuffer.append(BULRPlotsSubDlg.getPlotsSyntax(dialogDataModel, this.mBayesFactorRadio.isSelected(), this.mFactorList.getModel(), this.mCovarList.getModel()));
        stringBuffer.append(BULRFTestsSubDlg.getFTestsSyntax(dialogDataModel, this.mBayesFactorRadio.isSelected(), this.mFactorList.getModel(), this.mCovarList.getModel()));
    }

    @Override
    public String getIActionKey() {
        return "analyze_bayesian_univariate_regression";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_linear";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mDepVarList.getModel().getSize() > 0 && (this.mFactorList.getModel().getSize() > 0 || this.mCovarList.getModel().getSize() > 0));
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mDepVarList.getModel().getSize() > 0 && (this.mFactorList.getModel().getSize() > 0 || this.mCovarList.getModel().getSize() > 0));
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    protected void setDefaults() {
        super.setDefaults();
        this.mDepVarList.removeAll();
        this.mFactorList.removeAll();
        this.mCovarList.removeAll();
        this.mWeightVarList.removeAll();
        this.enableOkPaste(false);
    }

    @Override
    protected void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.setIdentifier("IDS_BULR_SRC_VAR_LIST");
        this.mDistributionRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_DISTRIBUTION"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BULRStatsDlg.this.onAnalysisRadio();
            }
        });
        this.mBayesFactorRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_BAYES_FACTOR"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BULRStatsDlg.this.onAnalysisRadio();
            }
        });
        this.mUseBothRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_USE_BOTH"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BULRStatsDlg.this.onAnalysisRadio();
            }
        });
        this.mAnalysisGroup = new SpssButtonGroup();
        this.mAnalysisGroup.add(this.mDistributionRadio);
        this.mAnalysisGroup.add(this.mBayesFactorRadio);
        this.mAnalysisGroup.add(this.mUseBothRadio);
        this.mDepVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mDepVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mDepVarList.getModel().addListDataListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.mDepVarList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setPreferredSize(this.mDepVarList.getMinimumSize());
        this.mDepVarList.setIdentifier(BURL_DEP_VAR_LIST);
        this.mDepVarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mFactorList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mFactorList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mFactorList.getModel().addListDataListener(this);
        this.mFactorList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mFactorList.getFixedCellHeight() * 2 + 2));
        JScrollPane jScrollPane2 = new JScrollPane(this.mFactorList);
        jScrollPane2.setPreferredSize(this.mFactorList.getMinimumSize());
        this.mFactorList.setIdentifier(BULR_FACTOR_LIST);
        this.mFactorList.addVarFilter(new SpssVarFilter(4, true, false));
        this.mCovarList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mCovarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mCovarList.getModel().addListDataListener(this);
        this.mCovarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mCovarList.getFixedCellHeight() * 2 + 2));
        JScrollPane jScrollPane3 = new JScrollPane(this.mCovarList);
        jScrollPane3.setPreferredSize(this.mCovarList.getMinimumSize());
        this.mCovarList.setIdentifier(BULR_COVARIATE_LIST);
        this.mCovarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mWeightVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mWeightVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        JScrollPane jScrollPane4 = new JScrollPane(this.mWeightVarList);
        jScrollPane4.setHorizontalScrollBarPolicy(31);
        jScrollPane4.setVerticalScrollBarPolicy(21);
        jScrollPane4.setPreferredSize(this.mWeightVarList.getMinimumSize());
        this.mWeightVarList.setIdentifier(BULR_WEIGHT_LIST);
        this.mWeightVarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mDepVarListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mDepVarListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mDepVarListArrow.registerVariableList(this.mDepVarList, SpssArrowButton.ButtonOrientation.left);
        this.mFactorListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mFactorListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mFactorListArrow.registerVariableList(this.mFactorList, SpssArrowButton.ButtonOrientation.left);
        this.mCovarListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCovarListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mCovarListArrow.registerVariableList(this.mCovarList, SpssArrowButton.ButtonOrientation.left);
        this.mWeightVarListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mWeightVarListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mWeightVarListArrow.registerVariableList(this.mWeightVarList, SpssArrowButton.ButtonOrientation.left);
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void setupPanel(JPanel jPanel) {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_BULR_DEPENDENT_VARIABLE");
        jLabel.setLabelFor(this.mDepVarList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_BULR_FACTOR");
        jLabel2.setLabelFor(this.mFactorList);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_BULR_COVARIATE");
        jLabel3.setLabelFor(this.mCovarList);
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_BULR_WEIGHT");
        jLabel4.setLabelFor(this.mWeightVarList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 18;
        JLabel jLabel5 = DialogUtil.createLabel(this, "IDS_BAYESIAN_SOURCE_LABEL");
        jLabel5.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel5, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(new Dimension(170, 340));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 9, n, insets);
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets3 = new Insets(0, insets2.left, 0, insets2.right);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mDepVarListArrow, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.5;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        JScrollPane jScrollPane2 = new JScrollPane(this.mDepVarList);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setVerticalScrollBarPolicy(21);
        jScrollPane2.setPreferredSize(this.mDepVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 1, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mFactorListArrow, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.5;
        n = 23;
        gridBagConstraints.fill = 2;
        Insets insets4 = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 2, 1, 1, n, insets4);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.weightx = 0.5;
        JScrollPane jScrollPane3 = new JScrollPane(this.mFactorList);
        jScrollPane3.setPreferredSize(this.mFactorList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane3, gridBagConstraints, 2, 3, 1, 1, n, insets);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mCovarListArrow, gridBagConstraints, 1, 5, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 4, 1, 1, n, insets4);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        JScrollPane jScrollPane4 = new JScrollPane(this.mCovarList);
        jScrollPane4.setPreferredSize(this.mCovarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane4, gridBagConstraints, 2, 5, 1, 1, n, insets);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mWeightVarListArrow, gridBagConstraints, 1, 7, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.5;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 2, 6, 1, 1, n, insets);
        JScrollPane jScrollPane5 = new JScrollPane(this.mWeightVarList);
        jScrollPane5.setHorizontalScrollBarPolicy(31);
        jScrollPane5.setVerticalScrollBarPolicy(21);
        jScrollPane5.setPreferredSize(this.mDepVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane5, gridBagConstraints, 2, 7, 1, 1, n, null);
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = this.createAnalysisPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 2, 8, 1, 1, n, insets);
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = this.createSideButtonPanel(true);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_BULR_SAVE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BULRStatsDlg.this.onSaveButton();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_BULR_PREDICT_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BULRStatsDlg.this.onPredictButton();
            }
        };
        JButton jButton2 = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_BULR_PLOTS_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BULRStatsDlg.this.onPlotsButton();
            }
        };
        JButton jButton3 = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_BULR_FTESTS_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BULRStatsDlg.this.onFTestsButton();
            }
        };
        JButton jButton4 = new JButton(toggleButtonAction);
        Insets insets = DialogUtil.getStandardButtonInsets();
        int n = insets.top + insets.bottom;
        jPanel.add(Box.createVerticalStrut(n));
        jPanel.add(jButton);
        jPanel.add(Box.createVerticalStrut(n));
        jPanel.add(jButton2);
        jPanel.add(Box.createVerticalStrut(n));
        jPanel.add(jButton3);
        jPanel.add(Box.createVerticalStrut(n));
        jPanel.add(jButton4);
        return jPanel;
    }

    @Override
    protected void onCriteriaButton() {
        this.runSubDialog(new BULRCriteriaSubDlg(this, this.getResString("IDS_BULR_CRITERIA_TITLE"), this.mDistributionRadio.isSelected()));
    }

    @Override
    protected ArrayList<ISpssVariable> getScanVariables() {
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        for (int i = 0; i < this.mFactorList.getModel().getSize(); ++i) {
            arrayList.add(this.mFactorList.getModel().getElementAt(i));
        }
        return arrayList;
    }

    @Override
    protected void onPriorsButton() {
        this.mScanVariables = this.getScanVariables();
        if (this.mScanVariables.size() == 0 || !this.needScanning(this.mFactorList.getModel(), null)) {
            new BULRPriorsSubDlg(this, this.getResString("IDS_BULR_PRIORS_TITLE"), this.mBayesFactorRadio.isSelected(), this.mFactorList.getModel(), this.mCovarList.getModel(), false);
            return;
        }
        this.performScanning(this);
        do {
            System.out.println("Proceeding Scanning......");
        } while (!this.mScanFinished);
        System.out.println("mScanFinished - 1");
        new BULRPriorsSubDlg(this, this.getResString("IDS_BULR_PRIORS_TITLE"), this.mBayesFactorRadio.isSelected(), this.mFactorList.getModel(), this.mCovarList.getModel(), false);
        this.mScanFinished = false;
    }

    @Override
    protected void onBayesFactorButton() {
        new BULRBayesFactorSubDlg(this, this.getResString("IDS_BULR_BF_TITLE"), this.mDistributionRadio.isSelected());
    }

    protected void onSaveButton() {
        new BULRSaveSubDlg(this, this.getResString("IDS_BULR_SAVE_TITLE"));
    }

    protected void onPredictButton() {
        new BULRPredictSubDlg(this, this.getResString("IDS_BULR_PREDICT_TITLE"), this.mFactorList.getModel(), this.mCovarList.getModel());
    }

    protected void onPlotsButton() {
        new BULRPlotsSubDlg((BaseProcedureDialog)this, this.getResString("IDS_BULR_PLOTS_TITLE"), this.mBayesFactorRadio.isSelected(), this.mFactorList.getModel(), this.mCovarList.getModel());
    }

    protected void onFTestsButton() {
        this.mScanVariables = this.getScanVariables();
        if (this.mScanVariables.size() == 0 || !this.needScanning(this.mFactorList.getModel(), null)) {
            new BULRFTestsSubDlg((BaseProcedureDialog)this, this.getResString("IDS_BULR_FTESTS_TITLE"), this.mFactorList.getModel(), this.mCovarList.getModel(), this.mBayesFactorRadio.isSelected());
            return;
        }
        this.performScanning(this);
        do {
            System.out.println("Proceeding Scanning......");
        } while (!this.mScanFinished);
        System.out.println("mScanFinished - 1");
        new BULRFTestsSubDlg((BaseProcedureDialog)this, this.getResString("IDS_BULR_FTESTS_TITLE"), this.mFactorList.getModel(), this.mCovarList.getModel(), this.mBayesFactorRadio.isSelected());
        this.mScanFinished = false;
    }

    @Override
    public void finishedScanning(CoreFrequencies coreFrequencies) {
        super.finishedScanning(coreFrequencies);
        this.mScanFinished = true;
    }

    @Override
    protected boolean okPastePressed() {
        Object object;
        ISpssVariable[] iSpssVariableArray2;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Vector vector = (Vector)dialogDataModel.getObject("IDS_BULR_SAVE_TABLE_DATA_KEY");
        if (vector != null) {
            for (ISpssVariable[] iSpssVariableArray2 : vector) {
                if (!iSpssVariableArray2.getSave() || ((String)(object = iSpssVariableArray2.getVariableName())).length() <= 0 || !BULRSaveSubDlg.existsInDataset((String)object)) continue;
                String string = MessageFormat.format(this.getResString("ERR_BULR_SAVE_EXIST_VALUE_MSG"), object);
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
                return false;
            }
        }
        Boolean bl = !this.mBayesFactorRadio.isSelected() && dialogDataModel.containsBooleanKey("IDS_BULR_PRIORS_CONJUGATE") ? dialogDataModel.getBoolean("IDS_BULR_PRIORS_CONJUGATE") : false;
        iSpssVariableArray2 = dialogDataModel.getVarArray("IDS_PRIORS_FACTOR_MODEL_KEY");
        object = dialogDataModel.getVarArray("IDS_PRIORS_COV_MODEL_KEY");
        this.checkPlotsForRemoval(BULRPlotsSubDlg.BULR_PLOTS_FACTOR_TARGET_LIST_KEY, this.mFactorList.getModel());
        this.checkPlotsForRemoval(BULRPlotsSubDlg.BULR_PLOTS_COV_TARGET_LIST_KEY, this.mCovarList.getModel());
        if (bl.booleanValue() && (this.isScanVarModelChanged(iSpssVariableArray2, this.mFactorList.getModel()) || this.isScanVarModelChanged((ISpssVariable[])object, this.mCovarList.getModel()))) {
            JOptionPane.showMessageDialog((Component)((Object)this), this.getResString("ERR_MSG_PRIOR_DETECT_CHANGE"), VersionInfo.getAppVersionString(), 1);
            dialogDataModel.putBoolean("IDS_BULR_PRIORS_CONJUGATE", false);
            dialogDataModel.putObject("IDS_PRIORS_MEAN_TABLE_VECTOR", null);
            dialogDataModel.putObject("IDS_PRIORS_VCM_TABLE_VECTOR", null);
        }
        return super.okPastePressed();
    }

    private void checkPlotsForRemoval(String string, VarListModel varListModel) {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray(string);
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        for (ISpssVariable iSpssVariable : iSpssVariableArray) {
            boolean bl = false;
            for (int i = 0; i < varListModel.getSize(); ++i) {
                if (!iSpssVariable.getName().equals(varListModel.getElementAt(i).getName())) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            arrayList.add(iSpssVariable);
        }
        dialogDataModel.putVarArray(string, arrayList.toArray(new ISpssVariable[arrayList.size()]));
    }

    @Override
    protected void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mDepVarListArrow);
        vector.add(this.mDepVarList);
        vector.add(this.mFactorListArrow);
        vector.add(this.mFactorList);
        vector.add(this.mCovarListArrow);
        vector.add(this.mCovarList);
        vector.add(this.mWeightVarListArrow);
        vector.add(this.mWeightVarList);
        vector.add(this.mAnalysisGroup);
        int n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }

    public static ISpssVariable[] refreshTargetVars(ISpssVariable[] iSpssVariableArray, VarListModel varListModel, VarListModel varListModel2) {
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        for (int i = iSpssVariableArray.length - 1; i >= 0; --i) {
            int n;
            boolean bl = false;
            for (n = 0; n < varListModel.getSize(); ++n) {
                if (!iSpssVariableArray[i].getName().equals(varListModel.getElementAt(n).getName())) continue;
                bl = true;
                break;
            }
            if (!bl && varListModel2 != null) {
                for (n = 0; n < varListModel2.getSize(); ++n) {
                    if (!iSpssVariableArray[i].getName().equals(varListModel2.getElementAt(n).getName())) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) continue;
            arrayList.add(iSpssVariableArray[i]);
        }
        return arrayList.toArray(new ISpssVariable[arrayList.size()]);
    }
}

