/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BayesianBaseDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.FileValidator;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.util.CharacterUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.font.TextAttribute;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;

public class BULRSaveSubDlg
extends BaseSubDialog {
    private static final String[] SAVE_TABLE_SYNTAX = new String[]{"MEANPRED", "VARIANCE", "MODE", "CIMEANPREDL", "CIMEANPREDU"};
    private static final String BULR_SAVE_TABLE_DATA_KEY = "IDS_BULR_SAVE_TABLE_DATA_KEY";
    private PlainTable mSaveTable;
    private SaveTableModel mSaveTableModel;
    private JLabel mSaveTableLabel;
    private JLabel mFileTextLabel;
    private FileTextField mXmlFileTextField;
    private JButton mBrowseButton;
    private Vector<SaveTableItem> mSaveTableDataVector;

    public BULRSaveSubDlg(BaseProcedureDialog baseProcedureDialog, String string) {
        super(baseProcedureDialog, string, true);
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_linear_save";
    }

    public static String getSaveDlgSyntax(DialogDataModel dialogDataModel) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = (Vector)dialogDataModel.getObject(BULR_SAVE_TABLE_DATA_KEY);
        String string = BULRSaveSubDlg.getSaveTableSyntax(vector);
        String string2 = dialogDataModel.getString("EXPORT_XML_FILE_PATH");
        boolean bl2 = bl = string.length() > 0;
        if (bl) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/SAVE"));
            stringBuffer.append(string);
        }
        if (bl && string2 != null && string2.length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/OUTFILE"));
            stringBuffer.append(" PARAMETER=").append(CharacterUtil.smartQuote((String)string2));
        }
        return stringBuffer.toString();
    }

    public static String getSaveTableSyntax(Vector<SaveTableItem> vector) {
        if (vector == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            SaveTableItem saveTableItem = vector.get(i);
            if (!saveTableItem.getSave()) continue;
            stringBuffer.append(" ").append(SAVE_TABLE_SYNTAX[i]);
            String string = saveTableItem.getVariableName();
            if (string.length() <= 0) continue;
            stringBuffer.append("(").append(string).append(")");
        }
        return stringBuffer.toString();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.setDefaults();
        this.pack();
        this.setFocusTraversalPolicy();
    }

    protected void initVars() {
        this.initTable();
        this.mSaveTableLabel = DialogUtil.createLabel(this, "IDS_BULR_SAVE_STATS_TABLE_LABEL");
        this.mSaveTableLabel.setLabelFor(this.mSaveTable);
        this.mFileTextLabel = DialogUtil.createLabel(this, "IDS_BULR_SAVE_FILE_LABEL");
        this.mXmlFileTextField = new FileTextField();
        this.mFileTextLabel.setLabelFor((Component)((Object)this.mXmlFileTextField));
        this.mXmlFileTextField.setColumns(20);
        this.mXmlFileTextField.setAction(new TextFieldAction(this, "EXPORT_XML_FILE_PATH"));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_BROWSE_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Data, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
                remoteFileChooser.setDialogTitle(BULRSaveSubDlg.this.getResString("IDS_COX_REG_SAVE_EXPORT_DIALOG_TITLE"));
                remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(BULRSaveSubDlg.this.getResString("IDS_BULR_SAVE_EXPORT_XML_FILE_FILTER"), BULRSaveSubDlg.this.getResString("IDS_BULR_SAVE_EXPORT_XML_FILE_EXTENSION")));
                remoteFileChooser.setAcceptAllFileFilterUsed(false);
                remoteFileChooser.setFileSelectionMode(0);
                int n = remoteFileChooser.showSaveDialog((Component)((Object)BULRSaveSubDlg.this));
                if (n == 0) {
                    FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                    BULRSaveSubDlg.this.mXmlFileTextField.setText(remoteFileChooser.getSelectedFilePath());
                    BULRSaveSubDlg.this.mXmlFileTextField.setCaretPosition(0);
                }
            }
        };
        this.mBrowseButton = new JButton(toggleButtonAction);
    }

    private void initTable() {
        this.mSaveTable = new PlainTable(){

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                boolean bl = super.editCellAt(n, n2, eventObject);
                final Component component = this.getEditorComponent();
                if (component != null && component instanceof JTextComponent) {
                    if (ComponentState.isBtdRtlOrLtr() && n2 == 2 && ((JTextComponent)component).getDocument() != null) {
                        if (ComponentState.getBTD() == 1) {
                            ((JTextComponent)component).getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                        } else {
                            ((JTextComponent)component).getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                        }
                    }
                    if (eventObject == null) {
                        ((JTextComponent)component).selectAll();
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((JTextComponent)component).selectAll();
                            }
                        });
                    }
                }
                return bl;
            }
        };
        this.mSaveTableModel = this.getSaveTableModel();
        this.mSaveTableModel.mColumnNames[0] = this.getResString("IDS_BULR_STATIS_COLUMN0_NAME");
        this.mSaveTableModel.mColumnNames[1] = this.getResString("IDS_BULR_STATIS_COLUMN1_NAME");
        this.mSaveTableModel.mColumnNames[2] = this.getResString("IDS_BULR_STATIS_COLUMN2_NAME");
        this.mSaveTable.setModel(this.mSaveTableModel);
        this.mSaveTable.setRowHeight(this.mSaveTable.getRowHeight() + 4);
        this.mSaveTable.setColumnSelectionAllowed(true);
        this.mSaveTable.setSelectionMode(0);
        this.mSaveTable.setRowSelectionAllowed(true);
        this.mSaveTable.setCellSelectionEnabled(true);
        this.mSaveTable.setAutoResizeMode(0);
        this.mSaveTable.setDefaultRenderer(Object.class, new SaveTableRenderer());
        JTableHeader jTableHeader = this.mSaveTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setDefaultRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = null;
                jLabel = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? (JLabel)super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (n2 == 0) {
                    jLabel.setHorizontalAlignment(0);
                } else {
                    jLabel.setHorizontalAlignment(2);
                }
                jLabel.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                jLabel.setBackground(jTable.getTableHeader().getBackground());
                jLabel.setForeground(jTable.getTableHeader().getForeground());
                return jLabel;
            }
        });
        TableColumnModel tableColumnModel = this.mSaveTable.getColumnModel();
        tableColumnModel.getColumn(0).setCellRenderer(new CheckBoxRenderer());
        tableColumnModel.getColumn(1).setPreferredWidth(190);
        tableColumnModel.getColumn(1).setMinWidth(60);
        tableColumnModel.getColumn(2).setCellEditor(new BayesianBaseDlg.BaseValueCellEditor(new StringTextField()));
        tableColumnModel.getColumn(2).setPreferredWidth(200);
        tableColumnModel.getColumn(2).setMinWidth(100);
    }

    @Override
    public boolean continuePressed() {
        boolean bl = true;
        if (!this.isValidate()) {
            return false;
        }
        if (!(CommandLine.isClementineCaller() && RemoteFileChooser.getFileBrowseCallback() == null || (bl = FileValidator.validatePath((Component)((Object)this), this.mXmlFileTextField.getText(), true, DataServerProxy.getDataProxy().isRemoteConnection())))) {
            this.mXmlFileTextField.requestFocus();
        }
        return bl;
    }

    private void setDefaults() {
        this.onTableSave();
        this.mXmlFileTextField.setText("");
        if (this.mSaveTableDataVector != null) {
            this.mSaveTableDataVector.clear();
        }
    }

    private void onTableSave() {
        boolean bl = this.mSaveTableModel.hasRowSaved();
        this.mFileTextLabel.setEnabled(bl);
        this.mXmlFileTextField.setEnabled(bl);
        this.mBrowseButton.setEnabled(bl);
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        this.mSaveTableDataVector = (Vector)dialogDataModel.getObject(BULR_SAVE_TABLE_DATA_KEY);
        super.loadState(dialogDataModel);
        this.reloadTable(this.mSaveTable, this.mSaveTableDataVector);
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        if (this.mSaveTable != null) {
            this.mSaveTableDataVector = ((SaveTableModel)this.mSaveTable.getModel()).getTableData();
            dialogDataModel.putObject(BULR_SAVE_TABLE_DATA_KEY, this.mSaveTableDataVector);
        }
        return super.saveState(dialogDataModel);
    }

    private void reloadTable(PlainTable plainTable, Vector<SaveTableItem> vector) {
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                SaveTableItem saveTableItem = vector.get(i);
                plainTable.setValueAt(saveTableItem.getSave(), i, 0);
                plainTable.setValueAt(saveTableItem.getItemToSave(), i, 1);
                plainTable.setValueAt(saveTableItem.getVariableName(), i, 2);
            }
        }
    }

    private void setupPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(0, 0, n, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n2 = 23;
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.mSaveTableLabel, "North");
        JScrollPane jScrollPane = new JScrollPane(this.mSaveTable);
        jScrollPane.setPreferredSize(new Dimension(480, 200));
        jPanel2.add((Component)jScrollPane, "Center");
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 2, 1, n2, insets2);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mFileTextLabel, gridBagConstraints, 0, 1, 2, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mXmlFileTextField), gridBagConstraints, 0, 2, 1, 1, n2, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 1, 2, 1, 1, n2, insets);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSaveTable);
        vector.add(this.mXmlFileTextField);
        vector.add(this.mBrowseButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private SaveTableModel getSaveTableModel() {
        Vector<SaveTableItem> vector = new Vector<SaveTableItem>();
        SaveTableItem saveTableItem = new SaveTableItem(false, this.getResString("IDS_BULR_SAVE_MEANS"), "");
        vector.addElement(saveTableItem);
        saveTableItem = new SaveTableItem(false, this.getResString("IDS_BULR_SAVE_VARIANCES"), "");
        vector.addElement(saveTableItem);
        saveTableItem = new SaveTableItem(false, this.getResString("IDS_BULR_SAVE_MODES"), "");
        vector.addElement(saveTableItem);
        saveTableItem = new SaveTableItem(false, this.getResString("IDS_BULR_SAVE_LOWER_LIMITS"), "");
        vector.addElement(saveTableItem);
        saveTableItem = new SaveTableItem(false, this.getResString("IDS_BULR_SAVE_UPPER_LIMITS"), "");
        vector.addElement(saveTableItem);
        return new SaveTableModel(vector, this.mSaveTable);
    }

    static boolean existsInDataset(String string) {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        return iSpssDataSrc.findVarIndex(string) >= 0;
    }

    public boolean isValidate() {
        int n;
        Object object;
        boolean bl = true;
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        int n2 = -1;
        int n3 = -1;
        StringBuffer stringBuffer = new StringBuffer("");
        try {
            object = new Vector();
            for (n = 0; n < this.mSaveTable.getModel().getRowCount(); ++n) {
                SaveTableItem saveTableItem = (SaveTableItem)saveTableModel.getValue(n);
                if (!saveTableItem.getSave()) continue;
                for (int i = 0; i < this.mSaveTable.getModel().getColumnCount(); ++i) {
                    String string;
                    if (i != 2) continue;
                    TableCellEditor tableCellEditor = this.mSaveTable.getCellEditor();
                    if (tableCellEditor != null) {
                        tableCellEditor.stopCellEditing();
                        this.mSaveTable.getSelectionModel().clearSelection();
                    }
                    if ((string = this.mSaveTable.getModel().getValueAt(n, i).toString()).length() == 0) continue;
                    if (!this.isLegalValue(string)) {
                        this.changeSelection(n, i);
                        return false;
                    }
                    ((Vector)object).add(string);
                    if (this.isDuplicateValue((Vector<String>)object)) {
                        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_BULR_SAVE_DUPLICATE_VALUE_MSG"), VersionInfo.getAppVersionString());
                        this.changeSelection(n, i);
                        return false;
                    }
                    if (!BULRSaveSubDlg.existsInDataset(string)) continue;
                    String string2 = MessageFormat.format(this.getResString("ERR_BULR_SAVE_EXIST_VALUE_MSG"), string);
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string2, VersionInfo.getAppVersionString());
                    this.changeSelection(n, i);
                    return false;
                }
            }
        }
        catch (Exception exception) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_GLM_SAVE_VALID_VALUE_MSG"), VersionInfo.getAppVersionString());
            bl = false;
        }
        if (stringBuffer.toString().length() > 0) {
            object = this.getResString("ERR_GLM_SAVE_EXISTING_VAR_NAME_MSG");
            n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), (String)(object = String.format((String)object, stringBuffer.toString())), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION);
            if (n == 1) {
                return true;
            }
            this.changeSelection(n2, n3);
            return false;
        }
        return bl;
    }

    private void changeSelection(final int n, final int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BULRSaveSubDlg.this.mSaveTable.changeSelection(n, n2, false, false);
                BULRSaveSubDlg.this.mSaveTable.editCellAt(n, n2, null);
                BULRSaveSubDlg.this.mSaveTable.requestFocusInWindow();
            }
        });
    }

    private boolean isLegalValue(String string) {
        boolean bl;
        int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
        if (n > 0 && n != 100) {
            DialogUtil.showBadSpssVarNameWarning(n, this);
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private boolean isDuplicateValue(Vector<String> vector) {
        Object[] objectArray = vector.toArray();
        for (int i = 0; i <= vector.toArray().length - 1; ++i) {
            for (int j = i + 1; j <= vector.toArray().length - 1; ++j) {
                if (!objectArray[i].toString().equals(objectArray[j].toString())) continue;
                return true;
            }
        }
        return false;
    }

    class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        Border mEmptyBorder = BorderFactory.createEmptyBorder();
        Border mHighLightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");

        public CheckBoxRenderer() {
            this.setBorder(null);
            this.setLayout(new FlowLayout(1, 0, 0));
            this.setBorder(this.mHighLightBorder);
            this.setBorderPainted(true);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setHorizontalAlignment(0);
            if (bl2) {
                this.setBorder(this.mHighLightBorder);
            } else {
                this.setBorder(this.mEmptyBorder);
            }
            this.setSelected(object != null && (Boolean)object != false);
            boolean bl3 = jTable.isCellEditable(n, n2);
            this.setEnabled(bl3);
            return this;
        }
    }

    class SaveTableRenderer
    extends DefaultTableCellRenderer {
        boolean mSave;
        Border mEmptyBorder = BorderFactory.createEmptyBorder();
        Border mHighLightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");

        SaveTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = null;
            component = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            SaveTableModel saveTableModel = (SaveTableModel)jTable.getModel();
            if (n2 == 1) {
                component.setForeground(Color.black);
                if (component.hasFocus() && component instanceof JLabel) {
                    ((JLabel)component).setBorder(this.mHighLightBorder);
                }
            } else if (n2 == 2) {
                Object object2 = jTable.getValueAt(n, 0);
                if (object2 instanceof Boolean) {
                    this.mSave = (Boolean)object2;
                }
                if (this.mSave) {
                    component.setForeground(Color.black);
                    if (component.hasFocus() && component instanceof JLabel) {
                        ((JLabel)component).setBorder(this.mHighLightBorder);
                    }
                } else {
                    component.setForeground(Color.gray);
                    if (component instanceof JLabel) {
                        ((JLabel)component).setBorder(this.mEmptyBorder);
                    }
                }
            } else {
                component.setForeground(Color.black);
            }
            if (bl) {
                if (component.hasFocus()) {
                    component.setBackground(jTable.getSelectionBackground());
                }
            } else {
                component.setBackground(jTable.getBackground());
            }
            return component;
        }
    }

    public static class SaveTableItem {
        boolean mSave = false;
        String mItemToSave = "";
        String mVariableName = "";

        public SaveTableItem() {
            this.mSave = false;
            this.mItemToSave = "";
            this.mVariableName = "";
        }

        public SaveTableItem(boolean bl, String string, String string2) {
            this.mSave = bl;
            this.mItemToSave = string;
            this.mVariableName = string2;
        }

        public boolean getSave() {
            return this.mSave;
        }

        public void setSave(boolean bl) {
            this.mSave = bl;
        }

        public String getItemToSave() {
            return this.mItemToSave;
        }

        public void setItemToSave(String string) {
            this.mItemToSave = string;
        }

        public String getVariableName() {
            return this.mVariableName;
        }

        public void setVariableName(String string) {
            this.mVariableName = string;
        }
    }

    private class SaveTableModel
    extends AbstractTableModel {
        public String[] mColumnNames = new String[3];
        private Vector<SaveTableItem> mData;
        private JTable mTable;

        public SaveTableModel(Vector<SaveTableItem> vector, JTable jTable) {
            this.mData = vector;
            this.mTable = jTable;
        }

        @Override
        public int getRowCount() {
            return 5;
        }

        public int getSize() {
            return this.mData.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        public Object getValue(int n) {
            if (n < 0 || n >= this.getSize()) {
                return null;
            }
            return this.mData.get(n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            SaveTableItem saveTableItem = this.mData.get(n);
            switch (n2) {
                case 0: {
                    return saveTableItem.getSave();
                }
                case 1: {
                    return saveTableItem.getItemToSave();
                }
                case 2: {
                    return saveTableItem.getVariableName();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            SaveTableItem saveTableItem = this.mData.get(n);
            if (n2 == 0) {
                Boolean bl = (Boolean)object;
                saveTableItem.setSave(bl);
                BULRSaveSubDlg.this.onTableSave();
                this.mTable.repaint();
            } else if (n2 == 2) {
                saveTableItem.setVariableName(object.toString());
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            SaveTableItem saveTableItem = this.mData.get(n);
            if (n2 == 0) {
                return true;
            }
            if (n2 == 2) {
                return saveTableItem.getSave();
            }
            return false;
        }

        @Override
        public String getColumnName(int n) {
            return this.mColumnNames[n];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(n);
        }

        public Vector<SaveTableItem> getTableData() {
            return this.mData;
        }

        public void setTableData(Vector<SaveTableItem> vector) {
            this.mData = vector;
        }

        boolean hasRowSaved() {
            boolean bl = false;
            for (SaveTableItem saveTableItem : this.mData) {
                if (!saveTableItem.getSave()) continue;
                bl = true;
                break;
            }
            return bl;
        }
    }
}

