/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BayesianBaseDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.ScanBaseDlg;
import com.spss.java_client.ui.dialogs.base.data.define_var_properties.ScannedVariable;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.SPSSTextField;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class BULRPriorsSubDlg
extends BaseSubDialog
implements ItemListener,
DocumentListener {
    private static final String FIRST_VAR = "INTERCEPT";
    private static final String PRIORS_SHAPE_PARAM = "IDS_INF_SHAPE_PARAM";
    private static final String PRIORS_SCALE_PARAM = "IDS_INF_SCALE_PARAM";
    public static final String PRIORS_FACTOR_VAR_ARRAY_KEY = "IDS_PRIORS_FACTOR_MODEL_KEY";
    public static final String PRIORS_COV_VAR_ARRAY_KEY = "IDS_PRIORS_COV_MODEL_KEY";
    private static final String PRIORS_MEAN_TABLE_VECTOR_KEY = "IDS_PRIORS_MEAN_TABLE_VECTOR";
    private static final String PRIORS_VCM_TABLE_VECTOR_KEY = "IDS_PRIORS_VCM_TABLE_VECTOR";
    private JRadioButton mReferenceRadio;
    private JRadioButton mConjugateRadio;
    private FocusableTextArea mConjugateInfoArea;
    private SpssButtonGroup mRCGroup;
    private JLabel mShapeParamLabel;
    private FloatTextField mShapeParamField;
    private JLabel mScaleParamLabel;
    private FloatTextField mScaleParamField;
    private boolean mIsBayesFactorSelected;
    private JLabel mMeanTableLabel;
    private JButton mMeanTableResetButton;
    private MeanTable mMeanTable;
    private JCheckBox mUseSICheck;
    private JLabel mVCMTableLabel;
    private JButton mVCMTableResetButton;
    private VCMTable mVCMTable;
    protected VarListModel mFactorsModel;
    protected VarListModel mCovModel;
    private Vector mMeanVector;
    private Vector mVCMVector;
    private ScanBaseDlg mScanBaseDlg;
    private boolean mIsFromAnova;
    private String mDialogHelpID;

    public BULRPriorsSubDlg(BaseProcedureDialog baseProcedureDialog, String string, boolean bl, VarListModel varListModel, VarListModel varListModel2, boolean bl2) {
        super(baseProcedureDialog, string, true);
        this.mIsBayesFactorSelected = bl;
        this.mFactorsModel = varListModel;
        this.mCovModel = varListModel2;
        this.mIsFromAnova = bl2;
        this.mScanBaseDlg = (ScanBaseDlg)this.mParentDlg;
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.addListeners();
        this.pack();
        this.setFocusTraversalPolicy();
        this.setDefaults();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
        this.setDialogHelpID("idh_bayesian_linear_priors");
    }

    public BULRPriorsSubDlg(BaseProcedureDialog baseProcedureDialog, String string, boolean bl, VarListModel varListModel, VarListModel varListModel2, boolean bl2, String string2) {
        super(baseProcedureDialog, string, true);
        this.mIsBayesFactorSelected = bl;
        this.mFactorsModel = varListModel;
        this.mCovModel = varListModel2;
        this.mIsFromAnova = bl2;
        this.mScanBaseDlg = (ScanBaseDlg)this.mParentDlg;
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.addListeners();
        this.pack();
        this.setFocusTraversalPolicy();
        this.setDefaults();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
        this.setDialogHelpID(string2);
    }

    @Override
    public String getDialogHelpID() {
        return this.mDialogHelpID;
    }

    public void setDialogHelpID(String string) {
        this.mDialogHelpID = string;
    }

    public static String getPriorsDlgSyntax(DialogDataModel dialogDataModel, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            return "";
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/PRIOR"));
        Boolean bl2 = dialogDataModel.containsBooleanKey("IDS_BULR_PRIORS_CONJUGATE") ? dialogDataModel.getBoolean("IDS_BULR_PRIORS_CONJUGATE") : false;
        stringBuffer.append(" TYPE=");
        stringBuffer.append(bl2 != false ? "CONJUGATE" : "REFERENCE");
        if (bl2.booleanValue()) {
            String string = dialogDataModel.getString(PRIORS_SHAPE_PARAM);
            String string2 = dialogDataModel.getString(PRIORS_SCALE_PARAM);
            stringBuffer.append(" SHAPEPARAM=");
            stringBuffer.append(string);
            stringBuffer.append(" SCALEPARAM=");
            stringBuffer.append(string2);
            stringBuffer.append(" MEANVECTOR=");
            stringBuffer.append(BULRPriorsSubDlg.getMeanTableSyntaxValues(dialogDataModel));
            stringBuffer.append(" VMATRIX=");
            stringBuffer.append(BULRPriorsSubDlg.getVCMTableSyntaxValues(dialogDataModel));
        }
        return stringBuffer.toString();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mRCGroup);
        vector.add(this.mConjugateInfoArea);
        vector.add(this.mShapeParamField);
        vector.add(this.mScaleParamField);
        vector.add(this.mMeanTable);
        vector.add(this.mMeanTableResetButton);
        vector.add(this.mUseSICheck);
        vector.add(this.mVCMTable);
        vector.add(this.mVCMTableResetButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setupPanel(JPanel jPanel) {
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_BULR_PRIORS_DIST_GROUP")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mReferenceRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mConjugateRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        Insets insets2 = (Insets)insets.clone();
        insets2.left += 20;
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        this.mConjugateInfoArea = new FocusableTextArea(this.getResString("IDS_BULR_PRIORS_CONJUGATE_INFO"), new ImageIcon(uRL));
        this.mConjugateInfoArea.setPreferredSize(new Dimension(400, 46));
        DialogUtil.addUsingGBL(jPanel2, this.mConjugateInfoArea, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel3 = this.createPriorsPanel();
        DialogUtil.addUsingGBL(jPanel2, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel4 = this.createRegressionParametersPanel();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel2, jPanel4, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets2);
    }

    protected void initVars() {
        this.mConjugateRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_BULR_PRIORS_CONJUGATE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BULRPriorsSubDlg.this.enableContinue(BULRPriorsSubDlg.this.canEnableContinue());
            }
        });
        this.mReferenceRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_BULR_PRIORS_REFERENCE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BULRPriorsSubDlg.this.enableContinue(BULRPriorsSubDlg.this.canEnableContinue());
            }
        });
        this.mRCGroup = new SpssButtonGroup();
        this.mRCGroup.add(this.mReferenceRadio);
        this.mRCGroup.add(this.mConjugateRadio);
        this.mShapeParamField = new FloatTextField(0.0, Double.NaN, 2, true);
        this.mShapeParamField.setIncludeMinRange(false);
        this.mShapeParamField.setIncludeMaxRange(false);
        this.mShapeParamField.setAction((Action)new TextFieldAction(this.mParentDlg, PRIORS_SHAPE_PARAM));
        this.mShapeParamField.setColumns(10);
        this.mScaleParamField = new FloatTextField(0.0, Double.NaN, 2, true);
        this.mScaleParamField.setIncludeMinRange(false);
        this.mScaleParamField.setIncludeMaxRange(false);
        this.mScaleParamField.setAction((Action)new TextFieldAction(this.mParentDlg, PRIORS_SCALE_PARAM));
        this.mScaleParamField.setColumns(10);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_BULR_PRIORS_RESET", "IDK_BULR_PRIORS_MEAN_RESET_KEY"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BULRPriorsSubDlg.this.onResetButton(true);
            }
        };
        this.mMeanTableResetButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_BULR_PRIORS_RESET", "IDK_BULR_PRIORS_VCM_RESET_KEY"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BULRPriorsSubDlg.this.onResetButton(false);
            }
        };
        this.mVCMTableResetButton = new JButton(toggleButtonAction);
        this.mUseSICheck = new JCheckBox(new ToggleButtonAction(this, "IDS_BULR_PRIORS_USE_SCALED_IDENTY"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BULRPriorsSubDlg.this.onUseSICheck(!BULRPriorsSubDlg.this.mUseSICheck.isSelected());
            }
        });
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        this.mMeanVector = (Vector)dialogDataModel.getObject(PRIORS_MEAN_TABLE_VECTOR_KEY);
        this.mVCMVector = (Vector)dialogDataModel.getObject(PRIORS_VCM_TABLE_VECTOR_KEY);
        if (this.mMeanVector != null && this.mMeanTable != null) {
            this.mMeanTable.reloadTable(this.mMeanVector);
        }
        if (this.mVCMVector != null && this.mVCMTable != null) {
            this.mVCMTable.reloadTable(this.mVCMVector);
        }
        this.onUseSICheck(this.mConjugateRadio.isSelected() && !this.mUseSICheck.isSelected());
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        dialogDataModel.putVarArray(PRIORS_FACTOR_VAR_ARRAY_KEY, BULRPriorsSubDlg.getVarArray(this.mFactorsModel));
        if (this.mCovModel != null) {
            dialogDataModel.putVarArray(PRIORS_COV_VAR_ARRAY_KEY, BULRPriorsSubDlg.getVarArray(this.mCovModel));
        }
        if (this.mMeanTable != null) {
            this.mMeanVector = ((DefaultTableModel)this.mMeanTable.getModel()).getDataVector();
            dialogDataModel.putObject(PRIORS_MEAN_TABLE_VECTOR_KEY, this.mMeanVector);
        }
        if (this.mVCMTable != null) {
            this.mVCMVector = ((DefaultTableModel)this.mVCMTable.getModel()).getDataVector();
            dialogDataModel.putObject(PRIORS_VCM_TABLE_VECTOR_KEY, this.mVCMVector);
        }
        return super.saveState(dialogDataModel);
    }

    @Override
    public boolean continuePressed() {
        return !(this.mMeanTable.isEnabled() && !this.mMeanTable.validateTable(false) || this.mVCMTable.isEnabled() && !this.mVCMTable.validateTable(false));
    }

    private void onResetButton(boolean bl) {
        if (bl) {
            for (int i = 0; i < this.mMeanTable.getRowCount(); ++i) {
                boolean bl2 = (Boolean)this.mMeanTable.getValueAt(i, 2);
                this.mMeanTable.setValueAt(this.mIsFromAnova || bl2 ? "" : "0", i, 1);
            }
        } else {
            this.resetVCMTable();
        }
    }

    public static ISpssVariable[] getVarArray(VarListModel varListModel) {
        ISpssVariable[] iSpssVariableArray = new ISpssVariable[varListModel.getSize()];
        for (int i = 0; i < varListModel.getSize(); ++i) {
            iSpssVariableArray[i] = varListModel.getElementAt(i);
        }
        return iSpssVariableArray;
    }

    private void resetVCMTable() {
        for (int i = 0; i < this.mVCMTable.getRowCount(); ++i) {
            for (int j = 1; j < this.mVCMTable.getColumnCount(); ++j) {
                if (i == j - 1) {
                    this.mVCMTable.setValueAt("1", i, j);
                    continue;
                }
                if (i <= j - 1) continue;
                this.mVCMTable.setValueAt("0", i, j);
            }
        }
    }

    private void onUseSICheck(boolean bl) {
        this.mVCMTable.setEnabled(bl);
    }

    private void addListeners() {
        this.mConjugateRadio.addItemListener(this);
        this.mReferenceRadio.addItemListener(this);
        this.mShapeParamField.getDocument().addDocumentListener(this);
        this.mScaleParamField.getDocument().addDocumentListener(this);
    }

    private void setDefaults() {
        this.mReferenceRadio.setSelected(true);
        this.mShapeParamField.setText("");
        this.mScaleParamField.setText("");
        this.mReferenceRadio.setEnabled(!this.mIsBayesFactorSelected);
        this.mConjugateRadio.setEnabled(!this.mIsBayesFactorSelected);
        this.mUseSICheck.setSelected(true);
        this.onConjugateRadio(false);
        this.mMeanVector = null;
        if (this.mVCMVector != null) {
            for (int i = 0; i < this.mVCMVector.size(); ++i) {
                Vector vector = (Vector)this.mVCMVector.get(i);
                for (int j = 1; j < vector.size(); ++j) {
                    if (i == j) {
                        vector.setElementAt("1", j);
                        continue;
                    }
                    if (i >= j) continue;
                    vector.setElementAt("0", j);
                }
            }
        } else {
            this.resetVCMTable();
        }
    }

    private void onConjugateRadio(boolean bl) {
        this.mConjugateInfoArea.setEnabled(bl);
        this.mShapeParamLabel.setEnabled(bl);
        this.mShapeParamField.setEnabled(bl);
        this.mScaleParamLabel.setEnabled(bl);
        this.mScaleParamField.setEnabled(bl);
        this.mMeanTableLabel.setEnabled(bl);
        this.mMeanTableResetButton.setEnabled(bl);
        this.mMeanTable.setEnabled(bl);
        this.mVCMTableLabel.setEnabled(bl);
        this.mVCMTableResetButton.setEnabled(bl);
        this.mVCMTable.setEnabled(bl);
        this.mUseSICheck.setEnabled(bl);
        this.onUseSICheck(bl && !this.mUseSICheck.isSelected());
    }

    private JPanel createPriorsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_BULR_PRIORS_VARIANCE_GROUP")));
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        this.mShapeParamLabel = DialogUtil.createLabel(this, PRIORS_SHAPE_PARAM);
        this.mShapeParamLabel.setLabelFor((Component)this.mShapeParamField);
        DialogUtil.addUsingGBL(jPanel, this.mShapeParamLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mShapeParamField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.mScaleParamLabel = DialogUtil.createLabel(this, PRIORS_SCALE_PARAM);
        this.mScaleParamLabel.setLabelFor((Component)this.mScaleParamField);
        DialogUtil.addUsingGBL(jPanel, this.mScaleParamLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mScaleParamField, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createRegressionParametersPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_BULR_PRIORS_PARAMS_GROUP")));
        JPanel jPanel2 = this.createMeanTablePanel();
        JPanel jPanel3 = this.createVCMTablePanel();
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private boolean canEnableContinue() {
        boolean bl = true;
        if (this.mConjugateRadio.isSelected()) {
            bl = this.mShapeParamField.getText().length() > 0 && this.mScaleParamField.getText().length() > 0;
        }
        return bl;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object;
        if (itemEvent.getStateChange() == 1 && ((object = itemEvent.getSource()) == this.mConjugateRadio || object == this.mReferenceRadio)) {
            this.onConjugateRadio(this.mConjugateRadio.isSelected());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private JPanel createMeanTablePanel() {
        Object object;
        Object object22;
        Object object3;
        Object[] objectArray = this.getResStringArray("IDS_BULR_PRIORS_MEAN_TABLE_COL_NAMES");
        if (objectArray.length == 2) {
            object3 = new String[3];
            object3[0] = objectArray[0];
            object3[1] = objectArray[1];
            objectArray = object3;
        }
        object3 = new JPanel(new GridBagLayout());
        this.mMeanTableLabel = DialogUtil.createLabel(this, "IDS_BULR_PRIORS_MEAN_TABLE_LABEL");
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, 0){

            @Override
            public Class<?> getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }
        };
        if (!this.mIsFromAnova) {
            defaultTableModel.addRow(new Object[]{FIRST_VAR, "", true});
        }
        ArrayList<ISpssVariable> arrayList = BULRPriorsSubDlg.getVariables(this.mFactorsModel, this.mCovModel);
        for (Object object22 : arrayList) {
            if (this.mScanBaseDlg.isVarFromModel(this.mFactorsModel, (ISpssVariable)object22)) {
                object = this.mScanBaseDlg.findScannedVariable((ISpssVariable)object22);
                ArrayList<String> arrayList2 = this.mScanBaseDlg.getCatsList((ScannedVariable)object);
                for (int i = 0; i < arrayList2.size(); ++i) {
                    boolean bl = i == arrayList2.size() - 1;
                    defaultTableModel.addRow(new Object[]{arrayList2.get(i), !this.mIsFromAnova && i == arrayList2.size() - 1 ? "0" : "", !this.mIsFromAnova && !bl});
                }
                continue;
            }
            defaultTableModel.addRow(new Object[]{object22, "", true});
        }
        this.mMeanTable = new MeanTable(defaultTableModel);
        JScrollPane jScrollPane = new JScrollPane(this.mMeanTable);
        jScrollPane.setPreferredSize(new Dimension(250, 200));
        jScrollPane.setMinimumSize(new Dimension(250, 150));
        this.mMeanTableLabel.setLabelFor(this.mMeanTable);
        object22 = new GridBagConstraints();
        object = DialogUtil.getStandardControlInsets();
        object22.weightx = 1.0;
        int n = 18;
        DialogUtil.addUsingGBL((Container)object3, this.mMeanTableLabel, (GridBagConstraints)object22, 0, 0, 1, 1, n, (Insets)object);
        object22.weightx = 0.0;
        DialogUtil.addUsingGBL((Container)object3, this.mMeanTableResetButton, (GridBagConstraints)object22, 1, 1, 1, 1, n, (Insets)object);
        object22.fill = 1;
        object22.weightx = 1.0;
        object22.weighty = 1.0;
        DialogUtil.addUsingGBL((Container)object3, jScrollPane, (GridBagConstraints)object22, 0, 1, 1, 1, n, (Insets)object);
        return object3;
    }

    private void enableResetButton(boolean bl) {
        boolean bl2 = true;
        if (bl && this.mMeanTable != null) {
            if (!this.mMeanTable.hasEmptyCell()) {
                this.mMeanTableResetButton.setEnabled(true);
            }
        } else if (this.mVCMTable != null) {
            block0: for (int i = 0; i < this.mVCMTable.getRowCount(); ++i) {
                for (int j = 1; j < this.mVCMTable.getColumnCount(); ++j) {
                    String string = (String)this.mVCMTable.getValueAt(i, 1);
                    if (i < j - 1 || string.length() <= 0) continue;
                    bl2 = false;
                    break block0;
                }
            }
            if (!bl2) {
                this.mVCMTableResetButton.setEnabled(true);
            }
        }
    }

    private VCMTable createVCMTable() {
        Integer n;
        Object[] objectArray;
        Object object;
        Object[] objectArray2;
        ArrayList<ISpssVariable> arrayList = BULRPriorsSubDlg.getVariables(this.mFactorsModel, this.mCovModel);
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        arrayList2.add("");
        if (!this.mIsFromAnova) {
            arrayList2.add(FIRST_VAR);
        }
        for (ISpssVariable object22 : arrayList) {
            if (this.mScanBaseDlg.isVarFromModel(this.mFactorsModel, object22)) {
                objectArray2 = this.mScanBaseDlg.findScannedVariable(object22);
                object = this.mScanBaseDlg.getCatsList((ScannedVariable)objectArray2);
                ISpssVariable iSpssVariable = ((ArrayList)object).iterator();
                while (iSpssVariable.hasNext()) {
                    objectArray = iSpssVariable.next();
                    arrayList2.add(objectArray);
                }
                continue;
            }
            arrayList2.add(object22.getName());
        }
        arrayList2.add("");
        String string = MessageFormat.format(this.getResString("IDS_BULR_PRIORS_VCM_TABLE_LABEL"), "\u03c3", "\u00b2");
        this.mVCMTableLabel = new JLabel(string);
        if (OSInfo.getOSType() != OSInfo.OSType.MAC && (n = this.getDlgAccessKey("IDK_BULR_PRIORS_VCM_TABLE_LABEL_KEY")) != null) {
            this.mVCMTableLabel.setDisplayedMnemonic(n);
        }
        DefaultTableModel defaultTableModel = new DefaultTableModel(arrayList2.toArray(new String[arrayList.size()]), 0){

            @Override
            public Class<?> getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }
        };
        objectArray2 = new Object[arrayList2.size()];
        Arrays.fill(objectArray2, "");
        if (!this.mIsFromAnova) {
            objectArray2[0] = FIRST_VAR;
            objectArray2[objectArray2.length - 1] = true;
            defaultTableModel.addRow(objectArray2);
        }
        for (ISpssVariable iSpssVariable : arrayList) {
            if (this.mScanBaseDlg.isVarFromModel(this.mFactorsModel, iSpssVariable)) {
                ScannedVariable scannedVariable = this.mScanBaseDlg.findScannedVariable(iSpssVariable);
                ArrayList<String> arrayList3 = this.mScanBaseDlg.getCatsList(scannedVariable);
                for (int i = 0; i < arrayList3.size(); ++i) {
                    objectArray = new Object[defaultTableModel.getColumnCount()];
                    Arrays.fill(objectArray, "");
                    objectArray[0] = arrayList3.get(i);
                    objectArray[defaultTableModel.getColumnCount() - 1] = i < arrayList3.size() - 1;
                    defaultTableModel.addRow(objectArray);
                }
                continue;
            }
            objectArray = new Object[defaultTableModel.getColumnCount()];
            Arrays.fill(objectArray, "");
            objectArray[0] = iSpssVariable;
            objectArray[defaultTableModel.getColumnCount() - 1] = true;
            defaultTableModel.addRow(objectArray);
        }
        object = new VCMTable(defaultTableModel){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return this.getPreferredSize().width < this.getParent().getWidth();
            }
        };
        this.mVCMTableLabel.setLabelFor((Component)object);
        ((JTable)object).setAutoResizeMode(0);
        return object;
    }

    private JPanel createVCMTablePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.mVCMTable = this.createVCMTable();
        JScrollPane jScrollPane = new JScrollPane(this.mVCMTable);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setPreferredSize(new Dimension(250, 200));
        jScrollPane.setMinimumSize(new Dimension(250, 150));
        this.mVCMTableLabel.setLabelFor(this.mVCMTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 1.0;
        int n = 18;
        DialogUtil.addUsingGBL(jPanel, this.mVCMTableLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mUseSICheck, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mVCMTableResetButton, gridBagConstraints, 2, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 2, 1, n, insets);
        return jPanel;
    }

    public static ArrayList<ISpssVariable> getVariables(VarListModel varListModel, VarListModel varListModel2) {
        int n;
        int n2;
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        if (varListModel != null) {
            n2 = varListModel.getSize();
            for (n = 0; n < n2; ++n) {
                arrayList.add(varListModel.getElementAt(n));
            }
        }
        if (varListModel2 != null) {
            n2 = varListModel2.getSize();
            for (n = 0; n < n2; ++n) {
                arrayList.add(varListModel2.getElementAt(n));
            }
        }
        return arrayList;
    }

    private static String getMeanTableSyntaxValues(DialogDataModel dialogDataModel) {
        Vector vector = (Vector)dialogDataModel.getObject(PRIORS_MEAN_TABLE_VECTOR_KEY);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = (Vector)vector.get(i);
            stringBuffer.append(vector2.get(1));
            if (i >= vector.size() - 1) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private static String getVCMTableSyntaxValues(DialogDataModel dialogDataModel) {
        Vector vector = (Vector)dialogDataModel.getObject(PRIORS_VCM_TABLE_VECTOR_KEY);
        Boolean bl = dialogDataModel.containsBooleanKey("IDS_BULR_PRIORS_USE_SCALED_IDENTY") ? dialogDataModel.getBoolean("IDS_BULR_PRIORS_USE_SCALED_IDENTY") : false;
        Boolean bl2 = dialogDataModel.containsBooleanKey("IDS_BULR_PRIORS_CONJUGATE") ? dialogDataModel.getBoolean("IDS_BULR_PRIORS_CONJUGATE") : false;
        if (bl2.booleanValue() && bl.booleanValue()) {
            return "IDENTITY";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = (Vector)vector.get(i);
            for (int j = 1; j < vector2.size() - 1; ++j) {
                String string;
                if (!(vector2.get(j) instanceof String) || (string = (String)vector2.get(j)) == null || string.length() <= 0) continue;
                stringBuffer.append(string);
                if (i <= j - 1) continue;
                stringBuffer.append(" ");
            }
            stringBuffer.trimToSize();
            if (i >= vector.size() - 1) continue;
            stringBuffer.append(";");
        }
        return stringBuffer.toString();
    }

    class VCMTable
    extends BayesianBaseDlg.BaseTable {
        ArrayList<Integer> theRows;

        VCMTable(TableModel tableModel) {
            super(tableModel);
            this.theRows = new ArrayList();
            this.setupColumns();
            if (!BULRPriorsSubDlg.this.mIsFromAnova) {
                this.setupTheRows();
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            boolean bl;
            boolean bl2 = !BULRPriorsSubDlg.this.mIsBayesFactorSelected && BULRPriorsSubDlg.this.mConjugateRadio.isSelected();
            boolean bl3 = bl = n2 > 0 && n >= n2 - 1;
            if (BULRPriorsSubDlg.this.mIsFromAnova) {
                return bl2 && bl;
            }
            boolean bl4 = this.theRows.contains(n) || this.theRows.contains(n2 - 1);
            return bl2 && bl && !bl4;
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (!BULRPriorsSubDlg.this.mIsBayesFactorSelected && BULRPriorsSubDlg.this.mConjugateRadio.isSelected() && n2 > 0) {
                if (n == n2 - 1) {
                    return new BayesianBaseDlg.FloatValueCellEditor(0.0, Double.NaN, false);
                }
                if (n > n2 - 1) {
                    return new BayesianBaseDlg.FloatValueCellEditor(Double.NaN, Double.NaN, false);
                }
            }
            return null;
        }

        @Override
        protected boolean validateTable(boolean bl) {
            String string = null;
            block0: for (int i = 0; i < this.getRowCount(); ++i) {
                for (int j = 1; j < this.getColumnCount() - 1; ++j) {
                    Object object = this.getValueAt(i, j);
                    if (!(object instanceof String)) continue;
                    String string2 = (String)this.getValueAt(i, j);
                    if (i >= j - 1 && string2.length() == 0) {
                        string = BULRPriorsSubDlg.this.getResString("ERR_MSG_EMPTY_VALUE_WARNING");
                    } else if (i == j - 1 && string2.length() > 0 && Double.parseDouble(string2) == 0.0) {
                        string = MessageFormat.format(UIToolResUtil.getString((String)"ERR_WARNING_MSG_GREATER_THAN"), 0);
                    }
                    if (string == null) continue;
                    if (bl) break block0;
                    SPSSTextField.showWarningDialog((JComponent)this, (String)string, (String)UIToolResUtil.getString((String)"IDS_WARNING_TITLE"));
                    this.setRowSelectionInterval(i, i);
                    this.setColumnSelectionInterval(j, j);
                    this.requestFocus();
                    break block0;
                }
            }
            return string == null;
        }

        private void setupColumns() {
            if (this.columnModel.getColumnCount() == 0) {
                return;
            }
            TableColumn tableColumn = this.columnModel.getColumn(0);
            BayesianBaseDlg.VarLabelRenderer varLabelRenderer = new BayesianBaseDlg.VarLabelRenderer(true);
            tableColumn.setCellRenderer(varLabelRenderer);
            tableColumn.setPreferredWidth(50);
            tableColumn.setMinWidth(50);
            int n = this.getModel().getColumnCount();
            BayesianBaseDlg.ValueRenderer valueRenderer = new BayesianBaseDlg.ValueRenderer();
            for (int i = 1; i < n; ++i) {
                TableColumn tableColumn2 = this.columnModel.getColumn(i);
                tableColumn2.setCellRenderer(valueRenderer);
                tableColumn2.setPreferredWidth(50);
                tableColumn2.setMinWidth(50);
            }
            TableColumn tableColumn3 = this.columnModel.getColumn(n - 1);
            tableColumn3.setPreferredWidth(0);
            tableColumn3.setMinWidth(0);
            tableColumn3.setMaxWidth(0);
        }

        private void setupTheRows() {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!(this.getValueAt(i, this.getColumnCount() - 1) instanceof Boolean) || ((Boolean)this.getValueAt(i, this.getColumnCount() - 1)).booleanValue()) continue;
                this.theRows.add(i);
            }
        }
    }

    class MeanTable
    extends BayesianBaseDlg.BaseTable {
        MeanTable(TableModel tableModel) {
            super(tableModel);
            this.setupColumns();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return !BULRPriorsSubDlg.this.mIsBayesFactorSelected && BULRPriorsSubDlg.this.mConjugateRadio.isSelected() && n2 == 1 && (BULRPriorsSubDlg.this.mIsFromAnova || this.getValueAt(n, 2) == null || (Boolean)this.getValueAt(n, 2) != false);
        }

        @Override
        protected boolean validateTable(boolean bl) {
            String string = null;
            for (int i = 0; i < this.getRowCount(); ++i) {
                String string2 = (String)this.getValueAt(i, 1);
                if (string2.length() == 0) {
                    string = BULRPriorsSubDlg.this.getResString("ERR_MSG_EMPTY_VALUE_WARNING");
                }
                if (string == null || bl) continue;
                SPSSTextField.showWarningDialog((JComponent)this, (String)string, (String)UIToolResUtil.getString((String)"IDS_WARNING_TITLE"));
                this.setRowSelectionInterval(i, i);
                this.setColumnSelectionInterval(1, 1);
                this.requestFocus();
                break;
            }
            return string == null;
        }

        private boolean hasEmptyCell() {
            boolean bl = false;
            for (int i = 0; i < this.getRowCount(); ++i) {
                String string = (String)BULRPriorsSubDlg.this.mMeanTable.getValueAt(i, 1);
                if (string.length() != 0) continue;
                bl = true;
                break;
            }
            return bl;
        }

        private void setupColumns() {
            if (this.columnModel.getColumnCount() == 0) {
                return;
            }
            TableColumn tableColumn = this.columnModel.getColumn(0);
            BayesianBaseDlg.VarLabelRenderer varLabelRenderer = new BayesianBaseDlg.VarLabelRenderer(true);
            tableColumn.setCellRenderer(varLabelRenderer);
            tableColumn.setPreferredWidth(60);
            tableColumn.setMinWidth(60);
            BayesianBaseDlg.ValueRenderer valueRenderer = new BayesianBaseDlg.ValueRenderer();
            TableColumn tableColumn2 = this.columnModel.getColumn(1);
            tableColumn2.setCellRenderer(valueRenderer);
            tableColumn2.setPreferredWidth(50);
            tableColumn2.setMinWidth(50);
            tableColumn2.setCellEditor(new BayesianBaseDlg.FloatValueCellEditor(Double.NaN, Double.NaN, false));
            TableColumn tableColumn3 = this.columnModel.getColumn(2);
            tableColumn3.setWidth(0);
            tableColumn3.setMinWidth(0);
            tableColumn3.setMaxWidth(0);
        }
    }
}

