/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BayesianBaseDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.ScanBaseDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.SPSSTextField;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class BULRPredictSubDlg
extends BaseSubDialog {
    private static final String BULR_PREDICT_TABLE_VECTOR_KEY = "IDS_BULR_PREDICT_TABLE_VECTOR";
    private JLabel mTableLabel;
    private JButton mTableResetButton;
    private RegressorTable mRegressorTable;
    protected VarListModel mFactorsModel;
    protected VarListModel mCovModel;
    private Vector mRegressorVector;
    private ScanBaseDlg mScanBaseDlg;

    public BULRPredictSubDlg(BaseProcedureDialog baseProcedureDialog, String string, VarListModel varListModel, VarListModel varListModel2) {
        super(baseProcedureDialog, string, true);
        this.mFactorsModel = varListModel;
        this.mCovModel = varListModel2;
        this.mScanBaseDlg = (ScanBaseDlg)this.mParentDlg;
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.pack();
        this.setFocusTraversalPolicy();
        this.setDefaults();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_linear_predict";
    }

    public static String getPredictDlgSyntax(DialogDataModel dialogDataModel, VarListModel varListModel, VarListModel varListModel2) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        Vector vector = (Vector)dialogDataModel.getObject(BULR_PREDICT_TABLE_VECTOR_KEY);
        if (vector == null || vector.size() == 0) {
            return "";
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string;
            Vector vector2 = (Vector)vector.get(i);
            SpssVariable spssVariable = (SpssVariable)vector2.get(0);
            if (!BULRPredictSubDlg.isInTargetList(spssVariable, varListModel, varListModel2) || (string = (String)vector2.get(1)) == null || string.length() <= 0) continue;
            stringBuffer2.append(string);
            if (i >= vector.size() - 1) continue;
            stringBuffer2.append(" ");
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/PREDICT"));
            stringBuffer.append(" REGRESSORS=");
            stringBuffer.append(stringBuffer2);
        }
        return stringBuffer.toString();
    }

    public static boolean isInTargetList(SpssVariable spssVariable, VarListModel varListModel, VarListModel varListModel2) {
        int n;
        boolean bl = false;
        for (n = 0; n < varListModel.getSize(); ++n) {
            if (!spssVariable.getName().equals(varListModel.getElementAt(n).getName())) continue;
            bl = true;
            break;
        }
        for (n = 0; n < varListModel2.getSize(); ++n) {
            if (!spssVariable.getName().equals(varListModel2.getElementAt(n).getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mRegressorTable);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setupPanel(JPanel jPanel) {
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = this.createRegressorTablePanel();
        jPanel.add((Component)jPanel2, "Center");
    }

    protected void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_BULR_PRIORS_RESET", "IDK_BULR_PRIORS_MEAN_RESET_KEY"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BULRPredictSubDlg.this.onResetButton();
            }
        };
        this.mTableResetButton = new JButton(toggleButtonAction);
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        this.mRegressorVector = (Vector)dialogDataModel.getObject(BULR_PREDICT_TABLE_VECTOR_KEY);
        super.loadState(dialogDataModel);
        this.mRegressorTable.reloadTable(this.mRegressorVector);
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        if (this.mRegressorTable != null) {
            this.mRegressorVector = ((DefaultTableModel)this.mRegressorTable.getModel()).getDataVector();
            dialogDataModel.putObject(BULR_PREDICT_TABLE_VECTOR_KEY, this.mRegressorVector);
        }
        return super.saveState(dialogDataModel);
    }

    @Override
    public boolean continuePressed() {
        return !this.mRegressorTable.isEnabled() || this.mRegressorTable.validateTable(false);
    }

    private void onResetButton() {
        for (int i = 0; i < this.mRegressorTable.getRowCount(); ++i) {
            this.mRegressorTable.setValueAt("", i, 1);
        }
    }

    private void setDefaults() {
        if (this.mRegressorVector != null) {
            this.mRegressorVector.clear();
        }
    }

    private JPanel createRegressorTablePanel() {
        Object object2;
        Object[] objectArray = this.getResStringArray("IDS_BULR_PREDICT_TABLE_COL_NAMES");
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.mTableLabel = DialogUtil.createLabel(this, "IDS_BULR_PREDICT_TABLE_LABEL");
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, 0){

            @Override
            public Class<?> getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }
        };
        ArrayList<ISpssVariable> arrayList = this.getVariables();
        for (Object object2 : arrayList) {
            defaultTableModel.addRow(new Object[]{object2, ""});
        }
        this.mRegressorTable = new RegressorTable(defaultTableModel);
        JScrollPane jScrollPane = new JScrollPane(this.mRegressorTable);
        jScrollPane.setPreferredSize(new Dimension(300, 200));
        this.mTableLabel.setLabelFor(this.mRegressorTable);
        object2 = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        object2.weightx = 1.0;
        int n = 18;
        DialogUtil.addUsingGBL(jPanel, this.mTableLabel, (GridBagConstraints)object2, 0, 0, 1, 1, n, insets);
        object2.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mTableResetButton, (GridBagConstraints)object2, 1, 1, 1, 1, n, insets);
        object2.fill = 1;
        object2.weightx = 1.0;
        object2.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, (GridBagConstraints)object2, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private ArrayList<ISpssVariable> getVariables() {
        int n;
        int n2;
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        if (this.mFactorsModel != null) {
            n2 = this.mFactorsModel.getSize();
            for (n = 0; n < n2; ++n) {
                arrayList.add(this.mFactorsModel.getElementAt(n));
            }
        }
        if (this.mCovModel != null) {
            n2 = this.mCovModel.getSize();
            for (n = 0; n < n2; ++n) {
                arrayList.add(this.mCovModel.getElementAt(n));
            }
        }
        return arrayList;
    }

    class RegressorTable
    extends BayesianBaseDlg.BaseTable {
        RegressorTable(TableModel tableModel) {
            super(tableModel);
            this.setupColumns();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            Object object = this.getValueAt(n, 0);
            if (object instanceof ISpssVariable) {
                if (((ISpssVariable)object).getFormat().getFormatType().isStringFormat()) {
                    return new BayesianBaseDlg.BaseValueCellEditor(new StringTextField());
                }
                return new BayesianBaseDlg.FloatValueCellEditor(Double.NaN, Double.NaN, false);
            }
            if (object instanceof String) {
                return new BayesianBaseDlg.BaseValueCellEditor(new StringTextField());
            }
            return null;
        }

        @Override
        protected boolean validateTable(boolean bl) {
            String string = null;
            boolean bl2 = this.isAllEmpty();
            if (bl2) {
                return true;
            }
            for (int i = 0; i < this.getRowCount(); ++i) {
                String string2 = (String)this.getValueAt(i, 1);
                if (string2.length() == 0) {
                    string = BULRPredictSubDlg.this.getResString("ERR_MSG_EMPTY_VALUE_WARNING");
                }
                if (string == null || bl) continue;
                SPSSTextField.showWarningDialog((JComponent)this, (String)string, (String)UIToolResUtil.getString((String)"IDS_WARNING_TITLE"));
                this.setRowSelectionInterval(i, i);
                this.setColumnSelectionInterval(1, 1);
                this.requestFocus();
                break;
            }
            return string == null;
        }

        private boolean isAllEmpty() {
            boolean bl = true;
            for (int i = 0; i < this.getRowCount(); ++i) {
                String string = (String)this.getValueAt(i, 1);
                if (string.length() <= 0) continue;
                bl = false;
                break;
            }
            return bl;
        }

        private void setupColumns() {
            if (this.columnModel.getColumnCount() == 0) {
                return;
            }
            TableColumn tableColumn = this.columnModel.getColumn(0);
            BayesianBaseDlg.VarLabelRenderer varLabelRenderer = new BayesianBaseDlg.VarLabelRenderer(true);
            tableColumn.setCellRenderer(varLabelRenderer);
            tableColumn.setPreferredWidth(100);
            tableColumn.setMinWidth(60);
            BayesianBaseDlg.ValueRenderer valueRenderer = new BayesianBaseDlg.ValueRenderer();
            TableColumn tableColumn2 = this.columnModel.getColumn(1);
            tableColumn2.setCellRenderer(valueRenderer);
            tableColumn2.setPreferredWidth(100);
            tableColumn2.setMinWidth(40);
        }
    }
}

