/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BULRStatsDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.NumberSpinner;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class BULRPlotsSubDlg
extends BaseSubDialog
implements ListDataListener {
    private static String BULR_COV_VAR_SRC_LIST_KEY = "BULR_SOURCE_COV_VARIABLE_LIST_KEY";
    private static String BULR_FACTOR_VAR_SRC_LIST_KEY = "BULR_SOURCE_FACTOR_VARIABLE_LIST_KEY";
    public static String BULR_PLOTS_FACTOR_TARGET_LIST_KEY = "BULR_PLOTS_FACTOR_VARIABLE_LIST_KEY";
    public static String BULR_PLOTS_COV_TARGET_LIST_KEY = "BULR_PLOTS_COV_VARIABLE_LIST_KEY";
    private SrcVariableList mCovVarSrcList;
    private JLabel mCovVarSrcListLabel;
    private SrcVariableList mFactorVarSrcList;
    private JLabel mFactorVarSrcListLabel;
    private TargetVariableList mCovTargetList;
    private JLabel mCovTargetLabel;
    private ArrowButton mCovTargetArrowButton;
    private TargetVariableList mFactorTargetList;
    private JLabel mFactorTargetLabel;
    private ArrowButton mFactorTargetArrowButton;
    private JLabel mMaxNumberLabel;
    private NumberSpinner mMaxNumberSpinner;
    private JCheckBox mInterceptCheck;
    private JCheckBox mVarianceCheck;
    private JCheckBox mDistCheck;
    private boolean mIsBayesFactorSelected;
    protected VarListModel mFactorsModel;
    protected VarListModel mCovModel;

    public BULRPlotsSubDlg(BaseProcedureDialog baseProcedureDialog, String string, boolean bl, VarListModel varListModel, VarListModel varListModel2) {
        super(baseProcedureDialog, string, true);
        this.mIsBayesFactorSelected = bl;
        this.mCovModel = varListModel2;
        this.mFactorsModel = varListModel;
        this.setDefaults();
        this.mFactorTargetList.getModel().addListDataListener(this);
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_linear_plots";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    protected void initVars() {
        this.mCovVarSrcList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mCovVarSrcList.setIdentifier(BULR_COV_VAR_SRC_LIST_KEY);
        this.mCovVarSrcList.setContextMenuFlags(this.mCovVarSrcList.getContextMenuFlags() | 8);
        this.mCovVarSrcListLabel = DialogUtil.createLabel(this, "IDS_BULR_COVARIATE");
        this.mCovVarSrcListLabel.setLabelFor(this.mCovVarSrcList);
        this.mFactorVarSrcList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mFactorVarSrcList.setIdentifier(BULR_FACTOR_VAR_SRC_LIST_KEY);
        this.mFactorVarSrcList.setContextMenuFlags(this.mFactorVarSrcList.getContextMenuFlags() | 8);
        this.mFactorVarSrcListLabel = DialogUtil.createLabel(this, "IDS_BULR_FACTOR");
        this.mFactorVarSrcListLabel.setLabelFor(this.mFactorVarSrcList);
        this.mFactorTargetList = new TargetVariableList();
        this.mFactorTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mFactorTargetList.setIdentifier(BULR_PLOTS_FACTOR_TARGET_LIST_KEY);
        this.mFactorTargetLabel = DialogUtil.createLabel(this, "IDS_BULR_PLOTS_FACTOR_TARGET_VAR_LABEL");
        this.mFactorTargetLabel.setLabelFor(this.mFactorTargetList);
        this.mFactorTargetList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mFactorTargetList.getFixedCellHeight() * 5 + 2));
        this.mFactorTargetArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mFactorTargetArrowButton.registerVariableList(this.mFactorVarSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mFactorTargetArrowButton.registerVariableList(this.mFactorTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mCovTargetList = new TargetVariableList();
        this.mCovTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mCovTargetList.setIdentifier(BULR_PLOTS_COV_TARGET_LIST_KEY);
        this.mCovTargetLabel = DialogUtil.createLabel(this, "IDS_BULR_PLOTS_COV_TARGET_VAR_LABEL");
        this.mCovTargetLabel.setLabelFor(this.mCovTargetList);
        this.mCovTargetList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mCovTargetList.getFixedCellHeight() * 5 + 2));
        this.mCovTargetArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCovTargetArrowButton.registerVariableList(this.mCovVarSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mCovTargetArrowButton.registerVariableList(this.mCovTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mMaxNumberLabel = DialogUtil.createLabel(this, "IDS_BULR_PLOTS_MAX_LABEL");
        this.mMaxNumberSpinner = new NumberSpinner(2, 1, Integer.MAX_VALUE, true, 1);
        this.mMaxNumberLabel.setLabelFor((Component)this.mMaxNumberSpinner);
        this.mInterceptCheck = new JCheckBox(new ToggleButtonAction(this, "IDS_BULR_PLOTS_INTERCEPT"));
        this.mVarianceCheck = new JCheckBox(new ToggleButtonAction(this, "IDS_BULR_PLOTS_VARIANCE"));
        this.mDistCheck = new JCheckBox(new ToggleButtonAction(this, "IDS_BULR_PLOTS_DIST"));
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        String string;
        ISpssVariable iSpssVariable;
        int n;
        super.loadState(dialogDataModel);
        this.mCovVarSrcList.getModel().removeAll();
        VarListModel varListModel = this.mCovVarSrcList.getModel();
        for (int i = 0; i < this.mCovModel.getSize(); ++i) {
            ISpssVariable iSpssVariable2 = this.mCovModel.getElementAt(i);
            if (this.mCovTargetList.getModel().contains(iSpssVariable2)) continue;
            varListModel.addElement(iSpssVariable2);
        }
        this.mFactorVarSrcList.getModel().removeAll();
        VarListModel varListModel2 = this.mFactorVarSrcList.getModel();
        for (n = 0; n < this.mFactorsModel.getSize(); ++n) {
            iSpssVariable = this.mFactorsModel.getElementAt(n);
            if (this.mFactorTargetList.getModel().contains(iSpssVariable)) continue;
            varListModel2.addElement(iSpssVariable);
        }
        for (n = this.mCovTargetList.getModel().getSize() - 1; n >= 0; --n) {
            iSpssVariable = this.mCovTargetList.getModel().getElementAt(n);
            if (this.mCovModel.contains(iSpssVariable)) continue;
            this.mCovTargetList.getModel().removeElement(iSpssVariable);
        }
        for (n = this.mFactorTargetList.getModel().getSize() - 1; n >= 0; --n) {
            iSpssVariable = this.mFactorTargetList.getModel().getElementAt(n);
            if (this.mFactorsModel.contains(iSpssVariable)) continue;
            this.mFactorTargetList.getModel().removeElement(iSpssVariable);
        }
        if (this.mCovVarSrcList.getModel().getSize() > 0) {
            this.mCovVarSrcList.setSelectedIndex(0);
        }
        if (this.mFactorVarSrcList.getModel().getSize() > 0) {
            this.mFactorVarSrcList.setSelectedIndex(0);
        }
        if ((string = dialogDataModel.getString("IDS_BULR_PLOTS_MAX_LABEL")) != null) {
            this.mMaxNumberSpinner.setValue((Object)Integer.parseInt(string));
        }
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        dialogDataModel.putString("IDS_BULR_PLOTS_MAX_LABEL", this.mMaxNumberSpinner.getValue().toString());
        return super.saveState(dialogDataModel);
    }

    public static String getPlotsSyntax(DialogDataModel dialogDataModel, boolean bl, VarListModel varListModel, VarListModel varListModel2) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            return "";
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/PLOT"));
        Boolean bl2 = dialogDataModel.containsBooleanKey("IDS_BULR_PLOTS_INTERCEPT") ? dialogDataModel.getBoolean("IDS_BULR_PLOTS_INTERCEPT") : false;
        Boolean bl3 = dialogDataModel.containsBooleanKey("IDS_BULR_PLOTS_VARIANCE") ? dialogDataModel.getBoolean("IDS_BULR_PLOTS_VARIANCE") : false;
        Boolean bl4 = dialogDataModel.containsBooleanKey("IDS_BULR_PLOTS_DIST") ? dialogDataModel.getBoolean("IDS_BULR_PLOTS_DIST") : false;
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray(BULR_PLOTS_FACTOR_TARGET_LIST_KEY);
        ISpssVariable[] iSpssVariableArray2 = dialogDataModel.getVarArray(BULR_PLOTS_COV_TARGET_LIST_KEY);
        ISpssVariable[] iSpssVariableArray3 = BULRStatsDlg.refreshTargetVars(iSpssVariableArray, varListModel, null);
        ISpssVariable[] iSpssVariableArray4 = BULRStatsDlg.refreshTargetVars(iSpssVariableArray2, varListModel2, null);
        String string2 = string = dialogDataModel.getString("IDS_BULR_PLOTS_MAX_LABEL") != null ? dialogDataModel.getString("IDS_BULR_PLOTS_MAX_LABEL") : "2";
        if (iSpssVariableArray4.length > 0) {
            stringBuffer.append(" COVARIATES=").append(BULRStatsDlg.getSyntaxVarString(iSpssVariableArray4));
        }
        if (iSpssVariableArray3.length > 0) {
            stringBuffer.append(" FACTORS=").append(BULRStatsDlg.getSyntaxVarString(iSpssVariableArray3));
            stringBuffer.append(" MAX_CATEGORY=").append(string);
        }
        stringBuffer.append(" INTERCEPT=").append(bl2 != false ? "TRUE" : "FALSE");
        stringBuffer.append(" ERRORVAR=").append(bl3 != false ? "TRUE" : "FALSE");
        stringBuffer.append(" BAYESPRED=").append(bl4 != false ? "TRUE" : "FALSE");
        return stringBuffer.toString();
    }

    private void setDefaults() {
        this.mInterceptCheck.setSelected(false);
        this.mVarianceCheck.setSelected(false);
        this.mDistCheck.setSelected(false);
        this.mMaxNumberSpinner.setValue((Object)2);
        this.mMaxNumberLabel.setEnabled(false);
        this.mMaxNumberSpinner.setEnabled(false);
        this.onEntering();
    }

    private void setupPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = this.createVarListPanel();
        JPanel jPanel3 = this.createIncludePanel();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 2;
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
    }

    private JPanel createVarListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 16;
        DialogUtil.addUsingGBL(jPanel, this.mCovVarSrcListLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mCovVarSrcList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setPreferredSize(this.mCovVarSrcList.getMinimumSize());
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        n = 18;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCovVarSrcListLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        n = 16;
        DialogUtil.addUsingGBL(jPanel, this.mFactorVarSrcListLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        JScrollPane jScrollPane2 = new JScrollPane(this.mFactorVarSrcList);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setVerticalScrollBarPolicy(20);
        jScrollPane2.setPreferredSize(this.mFactorVarSrcList.getMinimumSize());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        n = 18;
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 0, 3, 1, 2, n, insets);
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets3 = new Insets(0, insets2.left, 0, insets2.right);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mCovTargetArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 2;
        n = 16;
        Insets insets4 = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mCovTargetLabel, gridBagConstraints, 2, 0, 2, 1, n, insets4);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.weightx = 0.5;
        JScrollPane jScrollPane3 = new JScrollPane(this.mCovTargetList);
        jScrollPane3.setHorizontalScrollBarPolicy(31);
        jScrollPane3.setVerticalScrollBarPolicy(20);
        jScrollPane3.setPreferredSize(this.mCovTargetList.getMinimumSize());
        n = 18;
        DialogUtil.addUsingGBL(jPanel, jScrollPane3, gridBagConstraints, 2, 1, 2, 1, n, insets);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mFactorTargetArrowButton, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 18;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mFactorTargetLabel, gridBagConstraints, 2, 2, 2, 1, n, insets);
        JScrollPane jScrollPane4 = new JScrollPane(this.mFactorTargetList);
        jScrollPane4.setHorizontalScrollBarPolicy(31);
        jScrollPane4.setVerticalScrollBarPolicy(20);
        jScrollPane4.setPreferredSize(this.mFactorTargetList.getMinimumSize());
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        n = 18;
        DialogUtil.addUsingGBL(jPanel, jScrollPane4, gridBagConstraints, 2, 3, 2, 1, n, insets);
        n = 13;
        DialogUtil.addUsingGBL(jPanel, this.mMaxNumberLabel, gridBagConstraints, 2, 4, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxNumberSpinner, gridBagConstraints, 3, 4, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createIncludePanel() {
        JPanel jPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        jPanel.setLayout(boxLayout);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_BULR_PLOTS_INCLUDE_GROUP")));
        jPanel.add(this.mInterceptCheck);
        jPanel.add(Box.createVerticalStrut(3));
        jPanel.add(this.mVarianceCheck);
        jPanel.add(Box.createVerticalStrut(3));
        jPanel.add(this.mDistCheck);
        jPanel.add(Box.createVerticalStrut(3));
        return jPanel;
    }

    private void onEntering() {
        boolean bl = !this.mIsBayesFactorSelected;
        this.mCovVarSrcListLabel.setEnabled(bl);
        this.mCovVarSrcList.setEnabled(bl);
        this.mFactorVarSrcListLabel.setEnabled(bl);
        this.mFactorVarSrcList.setEnabled(bl);
        this.mFactorTargetLabel.setEnabled(bl);
        this.mFactorTargetList.setEnabled(bl);
        this.mCovTargetLabel.setEnabled(bl);
        this.mCovTargetList.setEnabled(bl);
        this.mFactorTargetArrowButton.setEnabled(bl);
        this.mCovTargetArrowButton.setEnabled(bl);
        this.mInterceptCheck.setEnabled(bl);
        this.mVarianceCheck.setEnabled(bl);
        this.mDistCheck.setEnabled(bl);
        this.onFactorTargetList();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mCovVarSrcList);
        vector.add(this.mCovTargetArrowButton);
        vector.add(this.mCovTargetList);
        vector.add(this.mFactorVarSrcList);
        vector.add(this.mFactorTargetArrowButton);
        vector.add(this.mFactorTargetList);
        vector.add(this.mMaxNumberSpinner);
        vector.add(this.mInterceptCheck);
        vector.add(this.mVarianceCheck);
        vector.add(this.mDistCheck);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.onFactorTargetList();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.onFactorTargetList();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    private void onFactorTargetList() {
        boolean bl = this.mFactorTargetList.isEnabled() && this.mFactorTargetList.getModel().getSize() > 0;
        this.mMaxNumberLabel.setEnabled(bl);
        this.mMaxNumberSpinner.setEnabled(bl);
    }
}

