/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BULRStatsDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.LayerPanel;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.ScanBaseDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BULRFTestsSubDlg
extends BaseSubDialog
implements DocumentListener {
    private static final String FTESTS_CURRENT_LAYER = "FTESTS_CURRENT_LAYER";
    private static final String FTESTS_TOTAL_LAYER = "FTESTS_TOTAL_LAYERS";
    private static final String FTESTS_DATA_OF_LAYERS = "FTESTS_DATA_OF_LAYERS";
    private int mCurrentLayer;
    private int mTotalLayers;
    private int mMaxNoOfLayers = 8;
    private ArrayList<LayerPanel.LayerData> mTotalLayerList;
    private JButton mBackButton;
    private JButton mNextButton;
    private LayerPanel mLayerPanel;
    private boolean mBayesFactorSelected;
    private ScanBaseDlg mScanBaseDlg = (ScanBaseDlg)this.mParentDlg;

    public BULRFTestsSubDlg(BaseProcedureDialog baseProcedureDialog, String string, VarListModel varListModel, VarListModel varListModel2, boolean bl) {
        super(baseProcedureDialog, string, true);
        this.mBayesFactorSelected = bl;
        this.mLayerPanel = new LayerPanel(this, bl, varListModel, varListModel2);
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.setDefaults();
        this.mLayerPanel.addListeners(this);
        this.pack();
        this.setFocusTraversalPolicy();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    public ScanBaseDlg getScanBaseDlg() {
        return this.mScanBaseDlg;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_linear_ftests";
    }

    @Override
    public boolean continuePressed() {
        if (this.mCurrentLayer == this.mTotalLayerList.size()) {
            if (this.saveCurrentLayer(true)) {
                return true;
            }
            Object[] objectArray = this.getResStringArray("IDS_BULR_FTESTS_LAYER_ARRAY");
            int n = SpssAlertOptionPane.showOptionDialog((Window)((Object)this), this.getResString("ERR_BULR_FTESTS_LAYER_MESG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, objectArray, (Object)objectArray[0]);
            if (n == 0) {
                return this.saveCurrentLayer(false);
            }
            --this.mCurrentLayer;
            if (this.mCurrentLayer < 0) {
                this.mCurrentLayer = 0;
            }
            --this.mTotalLayers;
            if (this.mTotalLayers < 0) {
                this.mTotalLayers = 0;
            }
            return true;
        }
        return this.saveCurrentLayer(false);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
    }

    protected void initVars() {
        this.mCurrentLayer = 0;
        this.mTotalLayers = 0;
        this.mTotalLayerList = new ArrayList(this.mMaxNoOfLayers);
        this.mBackButton = new JButton(new LayerButtonAction("IDS_BACK"));
        this.mNextButton = new JButton(new LayerButtonAction("IDS_NEXT"));
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        if (dialogDataModel.getInteger(FTESTS_CURRENT_LAYER) != null) {
            this.mCurrentLayer = dialogDataModel.getInteger(FTESTS_CURRENT_LAYER);
            this.mTotalLayers = dialogDataModel.getInteger(FTESTS_TOTAL_LAYER);
            this.mTotalLayerList = (ArrayList)dialogDataModel.getObject(FTESTS_DATA_OF_LAYERS);
            if (this.mTotalLayerList.size() > 0) {
                this.mLayerPanel.loadLayerPanel(this.mTotalLayerList.get(this.mCurrentLayer));
                this.manipulateLayerButtons();
                this.setLayerTitle(this.mCurrentLayer, this.mTotalLayers);
            }
        }
        this.mLayerPanel.selectFirstItemInSrcList();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        dialogDataModel.putInteger(FTESTS_CURRENT_LAYER, this.mCurrentLayer);
        dialogDataModel.putInteger(FTESTS_TOTAL_LAYER, this.mTotalLayers);
        dialogDataModel.putObject(FTESTS_DATA_OF_LAYERS, this.mTotalLayerList);
        return super.saveState(dialogDataModel);
    }

    private void setupPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = 10;
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 50, 0));
        jPanel2.add(this.mBackButton);
        jPanel2.add(this.mNextButton);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mLayerPanel, gridBagConstraints, 0, 1, 2, 1, n2, new Insets(n, 0, 0, 0));
        String string = MessageFormat.format(this.getResString("IDS_BULR_FTESTS_LAYER_TITLE"), this.mCurrentLayer + 1, this.mTotalLayers + 1);
        this.mLayerPanel.setBorder(BorderFactory.createTitledBorder(string));
    }

    public static String getFTestsSyntax(DialogDataModel dialogDataModel, boolean bl, VarListModel varListModel, VarListModel varListModel2) {
        if (bl) {
            return "";
        }
        ArrayList arrayList = (ArrayList)dialogDataModel.getObject(FTESTS_DATA_OF_LAYERS);
        StringBuffer stringBuffer = new StringBuffer();
        if (arrayList != null) {
            for (LayerPanel.LayerData layerData : arrayList) {
                BULRFTestsSubDlg.addSingleLayerSyntax(stringBuffer, layerData, varListModel, varListModel2);
            }
        }
        return stringBuffer.toString();
    }

    private static void addSingleLayerSyntax(StringBuffer stringBuffer, LayerPanel.LayerData layerData, VarListModel varListModel, VarListModel varListModel2) {
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/FTEST"));
        Boolean bl = layerData.includeIntercept;
        ISpssVariable[] iSpssVariableArray = layerData.targetVarArray.toArray(new ISpssVariable[layerData.targetVarArray.size()]);
        ISpssVariable[] iSpssVariableArray2 = BULRStatsDlg.refreshTargetVars(iSpssVariableArray, varListModel, varListModel2);
        if (iSpssVariableArray2.length > 0) {
            stringBuffer.append(" VARIABLES=").append(BULRStatsDlg.getSyntaxVarString(iSpssVariableArray2));
        }
        String string = layerData.testingValue;
        String string2 = layerData.testLabel;
        stringBuffer.append(" INTERCEPT=").append(bl != false || iSpssVariableArray2.length == 0 ? "TRUE" : "FALSE");
        if (iSpssVariableArray2.length == 0) {
            layerData.includeIntercept = true;
        }
        String string3 = "";
        if (layerData.includeIntercept) {
            string3 = string3 + string;
        }
        String string4 = BULRStatsDlg.getSyntaxVarString(iSpssVariableArray2);
        for (int i = 0; i < layerData.variableValueVector.size(); ++i) {
            Vector vector = (Vector)layerData.variableValueVector.get(i);
            String string5 = "";
            if (vector.get(0) instanceof SpssVariable) {
                string5 = ((SpssVariable)vector.get(0)).getName();
            } else {
                string5 = vector.get(0).toString();
                string5 = string5.substring(0, string5.indexOf(":"));
            }
            if (!string4.contains(string5)) continue;
            if (string3.length() > 0) {
                string3 = string3 + " ";
            }
            string3 = string3 + vector.get(1);
        }
        if (layerData.includeIntercept && string3.length() > 0) {
            stringBuffer.append(" TESTVALUES=").append(string3);
        }
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append(" LABEL=").append(CharacterUtil.smartQuote((String)string2));
        }
    }

    private void setDefaults() {
        this.mNextButton.setEnabled(!this.mBayesFactorSelected);
        this.mBackButton.setEnabled(false);
        this.mLayerPanel.setDefaults();
    }

    private boolean canEnableContinue() {
        return this.mLayerPanel.canEnableContinue();
    }

    private void setLayerTitle(int n, int n2) {
        this.mLayerPanel.setBorder(BorderFactory.createTitledBorder(MessageFormat.format(this.getResString("IDS_BULR_FTESTS_LAYER_TITLE"), n + 1, n2 + 1)));
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mBackButton);
        vector.add(this.mNextButton);
        this.mLayerPanel.addFocusTraversalPolicy(vector);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void manipulateLayerButtons() {
        if (this.mCurrentLayer == this.mMaxNoOfLayers) {
            this.mNextButton.setEnabled(false);
            this.mBackButton.setEnabled(true);
        } else if (this.mCurrentLayer == 0) {
            this.mNextButton.setEnabled(true);
            this.mBackButton.setEnabled(false);
        } else {
            this.mNextButton.setEnabled(true);
            this.mBackButton.setEnabled(true);
        }
    }

    private boolean saveCurrentLayer(boolean bl) {
        if (!this.mLayerPanel.isValidLayerPanel(bl)) {
            return false;
        }
        LayerPanel.LayerData layerData = this.mLayerPanel.getLayerData();
        this.mLayerPanel.resetLayerPanel();
        if (this.mCurrentLayer >= this.mTotalLayerList.size()) {
            this.mTotalLayerList.add(this.mCurrentLayer, layerData);
        } else {
            this.mTotalLayerList.set(this.mCurrentLayer, layerData);
        }
        return true;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    private class LayerButtonAction
    extends ToggleButtonAction {
        public LayerButtonAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == BULRFTestsSubDlg.this.mBackButton) {
                if (!BULRFTestsSubDlg.this.mLayerPanel.isValidLayerPanel(true)) {
                    Object[] objectArray = BULRFTestsSubDlg.this.getResStringArray("IDS_BULR_FTESTS_LAYER_ARRAY");
                    int n = SpssAlertOptionPane.showOptionDialog((Window)((Object)BULRFTestsSubDlg.this), BULRFTestsSubDlg.this.getResString("ERR_BULR_FTESTS_LAYER_MESG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, objectArray, (Object)objectArray[0]);
                    if (n == 0) {
                        BULRFTestsSubDlg.this.saveCurrentLayer(false);
                        return;
                    }
                    BULRFTestsSubDlg.this.mTotalLayers--;
                }
                if (BULRFTestsSubDlg.this.mCurrentLayer >= BULRFTestsSubDlg.this.mTotalLayerList.size()) {
                    BULRFTestsSubDlg.this.saveCurrentLayer(true);
                }
                BULRFTestsSubDlg.this.mCurrentLayer--;
                BULRFTestsSubDlg.this.mLayerPanel.loadLayerPanel((LayerPanel.LayerData)BULRFTestsSubDlg.this.mTotalLayerList.get(BULRFTestsSubDlg.this.mCurrentLayer));
                BULRFTestsSubDlg.this.setLayerTitle(BULRFTestsSubDlg.this.mCurrentLayer, BULRFTestsSubDlg.this.mTotalLayers);
            } else {
                if (!BULRFTestsSubDlg.this.saveCurrentLayer(false)) {
                    return;
                }
                BULRFTestsSubDlg.this.mCurrentLayer++;
                if (BULRFTestsSubDlg.this.mCurrentLayer < BULRFTestsSubDlg.this.mTotalLayerList.size()) {
                    BULRFTestsSubDlg.this.mLayerPanel.loadLayerPanel((LayerPanel.LayerData)BULRFTestsSubDlg.this.mTotalLayerList.get(BULRFTestsSubDlg.this.mCurrentLayer));
                } else {
                    BULRFTestsSubDlg.this.mTotalLayers++;
                }
                BULRFTestsSubDlg.this.setLayerTitle(BULRFTestsSubDlg.this.mCurrentLayer, BULRFTestsSubDlg.this.mTotalLayers);
            }
            BULRFTestsSubDlg.this.manipulateLayerButtons();
        }
    }
}

