/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BULRCriteriaSubDlg
extends BaseSubDialog
implements DocumentListener {
    static final String INTERVAL_PERCENTAGE = "IDS_INTERVAL_PERCENTAGE_LABEL";
    static final String TOLERANCE = "IDS_TOLERANCE_LABEL";
    static final String MAX_ITERATIONS = "IDS_MAX_ITERATIONS_LABEL";
    private FloatTextField mIntervalPercentageField;
    private JLabel mToleranceLabel;
    private FloatTextField mToleranceField;
    private JLabel mMaxIterationsLabel;
    private IntTextField mMaxIterationsField;
    private boolean mIsDistributionRadioSelected;
    private String mDialogHelpID;

    public BULRCriteriaSubDlg(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, true);
        this.mIsDistributionRadioSelected = bl;
        this.setDefaults();
        this.addListeners();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
        this.setDialogHelpID("idh_bayesian_linear_criteria");
    }

    public BULRCriteriaSubDlg(BaseProcedureDialog baseProcedureDialog, String string, boolean bl, String string2) {
        super(baseProcedureDialog, string, true);
        this.mIsDistributionRadioSelected = bl;
        this.setDefaults();
        this.addListeners();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
        this.setDialogHelpID(string2);
    }

    @Override
    public String getDialogHelpID() {
        return this.mDialogHelpID;
    }

    public void setDialogHelpID(String string) {
        this.mDialogHelpID = string;
    }

    public static String getCriteriaDlgSyntax(DialogDataModel dialogDataModel, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SyntaxUtil.getSubCommand("/CRITERIA"));
        String string = dialogDataModel.getString(INTERVAL_PERCENTAGE) != null ? dialogDataModel.getString(INTERVAL_PERCENTAGE) : "95";
        stringBuffer.append(" CILEVEL=").append(string);
        if (!bl) {
            string = dialogDataModel.getString(TOLERANCE);
            stringBuffer.append(" TOL=").append(string != null && string.length() > 0 ? string : "0.000001");
            string = dialogDataModel.getString(MAX_ITERATIONS);
            stringBuffer.append(" MAXITER=").append(string != null && string.length() > 0 ? string : "2000");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    protected void initVars() {
        this.mIntervalPercentageField = new FloatTextField(0.0, 100.0, 1, true);
        this.mIntervalPercentageField.setAllowMinMax(false, false);
        this.mIntervalPercentageField.setAction((Action)new TextFieldAction(this.mParentDlg, INTERVAL_PERCENTAGE));
        this.mIntervalPercentageField.setColumns(8);
        this.mToleranceField = new FloatTextField(Math.abs(Double.MIN_VALUE), 0.001, 3, true);
        this.mToleranceField.setAction((Action)new TextFieldAction(this.mParentDlg, TOLERANCE));
        this.mToleranceField.setColumns(8);
        this.mMaxIterationsField = new IntTextField(1, Integer.MAX_VALUE, true);
        this.mMaxIterationsField.setAction((Action)new TextFieldAction(this.mParentDlg, MAX_ITERATIONS));
        this.mMaxIterationsField.setColumns(8);
    }

    private void setDefaults() {
        this.mIntervalPercentageField.setText("95");
        this.mToleranceField.setText("0.000001");
        this.mMaxIterationsField.setText("2000");
        this.setEnableStateForNumericMethod();
    }

    private void addListeners() {
        this.mIntervalPercentageField.getDocument().addDocumentListener(this);
        this.mToleranceField.getDocument().addDocumentListener(this);
        this.mMaxIterationsField.getDocument().addDocumentListener(this);
    }

    private void setupPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, INTERVAL_PERCENTAGE);
        this.mIntervalPercentageField.setPreferredSize(new Dimension(100, 26));
        this.mIntervalPercentageField.setMinimumSize(new Dimension(70, 26));
        jLabel.setLabelFor((Component)this.mIntervalPercentageField);
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mIntervalPercentageField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JPanel jPanel3 = this.createAdaptiveMethodPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_NUMERICAL_METHOD_TITLE")));
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
    }

    private JPanel createAdaptiveMethodPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        int n = 23;
        this.mToleranceLabel = DialogUtil.createLabel(this, TOLERANCE);
        this.mToleranceLabel.setLabelFor((Component)this.mToleranceField);
        this.mMaxIterationsLabel = DialogUtil.createLabel(this, MAX_ITERATIONS);
        this.mMaxIterationsLabel.setLabelFor((Component)this.mMaxIterationsField);
        DialogUtil.addUsingGBL(jPanel, this.mToleranceLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mMaxIterationsLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mToleranceField, gridBagConstraints, 1, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxIterationsField, gridBagConstraints, 1, 2, 1, 1, n, insets);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mIntervalPercentageField);
        vector.add(this.mToleranceField);
        vector.add(this.mMaxIterationsField);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private boolean canEnableContinue() {
        boolean bl;
        boolean bl2 = bl = this.mIntervalPercentageField.getText().length() > 0;
        if (bl) {
            bl = this.mToleranceField.getText().length() > 0 && this.mMaxIterationsField.getText().length() > 0;
        }
        return bl;
    }

    private void setEnableStateForNumericMethod() {
        this.mToleranceLabel.setEnabled(!this.mIsDistributionRadioSelected);
        this.mToleranceField.setEnabled(!this.mIsDistributionRadioSelected);
        this.mMaxIterationsLabel.setEnabled(!this.mIsDistributionRadioSelected);
        this.mMaxIterationsField.setEnabled(!this.mIsDistributionRadioSelected);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }
}

