/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BULRStatsDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class BULRBayesFactorSubDlg
extends BaseSubDialog
implements ListDataListener,
DocumentListener {
    private static String BULR_SRC_VAR_LIST_KEY = "BULR_SOURCE_VARIABLE_LIST_KEY";
    private static String BULR_BF_FACTOR_TARGET_LIST_KEY = "BULR_BF_FACTOR_VARIABLE_LIST_KEY";
    private static String BULR_BF_COV_TARGET_LIST_KEY = "BULR_BF_COV_VARIABLE_LIST_KEY";
    private JRadioButton mNullRadio;
    private JRadioButton mFullRadio;
    private SpssButtonGroup mNullFullGroup;
    private SrcVariableList mVariableSrcList;
    private JLabel mSrcListLabel;
    private TargetVariableList mFactorTargetList;
    private JLabel mFactorTargetLabel;
    private ArrowButton mFactorTargetArrowButton;
    private TargetVariableList mCovTargetList;
    private JLabel mCovTargetLabel;
    private ArrowButton mCovTargetArrowButton;
    private JRadioButton mZelinerSiowRadio;
    private JRadioButton mZelinerRadio;
    private JRadioButton mHyperRadio;
    private JRadioButton mRounderRadio;
    private SpssButtonGroup mCompRadioGroup;
    private JLabel mGPriorValueLabel;
    private FloatTextField mGPriorValueField;
    private JLabel mScaleParamLabel;
    private FloatTextField mScaleParamField;
    private JLabel mShapeParamLabel;
    private FloatTextField mShapeParamField;
    private boolean mIsDistRadioSelected;

    public BULRBayesFactorSubDlg(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, true);
        this.mIsDistRadioSelected = bl;
        this.setDefaults();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_linear_bayes";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    protected void initVars() {
        this.mNullRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_BULR_BF_NULL_MODEL"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BULRBayesFactorSubDlg.this.onModelRadios();
                BULRBayesFactorSubDlg.this.enableContinue(BULRBayesFactorSubDlg.this.canEnableContinue());
            }
        });
        this.mFullRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_BULR_BF_FULL_MODEL"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BULRBayesFactorSubDlg.this.onModelRadios();
                BULRBayesFactorSubDlg.this.enableContinue(BULRBayesFactorSubDlg.this.canEnableContinue());
            }
        });
        this.mVariableSrcList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mVariableSrcList.setIdentifier(BULR_SRC_VAR_LIST_KEY);
        this.mVariableSrcList.setContextMenuFlags(this.mVariableSrcList.getContextMenuFlags() | 8);
        this.mSrcListLabel = DialogUtil.createLabel(this, "IDS_BULR_BF_AVAIL_VARIABLES");
        this.mSrcListLabel.setLabelFor(this.mVariableSrcList);
        this.mFactorTargetList = new TargetVariableList();
        this.mFactorTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mFactorTargetList.setIdentifier(BULR_BF_FACTOR_TARGET_LIST_KEY);
        this.mFactorTargetLabel = DialogUtil.createLabel(this, "IDS_BULR_BF_FACTOR_TARGET_VARS");
        this.mFactorTargetLabel.setLabelFor(this.mFactorTargetList);
        this.mFactorTargetList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mFactorTargetList.getFixedCellHeight() * 5 + 2));
        this.mFactorTargetList.getModel().addListDataListener(this);
        this.mFactorTargetList.addVarFilter(new SpssVarFilter(4, true, false));
        this.mFactorTargetArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mFactorTargetArrowButton.registerVariableList(this.mVariableSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mFactorTargetArrowButton.registerVariableList(this.mFactorTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mCovTargetList = new TargetVariableList();
        this.mCovTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mCovTargetList.setIdentifier(BULR_BF_COV_TARGET_LIST_KEY);
        this.mCovTargetLabel = DialogUtil.createLabel(this, "IDS_BULR_BF_COV_TARGET_VARS");
        this.mCovTargetLabel.setLabelFor(this.mCovTargetList);
        this.mCovTargetList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mCovTargetList.getFixedCellHeight() * 5 + 2));
        this.mCovTargetList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mCovTargetList.getModel().addListDataListener(this);
        this.mCovTargetArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCovTargetArrowButton.registerVariableList(this.mVariableSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mCovTargetArrowButton.registerVariableList(this.mCovTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mZelinerSiowRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_BULR_BF_ZELINER_SIOW"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BULRBayesFactorSubDlg.this.onComputationRadios();
                BULRBayesFactorSubDlg.this.enableContinue(BULRBayesFactorSubDlg.this.canEnableContinue());
            }
        });
        this.mZelinerRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_BULR_BF_ZELINER"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BULRBayesFactorSubDlg.this.onComputationRadios();
                BULRBayesFactorSubDlg.this.enableContinue(BULRBayesFactorSubDlg.this.canEnableContinue());
            }
        });
        this.mHyperRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_BULR_BF_HYPER"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BULRBayesFactorSubDlg.this.onComputationRadios();
                BULRBayesFactorSubDlg.this.enableContinue(BULRBayesFactorSubDlg.this.canEnableContinue());
            }
        });
        this.mRounderRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_BULR_BF_ROUNDER"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BULRBayesFactorSubDlg.this.onComputationRadios();
                BULRBayesFactorSubDlg.this.enableContinue(BULRBayesFactorSubDlg.this.canEnableContinue());
            }
        });
        this.mGPriorValueLabel = DialogUtil.createLabel(this, "IDS_BULR_BF_GPRIOR_VALUE");
        this.mGPriorValueField = new FloatTextField(0.0, Double.NaN, 5, true);
        this.mGPriorValueField.setIncludeMinRange(false);
        this.mGPriorValueField.setColumns(8);
        this.mGPriorValueField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_BULR_BF_GPRIOR_VALUE"));
        this.mGPriorValueLabel.setLabelFor((Component)this.mGPriorValueField);
        this.mGPriorValueField.getDocument().addDocumentListener(this);
        this.mScaleParamLabel = DialogUtil.createLabel(this, "IDS_INF_SCALE_PARAM");
        this.mScaleParamField = new FloatTextField(0.0, Double.NaN, 5, true);
        this.mScaleParamField.setIncludeMinRange(false);
        this.mScaleParamField.setColumns(8);
        this.mScaleParamField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_INF_SCALE_PARAM"));
        this.mScaleParamLabel.setLabelFor((Component)this.mScaleParamField);
        this.mScaleParamField.getDocument().addDocumentListener(this);
        this.mShapeParamLabel = DialogUtil.createLabel(this, "IDS_INF_SHAPE_PARAM");
        this.mShapeParamField = new FloatTextField(2.0, 4.0, 5, true);
        this.mShapeParamField.setIncludeMinRange(false);
        this.mShapeParamField.setIncludeMaxRange(true);
        this.mShapeParamField.setColumns(8);
        this.mShapeParamField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_INF_SHAPE_PARAM"));
        this.mShapeParamField.getDocument().addDocumentListener(this);
        this.mShapeParamLabel.setLabelFor((Component)this.mShapeParamField);
        this.mNullFullGroup = new SpssButtonGroup();
        this.mNullFullGroup.add(this.mNullRadio);
        this.mNullFullGroup.add(this.mFullRadio);
        this.mCompRadioGroup = new SpssButtonGroup();
        this.mCompRadioGroup.add(this.mZelinerSiowRadio);
        this.mCompRadioGroup.add(this.mZelinerRadio);
        this.mCompRadioGroup.add(this.mHyperRadio);
        this.mCompRadioGroup.add(this.mRounderRadio);
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        int n;
        ISpssVariable iSpssVariable2;
        super.loadState(dialogDataModel);
        ArrayList<ISpssVariable> arrayList = ((BULRStatsDlg)this.mParentDlg).getSrcVariables();
        this.mVariableSrcList.getModel().removeAll();
        VarListModel varListModel = this.mVariableSrcList.getModel();
        for (ISpssVariable iSpssVariable2 : arrayList) {
            varListModel.addElement(iSpssVariable2);
        }
        for (n = this.mFactorTargetList.getModel().getSize() - 1; n >= 0; --n) {
            iSpssVariable2 = this.mFactorTargetList.getModel().getElementAt(n);
            if (!varListModel.contains(iSpssVariable2)) {
                this.mFactorTargetList.getModel().removeElementAt(n);
                continue;
            }
            varListModel.removeElement(iSpssVariable2);
        }
        for (n = this.mCovTargetList.getModel().getSize() - 1; n >= 0; --n) {
            iSpssVariable2 = this.mCovTargetList.getModel().getElementAt(n);
            if (!varListModel.contains(iSpssVariable2)) {
                this.mCovTargetList.getModel().removeElementAt(n);
                continue;
            }
            varListModel.removeElement(iSpssVariable2);
        }
        if (this.mVariableSrcList.getModel().getSize() > 0) {
            this.mVariableSrcList.setSelectedIndex(0);
        }
        this.onEntry();
    }

    public static String getByesFactorSyntax(DialogDataModel dialogDataModel, boolean bl) {
        if (bl) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/ESTBF"));
        Boolean bl2 = dialogDataModel.containsBooleanKey("IDS_BULR_BF_ZELINER_SIOW") ? dialogDataModel.getBoolean("IDS_BULR_BF_ZELINER_SIOW") : true;
        Boolean bl3 = dialogDataModel.containsBooleanKey("IDS_BULR_BF_ZELINER") ? dialogDataModel.getBoolean("IDS_BULR_BF_ZELINER") : false;
        Boolean bl4 = dialogDataModel.containsBooleanKey("IDS_BULR_BF_HYPER") ? dialogDataModel.getBoolean("IDS_BULR_BF_HYPER") : false;
        String string = dialogDataModel.getString("IDS_BULR_BF_GPRIOR_VALUE");
        String string2 = dialogDataModel.getString("IDS_INF_SHAPE_PARAM");
        String string3 = dialogDataModel.getString("IDS_INF_SCALE_PARAM");
        stringBuffer.append(" COMPUTATION=");
        if (bl2.booleanValue()) {
            stringBuffer.append("JZS");
        } else if (bl3.booleanValue()) {
            stringBuffer.append("ZELLNER(");
            stringBuffer.append(string);
            stringBuffer.append(")");
        } else if (bl4.booleanValue()) {
            stringBuffer.append("HYPER(");
            stringBuffer.append(string2 != null && string2.length() > 0 ? string2 : "3");
            stringBuffer.append(")");
        } else {
            stringBuffer.append("ROUDER(");
            stringBuffer.append(string3 != null && string3.length() > 0 ? string3 : "1");
            stringBuffer.append(")");
        }
        Boolean bl5 = dialogDataModel.containsBooleanKey("IDS_BULR_BF_NULL_MODEL") ? dialogDataModel.getBoolean("IDS_BULR_BF_NULL_MODEL") : true;
        stringBuffer.append(" COMPARE=").append(bl5 != false ? "NULL" : "FULL");
        return stringBuffer.toString();
    }

    public static String getAdditonalFactorsOrCovSyntax(DialogDataModel dialogDataModel, VarListModel varListModel, boolean bl, boolean bl2) {
        if (bl) {
            return "";
        }
        Boolean bl3 = dialogDataModel.containsBooleanKey("IDS_BULR_BF_FULL_MODEL") ? dialogDataModel.getBoolean("IDS_BULR_BF_FULL_MODEL") : false;
        String string = "";
        if (bl3.booleanValue()) {
            ISpssVariable[] iSpssVariableArray = bl2 ? dialogDataModel.getVarArray(BULR_BF_FACTOR_TARGET_LIST_KEY) : dialogDataModel.getVarArray(BULR_BF_COV_TARGET_LIST_KEY);
            ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                if (varListModel.contains(iSpssVariable)) continue;
                arrayList.add(iSpssVariable);
            }
            string = BULRStatsDlg.getSyntaxVarString(arrayList.toArray(new ISpssVariable[iSpssVariableArray.length]));
        }
        return string;
    }

    private void setDefaults() {
        this.onEntry();
        this.mNullRadio.setSelected(true);
        this.mZelinerSiowRadio.setSelected(true);
        this.mGPriorValueField.setText("");
        this.mShapeParamField.setText("3");
        this.mScaleParamField.setText("1");
        this.onComputationRadios();
    }

    private void onEntry() {
        this.mNullRadio.setEnabled(!this.mIsDistRadioSelected);
        this.mFullRadio.setEnabled(!this.mIsDistRadioSelected);
        this.onModelRadios();
        this.mZelinerSiowRadio.setEnabled(!this.mIsDistRadioSelected);
        this.mZelinerRadio.setEnabled(!this.mIsDistRadioSelected);
        this.mHyperRadio.setEnabled(!this.mIsDistRadioSelected);
        this.mRounderRadio.setEnabled(!this.mIsDistRadioSelected);
        this.onComputationRadios();
    }

    private void setupPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = this.createModelPanel();
        JPanel jPanel3 = this.createCompPanel();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 2;
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
    }

    private JPanel createModelPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_BULR_BF_MODEL_GROUP")));
        JPanel jPanel2 = this.createVarListPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 2;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mNullRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mFullRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        Insets insets2 = (Insets)insets.clone();
        insets2.left += 20;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel createVarListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 16;
        DialogUtil.addUsingGBL(jPanel, this.mSrcListLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mVariableSrcList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setPreferredSize(this.mVariableSrcList.getMinimumSize());
        n = 23;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 3, n, insets);
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets3 = new Insets(0, insets2.left, 0, insets2.right);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mFactorTargetArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.5;
        n = 23;
        gridBagConstraints.fill = 2;
        Insets insets4 = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mFactorTargetLabel, gridBagConstraints, 2, 0, 1, 1, n, insets4);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.weightx = 0.5;
        JScrollPane jScrollPane2 = new JScrollPane(this.mFactorTargetList);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setVerticalScrollBarPolicy(20);
        jScrollPane2.setPreferredSize(this.mFactorTargetList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 1, n, insets);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mCovTargetArrowButton, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mCovTargetLabel, gridBagConstraints, 2, 2, 1, 1, n, insets4);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        JScrollPane jScrollPane3 = new JScrollPane(this.mCovTargetList);
        jScrollPane3.setHorizontalScrollBarPolicy(31);
        jScrollPane3.setVerticalScrollBarPolicy(20);
        jScrollPane3.setPreferredSize(this.mCovTargetList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane3, gridBagConstraints, 2, 3, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createCompPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_BULR_BF_COMPUTATION_GROUP")));
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = (Insets)insets.clone();
        insets2.left += 20;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mZelinerSiowRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mZelinerRadio, gridBagConstraints, 0, 2, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mGPriorValueLabel, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mGPriorValueField, gridBagConstraints, 1, 3, 1, 1, n, insets);
        Insets insets3 = (Insets)insets.clone();
        insets3.left += 10;
        Insets insets4 = (Insets)insets2.clone();
        insets4.left += 10;
        DialogUtil.addUsingGBL(jPanel, this.mHyperRadio, gridBagConstraints, 2, 0, 2, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mShapeParamLabel, gridBagConstraints, 2, 1, 1, 1, n, insets4);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mShapeParamField, gridBagConstraints, 3, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mRounderRadio, gridBagConstraints, 2, 2, 2, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mScaleParamLabel, gridBagConstraints, 2, 3, 1, 1, n, insets4);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mScaleParamField, gridBagConstraints, 3, 3, 1, 1, n, insets);
        return jPanel;
    }

    private void onComputationRadios() {
        boolean bl = this.mZelinerRadio.isEnabled() && this.mZelinerRadio.isSelected();
        this.mGPriorValueLabel.setEnabled(bl);
        this.mGPriorValueField.setEnabled(bl);
        boolean bl2 = this.mHyperRadio.isEnabled() && this.mHyperRadio.isSelected();
        this.mShapeParamLabel.setEnabled(bl2);
        this.mShapeParamField.setEnabled(bl2);
        boolean bl3 = this.mRounderRadio.isEnabled() && this.mRounderRadio.isSelected();
        this.mScaleParamLabel.setEnabled(bl3);
        this.mScaleParamField.setEnabled(bl3);
    }

    private void onModelRadios() {
        boolean bl = !this.mIsDistRadioSelected && this.mFullRadio.isSelected();
        this.mSrcListLabel.setEnabled(bl);
        this.mVariableSrcList.setEnabled(bl);
        this.mFactorTargetLabel.setEnabled(bl);
        this.mFactorTargetList.setEnabled(bl);
        this.mCovTargetLabel.setEnabled(bl);
        this.mCovTargetList.setEnabled(bl);
        this.mFactorTargetArrowButton.setEnabled(bl);
        this.mCovTargetArrowButton.setEnabled(bl);
    }

    private boolean canEnableContinue() {
        boolean bl;
        boolean bl2 = bl = !this.mFullRadio.isEnabled() || !this.mFullRadio.isSelected() || this.mFactorTargetList.getModel().getSize() > 0 || this.mCovTargetList.getModel().getSize() > 0;
        if (bl) {
            if (this.mZelinerRadio.isSelected()) {
                bl = this.mGPriorValueField.getText().length() > 0;
            } else if (this.mHyperRadio.isSelected()) {
                bl = this.mShapeParamField.getText().length() > 0;
            } else if (this.mRounderRadio.isSelected()) {
                bl = this.mScaleParamField.getText().length() > 0;
            }
        }
        return bl;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mNullFullGroup);
        vector.add(this.mVariableSrcList);
        vector.add(this.mFactorTargetArrowButton);
        vector.add(this.mCovTargetArrowButton);
        vector.add(this.mFactorTargetList);
        vector.add(this.mCovTargetList);
        vector.add(this.mCompRadioGroup);
        vector.add(this.mGPriorValueField);
        vector.add(this.mShapeParamField);
        vector.add(this.mScaleParamField);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }
}

