/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.uitools.controls.FloatTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BPPriorsSubDlg
extends BaseSubDialog
implements DocumentListener {
    private static final String PRIORS_SHAPE_PARAM = "IDS_INF_SHAPE_PARAM";
    private static final String PRIORS_SCALE_PARAM = "IDS_INF_SCALE_PARAM";
    private JLabel mShapeParamLabel;
    private FloatTextField mShapeParamField;
    private JLabel mScaleParamLabel;
    private FloatTextField mScaleParamField;

    public BPPriorsSubDlg(BaseProcedureDialog baseProcedureDialog, String string) {
        super(baseProcedureDialog, string, true);
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_onesample_binomialpoisson_priors";
    }

    @Override
    public boolean continuePressed() {
        double d = Double.parseDouble(this.mShapeParamField.getText());
        double d2 = Double.parseDouble(this.mScaleParamField.getText());
        if (d == 0.0 && d2 == 0.0) {
            return true;
        }
        if (d == 0.0 || d2 == 0.0) {
            JOptionPane.showMessageDialog((Component)((Object)this), this.getResString("ERR_PRIORS_ZEROPARAM"), VersionInfo.getAppVersionString(), 1);
            return false;
        }
        return true;
    }

    public static String getBPPriorsDlgSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" TYPE=CONJUGATE");
        String string = dialogDataModel.getString(PRIORS_SHAPE_PARAM);
        String string2 = dialogDataModel.getString(PRIORS_SCALE_PARAM);
        stringBuffer.append("(");
        stringBuffer.append(string != null && string.length() > 0 ? string : "2");
        stringBuffer.append(" ");
        stringBuffer.append(string2 != null && string2.length() > 0 ? string2 : "2").append(")");
        return stringBuffer.toString();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.setDefaults();
        this.addListeners();
        this.pack();
        this.setFocusTraversalPolicy();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mShapeParamField);
        vector.add(this.mScaleParamField);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setupPanel(JPanel jPanel) {
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_NORMAL_PRIORS_GROUP_TITLE")));
        JPanel jPanel2 = this.createPriorsPanel();
        jPanel.add((Component)jPanel2, "Center");
    }

    protected void initVars() {
        this.mShapeParamField = new FloatTextField(0.0, Double.NaN, 2, true);
        this.mShapeParamField.setIncludeMaxRange(false);
        this.mShapeParamField.setAction((Action)new TextFieldAction(this.mParentDlg, PRIORS_SHAPE_PARAM));
        this.mShapeParamField.setColumns(10);
        this.mScaleParamField = new FloatTextField(0.0, Double.NaN, 2, true);
        this.mScaleParamField.setIncludeMaxRange(false);
        this.mScaleParamField.setAction((Action)new TextFieldAction(this.mParentDlg, PRIORS_SCALE_PARAM));
        this.mScaleParamField.setColumns(10);
    }

    private void addListeners() {
        this.mShapeParamField.getDocument().addDocumentListener(this);
        this.mScaleParamField.getDocument().addDocumentListener(this);
    }

    private void setDefaults() {
        this.mShapeParamField.setText("2");
        this.mScaleParamField.setText("2");
    }

    private JPanel createPriorsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        this.mShapeParamLabel = DialogUtil.createLabel(this, PRIORS_SHAPE_PARAM);
        this.mShapeParamLabel.setLabelFor((Component)this.mShapeParamField);
        DialogUtil.addUsingGBL(jPanel, this.mShapeParamLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mShapeParamField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.mScaleParamLabel = DialogUtil.createLabel(this, PRIORS_SCALE_PARAM);
        this.mScaleParamLabel.setLabelFor((Component)this.mScaleParamField);
        DialogUtil.addUsingGBL(jPanel, this.mScaleParamLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mScaleParamField, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private boolean canEnableContinue() {
        return this.mShapeParamField.getText().length() > 0 && this.mScaleParamField.getText().length() > 0;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }
}

