/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.CoreFrequencies;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.AnovaBayesFactorSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.AnovaPlotsSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BULRCriteriaSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BULRPriorsSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.ScanBaseDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class AnovaStatsDlg
extends ScanBaseDlg
implements ListDataListener {
    static final String ANOVA_DEP_VAR_LIST = "IDS_ANOVA_DEP_VAR_LIST";
    static final String ANOVA_FACTOR_LIST = "IDS_ANOVA_FACTOR_LIST";
    static final String ANOVA_WEIGHT_LIST = "IDS_ANOVA_WEIGHT_LIST";
    private ArrowButton mDepVarListArrow;
    private ArrowButton mFactorListArrow;
    private ArrowButton mWeightVarListArrow;
    private TargetVariableList mDepVarList;
    private TargetVariableList mFactorList;
    private TargetVariableList mWeightVarList;

    public AnovaStatsDlg(JFrame jFrame) {
        super(jFrame);
        this.setTitle(this.getResString("IDS_ONEWAY_ANOVA_TITLE"));
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    @Override
    public String generateSyntax() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("BAYES")).append(" ANOVA ");
        stringBuffer.append(this.mDepVarList.getVariablesStringList());
        String string = this.mFactorList.getVariablesStringList();
        if (string.length() > 0) {
            stringBuffer.append(" BY ");
            stringBuffer.append(string);
        }
        stringBuffer.append("\n");
        this.addBayesianBodySyntax(stringBuffer, dialogDataModel);
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    protected void addBayesianBodySyntax(StringBuffer stringBuffer, DialogDataModel dialogDataModel) {
        stringBuffer.append(BULRCriteriaSubDlg.getCriteriaDlgSyntax(dialogDataModel, this.mDistributionRadio.isSelected()));
        String string = this.mFactorList.getVariablesStringList();
        String string2 = this.mWeightVarList.getVariablesStringList();
        if (string2.length() > 0) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/DESIGN"));
            if (string2.length() > 0) {
                stringBuffer.append(" REGWGT=").append(string2);
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append(SyntaxUtil.getSubCommand("/INFERENCE"));
        String string3 = "";
        Boolean bl = dialogDataModel.getBoolean("IDS_BAYES_FACTOR");
        Boolean bl2 = dialogDataModel.getBoolean("IDS_USE_BOTH");
        string3 = bl != null && bl != false ? "BAYESFACTOR" : (bl2 != null && bl2 != false ? "BOTH" : "POSTERIOR");
        stringBuffer.append(" ANALYSIS=").append(string3);
        stringBuffer.append(BULRPriorsSubDlg.getPriorsDlgSyntax(dialogDataModel, this.mBayesFactorRadio.isSelected()));
        stringBuffer.append(AnovaBayesFactorSubDlg.getByesFactorSyntax(dialogDataModel, this.mDistributionRadio.isSelected()));
        stringBuffer.append(AnovaPlotsSubDlg.getPlotsSyntax(dialogDataModel, this.mBayesFactorRadio.isSelected()));
    }

    @Override
    public String getIActionKey() {
        return "analyze_bayesian_oneway_anova";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_anova";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mDepVarList.getModel().getSize() > 0 && this.mFactorList.getModel().getSize() > 0);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mDepVarList.getModel().getSize() > 0 && this.mFactorList.getModel().getSize() > 0);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    protected void setDefaults() {
        super.setDefaults();
        this.mDepVarList.removeAll();
        this.mFactorList.removeAll();
        this.mWeightVarList.removeAll();
        this.enableOkPaste(false);
    }

    @Override
    protected void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.setIdentifier("IDS_ANOVA_SRC_VAR_LIST");
        this.mDistributionRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_DISTRIBUTION"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnovaStatsDlg.this.onAnalysisRadio();
            }
        });
        this.mBayesFactorRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_BAYES_FACTOR"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnovaStatsDlg.this.onAnalysisRadio();
            }
        });
        this.mUseBothRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_USE_BOTH"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnovaStatsDlg.this.onAnalysisRadio();
            }
        });
        this.mAnalysisGroup = new SpssButtonGroup();
        this.mAnalysisGroup.add(this.mDistributionRadio);
        this.mAnalysisGroup.add(this.mBayesFactorRadio);
        this.mAnalysisGroup.add(this.mUseBothRadio);
        this.mDepVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mDepVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mDepVarList.getModel().addListDataListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.mDepVarList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setPreferredSize(this.mDepVarList.getMinimumSize());
        this.mDepVarList.setIdentifier(ANOVA_DEP_VAR_LIST);
        this.mDepVarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mFactorList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mFactorList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mFactorList.getModel().addListDataListener(this);
        JScrollPane jScrollPane2 = new JScrollPane(this.mFactorList);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setVerticalScrollBarPolicy(21);
        jScrollPane2.setPreferredSize(this.mFactorList.getMinimumSize());
        this.mFactorList.setIdentifier(ANOVA_FACTOR_LIST);
        this.mFactorList.addVarFilter(new SpssVarFilter(4, true, false));
        this.mWeightVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mWeightVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        JScrollPane jScrollPane3 = new JScrollPane(this.mWeightVarList);
        jScrollPane3.setHorizontalScrollBarPolicy(31);
        jScrollPane3.setVerticalScrollBarPolicy(21);
        jScrollPane3.setPreferredSize(this.mWeightVarList.getMinimumSize());
        this.mWeightVarList.setIdentifier(ANOVA_WEIGHT_LIST);
        this.mWeightVarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mDepVarListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mDepVarListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mDepVarListArrow.registerVariableList(this.mDepVarList, SpssArrowButton.ButtonOrientation.left);
        this.mFactorListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mFactorListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mFactorListArrow.registerVariableList(this.mFactorList, SpssArrowButton.ButtonOrientation.left);
        this.mWeightVarListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mWeightVarListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mWeightVarListArrow.registerVariableList(this.mWeightVarList, SpssArrowButton.ButtonOrientation.left);
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void setupPanel(JPanel jPanel) {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_BULR_DEPENDENT_VARIABLE");
        jLabel.setLabelFor(this.mDepVarList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_FACTOR_COLON");
        jLabel2.setLabelFor(this.mFactorList);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_BULR_WEIGHT");
        jLabel3.setLabelFor(this.mWeightVarList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 18;
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_BAYESIAN_SOURCE_LABEL");
        jLabel4.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(new Dimension(160, 100));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 8, n, insets);
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets3 = new Insets(0, insets2.left, 0, insets2.right);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mDepVarListArrow, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.5;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        JScrollPane jScrollPane2 = new JScrollPane(this.mDepVarList);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setVerticalScrollBarPolicy(21);
        jScrollPane2.setPreferredSize(this.mDepVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 1, n, null);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mFactorListArrow, gridBagConstraints, 1, 3, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.5;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.5;
        JScrollPane jScrollPane3 = new JScrollPane(this.mFactorList);
        jScrollPane3.setHorizontalScrollBarPolicy(31);
        jScrollPane3.setVerticalScrollBarPolicy(21);
        jScrollPane3.setPreferredSize(this.mFactorList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane3, gridBagConstraints, 2, 3, 1, 1, n, null);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mWeightVarListArrow, gridBagConstraints, 1, 5, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.5;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 4, 1, 1, n, insets);
        JScrollPane jScrollPane4 = new JScrollPane(this.mWeightVarList);
        jScrollPane4.setHorizontalScrollBarPolicy(31);
        jScrollPane4.setVerticalScrollBarPolicy(21);
        jScrollPane4.setPreferredSize(this.mDepVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane4, gridBagConstraints, 2, 5, 1, 1, n, null);
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = this.createAnalysisPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 2, 6, 1, 1, n, insets);
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = this.createSideButtonPanel(true);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_ONEWAY_ANOVA_PLOTS_BTN"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnovaStatsDlg.this.onPlotsButton();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        Insets insets = DialogUtil.getStandardButtonInsets();
        int n = insets.top + insets.bottom;
        jPanel.add(Box.createVerticalStrut(n));
        jPanel.add(jButton);
        return jPanel;
    }

    @Override
    protected ArrayList<ISpssVariable> getScanVariables() {
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        for (int i = 0; i < this.mFactorList.getModel().getSize(); ++i) {
            arrayList.add(this.mFactorList.getModel().getElementAt(i));
        }
        return arrayList;
    }

    @Override
    protected void onCriteriaButton() {
        this.runSubDialog(new BULRCriteriaSubDlg(this, this.getResString("IDS_ONEWAY_ANOVA_CRITERIA_TITLE"), this.mDistributionRadio.isSelected(), "idh_bayesian_anova_criteria"));
    }

    @Override
    protected void onBayesFactorButton() {
        new AnovaBayesFactorSubDlg(this, this.getResString("IDS_ONEWAY_ANOVA_BF_TITLE"), this.mDistributionRadio.isSelected());
    }

    @Override
    protected void onPriorsButton() {
        this.mScanVariables = this.getScanVariables();
        if (this.mScanVariables.size() == 0 || !this.needScanning(this.mFactorList.getModel(), null)) {
            new BULRPriorsSubDlg(this, this.getResString("IDS_ONEWAY_ANOVA_PRIORS_TITLE"), this.mBayesFactorRadio.isSelected(), this.mFactorList.getModel(), null, true, "idh_bayesian_anova_priors");
            return;
        }
        this.performScanning(this);
        do {
            System.out.println("Proceeding Scanning......");
        } while (!this.mScanFinished);
        System.out.println("mScanFinished - 1");
        new BULRPriorsSubDlg(this, this.getResString("IDS_ONEWAY_ANOVA_PRIORS_TITLE"), this.mBayesFactorRadio.isSelected(), this.mFactorList.getModel(), null, true);
        this.mScanFinished = false;
    }

    protected void onPlotsButton() {
        this.mScanVariables = this.getScanVariables();
        if (this.mScanVariables.size() == 0 || !this.needScanning(this.mFactorList.getModel(), null)) {
            new AnovaPlotsSubDlg(this, this.getResString("IDS_ONEWAY_ANOVA_PLOTS_TITLE"), this.mBayesFactorRadio.isSelected(), this.mFactorList.getModel());
            return;
        }
        this.performScanning(this);
        do {
            System.out.println("Proceeding Scanning......");
        } while (!this.mScanFinished);
        System.out.println("mScanFinished - 1");
        new AnovaPlotsSubDlg(this, this.getResString("IDS_ONEWAY_ANOVA_PLOTS_TITLE"), this.mBayesFactorRadio.isSelected(), this.mFactorList.getModel());
        this.mScanFinished = false;
    }

    @Override
    public void finishedScanning(CoreFrequencies coreFrequencies) {
        super.finishedScanning(coreFrequencies);
        this.mScanFinished = true;
    }

    @Override
    protected boolean okPastePressed() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = !this.mBayesFactorRadio.isSelected() && dialogDataModel.containsBooleanKey("IDS_BULR_PRIORS_CONJUGATE") ? dialogDataModel.getBoolean("IDS_BULR_PRIORS_CONJUGATE") : false;
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray("IDS_PRIORS_FACTOR_MODEL_KEY");
        ISpssVariable[] iSpssVariableArray2 = dialogDataModel.getVarArray("ANOVA_PLOTS_FACTOR_VAR_ARRAY_KEY");
        if (bl.booleanValue() && this.isScanVarModelChanged(iSpssVariableArray, this.mFactorList.getModel())) {
            JOptionPane.showMessageDialog((Component)((Object)this), this.getResString("ERR_MSG_PRIOR_DETECT_CHANGE"), VersionInfo.getAppVersionString(), 1);
            dialogDataModel.putBoolean("IDS_BULR_PRIORS_CONJUGATE", false);
            dialogDataModel.putObject("IDS_PRIORS_MEAN_TABLE_VECTOR", null);
            dialogDataModel.putObject("IDS_PRIORS_VCM_TABLE_VECTOR", null);
        }
        if (this.isScanVarModelChanged(iSpssVariableArray2, this.mFactorList.getModel())) {
            dialogDataModel.putObject("IDS_ANOVA_PLOTS_TABLE_VECTOR_KEY", null);
        }
        return super.okPastePressed();
    }

    @Override
    protected void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mDepVarListArrow);
        vector.add(this.mDepVarList);
        vector.add(this.mFactorListArrow);
        vector.add(this.mFactorList);
        vector.add(this.mWeightVarListArrow);
        vector.add(this.mWeightVarList);
        vector.add(this.mAnalysisGroup);
        int n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }
}

