/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BULRPriorsSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.BayesianBaseDlg;
import com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats.ScanBaseDlg;
import com.spss.java_client.ui.dialogs.base.data.define_var_properties.ScannedVariable;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class AnovaPlotsSubDlg
extends BaseSubDialog {
    private static final String ANOVA_PLOTS_TABLE_VECTOR_KEY = "IDS_ANOVA_PLOTS_TABLE_VECTOR_KEY";
    public static final String ANOVA_PLOTS_FACTOR_VAR_ARRAY_KEY = "ANOVA_PLOTS_FACTOR_VAR_ARRAY_KEY";
    private JLabel mPlotCatsTableLabel;
    private BayesianBaseDlg.BaseTable mPlotCatsTable;
    private JCheckBox mVarianceETCheck;
    private boolean mIsBayesFactorSelected;
    private VarListModel mFactorsModel;
    private ScanBaseDlg mScanBaseDlg;
    private Vector mPlotVector;

    public AnovaPlotsSubDlg(BaseProcedureDialog baseProcedureDialog, String string, boolean bl, VarListModel varListModel) {
        super(baseProcedureDialog, string, true);
        this.mIsBayesFactorSelected = bl;
        this.mFactorsModel = varListModel;
        this.mScanBaseDlg = (ScanBaseDlg)this.mParentDlg;
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.setDefaults();
        this.pack();
        this.setFocusTraversalPolicy();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_anova_plots";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
    }

    protected void initVars() {
        this.mVarianceETCheck = new JCheckBox(new ToggleButtonAction(this, "IDS_ONEWAY_ANOVA_PLOTS_VARIANCE_ERROR_TERMS"));
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        this.mPlotVector = (Vector)dialogDataModel.getObject(ANOVA_PLOTS_TABLE_VECTOR_KEY);
        if (this.mPlotVector != null && this.mPlotCatsTable != null) {
            this.mPlotCatsTable.reloadTable(this.mPlotVector);
        }
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        dialogDataModel.putVarArray(ANOVA_PLOTS_FACTOR_VAR_ARRAY_KEY, BULRPriorsSubDlg.getVarArray(this.mFactorsModel));
        if (this.mPlotCatsTable != null) {
            this.mPlotVector = ((DefaultTableModel)this.mPlotCatsTable.getModel()).getDataVector();
            dialogDataModel.putObject(ANOVA_PLOTS_TABLE_VECTOR_KEY, this.mPlotVector);
        }
        return super.saveState(dialogDataModel);
    }

    private JPanel createPlotTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.mPlotCatsTableLabel = DialogUtil.createLabel(this, "IDS_ONEWAY_ANOVA_PLOTS_TABLE_LABEL");
        Object[] objectArray = this.getResStringArray("IDS_ONEWAY_ANOVA_PLOTS_COLUMN_NAMES");
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, 0){

            @Override
            public Class<?> getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }
        };
        this.mPlotCatsTable = new PlotsTable(defaultTableModel);
        this.mPlotCatsTableLabel.setLabelFor(this.mPlotCatsTable);
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        if (this.mFactorsModel != null) {
            int n = this.mFactorsModel.getSize();
            for (int i = 0; i < n; ++i) {
                arrayList.add(this.mFactorsModel.getElementAt(i));
            }
        }
        for (ISpssVariable iSpssVariable : arrayList) {
            ScannedVariable scannedVariable = this.mScanBaseDlg.findScannedVariable(iSpssVariable);
            ArrayList<String> arrayList2 = this.mScanBaseDlg.getCatsList(scannedVariable);
            for (String string : arrayList2) {
                defaultTableModel.addRow(new Object[]{string, false});
            }
        }
        JScrollPane jScrollPane = new JScrollPane(this.mPlotCatsTable);
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        this.mPlotCatsTableLabel.setLabelFor(this.mPlotCatsTable);
        jPanel.add((Component)this.mPlotCatsTableLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        if (this.mPlotCatsTable.getRowCount() > 0) {
            this.mPlotCatsTable.setRowSelectionInterval(0, 0);
        }
        return jPanel;
    }

    public static String getPlotsSyntax(DialogDataModel dialogDataModel, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            return "";
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/PLOT"));
        Boolean bl2 = dialogDataModel.containsBooleanKey("IDS_ONEWAY_ANOVA_PLOTS_VARIANCE_ERROR_TERMS") ? dialogDataModel.getBoolean("IDS_ONEWAY_ANOVA_PLOTS_VARIANCE_ERROR_TERMS") : false;
        String string = AnovaPlotsSubDlg.getPlotTableSyntaxValues(dialogDataModel);
        if (string.length() > 0) {
            stringBuffer.append(" MEANS=").append(string);
        }
        stringBuffer.append(" ERRORVAR=").append(bl2 != false ? "TRUE" : "FALSE");
        return stringBuffer.toString();
    }

    private static String getPlotTableSyntaxValues(DialogDataModel dialogDataModel) {
        Vector vector = (Vector)dialogDataModel.getObject(ANOVA_PLOTS_TABLE_VECTOR_KEY);
        if (vector == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            String string;
            int n;
            Vector vector2 = (Vector)vector.get(i);
            boolean bl = (Boolean)vector2.get(1);
            if (bl && (n = (string = (String)vector2.get(0)).lastIndexOf(58)) > -1) {
                stringBuffer.append(string.substring(n + 1));
            }
            stringBuffer.append(" ");
        }
        return stringBuffer.toString().trim();
    }

    private void setDefaults() {
        this.mVarianceETCheck.setSelected(false);
        boolean bl = !this.mIsBayesFactorSelected;
        this.mPlotCatsTableLabel.setEnabled(bl);
        this.mPlotCatsTable.setEnabled(bl);
        this.mVarianceETCheck.setEnabled(bl);
        if (this.mPlotVector != null && this.mPlotVector.size() > 0) {
            this.mPlotVector.clear();
        }
    }

    private void setupPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = this.createPlotTablePanel();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 2;
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mVarianceETCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mPlotCatsTable);
        vector.add(this.mVarianceETCheck);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    class PlotsTable
    extends BayesianBaseDlg.BaseTable {
        PlotsTable(TableModel tableModel) {
            super(tableModel);
            this.setupColumns();
            JTableHeader jTableHeader = this.getTableHeader();
            jTableHeader.setReorderingAllowed(false);
            jTableHeader.setDefaultRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    JLabel jLabel = null;
                    jLabel = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? (JLabel)super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (n2 == 1) {
                        jLabel.setHorizontalAlignment(0);
                    } else {
                        jLabel.setHorizontalAlignment(2);
                    }
                    jLabel.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                    jLabel.setBackground(jTable.getTableHeader().getBackground());
                    jLabel.setForeground(jTable.getTableHeader().getForeground());
                    return jLabel;
                }
            });
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return !AnovaPlotsSubDlg.this.mIsBayesFactorSelected && n2 == 1;
        }

        private void setupColumns() {
            TableColumn tableColumn = this.columnModel.getColumn(0);
            BayesianBaseDlg.VarLabelRenderer varLabelRenderer = new BayesianBaseDlg.VarLabelRenderer();
            tableColumn.setCellRenderer(varLabelRenderer);
            tableColumn.setPreferredWidth(50);
            tableColumn.setMinWidth(40);
            TableColumn tableColumn2 = this.columnModel.getColumn(1);
            tableColumn2.setCellRenderer(new BayesianBaseDlg.CheckBoxCellRenderer());
            tableColumn2.setPreferredWidth(50);
            tableColumn2.setMinWidth(50);
        }
    }
}

