/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.bayesian_stats;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class AnovaBayesFactorSubDlg
extends BaseSubDialog
implements ListDataListener,
DocumentListener {
    private JRadioButton mZelinerSiowRadio;
    private JRadioButton mZelinerRadio;
    private JRadioButton mHyperRadio;
    private JRadioButton mRounderRadio;
    private SpssButtonGroup mCompRadioGroup;
    private JLabel mGPriorValueLabel;
    private FloatTextField mGPriorValueField;
    private JLabel mScaleParamLabel;
    private FloatTextField mScaleParamField;
    private JLabel mShapeParamLabel;
    private FloatTextField mShapeParamField;
    private boolean mIsDistRadioSelected;

    public AnovaBayesFactorSubDlg(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, true);
        this.mIsDistRadioSelected = bl;
        this.setDefaults();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_bayesian_anova_bayes";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    protected void initVars() {
        this.mZelinerSiowRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_BULR_BF_ZELINER_SIOW"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnovaBayesFactorSubDlg.this.onComputationRadios();
                AnovaBayesFactorSubDlg.this.enableContinue(AnovaBayesFactorSubDlg.this.canEnableContinue());
            }
        });
        this.mZelinerRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_BULR_BF_ZELINER"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnovaBayesFactorSubDlg.this.onComputationRadios();
                AnovaBayesFactorSubDlg.this.enableContinue(AnovaBayesFactorSubDlg.this.canEnableContinue());
            }
        });
        this.mHyperRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_BULR_BF_HYPER"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnovaBayesFactorSubDlg.this.onComputationRadios();
                AnovaBayesFactorSubDlg.this.enableContinue(AnovaBayesFactorSubDlg.this.canEnableContinue());
            }
        });
        this.mRounderRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_BULR_BF_ROUNDER"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnovaBayesFactorSubDlg.this.onComputationRadios();
                AnovaBayesFactorSubDlg.this.enableContinue(AnovaBayesFactorSubDlg.this.canEnableContinue());
            }
        });
        this.mGPriorValueLabel = DialogUtil.createLabel(this, "IDS_BULR_BF_GPRIOR_VALUE");
        this.mGPriorValueField = new FloatTextField(0.0, Double.NaN, 5, true);
        this.mGPriorValueField.setIncludeMinRange(false);
        this.mGPriorValueField.setColumns(8);
        this.mGPriorValueField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_BULR_BF_GPRIOR_VALUE"));
        this.mGPriorValueLabel.setLabelFor((Component)this.mGPriorValueField);
        this.mGPriorValueField.getDocument().addDocumentListener(this);
        this.mScaleParamLabel = DialogUtil.createLabel(this, "IDS_INF_SCALE_PARAM");
        this.mScaleParamField = new FloatTextField(0.0, Double.NaN, 5, true);
        this.mScaleParamField.setIncludeMinRange(false);
        this.mScaleParamField.setColumns(8);
        this.mScaleParamField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_ANOVA_BF_SCALE_PARAM"));
        this.mScaleParamLabel.setLabelFor((Component)this.mScaleParamField);
        this.mScaleParamField.getDocument().addDocumentListener(this);
        this.mShapeParamLabel = DialogUtil.createLabel(this, "IDS_INDEPT_FACTOR_SHAPE");
        this.mShapeParamField = new FloatTextField(2.0, 4.0, 5, true);
        this.mShapeParamField.setIncludeMinRange(false);
        this.mShapeParamField.setIncludeMaxRange(true);
        this.mShapeParamField.setColumns(8);
        this.mShapeParamField.setAction((Action)new TextFieldAction(this.mParentDlg, "IDS_ANOVA_BF_SHAPE_PARAM"));
        this.mShapeParamField.getDocument().addDocumentListener(this);
        this.mShapeParamLabel.setLabelFor((Component)this.mShapeParamField);
        this.mCompRadioGroup = new SpssButtonGroup();
        this.mCompRadioGroup.add(this.mZelinerSiowRadio);
        this.mCompRadioGroup.add(this.mZelinerRadio);
        this.mCompRadioGroup.add(this.mHyperRadio);
        this.mCompRadioGroup.add(this.mRounderRadio);
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        this.onEntry();
    }

    public static String getByesFactorSyntax(DialogDataModel dialogDataModel, boolean bl) {
        if (bl) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/ESTBF"));
        Boolean bl2 = dialogDataModel.containsBooleanKey("IDS_BULR_BF_ZELINER_SIOW") ? dialogDataModel.getBoolean("IDS_BULR_BF_ZELINER_SIOW") : true;
        Boolean bl3 = dialogDataModel.containsBooleanKey("IDS_BULR_BF_ZELINER") ? dialogDataModel.getBoolean("IDS_BULR_BF_ZELINER") : false;
        Boolean bl4 = dialogDataModel.containsBooleanKey("IDS_BULR_BF_HYPER") ? dialogDataModel.getBoolean("IDS_BULR_BF_HYPER") : false;
        String string = dialogDataModel.getString("IDS_BULR_BF_GPRIOR_VALUE");
        String string2 = dialogDataModel.getString("IDS_ANOVA_BF_SHAPE_PARAM");
        String string3 = dialogDataModel.getString("IDS_ANOVA_BF_SCALE_PARAM");
        stringBuffer.append(" COMPUTATION=");
        if (bl2.booleanValue()) {
            stringBuffer.append("JZS");
        } else if (bl3.booleanValue()) {
            stringBuffer.append("ZELLNER(");
            stringBuffer.append(string);
            stringBuffer.append(")");
        } else if (bl4.booleanValue()) {
            stringBuffer.append("HYPER(");
            stringBuffer.append(string2 != null && string2.length() > 0 ? string2 : "3");
            stringBuffer.append(")");
        } else {
            stringBuffer.append("ROUDER(");
            stringBuffer.append(string3 != null && string3.length() > 0 ? string3 : "1");
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private void setDefaults() {
        this.onEntry();
        this.mZelinerSiowRadio.setSelected(true);
        this.mGPriorValueField.setText("");
        this.mShapeParamField.setText("3");
        this.mScaleParamField.setText("1");
        this.onComputationRadios();
    }

    private void onEntry() {
        this.mZelinerSiowRadio.setEnabled(!this.mIsDistRadioSelected);
        this.mZelinerRadio.setEnabled(!this.mIsDistRadioSelected);
        this.mHyperRadio.setEnabled(!this.mIsDistRadioSelected);
        this.mRounderRadio.setEnabled(!this.mIsDistRadioSelected);
        this.onComputationRadios();
    }

    private void setupPanel(JPanel jPanel) {
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = this.createCompPanel();
        jPanel.add((Component)jPanel2, "Center");
    }

    private JPanel createCompPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_BULR_BF_COMPUTATION_GROUP")));
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = (Insets)insets.clone();
        insets2.left += 20;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mZelinerSiowRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mZelinerRadio, gridBagConstraints, 0, 2, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mGPriorValueLabel, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mGPriorValueField, gridBagConstraints, 1, 3, 1, 1, n, insets);
        Insets insets3 = (Insets)insets.clone();
        insets3.left += 10;
        Insets insets4 = (Insets)insets2.clone();
        insets4.left += 10;
        DialogUtil.addUsingGBL(jPanel, this.mHyperRadio, gridBagConstraints, 2, 0, 2, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mShapeParamLabel, gridBagConstraints, 2, 1, 1, 1, n, insets4);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mShapeParamField, gridBagConstraints, 3, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mRounderRadio, gridBagConstraints, 2, 2, 2, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mScaleParamLabel, gridBagConstraints, 2, 3, 1, 1, n, insets4);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mScaleParamField, gridBagConstraints, 3, 3, 1, 1, n, insets);
        return jPanel;
    }

    private void onComputationRadios() {
        boolean bl = this.mZelinerRadio.isEnabled() && this.mZelinerRadio.isSelected();
        this.mGPriorValueLabel.setEnabled(bl);
        this.mGPriorValueField.setEnabled(bl);
        boolean bl2 = this.mHyperRadio.isEnabled() && this.mHyperRadio.isSelected();
        this.mShapeParamLabel.setEnabled(bl2);
        this.mShapeParamField.setEnabled(bl2);
        boolean bl3 = this.mRounderRadio.isEnabled() && this.mRounderRadio.isSelected();
        this.mScaleParamLabel.setEnabled(bl3);
        this.mScaleParamField.setEnabled(bl3);
    }

    private boolean canEnableContinue() {
        boolean bl = true;
        if (this.mZelinerRadio.isSelected()) {
            bl = this.mGPriorValueField.getText().length() > 0;
        } else if (this.mHyperRadio.isSelected()) {
            bl = this.mShapeParamField.getText().length() > 0;
        } else if (this.mRounderRadio.isSelected()) {
            bl = this.mScaleParamField.getText().length() > 0;
        }
        return bl;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mCompRadioGroup);
        vector.add(this.mGPriorValueField);
        vector.add(this.mShapeParamField);
        vector.add(this.mScaleParamField);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }
}

