/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.font.TextAttribute;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class RenameDlg
extends BaseDialog {
    protected JTextField mNameEdit;
    private StatsHelp.Book mHelpMode;
    private String mHelpID;
    private String mDefaultName;
    private boolean mOkPressed = true;

    public RenameDlg(SpssFrame spssFrame, String string, String string2, String string3, StatsHelp.Book book, String string4) throws HeadlessException {
        super((JFrame)spssFrame, true, ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), CommonDlgResBundle.getImageFolder());
        this.mHelpMode = book;
        this.mHelpID = string4;
        this.mDefaultName = string3 != null ? string3 : "";
        this.setTitle(this.getResString(string));
        this.setLocationRelativeTo(this.getParent());
        this.init(string2);
    }

    protected void init() {
    }

    protected void init(String string) {
        super.init();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(0, 0, 0, 0);
        JLabel jLabel = new JLabel(this.getResString(string), 10);
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            jLabel.setDisplayedMnemonic(this.getDlgAccessKey(string + "_KEY"));
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mNameEdit = new JTextField();
        Dimension dimension = new Dimension(280, 22);
        this.mNameEdit.setPreferredSize(dimension);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mNameEdit, gridBagConstraints, 0, 1, 1, 1, n, new Insets(5, 0, 0, 0));
        jLabel.setLabelFor(this.mNameEdit);
        if (ComponentState.isBtdRtlOrLtr()) {
            if (this.mNameEdit.getDocument() != null) {
                if (ComponentState.getBTD() == 1) {
                    this.mNameEdit.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                } else {
                    this.mNameEdit.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                }
            }
            this.mNameEdit.setText(ComponentState.prepareStringForBidiRendering((String)this.mDefaultName));
        } else {
            this.mNameEdit.setText(this.mDefaultName);
        }
        this.mNameEdit.setCaretPosition(0);
        this.mNameEdit.moveCaretPosition(this.mDefaultName.length());
        this.pack();
    }

    public boolean okPastePressed(boolean bl) {
        if (ComponentState.isBtdRtlOrLtr() && this.mNameEdit.getText() != null && this.mNameEdit.getText().length() > 0) {
            return this.validateName(ComponentState.removeBidiDirectionMarks((String)this.mNameEdit.getText()));
        }
        return this.validateName(this.mNameEdit.getText());
    }

    public void doOkPaste(boolean bl) {
        this.mOkPressed = true;
    }

    public boolean isOk() {
        return this.mOkPressed;
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        OKAction oKAction = new OKAction();
        JButton jButton = new JButton(oKAction);
        JButton jButton2 = new JButton(new CancelAction());
        JButton jButton3 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton3);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton3, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(jButton2);
                jPanel.add(jButton3);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton3);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(jButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    public boolean validateName(String string) {
        return string.length() > 0;
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(this.mHelpMode, this.mHelpID);
    }

    public String getNewName() {
        if (ComponentState.isBtdRtlOrLtr() && this.mNameEdit.getText() != null && this.mNameEdit.getText().length() > 0) {
            return ComponentState.removeBidiDirectionMarks((String)this.mNameEdit.getText());
        }
        return this.mNameEdit.getText();
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RenameDlg.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RenameDlg.this.dispose();
        }
    }

    class PasteButtonAction
    extends AbstractAction {
        PasteButtonAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_PASTE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (RenameDlg.this.okPastePressed(false)) {
                RenameDlg.this.doOkPaste(false);
                RenameDlg.this.dispose();
            }
        }
    }

    class OKAction
    extends AbstractAction {
        OKAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (RenameDlg.this.okPastePressed(true)) {
                RenameDlg.this.doOkPaste(true);
                RenameDlg.this.dispose();
            }
        }
    }
}

