/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.variance_comp;

import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.DatasetNameValidator;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class VarianceCompsSave
extends BaseSubDialog
implements ItemListener,
DocumentListener,
FocusListener {
    static final String VAR_COMP_EST_CHECK = "IDS_GLM_VC_SAVE_EST_CHECK";
    static final String COMP_COVAR = "IDS_GLM_VC_SAVE_COMP_COV_CHECK";
    static final String COV_MATRIX = "IDS_GLM_VC_SAVE_COV_MAT_RADIO";
    static final String COR_MATRIX = "IDS_GLM_VC_SAVE_COR_MAT_RADIO";
    static final String CREATE_NEW_DATASET = "IDS_GLM_VC_SAVE_CREATE_NEW_DATASET_RADIO";
    static final String WRITE_NEW_DATAFILE = "IDS_GLM_VC_SAVE_WRITE_NEW_DATA_FILE_RADIO";
    static final String FILE_PATH = "IDS_FILE_PATH";
    static final String FILE_BUTTON = "IDS_GLM_VC_SAVE_FILE_BUTTON";
    static final String DESTIN_VAL = "IDS_GLM_VC_SAVE_DEST_FOR_VAL_LABEL";
    static final String DATASET_NAME_LABEL = "IDS_GLM_VC_SAVE_DATASET_NAME";
    static final String DATASET_NAME_TEXT = "IDS_DATASET_NAME_TEXT";
    private JCheckBox mVarCompEstCheck;
    private JCheckBox mCompCovarCheck;
    private JRadioButton mCovMatrixRadio;
    private JRadioButton mCorMatrixRadio;
    private JLabel mDestinValLabel;
    private JLabel mDataSetNameLabel;
    private FileTextField mFilePathText;
    private JTextField mDatasetNameText;
    private JButton mFileButton;
    private JRadioButton mCreateNewDataSetRadio;
    private JRadioButton mWriteNewDataFileRadio;
    private SpssButtonGroup mDataButtonGroup;
    private SpssButtonGroup mMatrixButtonGroup;
    private SpssButtonGroup mCompButtonGroup;

    public VarianceCompsSave(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_GLM_VC_SAVE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_varc_save";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mCreateNewDataSetRadio) {
            this.setDestinationEnabled(true, true, false);
            this.mWriteNewDataFileRadio.setEnabled(true);
            this.mCreateNewDataSetRadio.requestFocusInWindow();
        } else if (object == this.mWriteNewDataFileRadio) {
            this.setDestinationEnabled(true, false, true);
            this.mCreateNewDataSetRadio.setEnabled(true);
            this.mWriteNewDataFileRadio.requestFocusInWindow();
        }
        this.setContinueEnabled();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setContinueEnabled();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setContinueEnabled();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.setContinueEnabled();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        JTextField jTextField = (JTextField)focusEvent.getSource();
        jTextField.setSelectionStart(0);
        jTextField.setSelectionEnd(jTextField.getText().length());
    }

    public void paint(Graphics graphics) {
        this.mFilePathText.setText(this.mFilePathText.getText());
        super.paint(graphics);
        super.validate();
    }

    @Override
    public boolean continuePressed() {
        if (this.mDatasetNameText.isEnabled()) {
            return this.isValidDatasetName();
        }
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        this.setDefaults();
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(this.setTabTraversal(), false));
        this.pack();
    }

    protected void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, VAR_COMP_EST_CHECK){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (VarianceCompsSave.this.mVarCompEstCheck.isSelected()) {
                    VarianceCompsSave.this.setDestinationEnabled(true, true, true);
                } else if (!VarianceCompsSave.this.mCompCovarCheck.isEnabled() || !VarianceCompsSave.this.mCompCovarCheck.isSelected()) {
                    VarianceCompsSave.this.setDestinationEnabled(false, false, false);
                }
                VarianceCompsSave.this.setContinueEnabled();
            }
        };
        this.mVarCompEstCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, COMP_COVAR){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (VarianceCompsSave.this.mCompCovarCheck.isSelected()) {
                    VarianceCompsSave.this.mCovMatrixRadio.setEnabled(true);
                    VarianceCompsSave.this.mCorMatrixRadio.setEnabled(true);
                    VarianceCompsSave.this.setDestinationEnabled(true, true, true);
                } else {
                    VarianceCompsSave.this.mCovMatrixRadio.setEnabled(false);
                    VarianceCompsSave.this.mCorMatrixRadio.setEnabled(false);
                    if (!VarianceCompsSave.this.mVarCompEstCheck.isSelected()) {
                        VarianceCompsSave.this.setDestinationEnabled(false, false, false);
                    }
                }
                VarianceCompsSave.this.setContinueEnabled();
            }
        };
        this.mCompCovarCheck = new JCheckBox(toggleButtonAction);
        this.mCompButtonGroup = new SpssButtonGroup();
        this.mCompButtonGroup.add(this.mVarCompEstCheck);
        this.mCompButtonGroup.add(this.mCompCovarCheck);
        toggleButtonAction = new ToggleButtonAction(this, COV_MATRIX);
        this.mCovMatrixRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, COR_MATRIX);
        this.mCorMatrixRadio = new JRadioButton(toggleButtonAction);
        this.mMatrixButtonGroup = new SpssButtonGroup();
        this.mMatrixButtonGroup.add(this.mCovMatrixRadio);
        this.mMatrixButtonGroup.add(this.mCorMatrixRadio);
        this.mDestinValLabel = new JLabel(this.getResString(DESTIN_VAL));
        toggleButtonAction = new ToggleButtonAction(this, CREATE_NEW_DATASET);
        this.mCreateNewDataSetRadio = new JRadioButton(toggleButtonAction);
        this.mCreateNewDataSetRadio.addItemListener(this);
        this.mDataSetNameLabel = DialogUtil.createLabel(this, DATASET_NAME_LABEL);
        this.mDatasetNameText = new StringTextField(14);
        this.mDatasetNameText.setAction(new TextFieldAction(this, DATASET_NAME_TEXT));
        this.mDatasetNameText.setEnabled(false);
        this.mDatasetNameText.setPreferredSize((Dimension)this.mDatasetNameText.getPreferredSize().clone());
        this.mDataSetNameLabel.setLabelFor(this.mDatasetNameText);
        this.mDatasetNameText.getDocument().addDocumentListener(this);
        this.mDatasetNameText.addFocusListener(this);
        toggleButtonAction = new ToggleButtonAction(this, WRITE_NEW_DATAFILE);
        this.mWriteNewDataFileRadio = new JRadioButton(toggleButtonAction);
        this.mWriteNewDataFileRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, FILE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VarianceCompsSave.this.showSaveDialog();
            }
        };
        this.mFileButton = new JButton(toggleButtonAction);
        this.mFileButton.setEnabled(false);
        this.mFilePathText = new FileTextField();
        this.mFilePathText.setAction(new TextFieldAction(this, FILE_PATH));
        this.mDataButtonGroup = new SpssButtonGroup();
        this.mDataButtonGroup.add(this.mCreateNewDataSetRadio);
        this.mDataButtonGroup.add(this.mWriteNewDataFileRadio);
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        if (this.mVarCompEstCheck.isSelected()) {
            this.setDestinationEnabled(true, true, true);
            this.enableContinue(this.mDatasetNameText.isEnabled() && this.mDatasetNameText.getText().length() > 0 || this.mFilePathText.isEnabled() && this.mFilePathText.getText().length() > 0);
        } else {
            this.setDestinationEnabled(false, false, false);
        }
        Boolean bl = dialogDataModel.getBoolean("IDS_GLM_VC_OPTIONS_MAX_LIKELIHOOD_RADIO");
        Boolean bl2 = dialogDataModel.getBoolean("IDS_GLM_VC_OPTIONS_RES_MAX_LIKELIHOOD_RADIO");
        if (bl != null && bl.booleanValue() || bl2 != null && bl2.booleanValue()) {
            this.mCompCovarCheck.setEnabled(true);
        }
        if (this.mCompCovarCheck.isEnabled() && this.mCompCovarCheck.isSelected()) {
            this.mCovMatrixRadio.setEnabled(true);
            this.mCorMatrixRadio.setEnabled(true);
            this.setDestinationEnabled(true, true, true);
            this.enableContinue(this.mDatasetNameText.isEnabled() && this.mDatasetNameText.getText().length() > 0 || this.mFilePathText.isEnabled() && this.mFilePathText.getText().length() > 0);
        } else if (this.mCompCovarCheck.isEnabled() && !this.mCompCovarCheck.isSelected() && !this.mVarCompEstCheck.isSelected()) {
            this.mCovMatrixRadio.setEnabled(false);
            this.mCorMatrixRadio.setEnabled(false);
            this.setDestinationEnabled(false, false, false);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VarianceCompsSave.this.mVarCompEstCheck.requestFocusInWindow();
            }
        });
    }

    private void setDefaults() {
        this.mCompCovarCheck.setEnabled(false);
        this.mCovMatrixRadio.setSelected(true);
        this.mCovMatrixRadio.setEnabled(false);
        this.mCorMatrixRadio.setEnabled(false);
        this.mCreateNewDataSetRadio.setSelected(true);
        this.mFilePathText.setBorder(BorderFactory.createEmptyBorder());
        this.mFilePathText.setEditable(false);
        this.mFilePathText.setText("");
        this.setDestinationEnabled(false, false, false);
        this.enableContinue(true);
    }

    private void setContinueEnabled() {
        if (!this.mVarCompEstCheck.isSelected() && !this.mCompCovarCheck.isSelected()) {
            this.enableContinue(true);
        } else if (this.mFilePathText.isEnabled() && this.mFilePathText.getText().length() > 0) {
            this.enableContinue(true);
        } else {
            this.enableContinue(false);
            if (this.mDatasetNameText.isEnabled()) {
                if (this.mDatasetNameText.getText().length() > 0) {
                    this.enableContinue(true);
                } else {
                    this.enableContinue(false);
                }
            }
        }
    }

    private void addComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mVarCompEstCheck, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCompCovarCheck, gridBagConstraints, 0, 1, 2, 1, n, insets);
        Insets insets2 = new Insets(insets.top, insets.left * 13, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mCovMatrixRadio, gridBagConstraints, 0, 2, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mCorMatrixRadio, gridBagConstraints, 0, 3, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mDestinValLabel, gridBagConstraints, 0, 4, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCreateNewDataSetRadio, gridBagConstraints, 0, 5, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets2.set(insets.top, insets.left * 7, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mDataSetNameLabel, gridBagConstraints, 0, 6, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mDatasetNameText, gridBagConstraints, 1, 6, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mWriteNewDataFileRadio, gridBagConstraints, 0, 7, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mFileButton, gridBagConstraints, 0, 8, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFilePathText), gridBagConstraints, 1, 8, 1, 1, n, insets);
    }

    private void showSaveDialog() {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        remoteFileChooser.setDialogTitle(this.getResString("IDS_GLM_VC_SAVE_FILE_CHOOSER_TITLE"));
        remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(this.getResString("IDS_GLM_VC_SAVE_FILE_FILTER_DESC"), this.getResString("IDS_GLM_VC_SAVE_FILE_EXTENSION")));
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        int n = remoteFileChooser.showSaveDialog((Component)((Object)this));
        if (n == 0) {
            String string = remoteFileChooser.getSelectedFilePath();
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            if (!string.endsWith(this.getResString("IDS_GLM_VC_SAVE_FILE_EXTENSION"))) {
                string = string + this.getResString("IDS_GLM_VC_SAVE_FILE_EXTENSION");
            }
            this.mFilePathText.setText(string);
            this.enableContinue(true);
        }
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mVarCompEstCheck);
        vector.add(this.mCompCovarCheck);
        vector.add(this.mMatrixButtonGroup);
        vector.add(this.mDataButtonGroup);
        vector.add(this.mDatasetNameText);
        vector.add(this.mFileButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void setDestinationEnabled(boolean bl, boolean bl2, boolean bl3) {
        this.mDestinValLabel.setEnabled(bl);
        this.mCreateNewDataSetRadio.setEnabled(bl2);
        if (bl2 && this.mCreateNewDataSetRadio.isSelected()) {
            this.mDataSetNameLabel.setEnabled(true);
            this.mDatasetNameText.setEnabled(true);
            this.mDatasetNameText.setOpaque(true);
        } else {
            this.mDataSetNameLabel.setEnabled(false);
            this.mDatasetNameText.setEnabled(false);
            this.mDatasetNameText.setOpaque(false);
        }
        this.mWriteNewDataFileRadio.setEnabled(bl3);
        if (bl3 && this.mWriteNewDataFileRadio.isSelected()) {
            this.mFileButton.setEnabled(true);
            this.mFilePathText.setEnabled(true);
            this.mFilePathText.setOpaque(true);
        } else {
            this.mFileButton.setEnabled(false);
            this.mFilePathText.setEnabled(false);
            this.mFilePathText.setOpaque(false);
        }
    }

    private boolean isValidDatasetName() {
        boolean bl = false;
        if (this.mDatasetNameText.getText().length() > 0) {
            if (DatasetNameValidator.validateDatasetName((String)this.mDatasetNameText.getText(), (Component)((Object)this)) == 1) {
                bl = true;
            }
            this.mDatasetNameText.selectAll();
            this.mDatasetNameText.requestFocus();
        } else {
            bl = false;
        }
        return bl;
    }
}

