/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.variance_comp;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.ContextEnabledTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class VarianceCompsOptions
extends BaseSubDialog
implements ItemListener,
DocumentListener,
FocusListener {
    static final String MINQUE_RADIO = "IDS_GLM_VC_OPTIONS_MINQUE_RADIO";
    static final String ANOVA_RADIO = "IDS_GLM_VC_OPTIONS_ANOVA_RADIO";
    static final String MAX_LIKELIHOOD_RADIO = "IDS_GLM_VC_OPTIONS_MAX_LIKELIHOOD_RADIO";
    static final String RES_MAX_LIKELIHOOD_RADIO = "IDS_GLM_VC_OPTIONS_RES_MAX_LIKELIHOOD_RADIO";
    static final String UNIFORM_RADIO = "IDS_GLM_VC_OPTIONS_UNIFORM_RADIO";
    static final String ZERO_RADIO = "IDS_GLM_VC_OPTIONS_ZERO_RADIO";
    static final String TYPE_I_RADIO = "IDS_GLM_VC_OPTIONS_TYPE_I_RADIO";
    static final String TYPE_III_RADIO = "IDS_GLM_VC_OPTIONS_TYPE_III_RADIO";
    static final String CONVERGENCE_LABEL = "IDS_GLM_VC_OPTIONS_CONVERGENCE_LABEL";
    static final String MAX_ITERATIONS_LABEL = "IDS_GLM_VC_OPTIONS_MAX_ITERATIONS_LABEL";
    static final String SUM_OF_SQUARES_CHECK = "IDS_GLM_VC_OPTIONS_SUM_OF_SQ_CHECK";
    static final String EXPECTED_MEAN_SQUARES_CHECK = "IDS_GLM_VC_OPTIONS_EXPECTED_MEAN_SQ_CHECK";
    static final String ITERATION_HISTORY_CHECK = "IDS_GLM_VC_OPTIONS_ITERATION_HISTORY_CHECK";
    static final String IN_STEPS_OF_LABEL = "IDS_GLM_VC_OPTIONS_IN_STEPS_OF_LABEL";
    static final String MAX_ITERATIONS_TEXT = "IDS_MAX_ITERATIONS_TEXT";
    static final String IN_STEPS_OF_TEXT = "IDS_IN_STEPS_OF_TEXT";
    static final String CONVERGENCE_COMBO = "IDS_CONVERGENCE_COMBO";
    static final int TEXT_FIELD_WIDTH = 2;
    static final int CONVERGENCE_INDEX = 2;
    static final String MAX_ITERATION_TEXT_DEFAULT = "50";
    static final String IN_STEPS_OF_TEXT_DEFAULT = "1";
    private JRadioButton mMinqueRadio;
    private JRadioButton mAnovaRadio;
    private JRadioButton mMaxLikelihoodRadio;
    private JRadioButton mResMaxLikelihoodRadio;
    private ButtonGroup mMethodButtonGroup;
    private JRadioButton mUniformRadio;
    private JRadioButton mZeroRadio;
    private ButtonGroup mRandEffButtonGroup;
    private JRadioButton mTypeIRadio;
    private JRadioButton mTypeIIIRadio;
    private ButtonGroup mSumOfSquaresButtonGroup;
    private JLabel mConvergenceLabel;
    private JComboBox mConvergenceCombo;
    private JLabel mMaxIterationsLabel;
    private ContextEnabledTextField mMaxIterationsText;
    private JCheckBox mSumOfSquaresCheck;
    private JCheckBox mExpectedMeanSquaresCheck;
    private JCheckBox mIterationHistoryCheck;
    private JLabel mInStepsOfLabel;
    private ContextEnabledTextField mInStepsOfText;
    private JPanel mMethodPanel;
    private JPanel mRandEffPriorsPanel;
    private JPanel mSumOfSquaresPanel;
    private JPanel mCriteriaPanel;
    private JPanel mDisplayPanel;

    public VarianceCompsOptions(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_GLM_VC_OPTIONS"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_varc_opt";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mMinqueRadio) {
            this.setComponentEnableState(this.mRandEffPriorsPanel, true);
            this.setComponentEnableState(this.mCriteriaPanel, false);
            this.mMaxIterationsText.setOpaque(false);
            this.setComponentEnableState(this.mSumOfSquaresPanel, false);
            this.setComponentEnableState(this.mDisplayPanel, false);
        } else if (object == this.mAnovaRadio) {
            this.setComponentEnableState(this.mRandEffPriorsPanel, false);
            this.setComponentEnableState(this.mCriteriaPanel, false);
            this.mMaxIterationsText.setOpaque(false);
            this.setComponentEnableState(this.mSumOfSquaresPanel, true);
            this.setComponentEnableState(this.mDisplayPanel, true);
            this.mIterationHistoryCheck.setEnabled(false);
            this.mInStepsOfLabel.setEnabled(false);
            this.mInStepsOfText.setEnabled(false);
            this.mInStepsOfText.setOpaque(false);
        } else if (object == this.mMaxLikelihoodRadio || object == this.mResMaxLikelihoodRadio) {
            this.setComponentEnableState(this.mRandEffPriorsPanel, false);
            this.setComponentEnableState(this.mSumOfSquaresPanel, false);
            this.setComponentEnableState(this.mCriteriaPanel, true);
            this.mMaxIterationsText.setOpaque(true);
            this.setComponentEnableState(this.mDisplayPanel, true);
            this.mSumOfSquaresCheck.setEnabled(false);
            this.mExpectedMeanSquaresCheck.setEnabled(false);
            this.mIterationHistoryCheck.setEnabled(true);
            this.mInStepsOfLabel.setEnabled(this.mIterationHistoryCheck.isSelected());
            this.mInStepsOfText.setEnabled(this.mIterationHistoryCheck.isSelected());
            this.mInStepsOfText.setOpaque(this.mIterationHistoryCheck.isSelected());
        }
        this.setContinueEnabled();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setContinueEnabled();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setContinueEnabled();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.setContinueEnabled();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        JTextField jTextField = (JTextField)focusEvent.getSource();
        jTextField.setSelectionStart(0);
        jTextField.setSelectionEnd(jTextField.getText().length());
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        this.setDefaults();
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(this.setTabTraversal(), false));
        this.pack();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        if (this.mMaxIterationsText.isEnabled() && Integer.parseInt(this.mMaxIterationsText.getText()) == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_GLM_VC_OPTIONS_TEXT_OUT_OF_RANGE_WARNING"), VersionInfo.getAppVersionString());
            this.mMaxIterationsText.requestFocus();
            return false;
        }
        if (this.mInStepsOfText.isEnabled() && Integer.parseInt(this.mInStepsOfText.getText()) == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_GLM_VC_OPTIONS_TEXT_OUT_OF_RANGE_WARNING"), VersionInfo.getAppVersionString());
            this.mInStepsOfText.requestFocus();
            return false;
        }
        return super.saveState(dialogDataModel);
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        if (this.mIterationHistoryCheck.isEnabled() && this.mIterationHistoryCheck.isSelected()) {
            this.mInStepsOfLabel.setEnabled(true);
            this.mInStepsOfText.setEnabled(true);
            this.mInStepsOfText.setOpaque(true);
        }
    }

    protected void initVars() {
        ControlAction controlAction = new ToggleButtonAction(this, MINQUE_RADIO);
        this.mMinqueRadio = new JRadioButton(controlAction);
        this.mMinqueRadio.addItemListener(this);
        controlAction = new ToggleButtonAction(this, ANOVA_RADIO);
        this.mAnovaRadio = new JRadioButton(controlAction);
        this.mAnovaRadio.addItemListener(this);
        controlAction = new ToggleButtonAction(this, MAX_LIKELIHOOD_RADIO);
        this.mMaxLikelihoodRadio = new JRadioButton(controlAction);
        this.mMaxLikelihoodRadio.addItemListener(this);
        controlAction = new ToggleButtonAction(this, RES_MAX_LIKELIHOOD_RADIO);
        this.mResMaxLikelihoodRadio = new JRadioButton(controlAction);
        this.mResMaxLikelihoodRadio.addItemListener(this);
        this.mMethodButtonGroup = new ButtonGroup();
        this.mMethodButtonGroup.add(this.mMinqueRadio);
        this.mMethodButtonGroup.add(this.mAnovaRadio);
        this.mMethodButtonGroup.add(this.mMaxLikelihoodRadio);
        this.mMethodButtonGroup.add(this.mResMaxLikelihoodRadio);
        controlAction = new ToggleButtonAction(this, UNIFORM_RADIO);
        this.mUniformRadio = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this, ZERO_RADIO);
        this.mZeroRadio = new JRadioButton(controlAction);
        this.mRandEffButtonGroup = new ButtonGroup();
        this.mRandEffButtonGroup.add(this.mUniformRadio);
        this.mRandEffButtonGroup.add(this.mZeroRadio);
        controlAction = new ToggleButtonAction(this, TYPE_I_RADIO);
        this.mTypeIRadio = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this, TYPE_III_RADIO);
        this.mTypeIIIRadio = new JRadioButton(controlAction);
        this.mSumOfSquaresButtonGroup = new ButtonGroup();
        this.mSumOfSquaresButtonGroup.add(this.mTypeIRadio);
        this.mSumOfSquaresButtonGroup.add(this.mTypeIIIRadio);
        this.mConvergenceLabel = DialogUtil.createLabel(this, CONVERGENCE_LABEL);
        this.mConvergenceCombo = new JComboBox<String>(this.setupConvergenceItems());
        this.mConvergenceCombo.setAction(new ComboboxAction(this, CONVERGENCE_COMBO));
        this.mConvergenceLabel.setLabelFor(this.mConvergenceCombo);
        this.mMaxIterationsLabel = DialogUtil.createLabel(this, MAX_ITERATIONS_LABEL);
        this.mMaxIterationsText = new ContextEnabledTextField();
        this.mMaxIterationsText.setDocument((Document)new FixedLengthNumericDocument(3, true, false));
        this.mMaxIterationsText.setColumns(2);
        controlAction = new TextFieldAction(this, MAX_ITERATIONS_TEXT);
        this.mMaxIterationsText.setAction((Action)controlAction);
        this.mMaxIterationsLabel.setLabelFor((Component)this.mMaxIterationsText);
        this.mMaxIterationsText.getDocument().addDocumentListener(this);
        this.mMaxIterationsText.addFocusListener((FocusListener)this);
        controlAction = new ToggleButtonAction(this, SUM_OF_SQUARES_CHECK);
        this.mSumOfSquaresCheck = new JCheckBox(controlAction);
        controlAction = new ToggleButtonAction(this, EXPECTED_MEAN_SQUARES_CHECK);
        this.mExpectedMeanSquaresCheck = new JCheckBox(controlAction);
        controlAction = new ToggleButtonAction(this, ITERATION_HISTORY_CHECK){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (VarianceCompsOptions.this.mIterationHistoryCheck.isSelected()) {
                    VarianceCompsOptions.this.mInStepsOfLabel.setEnabled(true);
                    VarianceCompsOptions.this.mInStepsOfText.setEnabled(true);
                    VarianceCompsOptions.this.mInStepsOfText.setOpaque(true);
                } else {
                    VarianceCompsOptions.this.mInStepsOfLabel.setEnabled(false);
                    VarianceCompsOptions.this.mInStepsOfText.setEnabled(false);
                    VarianceCompsOptions.this.mInStepsOfText.setOpaque(false);
                }
                VarianceCompsOptions.this.setContinueEnabled();
            }
        };
        this.mIterationHistoryCheck = new JCheckBox(controlAction);
        this.mInStepsOfLabel = DialogUtil.createLabel(this, IN_STEPS_OF_LABEL);
        this.mInStepsOfText = new ContextEnabledTextField();
        this.mInStepsOfText.setDocument((Document)new FixedLengthNumericDocument(2, true, false));
        this.mInStepsOfText.setColumns(2);
        controlAction = new TextFieldAction(this, IN_STEPS_OF_TEXT);
        this.mInStepsOfText.setAction((Action)controlAction);
        this.mInStepsOfLabel.setLabelFor((Component)this.mInStepsOfText);
        this.mInStepsOfText.getDocument().addDocumentListener(this);
        this.mInStepsOfText.addFocusListener((FocusListener)this);
    }

    private void setDefaults() {
        this.mMinqueRadio.setSelected(true);
        this.mUniformRadio.setSelected(true);
        this.mTypeIRadio.setSelected(true);
        this.mConvergenceCombo.setSelectedIndex(2);
        this.mMaxIterationsText.setText(MAX_ITERATION_TEXT_DEFAULT);
        this.mInStepsOfText.setText(IN_STEPS_OF_TEXT_DEFAULT);
        this.setComponentEnableState(this.mMethodPanel, true);
        this.setComponentEnableState(this.mRandEffPriorsPanel, true);
        this.setComponentEnableState(this.mCriteriaPanel, false);
        this.setComponentEnableState(this.mSumOfSquaresPanel, false);
        this.setComponentEnableState(this.mDisplayPanel, false);
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mMethodButtonGroup);
        vector.add(this.mRandEffButtonGroup);
        vector.add(this.mSumOfSquaresButtonGroup);
        vector.add(this.mConvergenceCombo);
        vector.add(this.mMaxIterationsText);
        vector.add(this.mSumOfSquaresCheck);
        vector.add(this.mExpectedMeanSquaresCheck);
        vector.add(this.mIterationHistoryCheck);
        vector.add(this.mInStepsOfText);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private JPanel setupMethodPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_GLM_VC_OPTIONS_METHOD_PANEL")));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mMinqueRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mAnovaRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        Insets insets2 = new Insets(insets.top, insets.left * 30, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mMaxLikelihoodRadio, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mResMaxLikelihoodRadio, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupRandomEffectPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_GLM_VC_OPTIONS_RAND_EFF_PRIOR_PANEL")));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mUniformRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mZeroRadio, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupSumOfSquaresPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_GLM_VC_OPTIONS_SUM_OF_SQUARES_PANEL")));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mTypeIRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        Insets insets2 = new Insets(insets.top, insets.left * 5, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mTypeIIIRadio, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupCriteriaPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_GLM_VC_OPTIONS_CRITERIA_PANEL")));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mConvergenceLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        Insets insets2 = new Insets(insets.left * 10, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mMaxIterationsLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mConvergenceCombo, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        insets2.set(insets2.top, insets2.left * 10, insets2.bottom, insets2.right);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxIterationsText, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupDisplayPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_GLM_VC_OPTIONS_DISPLAY_PANEL")));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mSumOfSquaresCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mExpectedMeanSquaresCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        Insets insets2 = new Insets(insets.top, insets.left * 20, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mIterationHistoryCheck, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        n = 24;
        insets2.set(insets2.top * 5, insets2.left, insets2.bottom, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.mInStepsOfLabel, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mInStepsOfText, gridBagConstraints, 2, 1, 1, 1, n, insets);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private void addComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        this.mMethodPanel = this.setupMethodPanel();
        DialogUtil.addUsingGBL(jPanel, this.mMethodPanel, gridBagConstraints, 0, 0, 2, 1, n, null);
        this.mRandEffPriorsPanel = this.setupRandomEffectPanel();
        DialogUtil.addUsingGBL(jPanel, this.mRandEffPriorsPanel, gridBagConstraints, 0, 1, 1, 1, n, null);
        this.mSumOfSquaresPanel = this.setupSumOfSquaresPanel();
        DialogUtil.addUsingGBL(jPanel, this.mSumOfSquaresPanel, gridBagConstraints, 0, 2, 1, 1, n, null);
        this.mCriteriaPanel = this.setupCriteriaPanel();
        DialogUtil.addUsingGBL(jPanel, this.mCriteriaPanel, gridBagConstraints, 1, 1, 1, 2, n, null);
        this.mDisplayPanel = this.setupDisplayPanel();
        DialogUtil.addUsingGBL(jPanel, this.mDisplayPanel, gridBagConstraints, 0, 3, 2, 1, n, null);
    }

    private String[] setupConvergenceItems() {
        String[] stringArray = new String[]{this.getResString("IDS_GLM_VC_OPTIONS_CONV+1"), this.getResString("IDS_GLM_VC_OPTIONS_CONV+2"), this.getResString("IDS_GLM_VC_OPTIONS_CONV+3"), this.getResString("IDS_GLM_VC_OPTIONS_CONV+4"), this.getResString("IDS_GLM_VC_OPTIONS_CONV+5")};
        return stringArray;
    }

    private void setContinueEnabled() {
        if (this.mMaxIterationsText.isEnabled()) {
            if (this.mMaxIterationsText.getText().length() > 0) {
                if (this.mIterationHistoryCheck.isSelected()) {
                    if (this.mInStepsOfText.getText().length() > 0) {
                        this.enableContinue(true);
                    } else {
                        this.enableContinue(false);
                    }
                } else {
                    this.enableContinue(true);
                }
            } else {
                this.enableContinue(false);
            }
        } else {
            this.enableContinue(true);
        }
    }
}

