/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.variance_comp;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.adv_stats.res.AdvStatsResBundle;
import com.spss.java_client.ui.dialogs.adv_stats.variance_comp.VarianceCompsModel;
import com.spss.java_client.ui.dialogs.adv_stats.variance_comp.VarianceCompsOptions;
import com.spss.java_client.ui.dialogs.adv_stats.variance_comp.VarianceCompsSave;
import com.spss.java_client.ui.dialogs.common.AbstractModelSubDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class VarianceCompsDlg
extends BaseProcedureDialog
implements ListDataListener {
    static final String DEP_VAR_LIST = "IDS_DEP_VAR_LIST";
    static final String FIX_FACTOR_LIST = "IDS_FIX_FACTOR_LIST";
    static final String RAND_FACTOR_LIST = "IDS_RAND_FACTOR_LIST";
    static final String COVARIATE_LIST = "IDS_COVARIATE_LIST";
    static final String WLSWEIGHT_LIST = "IDS_WLSWEIGHT_LIST";
    static final String MODEL_BUTTON = "IDS_COMMON_MODEL_BUTTON";
    static final String OPTIONS_BUTTON = "IDS_COMMON_OPTIONS_3DOT";
    static final String SAVE_BUTTON = "IDS_COMMON_SAVE_BUTTON";
    static final String FULL_FAC_RADIO = "IDS_GLM_VC_MODEL_FULL_FACTORIAL_RADIO";
    private ArrowButton mDepVarListArrow;
    private ArrowButton mFixFactorListArrow;
    private ArrowButton mRandFactorListArrow;
    private ArrowButton mCovarListArrow;
    private ArrowButton mWlsWtListArrow;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mDepVarList;
    private TargetVariableList mFixFactorList;
    private TargetVariableList mRandFactorList;
    private TargetVariableList mCovarList;
    private TargetVariableList mWlsWtList;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mDepVarListScroll;
    private JScrollPane mFixScrollPane;
    private JScrollPane mRandScrollPane;
    private JScrollPane mCovarScrollPane;
    private JScrollPane mWlsWtListScroll;
    private JButton mModelButton;
    private String mModelListString;

    public VarianceCompsDlg(JFrame jFrame) {
        super(jFrame, false, AdvStatsResBundle.getDefaultResourceBundleName(), AdvStatsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_GLM_VC"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public final String getIActionKey() {
        return "analyze_gen_linear_var_components";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_varc";
    }

    @Override
    public String generateSyntax() {
        String string;
        String[] stringArray;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.delete(0, stringBuffer.length());
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append(SyntaxUtil.getMainCommand("VARCOMP"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mDepVarList.getVariablesStringList()));
        stringBuffer.append(" BY " + this.mRandFactorList.getVariablesStringList());
        stringBuffer.append(" " + this.mFixFactorList.getVariablesStringList());
        if (this.mCovarList.getModel().getSize() > 0) {
            stringBuffer.append(" WITH " + this.mCovarList.getVariablesStringList());
        }
        stringBuffer.append("\n");
        if (this.mWlsWtList.getModel().getSize() > 0) {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("REGWGT", this.mWlsWtList.getVariablesStringList(), true));
        }
        stringBuffer.append(SyntaxUtil.getSubCommand("/RANDOM="));
        stringBuffer.append(this.mRandFactorList.getVariablesStringList() + "\n");
        Boolean bl = dialogDataModel.getBoolean("IDS_GLM_VC_OPTIONS_MINQUE_RADIO");
        Boolean bl2 = dialogDataModel.getBoolean("IDS_GLM_VC_OPTIONS_MAX_LIKELIHOOD_RADIO");
        Boolean bl3 = dialogDataModel.getBoolean("IDS_GLM_VC_OPTIONS_RES_MAX_LIKELIHOOD_RADIO");
        Boolean bl4 = dialogDataModel.getBoolean("IDS_GLM_VC_OPTIONS_ANOVA_RADIO");
        Boolean bl5 = dialogDataModel.getBoolean("IDS_GLM_VC_SAVE_EST_CHECK");
        Boolean bl6 = dialogDataModel.getBoolean("IDS_GLM_VC_SAVE_COMP_COV_CHECK");
        Boolean bl7 = dialogDataModel.getBoolean("IDS_GLM_VC_SAVE_CREATE_NEW_DATASET_RADIO");
        Boolean bl8 = dialogDataModel.getBoolean("IDS_GLM_VC_SAVE_WRITE_NEW_DATA_FILE_RADIO");
        Boolean bl9 = dialogDataModel.getBoolean("IDS_GLM_VC_SAVE_COV_MAT_RADIO");
        Boolean bl10 = dialogDataModel.getBoolean("IDS_GLM_VC_SAVE_COR_MAT_RADIO");
        String string2 = "";
        String string3 = "";
        if (bl5 != null && bl5.booleanValue()) {
            string2 = string2 + "VAREST ";
        }
        if ((bl2 != null && bl2.booleanValue() || bl3 != null && bl3.booleanValue()) && bl6 != null && bl6.booleanValue()) {
            if (bl9 != null && bl9.booleanValue()) {
                string2 = string2 + "COVB ";
            }
            if (bl10 != null && bl10.booleanValue()) {
                string2 = string2 + "CORB ";
            }
        }
        String string4 = null;
        boolean bl11 = false;
        if (!string2.equals("")) {
            if (bl7 != null && bl7.booleanValue()) {
                string3 = dialogDataModel.getString("IDS_DATASET_NAME_TEXT");
                stringArray = SyntaxUtil.getMainCommand("DATASET DECLARE").toString();
                stringArray = (String)stringArray + SyntaxUtil.getMainCommandParamters(string3);
                stringArray = (String)stringArray + SyntaxUtil.terminateSyntax();
                stringBuffer.insert(0, (String)stringArray);
                bl11 = true;
            }
            if (bl8 != null && bl8.booleanValue()) {
                string4 = dialogDataModel.getString("IDS_FILE_PATH");
                string3 = CharacterUtil.smartQuote((String)string4);
            }
            stringBuffer.append(SyntaxUtil.getBracedSingleValueSubCommand("OUTFILE", string2, string3, true));
        }
        if (bl == null) {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("METHOD", "MINQUE(1)", true));
        } else if (bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("METHOD", "MINQUE", false));
            if (dialogDataModel.getBoolean("IDS_GLM_VC_OPTIONS_UNIFORM_RADIO").booleanValue()) {
                stringBuffer.append("(1)\n");
            } else {
                stringBuffer.append("(0)\n");
            }
        } else if (bl4.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("METHOD", "SSTYPE", false));
            if (dialogDataModel.getBoolean("IDS_GLM_VC_OPTIONS_TYPE_I_RADIO").booleanValue()) {
                stringBuffer.append("(1)\n");
            } else {
                stringBuffer.append("(3)\n");
            }
            if (dialogDataModel.getBoolean("IDS_GLM_VC_OPTIONS_SUM_OF_SQ_CHECK").booleanValue()) {
                stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("PRINT", "SS", true));
            }
            if (dialogDataModel.getBoolean("IDS_GLM_VC_OPTIONS_EXPECTED_MEAN_SQ_CHECK").booleanValue()) {
                stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("PRINT", "EMS", true));
            }
        } else if (bl2.booleanValue() || bl3.booleanValue()) {
            if (bl2.booleanValue()) {
                stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("METHOD", "ML", true));
            } else if (bl3.booleanValue()) {
                stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("METHOD", "REML", true));
            }
            stringBuffer.append(SyntaxUtil.getBracedSingleValueSubCommand("CRITERIA", "ITERATE", dialogDataModel.getString("IDS_MAX_ITERATIONS_TEXT"), true));
            stringArray = new String[]{"1.0E-6", "1.0E-7", "1.0E-8", "1.0E-9", "1.0E-10"};
            stringBuffer.append(SyntaxUtil.getBracedSingleValueSubCommand("CRITERIA", "CONVERGE", stringArray[dialogDataModel.getInteger("IDS_CONVERGENCE_COMBO")], true));
            if (dialogDataModel.getBoolean("IDS_GLM_VC_OPTIONS_ITERATION_HISTORY_CHECK").booleanValue()) {
                stringBuffer.append(SyntaxUtil.getBracedSingleValueSubCommand("PRINT", "HISTORY", dialogDataModel.getString("IDS_IN_STEPS_OF_TEXT"), true));
            }
        }
        if (this.mModelListString.equals("")) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/DESIGN"));
            stringBuffer.append("\n");
        } else {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("DESIGN", this.mModelListString));
        }
        stringArray = dialogDataModel.getBoolean("IDS_GLM_VC_MODEL_INCLUDE_INTERCEPT_CHECK");
        if (stringArray == null || stringArray.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("INTERCEPT", "INCLUDE", false));
        } else {
            stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("INTERCEPT", "EXCLUDE", false));
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        PesFile pesFile = PES_Repository.getPesFile((String)string4);
        if (pesFile != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            stringBuffer.append(string);
        }
        if (bl11 && CommandLine.isClementineCaller() && RemoteFileChooser.enableSaveInModeler()) {
            stringBuffer.append("DATASET ACTIVATE " + string3);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean okPastePressed() {
        this.updateDialogDataModel();
        if (this.showWarning()) {
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mRandFactorList.getModel()) {
            this.mModelButton.setEnabled(true);
            if (this.mDepVarList.getModel().getSize() > 0) {
                this.enableOkPaste(true);
            }
        }
        if (listDataEvent.getSource() == this.mDepVarList.getModel() && this.mRandFactorList.getModel().getSize() > 0) {
            this.enableOkPaste(true);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() != this.mDepVarList.getModel()) {
            this.updateDialogDataModel();
        }
        if (listDataEvent.getSource() == this.mRandFactorList.getModel() && this.mRandFactorList.getModel().getSize() == 0) {
            this.mModelButton.setEnabled(false);
            this.enableOkPaste(false);
        }
        if (listDataEvent.getSource() == this.mDepVarList.getModel()) {
            this.enableOkPaste(false);
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateDialogDataModel();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(this.setTabTraversal(), false));
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(MODEL_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VarianceCompsDlg.this.runModelSubDlg();
            }
        };
        this.mModelButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mModelButton);
        toggleButtonAction = new ToggleButtonAction(OPTIONS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VarianceCompsDlg.this.runOptionsSubDlg();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton);
        toggleButtonAction = new ToggleButtonAction(SAVE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VarianceCompsDlg.this.runSaveSubDlg();
            }
        };
        JButton jButton2 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton2);
        if (!RemoteFileChooser.enableSaveInModeler()) {
            jButton2.setEnabled(false);
        }
        return jPanel;
    }

    private void updateDialogDataModel() {
        String string = this.mFixFactorList.getVariablesStringList();
        String string2 = this.mRandFactorList.getVariablesStringList();
        String string3 = this.mCovarList.getVariablesStringList();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        stringTokenizer = new StringTokenizer(string2, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector2.add(stringTokenizer.nextToken());
        }
        stringTokenizer = new StringTokenizer(string3, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector3.add(stringTokenizer.nextToken());
        }
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Vector<String> vector4 = new Vector<String>();
        Object[] objectArray = dialogDataModel.getArray(AbstractModelSubDialog.MODEL_TERMS_KEY);
        if (objectArray != null) {
            String string4 = "";
            for (int i = 0; i < objectArray.length; ++i) {
                String string5 = objectArray[i].toString();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string5, "*");
                int n = stringTokenizer2.countTokens();
                for (int j = 0; j < n && (vector.contains(string4 = stringTokenizer2.nextToken()) || vector2.contains(string4) || string3.contains(string4)); ++j) {
                    if (j < n - 1) continue;
                    vector4.add(string5);
                }
            }
        }
        dialogDataModel.putArray(AbstractModelSubDialog.MODEL_TERMS_KEY, vector4.toArray());
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mDepVarList.removeAll();
        this.mFixFactorList.removeAll();
        this.mRandFactorList.removeAll();
        this.mCovarList.removeAll();
        this.mWlsWtList.removeAll();
        this.enableOkPaste(false);
        this.mModelButton.setEnabled(false);
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mSrcVarList.setSelectedIndex(0);
        this.mDepVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mDepVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mDepVarList.getModel().addListDataListener(this);
        this.mDepVarListScroll = new JScrollPane(this.mDepVarList);
        this.mDepVarListScroll.setHorizontalScrollBarPolicy(31);
        this.mDepVarListScroll.setVerticalScrollBarPolicy(21);
        this.mDepVarListScroll.setPreferredSize(this.mDepVarList.getMinimumSize());
        this.mDepVarList.setIdentifier(DEP_VAR_LIST);
        this.mDepVarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mFixFactorList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mFixFactorList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mFixFactorList.getModel().addListDataListener(this);
        this.mFixScrollPane = new JScrollPane(this.mFixFactorList);
        this.mFixFactorList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mFixFactorList.getFixedCellHeight() * 2 + 2));
        this.mFixScrollPane.setPreferredSize(this.mFixFactorList.getMinimumSize());
        this.mFixFactorList.setIdentifier(FIX_FACTOR_LIST);
        this.mRandFactorList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mRandFactorList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mRandFactorList.getModel().addListDataListener(this);
        this.mRandScrollPane = new JScrollPane(this.mRandFactorList);
        this.mRandFactorList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mRandFactorList.getFixedCellHeight() * 2 + 2));
        this.mRandScrollPane.setPreferredSize(this.mRandFactorList.getMinimumSize());
        this.mRandFactorList.setIdentifier(RAND_FACTOR_LIST);
        this.mCovarList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mCovarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mCovarList.getModel().addListDataListener(this);
        this.mCovarScrollPane = new JScrollPane(this.mCovarList);
        this.mCovarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mCovarList.getFixedCellHeight() * 2 + 2));
        this.mCovarScrollPane.setPreferredSize(this.mCovarList.getMinimumSize());
        this.mCovarList.setIdentifier(COVARIATE_LIST);
        this.mCovarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mWlsWtList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mWlsWtList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mWlsWtListScroll = new JScrollPane(this.mWlsWtList);
        this.mWlsWtListScroll.setHorizontalScrollBarPolicy(31);
        this.mWlsWtListScroll.setVerticalScrollBarPolicy(21);
        this.mWlsWtListScroll.setPreferredSize(this.mWlsWtList.getMinimumSize());
        this.mWlsWtList.setIdentifier(WLSWEIGHT_LIST);
        this.mWlsWtList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mDepVarListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mDepVarListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mDepVarListArrow.registerVariableList(this.mDepVarList, SpssArrowButton.ButtonOrientation.left);
        this.mFixFactorListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mFixFactorListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mFixFactorListArrow.registerVariableList(this.mFixFactorList, SpssArrowButton.ButtonOrientation.left);
        this.mRandFactorListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mRandFactorListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mRandFactorListArrow.registerVariableList(this.mRandFactorList, SpssArrowButton.ButtonOrientation.left);
        this.mCovarListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCovarListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mCovarListArrow.registerVariableList(this.mCovarList, SpssArrowButton.ButtonOrientation.left);
        this.mWlsWtListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mWlsWtListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mWlsWtListArrow.registerVariableList(this.mWlsWtList, SpssArrowButton.ButtonOrientation.left);
    }

    private void addComponents(JPanel jPanel) {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_GLM_VC_DEPENDENT_LABEL");
        jLabel.setLabelFor(this.mDepVarList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_GLM_VC_FIXED_FAC_LABEL");
        jLabel2.setLabelFor(this.mFixFactorList);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_GLM_VC_RANDOM_FAC_LABEL");
        jLabel3.setLabelFor(this.mRandFactorList);
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_GLM_VC_COVARIATE_LABEL");
        jLabel4.setLabelFor(this.mCovarList);
        JLabel jLabel5 = DialogUtil.createLabel(this, "IDS_GLM_VC_WLS_WEIGHT_LABEL");
        jLabel5.setLabelFor(this.mWlsWtList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getArrowButtonInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        JLabel jLabel6 = DialogUtil.createLabel(this, "IDS_GLM_VC_SRCLIST_LABEL");
        jLabel6.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel6, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 9, n, null);
        n = 20;
        Insets insets2 = new Insets(0, insets.left, 0, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mDepVarListArrow, gridBagConstraints, 1, 0, 1, 2, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.mDepVarListScroll, gridBagConstraints, 2, 1, 1, 1, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mFixFactorListArrow, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        Insets insets3 = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 2, 1, 1, n, insets3);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mFixScrollPane, gridBagConstraints, 2, 3, 1, 1, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mRandFactorListArrow, gridBagConstraints, 1, 5, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 4, 1, 1, n, insets3);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mRandScrollPane, gridBagConstraints, 2, 5, 1, 1, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mCovarListArrow, gridBagConstraints, 1, 7, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 2, 6, 1, 1, n, insets3);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mCovarScrollPane, gridBagConstraints, 2, 7, 1, 1, n, null);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mWlsWtListArrow, gridBagConstraints, 1, 8, 1, 2, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel5, gridBagConstraints, 2, 8, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mWlsWtListScroll, gridBagConstraints, 2, 9, 1, 1, n, null);
    }

    private Vector<Object> setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mDepVarListArrow);
        vector.add(this.mFixFactorListArrow);
        vector.add(this.mRandFactorListArrow);
        vector.add(this.mCovarListArrow);
        vector.add(this.mWlsWtListArrow);
        vector.add(this.mDepVarList);
        vector.add(this.mFixFactorList);
        vector.add(this.mRandFactorList);
        vector.add(this.mCovarList);
        vector.add(this.mWlsWtList);
        int n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void runModelSubDlg() {
        this.updateDialogDataModel();
        this.runSubDialog(new VarianceCompsModel(this, this.getResString("IDS_GLM_VC_MODEL"), this.mFixFactorList.getModel(), this.mCovarList.getModel(), this.mRandFactorList.getModel(), FULL_FAC_RADIO));
    }

    private void runSaveSubDlg() {
        this.runSubDialog(new VarianceCompsSave(this));
    }

    private void runOptionsSubDlg() {
        this.runSubDialog(new VarianceCompsOptions(this));
    }

    private boolean showWarning() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean(AbstractModelSubDialog.MODEL_CUSTOM_KEY);
        if (bl != null && bl.booleanValue() && dialogDataModel.getArray(AbstractModelSubDialog.MODEL_TERMS_KEY).length == 0) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_LOGLINEAR_GENERAL_MODEL_NOT_SPECIFIED_WARNING"), VersionInfo.getAppVersionString());
            return true;
        }
        DialogDataModel dialogDataModel2 = this.getDialogDataModel();
        this.mModelListString = "";
        Boolean bl2 = dialogDataModel2.getBoolean(AbstractModelSubDialog.MODEL_CUSTOM_KEY);
        if (bl2 != null && bl2.booleanValue()) {
            String string;
            int n;
            Object[] objectArray = dialogDataModel2.getArray(AbstractModelSubDialog.MODEL_TERMS_KEY);
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    String string2 = objectArray[i].toString();
                    this.mModelListString = this.mModelListString + string2 + " ";
                }
            }
            this.mModelListString = this.mModelListString.trim();
            StringBuffer stringBuffer = new StringBuffer("");
            int n2 = this.mFixFactorList.getModel().getSize();
            for (n = 0; n < n2; ++n) {
                string = this.mFixFactorList.getModel().getElementAt(n).getName();
                if (this.mModelListString.contains(string)) continue;
                stringBuffer.append(string + ", ");
            }
            n2 = this.mRandFactorList.getModel().getSize();
            for (n = 0; n < n2; ++n) {
                string = this.mRandFactorList.getModel().getElementAt(n).getName();
                if (this.mModelListString.contains(string)) continue;
                stringBuffer.append(string + ", ");
            }
            n2 = this.mCovarList.getModel().getSize();
            for (n = 0; n < n2; ++n) {
                string = this.mCovarList.getModel().getElementAt(n).getName();
                if (this.mModelListString.contains(string)) continue;
                stringBuffer.append(string + ", ");
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
                String string3 = this.getResString("ERR_GLM_VC_FACTORS_NOT_USED_WARNING");
                string3 = String.format(string3, stringBuffer);
                int n3 = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), string3, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
                if (n3 == 3 || n3 == -1) {
                    return true;
                }
            }
        }
        return false;
    }
}

