/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.rep_measures;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.controls.BasicACREvent;
import com.spss.java_client.ui.controls.BasicACRWidget;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.controls.IBasicACRListener;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.adv_stats.res.AdvStatsResBundle;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.ProcedureAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.doc_util.ProcedureDialogLoader;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RepeatedMeasuresDefineDlg
extends BaseProcedureDialog
implements IBasicACRListener,
DocumentListener {
    static String BASIC_ACRWIDGET_ACTION_KEY1 = "IDS_BASIC_ACRWIDGET1";
    static String FACTORS = "IDS_FACTORS";
    static String BASIC_ACRWIDGET_ACTION_KEY2 = "IDS_BASIC_ACRWIDGET2";
    private StringTextField mFactorEdit;
    private IntTextField mLevelEdit;
    private BasicACRWidget mLevelWidget;
    private BasicACRWidget mMeasureWidget;
    private StringTextField mMeasureEdit;

    public RepeatedMeasuresDefineDlg(JFrame jFrame) {
        super(jFrame, AdvStatsResBundle.getDefaultResourceBundleName(), AdvStatsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_REPEATED_MEASURE_DEFINE_TITLE"));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_glms";
    }

    @Override
    public String generateSyntax() {
        return null;
    }

    @Override
    public String getIActionKey() {
        return "analyze_gen_linear_rep_measures";
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument().equals(this.mMeasureEdit.getDocument())) {
            this.addButtonUpdateFormMeasureWidget();
        } else {
            this.addButtonUpdateFormLevelWidget();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument().equals(this.mMeasureEdit.getDocument())) {
            this.addButtonUpdateFormMeasureWidget();
        } else {
            this.addButtonUpdateFormLevelWidget();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument().equals(this.mMeasureEdit.getDocument())) {
            this.addButtonUpdateFormMeasureWidget();
        } else {
            this.addButtonUpdateFormLevelWidget();
        }
    }

    @Override
    public void acrEventOccured(BasicACREvent basicACREvent) {
        if (basicACREvent.getSource() == this.mLevelWidget) {
            BasicACREvent.EventType eventType = basicACREvent.getEventType();
            if (eventType.equals((Object)BasicACREvent.EventType.addButtonPress)) {
                int n = VarNameValidator.validateSPSSName((String)this.mFactorEdit.getText(), (boolean)true).asInt();
                boolean bl = true;
                if (n > 0 && n != 100) {
                    bl = DialogUtil.showBadSpssVarNameWarning(n, this);
                }
                if (bl) {
                    String string = this.mFactorEdit.getText();
                    String string2 = this.mLevelEdit.getText();
                    if (!this.isDuplicateVariableNameForFactor(string)) {
                        this.mFactorEdit.requestFocus();
                        this.mLevelEdit.setText("");
                        this.mFactorEdit.setText("");
                        String string3 = "(" + string2 + ")";
                        String string4 = string + string3;
                        this.mLevelWidget.removeBasicACRListener(this);
                        this.mLevelWidget.clearItemListSelection();
                        if (this.mLevelWidget.getListItemCount() >= 18) {
                            this.mLevelWidget.setAddEnabled(false);
                            this.mLevelWidget.setChangeEnabled(false);
                            this.mLevelWidget.setRemoveEnabled(false);
                        } else {
                            this.mLevelWidget.addListItemAt(this.mLevelWidget.getListItemCount(), string4);
                        }
                        this.getOkButton().setEnabled(true);
                        this.mLevelWidget.setAddEnabled(false);
                        this.mLevelWidget.addBasicACRListener(this);
                    }
                } else {
                    this.mFactorEdit.requestFocus();
                    this.mFactorEdit.selectAll();
                }
            } else if (eventType.equals((Object)BasicACREvent.EventType.listSelectionValueChange)) {
                int n = this.mLevelWidget.getListSelectedIndex();
                this.mLevelWidget.setAddEnabled(false);
                this.mLevelWidget.setChangeEnabled(false);
                this.mLevelWidget.setRemoveEnabled(n > -1);
                if (n > -1) {
                    String string = (String)this.mLevelWidget.getListItemAt(this.mLevelWidget.getListSelectedIndex());
                    String[] stringArray = new String[]{"", ""};
                    int n2 = 0;
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "(");
                    while (stringTokenizer.hasMoreTokens()) {
                        stringArray[n2] = stringTokenizer.nextToken();
                        stringArray[++n2] = stringTokenizer.nextToken();
                    }
                    stringTokenizer = new StringTokenizer(stringArray[1], ")");
                    while (stringTokenizer.hasMoreTokens()) {
                        stringArray[1] = stringTokenizer.nextToken();
                    }
                    this.mFactorEdit.getDocument().removeDocumentListener(this);
                    this.mLevelEdit.getDocument().removeDocumentListener(this);
                    this.mFactorEdit.setText(stringArray[0]);
                    this.mLevelEdit.setText(stringArray[1]);
                    this.mFactorEdit.getDocument().addDocumentListener(this);
                    this.mLevelEdit.getDocument().addDocumentListener(this);
                }
            } else if (eventType.equals((Object)BasicACREvent.EventType.removeButtonPress)) {
                int n = this.mLevelWidget.getListSelectedIndex();
                if (n > -1) {
                    this.mFactorEdit.setText("");
                    this.mLevelEdit.setText("");
                    this.mLevelWidget.removeListItemAt(n);
                    if (this.mLevelWidget.getListItemCount() > 0) {
                        this.getOkButton().setEnabled(true);
                    } else {
                        this.getOkButton().setEnabled(false);
                    }
                    this.mLevelWidget.requestFocus();
                }
            } else if (eventType.equals((Object)BasicACREvent.EventType.changeButtonPress)) {
                int n = this.mLevelWidget.getListSelectedIndex();
                String string = this.mFactorEdit.getText();
                String string5 = this.mLevelEdit.getText();
                String string6 = string + "(" + string5 + ")";
                this.mFactorEdit.setText("");
                this.mLevelEdit.setText("");
                if (n > -1) {
                    this.mLevelWidget.removeListItemAt(n);
                    this.mLevelWidget.addListItemAt(n, string6);
                    this.mFactorEdit.requestFocus();
                }
            }
        } else if (basicACREvent.getSource() == this.mMeasureWidget) {
            BasicACREvent.EventType eventType = basicACREvent.getEventType();
            if (eventType.equals((Object)BasicACREvent.EventType.addButtonPress)) {
                int n = VarNameValidator.validateSPSSName((String)this.mMeasureEdit.getText(), (boolean)true).asInt();
                boolean bl = true;
                if (n > 0 && n != 100) {
                    bl = DialogUtil.showBadSpssVarNameWarning(n, this);
                }
                if (bl) {
                    String string = this.mMeasureEdit.getText();
                    if (!this.isDuplicateVariableNameForMeasure(string)) {
                        this.mMeasureEdit.requestFocus();
                        this.mMeasureWidget.removeBasicACRListener(this);
                        this.mMeasureEdit.setText("");
                        this.mMeasureWidget.clearItemListSelection();
                        this.mMeasureWidget.addListItemAt(this.mMeasureWidget.getListItemCount(), string);
                        this.mMeasureEdit.requestFocus();
                        this.mMeasureWidget.addBasicACRListener(this);
                    }
                } else {
                    this.mFactorEdit.requestFocus();
                    this.mFactorEdit.selectAll();
                }
            } else if (eventType.equals((Object)BasicACREvent.EventType.listSelectionValueChange)) {
                int n = this.mMeasureWidget.getListSelectedIndex();
                this.mMeasureWidget.setAddEnabled(false);
                this.mMeasureWidget.setChangeEnabled(false);
                this.mMeasureWidget.setRemoveEnabled(n > -1);
                if (n > -1) {
                    String string = (String)this.mMeasureWidget.getListItemAt(this.mMeasureWidget.getListSelectedIndex());
                    this.mMeasureEdit.getDocument().removeDocumentListener(this);
                    this.mMeasureEdit.setText(string);
                    this.mMeasureEdit.getDocument().addDocumentListener(this);
                }
            } else if (eventType.equals((Object)BasicACREvent.EventType.removeButtonPress)) {
                int n = this.mMeasureWidget.getListSelectedIndex();
                if (n > -1) {
                    this.mMeasureEdit.setText("");
                    this.mMeasureWidget.removeListItemAt(n);
                    this.mMeasureEdit.requestFocus();
                }
            } else if (eventType.equals((Object)BasicACREvent.EventType.changeButtonPress)) {
                int n = this.mMeasureWidget.getListSelectedIndex();
                if (n > -1) {
                    this.mMeasureWidget.removeListItemAt(n);
                    this.mMeasureWidget.addListItemAt(n, this.mMeasureEdit.getText());
                    this.mMeasureEdit.requestFocus();
                }
                this.mMeasureEdit.setText("");
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
        this.clearAll();
    }

    public String getTitle() {
        return this.getResString("IDS_REPEATED_MEASURES_TITLE");
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JPanel jPanel2 = this.setupTextPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        JPanel jPanel3 = this.setupAcivePanel();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, null);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        if (this.getDialogDataModel().getArray(BASIC_ACRWIDGET_ACTION_KEY1) != null) {
            this.getOkButton().setEnabled(true);
        } else {
            this.getOkButton().setEnabled(false);
        }
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
    }

    @Override
    protected boolean okPastePressed() {
        if (this.mLevelWidget.isAddEnabled()) {
            ResourceBundle resourceBundle = ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
            String string = resourceBundle.getString("ERR_DEFINE_SETS_ERR_MESSAGE_PENDING_OPERATIONS_WILL_BE_LOST");
            int n = SpssAlertOptionPane.showConfirmDialog(this.getOwner(), string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
            switch (n) {
                case 0: {
                    if (this.bCanHandleSkeleton()) {
                        this.launchNextDialog();
                        return true;
                    }
                    this.getOkButton().requestFocus();
                }
                case -1: 
                case 3: {
                    this.mFactorEdit.requestFocus();
                    this.mFactorEdit.selectAll();
                }
            }
        } else if (this.mMeasureWidget.isAddEnabled()) {
            ResourceBundle resourceBundle = ResUtil.getBundle(UtilitiesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
            String string = resourceBundle.getString("ERR_DEFINE_SETS_ERR_MESSAGE_PENDING_OPERATIONS_WILL_BE_LOST");
            int n = SpssAlertOptionPane.showConfirmDialog(this.getOwner(), string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
            switch (n) {
                case 0: {
                    if (this.bCanHandleSkeleton()) {
                        this.launchNextDialog();
                        return true;
                    }
                    this.getOkButton().requestFocus();
                }
                case -1: 
                case 3: {
                    this.mMeasureEdit.requestFocus();
                    this.mMeasureEdit.selectAll();
                }
            }
        } else {
            if (this.bCanHandleSkeleton()) {
                this.launchNextDialog();
                return true;
            }
            this.getOkButton().requestFocus();
        }
        return false;
    }

    @Override
    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = super.setupCmdButtonPanel();
        jPanel.remove(this.getPasteButton());
        this.getOkButton().setText(this.getResString("IDS_REP_DEFINE"));
        this.getRootPane().setDefaultButton(this.getOkButton());
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void launchNextDialog() {
        this.saveDialogState();
        ProcedureDlgMgr.getMgr().savePersistentState(this.getIActionKey(), this.getDialogDataModel());
        ProcedureDlgMgr.getMgr().addRecallItem(this.getTitle(), this.getIActionKey());
        ProcedureAction procedureAction = (ProcedureAction)ActionCatalog.getActionCatalog().getSpssAction("analyze_gen_linear_rep_measures_define");
        Container container = this.getParent();
        JFrame jFrame = container instanceof JFrame ? (JFrame)container : SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame();
        ProcedureDialogLoader.showDialog(procedureAction, jFrame);
    }

    private boolean bCanHandleSkeleton() {
        int n;
        int n2;
        int[] nArray = new int[10];
        int n3 = this.mMeasureWidget.getListItemCount();
        if (this.mMeasureWidget.getListItemCount() != 0) {
            n2 = n3;
            n = 9;
        } else {
            n2 = 1;
            n = 0;
        }
        int n4 = 0;
        int n5 = 0;
        while (n4 < this.mLevelWidget.getListItemCount()) {
            String string = (String)this.mLevelWidget.getListItemAt(n4);
            String string2 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "(");
            while (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
            }
            stringTokenizer = new StringTokenizer(string2, ")");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                nArray[n5] = Integer.parseInt(string3);
            }
            int n6 = (n2 *= nArray[n5]) * (n5 * 3 + 13 + n + 8) + 256;
            if (n6 >= 65536) {
                SpssAlertOptionPane.showWarningMessageDialog(this.getOwner(), this.getResString("ERR_REPEATED_MEASURE_SKELETON_ALERT"), VersionInfo.getAppVersionString());
                return false;
            }
            ++n4;
            ++n5;
        }
        return true;
    }

    private JPanel setupTextPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 2;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_REPEATED_MEASURE_DEFINE_FACTORNAME");
        jLabel.setLabelFor((Component)((Object)this.mFactorEdit));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFactorEdit), gridBagConstraints, 1, 1, 1, 1, n, insets);
        jLabel = DialogUtil.createLabel(this, "IDS_REPEATED_MEASURE_DEFINE_LEVELS");
        jLabel.setLabelFor((Component)this.mLevelEdit);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mLevelEdit, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupAcivePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mLevelWidget, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_REPEATED_MEASURE_DEFINE_MEASURENAME");
        jLabel.setLabelFor((Component)((Object)this.mMeasureEdit));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)((Object)this.mMeasureEdit), gridBagConstraints, 1, 1, 1, 1, n, DialogUtil.getStandardControlInsets());
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, DialogUtil.getStandardControlInsets());
        insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mMeasureWidget, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mLevelEdit);
        Component[] componentArray = new Component[3];
        for (int i = 0; i < ((JPanel)this.mLevelWidget.getComponent(0)).getComponentCount(); ++i) {
            componentArray[i] = ((JPanel)this.mLevelWidget.getComponent(0)).getComponent(i);
        }
        vector.add(componentArray[0]);
        vector.add(this.mLevelWidget.getList());
        vector.add(componentArray[1]);
        vector.add(componentArray[2]);
        vector.add(this.mMeasureEdit);
        Component[] componentArray2 = new Component[3];
        for (n = 0; n < ((JPanel)this.mMeasureWidget.getComponent(0)).getComponentCount(); ++n) {
            componentArray2[n] = ((JPanel)this.mMeasureWidget.getComponent(0)).getComponent(n);
        }
        vector.add(componentArray2[0]);
        vector.add(this.mMeasureWidget.getList());
        vector.add(componentArray2[1]);
        vector.add(componentArray2[2]);
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        vector.add(this.mFactorEdit);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void initVars() {
        this.mFactorEdit = new StringTextField("", 12);
        this.mFactorEdit.setDocument(new FixedLengthDocument(64));
        this.mFactorEdit.getDocument().addDocumentListener(this);
        this.mLevelEdit = new IntTextField(2, 99, true);
        this.mLevelEdit.setColumns(2);
        this.mLevelEdit.getDocument().addDocumentListener(this);
        this.mLevelWidget = new BasicACRWidget(BASIC_ACRWIDGET_ACTION_KEY1);
        this.mLevelWidget.addBasicACRListener(this);
        this.mLevelWidget.setAllowDuplicates(false);
        this.mMeasureEdit = new StringTextField("", 12);
        this.mMeasureEdit.setDocument(new FixedLengthDocument(64));
        this.mMeasureWidget = new BasicACRWidget(BASIC_ACRWIDGET_ACTION_KEY2);
        this.mMeasureWidget.addBasicACRListener(this);
        this.mMeasureWidget.setAllowDuplicates(false);
        this.mMeasureWidget.setAddText(ResUtil.getCommonDlgString("IDS_ADD_1"));
        this.mMeasureWidget.setAddMnemonic(ResUtil.getCommonDlgAccessKey("IDK_ADD_1"));
        this.mMeasureWidget.setChangeText(ResUtil.getCommonDlgString("IDS_CHANGE_1"));
        this.mMeasureWidget.setChangeMnemonic(ResUtil.getCommonDlgAccessKey("IDK_CHANGE_1"));
        this.mMeasureWidget.setRemoveText(ResUtil.getCommonDlgString("IDS_REMOVE_1"));
        this.mMeasureWidget.setRemoveMnemonic(ResUtil.getCommonDlgAccessKey("IDK_REMOVE_1"));
        this.mMeasureEdit.getDocument().addDocumentListener(this);
    }

    private void setDefaults() {
        this.mFactorEdit.setText(this.getResString("IDS_REP_DEFINE_FACTOR"));
        this.mMeasureEdit.setText("");
        this.mLevelEdit.setText("");
        this.mLevelEdit.requestFocus();
        this.mLevelWidget.clearListModel();
        this.mMeasureWidget.clearListModel();
        this.getOkButton().setEnabled(false);
    }

    private boolean isDuplicateVariableNameForFactor(String string) {
        String string2;
        Object object;
        int n;
        boolean bl = false;
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc.findVarIndex(string) != -1) {
            SpssAlertOptionPane.showWarningMessageDialog(this.getOwner(), this.getResString("ERR_REPEATED_MEASURE_DUPLICATES"), VersionInfo.getAppVersionString());
            this.mFactorEdit.requestFocus();
            this.mFactorEdit.selectAll();
            bl = true;
            return bl;
        }
        for (n = 0; n < this.mLevelWidget.getListItemCount(); ++n) {
            object = this.mLevelWidget.getListItemAt(n);
            string2 = object.toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "(", false);
            String string3 = stringTokenizer.nextToken();
            if (!string.equals(string3)) continue;
            SpssAlertOptionPane.showWarningMessageDialog(this.getOwner(), this.getResString("ERR_REPEATED_MEASURE_DUPLICATES"), VersionInfo.getAppVersionString());
            this.mFactorEdit.requestFocus();
            this.mFactorEdit.selectAll();
            bl = true;
            return bl;
        }
        for (n = 0; n < this.mMeasureWidget.getListItemCount(); ++n) {
            object = this.mMeasureWidget.getListItemAt(n);
            string2 = object.toString();
            if (!string.equals(string2)) continue;
            SpssAlertOptionPane.showWarningMessageDialog(this.getOwner(), this.getResString("ERR_REPEATED_MEASURE_DUPLICATES1"), VersionInfo.getAppVersionString());
            this.mFactorEdit.requestFocus();
            this.mFactorEdit.selectAll();
            bl = true;
            return bl;
        }
        return bl;
    }

    private boolean isDuplicateVariableNameForMeasure(String string) {
        String string2;
        Object object;
        int n;
        boolean bl = false;
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc.findVarIndex(string) != -1) {
            SpssAlertOptionPane.showWarningMessageDialog(this.getOwner(), this.getResString("ERR_REPEATED_MEASURE_DUPLICATES"), VersionInfo.getAppVersionString());
            this.mMeasureEdit.requestFocus();
            this.mMeasureEdit.selectAll();
            bl = true;
            return bl;
        }
        for (n = 0; n < this.mLevelWidget.getListItemCount(); ++n) {
            object = this.mLevelWidget.getListItemAt(n);
            string2 = object.toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "(", false);
            String string3 = stringTokenizer.nextToken();
            if (!string.equals(string3)) continue;
            SpssAlertOptionPane.showWarningMessageDialog(this.getOwner(), this.getResString("ERR_REPEATED_MEASURE_DUPLICATES1"), VersionInfo.getAppVersionString());
            this.mMeasureEdit.requestFocus();
            this.mMeasureEdit.selectAll();
            bl = true;
            return bl;
        }
        for (n = 0; n < this.mMeasureWidget.getListItemCount(); ++n) {
            object = this.mMeasureWidget.getListItemAt(n);
            string2 = object.toString();
            if (!string.equals(string2)) continue;
            SpssAlertOptionPane.showWarningMessageDialog(this.getOwner(), this.getResString("ERR_REPEATED_MEASURE_DUPLICATES"), VersionInfo.getAppVersionString());
            this.mMeasureEdit.requestFocus();
            this.mMeasureEdit.selectAll();
            bl = true;
            return bl;
        }
        return bl;
    }

    private void addButtonUpdateFormLevelWidget() {
        boolean bl = this.mFactorEdit.getText().length() > 0;
        boolean bl2 = this.mLevelEdit.getText().length() > 0;
        this.mLevelWidget.setAddEnabled(bl && bl2);
        int n = this.mLevelWidget.getListSelectedIndex();
        this.mLevelWidget.setChangeEnabled(bl && bl2 && n > -1);
        this.mLevelWidget.setRemoveEnabled(false);
    }

    private void addButtonUpdateFormMeasureWidget() {
        boolean bl = this.mMeasureEdit.getText().length() > 0;
        this.mMeasureWidget.setAddEnabled(bl);
        int n = this.mMeasureWidget.getListSelectedIndex();
        this.mMeasureWidget.setChangeEnabled(bl && n > -1);
        this.mMeasureWidget.setRemoveEnabled(false);
    }

    private void clearAll() {
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame != null) {
            DataFrame dataFrame = (DataFrame)spssFrame;
            LocallyUniqueId locallyUniqueId = dataFrame.getDatasetId();
            ProcedureDlgMgr.getMgr().removePersistenceData(locallyUniqueId, "analyze_gen_linear_rep_measures_define");
        }
        if (this.getDialogDataModel() != null) {
            this.getDialogDataModel().clear();
        }
    }
}

