/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.rep_measures;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class ListTraversalArrowButton
implements ActionListener,
ListSelectionListener,
FocusListener {
    protected JList mList;
    private PlainTable mTable;
    private boolean mSideWays;
    protected ArrowButton mUpArrowButton;
    protected ArrowButton mDownArrowButton;
    private GridBagConstraints mConstraints;
    private Color mColor;
    private Insets mInsets;

    public ListTraversalArrowButton(JList jList, boolean bl) {
        this.mList = jList;
        this.mList.addListSelectionListener(this);
        this.mSideWays = bl;
        this.initVars();
    }

    public ListTraversalArrowButton(PlainTable plainTable, boolean bl, Color color) {
        this.mColor = color;
        this.mTable = plainTable;
        this.mTable.getSelectionModel().addListSelectionListener(this);
        this.mTable.addMouseListener(new MyMouseAdapater());
        this.mTable.addFocusListener(this);
        this.mSideWays = bl;
        this.initVars();
    }

    public JPanel setupArrowButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setLayout(new GridBagLayout());
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        if (this.mSideWays) {
            this.mInsets.set(n2, n2, n2, 0);
            DialogUtil.addUsingGBL(jPanel, this.mUpArrowButton, this.mConstraints, 0, 0, 1, 1, n, this.mInsets);
            this.mConstraints.weighty = 1.0;
            this.mInsets.set(n2, insets.left, n2, n2);
            DialogUtil.addUsingGBL(jPanel, this.mDownArrowButton, this.mConstraints, 1, 0, 1, 1, n, this.mInsets);
        } else {
            this.mInsets.set(n2, n2, 0, n2);
            DialogUtil.addUsingGBL(jPanel, this.mUpArrowButton, this.mConstraints, 0, 0, 1, 1, n, this.mInsets);
            this.mConstraints.weighty = 1.0;
            this.mInsets.set(n2, n2, n2, n2);
            DialogUtil.addUsingGBL(jPanel, this.mDownArrowButton, this.mConstraints, 0, 1, 1, 1, n, this.mInsets);
        }
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ArrowButton arrowButton = (ArrowButton)actionEvent.getSource();
        if (this.mList != null) {
            if (arrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.up) {
                int n = this.mList.getSelectedIndex();
                this.manipulateList(--n, SpssArrowButton.ButtonOrientation.up);
            } else if (arrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.down) {
                int n = this.mList.getSelectedIndex();
                this.manipulateList(++n, SpssArrowButton.ButtonOrientation.down);
            }
            this.mList.requestFocusInWindow();
        } else if (arrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.up) {
            int n = this.mTable.getSelectedRow();
            this.manipulateTable(--n, SpssArrowButton.ButtonOrientation.up);
        } else {
            int n = this.mTable.getSelectedRow();
            this.manipulateTable(n += this.mTable.getSelectedRowCount(), SpssArrowButton.ButtonOrientation.down);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.mList != null) {
            int[] nArray = this.mList.getSelectedIndices();
            if (nArray.length == 0) {
                this.mUpArrowButton.setEnabled(false);
                this.mDownArrowButton.setEnabled(false);
                return;
            }
            this.mUpArrowButton.setEnabled(true);
            this.mDownArrowButton.setEnabled(true);
            if (this.isSelectedIndexInSequence()) {
                int n;
                if (this.mList.getSelectedIndex() == 0) {
                    this.mUpArrowButton.setEnabled(false);
                }
                if (nArray[nArray.length - 1] == (n = this.mList.getModel().getSize()) - 1) {
                    this.mDownArrowButton.setEnabled(false);
                }
            } else {
                this.mUpArrowButton.setEnabled(false);
                this.mDownArrowButton.setEnabled(false);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.mTable.setSelectionBackground(this.mColor);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    public void resetArrowButtons() {
        this.mUpArrowButton.setEnabled(false);
        this.mDownArrowButton.setEnabled(false);
    }

    public void enableArrowButtonsForTable() {
        int n;
        int[] nArray = this.mTable.getSelectedColumns();
        int[] nArray2 = this.mTable.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) continue;
            this.mUpArrowButton.setEnabled(false);
            this.mDownArrowButton.setEnabled(false);
            return;
        }
        if (nArray2.length == 0 || this.mTable.getRowCount() == 2) {
            this.mUpArrowButton.setEnabled(false);
            this.mDownArrowButton.setEnabled(false);
            return;
        }
        this.mUpArrowButton.setEnabled(true);
        this.mDownArrowButton.setEnabled(true);
        int[] nArray3 = this.mTable.getSelectedRows();
        for (n = 0; n < nArray3.length; ++n) {
            if (!(this.mTable.getModel().getValueAt(nArray3[n], 1) instanceof String) || !(this.mTable.getModel().getValueAt(nArray3[n], 2) instanceof String)) continue;
            this.mUpArrowButton.setEnabled(false);
            this.mDownArrowButton.setEnabled(false);
            return;
        }
        if (this.isSelectedIndexInSequence()) {
            if (this.mTable.getSelectedRow() == 0) {
                this.mUpArrowButton.setEnabled(false);
            }
            if (nArray2[nArray2.length - 1] == (n = this.mTable.getModel().getRowCount()) - 2) {
                this.mDownArrowButton.setEnabled(false);
            }
        } else {
            this.mUpArrowButton.setEnabled(false);
            this.mDownArrowButton.setEnabled(false);
        }
    }

    private void manipulateTable(int n, SpssArrowButton.ButtonOrientation buttonOrientation) {
        int n2;
        Object[] objectArray;
        int n3;
        Object[] objectArray2 = new Object[3];
        for (int i = 0; i < 3; ++i) {
            objectArray2[i] = ((DefaultTableModel)this.mTable.getModel()).getValueAt(n, i);
        }
        int[] nArray = this.mTable.getSelectedRows();
        if (buttonOrientation == SpssArrowButton.ButtonOrientation.up) {
            for (n3 = 0; n3 < nArray.length; ++n3) {
                objectArray = new Object[3];
                for (n2 = 0; n2 < 3; ++n2) {
                    objectArray[n2] = ((DefaultTableModel)this.mTable.getModel()).getValueAt(nArray[n3], n2);
                    if (n2 == 0) {
                        objectArray[n2] = new Integer(Integer.parseInt((String)objectArray[n2]) - 1).toString();
                    }
                    ((DefaultTableModel)this.mTable.getModel()).setValueAt(objectArray[n2], nArray[n3] - 1, n2);
                }
            }
        } else if (buttonOrientation == SpssArrowButton.ButtonOrientation.down) {
            for (n3 = nArray.length - 1; n3 >= 0; --n3) {
                objectArray = new Object[3];
                for (n2 = 0; n2 < 3; ++n2) {
                    objectArray[n2] = ((DefaultTableModel)this.mTable.getModel()).getValueAt(nArray[n3], n2);
                    if (n2 == 0) {
                        objectArray[n2] = new Integer(Integer.parseInt((String)objectArray[n2]) + 1).toString();
                    }
                    ((DefaultTableModel)this.mTable.getModel()).setValueAt(objectArray[n2], nArray[n3] + 1, n2);
                }
            }
        }
        for (n3 = 0; n3 < 3; ++n3) {
            if (buttonOrientation == SpssArrowButton.ButtonOrientation.up) {
                if (n3 == 0) {
                    objectArray2[n3] = new Integer(Integer.parseInt((String)objectArray2[n3]) + nArray.length).toString();
                }
                ((DefaultTableModel)this.mTable.getModel()).setValueAt(objectArray2[n3], n + nArray.length, n3);
                continue;
            }
            if (n3 == 0) {
                objectArray2[n3] = new Integer(Integer.parseInt((String)objectArray2[n3]) - nArray.length).toString();
            }
            ((DefaultTableModel)this.mTable.getModel()).setValueAt(objectArray2[n3], n - nArray.length, n3);
        }
        this.mTable.getSelectionModel().clearSelection();
        if (buttonOrientation == SpssArrowButton.ButtonOrientation.up) {
            this.mTable.getSelectionModel().addSelectionInterval(n, n + (nArray.length - 1));
        } else {
            this.mTable.getSelectionModel().addSelectionInterval(nArray[0] + 1, nArray[0] + nArray.length);
        }
        if (this.mTable.getSelectedRow() == 0) {
            this.mUpArrowButton.setEnabled(false);
        } else {
            this.mUpArrowButton.setEnabled(true);
        }
        n3 = this.mTable.getModel().getRowCount();
        objectArray = this.mTable.getSelectedRows();
        if (objectArray[objectArray.length - 1] + true == n3 - 1) {
            this.mDownArrowButton.setEnabled(false);
        } else {
            this.mDownArrowButton.setEnabled(true);
        }
    }

    public void setArrowButtonEnableDisable(boolean bl, boolean bl2) {
        this.mUpArrowButton.setEnabled(bl);
        this.mDownArrowButton.setEnabled(bl2);
    }

    private void initVars() {
        this.mUpArrowButton = new ArrowButton();
        this.mUpArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.up);
        this.mUpArrowButton.addActionListener(this);
        this.mUpArrowButton.setEnabled(false);
        this.mDownArrowButton = new ArrowButton();
        this.mDownArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.down);
        this.mDownArrowButton.addActionListener(this);
        this.mDownArrowButton.setEnabled(false);
        this.mConstraints = new GridBagConstraints();
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mInsets = new Insets(0, 0, 0, 0);
    }

    private boolean isSelectedIndexInSequence() {
        int[] nArray = this.mList != null ? this.mList.getSelectedIndices() : this.mTable.getSelectedRows();
        for (int i = 0; i < nArray.length - 1; ++i) {
            if (nArray[i] + 1 == nArray[i + 1]) continue;
            return false;
        }
        return true;
    }

    private void manipulateList(int n, SpssArrowButton.ButtonOrientation buttonOrientation) {
        int n2;
        int n3;
        int[] nArray = this.mList.getSelectedIndices();
        Object[] objectArray = this.mList.getSelectedValues();
        List<Object> list = Arrays.asList(objectArray);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n3 = 0; n3 < this.mList.getModel().getSize(); ++n3) {
            arrayList.add(this.mList.getModel().getElementAt(n3));
        }
        arrayList.removeAll(list);
        arrayList.addAll(n, list);
        n3 = this.mList.getModel().getSize();
        if (this.mList.getModel() instanceof VarListModel) {
            ((VarListModel)this.mList.getModel()).removeAll();
        } else {
            ((DefaultListModel)this.mList.getModel()).removeAllElements();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.mList.getModel() instanceof VarListModel) {
                ((VarListModel)this.mList.getModel()).addElement((ISpssVariable)arrayList.get(n2));
                continue;
            }
            ((DefaultListModel)this.mList.getModel()).addElement(arrayList.get(n2));
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (buttonOrientation == SpssArrowButton.ButtonOrientation.up) {
                int n4 = n2;
                nArray[n4] = nArray[n4] - 1;
                continue;
            }
            int n5 = n2;
            nArray[n5] = nArray[n5] + 1;
        }
        this.mList.setSelectedIndices(nArray);
    }

    class MyMouseAdapater
    extends MouseAdapter {
        MyMouseAdapater() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            ListTraversalArrowButton.this.enableArrowButtonsForTable();
        }
    }
}

