/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.neural_networks;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.IVarFilter;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.adv_stats.neural_networks.ExportTab;
import com.spss.java_client.ui.dialogs.adv_stats.neural_networks.NeuralNetworksMLPModelDlg;
import com.spss.java_client.ui.dialogs.adv_stats.neural_networks.NeuralNetworksRBFModelDlg;
import com.spss.java_client.ui.dialogs.adv_stats.neural_networks.PartitionsTab;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class VariablesTab
extends BaseProcedureTab
implements ItemListener,
ListDataListener {
    private static final String SRC_VAR_LIST = "MLP_SRC_VARLIST";
    static final String COVARIATES_TARGET_LIST_KEY = "COVARIATES_TARGET_LIST";
    static final String FACTORS_TARGET_LIST_KEY = "FACTORS_TARGET_LIST";
    static final String TARGET_LIST_KEY = "TARGET_LIST";
    static final String RESCALING_COMBO_KEY = "IDS_MLP_RESCALING_COMBO_KEY";
    static final String DEP_RESCALING_COMBO_KEY = "IDS_RBF_RESCALING_COMBO_KEY";
    private static final int DEP_LIST_HEIGHT = 72;
    private static final int LIST_HEIGHT = 50;
    private static final int LIST_WIDTH = 150;
    private SrcVariableList mVariableSrcList;
    private JLabel mSrcListLabel;
    private JScrollPane mSrcScrollPane;
    private TargetVariableList mDepVarList;
    private TargetVariableList mFactorVarList;
    private TargetVariableList mCovariatesVarList;
    private JComboBox mRescalingCombo;
    private JComboBox mDepRescalingCombo = null;
    private JScrollPane mDepVarListScrollPane;
    private JScrollPane mFactorVarListScrollPane;
    private JScrollPane mCovariatesVarListScrollPane;
    private ArrowButton mDepArrowButton;
    private ArrowButton mFactorArrowButton;
    private ArrowButton mCovariatesArrowButton;
    Vector<String> AllVariableNames = new Vector();
    private boolean mIsRBF = false;

    public VariablesTab(BaseTabbedDialog baseTabbedDialog, boolean bl) {
        super(baseTabbedDialog, true);
        this.mIsRBF = bl;
        this.initialize();
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mVariableSrcList;
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        Object object = listDataEvent.getSource();
        if (object.equals(this.mDepVarList.getModel()) || object.equals(this.mFactorVarList.getModel()) || object.equals(this.mCovariatesVarList.getModel())) {
            if (this.mIsRBF && object.equals(this.mDepVarList.getModel())) {
                DepVarMeasurment depVarMeasurment = this.checkDepentVarMeasurement();
                if (depVarMeasurment == DepVarMeasurment.ALL_SCALE || depVarMeasurment == DepVarMeasurment.MIXED) {
                    this.mDepRescalingCombo.setEnabled(true);
                } else {
                    this.mDepRescalingCombo.setEnabled(false);
                }
            }
            this.setEnabledOkPaste();
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        Object[] objectArray;
        Object object;
        Object object2 = listDataEvent.getSource();
        if (object2.equals(this.mDepVarList.getModel()) || object2.equals(this.mFactorVarList.getModel()) || object2.equals(this.mCovariatesVarList.getModel())) {
            if (this.mIsRBF && object2.equals(this.mDepVarList.getModel())) {
                object = this.checkDepentVarMeasurement();
                if (object == DepVarMeasurment.ALL_SCALE || object == DepVarMeasurment.MIXED) {
                    this.mDepRescalingCombo.setEnabled(true);
                } else {
                    this.mDepRescalingCombo.setEnabled(false);
                }
            }
            this.setEnabledOkPaste();
        }
        if (object2.equals(this.mDepVarList.getModel()) && (object = this.mIsRBF ? ((NeuralNetworksRBFModelDlg)this.mParent).getDialogDataModel() : ((NeuralNetworksMLPModelDlg)this.mParent).getDialogDataModel()) != null && (objectArray = ((DialogDataModel)object).getArray("IDS_MLP_DEP_VAR_NAMES")) != null) {
            VarListModel varListModel = this.mDepVarList.getModel();
            ExportTab exportTab = this.mIsRBF ? ((NeuralNetworksRBFModelDlg)this.mParent).getExportTab() : ((NeuralNetworksMLPModelDlg)this.mParent).getExportTab();
            for (Object object3 : objectArray) {
                if (varListModel.findElementIndexesByName((String)object3).length != 0) continue;
                exportTab.removeDependentVariable((String)object3);
            }
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    protected boolean validateTab() {
        if (this.mDepVarList.getModel().getSize() == 0 && (this.mFactorVarList.getModel().getSize() > 0 || this.mCovariatesVarList.getModel().getSize() > 0)) {
            SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_MLP_VARIABLES_WARNING"), VersionInfo.getAppVersionString());
            this.mVariableSrcList.requestFocusInWindow();
            return false;
        }
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
    }

    @Override
    public String getDialogHelpID() {
        if (this.mIsRBF) {
            return "idh_idd_rbf_variables";
        }
        return "idh_idd_mlp_variables";
    }

    public VarListModel getFactorsListModel() {
        return this.mFactorVarList.getModel();
    }

    public VarListModel getTargetListModel() {
        return this.mDepVarList.getModel();
    }

    public VarListModel getSrcListModel() {
        return this.mVariableSrcList.getModel();
    }

    public VarListModel getCovariateListModel() {
        return this.mCovariatesVarList.getModel();
    }

    public String getVariablesTabSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.mIsRBF) {
            stringBuffer.append("RBF ");
        } else {
            stringBuffer.append("MLP ");
        }
        VarListModel varListModel = this.getTargetListModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            ISpssVariable iSpssVariable = varListModel.getElementAt(i);
            stringBuffer.append(iSpssVariable.getName()).append(" ");
            MeasurementLevel measurementLevel = iSpssVariable.getDisplayMeasurementLevel();
            if (measurementLevel == MeasurementLevel.scale) {
                stringBuffer.append("(MLEVEL=S) ");
                continue;
            }
            if (measurementLevel == MeasurementLevel.nominal) {
                stringBuffer.append("(MLEVEL=N) ");
                continue;
            }
            if (measurementLevel != MeasurementLevel.ordinal) continue;
            stringBuffer.append("(MLEVEL=O) ");
        }
        String string = this.getByCommandSyntax();
        if (string.length() > 0) {
            stringBuffer.append(string).append(" ");
        }
        string = this.getWithCommandSyntax();
        boolean bl = false;
        if (string.length() > 0) {
            stringBuffer.append(string).append(" ");
            bl = true;
        }
        if (this.mIsRBF && this.mDepRescalingCombo.isEnabled()) {
            if (bl) {
                stringBuffer.append(" DEPENDENT=");
            } else {
                stringBuffer.append("\n  /RESCALE DEPENDENT=");
            }
            int n = this.mDepRescalingCombo.getSelectedIndex();
            switch (n) {
                case 0: {
                    stringBuffer.append("STANDARDIZED ");
                    break;
                }
                case 1: {
                    stringBuffer.append("NORMALIZED ");
                    break;
                }
                case 2: {
                    stringBuffer.append("ADJNORMALIZED ");
                    break;
                }
                case 3: {
                    stringBuffer.append("NONE ");
                }
            }
        }
        return stringBuffer.toString();
    }

    public String getByCommandSyntax() {
        String string = this.mFactorVarList.getVariablesStringList();
        if (string.length() > 0) {
            return "BY " + string;
        }
        return string;
    }

    public String getWithCommandSyntax() {
        String string = this.mCovariatesVarList.getVariablesStringList();
        if (string.length() > 0) {
            string = "WITH " + string;
            StringBuffer stringBuffer = new StringBuffer(string);
            String string2 = "\n /RESCALE COVARIATE=";
            int n = this.mRescalingCombo.getSelectedIndex();
            switch (n) {
                case 0: {
                    string2 = string2 + "STANDARDIZED";
                    break;
                }
                case 1: {
                    string2 = string2 + "NORMALIZED";
                    break;
                }
                case 2: {
                    string2 = string2 + "ADJNORMALIZED";
                    break;
                }
                case 3: {
                    string2 = string2 + "NONE";
                }
            }
            stringBuffer.append(string2);
            return stringBuffer.toString();
        }
        return string;
    }

    boolean hasRescaleCommand() {
        return this.mCovariatesVarList != null && this.mCovariatesVarList.getVariablesStringList().length() > 0;
    }

    @Override
    public void reset() {
        this.mDepVarList.getModel().removeAll();
        this.mFactorVarList.getModel().removeAll();
        this.mCovariatesVarList.getModel().removeAll();
        this.setDefaults();
        PartitionsTab partitionsTab = this.mIsRBF ? ((NeuralNetworksRBFModelDlg)this.mParent).getPartitionsTab() : ((NeuralNetworksMLPModelDlg)this.mParent).getPartitionsTab();
        if (partitionsTab != null) {
            TargetVariableList targetVariableList = partitionsTab.getPartioningVariable();
            if (targetVariableList == null) {
                return;
            }
            VarListModel varListModel = targetVariableList.getModel();
            if (varListModel.getSize() > 0) {
                this.mVariableSrcList.getModel().removeElement(varListModel.getElementAt(0));
            }
        }
    }

    public boolean setEnabledOkPaste() {
        boolean bl = false;
        if (this.mDepVarList.getModel().getSize() > 0 && (this.mFactorVarList.getModel().getSize() > 0 || this.mCovariatesVarList.getModel().getSize() > 0)) {
            bl = true;
        }
        if (this.mIsRBF) {
            ((NeuralNetworksRBFModelDlg)this.mParent).enableOkPaste(bl);
        } else {
            ((NeuralNetworksMLPModelDlg)this.mParent).enableOkPaste(bl);
        }
        return bl;
    }

    public DepVarMeasurment checkDepentVarMeasurement() {
        VarListModel varListModel = this.getTargetListModel();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < varListModel.getSize(); ++i) {
            MeasurementLevel measurementLevel = varListModel.getElementAt(i).getDisplayMeasurementLevel();
            if (measurementLevel == MeasurementLevel.scale || measurementLevel == MeasurementLevel.unknown) {
                ++n2;
                continue;
            }
            if (measurementLevel != MeasurementLevel.nominal && measurementLevel != MeasurementLevel.ordinal) continue;
            ++n;
        }
        DepVarMeasurment depVarMeasurment = n == 0 && n2 == 0 ? DepVarMeasurment.UNDEFINED : (n > 0 && n2 > 0 ? DepVarMeasurment.MIXED : (n == 0 ? DepVarMeasurment.ALL_SCALE : DepVarMeasurment.ALL_CATEGORICAL));
        return depVarMeasurment;
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
    }

    private void initialize() {
        JComponent jComponent;
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, 0, 0);
        JPanel jPanel = this.setupListPanel();
        int n3 = 3;
        if (this.mIsRBF) {
            n3 = 4;
        }
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, n3, n, insets);
        Dimension dimension = jPanel.getPreferredSize();
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_NNET_MLP_VARIABLES_MESG"));
        jTextArea.setOpaque(false);
        jTextArea.setFont(this.mSrcListLabel.getFont());
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFocusable(false);
        jTextArea.setMinimumSize(new Dimension(dimension.width, 28));
        jTextArea.setPreferredSize(new Dimension(dimension.width, 28));
        insets.set(n2, n2, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, jTextArea, gridBagConstraints, 0, n3, 1, 1, n, insets);
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_NNET_MLP_FACTOR_LABEL");
        jLabel.setLabelFor(this.mFactorVarList);
        JComponent[] jComponentArray = new JComponent[]{this.mFactorArrowButton, jLabel, this.mFactorVarListScrollPane};
        JPanel jPanel2 = this.setupTargetlistPanel(jComponentArray);
        Dimension dimension2 = jPanel2.getPreferredSize();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, "IDS_NNET_MLP_DEP_VARIABLES_LABEL");
        jLabel2.setLabelFor(this.mDepVarList);
        JComponent[] jComponentArray2 = new JComponent[]{this.mDepArrowButton, jLabel2, this.mDepVarListScrollPane};
        insets.set(n2, 0, 0, 0);
        JPanel jPanel3 = this.setupTargetlistPanel(jComponentArray2);
        Dimension dimension3 = jPanel3.getPreferredSize();
        dimension3.height = (int)((double)dimension2.height / 2.0);
        dimension3.width = dimension2.width;
        jPanel3.setPreferredSize(dimension3);
        int n4 = 0;
        DialogUtil.addUsingGBL(this, jPanel3, gridBagConstraints, 1, n4++, 1, 1, n, insets);
        if (this.mIsRBF) {
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            insets.set(n2, n2 * 9, 0, 0);
            jComponent = this.setupDepRescalingPanel();
            DialogUtil.addUsingGBL(this, jComponent, gridBagConstraints, 1, n4++, 1, 1, n, insets);
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2, 0, 0, 0);
        gridBagConstraints.fill = 1;
        n = 23;
        jPanel2.setPreferredSize(dimension2);
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 1, n4++, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        jComponent = DialogUtil.createLabel(this.mParent, "IDS_NNET_MLP_COVARIATES_LABEL");
        ((JLabel)jComponent).setLabelFor(this.mCovariatesVarList);
        JComponent[] jComponentArray3 = new JComponent[]{this.mCovariatesArrowButton, jComponent, this.mCovariatesVarListScrollPane};
        insets.set(n2, 0, 0, 0);
        JPanel jPanel4 = this.setupTargetlistPanel(jComponentArray3);
        DialogUtil.addUsingGBL(this, jPanel4, gridBagConstraints, 1, n4++, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, n2 * 9, 0, 0);
        JPanel jPanel5 = this.setupRescalingPanel();
        DialogUtil.addUsingGBL(this, jPanel5, gridBagConstraints, 1, n4, 1, 1, n, insets);
        this.setFocusTraversalPolicy();
    }

    private JPanel setupTargetlistPanel(JComponent[] jComponentArray) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 10;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, jComponentArray[0], gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jComponentArray[1], gridBagConstraints, 1, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jComponentArray[2], gridBagConstraints, 1, 1, 1, 1, n, null);
        return jPanel;
    }

    private Vector<Object> setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mVariableSrcList);
        vector.add(this.mDepArrowButton);
        vector.add(this.mFactorArrowButton);
        vector.add(this.mCovariatesArrowButton);
        vector.add(this.mDepVarList);
        vector.add(this.mFactorVarList);
        vector.add(this.mCovariatesVarList);
        vector.add(this.mRescalingCombo);
        this.setComponentOrder(vector);
        return vector;
    }

    private JPanel setupListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mSrcListLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setupRescalingPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_NNET_MLP_RESCALING_LABEL");
        jLabel.setLabelFor(this.mRescalingCombo);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mRescalingCombo, gridBagConstraints, 0, 1, 1, 1, n, null);
        return jPanel;
    }

    private void setDefaults() {
        String[] stringArray;
        int n;
        this.mVariableSrcList.loadFromActiveDataset();
        this.mVariableSrcList.setSelectedIndex(0);
        VarListModel varListModel = this.mVariableSrcList.getModel();
        for (n = 0; n < varListModel.getSize(); ++n) {
            this.AllVariableNames.add(varListModel.getElementAt(n).getName());
        }
        this.mDepArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mDepArrowButton.setEnabled(true);
        this.mFactorArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mFactorArrowButton.setEnabled(true);
        this.mCovariatesArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        n = this.mVariableSrcList.getSelectedIndex();
        this.mCovariatesArrowButton.setEnabled(true);
        if (n >= 0 && (stringArray = varListModel.getElementAt(n)).getType() != 0) {
            this.mCovariatesArrowButton.setEnabled(false);
        }
        this.mRescalingCombo.removeItemListener(this);
        if (this.mRescalingCombo.getItemCount() > 0) {
            this.mRescalingCombo.removeAllItems();
        }
        for (String string : stringArray = this.getResStringArray("IDS_NNET_MLP_RESCALING_VALUES")) {
            this.mRescalingCombo.addItem(string);
        }
        this.mRescalingCombo.addItemListener(this);
        this.mRescalingCombo.setSelectedIndex(0);
        if (this.mIsRBF) {
            this.mDepRescalingCombo.removeItemListener(this);
            if (this.mDepRescalingCombo.getItemCount() > 0) {
                this.mDepRescalingCombo.removeAllItems();
            }
            for (String string : stringArray) {
                this.mDepRescalingCombo.addItem(string);
            }
            this.mDepRescalingCombo.addItemListener(this);
            this.mDepRescalingCombo.setSelectedIndex(0);
            this.mDepRescalingCombo.setEnabled(false);
        }
    }

    private JPanel setupDepRescalingPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_NNET_RBF_RESCALING_LABEL");
        jLabel.setLabelFor(this.mDepRescalingCombo);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mDepRescalingCombo, gridBagConstraints, 0, 1, 1, 1, n, null);
        return jPanel;
    }

    private void initVars() {
        this.mVariableSrcList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mVariableSrcList.getModel().addListDataListener(this);
        SplitVarFilter splitVarFilter = new SplitVarFilter();
        this.mVariableSrcList.addVarFilter(splitVarFilter);
        this.mVariableSrcList.setIdentifier(SRC_VAR_LIST);
        this.mVariableSrcList.setContextMenuFlags(this.mVariableSrcList.getContextMenuFlags() | 8);
        this.mSrcListLabel = DialogUtil.createLabel(this.mParent, "IDS_NNET_MLP_VARIABLES_LABEL");
        this.mSrcListLabel.setLabelFor(this.mVariableSrcList);
        this.mSrcScrollPane = new JScrollPane(this.mVariableSrcList);
        this.mSrcScrollPane.setPreferredSize(this.mVariableSrcList.getMinimumSize());
        this.mSrcScrollPane.setHorizontalScrollBarPolicy(30);
        this.mSrcScrollPane.setVerticalScrollBarPolicy(20);
        this.mDepVarList = new TargetVariableList();
        this.mDepVarList.addVarFilter(splitVarFilter);
        this.mDepVarList.getModel().addListDataListener(this);
        this.mDepVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mDepVarList.setIdentifier(TARGET_LIST_KEY);
        this.mDepVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mDepVarList.getFixedCellHeight() * 4 + 2));
        this.mDepVarListScrollPane = new JScrollPane(this.mDepVarList);
        this.mDepVarListScrollPane.setPreferredSize(new Dimension(150, 72));
        this.mFactorVarList = new TargetVariableList();
        this.mFactorVarList.addVarFilter(splitVarFilter);
        this.mFactorVarList.getModel().addListDataListener(this);
        this.mFactorVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mFactorVarList.setIdentifier(FACTORS_TARGET_LIST_KEY);
        this.mFactorVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mFactorVarList.getFixedCellHeight() * 8 + 2));
        this.mFactorVarListScrollPane = new JScrollPane(this.mFactorVarList);
        this.mFactorVarListScrollPane.setPreferredSize(new Dimension(150, 50));
        this.mCovariatesVarList = new TargetVariableList();
        this.mCovariatesVarList.getModel().addListDataListener(this);
        this.mCovariatesVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mCovariatesVarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mCovariatesVarList.setIdentifier(COVARIATES_TARGET_LIST_KEY);
        this.mCovariatesVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mCovariatesVarList.getFixedCellHeight() * 8 + 2));
        this.mCovariatesVarListScrollPane = new JScrollPane(this.mCovariatesVarList);
        this.mCovariatesVarListScrollPane.setPreferredSize(new Dimension(150, 50));
        this.mDepArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.left);
        this.mDepArrowButton.registerVariableList(this.mVariableSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mDepArrowButton.registerVariableList(this.mDepVarList, SpssArrowButton.ButtonOrientation.left);
        this.mFactorArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.left);
        this.mFactorArrowButton.registerVariableList(this.mVariableSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mFactorArrowButton.registerVariableList(this.mFactorVarList, SpssArrowButton.ButtonOrientation.left);
        this.mCovariatesArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCovariatesArrowButton.registerVariableList(this.mVariableSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mCovariatesArrowButton.registerVariableList(this.mCovariatesVarList, SpssArrowButton.ButtonOrientation.left);
        this.mRescalingCombo = new JComboBox<String>(this.getResStringArray("IDS_NNET_MLP_RESCALING_VALUES"));
        this.mRescalingCombo.addItemListener(this);
        this.mRescalingCombo.setAction(new ComboboxAction(this.mParent, RESCALING_COMBO_KEY));
        Dimension dimension = this.mRescalingCombo.getMinimumSize();
        dimension.width = 180;
        this.mRescalingCombo.setPreferredSize(dimension);
        if (this.mIsRBF) {
            this.mDepRescalingCombo = new JComboBox<String>(this.getResStringArray("IDS_NNET_MLP_RESCALING_VALUES"));
            this.mDepRescalingCombo.addItemListener(this);
            this.mDepRescalingCombo.setAction(new ComboboxAction(this.mParent, DEP_RESCALING_COMBO_KEY));
            dimension = this.mDepRescalingCombo.getMinimumSize();
            dimension.width = 180;
            this.mDepRescalingCombo.setPreferredSize(dimension);
        }
    }

    public SplitVarFilter getSplitVarFilter() {
        return new SplitVarFilter();
    }

    private class SplitVarFilter
    implements IVarFilter {
        private SplitVarFilter() {
        }

        @Override
        public boolean canIncludeVariable(ISpssVariable iSpssVariable) {
            LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            int n = iSpssDataSrc.getNSplitVars();
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable2 = iSpssDataSrc.getVariable(iSpssDataSrc.getSplitVarIndex(i));
                if (iSpssVariable == null || iSpssVariable2 == null || !iSpssVariable.getId().equals((Object)iSpssVariable2.getId())) continue;
                return false;
            }
            return true;
        }
    }

    public static enum DepVarMeasurment {
        ALL_CATEGORICAL,
        ALL_SCALE,
        MIXED,
        UNDEFINED;

    }
}

