/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.neural_networks;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.adv_stats.neural_networks.NeuralNetworksMLPModelDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatDocument;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class TrainingTab
extends BaseProcedureTab
implements DocumentListener,
ItemListener,
FocusListener {
    private static String NUM_OF_RECORDS = "IDS_MLP_NUM_OF_RECORDS";
    private static String INIT_LAMBDA = "IDS_MLP_INIT_LAMBDA";
    private static String INIT_SIGMA = "IDS_MLP_INIT_SIGMA";
    private static String INITERVAL_CENTER = "IDS_MLP_INITERVAL_CENTER";
    private static String INITERVAL_OFFSET = "IDS_MLP_INITERVAL_OFFSET";
    private static String LEARNING_RATE = "IDS_MLP_LEARNING_RATE";
    private static String LOW_LEARNING_RATE = "IDS_MLP_LOW_LEARNING_RATE";
    private static String MOMENTTUM = "IDS_MLP_MOMENTTUM";
    private static String EPOCHS = "IDS_MLP_EPOCHS";
    private final String SYMBOL = "\u00b10.5";
    private final int LEFT_SIDE_WIDTH = 260;
    private final int RIGHT_SIDE_WIDTH = 100;
    private SpssButtonGroup mTrainingTypeGrp;
    private JRadioButton mBatchTypeRadio;
    private JRadioButton mOnlineTypeRadio;
    private JRadioButton mMiniBatchTypeRadio;
    private JPanel mTrainingTypePanel;
    private Dimension mPanelDimension;
    private SpssButtonGroup mMiniBatchGrp;
    private JRadioButton mAutoComputeRadio;
    private JRadioButton mCustomSetRadio;
    private IntTextField mCustomSetField;
    private JLabel mCustomSetLabel;
    private JPanel mMiniBatchPanel;
    private SpssButtonGroup mOptiAlgoGrp;
    private JRadioButton mScaledConjGradientRadio;
    private JRadioButton mGradientDescentRadio;
    private JPanel mAlgorithmPanel;
    private JScrollPane mTrainingOptionScrollPane;
    private JPanel mTrainingOptionPanel;
    private JLabel mTrainingOptionPanelLabel;
    private FloatTextField mInitLearningRate;
    private JTextField mInitLearningRateText;
    private FloatTextField mLowerBoundary;
    private JTextField mLowerBoundaryText;
    private FloatTextField mMonmentum;
    private JTextField mMonmentumText;
    private FloatTextField mEpochs;
    private JTextField mEpochsText;
    private FloatTextField mInitLambda;
    private JTextField mInitLambdaText;
    private FloatTextField mInitSigma;
    private JTextField mInitSigmaText;
    private FloatTextField mIntervalCenter;
    private FloatTextField mIntervalOffset;
    private JTextField mOptionName;
    private JTextField mOptionValue;
    private JTextField mIntervalCenterText;
    private JTextField mIntervalOffsetText;
    private JTextField mEmptyOption1;
    private JTextField mEmptyValue1;
    private JTextField mEmptyOption2;
    private JTextField mEmptyValue2;

    public TrainingTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
        this.initilaizePanel();
    }

    public JPanel setUpLinePanel(String string) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(string);
        JPanel jPanel2 = new JPanel();
        DialogUtil.applyTopBorder(jPanel2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        Insets insets = new Insets(n2 - 4, n2, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
        this.mIntervalOffset.setDocument((Document)((Object)new SpecialFloatDocument(true)));
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mBatchTypeRadio;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_mlp_training";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mAutoComputeRadio || object == this.mCustomSetRadio) {
            if (object == this.mAutoComputeRadio) {
                this.mCustomSetField.setEnabled(false);
                this.mCustomSetLabel.setEnabled(false);
            } else {
                this.mCustomSetField.setEnabled(true);
                this.mCustomSetLabel.setEnabled(true);
            }
        } else {
            if (object == this.mBatchTypeRadio) {
                DialogUtil.enableTitledBorder(this.mMiniBatchPanel, false);
                this.mAutoComputeRadio.setEnabled(false);
                this.mCustomSetRadio.setEnabled(false);
                this.mCustomSetField.setEnabled(false);
                this.mCustomSetLabel.setEnabled(false);
                this.mScaledConjGradientRadio.setEnabled(true);
            } else if (object == this.mOnlineTypeRadio) {
                DialogUtil.enableTitledBorder(this.mMiniBatchPanel, false);
                this.mAutoComputeRadio.setEnabled(false);
                this.mCustomSetRadio.setEnabled(false);
                this.mCustomSetField.setEnabled(false);
                this.mCustomSetLabel.setEnabled(false);
                this.mScaledConjGradientRadio.setEnabled(false);
                this.mGradientDescentRadio.setSelected(true);
            } else if (object == this.mMiniBatchTypeRadio) {
                DialogUtil.enableTitledBorder(this.mMiniBatchPanel, true);
                this.mScaledConjGradientRadio.setEnabled(false);
                this.mGradientDescentRadio.setSelected(true);
                this.mAutoComputeRadio.setEnabled(true);
                this.mCustomSetRadio.setEnabled(true);
                if (this.mCustomSetRadio.isSelected()) {
                    this.mCustomSetField.setEnabled(true);
                    this.mCustomSetLabel.setEnabled(true);
                } else {
                    this.mCustomSetField.setEnabled(false);
                    this.mCustomSetLabel.setEnabled(false);
                }
            } else if (object == this.mScaledConjGradientRadio || object == this.mGradientDescentRadio) {
                // empty if block
            }
            this.mTrainingOptionPanel.removeAll();
            this.setupTrainingOptionGrid();
            this.setFocusTraversalPolicy();
            this.validate();
            this.repaint();
        }
    }

    public boolean isOnline() {
        return this.mOnlineTypeRadio.isSelected();
    }

    public boolean isMiniBatch() {
        return this.mMiniBatchTypeRadio.isSelected();
    }

    public boolean isBatch() {
        return this.mBatchTypeRadio.isSelected();
    }

    @Override
    protected void aboutToShowTab() {
    }

    @Override
    public boolean validateTab() {
        return this.doValidation();
    }

    protected void initilaizePanel() {
        super.initPanel();
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = 23;
        Insets insets = new Insets(n * 2, n, n, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        this.setupTrainingTypePanel();
        this.mPanelDimension = this.mTrainingTypePanel.getPreferredSize();
        this.mPanelDimension.width = 260;
        this.mTrainingTypePanel.setPreferredSize(this.mPanelDimension);
        double d = this.mPanelDimension.getWidth();
        DialogUtil.addUsingGBL(this, this.mTrainingTypePanel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        JLabel jLabel = new JLabel("                  ");
        Dimension dimension = jLabel.getPreferredSize();
        dimension.width = 100;
        jLabel.setPreferredSize(dimension);
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        this.setupOptimizationAlgorithmPanel();
        dimension = this.mAlgorithmPanel.getPreferredSize();
        dimension.width = (int)d;
        this.mAlgorithmPanel.setPreferredSize(dimension);
        DialogUtil.addUsingGBL(this, this.mAlgorithmPanel, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        this.setupTrainingOptionGrid();
        dimension = this.mTrainingOptionPanel.getPreferredSize();
        dimension.width = (int)d;
        this.mTrainingOptionPanel.setPreferredSize(dimension);
        DialogUtil.addUsingGBL(this, this.mTrainingOptionPanelLabel, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        gridBagConstraints.weighty = 1.0;
        insets.set(0, UIToolDialogUtil.getStandardDialogInsets().left, 0, UIToolDialogUtil.getStandardDialogInsets().right);
        DialogUtil.addUsingGBL(this, this.mTrainingOptionScrollPane, gridBagConstraints, 0, 3, 1, 1, n2, insets);
        this.setFocusTraversalPolicy();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mBatchTypeRadio);
        vector.add(this.mOnlineTypeRadio);
        vector.add(this.mMiniBatchTypeRadio);
        vector.add(this.mAutoComputeRadio);
        vector.add(this.mCustomSetRadio);
        vector.add(this.mScaledConjGradientRadio);
        vector.add(this.mGradientDescentRadio);
        if (this.mScaledConjGradientRadio.isSelected()) {
            vector.add(this.mInitLambda);
            vector.add(this.mInitSigma);
        }
        if (this.mGradientDescentRadio.isSelected()) {
            vector.add(this.mInitLearningRate);
            if (this.mOnlineTypeRadio.isSelected() || this.mMiniBatchTypeRadio.isSelected()) {
                vector.add(this.mLowerBoundary);
            }
            vector.add(this.mMonmentum);
            if (this.mOnlineTypeRadio.isSelected() || this.mMiniBatchTypeRadio.isSelected()) {
                vector.add(this.mEpochs);
            }
        }
        vector.add(this.mIntervalCenter);
        vector.add(this.mIntervalOffset);
        JPanel jPanel = ((NeuralNetworksMLPModelDlg)this.mParent).getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private boolean doValidation() {
        if (this.mCustomSetField.isEnabled() && this.mCustomSetField.getText().equals("")) {
            SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_MLP_TRAINING_WARNING1"), VersionInfo.getAppVersionString());
            NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mCustomSetField);
            return false;
        }
        int n = ((NeuralNetworksMLPModelDlg)this.mParent).getOptionsTab().getMaxCasesInStore();
        if (this.mCustomSetField.isEnabled() && !this.mCustomSetField.getText().equals("")) {
            try {
                long l = Long.parseLong(this.mCustomSetField.getText());
                if (l < 2L || ((NeuralNetworksMLPModelDlg)this.mParent).getOptionsTab().isMaxCaseInStoreEnabled() && l > (long)n) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_MLP_TRAINING_WARNING2"), VersionInfo.getAppVersionString());
                    NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mCustomSetField);
                    return false;
                }
                if (l > Integer.MAX_VALUE) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        try {
            Object object;
            String string;
            String string2;
            String string3 = this.mIntervalCenter.getText();
            String string4 = this.mIntervalOffset.getText();
            string4 = string4.substring(1);
            if (this.mScaledConjGradientRadio.isSelected()) {
                string2 = this.mInitLambda.getText();
                string = this.mInitSigma.getText();
                object = new JComponent[4];
                if (string2.length() == 0 || string.length() == 0 || string3.length() == 0 || string4.length() == 0) {
                    String string5 = this.getResString("ERR_NNET_MLP_TRAINING_WARNING3");
                    if (string2.length() == 0) {
                        string5 = string5 + this.mInitLambdaText.getText() + "\n";
                        object[0] = this.mInitLambda;
                    }
                    if (string.length() == 0) {
                        string5 = string5 + this.mInitSigmaText.getText() + "\n";
                        object[1] = this.mInitSigma;
                    }
                    if (string3.length() == 0) {
                        string5 = string5 + this.mIntervalCenterText.getText() + "\n";
                        object[2] = this.mIntervalCenter;
                    }
                    if (string4.length() == 0) {
                        string5 = string5 + this.mIntervalOffsetText.getText() + "\n";
                        object[3] = this.mIntervalOffset;
                    }
                    SpssAlertOptionPane.showWarningMessageDialog(this, string5, VersionInfo.getAppVersionString());
                    for (int i = 0; i < 4; ++i) {
                        if (object[i] == null) continue;
                        int n2 = 0;
                        if (i == 3) {
                            n2 = 1;
                        }
                        NeuralNetworksMLPModelDlg.setSelectionText((JComponent)object[i], n2);
                        break;
                    }
                    return false;
                }
                if (Double.parseDouble(string2) == 0.0 || Double.parseDouble(string) == 0.0) {
                    String string6 = this.getResString("ERR_NNET_MLP_TRAINING_WARNING4");
                    if (Double.parseDouble(string2) == 0.0) {
                        string6 = string6 + this.mInitLambdaText.getText() + "\n";
                        object[0] = this.mInitLambda;
                    }
                    if (Double.parseDouble(string) == 0.0) {
                        string6 = string6 + this.mInitSigmaText.getText() + "\n";
                        object[1] = this.mInitSigma;
                    }
                    SpssAlertOptionPane.showWarningMessageDialog(this, string6, VersionInfo.getAppVersionString());
                    for (int i = 0; i < 4; ++i) {
                        if (object[i] == null) continue;
                        NeuralNetworksMLPModelDlg.setSelectionText((JComponent)object[i]);
                        break;
                    }
                    return false;
                }
                if (Double.parseDouble(string2) >= 1.0E-6) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_MLP_TRAINING_WARNING6"), VersionInfo.getAppVersionString());
                    NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mInitLambda);
                    return false;
                }
                if (Double.parseDouble(string) >= 1.0E-4) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_MLP_TRAINING_WARNING7"), VersionInfo.getAppVersionString());
                    NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mInitSigma);
                    return false;
                }
            }
            if (this.mGradientDescentRadio.isSelected()) {
                string2 = this.mInitLearningRate.getText();
                string = this.mMonmentum.getText();
                object = this.mEpochs.getText();
                String string7 = this.mLowerBoundary.getText();
                JComponent[] jComponentArray = new JComponent[6];
                String string8 = this.getResString("ERR_NNET_MLP_TRAINING_WARNING3");
                boolean bl = false;
                int n3 = 0;
                if (string2.length() == 0) {
                    bl = true;
                    string8 = string8 + this.mInitLearningRateText.getText() + "\n";
                    jComponentArray[n3++] = this.mInitLearningRate;
                }
                if ((this.mOnlineTypeRadio.isSelected() || this.mMiniBatchTypeRadio.isSelected()) && string7.length() == 0) {
                    string8 = string8 + this.mLowerBoundaryText.getText() + "\n";
                    jComponentArray[n3++] = this.mLowerBoundary;
                    bl = true;
                }
                if (string.length() == 0) {
                    string8 = string8 + this.mMonmentumText.getText() + "\n";
                    jComponentArray[n3++] = this.mMonmentum;
                    bl = true;
                }
                if ((this.mOnlineTypeRadio.isSelected() || this.mMiniBatchTypeRadio.isSelected()) && ((String)object).length() == 0) {
                    string8 = string8 + this.mEpochsText.getText() + "\n";
                    jComponentArray[n3++] = this.mEpochs;
                    bl = true;
                }
                if (string3.length() == 0) {
                    string8 = string8 + this.mIntervalCenterText.getText() + "\n";
                    jComponentArray[n3++] = this.mIntervalCenter;
                    bl = true;
                }
                if (string4.length() == 0) {
                    string8 = string8 + this.mIntervalOffsetText.getText() + "\n";
                    jComponentArray[n3++] = this.mIntervalOffset;
                    bl = true;
                }
                if (bl) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, string8, VersionInfo.getAppVersionString());
                    for (int i = 0; i < 6; ++i) {
                        if (jComponentArray[i] == null) continue;
                        NeuralNetworksMLPModelDlg.setSelectionText(jComponentArray[i]);
                        break;
                    }
                    return false;
                }
                string8 = this.getResString("ERR_NNET_MLP_TRAINING_WARNING4");
                boolean bl2 = false;
                n3 = 0;
                if (Double.parseDouble(string2) == 0.0) {
                    string8 = string8 + this.mInitLearningRateText.getText() + "\n";
                    jComponentArray[n3++] = this.mInitLearningRate;
                    bl = true;
                }
                if ((this.mOnlineTypeRadio.isSelected() || this.mMiniBatchTypeRadio.isSelected()) && Double.parseDouble(string7) == 0.0) {
                    string8 = string8 + this.mLowerBoundaryText.getText() + "\n";
                    jComponentArray[n3++] = this.mLowerBoundary;
                    bl = true;
                }
                if (Double.parseDouble(string) == 0.0) {
                    string8 = string8 + this.mMonmentumText.getText() + "\n";
                    jComponentArray[n3++] = this.mMonmentum;
                    bl = true;
                }
                if (this.mOnlineTypeRadio.isSelected() || this.mMiniBatchTypeRadio.isSelected()) {
                    if (Double.parseDouble(string7) >= Double.parseDouble(string2)) {
                        bl2 = true;
                    }
                    if (Double.parseDouble((String)object) == 0.0) {
                        string8 = string8 + this.mEpochsText.getText() + "\n";
                        jComponentArray[n3++] = this.mEpochs;
                        bl = true;
                    }
                }
                if (bl) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, string8, VersionInfo.getAppVersionString());
                    for (int i = 0; i < 6; ++i) {
                        if (jComponentArray[i] == null) continue;
                        NeuralNetworksMLPModelDlg.setSelectionText(jComponentArray[i]);
                        break;
                    }
                    return false;
                }
                if (bl2) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_MLP_TRAINING_WARNING5"), VersionInfo.getAppVersionString());
                    NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mLowerBoundary);
                    return false;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public String getTrainingTabSyntax() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\n  /CRITERIA ");
        stringBuffer.append("TRAINING=");
        if (this.mBatchTypeRadio.isSelected()) {
            stringBuffer.append("BATCH ");
        } else if (this.mOnlineTypeRadio.isSelected()) {
            stringBuffer.append("ONLINE ");
        } else if (this.mMiniBatchTypeRadio.isSelected()) {
            stringBuffer.append("MINIBATCH MINIBATCHSIZE=");
            if (this.mAutoComputeRadio.isSelected()) {
                stringBuffer.append("AUTO ");
            } else {
                stringBuffer.append(this.mCustomSetField.getText() + " ");
            }
        }
        if (this.mScaledConjGradientRadio.isSelected()) {
            stringBuffer.append("OPTIMIZATION=SCALEDCONJUGATE ");
            if (this.mInitLambda.getText().length() > 0) {
                stringBuffer.append("LAMBDAINITIAL=");
                stringBuffer.append(this.mInitLambda.getText() + " ");
            }
            if (this.mInitSigma.getText().length() > 0) {
                stringBuffer.append("SIGMAINITIAL=");
                stringBuffer.append(this.mInitSigma.getText() + " ");
            }
        } else if (this.mGradientDescentRadio.isSelected()) {
            stringBuffer.append("OPTIMIZATION=GRADIENTDESCENT ");
            if (this.mInitLearningRate.getText().length() > 0) {
                stringBuffer.append("LEARNINGINITIAL= " + this.mInitLearningRate.getText() + " ");
            }
            if ((this.mOnlineTypeRadio.isSelected() || this.mMiniBatchTypeRadio.isSelected()) && this.mLowerBoundary.getText().length() > 0) {
                stringBuffer.append("LEARNINGLOWER= " + this.mLowerBoundary.getText() + " ");
            }
            if ((this.mOnlineTypeRadio.isSelected() || this.mMiniBatchTypeRadio.isSelected()) && this.mEpochs.getText().length() > 0) {
                stringBuffer.append("LEARNINGEPOCHS= " + this.mEpochs.getText() + " ");
            }
            if (this.mMonmentum.getText().length() > 0) {
                stringBuffer.append("MOMENTUM= " + this.mMonmentum.getText() + " ");
            }
        }
        if (!this.mIntervalCenter.getText().equals("")) {
            stringBuffer.append("INTERVALCENTER=");
            stringBuffer.append(this.mIntervalCenter.getText() + " ");
        }
        if (!this.mIntervalOffset.getText().equals("")) {
            stringBuffer.append("INTERVALOFFSET=");
            stringBuffer.append(this.mIntervalOffset.getText().substring(1) + " ");
        }
        if (((NeuralNetworksMLPModelDlg)this.mParent).getOptionsTab().isMaxCaseInStoreEnabled()) {
            stringBuffer.append("MEMSIZE=");
            stringBuffer.append(((NeuralNetworksMLPModelDlg)this.mParent).getOptionsTab().getMaxCasesInStore() + " ");
        }
        return stringBuffer.toString();
    }

    private void setDefaults() {
        this.mBatchTypeRadio.setSelected(true);
        DialogUtil.enableTitledBorder(this.mMiniBatchPanel, false);
        this.validate();
        this.repaint();
        this.mAutoComputeRadio.setEnabled(false);
        this.mAutoComputeRadio.setSelected(true);
        this.mCustomSetRadio.setEnabled(false);
        this.mCustomSetField.setEnabled(false);
        this.mCustomSetField.setText("2");
        this.mCustomSetLabel.setEnabled(false);
        if (this.mBatchTypeRadio.isSelected()) {
            this.mScaledConjGradientRadio.setSelected(true);
        } else {
            this.mGradientDescentRadio.setSelected(true);
            this.mScaledConjGradientRadio.setEnabled(false);
        }
        this.mInitLearningRate.setText("0.4");
        this.mLowerBoundary.setText("0.001");
        this.mMonmentum.setText("0.9");
        this.mEpochs.setText("10");
        this.mInitLambda.setText("0.0000005");
        this.mInitSigma.setText("0.00005");
        this.mIntervalCenter.setText("0");
    }

    private void initVars() {
        this.mTrainingTypePanel = PanelFactory.getEmptyPanel(this.getResString("IDS_NNET_MLP_TRAINING_TYPE"));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NNET_MLP_TRAINING_TYPE_BATCH");
        this.mBatchTypeRadio = new JRadioButton(toggleButtonAction);
        this.mBatchTypeRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NNET_MLP_TRAINING_TYPE_ONLINE");
        this.mOnlineTypeRadio = new JRadioButton(toggleButtonAction);
        this.mOnlineTypeRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NNET_MLP_TRAINING_TYPE_MINI_BATCH");
        this.mMiniBatchTypeRadio = new JRadioButton(toggleButtonAction);
        this.mMiniBatchTypeRadio.addItemListener(this);
        this.mTrainingTypeGrp = new SpssButtonGroup();
        this.mTrainingTypeGrp.add(this.mBatchTypeRadio);
        this.mTrainingTypeGrp.add(this.mOnlineTypeRadio);
        this.mTrainingTypeGrp.add(this.mMiniBatchTypeRadio);
        this.mMiniBatchPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_NNET_MLP_TRAINING_NUM_MINI_BATCH_LABEL"));
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NNET_MLP_TRAINING_BATCH_AUTO");
        this.mAutoComputeRadio = new JRadioButton(toggleButtonAction);
        this.mAutoComputeRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NNET_MLP_TRAINING_BATCH_CUMSTOM");
        this.mCustomSetRadio = new JRadioButton(toggleButtonAction);
        this.mCustomSetRadio.addItemListener(this);
        this.mMiniBatchGrp = new SpssButtonGroup();
        this.mMiniBatchGrp.add(this.mAutoComputeRadio);
        this.mMiniBatchGrp.add(this.mCustomSetRadio);
        this.mCustomSetLabel = DialogUtil.createLabel(this.mParent, "IDS_NNET_MLP_TRAINING_NUM_MINI_BATCH");
        this.mCustomSetField = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mCustomSetField.setAction((Action)new TextFieldAction(this.mParent, NUM_OF_RECORDS));
        this.mCustomSetField.setColumns(5);
        this.mCustomSetField.addFocusListener((FocusListener)this);
        this.mCustomSetField.getDocument().addDocumentListener(this);
        this.mCustomSetLabel.setLabelFor((Component)this.mCustomSetField);
        this.mAlgorithmPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_NNET_MLP_TRAINING_OPTIM_ALGORITHM"));
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NNET_MLP_TRAINING_OPTIM_SCALED_CONJU_GRADIENT");
        this.mScaledConjGradientRadio = new JRadioButton(toggleButtonAction);
        this.mScaledConjGradientRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NNET_MLP_TRAINING_OPTIM_GRAD_DESCENT");
        this.mGradientDescentRadio = new JRadioButton(toggleButtonAction);
        this.mGradientDescentRadio.addItemListener(this);
        this.mOptiAlgoGrp = new SpssButtonGroup();
        this.mOptiAlgoGrp.add(this.mScaledConjGradientRadio);
        this.mOptiAlgoGrp.add(this.mGradientDescentRadio);
        this.mTrainingOptionPanel = PanelFactory.getEmptyPanel("");
        this.mTrainingOptionPanel.setMaximumSize(new Dimension(300, 140));
        this.mTrainingOptionScrollPane = new JScrollPane(this.mTrainingOptionPanel);
        this.mTrainingOptionScrollPane.setPreferredSize(new Dimension(300, 140));
        this.mTrainingOptionScrollPane.setHorizontalScrollBarPolicy(31);
        this.mTrainingOptionScrollPane.setVerticalScrollBarPolicy(20);
        this.mTrainingOptionPanelLabel = DialogUtil.createLabel(this.mParent, "IDS_NNET_MLP_TRAINING_OPTIONS");
        this.mTrainingOptionPanelLabel.setLabelFor(this.mTrainingOptionPanel);
        this.mOptionName = new JTextField(this.getResString("IDS_NNET_MLP_TRAINING_OPTION"));
        this.mOptionName.setEditable(false);
        this.mOptionValue = new JTextField(this.getResString("IDS_NNET_MLP_TRAINING_OPTION_VALUE"));
        this.mOptionValue.setEditable(false);
        this.mInitLearningRate = new FloatTextField(true);
        this.mInitLearningRate.setAction((Action)new TextFieldAction(this.mParent, LEARNING_RATE));
        this.mInitLearningRate.addFocusListener((FocusListener)this);
        this.mInitLearningRate.getDocument().addDocumentListener(this);
        this.mInitLearningRateText = new JTextField(this.getResString("IDS_NNET_MLP_TRAINING_OPTION_INIT_LEARNING_RATE"));
        this.mInitLearningRateText.setEditable(false);
        this.mLowerBoundary = new FloatTextField(true);
        this.mLowerBoundary.setAction((Action)new TextFieldAction(this.mParent, LOW_LEARNING_RATE));
        this.mLowerBoundary.addFocusListener((FocusListener)this);
        this.mLowerBoundary.getDocument().addDocumentListener(this);
        this.mLowerBoundaryText = new JTextField(this.getResString("IDS_NNET_MLP_TRAINING_OPTION_LOWER_BOUNDARY"));
        this.mLowerBoundaryText.setEditable(false);
        this.mMonmentum = new FloatTextField(true);
        this.mMonmentum.setAction((Action)new TextFieldAction(this.mParent, MOMENTTUM));
        this.mMonmentum.addFocusListener((FocusListener)this);
        this.mMonmentum.getDocument().addDocumentListener(this);
        this.mMonmentumText = new JTextField(this.getResString("IDS_NNET_MLP_TRAINING_OPTION_MOMENTUM"));
        this.mMonmentumText.setEditable(false);
        this.mEpochs = new FloatTextField(true);
        this.mEpochs.setAction((Action)new TextFieldAction(this.mParent, EPOCHS));
        this.mEpochs.addFocusListener((FocusListener)this);
        this.mEpochs.getDocument().addDocumentListener(this);
        this.mEpochsText = new JTextField(this.getResString("IDS_NNET_MLP_TRAINING_OPTION_EPOCHS"));
        this.mEpochsText.setEditable(false);
        this.mInitLambda = new FloatTextField(true);
        this.mInitLambda.setAction((Action)new TextFieldAction(this.mParent, INIT_LAMBDA));
        this.mInitLambda.getDocument().addDocumentListener(this);
        this.mInitLambdaText = new JTextField(this.getResString("IDS_NNET_MLP_TRAINING_OPTION_INIT_LAMBDA"));
        this.mInitLambdaText.setEditable(false);
        this.mInitSigma = new FloatTextField(true);
        this.mInitSigma.setAction((Action)new TextFieldAction(this.mParent, INIT_SIGMA));
        this.mInitSigma.getDocument().addDocumentListener(this);
        this.mInitSigmaText = new JTextField(this.getResString("IDS_NNET_MLP_TRAINING_OPTION_INIT_SIGMA"));
        this.mInitSigmaText.setEditable(false);
        this.mIntervalCenter = new FloatTextField(true);
        this.mIntervalCenter.setAction((Action)new TextFieldAction(this.mParent, INITERVAL_CENTER));
        this.mIntervalCenter.getDocument().addDocumentListener(this);
        this.mIntervalCenterText = new JTextField(this.getResString("IDS_NNET_MLP_TRAINING_OPTION_INTERVAL_CENTER"));
        this.mIntervalCenterText.setEditable(false);
        this.mIntervalOffset = new FloatTextField(true);
        this.mIntervalOffset.setDocument((Document)((Object)new SpecialFloatDocument(true)));
        this.mIntervalOffset.setAction((Action)new TextFieldAction(this.mParent, INITERVAL_OFFSET));
        this.mIntervalOffset.getDocument().addDocumentListener(this);
        this.mIntervalOffsetText = new JTextField(this.getResString("IDS_NNET_MLP_TRAINING_OPTION_INTERVAL_OFFSET"));
        this.mIntervalOffsetText.setEditable(false);
        this.mEmptyOption1 = new JTextField("    ");
        this.mEmptyOption1.setEditable(false);
        this.mEmptyValue1 = new JTextField("    ");
        this.mEmptyValue1.setEditable(false);
        this.mEmptyOption2 = new JTextField("    ");
        this.mEmptyOption2.setEditable(false);
        this.mEmptyValue2 = new JTextField("    ");
        this.mEmptyValue2.setEditable(false);
    }

    private void setupTrainingOptionGrid() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        if (this.mGradientDescentRadio.isSelected()) {
            boolean bl = true;
            gridBagConstraints.ipadx = 90;
            DialogUtil.addUsingGBL(this.mTrainingOptionPanel, this.mOptionName, gridBagConstraints, 0, 0, 1, 1, n, null);
            gridBagConstraints.ipadx = 0;
            DialogUtil.addUsingGBL(this.mTrainingOptionPanel, this.mOptionValue, gridBagConstraints, 1, 0, 1, 1, n, null);
            DialogUtil.addUsingGBL(this.mTrainingOptionPanel, this.mInitLearningRateText, gridBagConstraints, 0, 1, 1, 1, n, null);
            DialogUtil.addUsingGBL(this.mTrainingOptionPanel, (JComponent)this.mInitLearningRate, gridBagConstraints, 1, 1, 1, 1, n, null);
            int n2 = 2;
            if (this.mMiniBatchTypeRadio.isSelected() || this.mOnlineTypeRadio.isSelected()) {
                DialogUtil.addUsingGBL(this.mTrainingOptionPanel, this.mLowerBoundaryText, gridBagConstraints, 0, n2, 1, 1, n, null);
                DialogUtil.addUsingGBL(this.mTrainingOptionPanel, (JComponent)this.mLowerBoundary, gridBagConstraints, 1, n2, 1, 1, n, null);
                bl = false;
                ++n2;
            }
            if (this.mMiniBatchTypeRadio.isSelected() || this.mOnlineTypeRadio.isSelected()) {
                DialogUtil.addUsingGBL(this.mTrainingOptionPanel, this.mEpochsText, gridBagConstraints, 0, n2, 1, 1, n, null);
                DialogUtil.addUsingGBL(this.mTrainingOptionPanel, (JComponent)this.mEpochs, gridBagConstraints, 1, n2, 1, 1, n, null);
                ++n2;
            }
            DialogUtil.addUsingGBL(this.mTrainingOptionPanel, this.mMonmentumText, gridBagConstraints, 0, n2, 1, 1, n, null);
            DialogUtil.addUsingGBL(this.mTrainingOptionPanel, (JComponent)this.mMonmentum, gridBagConstraints, 1, n2, 1, 1, n, null);
            DialogUtil.addUsingGBL(this.mTrainingOptionPanel, this.mIntervalCenterText, gridBagConstraints, 0, ++n2, 1, 1, n, null);
            DialogUtil.addUsingGBL(this.mTrainingOptionPanel, (JComponent)this.mIntervalCenter, gridBagConstraints, 1, n2, 1, 1, n, null);
            if (++n2 == 6) {
                gridBagConstraints.weighty = 1.0;
            }
            DialogUtil.addUsingGBL(this.mTrainingOptionPanel, this.mIntervalOffsetText, gridBagConstraints, 0, n2, 1, 1, n, null);
            DialogUtil.addUsingGBL(this.mTrainingOptionPanel, (JComponent)this.mIntervalOffset, gridBagConstraints, 1, n2, 1, 1, n, null);
            ++n2;
            if (bl) {
                DialogUtil.addUsingGBL(this.mTrainingOptionPanel, this.mEmptyOption1, gridBagConstraints, 0, n2, 1, 1, n, null);
                DialogUtil.addUsingGBL(this.mTrainingOptionPanel, this.mEmptyValue1, gridBagConstraints, 1, n2, 1, 1, n, null);
                gridBagConstraints.weighty = 1.0;
                DialogUtil.addUsingGBL(this.mTrainingOptionPanel, this.mEmptyOption2, gridBagConstraints, 0, ++n2, 1, 1, n, null);
                DialogUtil.addUsingGBL(this.mTrainingOptionPanel, this.mEmptyValue2, gridBagConstraints, 1, n2, 1, 1, n, null);
                ++n2;
            }
        }
        if (this.mScaledConjGradientRadio.isSelected()) {
            gridBagConstraints.ipadx = 90;
            DialogUtil.addUsingGBL(this.mTrainingOptionPanel, this.mOptionName, gridBagConstraints, 0, 0, 1, 1, n, null);
            gridBagConstraints.ipadx = 0;
            DialogUtil.addUsingGBL(this.mTrainingOptionPanel, this.mOptionValue, gridBagConstraints, 1, 0, 1, 1, n, null);
            DialogUtil.addUsingGBL(this.mTrainingOptionPanel, this.mInitLambdaText, gridBagConstraints, 0, 1, 1, 1, n, null);
            DialogUtil.addUsingGBL(this.mTrainingOptionPanel, (JComponent)this.mInitLambda, gridBagConstraints, 1, 1, 1, 1, n, null);
            DialogUtil.addUsingGBL(this.mTrainingOptionPanel, this.mInitSigmaText, gridBagConstraints, 0, 2, 1, 1, n, null);
            DialogUtil.addUsingGBL(this.mTrainingOptionPanel, (JComponent)this.mInitSigma, gridBagConstraints, 1, 2, 1, 1, n, null);
            DialogUtil.addUsingGBL(this.mTrainingOptionPanel, this.mIntervalCenterText, gridBagConstraints, 0, 3, 1, 1, n, null);
            DialogUtil.addUsingGBL(this.mTrainingOptionPanel, (JComponent)this.mIntervalCenter, gridBagConstraints, 1, 3, 1, 1, n, null);
            DialogUtil.addUsingGBL(this.mTrainingOptionPanel, this.mIntervalOffsetText, gridBagConstraints, 0, 4, 1, 1, n, null);
            DialogUtil.addUsingGBL(this.mTrainingOptionPanel, (JComponent)this.mIntervalOffset, gridBagConstraints, 1, 4, 1, 1, n, null);
            DialogUtil.addUsingGBL(this.mTrainingOptionPanel, this.mEmptyOption1, gridBagConstraints, 0, 5, 1, 1, n, null);
            DialogUtil.addUsingGBL(this.mTrainingOptionPanel, this.mEmptyValue1, gridBagConstraints, 1, 5, 1, 1, n, null);
            gridBagConstraints.weighty = 1.0;
            DialogUtil.addUsingGBL(this.mTrainingOptionPanel, this.mEmptyOption2, gridBagConstraints, 0, 6, 1, 1, n, null);
            DialogUtil.addUsingGBL(this.mTrainingOptionPanel, this.mEmptyValue2, gridBagConstraints, 1, 6, 1, 1, n, null);
        }
    }

    private void setupOptimizationAlgorithmPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(this.mAlgorithmPanel, this.mScaledConjGradientRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mAlgorithmPanel, this.mGradientDescentRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
    }

    private void setupNumOfMiniBatchPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        int n2 = 23;
        DialogUtil.addUsingGBL(this.mMiniBatchPanel, this.mAutoComputeRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.mMiniBatchPanel, this.mCustomSetRadio, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets2.set(insets.top, 45, insets.bottom, 0);
        DialogUtil.addUsingGBL(this.mMiniBatchPanel, this.mCustomSetLabel, gridBagConstraints, 0, 2, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets2.set(insets.top, 15, n, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(this.mMiniBatchPanel, (JComponent)this.mCustomSetField, gridBagConstraints, 1, 2, 1, 1, n2, insets2);
    }

    private void setupTrainingTypePanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = 23;
        DialogUtil.addUsingGBL(this.mTrainingTypePanel, this.mBatchTypeRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.mTrainingTypePanel, this.mOnlineTypeRadio, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(this.mTrainingTypePanel, this.mMiniBatchTypeRadio, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        Insets insets2 = new Insets(0, 20, n, DialogUtil.getGroupBoxInnerMargin());
        gridBagConstraints.fill = 2;
        this.setupNumOfMiniBatchPanel();
        double d = this.mMiniBatchPanel.getPreferredSize().width;
        DialogUtil.addUsingGBL(this.mTrainingTypePanel, this.mMiniBatchPanel, gridBagConstraints, 0, 3, 1, 1, n2, insets2);
    }

    private class SpecialFloatDocument
    extends FloatDocument {
        public SpecialFloatDocument() {
            this(true);
        }

        public SpecialFloatDocument(boolean bl) {
            super(bl);
            try {
                super.insertStringToPlainText(0, "\u00b10.5", null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null || string.length() == 0 || n == 0) {
                return;
            }
            char[] cArray = string.toCharArray();
            boolean bl = true;
            for (int i = 0; i < cArray.length; ++i) {
                if (Character.isDigit(cArray[i]) || cArray[i] == this.mSymbol.getDecimalSeparator() || cArray[i] == this.mSymbol.getMinusSign()) continue;
                bl = false;
                break;
            }
            if (bl) {
                String string2 = null;
                if (n >= 0 && this.getLength() - n >= 0 && (string2 = this.getText(1, n) + string + this.getText(n, this.getLength() - n)).length() > 0 && (this.getDotCount(string2) > 1 || this.isInvalidMinus(string2))) {
                    bl = false;
                }
            }
            if (bl) {
                super.insertStringToPlainText(n, string, attributeSet);
            } else if (this.mWantBeep) {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        public void remove(int n, int n2) throws BadLocationException {
            if (n == 0) {
                return;
            }
            super.remove(n, n2);
        }
    }
}

