/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.neural_networks;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.adv_stats.neural_networks.NeuralNetworksMLPModelDlg;
import com.spss.java_client.ui.dialogs.adv_stats.neural_networks.NeuralNetworksRBFModelDlg;
import com.spss.java_client.ui.dialogs.adv_stats.neural_networks.VariablesTab;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SaveTab
extends BaseProcedureTab
implements ItemListener,
DocumentListener,
FocusListener {
    private JRadioButton mAutoNameRadio;
    private JRadioButton mCustomNameRadio;
    private JCheckBox mSavePredictedValueCheck;
    private JCheckBox mSavePredictedProbabilityCheck;
    private Vector<String> mDependentVariableNames = new Vector();
    private Vector<Boolean> mScaleVar = new Vector();
    private Vector<StringTextField> mDepVariableField = new Vector();
    private Vector<StringTextField> mNameOfSavedVariable = new Vector();
    private Vector<StringTextField> mRootNameOfSavedVariable = new Vector();
    private Vector<IntTextField> mCategoryToSave = new Vector();
    private Vector<String> mDependentVariableNamesPre = new Vector();
    private Vector<StringTextField> mNameOfSavedVariablePre = new Vector();
    private Vector<StringTextField> mRootNameOfSavedVariablePre = new Vector();
    private Vector<IntTextField> mCategoryToSavePre = new Vector();
    private JPanel mVariablesPanel;
    private JLabel mVariablesLabel;
    private JTextField mEmpty;
    private JTextField mPredictedValue;
    private JTextField mPredictedProbability;
    private JTextField mDependentVarible;
    private JTextField mSavedVariable;
    private JTextField mRootName;
    private JTextField mCategories;
    private JScrollPane mVariableScrollPane;
    private static final String DEFAULT_DEP_VAR_NAME_MLP = "MLP_PredictedValue";
    private static final String DEFAULT_DEP_ROOT_VAR_NAME_MLP = "MLP_PseudoProbability";
    private static final String DEFAULT_DEP_VAR_NAME_RBF = "RBF_PredictedValue";
    private static final String DEFAULT_DEP_ROOT_VAR_NAME_RBF = "RBF_PseudoProbability";
    private boolean mIsRBF;

    public SaveTab(BaseTabbedDialog baseTabbedDialog, boolean bl) {
        super(baseTabbedDialog, true);
        this.mIsRBF = bl;
        this.initialize();
    }

    @Override
    public String getDialogHelpID() {
        if (this.mIsRBF) {
            return "idh_idd_rbf_save";
        }
        return "idh_idd_mlp_save";
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        int n = itemEvent.getStateChange();
        if (itemEvent.getSource() == this.mSavePredictedValueCheck) {
            for (StringTextField object2 : this.mNameOfSavedVariable) {
                if (n == 1) {
                    this.mPredictedValue.setEnabled(true);
                    this.mSavedVariable.setEnabled(true);
                    if (this.mAutoNameRadio.isSelected()) {
                        object2.setEditable(false);
                        object2.setEnabled(true);
                        continue;
                    }
                    object2.setEnabled(true);
                    object2.setEditable(true);
                    continue;
                }
                object2.setEnabled(false);
                this.mPredictedValue.setEnabled(false);
                this.mSavedVariable.setEnabled(false);
            }
        }
        if (itemEvent.getSource() == this.mSavePredictedProbabilityCheck) {
            for (int i = 0; i < this.mNameOfSavedVariable.size(); ++i) {
                if (n == 1) {
                    this.mCategoryToSave.get(i).setEnabled(true);
                    this.mRootNameOfSavedVariable.get(i).setEnabled(true);
                    this.mPredictedProbability.setEnabled(true);
                    this.mRootName.setEnabled(true);
                    this.mCategories.setEnabled(true);
                    if (!this.mScaleVar.get(i).booleanValue()) {
                        if (this.mCustomNameRadio.isSelected()) {
                            this.mRootNameOfSavedVariable.get(i).setEditable(true);
                            this.mCategoryToSave.get(i).setEditable(true);
                            continue;
                        }
                        this.mRootNameOfSavedVariable.get(i).setEditable(false);
                        this.mCategoryToSave.get(i).setEditable(false);
                        continue;
                    }
                    this.mRootNameOfSavedVariable.get(i).setEnabled(false);
                    this.mCategoryToSave.get(i).setEnabled(false);
                    continue;
                }
                this.mRootNameOfSavedVariable.get(i).setEnabled(false);
                this.mCategoryToSave.get(i).setEnabled(false);
                this.mPredictedProbability.setEnabled(false);
                this.mRootName.setEnabled(false);
                this.mCategories.setEnabled(false);
            }
        }
        if (itemEvent.getSource() == this.mAutoNameRadio) {
            Object object;
            if (this.mIsRBF) {
                object = DEFAULT_DEP_VAR_NAME_RBF;
                String string = DEFAULT_DEP_ROOT_VAR_NAME_RBF;
            } else {
                object = DEFAULT_DEP_VAR_NAME_MLP;
                String string = DEFAULT_DEP_ROOT_VAR_NAME_MLP;
            }
            for (int i = 0; i < this.mNameOfSavedVariable.size(); ++i) {
                void var4_10;
                if (i > 0) {
                    object = (String)object + "_" + i;
                    String string = (String)var4_10 + "_" + i;
                }
                this.mNameOfSavedVariable.get(i).setText((String)object);
                if (this.mScaleVar.get(i).booleanValue()) {
                    this.mRootNameOfSavedVariable.get(i).setText("  ");
                } else {
                    this.mRootNameOfSavedVariable.get(i).setText((String)var4_10);
                }
                if (this.mSavePredictedValueCheck.isSelected()) {
                    this.mNameOfSavedVariable.get(i).setEnabled(true);
                    this.mNameOfSavedVariable.get(i).setEditable(false);
                } else {
                    this.mNameOfSavedVariable.get(i).setEnabled(false);
                }
                if (this.mSavePredictedProbabilityCheck.isEnabled() && this.mSavePredictedProbabilityCheck.isSelected()) {
                    this.mRootNameOfSavedVariable.get(i).setEnabled(true);
                    this.mRootNameOfSavedVariable.get(i).setEditable(false);
                    this.mCategoryToSave.get(i).setEnabled(true);
                    this.mCategoryToSave.get(i).setEditable(false);
                    continue;
                }
                this.mRootNameOfSavedVariable.get(i).setEnabled(false);
                this.mCategoryToSave.get(i).setEnabled(false);
            }
        }
        if (itemEvent.getSource() == this.mCustomNameRadio) {
            for (int i = 0; i < this.mNameOfSavedVariable.size(); ++i) {
                if (this.mSavePredictedValueCheck.isSelected()) {
                    this.mNameOfSavedVariable.get(i).setEditable(true);
                    this.mPredictedValue.setEnabled(true);
                    this.mSavedVariable.setEnabled(true);
                } else {
                    this.mNameOfSavedVariable.get(i).setEnabled(false);
                    this.mPredictedValue.setEnabled(false);
                    this.mSavedVariable.setEnabled(false);
                }
                if (this.mSavePredictedProbabilityCheck.isEnabled() && this.mSavePredictedProbabilityCheck.isSelected()) {
                    this.mRootNameOfSavedVariable.get(i).setEditable(true);
                    this.mCategoryToSave.get(i).setEnabled(true);
                    this.mCategoryToSave.get(i).setEditable(true);
                    this.mPredictedProbability.setEnabled(true);
                    this.mRootName.setEnabled(true);
                    if (this.mScaleVar.get(i).booleanValue()) {
                        this.mRootNameOfSavedVariable.get(i).setEnabled(false);
                        this.mCategoryToSave.get(i).setEnabled(false);
                        continue;
                    }
                    this.mRootNameOfSavedVariable.get(i).setEditable(true);
                    this.mCategoryToSave.get(i).setEditable(true);
                    continue;
                }
                this.mRootNameOfSavedVariable.get(i).setEnabled(false);
                this.mCategoryToSave.get(i).setEnabled(false);
                this.mPredictedProbability.setEnabled(false);
                this.mRootName.setEnabled(false);
            }
        }
    }

    public String getSaveTabSyntax() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.mSavePredictedValueCheck.isSelected() || this.mSavePredictedProbabilityCheck.isEnabled() && this.mSavePredictedProbabilityCheck.isSelected()) {
            int n;
            stringBuffer.append("\n  /SAVE ");
            if (this.mAutoNameRadio.isSelected() && this.mSavePredictedValueCheck.isSelected()) {
                stringBuffer.append("PREDVAL ");
            }
            if (this.mCustomNameRadio.isSelected() && this.mSavePredictedValueCheck.isSelected()) {
                if (this.mNameOfSavedVariable.size() > 0) {
                    stringBuffer.append("PREDVAL(");
                }
                for (n = 0; n < this.mNameOfSavedVariable.size(); ++n) {
                    stringBuffer.append(this.mNameOfSavedVariable.get(n).getText());
                    stringBuffer.append(" ");
                }
                if (this.mNameOfSavedVariable.size() > 0) {
                    stringBuffer.append(") ");
                }
            }
            if (this.mAutoNameRadio.isSelected() && this.mSavePredictedProbabilityCheck.isEnabled() && this.mSavePredictedProbabilityCheck.isSelected() && this.mCategoryToSave.size() > 0) {
                stringBuffer.append("PSEUDOPROB ");
            }
            boolean bl = false;
            if (this.mCustomNameRadio.isSelected() && this.mSavePredictedProbabilityCheck.isEnabled() && this.mSavePredictedProbabilityCheck.isSelected()) {
                if (this.mRootNameOfSavedVariable.size() > 0) {
                    stringBuffer.append("PSEUDOPROB(");
                }
                for (n = 0; n < this.mRootNameOfSavedVariable.size(); ++n) {
                    if (this.mScaleVar.get(n).booleanValue()) continue;
                    stringBuffer.append(this.mRootNameOfSavedVariable.get(n).getText());
                    stringBuffer.append(":");
                    stringBuffer.append(this.mCategoryToSave.get(n).getText());
                    stringBuffer.append(" ");
                    bl = true;
                }
                if (bl && this.mRootNameOfSavedVariable.size() > 0) {
                    stringBuffer.append(") ");
                }
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
        this.mVariablesPanel.removeAll();
        this.setupSaveVariableGrid();
        this.validate();
        this.setFocusTraversalPolicy();
        this.repaint();
    }

    @Override
    public boolean validateTab() {
        return this.doValidation();
    }

    @Override
    public void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        Object[] objectArray = dialogDataModel.getArray("IDS_MLP_SAVE_DEP_VAR_NAMES");
        Object[] objectArray2 = dialogDataModel.getArray("IDS_MLP_SAVED_VAR_NAMES");
        Object[] objectArray3 = dialogDataModel.getArray("IDS_MLP_SAVED_ROOT_VAR_NAMES");
        Object[] objectArray4 = dialogDataModel.getArray("IDS_MLP_SAVED_CATE_NAMES");
        if (objectArray2 != null && objectArray != null && objectArray3 != null && objectArray4 != null && objectArray.length == objectArray2.length && objectArray.length == objectArray3.length && objectArray.length == objectArray4.length) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.mDependentVariableNamesPre.add((String)objectArray[i]);
                this.mNameOfSavedVariablePre.add(new StringTextField(objectArray2[i].toString()));
                this.mRootNameOfSavedVariablePre.add(new StringTextField(objectArray3[i].toString()));
                IntTextField intTextField = new IntTextField();
                intTextField.setText(objectArray4[i].toString());
                this.mCategoryToSavePre.add(intTextField);
            }
        }
    }

    @Override
    public void saveTabState(DialogDataModel dialogDataModel) {
        Object[] objectArray = this.mDependentVariableNamesPre.toArray();
        dialogDataModel.putArray("IDS_MLP_SAVE_DEP_VAR_NAMES", objectArray);
        int n = 0;
        Object[] objectArray2 = new String[this.mNameOfSavedVariablePre.size()];
        for (StringTextField stringTextField : this.mNameOfSavedVariablePre) {
            objectArray2[n++] = stringTextField.getText();
        }
        dialogDataModel.putArray("IDS_MLP_SAVED_VAR_NAMES", objectArray2);
        n = 0;
        objectArray2 = new String[this.mNameOfSavedVariablePre.size()];
        for (StringTextField stringTextField : this.mRootNameOfSavedVariablePre) {
            objectArray2[n++] = stringTextField.getText();
        }
        dialogDataModel.putArray("IDS_MLP_SAVED_ROOT_VAR_NAMES", objectArray2);
        n = 0;
        objectArray2 = new String[this.mCategoryToSavePre.size()];
        for (IntTextField intTextField : this.mCategoryToSavePre) {
            objectArray2[n++] = intTextField.getText();
        }
        dialogDataModel.putArray("IDS_MLP_SAVED_CATE_NAMES", objectArray2);
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mSavePredictedValueCheck;
    }

    @Override
    protected void aboutToShowTab() {
        VarListModel varListModel;
        VariablesTab.DepVarMeasurment depVarMeasurment;
        super.aboutToShowTab();
        if (this.mIsRBF) {
            depVarMeasurment = ((NeuralNetworksRBFModelDlg)this.mParent).getVariablesTab().checkDepentVarMeasurement();
            varListModel = ((NeuralNetworksRBFModelDlg)this.mParent).getVariablesTab().getTargetListModel();
        } else {
            depVarMeasurment = ((NeuralNetworksMLPModelDlg)this.mParent).getVariablesTab().checkDepentVarMeasurement();
            varListModel = ((NeuralNetworksMLPModelDlg)this.mParent).getVariablesTab().getTargetListModel();
        }
        int n = varListModel.getSize();
        this.mDependentVariableNames.clear();
        this.mNameOfSavedVariable.clear();
        this.mRootNameOfSavedVariable.clear();
        this.mCategoryToSave.clear();
        this.mDepVariableField.clear();
        this.mScaleVar.clear();
        for (int i = 0; i < n; ++i) {
            ISpssVariable iSpssVariable = varListModel.getElementAt(i);
            String string = iSpssVariable.getName();
            if (iSpssVariable.getDisplayMeasurementLevel() == MeasurementLevel.scale) {
                this.mScaleVar.add(true);
            } else {
                this.mScaleVar.add(false);
            }
            this.mDependentVariableNames.add(string);
            StringTextField stringTextField = new StringTextField(string);
            stringTextField.setEnabled(true);
            stringTextField.setEditable(false);
            this.mDepVariableField.add(stringTextField);
            int n2 = this.mDependentVariableNamesPre.indexOf(string);
            StringTextField stringTextField2 = n2 >= 0 && this.mCustomNameRadio.isSelected() ? new StringTextField(this.mNameOfSavedVariablePre.get(n2).getText()) : new StringTextField("");
            stringTextField2.getDocument().addDocumentListener(this);
            stringTextField2.addFocusListener(this);
            this.mNameOfSavedVariable.add(stringTextField2);
            StringTextField stringTextField3 = n2 >= 0 && this.mCustomNameRadio.isSelected() ? new StringTextField(this.mRootNameOfSavedVariablePre.get(n2).getText()) : new StringTextField("");
            stringTextField3.getDocument().addDocumentListener(this);
            stringTextField3.addFocusListener(this);
            this.mRootNameOfSavedVariable.add(stringTextField3);
            IntTextField intTextField = new IntTextField(true);
            if (n2 >= 0 && this.mCustomNameRadio.isSelected()) {
                intTextField.setText(this.mCategoryToSavePre.get(n2).getText());
            } else {
                intTextField.setText(" ");
            }
            intTextField.getDocument().addDocumentListener(this);
            intTextField.addFocusListener((FocusListener)this);
            this.mCategoryToSave.add(intTextField);
        }
        this.mDependentVariableNamesPre.clear();
        this.mNameOfSavedVariablePre.clear();
        this.mRootNameOfSavedVariablePre.clear();
        this.mCategoryToSavePre.clear();
        this.mDependentVariableNamesPre = (Vector)this.mDependentVariableNames.clone();
        this.mNameOfSavedVariablePre = (Vector)this.mNameOfSavedVariable.clone();
        this.mRootNameOfSavedVariablePre = (Vector)this.mRootNameOfSavedVariable.clone();
        this.mCategoryToSavePre = (Vector)this.mCategoryToSave.clone();
        if (depVarMeasurment == VariablesTab.DepVarMeasurment.ALL_SCALE) {
            this.mSavePredictedProbabilityCheck.setEnabled(false);
            for (int i = 0; i < this.mNameOfSavedVariable.size(); ++i) {
                this.mRootNameOfSavedVariable.get(i).setEnabled(false);
                this.mCategoryToSave.get(i).setEnabled(false);
                this.mPredictedProbability.setEnabled(false);
                this.mRootName.setEnabled(false);
                this.mCategories.setEnabled(false);
            }
        } else {
            this.mSavePredictedProbabilityCheck.setEnabled(true);
            for (int i = 0; i < this.mNameOfSavedVariable.size(); ++i) {
                if (this.mSavePredictedProbabilityCheck.isSelected()) {
                    this.mCategoryToSave.get(i).setEnabled(true);
                    this.mRootNameOfSavedVariable.get(i).setEnabled(true);
                    this.mPredictedProbability.setEnabled(true);
                    this.mRootName.setEnabled(true);
                    this.mCategories.setEnabled(true);
                    if (!this.mScaleVar.get(i).booleanValue()) {
                        if (this.mAutoNameRadio.isSelected()) {
                            this.mRootNameOfSavedVariable.get(i).setEditable(false);
                            this.mCategoryToSave.get(i).setEditable(false);
                        }
                        if (!this.mCustomNameRadio.isSelected()) continue;
                        this.mRootNameOfSavedVariable.get(i).setEditable(true);
                        this.mCategoryToSave.get(i).setEditable(true);
                        continue;
                    }
                    this.mCategoryToSave.get(i).setEnabled(false);
                    this.mRootNameOfSavedVariable.get(i).setEnabled(false);
                    continue;
                }
                this.mRootNameOfSavedVariable.get(i).setEnabled(false);
                this.mCategoryToSave.get(i).setEnabled(false);
                this.mPredictedProbability.setEnabled(false);
                this.mRootName.setEnabled(false);
                this.mCategories.setEnabled(false);
            }
        }
        if (this.mSavePredictedValueCheck.isSelected()) {
            this.mSavedVariable.setEnabled(true);
            this.mPredictedValue.setEnabled(true);
        }
        this.mVariablesPanel.removeAll();
        this.setupSaveVariableGrid();
        this.validate();
        this.setFocusTraversalPolicy();
        this.repaint();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSavePredictedValueCheck);
        vector.add(this.mSavePredictedProbabilityCheck);
        for (int i = 0; i < this.mNameOfSavedVariable.size(); ++i) {
            vector.add(this.mNameOfSavedVariable.get(i));
            vector.add(this.mRootNameOfSavedVariable.get(i));
            vector.add(this.mCategoryToSave.get(i));
        }
        vector.add(this.mAutoNameRadio);
        vector.add(this.mCustomNameRadio);
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private void initialize() {
        this.initVars();
        super.initPanel();
        this.setupSaveVariableGrid();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2 * 2, n2, n2, n2);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, this.setupCheckBoxPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, 0, n2);
        DialogUtil.addUsingGBL(this, this.mVariablesLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        insets.set(0, n2, n2, n2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this, this.mVariableScrollPane, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.fill = 2;
        insets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(this, this.setupNamesOfSavedVariablesPanel(), gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.setDefaults();
        this.setFocusTraversalPolicy();
    }

    private void setDefaults() {
        this.mSavePredictedValueCheck.setEnabled(true);
        this.mSavePredictedValueCheck.setSelected(false);
        this.mSavePredictedProbabilityCheck.setSelected(false);
        VariablesTab.DepVarMeasurment depVarMeasurment = this.mIsRBF ? ((NeuralNetworksRBFModelDlg)this.mParent).getVariablesTab().checkDepentVarMeasurement() : ((NeuralNetworksMLPModelDlg)this.mParent).getVariablesTab().checkDepentVarMeasurement();
        if (depVarMeasurment == VariablesTab.DepVarMeasurment.ALL_SCALE) {
            this.mSavePredictedProbabilityCheck.setEnabled(false);
        } else {
            this.mSavePredictedProbabilityCheck.setEnabled(true);
        }
        this.mAutoNameRadio.setSelected(true);
        this.mVariablesPanel.setEnabled(false);
        this.mDependentVarible.setEnabled(true);
        this.mPredictedValue.setEnabled(false);
        this.mPredictedProbability.setEnabled(false);
        this.mSavedVariable.setEnabled(false);
        this.mRootName.setEnabled(false);
        this.mCategories.setEnabled(false);
    }

    private void initVars() {
        this.mSavePredictedValueCheck = DialogUtil.createCheckBox(this.mParent, "IDS_NNET_MLP_SAVE_PREDICTED_VALUE", null);
        this.mSavePredictedValueCheck.addItemListener(this);
        this.mSavePredictedProbabilityCheck = DialogUtil.createCheckBox(this.mParent, "IDS_NNET_MLP_SAVE_PREDICTED_PROBABILITY", null);
        this.mSavePredictedProbabilityCheck.addItemListener(this);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NNET_MLP_SAVE_AUTO_VARIABLE_NAME");
        this.mAutoNameRadio = new JRadioButton(toggleButtonAction);
        this.mAutoNameRadio.setEnabled(true);
        this.mAutoNameRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NNET_MLP_SAVE_CUSTOM_VARIABLE_NAME");
        this.mCustomNameRadio = new JRadioButton(toggleButtonAction);
        this.mCustomNameRadio.setEnabled(true);
        this.mCustomNameRadio.addItemListener(this);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mAutoNameRadio);
        spssButtonGroup.add(this.mCustomNameRadio);
        this.mVariablesPanel = PanelFactory.getEmptyPanel("");
        this.mVariablesLabel = DialogUtil.createLabel(this.mParent, "IDS_NNET_MLP_VARIABLES_LABEL");
        this.mVariablesLabel.setLabelFor(this.mVariablesPanel);
        this.mVariableScrollPane = new JScrollPane(this.mVariablesPanel);
        this.mVariablesPanel.setMinimumSize(new Dimension(300, 260));
        this.mVariableScrollPane.setPreferredSize(new Dimension(300, 260));
        this.mVariableScrollPane.setHorizontalScrollBarPolicy(31);
        this.mVariableScrollPane.setVerticalScrollBarPolicy(20);
        this.mEmpty = new JTextField("       ");
        this.mEmpty.setEditable(false);
        this.mPredictedValue = new JTextField(this.getResString("IDS_NNET_MLP_SAVE_PREDICTED_VALUE_OR_CATEGORY"));
        this.mPredictedValue.setEditable(false);
        this.mPredictedValue.setEnabled(true);
        this.mPredictedProbability = new JTextField(this.getResString("IDS_NNET_MLP_SAVE_PREDICTED_PROBABILITY_VALUE"));
        this.mPredictedProbability.setEditable(false);
        this.mPredictedProbability.setEnabled(true);
        this.mPredictedProbability.setHorizontalAlignment(0);
        this.mDependentVarible = new JTextField(this.getResString("IDS_NNET_MLP_SAVE_DEPENDENT_VARIABLE"));
        this.mDependentVarible.setEditable(false);
        this.mDependentVarible.setEnabled(true);
        this.mSavedVariable = new JTextField(this.getResString("IDS_NNET_MLP_SAVE_SAVED_VARIABLE_NAME"));
        this.mSavedVariable.setEditable(false);
        this.mSavedVariable.setEnabled(true);
        this.mRootName = new JTextField(this.getResString("IDS_NNET_MLP_SAVE_SAVED_VARIABLE_ROOT_NAME"));
        this.mRootName.setEditable(false);
        this.mRootName.setEnabled(true);
        this.mCategories = new JTextField(this.getResString("IDS_NNET_MLP_SAVE_CATEGORIES_TO_SAVE"));
        this.mCategories.setEditable(false);
        this.mCategories.setEnabled(true);
    }

    private JPanel setupCheckBoxPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, 0, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mSavePredictedValueCheck, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        insets2.set(0, 0, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mSavePredictedProbabilityCheck, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private void setupSaveVariableGrid() {
        String string;
        String string2;
        int n = this.mDependentVariableNames.size();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mVariablesPanel, this.mEmpty, gridBagConstraints, 0, 0, 1, 1, n2, null);
        DialogUtil.addUsingGBL(this.mVariablesPanel, this.mPredictedValue, gridBagConstraints, 1, 0, 1, 1, n2, null);
        DialogUtil.addUsingGBL(this.mVariablesPanel, this.mPredictedProbability, gridBagConstraints, 2, 0, 2, 1, n2, null);
        if (n == 0) {
            gridBagConstraints.weighty = 1.0;
        }
        DialogUtil.addUsingGBL(this.mVariablesPanel, this.mDependentVarible, gridBagConstraints, 0, 1, 1, 1, n2, null);
        DialogUtil.addUsingGBL(this.mVariablesPanel, this.mSavedVariable, gridBagConstraints, 1, 1, 1, 1, n2, null);
        DialogUtil.addUsingGBL(this.mVariablesPanel, this.mRootName, gridBagConstraints, 2, 1, 1, 1, n2, null);
        DialogUtil.addUsingGBL(this.mVariablesPanel, this.mCategories, gridBagConstraints, 3, 1, 1, 1, n2, null);
        if (this.mIsRBF) {
            string2 = DEFAULT_DEP_VAR_NAME_RBF;
            string = DEFAULT_DEP_ROOT_VAR_NAME_RBF;
        } else {
            string2 = DEFAULT_DEP_VAR_NAME_MLP;
            string = DEFAULT_DEP_ROOT_VAR_NAME_MLP;
        }
        for (int i = 0; i < n; ++i) {
            int n3 = i + 2;
            if (i == n - 1) {
                gridBagConstraints.weighty = 1.0;
            }
            DialogUtil.addUsingGBL(this.mVariablesPanel, (JComponent)((Object)this.mDepVariableField.get(i)), gridBagConstraints, 0, n3, 1, 1, n2, null);
            if (i > 0) {
                string2 = string2 + "_" + i;
                string = string + "_" + i;
            }
            if (this.mAutoNameRadio.isSelected() || this.mNameOfSavedVariable.get(i).getText().length() == 0) {
                this.mNameOfSavedVariable.get(i).setText(string2);
            }
            if (this.mScaleVar.get(i).booleanValue()) {
                this.mRootNameOfSavedVariable.get(i).setText("  ");
            } else if (this.mAutoNameRadio.isSelected() || this.mRootNameOfSavedVariable.get(i).getText().length() == 0) {
                this.mRootNameOfSavedVariable.get(i).setText(string);
            }
            this.mNameOfSavedVariable.get(i).setEnabled(false);
            this.mRootNameOfSavedVariable.get(i).setEnabled(false);
            if (this.mSavePredictedValueCheck.isSelected()) {
                this.mNameOfSavedVariable.get(i).setEnabled(true);
                if (this.mAutoNameRadio.isSelected()) {
                    this.mNameOfSavedVariable.get(i).setEditable(false);
                } else {
                    this.mNameOfSavedVariable.get(i).setEditable(true);
                }
            }
            if (this.mSavePredictedProbabilityCheck.isEnabled() && this.mSavePredictedProbabilityCheck.isSelected()) {
                this.mRootNameOfSavedVariable.get(i).setEnabled(true);
                if (!this.mScaleVar.get(i).booleanValue()) {
                    if (this.mAutoNameRadio.isSelected()) {
                        this.mRootNameOfSavedVariable.get(i).setEditable(false);
                    } else {
                        this.mRootNameOfSavedVariable.get(i).setEditable(true);
                    }
                } else {
                    this.mRootNameOfSavedVariable.get(i).setEnabled(false);
                }
            }
            DialogUtil.addUsingGBL(this.mVariablesPanel, (JComponent)((Object)this.mNameOfSavedVariable.get(i)), gridBagConstraints, 1, n3, 1, 1, n2, null);
            DialogUtil.addUsingGBL(this.mVariablesPanel, (JComponent)((Object)this.mRootNameOfSavedVariable.get(i)), gridBagConstraints, 2, n3, 1, 1, n2, null);
            if (this.mAutoNameRadio.isSelected() || this.mCategoryToSave.get(i).getText().length() == 0) {
                this.mCategoryToSave.get(i).setText("25");
            }
            this.mCategoryToSave.get(i).setEnabled(false);
            if (this.mSavePredictedProbabilityCheck.isEnabled() && this.mSavePredictedProbabilityCheck.isSelected() && !this.mScaleVar.get(i).booleanValue()) {
                this.mCategoryToSave.get(i).setEnabled(true);
                this.mCategoryToSave.get(i).setEditable(true);
            } else {
                this.mCategoryToSave.get(i).setEnabled(false);
            }
            DialogUtil.addUsingGBL(this.mVariablesPanel, (JComponent)this.mCategoryToSave.get(i), gridBagConstraints, 3, n3, 1, 1, n2, null);
        }
    }

    private JPanel setupNamesOfSavedVariablesPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_NNET_MLP_SAVE_SAVED_VARIABLE_NAMES"));
        jPanel.setBorder(titledBorder);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setRows(2);
        jTextArea.setOpaque(false);
        jTextArea.setFont(this.mAutoNameRadio.getFont());
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setText(this.getResString("IDS_NNET_MLP_SAVE_AUTO_VARIABLE_NAME_MESG"));
        jTextArea.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n, 0, n);
        int n2 = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mAutoNameRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        insets.set(0, n * 5, 0, n);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(0, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mCustomNameRadio, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        JTextArea jTextArea2 = new JTextArea();
        jTextArea2.setRows(2);
        jTextArea2.setOpaque(false);
        jTextArea2.setFont(this.mCustomNameRadio.getFont());
        jTextArea2.setLineWrap(true);
        jTextArea2.setWrapStyleWord(true);
        jTextArea2.setText(this.getResString("IDS_NNET_MLP_SAVE_CUSTOM_VARIABLE_NAME_MESG"));
        jTextArea.setFocusable(false);
        gridBagConstraints.weighty = 1.0;
        insets.set(0, n * 5, 0, n);
        DialogUtil.addUsingGBL(jPanel, jTextArea2, gridBagConstraints, 0, 3, 1, 1, n2, insets);
        return jPanel;
    }

    private boolean doValidation() {
        if (this.mSavePredictedValueCheck.isSelected() || this.mSavePredictedProbabilityCheck.isEnabled() && this.mSavePredictedProbabilityCheck.isSelected()) {
            for (int i = 0; i < this.mNameOfSavedVariable.size(); ++i) {
                String string = this.mNameOfSavedVariable.get(i).getText();
                String string2 = this.mRootNameOfSavedVariable.get(i).getText();
                boolean bl = this.mCategoryToSave.get(i).isEnabled();
                String string3 = this.mCategoryToSave.get(i).getText();
                boolean bl2 = this.mScaleVar.get(i);
                if (this.mSavePredictedValueCheck.isSelected() && string.length() > 64 || this.mSavePredictedProbabilityCheck.isEnabled() && this.mSavePredictedProbabilityCheck.isSelected() && string2.length() > 64) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_MLP_SAVE_WARNING_MESG3"), VersionInfo.getAppVersionString());
                    if (string.length() > 64) {
                        NeuralNetworksMLPModelDlg.setSelectionText((JComponent)((Object)this.mNameOfSavedVariable.get(i)));
                    } else {
                        NeuralNetworksMLPModelDlg.setSelectionText((JComponent)((Object)this.mRootNameOfSavedVariable.get(i)));
                    }
                    return false;
                }
                if (this.mSavePredictedValueCheck.isSelected() && (string.equals("") || VarNameValidator.validateSPSSName((String)string, (boolean)false) != VarNameValidator.ValidNameCode.SPSSNAME_STANDARD)) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_MLP_SAVE_WARNING_MESG1"), VersionInfo.getAppVersionString());
                    NeuralNetworksMLPModelDlg.setSelectionText((JComponent)((Object)this.mNameOfSavedVariable.get(i)));
                    return false;
                }
                if (this.mSavePredictedProbabilityCheck.isEnabled() && this.mSavePredictedProbabilityCheck.isSelected() && !bl2 && (string2.equals("") || VarNameValidator.validateSPSSName((String)string2, (boolean)false) != VarNameValidator.ValidNameCode.SPSSNAME_STANDARD)) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_MLP_SAVE_WARNING_MESG2"), VersionInfo.getAppVersionString());
                    this.mRootNameOfSavedVariable.get(i).requestFocusInWindow();
                    return false;
                }
                if (!this.mSavePredictedProbabilityCheck.isEnabled() || !this.mSavePredictedProbabilityCheck.isSelected() || bl2 || !bl || !string3.equals("") && Integer.parseInt(string3) != 0) continue;
                SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_MLP_SAVE_WARNING_MESG5"), VersionInfo.getAppVersionString());
                NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mCategoryToSave.get(i));
                return false;
            }
        }
        return true;
    }

    public String getDeleteVariableNameSyntax() {
        StringBuffer stringBuffer = new StringBuffer("");
        StringBuffer stringBuffer2 = new StringBuffer("");
        if (this.mSavePredictedValueCheck.isSelected() && this.mCustomNameRadio.isSelected()) {
            LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            for (StringTextField stringTextField : this.mNameOfSavedVariable) {
                String string = stringTextField.getText();
                if (iSpssDataSrc.findVarIndex(string) > -1) {
                    stringBuffer2.append(" ");
                    stringBuffer2.append(string);
                }
                Vector<String> vector = DocUtil.findVariablesWithRootName(string);
                for (String string2 : vector) {
                    if (stringBuffer2.indexOf(string2) >= 0) continue;
                    stringBuffer2.append(" ");
                    stringBuffer2.append(string2);
                }
            }
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append("\nDELETE VARIABLES ").append(stringBuffer2.toString());
        }
        return stringBuffer.toString();
    }

    public String getDeleteRootVariableNameSyntax() {
        StringBuffer stringBuffer = new StringBuffer("");
        StringBuffer stringBuffer2 = new StringBuffer("");
        if (this.mSavePredictedProbabilityCheck.isEnabled() && this.mSavePredictedProbabilityCheck.isSelected() && this.mCustomNameRadio.isSelected()) {
            LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            for (StringTextField stringTextField : this.mRootNameOfSavedVariable) {
                String string = stringTextField.getText();
                if (iSpssDataSrc.findVarIndex(string) > -1) {
                    stringBuffer2.append(" ");
                    stringBuffer2.append(string);
                }
                Vector<String> vector = DocUtil.findVariablesWithRootName(string);
                for (String string2 : vector) {
                    if (stringBuffer2.indexOf(string2) >= 0) continue;
                    stringBuffer2.append(" ");
                    stringBuffer2.append(string2);
                }
            }
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append("\nDELETE VARIABLES ").append(stringBuffer2.toString());
        }
        return stringBuffer.toString();
    }
}

