/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.neural_networks;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.adv_stats.neural_networks.NeuralNetworksMLPModelDlg;
import com.spss.java_client.ui.dialogs.adv_stats.neural_networks.NeuralNetworksRBFModelDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RBFArchitectureTab
extends BaseProcedureTab
implements ItemListener,
FocusListener,
DocumentListener {
    private static String RANGE_MINIMUM = "IDS_RBF_RANGE_MINIMUM";
    private static String RANGE_MAXIMUM = "IDS_RBF_RANGE_MAXIMUM";
    private static String NUM_UNITS = "IDS_RBF_NUM_UNITS";
    private static String OVERLAPPING_FACTOR = "IDS_RBF_OVERLAPPING_FACTOR";
    private final int LEFT_SIDE_WIDTH = 300;
    private final int RIGHT_SIDE_WIDTH = 80;
    private SpssButtonGroup mNumUnitsGrp;
    private JRadioButton mFindNumberRadio;
    private JRadioButton mSpecifyNumberRadio;
    private JLabel mNumberLabel;
    private IntTextField mNumberField;
    private JPanel mNumUnitsPanel;
    private Dimension mPanelDimension;
    private JPanel mRangePanel;
    private SpssButtonGroup mRangeGrp;
    private JRadioButton mAutoRangeRadio;
    private JRadioButton mSpecifyRangeRadio;
    private JLabel mMinLabel;
    private IntTextField mMinField;
    private JLabel mMaxLabel;
    private IntTextField mMaxField;
    private SpssButtonGroup mActvFunctionGrp;
    private JRadioButton mNormalizedRadio;
    private JRadioButton mOrdinaryRadio;
    private JPanel mActvFunctionPanel;
    private SpssButtonGroup mOverlapGrp;
    private JRadioButton mOverlapAutoComputeRadio;
    private JRadioButton mOverlapSpecifiedRadio;
    private JLabel mOverlapSpecifiedLabel;
    private FloatTextField mOverlapSpecifiedField;
    private JPanel mOverlapPanel;
    private JSeparator mSeparator;

    public RBFArchitectureTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
        this.initilaizePanel();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mFindNumberRadio;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_rbf_architecture";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mFindNumberRadio) {
            DialogUtil.enableTitledBorder(this.mRangePanel, true);
            this.validate();
            this.repaint();
            this.mSpecifyRangeRadio.setEnabled(true);
            this.mAutoRangeRadio.setEnabled(true);
            if (this.mSpecifyRangeRadio.isSelected()) {
                this.mMinField.setEnabled(true);
                this.mMinLabel.setEnabled(true);
                this.mMaxField.setEnabled(true);
                this.mMaxLabel.setEnabled(true);
            } else {
                this.mMinField.setEnabled(false);
                this.mMinLabel.setEnabled(false);
                this.mMaxField.setEnabled(false);
                this.mMaxLabel.setEnabled(false);
            }
            this.mNumberField.setEnabled(false);
            this.mNumberLabel.setEnabled(false);
        }
        if (object == this.mSpecifyNumberRadio) {
            DialogUtil.enableTitledBorder(this.mRangePanel, false);
            this.mSpecifyRangeRadio.setEnabled(false);
            this.mAutoRangeRadio.setEnabled(false);
            this.mMinField.setEnabled(false);
            this.mMinLabel.setEnabled(false);
            this.mMaxField.setEnabled(false);
            this.mMaxLabel.setEnabled(false);
            this.mNumberField.setEnabled(true);
            this.mNumberLabel.setEnabled(true);
            this.validate();
            this.repaint();
        }
        if (object == this.mSpecifyRangeRadio) {
            this.mMinField.setEnabled(true);
            this.mMinLabel.setEnabled(true);
            this.mMaxField.setEnabled(true);
            this.mMaxLabel.setEnabled(true);
        }
        if (object == this.mAutoRangeRadio) {
            this.mMinField.setEnabled(false);
            this.mMinLabel.setEnabled(false);
            this.mMaxField.setEnabled(false);
            this.mMaxLabel.setEnabled(false);
        }
        if (object == this.mOverlapAutoComputeRadio) {
            this.mOverlapSpecifiedField.setEnabled(false);
            this.mOverlapSpecifiedLabel.setEnabled(false);
        }
        if (object == this.mOverlapSpecifiedRadio) {
            this.mOverlapSpecifiedField.setEnabled(true);
            this.mOverlapSpecifiedLabel.setEnabled(true);
        }
    }

    @Override
    public boolean validateTab() {
        return this.doValidation();
    }

    protected void initilaizePanel() {
        super.initPanel();
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = 23;
        Insets insets = new Insets(n * 2, n, n, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        this.setupNumUnitsPanel();
        this.mPanelDimension = this.mNumUnitsPanel.getPreferredSize();
        this.mPanelDimension.width = 300;
        this.mNumUnitsPanel.setPreferredSize(this.mPanelDimension);
        double d = this.mPanelDimension.getWidth();
        DialogUtil.addUsingGBL(this, this.mNumUnitsPanel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        JLabel jLabel = new JLabel("                  ");
        Dimension dimension = jLabel.getPreferredSize();
        dimension.width = 80;
        jLabel.setPreferredSize(dimension);
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        this.setupActivationFunctionPanel();
        dimension = this.mActvFunctionPanel.getPreferredSize();
        dimension.width = (int)d;
        this.mActvFunctionPanel.setPreferredSize(dimension);
        DialogUtil.addUsingGBL(this, this.mActvFunctionPanel, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        this.setupOverlappingPanel();
        dimension = this.mOverlapPanel.getPreferredSize();
        dimension.width = (int)d;
        this.mOverlapPanel.setPreferredSize(dimension);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, this.mOverlapPanel, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        this.setFocusTraversalPolicy();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mFindNumberRadio);
        vector.add(this.mSpecifyNumberRadio);
        vector.add(this.mAutoRangeRadio);
        vector.add(this.mSpecifyRangeRadio);
        vector.add(this.mMinField);
        vector.add(this.mMaxField);
        vector.add(this.mNumberField);
        vector.add(this.mNormalizedRadio);
        vector.add(this.mOrdinaryRadio);
        vector.add(this.mOverlapAutoComputeRadio);
        vector.add(this.mOverlapSpecifiedRadio);
        vector.add(this.mOverlapSpecifiedField);
        JPanel jPanel = ((NeuralNetworksRBFModelDlg)this.mParent).getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private boolean doValidation() {
        try {
            String string;
            int n = 0;
            if (this.mMinField.isEnabled() && ((string = this.mMinField.getText()).equals("") || string.length() > 0 && (n = Integer.valueOf(string).intValue()) == 0)) {
                SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_RBF_ARCH_WARNING_MESG1"), VersionInfo.getAppVersionString());
                NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mMinField);
                return false;
            }
            if (this.mMaxField.isEnabled() && ((string = this.mMaxField.getText()).equals("") || string.length() > 0 && Integer.valueOf(string) <= n)) {
                SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_RBF_ARCH_WARNING_MESG2"), VersionInfo.getAppVersionString());
                NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mMaxField);
                return false;
            }
            if (this.mNumberField.isEnabled() && ((string = this.mNumberField.getText()).equals("") || string.length() > 0 && Integer.valueOf(string) == 0)) {
                SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_RBF_ARCH_WARNING_MESG3"), VersionInfo.getAppVersionString());
                NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mNumberField);
                return false;
            }
            if (this.mOverlapSpecifiedField.isEnabled() && ((string = this.mOverlapSpecifiedField.getText()).equals("") || string.length() > 0 && Double.valueOf(string) == 0.0)) {
                SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_RBF_ARCH_WARNING_MESG4"), VersionInfo.getAppVersionString());
                NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mOverlapSpecifiedField);
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getRBFArchSyntax() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\n  /ARCHITECTURE ");
        if (this.mFindNumberRadio.isSelected()) {
            if (this.mAutoRangeRadio.isSelected()) {
                stringBuffer.append("MINUNITS=AUTO MAXUNITS=AUTO ");
            } else if (this.mMinField.getText().length() > 0 && this.mMaxField.getText().length() > 0) {
                stringBuffer.append("MINUNITS=");
                stringBuffer.append(Integer.parseInt(this.mMinField.getText()));
                stringBuffer.append(" MAXUNITS=");
                stringBuffer.append(Integer.parseInt(this.mMaxField.getText()));
                stringBuffer.append(" ");
            }
        }
        if (this.mSpecifyNumberRadio.isSelected() && this.mNumberField.getText().length() > 0) {
            stringBuffer.append("NUMUNITS=");
            stringBuffer.append(Integer.parseInt(this.mNumberField.getText()));
            stringBuffer.append(" ");
        }
        if (this.mNormalizedRadio.isSelected()) {
            stringBuffer.append("HIDDENFUNCTION=NRBF ");
        } else {
            stringBuffer.append("HIDDENFUNCTION=ORBF ");
        }
        stringBuffer.append("\n  /CRITERIA ");
        if (this.mOverlapAutoComputeRadio.isSelected()) {
            stringBuffer.append("OVERLAP=AUTO ");
        } else if (this.mOverlapSpecifiedRadio.isSelected()) {
            stringBuffer.append("OVERLAP=");
            if (this.mOverlapSpecifiedField.getText().length() > 0) {
                stringBuffer.append(Double.parseDouble(this.mOverlapSpecifiedField.getText()));
                stringBuffer.append(" ");
            }
        }
        return stringBuffer.toString();
    }

    private void setDefaults() {
        this.mFindNumberRadio.setSelected(true);
        this.mAutoRangeRadio.setSelected(true);
        this.mMinLabel.setEnabled(false);
        this.mMinField.setEnabled(false);
        this.mMaxField.setEnabled(false);
        this.mMaxLabel.setEnabled(false);
        this.mNumberLabel.setEnabled(false);
        this.mNumberField.setEnabled(false);
        this.mNormalizedRadio.setSelected(true);
        this.mOverlapAutoComputeRadio.setSelected(true);
        this.mOverlapSpecifiedLabel.setEnabled(false);
        this.mOverlapSpecifiedField.setEnabled(false);
    }

    private void initVars() {
        this.mNumUnitsPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_NNET_RBF_ARCH_NUM_UNITS_IN_HIDDEN_LAYER"));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NNET_RBF_ARCH_FIND_BEST_NUM_UNITS");
        this.mFindNumberRadio = new JRadioButton(toggleButtonAction);
        this.mFindNumberRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NNET_RBF_ARCH_SPECIFIED_UNITS");
        this.mSpecifyNumberRadio = new JRadioButton(toggleButtonAction);
        this.mSpecifyNumberRadio.addItemListener(this);
        this.mNumUnitsGrp = new SpssButtonGroup();
        this.mNumUnitsGrp.add(this.mFindNumberRadio);
        this.mNumUnitsGrp.add(this.mSpecifyNumberRadio);
        this.mRangePanel = PanelFactory.getEmptyPanel(this.getResString("IDS_NNET_RBF_ARCH_RANGE"));
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NNET_RBF_ARCH_AUTO_COMPUTE_RANGE");
        this.mAutoRangeRadio = new JRadioButton(toggleButtonAction);
        this.mAutoRangeRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NNET_RBF_ARCH_SPECIFIED_RANGE");
        this.mSpecifyRangeRadio = new JRadioButton(toggleButtonAction);
        this.mSpecifyRangeRadio.addItemListener(this);
        this.mRangeGrp = new SpssButtonGroup();
        this.mRangeGrp.add(this.mAutoRangeRadio);
        this.mRangeGrp.add(this.mSpecifyRangeRadio);
        this.mMinLabel = DialogUtil.createLabel(this.mParent, "IDS_NNET_RBF_ARCH_MIN_RANGE");
        this.mMinField = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mMinField.setAction((Action)new TextFieldAction(this.mParent, RANGE_MINIMUM));
        this.mMinField.setColumns(5);
        this.mMinField.addFocusListener((FocusListener)this);
        this.mMinField.getDocument().addDocumentListener(this);
        this.mMinLabel.setLabelFor((Component)this.mMinField);
        this.mMaxLabel = DialogUtil.createLabel(this.mParent, "IDS_NNET_RBF_ARCH_MAX_RANGE");
        this.mMaxField = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mMaxField.setAction((Action)new TextFieldAction(this.mParent, RANGE_MAXIMUM));
        this.mMaxField.setColumns(5);
        this.mMaxField.addFocusListener((FocusListener)this);
        this.mMaxField.getDocument().addDocumentListener(this);
        this.mMaxLabel.setLabelFor((Component)this.mMaxField);
        this.mNumberLabel = DialogUtil.createLabel(this.mParent, "IDS_NNET_RBF_ARCH_UNIT_NUMBER");
        this.mNumberField = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mNumberField.setAction((Action)new TextFieldAction(this.mParent, NUM_UNITS));
        this.mNumberField.setColumns(5);
        this.mNumberField.addFocusListener((FocusListener)this);
        this.mNumberField.getDocument().addDocumentListener(this);
        this.mNumberLabel.setLabelFor((Component)this.mNumberField);
        this.mActvFunctionPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_NNET_RBF_ARCH_ACTIVATION_FUNCTION"));
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NNET_RBF_ARCH_ACTIVATION_FUNCTION_NORMALIZED");
        this.mNormalizedRadio = new JRadioButton(toggleButtonAction);
        this.mNormalizedRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NNET_RBF_ARCH_ACTIVATION_FUNCTION_ORDINARY");
        this.mOrdinaryRadio = new JRadioButton(toggleButtonAction);
        this.mOrdinaryRadio.addItemListener(this);
        this.mActvFunctionGrp = new SpssButtonGroup();
        this.mActvFunctionGrp.add(this.mNormalizedRadio);
        this.mActvFunctionGrp.add(this.mOrdinaryRadio);
        this.mOverlapPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_NNET_RBF_ARCH_OVERLAP"));
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NNET_RBF_ARCH_AUTO_OVERLAP");
        this.mOverlapAutoComputeRadio = new JRadioButton(toggleButtonAction);
        this.mOverlapAutoComputeRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NNET_RBF_ARCH_SPECIFIED_OVERLAP");
        this.mOverlapSpecifiedRadio = new JRadioButton(toggleButtonAction);
        this.mOverlapSpecifiedRadio.addItemListener(this);
        this.mOverlapGrp = new SpssButtonGroup();
        this.mOverlapGrp.add(this.mOverlapAutoComputeRadio);
        this.mOverlapGrp.add(this.mOverlapSpecifiedRadio);
        this.mOverlapSpecifiedLabel = DialogUtil.createLabel(this.mParent, "IDS_NNET_RBF_ARCH_OVERLAP_FACTOR");
        this.mOverlapSpecifiedField = new FloatTextField(true);
        this.mOverlapSpecifiedField.setAction((Action)new TextFieldAction(this.mParent, OVERLAPPING_FACTOR));
        this.mOverlapSpecifiedField.addFocusListener((FocusListener)this);
        this.mOverlapSpecifiedField.setColumns(5);
        this.mOverlapSpecifiedField.getDocument().addDocumentListener(this);
        this.mOverlapSpecifiedLabel.setLabelFor((Component)this.mOverlapSpecifiedField);
        this.mSeparator = new JSeparator();
    }

    private void setupActivationFunctionPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(this.mActvFunctionPanel, this.mNormalizedRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mActvFunctionPanel, this.mOrdinaryRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
    }

    private void setupRangePanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        int n2 = 23;
        DialogUtil.addUsingGBL(this.mRangePanel, this.mAutoRangeRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.mRangePanel, this.mSpecifyRangeRadio, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets2.set(insets.top, 45, insets.bottom, 0);
        JPanel jPanel = this.setupOneTextFieldPanel(this.mMinLabel, (JTextField)this.mMinField);
        DialogUtil.addUsingGBL(this.mRangePanel, jPanel, gridBagConstraints, 0, 2, 1, 1, n2, insets2);
        insets2.set(insets.top * 2, 45, insets.bottom * 2, 0);
        jPanel = this.setupOneTextFieldPanel(this.mMaxLabel, (JTextField)this.mMaxField);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mRangePanel, jPanel, gridBagConstraints, 0, 3, 1, 1, n2, insets2);
    }

    private void setupNumUnitsPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = 23;
        DialogUtil.addUsingGBL(this.mNumUnitsPanel, this.mFindNumberRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        Insets insets2 = new Insets(0, 20, n, DialogUtil.getGroupBoxInnerMargin());
        gridBagConstraints.fill = 2;
        this.setupRangePanel();
        DialogUtil.addUsingGBL(this.mNumUnitsPanel, this.mRangePanel, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        Dimension dimension = this.mSeparator.getPreferredSize();
        dimension.width = 300;
        this.mSeparator.setPreferredSize(dimension);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mNumUnitsPanel, this.mSeparator, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.mNumUnitsPanel, this.mSpecifyNumberRadio, gridBagConstraints, 0, 3, 1, 1, n2, insets);
        JPanel jPanel = this.setupOneTextFieldPanel(this.mNumberLabel, (JTextField)this.mNumberField);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets2.set(insets.top, 45, insets.bottom, 0);
        DialogUtil.addUsingGBL(this.mNumUnitsPanel, jPanel, gridBagConstraints, 0, 4, 1, 1, n2, insets2);
    }

    private void setupOverlappingPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, insets.left, insets.bottom, insets.right);
        int n2 = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mOverlapPanel, this.mOverlapAutoComputeRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        DialogUtil.addUsingGBL(this.mOverlapPanel, this.mOverlapSpecifiedRadio, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        JPanel jPanel = this.setupOneTextFieldPanel(this.mOverlapSpecifiedLabel, (JTextField)this.mOverlapSpecifiedField);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets2.set(insets.top, 45, insets.bottom * 3, 0);
        DialogUtil.addUsingGBL(this.mOverlapPanel, jPanel, gridBagConstraints, 0, 2, 1, 1, n2, insets2);
    }

    private JPanel setupOneTextFieldPanel(JLabel jLabel, JTextField jTextField) {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(0, 0, n2, n2 * 2);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        insets.set(0, n2 * 2, n2, 0);
        DialogUtil.addUsingGBL(jPanel, jTextField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }
}

