/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.neural_networks;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.adv_stats.neural_networks.NeuralNetworksMLPModelDlg;
import com.spss.java_client.ui.dialogs.adv_stats.neural_networks.NeuralNetworksRBFModelDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PartitionsTab
extends BaseProcedureTab
implements CaretListener,
ItemListener,
DocumentListener {
    private static final String RANDOMLY_ASSIGN_KEY = "IDS_NNET_MLP_RANDOMLY_CASES_LABEL";
    private static final String USE_PARTITIONING_KEY = "IDS_NNET_MLP_USE_PARTITIONING_LABEL";
    private static final String TARGET_PARTIONING_VARIBLE_KEY = "IDS_NNET_MLP_PARTITION_VARIABLES_LABEL";
    private static final String SOURCE_LIST_KEY = "IDS_MLP_SOURCE_LIST_KEY";
    private static final String TRAINING_NUMBER = "IDS_MLP_TRAINING_NUMBER";
    private static final String TESTING_NUMBER = "IDS_MLP_TESTING_NUMBER";
    private static final String HOLDOUT_NUMBER = "IDS_MLP_HOLDOUT_NUMBER";
    private static final String TRAINING_PERCENT = "IDS_MLP_TRAINING_PERCENT";
    private static final String TESTING_PERCENT = "IDS_MLP_TESTING_PERCENT";
    private static final String HOLDOUT_PERCENT = "IDS_MLP_HOLDOUT_PERCENT";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mPartitioningVariable;
    private JRadioButton mUseRandomlyRadio;
    private JRadioButton mUsePartioningRadio;
    private JScrollPane mSrcScrollPane;
    private JPanel mPartitionDatasetPanel;
    private ArrowButton mPartitioningArrow;
    private SpssButtonGroup mPartitionDatasetGroup;
    private Vector<Object> mComponent;
    private IntTextField mTrainingNumber;
    private FloatTextField mTrainingPercent;
    private IntTextField mTestNumber;
    private FloatTextField mTestPercent;
    private IntTextField mHoldoutNumber;
    private FloatTextField mHoldoutPercent;
    private IntTextField mTotalNumber;
    private JTextField mOneHundredField;
    private int mNumTrainRecords = 7;
    private int mTestRecords = 3;
    private int mHoldoutRecords = 0;
    private StringBuffer mSyntax;
    private boolean mIsRBF;

    public PartitionsTab(BaseTabbedDialog baseTabbedDialog, boolean bl) {
        super(baseTabbedDialog, true);
        this.mIsRBF = bl;
        this.initializePanel();
    }

    public JPanel setUpListPanel(JComponent[] jComponentArray) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(jComponentArray[2]);
        jScrollPane.setPreferredSize(jComponentArray[2].getMinimumSize());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jComponentArray[0], gridBagConstraints, 1, 0, 1, 1, 23, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n - 5, 0, 0, DialogUtil.getArrowButtonInsets().right);
        DialogUtil.addUsingGBL(jPanel, jComponentArray[1], gridBagConstraints, 0, 0, 1, 2, 23, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(0, 0, 0, n * 10);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 1, 23, insets);
        return jPanel;
    }

    @Override
    public void reset() {
        VarListModel varListModel = this.mSrcVarList.getModel();
        if (this.mPartitioningVariable.getModel().getSize() > 0) {
            varListModel.addElement(this.mPartitioningVariable.getModel().getElementAt(0));
        }
        this.setDefaults();
        this.mPartitioningVariable.removeAll();
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mSrcVarList;
    }

    @Override
    public String getDialogHelpID() {
        if (this.mIsRBF) {
            return "idh_idd_rbf_partitions";
        }
        return "idh_idd_mlp_partitions";
    }

    public TargetVariableList getPartioningVariable() {
        return this.mPartitioningVariable;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mUseRandomlyRadio) {
            this.mTrainingNumber.setEditable(true);
            this.mTrainingNumber.setEnabled(true);
            this.mTestNumber.setEditable(true);
            this.mTestNumber.setEnabled(true);
            this.mHoldoutNumber.setEditable(true);
            this.mHoldoutNumber.setEnabled(true);
            this.mTrainingPercent.setEnabled(true);
            this.mTestPercent.setEnabled(true);
            this.mHoldoutPercent.setEnabled(true);
            this.mTotalNumber.setEnabled(true);
            this.mPartitioningArrow.setEnabled(false);
            this.mPartitioningVariable.setEnabled(false);
        } else if (object == this.mUsePartioningRadio) {
            this.mTrainingNumber.setEditable(false);
            this.mTrainingNumber.setEnabled(false);
            this.mTestNumber.setEditable(false);
            this.mTestNumber.setEnabled(false);
            this.mHoldoutNumber.setEditable(false);
            this.mHoldoutNumber.setEnabled(false);
            this.mTrainingPercent.setEnabled(false);
            this.mTestPercent.setEnabled(false);
            this.mHoldoutPercent.setEnabled(false);
            this.mTotalNumber.setEnabled(false);
            this.mPartitioningArrow.setEnabled(true);
            this.mPartitioningVariable.setEnabled(true);
        }
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        try {
            Object object = caretEvent.getSource();
            if (object == this.mTrainingNumber || object == this.mTestNumber || object == this.mHoldoutNumber) {
                String string = this.mTrainingNumber.getText();
                String string2 = this.mTestNumber.getText();
                String string3 = this.mHoldoutNumber.getText();
                this.mNumTrainRecords = 0;
                this.mTestRecords = 0;
                this.mHoldoutRecords = 0;
                int n = 0;
                if (!string.equals("")) {
                    this.mNumTrainRecords = Integer.parseInt(string);
                    n += this.mNumTrainRecords;
                }
                if (!string2.equals("")) {
                    this.mTestRecords = Integer.parseInt(string2);
                    n += this.mTestRecords;
                }
                if (!string3.equals("")) {
                    this.mHoldoutRecords = Integer.parseInt(string3);
                    n += this.mHoldoutRecords;
                }
                if (n > 0) {
                    NumberFormat numberFormat = NumberFormat.getNumberInstance();
                    numberFormat.setMaximumFractionDigits(2);
                    this.mTotalNumber.setText(Integer.toString(n));
                    double d = 100.0 * (double)this.mNumTrainRecords / (double)n;
                    this.mTrainingPercent.setText(numberFormat.format(d));
                    d = 100.0 * (double)this.mTestRecords / (double)n;
                    this.mTestPercent.setText(numberFormat.format(d));
                    d = 100.0 * (double)this.mHoldoutRecords / (double)n;
                    this.mHoldoutPercent.setText(numberFormat.format(d));
                    this.mOneHundredField.setText("100");
                } else {
                    this.mTotalNumber.setText("0");
                    this.mTrainingPercent.setText("0.0");
                    this.mTestPercent.setText("0.0");
                    this.mHoldoutPercent.setText("0.0");
                    this.mOneHundredField.setText("0");
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public String getSyntax() {
        StringBuffer stringBuffer = new StringBuffer("\n  /PARTITION");
        if (this.mUseRandomlyRadio.isSelected() && this.mUseRandomlyRadio.isEnabled()) {
            stringBuffer.append("  TRAINING=");
            stringBuffer.append(this.mNumTrainRecords);
            stringBuffer.append("  TESTING=");
            stringBuffer.append(this.mTestRecords);
            stringBuffer.append("  HOLDOUT=");
            stringBuffer.append(this.mHoldoutRecords);
        }
        if (this.mUsePartioningRadio.isSelected() && this.mUsePartioningRadio.isEnabled()) {
            stringBuffer.append("  VARIABLE=");
            stringBuffer.append(this.mPartitioningVariable.getModel().getElementAt(0).getName());
        }
        return stringBuffer.toString();
    }

    VarListModel getSrcVariableList() {
        return this.mSrcVarList.getModel();
    }

    public int getTestRecords() {
        int n = 0;
        if (!this.mTrainingNumber.getText().equals("")) {
            n = Integer.parseInt(this.mTrainingNumber.getText());
        }
        return n;
    }

    public boolean usePartitioningVariable() {
        return this.mUsePartioningRadio.isSelected();
    }

    protected void initializePanel() {
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2 * 2, n2, n2, n2);
        DialogUtil.addUsingGBL(this, this.setupSourcePanel(), gridBagConstraints, 0, 0, 1, 2, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        this.setupPartitionDatasetPanel();
        DialogUtil.addUsingGBL(this, this.mPartitionDatasetPanel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.setDefaults();
        this.setFocusTraversalPolicy();
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        if (this.mSrcVarList.getModel().getSize() > 0) {
            this.mSrcVarList.setSelectedIndex(0);
        }
    }

    @Override
    public boolean validateTab() {
        return this.doValidation();
    }

    private boolean doValidation() {
        block13: {
            if (this.mUseRandomlyRadio.isEnabled() && this.mUseRandomlyRadio.isSelected()) {
                boolean bl;
                String string = this.mTrainingNumber.getText();
                String string2 = this.mTestNumber.getText();
                String string3 = this.mHoldoutNumber.getText();
                boolean bl2 = !string.equals("");
                boolean bl3 = !string2.equals("");
                boolean bl4 = bl = !string3.equals("");
                if (!(bl2 && bl3 && bl)) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_MLP_PARTITION_WARNING1"), VersionInfo.getAppVersionString());
                    if (!bl2) {
                        NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mTrainingNumber);
                    } else if (!bl3) {
                        NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mTestNumber);
                    } else {
                        NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mHoldoutNumber);
                    }
                    return false;
                }
                if (this.mNumTrainRecords == 0) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_MLP_PARTITION_WARNING2"), VersionInfo.getAppVersionString());
                    NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mTrainingNumber);
                    return false;
                }
                try {
                    long l = Long.parseLong(string);
                    if (l < 1L || l > Integer.MAX_VALUE) {
                        return false;
                    }
                    l = Long.parseLong(string2);
                    if (l < 0L || l > Integer.MAX_VALUE) {
                        return false;
                    }
                    l = Long.parseLong(string3);
                    if (l < 0L || l > Integer.MAX_VALUE) {
                        return false;
                    }
                    break block13;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            if (this.mUsePartioningRadio.isEnabled() && this.mUsePartioningRadio.isSelected() && this.mPartitioningVariable.getModel().getSize() == 0) {
                SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_MLP_PARTITION_WARNING3"), VersionInfo.getAppVersionString());
                this.mSrcVarList.requestFocusInWindow();
                return false;
            }
        }
        return true;
    }

    private JPanel setupSourcePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_NNET_MLP_VARIABLES_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void setupPartitionDatasetPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, n2, n2, n2 * 2);
        DialogUtil.addUsingGBL(this.mPartitionDatasetPanel, this.mUseRandomlyRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_NNET_MLP_PARTITIONS_LABEL");
        JPanel jPanel = this.setupPartitionGrid();
        jLabel.setLabelFor(jPanel);
        insets.set(n2, n2 * 5, 0, n2 * 2);
        DialogUtil.addUsingGBL(this.mPartitionDatasetPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(0, n2 * 5, n2, n2 * 2);
        DialogUtil.addUsingGBL(this.mPartitionDatasetPanel, jPanel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        insets.set(n2, n2, n2, n2 * 2);
        DialogUtil.addUsingGBL(this.mPartitionDatasetPanel, this.mUsePartioningRadio, gridBagConstraints, 0, 3, 1, 1, n, insets);
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, TARGET_PARTIONING_VARIBLE_KEY);
        jLabel2.setLabelFor(this.mPartitioningVariable);
        JComponent[] jComponentArray = new JComponent[]{jLabel2, this.mPartitioningArrow, this.mPartitioningVariable};
        gridBagConstraints.weighty = 1.0;
        insets.set(0, n2 * 5, n2, n2 * 2);
        DialogUtil.addUsingGBL(this.mPartitionDatasetPanel, this.setUpListPanel(jComponentArray), gridBagConstraints, 0, 4, 1, 1, n, insets);
    }

    private JPanel setupPartitionGrid() {
        JPanel jPanel = PanelFactory.getEmptyPanel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        JTextField jTextField = new JTextField(this.getResString("IDS_NNET_MLP_PARTITION_COL"));
        jTextField.setEditable(false);
        JTextField jTextField2 = new JTextField(this.getResString("IDS_NNET_MLP_RELNUM_COL"));
        jTextField2.setEditable(false);
        jTextField2.setHorizontalAlignment(0);
        JTextField jTextField3 = new JTextField("%");
        jTextField3.setEditable(false);
        jTextField3.setHorizontalAlignment(4);
        gridBagConstraints.ipadx = 50;
        DialogUtil.addUsingGBL(jPanel, jTextField, gridBagConstraints, 0, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jTextField2, gridBagConstraints, 1, 0, 1, 1, n, null);
        gridBagConstraints.ipadx = 0;
        DialogUtil.addUsingGBL(jPanel, jTextField3, gridBagConstraints, 2, 0, 1, 1, n, null);
        JTextField jTextField4 = new JTextField(this.getResString("IDS_NNET_MLP_TRAINING_ROW"));
        jTextField4.setEditable(false);
        DialogUtil.addUsingGBL(jPanel, jTextField4, gridBagConstraints, 0, 1, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTrainingNumber, gridBagConstraints, 1, 1, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTrainingPercent, gridBagConstraints, 2, 1, 1, 1, n, null);
        JTextField jTextField5 = new JTextField(this.getResString("IDS_NNET_MLP_TEST_ROW"));
        jTextField5.setEditable(false);
        DialogUtil.addUsingGBL(jPanel, jTextField5, gridBagConstraints, 0, 2, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTestNumber, gridBagConstraints, 1, 2, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTestPercent, gridBagConstraints, 2, 2, 1, 1, n, null);
        JTextField jTextField6 = new JTextField(this.getResString("IDS_NNET_MLP_HOLDOUT_ROW"));
        jTextField6.setEditable(false);
        DialogUtil.addUsingGBL(jPanel, jTextField6, gridBagConstraints, 0, 3, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mHoldoutNumber, gridBagConstraints, 1, 3, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mHoldoutPercent, gridBagConstraints, 2, 3, 1, 1, n, null);
        JTextField jTextField7 = new JTextField(this.getResString("IDS_NNET_MLP_TOTAL_ROW"));
        jTextField7.setEditable(false);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jTextField7, gridBagConstraints, 0, 4, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTotalNumber, gridBagConstraints, 1, 4, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.mOneHundredField, gridBagConstraints, 2, 4, 1, 1, n, null);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mUseRandomlyRadio);
        vector.add(this.mTrainingNumber);
        vector.add(this.mTestNumber);
        vector.add(this.mHoldoutNumber);
        vector.add(this.mUsePartioningRadio);
        vector.add(this.mPartitioningArrow);
        vector.add(this.mPartitioningVariable);
        JPanel jPanel = ((BaseTabbedDialog)this.mParent).getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private void setDefaults() {
        if (this.mIsRBF) {
            this.mSrcVarList.setModel(((NeuralNetworksRBFModelDlg)this.mParent).getVariablesTab().getSrcListModel());
        } else {
            this.mSrcVarList.setModel(((NeuralNetworksMLPModelDlg)this.mParent).getVariablesTab().getSrcListModel());
        }
        if (this.mSrcVarList.getModel().getSize() > 0) {
            this.mSrcVarList.setSelectedIndex(0);
        }
        this.mUsePartioningRadio.setEnabled(true);
        this.mUseRandomlyRadio.setSelected(true);
        this.mPartitioningArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mPartitioningArrow.setEnabled(false);
        this.mPartitioningVariable.setEnabled(false);
        this.mTrainingNumber.setText("7");
        this.mTrainingPercent.setEditable(false);
        this.mTrainingPercent.setText("70");
        this.mTestNumber.setText("3");
        this.mTestPercent.setEditable(false);
        this.mTestPercent.setText("30");
        this.mHoldoutNumber.setText("0");
        this.mHoldoutPercent.setEditable(false);
        this.mHoldoutPercent.setText("0");
        this.mTotalNumber.setText("10");
        this.mTotalNumber.setEditable(false);
    }

    private void initVars() {
        this.mUseRandomlyRadio = DialogUtil.createRadioButton(this.mParent, RANDOMLY_ASSIGN_KEY, null);
        this.mUsePartioningRadio = DialogUtil.createRadioButton(this.mParent, USE_PARTITIONING_KEY, null);
        this.mPartitionDatasetGroup = new SpssButtonGroup();
        this.mPartitionDatasetGroup.add(this.mUseRandomlyRadio);
        this.mPartitionDatasetGroup.add(this.mUsePartioningRadio);
        this.mPartitionDatasetPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_NNET_MLP_PARTITION_DATASET_LABEL"));
        this.mPartitionDatasetPanel.setEnabled(true);
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        if (this.mIsRBF) {
            this.mSrcVarList.addVarFilter(((NeuralNetworksRBFModelDlg)this.mParent).getVariablesTab().getSplitVarFilter());
        } else {
            this.mSrcVarList.addVarFilter(((NeuralNetworksMLPModelDlg)this.mParent).getVariablesTab().getSplitVarFilter());
        }
        this.mSrcVarList.setIdentifier(SOURCE_LIST_KEY);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mSrcScrollPane.setHorizontalScrollBarPolicy(30);
        this.mSrcScrollPane.setVerticalScrollBarPolicy(20);
        this.mPartitioningVariable = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mPartitioningVariable.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mPartitioningVariable.addVarFilter(new SpssVarFilter(8, false));
        this.mPartitioningArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mPartitioningArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mPartitioningArrow.registerVariableList(this.mPartitioningVariable, SpssArrowButton.ButtonOrientation.left);
        this.mUsePartioningRadio.addItemListener(this);
        this.mUseRandomlyRadio.addItemListener(this);
        this.mPartitioningVariable.setIdentifier(TARGET_PARTIONING_VARIBLE_KEY);
        this.mTrainingNumber = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mTrainingNumber.setAction((Action)new TextFieldAction(this.mParent, TRAINING_NUMBER));
        this.mTrainingNumber.setColumns(9);
        this.mTrainingNumber.setHorizontalAlignment(4);
        this.mTrainingNumber.getDocument().addDocumentListener(this);
        this.mTrainingNumber.addCaretListener((CaretListener)this);
        this.mTrainingPercent = new FloatTextField(0.0, 100.0, 2, true, true);
        this.mTrainingPercent.setAction((Action)new TextFieldAction(this.mParent, TRAINING_PERCENT));
        this.mTrainingPercent.setColumns(6);
        this.mTrainingPercent.setHorizontalAlignment(4);
        this.mTestNumber = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mTestNumber.setAction((Action)new TextFieldAction(this.mParent, TESTING_NUMBER));
        this.mTestNumber.setColumns(9);
        this.mTestNumber.setHorizontalAlignment(4);
        this.mTestNumber.getDocument().addDocumentListener(this);
        this.mTestNumber.addCaretListener((CaretListener)this);
        this.mTestPercent = new FloatTextField(0.0, 100.0, 2, true, true);
        this.mTestPercent.setAction((Action)new TextFieldAction(this.mParent, TESTING_PERCENT));
        this.mTestPercent.setHorizontalAlignment(4);
        this.mTestPercent.setColumns(6);
        this.mHoldoutNumber = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mHoldoutNumber.setAction((Action)new TextFieldAction(this.mParent, HOLDOUT_NUMBER));
        this.mHoldoutNumber.setColumns(9);
        this.mHoldoutNumber.setHorizontalAlignment(4);
        this.mHoldoutNumber.getDocument().addDocumentListener(this);
        this.mHoldoutNumber.addCaretListener((CaretListener)this);
        this.mHoldoutPercent = new FloatTextField(0.0, 100.0, 2, true, true);
        this.mHoldoutPercent.setAction((Action)new TextFieldAction(this.mParent, HOLDOUT_PERCENT));
        this.mHoldoutPercent.setHorizontalAlignment(4);
        this.mHoldoutPercent.setColumns(6);
        this.mTotalNumber = new IntTextField(true);
        this.mTotalNumber.setHorizontalAlignment(4);
        this.mTotalNumber.getDocument().addDocumentListener(this);
        this.mOneHundredField = new JTextField("100");
        this.mOneHundredField.setEditable(false);
        this.mOneHundredField.setHorizontalAlignment(4);
        this.mComponent = new Vector();
        this.mSyntax = new StringBuffer();
    }
}

