/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.neural_networks;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.dialogs.adv_stats.neural_networks.NeuralNetworksMLPModelDlg;
import com.spss.java_client.ui.dialogs.adv_stats.neural_networks.NeuralNetworksRBFModelDlg;
import com.spss.java_client.ui.dialogs.adv_stats.neural_networks.VariablesTab;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class OutputTab
extends BaseProcedureTab {
    private static int WIDTH = 310;
    private JPanel mSummaryPanel;
    private JCheckBox mDescriptionCheck;
    private JCheckBox mCaseProcessingSummaryCheck;
    private JCheckBox mDiagramCheck;
    private JCheckBox mSynapticWeightCheck;
    private JPanel mModelPanel;
    private JCheckBox mModelSummaryCheck;
    private JCheckBox mClassificationResultsCheck;
    private JCheckBox mROCCurveCheck;
    private JCheckBox mCumulateGainsChartCheck;
    private JCheckBox mLiftChartCheck;
    private JCheckBox mPredictorVarAnalysisCheck;
    private JCheckBox mPredictedCheck;
    private JCheckBox mResidualCheck;
    private JLabel mImageLabel;
    private JTextArea mMessageArea;
    private boolean mIsRBF;

    public OutputTab(BaseTabbedDialog baseTabbedDialog, boolean bl) {
        super(baseTabbedDialog, true);
        this.mIsRBF = bl;
        this.initialize();
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        this.mResidualCheck.setEnabled(true);
        VariablesTab.DepVarMeasurment depVarMeasurment = this.mIsRBF ? ((NeuralNetworksRBFModelDlg)this.mParent).getVariablesTab().checkDepentVarMeasurement() : ((NeuralNetworksMLPModelDlg)this.mParent).getVariablesTab().checkDepentVarMeasurement();
        if (depVarMeasurment == VariablesTab.DepVarMeasurment.ALL_SCALE) {
            this.mClassificationResultsCheck.setEnabled(false);
            this.mROCCurveCheck.setEnabled(false);
            this.mCumulateGainsChartCheck.setEnabled(false);
            this.mLiftChartCheck.setEnabled(false);
        } else {
            this.mClassificationResultsCheck.setEnabled(true);
            this.mROCCurveCheck.setEnabled(true);
            this.mCumulateGainsChartCheck.setEnabled(true);
            this.mLiftChartCheck.setEnabled(true);
            if (depVarMeasurment == VariablesTab.DepVarMeasurment.ALL_CATEGORICAL) {
                this.mResidualCheck.setEnabled(false);
            }
        }
        this.setFocusTraversalPolicy();
    }

    @Override
    public String getDialogHelpID() {
        if (this.mIsRBF) {
            return "idh_idd_rbf_output";
        }
        return "idh_idd_mlp_output";
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    public String getOutputTabSyntax() {
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer("\n  /PRINT ");
        if (this.mCaseProcessingSummaryCheck.isSelected()) {
            stringBuffer.append("CPS ");
            bl = true;
        }
        if (this.mDescriptionCheck.isSelected()) {
            stringBuffer.append("NETWORKINFO ");
            bl = true;
        }
        if (this.mModelSummaryCheck.isSelected()) {
            stringBuffer.append("SUMMARY ");
            bl = true;
        }
        if (this.mClassificationResultsCheck.isEnabled() && this.mClassificationResultsCheck.isSelected()) {
            stringBuffer.append("CLASSIFICATION ");
            bl = true;
        }
        if (this.mSynapticWeightCheck.isSelected()) {
            stringBuffer.append("SOLUTION ");
            bl = true;
        }
        if (this.mPredictorVarAnalysisCheck.isSelected()) {
            stringBuffer.append("IMPORTANCE ");
            bl = true;
        }
        if (!bl) {
            stringBuffer.append("NONE ");
        }
        stringBuffer.append("\n  /PLOT ");
        if (this.mDiagramCheck.isSelected()) {
            stringBuffer.append("NETWORK ");
            bl2 = true;
        }
        if (this.mROCCurveCheck.isEnabled() && this.mROCCurveCheck.isSelected()) {
            stringBuffer.append("ROC ");
            bl2 = true;
        }
        if (this.mCumulateGainsChartCheck.isEnabled() && this.mCumulateGainsChartCheck.isSelected()) {
            stringBuffer.append("GAIN ");
            bl2 = true;
        }
        if (this.mLiftChartCheck.isEnabled() && this.mLiftChartCheck.isSelected()) {
            stringBuffer.append("LIFT ");
            bl2 = true;
        }
        if (this.mPredictedCheck.isSelected()) {
            stringBuffer.append("PREDICTED ");
            bl2 = true;
        }
        if (this.mResidualCheck.isEnabled() && this.mResidualCheck.isSelected()) {
            stringBuffer.append("RESIDUAL ");
            bl2 = true;
        }
        if (!bl2) {
            stringBuffer.append("NONE ");
        }
        return stringBuffer.toString();
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mCaseProcessingSummaryCheck;
    }

    private void initialize() {
        super.initPanel();
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = UIToolDialogUtil.getStandardDialogInsets();
        Insets insets2 = new Insets(n2 * 2, n2, n2, n2);
        this.setupSummaryPanel();
        this.setupModelPanel();
        Dimension dimension = this.mSummaryPanel.getPreferredSize();
        dimension.width = WIDTH;
        this.mSummaryPanel.setPreferredSize(dimension);
        dimension = this.mModelPanel.getPreferredSize();
        dimension.width = WIDTH;
        this.mModelPanel.setPreferredSize(dimension);
        DialogUtil.addUsingGBL(this, this.mSummaryPanel, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        DialogUtil.createButtonGroup(this.mSummaryPanel);
        insets2.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(this, this.mModelPanel, gridBagConstraints, 0, 1, 2, 1, n, insets2);
        DialogUtil.createButtonGroup(this.mModelPanel);
        insets2.set(n2, n2 * 5, n2, n2);
        DialogUtil.addUsingGBL(this, this.mCaseProcessingSummaryCheck, gridBagConstraints, 0, 2, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(this, this.mPredictorVarAnalysisCheck, gridBagConstraints, 0, 3, 2, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        insets2.set(n2, n2 * 5, n2, 0);
        DialogUtil.addUsingGBL(this, this.mImageLabel, gridBagConstraints, 0, 5, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.set(n2, 0, n2, n2);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, this.mMessageArea, gridBagConstraints, 1, 5, 1, 1, n, insets2);
        this.setFocusTraversalPolicy();
    }

    private void setupSummaryPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = UIToolDialogUtil.getStandardDialogInsets();
        Insets insets2 = new Insets(n2, insets.left, n2, insets.right);
        DialogUtil.addUsingGBL(this.mSummaryPanel, this.mDescriptionCheck, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(this.mSummaryPanel, this.mDiagramCheck, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(this.mSummaryPanel, this.mSynapticWeightCheck, gridBagConstraints, 0, 2, 1, 1, n, insets2);
    }

    private void setupModelPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(this.mModelPanel, this.mModelSummaryCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mModelPanel, this.mClassificationResultsCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mModelPanel, this.mROCCurveCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mModelPanel, this.mCumulateGainsChartCheck, gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mModelPanel, this.mLiftChartCheck, gridBagConstraints, 0, 4, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mModelPanel, this.mPredictedCheck, gridBagConstraints, 0, 5, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mModelPanel, this.mResidualCheck, gridBagConstraints, 0, 6, 1, 1, n, insets);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mDescriptionCheck);
        vector.add(this.mDiagramCheck);
        vector.add(this.mSynapticWeightCheck);
        vector.add(this.mModelSummaryCheck);
        vector.add(this.mClassificationResultsCheck);
        vector.add(this.mROCCurveCheck);
        vector.add(this.mCumulateGainsChartCheck);
        vector.add(this.mLiftChartCheck);
        vector.add(this.mPredictedCheck);
        vector.add(this.mResidualCheck);
        vector.add(this.mCaseProcessingSummaryCheck);
        vector.add(this.mPredictorVarAnalysisCheck);
        JPanel jPanel = ((BaseTabbedDialog)this.mParent).getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private void setDefaults() {
        this.mCaseProcessingSummaryCheck.setSelected(true);
        this.mDescriptionCheck.setSelected(true);
        this.mDiagramCheck.setSelected(true);
        this.mSynapticWeightCheck.setSelected(false);
        this.mModelSummaryCheck.setSelected(true);
        this.mResidualCheck.setEnabled(true);
        this.mResidualCheck.setSelected(false);
        VariablesTab.DepVarMeasurment depVarMeasurment = this.mIsRBF ? ((NeuralNetworksRBFModelDlg)this.mParent).getVariablesTab().checkDepentVarMeasurement() : ((NeuralNetworksMLPModelDlg)this.mParent).getVariablesTab().checkDepentVarMeasurement();
        if (depVarMeasurment == VariablesTab.DepVarMeasurment.ALL_SCALE) {
            this.mClassificationResultsCheck.setEnabled(false);
            this.mClassificationResultsCheck.setSelected(true);
            this.mROCCurveCheck.setEnabled(false);
            this.mROCCurveCheck.setSelected(false);
            this.mCumulateGainsChartCheck.setEnabled(false);
            this.mCumulateGainsChartCheck.setSelected(false);
            this.mLiftChartCheck.setEnabled(false);
            this.mLiftChartCheck.setSelected(false);
        } else {
            this.mClassificationResultsCheck.setEnabled(true);
            this.mClassificationResultsCheck.setSelected(true);
            this.mROCCurveCheck.setEnabled(true);
            this.mROCCurveCheck.setSelected(false);
            this.mCumulateGainsChartCheck.setEnabled(true);
            this.mCumulateGainsChartCheck.setSelected(false);
            this.mLiftChartCheck.setEnabled(true);
            this.mLiftChartCheck.setSelected(false);
            if (depVarMeasurment == VariablesTab.DepVarMeasurment.ALL_CATEGORICAL) {
                this.mResidualCheck.setEnabled(false);
            }
        }
        this.mPredictorVarAnalysisCheck.setEnabled(true);
        this.mPredictorVarAnalysisCheck.setSelected(false);
        this.mPredictedCheck.setEnabled(true);
        this.mPredictedCheck.setSelected(false);
    }

    private void initVars() {
        this.mSummaryPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_NNET_MLP_OUTPUT_SUMMARY"));
        this.mCaseProcessingSummaryCheck = DialogUtil.createCheckBox(this.mParent, "IDS_NNET_MLP_OUTPUT_CASE_SUMMARY", null);
        this.mDescriptionCheck = DialogUtil.createCheckBox(this.mParent, "IDS_NNET_MLP_OUTPUT_DESCRIPTION", null);
        this.mDiagramCheck = DialogUtil.createCheckBox(this.mParent, "IDS_NNET_MLP_OUTPUT_NETWORK_INFORMATION", null);
        this.mSynapticWeightCheck = DialogUtil.createCheckBox(this.mParent, "IDS_NNET_MLP_OUTPUT_NETWORK_DIAGRAM", null);
        this.mModelPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_NNET_MLP_OUTPUT_MODEL"));
        this.mModelSummaryCheck = DialogUtil.createCheckBox(this.mParent, "IDS_NNET_MLP_OUTPUT_MODEL_SUMMARY", null);
        this.mClassificationResultsCheck = DialogUtil.createCheckBox(this.mParent, "IDS_NNET_MLP_OUTPUT_MODEL_CLS_RESULT", null);
        this.mROCCurveCheck = DialogUtil.createCheckBox(this.mParent, "IDS_NNET_MLP_OUTPUT_MODEL_ROC_CURVE", null);
        this.mCumulateGainsChartCheck = DialogUtil.createCheckBox(this.mParent, "IDS_NNET_MLP_OUTPUT_MODEL_CUMULATE_GAIN_CHART", null);
        this.mLiftChartCheck = DialogUtil.createCheckBox(this.mParent, "IDS_NNET_MLP_OUTPUT_MODEL_LIFT_CHART", null);
        this.mPredictorVarAnalysisCheck = DialogUtil.createCheckBox(this.mParent, "IDS_NNET_MLP_OUTPUT_PARAMETERS_PREDICTOR_ANALYSIS", null);
        this.mPredictedCheck = DialogUtil.createCheckBox(this.mParent, "IDS_NNET_MLP_OUTPUT_DIAGNOSIS_PREDICATED", null);
        this.mResidualCheck = DialogUtil.createCheckBox(this.mParent, "IDS_NNET_MLP_OUTPUT_DIAGNOSIS_RESIDUAL", null);
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        this.mImageLabel = new JLabel();
        this.mImageLabel.setIcon(new ImageIcon(uRL));
        this.mMessageArea = new JTextArea();
        this.mMessageArea.setRows(3);
        this.mMessageArea.setOpaque(false);
        this.mMessageArea.setFont(this.mResidualCheck.getFont());
        this.mMessageArea.setLineWrap(true);
        this.mMessageArea.setWrapStyleWord(true);
        this.mMessageArea.setText(this.getResString("IDS_NNET_MLP_OUTPUT_MESA"));
        this.mMessageArea.setFocusable(false);
    }
}

