/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.neural_networks;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.adv_stats.neural_networks.NeuralNetworksMLPModelDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class OptionsTab
extends BaseProcedureTab
implements DocumentListener,
ItemListener,
FocusListener {
    private static String TRAINING_TIME = "IDS_MLP_TRAINING_TIME";
    private static String TRAINING_ERROR = "IDS_MLP_TRAINING_ERROR";
    private static String MAX_EPOCHS = "IDS_MLP_MAX_EPOCHS";
    private static String TRAINING_ERROR_RATIO = "IDS_MLP_TRAINING_ERROR_RATIO";
    private static String MAX_CASES_IN_STORE = "IDS_MLP_MAX_CASES_IN_STORE";
    private static String MAX_STEPS = "IDS_MLP_MAX_STEPS";
    private JRadioButton mExcludeRadio;
    private JRadioButton mIncludeRadio;
    private SpssButtonGroup mUserMissingRadioGrp;
    private JLabel mMaxStepsLabel;
    private IntTextField mMaxStepsEdit;
    private SpssButtonGroup mUseDataRadioGrp;
    private JRadioButton mAutoRadio;
    private JRadioButton mBothRadio;
    private JCheckBox mMaxTrainTimeCheck;
    private JLabel mInMinutesLabel;
    private IntTextField mInMinutesEdit;
    private SpssButtonGroup mEpochGrp;
    private JRadioButton mAutoEpochRadio;
    private JRadioButton mSpecifyEpochRadio;
    private JLabel mMaxEpochLabel;
    private IntTextField mMaxEpochEdit;
    private JLabel mMinTrainErrorLabel;
    private FloatTextField mMinTrainErrorEdit;
    private JLabel mMinTrainErrorRatioLabel;
    private FloatTextField mMinTrainErrorRatioEdit;
    private JLabel mMaxCasesInStoreLabel;
    private IntTextField mMaxCasesInStoreEdit;
    private JSeparator mSeparator;
    private boolean mIsRBF;

    public OptionsTab(BaseTabbedDialog baseTabbedDialog, boolean bl) {
        super(baseTabbedDialog, true);
        this.mIsRBF = bl;
        this.initialize();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mMaxStepsEdit) {
            NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mMaxStepsEdit);
        }
        if (focusEvent.getSource() == this.mInMinutesEdit) {
            NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mInMinutesEdit);
        }
        if (focusEvent.getSource() == this.mMaxEpochEdit) {
            NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mMaxEpochEdit);
        }
        if (focusEvent.getSource() == this.mMinTrainErrorEdit) {
            NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mMinTrainErrorEdit);
        }
        if (focusEvent.getSource() == this.mMinTrainErrorRatioEdit) {
            NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mMinTrainErrorRatioEdit);
        }
        if (focusEvent.getSource() == this.mMaxCasesInStoreEdit) {
            NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mMaxCasesInStoreEdit);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        int n = itemEvent.getStateChange();
        if (object == this.mMaxTrainTimeCheck) {
            if (n == 1) {
                this.mInMinutesEdit.setEnabled(true);
                this.mInMinutesLabel.setEnabled(true);
            } else {
                this.mInMinutesEdit.setEnabled(false);
                this.mInMinutesLabel.setEnabled(false);
            }
        }
        if (object == this.mAutoEpochRadio) {
            this.mMaxEpochEdit.setEnabled(false);
            this.mMaxEpochLabel.setEnabled(false);
        }
        if (object == this.mSpecifyEpochRadio) {
            this.mMaxEpochEdit.setEnabled(true);
            this.mMaxEpochLabel.setEnabled(true);
        }
    }

    public String getOptionTabSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.mIsRBF) {
            stringBuffer.append(SyntaxUtil.getSubCommand("\n  /STOPPINGRULES "));
            stringBuffer.append("ERRORSTEPS= ");
            stringBuffer.append(Integer.parseInt(this.mMaxStepsEdit.getText()));
            stringBuffer.append(" (DATA=");
            if (this.mAutoRadio.isSelected()) {
                stringBuffer.append("AUTO) ");
            } else if (this.mBothRadio.isEnabled() && this.mBothRadio.isSelected()) {
                stringBuffer.append("BOTH) ");
            }
            if (this.mMaxTrainTimeCheck.isSelected()) {
                stringBuffer.append("TRAININGTIMER=ON ");
                stringBuffer.append("(MAXTIME=");
                stringBuffer.append(Integer.parseInt(this.mInMinutesEdit.getText()) + ") ");
            } else {
                stringBuffer.append("TRAININGTIMER=OFF ");
            }
            stringBuffer.append("MAXEPOCHS=");
            if (this.mSpecifyEpochRadio.isSelected()) {
                stringBuffer.append(Integer.parseInt(this.mMaxEpochEdit.getText()) + " ");
            } else {
                stringBuffer.append("AUTO ");
            }
            if (this.mMinTrainErrorEdit.isEnabled()) {
                stringBuffer.append("ERRORCHANGE=");
                stringBuffer.append(Double.parseDouble(this.mMinTrainErrorEdit.getText()) + " ");
            }
            if (this.mMinTrainErrorRatioEdit.isEnabled()) {
                stringBuffer.append("ERRORRATIO=");
                stringBuffer.append(Double.parseDouble(this.mMinTrainErrorRatioEdit.getText()) + " ");
            }
        }
        stringBuffer.append("\n /MISSING ");
        if (this.mExcludeRadio.isSelected()) {
            stringBuffer.append("USERMISSING=EXCLUDE ");
        }
        if (this.mIncludeRadio.isSelected()) {
            stringBuffer.append("USERMISSING=INCLUDE ");
        }
        return stringBuffer.toString();
    }

    @Override
    public String getDialogHelpID() {
        if (this.mIsRBF) {
            return "idh_idd_rbf_options";
        }
        return "idh_idd_mlp_options";
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    protected boolean validateTab() {
        return this.doValidation();
    }

    public boolean isMaxCaseInStoreEnabled() {
        return this.mMaxCasesInStoreEdit != null && this.mMaxCasesInStoreEdit.isEnabled();
    }

    public int getMaxCasesInStore() {
        int n = 0;
        if (this.mIsRBF) {
            return n;
        }
        if (this.mMaxCasesInStoreEdit.getText().length() > 0) {
            n = Integer.parseInt(this.mMaxCasesInStoreEdit.getText());
        }
        return n;
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        if (!this.mIsRBF) {
            if (!((NeuralNetworksMLPModelDlg)this.mParent).getPartitionsTab().usePartitioningVariable() && ((NeuralNetworksMLPModelDlg)this.mParent).getPartitionsTab().getTestRecords() == 0 || ((NeuralNetworksMLPModelDlg)this.mParent).getTrainingTab().isBatch()) {
                this.mBothRadio.setEnabled(false);
            } else {
                this.mBothRadio.setEnabled(true);
            }
        }
        this.setFocusTraversalPolicy();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mExcludeRadio);
        vector.add(this.mIncludeRadio);
        if (!this.mIsRBF) {
            vector.add(this.mMaxStepsEdit);
            vector.add(this.mAutoRadio);
            vector.add(this.mBothRadio);
            vector.add(this.mMaxTrainTimeCheck);
            vector.add(this.mInMinutesEdit);
            vector.add(this.mEpochGrp);
            vector.add(this.mMaxEpochEdit);
            vector.add(this.mMinTrainErrorEdit);
            vector.add(this.mMinTrainErrorRatioEdit);
            vector.add(this.mMaxCasesInStoreEdit);
        }
        JPanel jPanel = ((BaseTabbedDialog)this.mParent).getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private boolean doValidation() {
        if (this.mIsRBF) {
            return true;
        }
        try {
            long l = -1L;
            if (this.mMaxStepsEdit.getText().equals("")) {
                SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_MLP_OPTION_WARNING_MESG1"), VersionInfo.getAppVersionString());
                NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mMaxStepsEdit);
                return false;
            }
            l = Long.parseLong(this.mMaxStepsEdit.getText());
            if (l == 0L) {
                SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_MLP_OPTION_WARNING_MESG1"), VersionInfo.getAppVersionString());
                NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mMaxStepsEdit);
                return false;
            }
            if (l > Integer.MAX_VALUE) {
                return false;
            }
            if (this.mMaxTrainTimeCheck.isSelected()) {
                if (this.mInMinutesEdit.getText().equals("")) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_MLP_OPTION_WARNING_MESG2"), VersionInfo.getAppVersionString());
                    NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mInMinutesEdit);
                    return false;
                }
                l = Long.parseLong(this.mInMinutesEdit.getText());
                if (l == 0L) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_MLP_OPTION_WARNING_MESG2"), VersionInfo.getAppVersionString());
                    NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mInMinutesEdit);
                    return false;
                }
                if (l > Integer.MAX_VALUE) {
                    return false;
                }
            }
            if (this.mSpecifyEpochRadio.isSelected()) {
                if (this.mMaxEpochEdit.getText().equals("")) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_MLP_OPTION_WARNING_MESG3"), VersionInfo.getAppVersionString());
                    NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mMaxEpochEdit);
                    return false;
                }
                l = Long.parseLong(this.mMaxEpochEdit.getText());
                if (l == 0L) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_MLP_OPTION_WARNING_MESG3"), VersionInfo.getAppVersionString());
                    NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mMaxEpochEdit);
                    return false;
                }
                if (l > Integer.MAX_VALUE) {
                    return false;
                }
            }
            if (this.mMinTrainErrorEdit.getText().equals("") || !this.mMinTrainErrorEdit.getText().equals("") && Double.parseDouble(this.mMinTrainErrorEdit.getText()) == 0.0) {
                SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_MLP_OPTION_WARNING_MESG4"), VersionInfo.getAppVersionString());
                NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mMinTrainErrorEdit);
                return false;
            }
            if (this.mMinTrainErrorRatioEdit.getText().equals("") || !this.mMinTrainErrorRatioEdit.getText().equals("") && Double.parseDouble(this.mMinTrainErrorRatioEdit.getText()) == 0.0) {
                SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_MLP_OPTION_WARNING_MESG5"), VersionInfo.getAppVersionString());
                NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mMinTrainErrorRatioEdit);
                return false;
            }
            if (this.mMaxCasesInStoreEdit.isEnabled()) {
                if (this.mMaxCasesInStoreEdit.getText().equals("")) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_MLP_OPTION_WARNING_MESG6"), VersionInfo.getAppVersionString());
                    NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mMaxCasesInStoreEdit);
                    return false;
                }
                l = Long.parseLong(this.mMaxCasesInStoreEdit.getText());
                if (l < 2L) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_MLP_OPTION_WARNING_MESG7"), VersionInfo.getAppVersionString());
                    NeuralNetworksMLPModelDlg.setSelectionText((JComponent)this.mMaxCasesInStoreEdit);
                    return false;
                }
                if (l > Integer.MAX_VALUE) {
                    return false;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void initialize() {
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = UIToolDialogUtil.getStandardDialogInsets();
        Insets insets2 = new Insets(n2, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(this, this.setupPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets2);
        this.setDefaults();
        this.setFocusTraversalPolicy();
    }

    private JPanel setupPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = UIToolDialogUtil.getStandardDialogInsets();
        Insets insets2 = new Insets(0, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.setupUserMissingValuePanel(), gridBagConstraints, 0, 0, 1, 1, n, insets2);
        if (!this.mIsRBF) {
            insets2.set(n2, insets.left, 0, insets.right);
            DialogUtil.addUsingGBL(jPanel, this.setupStoppingRulePanel(), gridBagConstraints, 0, 1, 1, 1, n, insets2);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            insets2.set(n2, insets.left * 2, insets.bottom, DialogUtil.getGroupBoxInnerMargin());
            DialogUtil.addUsingGBL(jPanel, this.setupMaxCasesInStorePanel(), gridBagConstraints, 0, 2, 1, 1, n, insets2);
        }
        return jPanel;
    }

    private void setDefaults() {
        this.mExcludeRadio.setEnabled(true);
        this.mExcludeRadio.setSelected(true);
        this.mIncludeRadio.setEnabled(true);
        if (!this.mIsRBF) {
            this.mMaxStepsEdit.setText("1");
            this.mAutoRadio.setEnabled(true);
            this.mAutoRadio.setSelected(true);
            this.mBothRadio.setEnabled(false);
            this.mMaxTrainTimeCheck.setEnabled(true);
            this.mMaxTrainTimeCheck.setSelected(true);
            this.mInMinutesEdit.setEnabled(true);
            this.mInMinutesEdit.setText("15");
            this.mAutoEpochRadio.setSelected(true);
            if (this.mSpecifyEpochRadio.isSelected()) {
                this.mMaxEpochEdit.setEnabled(true);
                this.mMaxEpochEdit.setText("");
            } else {
                this.mMaxEpochEdit.setEnabled(false);
                this.mMaxEpochEdit.setText("");
            }
            this.mMinTrainErrorEdit.setText("0.0001");
            this.mMinTrainErrorRatioEdit.setText("0.001");
            this.mMaxCasesInStoreLabel.setEnabled(true);
            this.mMaxCasesInStoreEdit.setEnabled(true);
            this.mMaxCasesInStoreEdit.setText("1000");
        }
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NNET_MLP_USESR_MIISING_VALUES_EXCLUDE");
        this.mExcludeRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NNET_MLP_USESR_MIISING_VALUES_INCLUDE");
        this.mIncludeRadio = new JRadioButton(toggleButtonAction);
        this.mUserMissingRadioGrp = new SpssButtonGroup();
        this.mUserMissingRadioGrp.add(this.mExcludeRadio);
        this.mUserMissingRadioGrp.add(this.mIncludeRadio);
        if (!this.mIsRBF) {
            this.mMaxStepsLabel = DialogUtil.createLabel(this.mParent, "IDS_NNET_MLP_STOPPING_RULE_MAX_STEPS");
            this.mInMinutesLabel = DialogUtil.createLabel(this.mParent, "IDS_NNET_MLP_STOPPING_RULE_MAX_TRAIN_TIME_MINUTES");
            this.mMaxEpochLabel = DialogUtil.createLabel(this.mParent, "IDS_NNET_MLP_STOPPING_RULE_MAX_EPHOCHS");
            this.mMinTrainErrorLabel = DialogUtil.createLabel(this.mParent, "IDS_NNET_MLP_STOPPING_RULE_MIN_TRAIN_ERROR");
            this.mMinTrainErrorRatioLabel = DialogUtil.createLabel(this.mParent, "IDS_NNET_MLP_STOPPING_RULE_MIN_TRAIN_ERROR_RATIO");
            this.mMaxCasesInStoreLabel = DialogUtil.createLabel(this.mParent, "IDS_NNET_MLP_MAX_CASES_STORED");
            toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NNET_MLP_STOPPING_RULE_USE_DATA_AUTO");
            this.mAutoRadio = new JRadioButton(toggleButtonAction);
            toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NNET_MLP_STOPPING_RULE_USE_DATA_BOTH");
            this.mBothRadio = new JRadioButton(toggleButtonAction);
            this.mUseDataRadioGrp = new SpssButtonGroup();
            this.mUseDataRadioGrp.add(this.mAutoRadio);
            this.mUseDataRadioGrp.add(this.mBothRadio);
            toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NNET_MLP_STOPPING_RULE_MAX_EPHOCHS_AUTO");
            this.mAutoEpochRadio = new JRadioButton(toggleButtonAction);
            this.mAutoEpochRadio.addItemListener(this);
            toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NNET_MLP_STOPPING_RULE_MAX_EPHOCHS_SPECIFY");
            this.mSpecifyEpochRadio = new JRadioButton(toggleButtonAction);
            this.mSpecifyEpochRadio.addItemListener(this);
            this.mEpochGrp = new SpssButtonGroup();
            this.mEpochGrp.add(this.mAutoEpochRadio);
            this.mEpochGrp.add(this.mSpecifyEpochRadio);
            this.mMaxEpochEdit = new IntTextField(0, Integer.MAX_VALUE, true);
            this.mMaxEpochEdit.setAction((Action)new TextFieldAction(this.mParent, MAX_EPOCHS));
            this.mMaxEpochEdit.setColumns(5);
            this.mMaxEpochEdit.addFocusListener((FocusListener)this);
            this.mMaxEpochEdit.getDocument().addDocumentListener(this);
            this.mMaxEpochLabel.setLabelFor((Component)this.mMaxEpochEdit);
            toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NNET_MLP_STOPPING_RULE_MAX_TRAIN_TIME");
            this.mMaxTrainTimeCheck = new JCheckBox(toggleButtonAction);
            this.mMaxTrainTimeCheck.addItemListener(this);
            this.mMaxStepsEdit = new IntTextField(0, Integer.MAX_VALUE, true);
            this.mMaxStepsEdit.setAction((Action)new TextFieldAction(this.mParent, MAX_STEPS));
            this.mMaxStepsEdit.setColumns(5);
            this.mMaxStepsEdit.addFocusListener((FocusListener)this);
            this.mMaxStepsEdit.getDocument().addDocumentListener(this);
            this.mMaxStepsLabel.setLabelFor((Component)this.mMaxStepsEdit);
            this.mInMinutesEdit = new IntTextField(0, Integer.MAX_VALUE, true);
            this.mInMinutesEdit.setAction((Action)new TextFieldAction(this.mParent, TRAINING_TIME));
            this.mInMinutesEdit.setColumns(5);
            this.mInMinutesEdit.addFocusListener((FocusListener)this);
            this.mInMinutesEdit.getDocument().addDocumentListener(this);
            this.mInMinutesLabel.setLabelFor((Component)this.mInMinutesEdit);
            this.mMinTrainErrorEdit = new FloatTextField(true);
            this.mMinTrainErrorEdit.setAction((Action)new TextFieldAction(this.mParent, TRAINING_ERROR));
            this.mMinTrainErrorEdit.setColumns(5);
            this.mMinTrainErrorEdit.addFocusListener((FocusListener)this);
            this.mMinTrainErrorEdit.getDocument().addDocumentListener(this);
            this.mMinTrainErrorLabel.setLabelFor((Component)this.mMinTrainErrorEdit);
            this.mMinTrainErrorRatioEdit = new FloatTextField(true);
            this.mMinTrainErrorRatioEdit.setAction((Action)new TextFieldAction(this.mParent, TRAINING_ERROR_RATIO));
            this.mMinTrainErrorRatioEdit.setColumns(5);
            this.mMinTrainErrorRatioEdit.addFocusListener((FocusListener)this);
            this.mMinTrainErrorRatioEdit.getDocument().addDocumentListener(this);
            this.mMinTrainErrorRatioLabel.setLabelFor((Component)this.mMinTrainErrorRatioEdit);
            this.mMaxCasesInStoreEdit = new IntTextField(0, Integer.MAX_VALUE, true);
            this.mMaxCasesInStoreEdit.setAction((Action)new TextFieldAction(this.mParent, MAX_CASES_IN_STORE));
            this.mMaxCasesInStoreEdit.setColumns(5);
            this.mMaxCasesInStoreEdit.addFocusListener((FocusListener)this);
            this.mMaxCasesInStoreEdit.getDocument().addDocumentListener(this);
            this.mMaxCasesInStoreLabel.setLabelFor((Component)this.mMaxCasesInStoreEdit);
            this.mSeparator = new JSeparator();
        }
    }

    private JPanel setupStoppingRulePanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_NNET_MLP_STOPPING_RULE_LABEL"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = 23;
        Insets insets = new Insets(n, n, n, n);
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_NNET_MLP_STOPPING_RULE_MESG");
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mSeparator, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        insets.set(n, n, n, n);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.setupMaxStepsPanel(), gridBagConstraints, 0, 2, 1, 1, n2, insets);
        insets.set(n, n, n, n);
        DialogUtil.addUsingGBL(jPanel, this.setupUseDataPanel(), gridBagConstraints, 0, 3, 1, 1, n2, insets);
        insets.set(n, n, n, n);
        DialogUtil.addUsingGBL(jPanel, this.setupMaxTrainingTimePanel(), gridBagConstraints, 0, 4, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.setupMaxDataPassPanel(), gridBagConstraints, 0, 5, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.setupMinTrainingErrorPanel(), gridBagConstraints, 0, 6, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.setupMinTrainingErrorRatioPanel(), gridBagConstraints, 0, 7, 1, 1, n2, insets);
        return jPanel;
    }

    private JPanel setupUserMissingValuePanel() {
        int n;
        int n2;
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_NNET_MLP_USESR_MIISING_VALUES"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n3 = 23;
        gridBagConstraints.fill = 2;
        int n4 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n4, n4 - 4, n4);
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_NNET_MLP_USESR_MIISING_VALUES_SPECIFICATION");
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 2, 1, n3, insets);
        insets.set(n4 - 4, n4, n4 - 4, n4 * 2);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mExcludeRadio, gridBagConstraints, 0, 1, 1, 1, n3, insets);
        int n5 = n4;
        if (this.mIsRBF) {
            n2 = 0;
            n = 2;
        } else {
            n2 = 1;
            n = 1;
            n5 = n4 * 2;
        }
        gridBagConstraints.weightx = 1.0;
        insets.set(n4 - 4, n5, n4 - 4, n4);
        DialogUtil.addUsingGBL(jPanel, this.mIncludeRadio, gridBagConstraints, n2, n++, 1, 1, n3, insets);
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, "IDS_NNET_MLP_USESR_MIISING_VALUES_MESG");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n4 - 4, n4, n4, n4);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, n, 2, 1, n3, insets);
        return jPanel;
    }

    private JPanel setupMaxStepsPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mMaxStepsLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        insets.set(0, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxStepsEdit, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupMaxTrainingTimePanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, 0, 0, n * 4);
        int n2 = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mMaxTrainTimeCheck, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(3, n * 4, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mInMinutesLabel, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        insets.set(3, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mInMinutesEdit, gridBagConstraints, 2, 0, 1, 1, n2, insets);
        return jPanel;
    }

    private JPanel setupTrainingTimePanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(0, 0, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mInMinutesLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        insets.set(0, n2, n2, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mInMinutesEdit, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupUseDataPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_NNET_MLP_STOPPING_RULE_USE_DATA"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mAutoRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        insets.set(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mBothRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupMaxDataPassPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_NNET_MLP_STOPPING_RULE_MAX_EPHOCHS_TITLE"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mAutoEpochRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        insets.set(0, n2, 0, n2 * 4);
        DialogUtil.addUsingGBL(jPanel, this.mSpecifyEpochRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(3, n2 * 4, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mMaxEpochLabel, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        insets.set(3, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxEpochEdit, gridBagConstraints, 2, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupMinTrainingErrorPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(0, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mMinTrainErrorLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        insets.set(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMinTrainErrorEdit, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupMinTrainingErrorRatioPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(0, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mMinTrainErrorRatioLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        insets.set(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMinTrainErrorRatioEdit, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupMaxCasesInStorePanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(0, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mMaxCasesInStoreLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxCasesInStoreEdit, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }
}

