/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.neural_networks;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.dialogs.adv_stats.neural_networks.ExportTab;
import com.spss.java_client.ui.dialogs.adv_stats.neural_networks.OptionsTab;
import com.spss.java_client.ui.dialogs.adv_stats.neural_networks.OutputTab;
import com.spss.java_client.ui.dialogs.adv_stats.neural_networks.PartitionsTab;
import com.spss.java_client.ui.dialogs.adv_stats.neural_networks.RBFArchitectureTab;
import com.spss.java_client.ui.dialogs.adv_stats.neural_networks.SaveTab;
import com.spss.java_client.ui.dialogs.adv_stats.neural_networks.VariablesTab;
import com.spss.java_client.ui.dialogs.adv_stats.res.AdvStatsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JFrame;

public class NeuralNetworksRBFModelDlg
extends BaseTabbedDialog {
    private VariablesTab mVariableTab;
    private PartitionsTab mPartitionTab;
    private RBFArchitectureTab mArchitectTab;
    private OutputTab mOutputTab;
    private SaveTab mSaveTab;
    private ExportTab mExportTab;
    private OptionsTab mOptionTab;

    public NeuralNetworksRBFModelDlg(JFrame jFrame) {
        super(jFrame, false, AdvStatsResBundle.getDefaultResourceBundleName(), AdvStatsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_NNET_RBF_TITLE"));
        this.setLocationRelativeTo(jFrame);
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        this.mExportTab.loadTabState(this.getDialogDataModel(), this.getNameLabelOverride());
        this.mSaveTab.loadTabState(this.getDialogDataModel(), this.getNameLabelOverride());
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
        this.mExportTab.saveTabState(this.getDialogDataModel());
        this.mSaveTab.saveTabState(this.getDialogDataModel());
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("*Radial Basis Function Network.\n");
        String string = this.mSaveTab.getDeleteVariableNameSyntax();
        if (string.length() > 0) {
            stringBuffer.append(string).append(".\n");
        }
        if ((string = this.mSaveTab.getDeleteRootVariableNameSyntax()).length() > 0) {
            stringBuffer.append(string).append(".\n");
        }
        stringBuffer.append(this.mVariableTab.getVariablesTabSyntax());
        stringBuffer.append(this.mPartitionTab.getSyntax());
        stringBuffer.append(this.mArchitectTab.getRBFArchSyntax());
        stringBuffer.append(this.mOutputTab.getOutputTabSyntax());
        stringBuffer.append(this.mSaveTab.getSaveTabSyntax());
        stringBuffer.append(this.mExportTab.getExportTabSyntax());
        stringBuffer.append(this.mOptionTab.getOptionTabSyntax());
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public boolean okPastePressed() {
        if (!this.getVariablesTab().validateTab()) {
            return false;
        }
        if (!this.mPartitionTab.validateTab()) {
            return false;
        }
        if (!this.mArchitectTab.validateTab()) {
            return false;
        }
        if (!this.mSaveTab.validateTab()) {
            return false;
        }
        if (!this.mExportTab.validateTab()) {
            if (this.getTabbedPane().getSelectedIndex() != 5) {
                this.getTabbedPane().setSelectedIndex(5);
            }
            return false;
        }
        if (!this.mOptionTab.validateTab()) {
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public String getIActionKey() {
        return "analyze_neural_networks_radial_basis_function";
    }

    public VariablesTab getVariablesTab() {
        return this.mVariableTab;
    }

    public PartitionsTab getPartitionsTab() {
        return this.mPartitionTab;
    }

    public SaveTab getSaveTab() {
        return this.mSaveTab;
    }

    public RBFArchitectureTab getArchitectureTab() {
        return this.mArchitectTab;
    }

    public ExportTab getExportTab() {
        return this.mExportTab;
    }

    public OptionsTab getOptionsTab() {
        return this.mOptionTab;
    }

    @Override
    protected void enableOkPaste(boolean bl) {
        super.enableOkPaste(bl);
    }

    public boolean hasSplitVar() {
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        int n = iSpssDataSrc.getNSplitVars();
        return n > 0;
    }

    @Override
    public void reset() {
        Object[] objectArray = this.getResStringArray("IDS_NNET_MLP_RESET_BUTTON_LABELS");
        int n = SpssAlertOptionPane.showOptionDialog((Window)((Object)this), this.getResString("ERR_NNET_MLP_RESET_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, objectArray, (Object)objectArray[0]);
        if (n != 2) {
            if (n == 0) {
                super.reset();
                this.mVariableTab.reset();
                this.mPartitionTab.reset();
                this.mArchitectTab.reset();
                this.mOutputTab.reset();
                this.mSaveTab.reset();
                this.mExportTab.reset();
                this.mOptionTab.reset();
            } else {
                Component component = this.mTabbedPane.getSelectedComponent();
                if (component instanceof BaseProcedureTab) {
                    ((BaseProcedureTab)component).reset();
                }
            }
        }
    }

    @Override
    protected void init() {
        super.init();
        this.mVariableTab = new VariablesTab(this, true);
        this.addTab(this.getResString("IDS_NNET_MLP_VARIABLES"), this.mVariableTab);
        this.mPartitionTab = new PartitionsTab(this, true);
        this.addTab(this.getResString("IDS_NNET_MLP_PARTITIONS"), this.mPartitionTab);
        this.mArchitectTab = new RBFArchitectureTab(this);
        this.addTab(this.getResString("IDS_NNET_MLP_ARCHITECTURE"), this.mArchitectTab);
        this.mOutputTab = new OutputTab(this, true);
        this.addTab(this.getResString("IDS_NNET_MLP_OUTPUT"), this.mOutputTab);
        this.mSaveTab = new SaveTab(this, true);
        this.addTab(this.getResString("IDS_NNET_MLP_SAVE"), this.mSaveTab);
        this.mExportTab = new ExportTab(this, true);
        this.addTab(this.getResString("IDS_NNET_MLP_EXPORT"), this.mExportTab);
        this.mOptionTab = new OptionsTab(this, true);
        this.addTab(this.getResString("IDS_NNET_MLP_OPTIONS"), this.mOptionTab);
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mTabbedPane.setEnabledAt(4, false);
        }
        this.pack();
    }
}

