/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.neural_networks;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.adv_stats.neural_networks.NeuralNetworksMLPModelDlg;
import com.spss.java_client.ui.dialogs.adv_stats.neural_networks.NeuralNetworksRBFModelDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class ExportTab
extends BaseProcedureTab
implements ItemListener,
ActionListener,
FocusListener {
    private JCheckBox mExportModelAsXMLCheck;
    private static String FILE_NAME_PREFIX = "IDS_MLP_EXPORT_FILE_NAME";
    private Vector<String> mDependentVariableNames = new Vector();
    private Vector<String> mDependentVariableNamesPre = new Vector();
    private Vector<JButton> mBrowseButtons = new Vector();
    private Vector<FileTextField> mFilePath = new Vector();
    private Vector<FileTextField> mFilePathPre = new Vector();
    private Vector<StringTextField> mDepVarField = new Vector();
    private JLabel mFileLabel;
    private JPanel mFilePanel;
    private JTextField mDepVariable;
    private JTextField mFileName;
    private JTextField mEmpty;
    private JScrollPane mFileScrollPane;
    private boolean mIsRBF;

    public ExportTab(BaseTabbedDialog baseTabbedDialog, boolean bl) {
        super(baseTabbedDialog, true);
        this.mIsRBF = bl;
        this.initialize();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        this.mFilePath.clear();
        Object[] objectArray = dialogDataModel.getArray("IDS_MLP_DEP_VAR_NAMES");
        Object[] objectArray2 = dialogDataModel.getArray("IDS_MLP_FILE_NAMES_PRE");
        if (objectArray2 != null && objectArray != null && objectArray.length == objectArray2.length) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.mDependentVariableNamesPre.add((String)objectArray[i]);
                FileTextField fileTextField = new FileTextField();
                fileTextField.setText(objectArray2[i].toString());
                this.mFilePathPre.add(fileTextField);
                this.mFilePath.add(fileTextField);
            }
        }
    }

    @Override
    public void saveTabState(DialogDataModel dialogDataModel) {
        Object[] objectArray = this.mDependentVariableNamesPre.toArray();
        dialogDataModel.putArray("IDS_MLP_DEP_VAR_NAMES", objectArray);
        int n = 0;
        Object[] objectArray2 = new Object[this.mFilePathPre.size()];
        for (FileTextField fileTextField : this.mFilePathPre) {
            objectArray2[n++] = fileTextField.getText();
        }
        dialogDataModel.putArray("IDS_MLP_FILE_NAMES_PRE", objectArray2);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        super.validate();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        VarListModel varListModel = this.getTargetVars();
        int n = varListModel.getSize();
        this.mExportModelAsXMLCheck.setEnabled(true);
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mExportModelAsXMLCheck.setSelected(true);
            this.mExportModelAsXMLCheck.setEnabled(false);
        }
        if (!this.hasSplitVar()) {
            int n2;
            this.mDependentVariableNames.clear();
            this.mFilePath.clear();
            this.mBrowseButtons.clear();
            this.mDepVarField.clear();
            DialogDataModel dialogDataModel = this.getDialogDataModel();
            String string = dialogDataModel.getString("EXPORT_XML_FILE_PATH");
            for (n2 = 0; n2 < n; ++n2) {
                ISpssVariable iSpssVariable = varListModel.getElementAt(n2);
                String string2 = iSpssVariable.getName();
                this.mDependentVariableNames.add(string2);
                StringTextField stringTextField = new StringTextField(string2);
                stringTextField.setEditable(false);
                this.mDepVarField.add(stringTextField);
                ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_BROWSE_3_DOT");
                JButton jButton = new JButton(toggleButtonAction);
                jButton.setEnabled(true);
                jButton.addActionListener(this);
                Dimension dimension = jButton.getPreferredSize();
                dimension.width = 40;
                this.mBrowseButtons.add(jButton);
                int n3 = this.mDependentVariableNamesPre.indexOf(string2);
                FileTextField fileTextField = new FileTextField();
                String string3 = FILE_NAME_PREFIX.concat(String.valueOf(n2));
                fileTextField.setAction(new TextFieldAction(this.mParent, string3));
                Dimension dimension2 = fileTextField.getPreferredSize();
                dimension2.height = dimension.height;
                fileTextField.setPreferredSize(dimension2);
                fileTextField.setEditable(true);
                if (n3 >= 0) {
                    fileTextField.setText(this.mFilePathPre.get(n3).getText());
                }
                if (!RemoteFileChooser.enableSaveInModeler() && string != null) {
                    String string4 = this.getSequencedFileName(string, n2);
                    fileTextField.setText(string4);
                }
                this.mFilePath.add(fileTextField);
            }
            this.mDependentVariableNamesPre.clear();
            this.mFilePathPre.clear();
            this.mDependentVariableNamesPre = (Vector)this.mDependentVariableNames.clone();
            this.mFilePathPre = (Vector)this.mFilePath.clone();
            this.mFilePanel.removeAll();
            this.setupExportAsXMLPanel();
            this.validate();
            if (this.mExportModelAsXMLCheck.isSelected()) {
                this.mFilePanel.setEnabled(true);
                this.mDepVariable.setEnabled(true);
                this.mFileName.setEnabled(true);
                for (n2 = 0; n2 < this.mBrowseButtons.size(); ++n2) {
                    this.mBrowseButtons.get(n2).setEnabled(true);
                    this.mFilePath.get(n2).setEnabled(true);
                    this.mDepVarField.get(n2).setEnabled(true);
                }
            } else {
                this.mFilePanel.setEnabled(false);
                this.mDepVariable.setEnabled(false);
                this.mFileName.setEnabled(false);
                for (n2 = 0; n2 < this.mBrowseButtons.size(); ++n2) {
                    this.mBrowseButtons.get(n2).setEnabled(false);
                    this.mFilePath.get(n2).setEnabled(false);
                    this.mDepVarField.get(n2).setEnabled(false);
                }
            }
            this.setFocusTraversalPolicy();
        } else {
            this.mExportModelAsXMLCheck.setEnabled(false);
            this.mFilePanel.setEnabled(false);
            this.mDepVariable.setEnabled(false);
            this.mFileName.setEnabled(false);
            for (int i = 0; i < this.mBrowseButtons.size(); ++i) {
                this.mBrowseButtons.get(i).setEnabled(false);
                this.mFilePath.get(i).setEnabled(false);
                this.mDepVarField.get(i).setEnabled(false);
            }
        }
        this.repaint();
    }

    private boolean hasSplitVar() {
        boolean bl = this.mIsRBF ? ((NeuralNetworksRBFModelDlg)this.mParent).hasSplitVar() : ((NeuralNetworksMLPModelDlg)this.mParent).hasSplitVar();
        return bl;
    }

    private VarListModel getTargetVars() {
        VarListModel varListModel = this.mIsRBF ? ((NeuralNetworksRBFModelDlg)this.mParent).getVariablesTab().getTargetListModel() : ((NeuralNetworksMLPModelDlg)this.mParent).getVariablesTab().getTargetListModel();
        return varListModel;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        int n;
        int n2 = itemEvent.getStateChange();
        if (itemEvent.getSource() == this.mExportModelAsXMLCheck && n2 == 1) {
            this.mFilePanel.setEnabled(true);
            this.mDepVariable.setEnabled(true);
            this.mFileName.setEnabled(true);
            for (n = 0; n < this.mBrowseButtons.size(); ++n) {
                this.mBrowseButtons.get(n).setEnabled(true);
                this.mFilePath.get(n).setEnabled(true);
                this.mDepVarField.get(n).setEnabled(true);
            }
        }
        if (itemEvent.getSource() == this.mExportModelAsXMLCheck && n2 == 2) {
            this.mFilePanel.setEnabled(false);
            this.mDepVariable.setEnabled(false);
            this.mFileName.setEnabled(false);
            for (n = 0; n < this.mBrowseButtons.size(); ++n) {
                this.mBrowseButtons.get(n).setEnabled(false);
                this.mFilePath.get(n).setEnabled(false);
                this.mDepVarField.get(n).setEnabled(false);
            }
        }
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mFilePanel.setEnabled(false);
            this.mDepVariable.setEnabled(false);
            this.mFileName.setEnabled(false);
            for (n = 0; n < this.mBrowseButtons.size(); ++n) {
                this.mBrowseButtons.get(n).setEnabled(false);
                this.mFilePath.get(n).setEnabled(false);
                this.mDepVarField.get(n).setEnabled(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        for (int i = 0; i < this.mBrowseButtons.size(); ++i) {
            if (object != this.mBrowseButtons.get(i)) continue;
            this.showSaveDialog(i);
        }
    }

    @Override
    public String getDialogHelpID() {
        if (this.mIsRBF) {
            return "idh_idd_rbf_export";
        }
        return "idh_idd_mlp_export";
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    public String getExportTabSyntax() {
        StringBuffer stringBuffer = new StringBuffer("");
        this.aboutToShowTab();
        if (!RemoteFileChooser.enableSaveInModeler()) {
            DialogDataModel dialogDataModel = this.getDialogDataModel();
            if (this.hasSplitVar()) {
                dialogDataModel.putInteger("PMML_COUNT_KEY", 0);
                return "";
            }
            String string = dialogDataModel.getString("EXPORT_XML_FILE_PATH");
            int n = this.getTargetVars().getSize();
            if (string != null) {
                stringBuffer = SyntaxUtil.getSubCommand("\n  /OUTFILE MODEL=");
                for (int i = 0; i < n; ++i) {
                    String string2 = this.getSequencedFileName(string, i);
                    dialogDataModel.putString("EXPORT_XML_FILE_PATH" + i, string2);
                    stringBuffer.append("'").append(string2).append("' ");
                }
            }
            dialogDataModel.putInteger("PMML_COUNT_KEY", n);
        } else if (this.mExportModelAsXMLCheck.isEnabled() && this.mExportModelAsXMLCheck.isSelected() && this.mFilePath.size() > 0) {
            stringBuffer = SyntaxUtil.getSubCommand("\n  /OUTFILE MODEL=");
            for (FileTextField fileTextField : this.mFilePath) {
                stringBuffer.append("'").append(fileTextField.getText()).append("' ");
            }
        }
        return stringBuffer.toString();
    }

    public void removeDependentVariable(String string) {
        if (this.mDependentVariableNamesPre.contains(string)) {
            int n = this.mDependentVariableNamesPre.indexOf(string);
            if (n >= 0) {
                this.mFilePathPre.remove(n);
            }
            this.mDependentVariableNamesPre.remove(string);
        }
    }

    private DialogDataModel getDialogDataModel() {
        DialogDataModel dialogDataModel = this.mIsRBF ? ((NeuralNetworksRBFModelDlg)this.mParent).getDialogDataModel() : ((NeuralNetworksMLPModelDlg)this.mParent).getDialogDataModel();
        return dialogDataModel;
    }

    private String getSequencedFileName(String string, int n) {
        String string2 = "";
        int n2 = string.indexOf(46);
        if (n2 >= 0) {
            string2 = string.substring(0, n2);
            string2 = string2 + n;
            string2 = string2 + string.substring(n2);
        }
        return string2;
    }

    @Override
    protected boolean validateTab() {
        return this.doValidation();
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mExportModelAsXMLCheck;
    }

    private void initialize() {
        this.initVars();
        super.initPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(UIToolDialogUtil.getStandardDialogInsets().top, n2, n2, n2);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, this.mExportModelAsXMLCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, 0, n2);
        DialogUtil.addUsingGBL(this, this.mFileLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        insets.set(0, n2, n2, n2);
        gridBagConstraints.fill = 1;
        this.setupExportAsXMLPanel();
        DialogUtil.addUsingGBL(this, this.mFileScrollPane, gridBagConstraints, 0, 2, 1, 1, n, insets);
        this.setDefaults();
        this.setFocusTraversalPolicy();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mExportModelAsXMLCheck);
        for (Component component : this.mBrowseButtons) {
            vector.add(component);
        }
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component;
            component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private void setDefaults() {
        this.mExportModelAsXMLCheck.setEnabled(true);
        this.mFilePanel.setEnabled(false);
        this.mDepVariable.setEnabled(false);
        this.mFileName.setEnabled(false);
        this.mExportModelAsXMLCheck.setSelected(false);
        for (FileTextField fileTextField : this.mFilePath) {
            fileTextField.setText("");
        }
        for (int i = 0; i < this.mBrowseButtons.size(); ++i) {
            this.mBrowseButtons.get(i).setEnabled(false);
            this.mFilePath.get(i).setEnabled(false);
            this.mDepVarField.get(i).setEnabled(false);
        }
        if (!RemoteFileChooser.enableSaveInModeler() && !this.hasSplitVar()) {
            this.mExportModelAsXMLCheck.setSelected(true);
            this.mExportModelAsXMLCheck.setEnabled(false);
        }
    }

    private void initVars() {
        this.mFilePanel = PanelFactory.getEmptyPanel("");
        this.mFileLabel = DialogUtil.createLabel(this.mParent, "IDS_NNET_MLP_EXPORT_VARIBLE_AND_FILE_NAME");
        this.mFileLabel.setLabelFor(this.mFilePanel);
        this.mFileScrollPane = new JScrollPane(this.mFilePanel);
        this.mFilePanel.setMinimumSize(new Dimension(300, 420));
        this.mFileScrollPane.setPreferredSize(new Dimension(300, 420));
        this.mFileScrollPane.setHorizontalScrollBarPolicy(31);
        this.mFileScrollPane.setVerticalScrollBarPolicy(20);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_NNET_MLP_EXPORT_TO_XML");
        this.mExportModelAsXMLCheck = new JCheckBox(toggleButtonAction);
        this.mExportModelAsXMLCheck.addItemListener(this);
        this.mDepVariable = new JTextField(" " + this.getResString("IDS_NNET_MLP_SAVE_DEPENDENT_VARIABLE"));
        this.mDepVariable.setEditable(false);
        this.mFileName = new JTextField(this.getResString("IDS_NNET_MLP_EXPORT_FILE_NAME"));
        this.mFileName.setEditable(false);
        this.mEmpty = new JTextField("       ");
        this.mEmpty.setEditable(false);
    }

    private void setupExportAsXMLPanel() {
        int n = this.mDependentVariableNames.size();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        if (n == 0) {
            gridBagConstraints.weighty = 1.0;
        }
        DialogUtil.addUsingGBL(this.mFilePanel, this.mDepVariable, gridBagConstraints, 0, 0, 1, 1, n2, null);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(this.mFilePanel, this.mFileName, gridBagConstraints, 1, 0, 1, 1, n2, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        Dimension dimension = this.mEmpty.getPreferredSize();
        DialogUtil.addUsingGBL(this.mFilePanel, this.mEmpty, gridBagConstraints, 2, 0, 1, 1, n2, null);
        for (int i = 0; i < n; ++i) {
            if (i == n - 1) {
                gridBagConstraints.weighty = 1.0;
            }
            int n3 = i + 1;
            gridBagConstraints.fill = 2;
            Dimension dimension2 = this.mBrowseButtons.get(i).getPreferredSize();
            dimension.width = dimension2.width;
            this.mEmpty.setPreferredSize(dimension);
            Dimension dimension3 = this.mDepVarField.get(i).getPreferredSize();
            dimension3.height = dimension2.height;
            this.mDepVarField.get(i).setPreferredSize(dimension3);
            gridBagConstraints.weightx = 0.0;
            DialogUtil.addUsingGBL(this.mFilePanel, (JComponent)((Object)this.mDepVarField.get(i)), gridBagConstraints, 0, n3, 1, 1, n2, null);
            gridBagConstraints.weightx = 1.0;
            DialogUtil.addUsingGBL(this.mFilePanel, (JComponent)((Object)this.mFilePath.get(i)), gridBagConstraints, 1, n3, 1, 1, n2, null);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 2;
            ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_BROWSE_3_DOT");
            JButton jButton = new JButton(toggleButtonAction);
            jButton.setEnabled(true);
            jButton.addActionListener(this);
            DialogUtil.addUsingGBL(this.mFilePanel, this.mBrowseButtons.get(i), gridBagConstraints, 2, n3, 1, 1, n2, null);
        }
    }

    private void showSaveDialog(int n) {
        String string = this.getResString("IDS_NNET_MLP_EXPORT_XML_FILE_FILTER_EXTN");
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), true);
        remoteFileChooser.setDialogTitle(this.getResString("IDS_NNET_MLP_EXPORT_SAVE_DIALOG_TITLE"));
        remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(this.getResString("IDS_NNET_MLP_EXPORT_XML_FILE_FILTER"), string));
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        int n2 = remoteFileChooser.showSaveDialog((Component)this.mParent);
        if (n2 == 0) {
            String string2 = remoteFileChooser.getSelectedFilePath();
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            if (!string.regionMatches(true, 0, string2, string2.length() - string.length(), string.length())) {
                string2 = string2 + string;
            }
            this.mFilePath.get(n).setText(string2);
        }
    }

    private boolean doValidation() {
        if (!RemoteFileChooser.enableSaveInModeler()) {
            return true;
        }
        if (this.mExportModelAsXMLCheck.isSelected()) {
            int n = this.getTargetVars().getSize();
            if (this.mFilePath.size() != n && (this.mFilePath.size() == 0 || n > this.mFilePath.size())) {
                SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_MLP_EXPORT_WARNING_MESG1"), VersionInfo.getAppVersionString());
                return false;
            }
            for (int i = 0; i < this.mFilePath.size(); ++i) {
                String string = this.mFilePath.get(i).getText();
                if (string.equals("")) {
                    SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_MLP_EXPORT_WARNING_MESG1"), VersionInfo.getAppVersionString());
                    NeuralNetworksMLPModelDlg.setSelectionText((JComponent)((Object)this.mFilePath.get(i)), 0);
                    return false;
                }
                for (int j = i + 1; j < this.mFilePath.size(); ++j) {
                    if (!string.equals(this.mFilePath.get(j).getText())) continue;
                    SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_NNET_MLP_EXPORT_WARNING_MESG2"), VersionInfo.getAppVersionString());
                    NeuralNetworksMLPModelDlg.setSelectionText((JComponent)((Object)this.mFilePath.get(j)), 0);
                    return false;
                }
            }
        }
        return true;
    }
}

