/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.multivariate;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.adv_stats.GLMCommonContrast;
import com.spss.java_client.ui.dialogs.adv_stats.GLMCommonEMMeans;
import com.spss.java_client.ui.dialogs.adv_stats.GLMCommonModel;
import com.spss.java_client.ui.dialogs.adv_stats.GLMCommonOptions;
import com.spss.java_client.ui.dialogs.adv_stats.GLMCommonPlots;
import com.spss.java_client.ui.dialogs.adv_stats.GLMCommonPostHoc;
import com.spss.java_client.ui.dialogs.adv_stats.GLMCommonSave;
import com.spss.java_client.ui.dialogs.adv_stats.res.AdvStatsResBundle;
import com.spss.java_client.ui.dialogs.common.AbstractModelSubDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BootstrapDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class MultivariateDlg
extends BaseProcedureDialog
implements ListDataListener {
    public static final String OVERALL = "(OVERALL)";
    static final String DEP_VAR_LIST = "IDS_DEP_VAR_LIST";
    static final String FIX_FACTOR_LIST = "IDS_FIX_FACTOR_LIST";
    static final String COVARIATE_LIST = "IDS_COVARIATE_LIST";
    static final String WLSWEIGHT_LIST = "IDS_WLSWEIGHT_LIST";
    static final String MODEL_BUTTON = "IDS_COMMON_MODEL_BUTTON";
    static final String CONTRAST_BUTTON = "IDS_COMMON_CONTRASTS_BUTTON";
    static final String PLOTS_BUTTON = "IDS_COMMON_PLOTS_BUTTON";
    static final String POST_HOC_BUTTON = "IDS_COMMON_POSTHOC_BUTTON";
    static final String EM_MEANS_BUTTON = "IDS_COMMON_EMMEANS_BUTTON";
    static final String SAVE_BUTTON = "IDS_COMMON_SAVE_BUTTON";
    static final String OPTIONS_BUTTON = "IDS_COMMON_OPTIONS_3DOT";
    private static final int TARGET_LIST_MAX_LIMIT = 200;
    private ArrowButton mFixFactorListArrow;
    private ArrowButton mDepVarListArrow;
    private ArrowButton mCovarListArrow;
    private ArrowButton mWlsWtListArrow;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mDepVarList;
    private TargetVariableList mFixFactorList;
    private TargetVariableList mCovarList;
    private TargetVariableList mWlsWtList;
    private JScrollPane mDepVarListScroll;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mCovarScrollPane;
    private JScrollPane mFixScrollPane;
    private JScrollPane mWlsWtListScroll;
    private JButton mPostHocButton;
    private LinkedHashMap<String, String> mSavemap;
    private boolean mIsBootstrapOK;

    public MultivariateDlg(JFrame jFrame) {
        super(jFrame, false, AdvStatsResBundle.getDefaultResourceBundleName(), AdvStatsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_MULTIVARIATE"));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_glm_multivariate";
    }

    public String getFixedFactorList() {
        return this.mFixFactorList.getVariablesStringList();
    }

    public Vector<String> getFactorCombinations() {
        Vector<String> vector = new Vector<String>();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean(AbstractModelSubDialog.MODEL_CUSTOM_KEY);
        if (bl != null && bl.booleanValue()) {
            vector = this.getCustomModelFactorVarList();
        }
        if (vector.size() != 0) {
            return vector;
        }
        int n = this.mFixFactorList.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mFixFactorList.getModel().getElementAt(i).getName());
        }
        if (vector.size() > 0 && vector.size() <= 8) {
            Combinations combinations = new Combinations();
            return combinations.generateCombinations(vector);
        }
        return vector;
    }

    public Vector<String> getFixFactorVarList() {
        String string = this.mFixFactorList.getVariablesStringList();
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        return vector;
    }

    public Vector<String> getFullFactorialFixFactorVarList() {
        return this.getFixFactorVarList();
    }

    public Vector<String> getCustomFactorialFixFactorVarList() {
        return this.getCustomModelFactorVarList();
    }

    protected Vector<String> getCustomModelFactorVarList() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = this.getFixFactorVarList();
        Object[] objectArray = dialogDataModel.getArray(AbstractModelSubDialog.MODEL_TERMS_KEY);
        if (objectArray != null) {
            for (Object object : objectArray) {
                String string;
                String string2 = object.toString();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "*");
                int n = stringTokenizer.countTokens();
                for (int i = 0; i < n && vector2.contains(string = stringTokenizer.nextToken()); ++i) {
                    if (i < n - 1) continue;
                    vector.add(string2);
                }
            }
        }
        return vector;
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mDepVarList.getModel()) {
            this.enableOkPaste(this.mDepVarList.getModel().getSize() >= 2);
        }
        if (listDataEvent.getSource() == this.mCovarList.getModel()) {
            this.mPostHocButton.setEnabled(false);
        }
        if (listDataEvent.getSource() == this.mWlsWtList.getModel()) {
            this.mSavemap.put("IDS_PRE_WEIGHTED", "WPRED");
            this.mSavemap.put("IDS_RES_WEIGHTED", "WRESID");
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        String string;
        int n;
        ArrayList<ISpssVariable> arrayList;
        ISpssVariable[] iSpssVariableArray;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        if (listDataEvent.getSource() == this.mDepVarList.getModel()) {
            this.enableOkPaste(this.mDepVarList.getModel().getSize() >= 2);
        }
        if (listDataEvent.getSource() == this.mCovarList.getModel() && this.mCovarList.getModel().getSize() == 0) {
            this.mPostHocButton.setEnabled(true);
        }
        VarListModel varListModel = this.mFixFactorList.getModel();
        if (listDataEvent.getSource() == this.mFixFactorList.getModel()) {
            iSpssVariableArray = dialogDataModel.getVarArray("IDS_SRC_LIST");
            arrayList = new ArrayList<ISpssVariable>();
            if (iSpssVariableArray != null && iSpssVariableArray.length > 0) {
                block0: for (n = 0; n < varListModel.getSize(); ++n) {
                    string = varListModel.getElementAt(n).getName();
                    for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                        String string2 = iSpssVariable.getName();
                        if (!string.equals(string2)) continue;
                        arrayList.add(iSpssVariable);
                        continue block0;
                    }
                }
                if (arrayList.size() == 0) {
                    dialogDataModel.putVarArray("IDS_SRC_LIST", null);
                } else {
                    ISpssVariable[] iSpssVariableArray2 = new ISpssVariable[arrayList.size()];
                    dialogDataModel.putVarArray("IDS_SRC_LIST", arrayList.toArray(iSpssVariableArray2));
                }
            }
        }
        iSpssVariableArray = dialogDataModel.getVarArray("IDS_POSTHOC_TARGET_LIST");
        arrayList = new ArrayList();
        if (iSpssVariableArray != null) {
            block2: for (n = 0; n < varListModel.getSize(); ++n) {
                string = varListModel.getElementAt(n).getName();
                for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                    if (!string.equals(iSpssVariable.getName())) continue;
                    arrayList.add(iSpssVariable);
                    continue block2;
                }
            }
            if (arrayList.size() == 0) {
                this.resetPostHocSubDialog();
            } else {
                ISpssVariable[] iSpssVariableArray3 = new ISpssVariable[arrayList.size()];
                dialogDataModel.putVarArray("IDS_POSTHOC_TARGET_LIST", arrayList.toArray(iSpssVariableArray3));
            }
        }
        if (listDataEvent.getSource() == this.mWlsWtList.getModel()) {
            this.mSavemap.remove("IDS_PRE_WEIGHTED");
            this.mSavemap.remove("IDS_RES_WEIGHTED");
        }
        this.validateDialogDataModel();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void reset() {
        super.reset();
        this.mDepVarList.removeAll();
        this.mFixFactorList.removeAll();
        this.mCovarList.removeAll();
        this.mWlsWtList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.setDefaults();
    }

    @Override
    public String generateSyntax() {
        Object object;
        StringBuffer stringBuffer;
        String string;
        Map.Entry<String, String> entry2;
        String string2;
        String string3;
        StringBuffer stringBuffer2 = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        DialogDataModel dialogDataModel2 = (DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY);
        boolean bl = false;
        if (this.mIsBootstrapOK && dialogDataModel2 != null) {
            bl = true;
            string3 = this.mDepVarList.getVariablesStringList();
            string2 = this.mFixFactorList.getVariablesStringList() + " " + this.mCovarList.getVariablesStringList() + " " + this.mWlsWtList.getVariablesStringList();
            stringBuffer2.append(BootstrapDlg.getBootstrapSyntax(string3, string2, dialogDataModel2));
        }
        stringBuffer2.append(SyntaxUtil.getMainCommand("GLM"));
        stringBuffer2.append(SyntaxUtil.getMainCommandParamters(this.mDepVarList.getVariablesStringList()));
        if (this.mFixFactorList.getModel().getSize() > 0) {
            stringBuffer2.append(" BY ").append(this.mFixFactorList.getVariablesStringList());
        }
        if (this.mCovarList.getModel().getSize() > 0) {
            stringBuffer2.append(" WITH ").append(this.mCovarList.getVariablesStringList());
        }
        stringBuffer2.append("\n");
        string3 = this.mWlsWtList.getVariablesStringList();
        if (!string3.equals("")) {
            stringBuffer2.append(SyntaxUtil.getSubCommand("/REGWGT="));
            stringBuffer2.append(string3).append("\n");
        }
        if (!(string2 = GLMCommonContrast.getGLMContrastSyntax(this, dialogDataModel)).equals("")) {
            stringBuffer2.append(string2);
        }
        stringBuffer2.append(SyntaxUtil.getSubCommand("/METHOD="));
        if (dialogDataModel.getInteger("IDS_SUM_OF_SQUARE_COMBO") != null) {
            stringBuffer2.append("SSTYPE(").append(dialogDataModel.getInteger("IDS_SUM_OF_SQUARE_COMBO") + 1).append(")\n");
        } else {
            stringBuffer2.append("SSTYPE(3)\n");
        }
        Boolean bl2 = dialogDataModel.getBoolean("IDS_INCLUDE_INTERCEPT");
        stringBuffer2.append(SyntaxUtil.getSubCommand("/INTERCEPT="));
        if (bl2 != null && !bl2.booleanValue()) {
            stringBuffer2.append("EXCLUDE\n");
        } else {
            stringBuffer2.append("INCLUDE\n");
        }
        String string4 = "";
        String string5 = "";
        this.getSaveCheckMap();
        for (Map.Entry<String, String> entry2 : this.mSavemap.entrySet()) {
            bl2 = dialogDataModel.getBoolean(entry2.getKey());
            if (bl2 == null || !bl2.booleanValue()) continue;
            string5 = string5 + entry2.getValue() + " ";
        }
        if ((string5 = string5.trim()).length() > 0) {
            string4 = string4 + SyntaxUtil.getSubCommand("/SAVE=").toString() + string5 + "\n";
        }
        boolean bl3 = false;
        entry2 = null;
        String string6 = "";
        bl2 = dialogDataModel.getBoolean("IDS_CREATE_COEFFICIENT_STATS");
        if (bl2 != null && bl2.booleanValue()) {
            string4 = string4 + SyntaxUtil.getSubCommand("/OUTFILE=").toString();
            bl2 = dialogDataModel.getBoolean("IDS_CREATE_NEW_DATASET");
            if (bl2 != null && bl2.booleanValue()) {
                string6 = dialogDataModel.getString("IDS_DATASET_NAME_EDIT");
                string4 = string4 + "COVB(" + string6 + ")\n";
                bl3 = true;
            }
            if ((bl2 = dialogDataModel.getBoolean("IDS_WRITE_NEW_DATA_FILE")) != null && bl2.booleanValue()) {
                entry2 = dialogDataModel.getString("IDS_FILE_PATH");
                string4 = string4 + "COVB(" + CharacterUtil.smartQuote((String)((Object)entry2)) + ")\n";
            }
        }
        stringBuffer2.append(string4);
        if (this.mPostHocButton.isEnabled()) {
            stringBuffer2.append(GLMCommonPostHoc.getPostHocDlgSyntax(this, dialogDataModel));
        }
        if (!(string = GLMCommonPlots.getCommonPlotDlgSyntax(dialogDataModel)).equals("")) {
            stringBuffer2.append(SyntaxUtil.getSubCommand("/PLOT=")).append(string).append("\n");
        }
        stringBuffer2.append(this.getOptionsDlgSyntax(dialogDataModel));
        if (this.mFixFactorList.getModel().getSize() > 0 || this.mCovarList.getModel().getSize() > 0) {
            String string7;
            stringBuffer2.append("\n");
            stringBuffer2.append(SyntaxUtil.getSubCommand("/DESIGN="));
            stringBuffer = new StringBuffer();
            bl2 = dialogDataModel.getBoolean(AbstractModelSubDialog.MODEL_CUSTOM_KEY);
            if (bl2 != null && bl2.booleanValue() && (object = dialogDataModel.getArray(AbstractModelSubDialog.MODEL_TERMS_KEY)) != null) {
                for (Object object2 : object) {
                    string7 = object2.toString();
                    stringBuffer.append(string7).append(" ");
                }
            }
            if ((bl2 = dialogDataModel.getBoolean(AbstractModelSubDialog.MODEL_BUILD_CUSTOM_TERM_KEY)) != null && bl2.booleanValue() && (object = dialogDataModel.getArray(AbstractModelSubDialog.MODEL_TERMS_KEY)) != null) {
                for (Object object2 : object) {
                    string7 = object2.toString();
                    stringBuffer.append(string7).append(" ");
                }
            }
            object = this.mCovarList.getVariablesStringList();
            if (stringBuffer.length() > 0) {
                stringBuffer2.append(stringBuffer.toString().trim());
            } else {
                if (((String)object).length() > 0) {
                    stringBuffer2.append((String)object);
                }
                Vector<String> vector = this.getFactorCombinations();
                int n = vector.size();
                StringBuffer stringBuffer3 = new StringBuffer("");
                for (int i = 0; i < n; ++i) {
                    stringBuffer3.append((String)vector.get(i)).append(" ");
                }
                if (stringBuffer3.length() > 0) {
                    stringBuffer2.append(" ").append(stringBuffer3.toString().trim());
                } else {
                    stringBuffer2.append(stringBuffer3.toString().trim());
                }
            }
        }
        stringBuffer2.append(SyntaxUtil.terminateSyntax());
        if (bl3) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(SyntaxUtil.getMainCommand("DATASET DECLARE "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(string6));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(stringBuffer2);
            stringBuffer2 = stringBuffer;
        }
        if ((stringBuffer = PES_Repository.getPesFile((String)((Object)entry2))) != null && (object = stringBuffer.getPerAttributesSyntax()) != null) {
            stringBuffer2.append((String)object);
        }
        if (bl && dialogDataModel2 != null) {
            stringBuffer2.append(BootstrapDlg.getRestoreSyntax(dialogDataModel2));
        }
        if (bl3 && CommandLine.isClementineCaller() && RemoteFileChooser.enableSaveInModeler()) {
            stringBuffer2.append("\nDATASET ACTIVATE " + string6);
            stringBuffer2.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String getOptionsDlgSyntax(DialogDataModel dialogDataModel) {
        void var8_11;
        Boolean bl;
        Object object2;
        String[] stringArray = new String[]{"LSD", "BONFERRONI", "SIDAK"};
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        Object[] objectArray = dialogDataModel.getArray("IDS_OPTIONS_TARGET_LIST");
        if (objectArray != null) {
            for (Object object2 : objectArray) {
                stringBuffer.append(SyntaxUtil.getSubCommand("/EMMEANS="));
                String string2 = object2.toString();
                string = string2.contains(OVERALL) ? string + "TABLES" + string2 + " " : string + "TABLES(" + string2 + ") ";
                if (this.mCovarList.getModel().getSize() > 0) {
                    string = string + "WITH(";
                    for (int i = 0; i < this.mCovarList.getModel().getSize(); ++i) {
                        string = string + this.mCovarList.getModel().getElementAt(i).getName() + "=MEAN ";
                    }
                    string = string.trim() + ") ";
                }
                if (!string2.contains("*") && !string2.contains(OVERALL) && (bl = dialogDataModel.getBoolean("IDS_GLM_COMPARE_MAIN_EFFECTS")) != null && bl.booleanValue()) {
                    string = string + "COMPARE ADJ(";
                    string = string + stringArray[dialogDataModel.getInteger("IDS_CONFIDENCE_INTERVAL_COMBO")];
                    string = string + ")";
                }
                stringBuffer.append(string).append("\n");
                string = "";
            }
        }
        String string3 = "";
        String string4 = "";
        LinkedHashMap<String, String> linkedHashMap = this.getDisplayMap();
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            bl = dialogDataModel.getBoolean((String)entry.getKey());
            if (bl == null || !bl.booleanValue()) continue;
            string4 = string4 + (String)entry.getValue() + " ";
        }
        if ((string4 = string4.trim()).length() > 0) {
            String string5 = string3 + SyntaxUtil.getSubCommand("/PRINT=").toString() + string4 + "\n";
        }
        object2 = "";
        bl = dialogDataModel.getBoolean("IDS_SPREAD_VS_LEVEL_PLOT");
        if (bl != null && bl.booleanValue()) {
            object2 = (String)object2 + "SPREADLEVEL ";
        }
        if ((bl = dialogDataModel.getBoolean("IDS_RESIDUAL_PLOT")) != null && bl.booleanValue()) {
            object2 = (String)object2 + "RESIDUALS ";
        }
        if (((String)object2).length() > 0) {
            void var8_9;
            String string6 = (String)var8_9 + SyntaxUtil.getSubCommand("/PLOT=").toString() + (String)object2 + "\n";
        }
        stringBuffer.append((String)var8_11);
        String string7 = dialogDataModel.getString("IDS_SIGNIFICANCE_LEVEL_EDIT");
        stringBuffer.append(SyntaxUtil.getSubCommand("/CRITERIA="));
        if (string7 != null) {
            stringBuffer.append("ALPHA(").append(string7).append(")");
        } else {
            stringBuffer.append("ALPHA(.05)");
        }
        return stringBuffer.toString();
    }

    public Boolean isWLSListEmpty() {
        return this.mWlsWtList.getModel().getSize() == 0;
    }

    public VarListModel getFixedFactorListModel() {
        return this.mFixFactorList.getModel();
    }

    public VarListModel getCovarListModel() {
        return this.mCovarList.getModel();
    }

    @Override
    public String getIActionKey() {
        return "analyze_gen_linear_multivariate";
    }

    @Override
    public boolean okPastePressed() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean(AbstractModelSubDialog.MODEL_CUSTOM_KEY);
        Boolean bl2 = dialogDataModel.getBoolean(AbstractModelSubDialog.MODEL_BUILD_CUSTOM_TERM_KEY);
        if (bl != null && bl.booleanValue() || bl2 != null && bl2.booleanValue()) {
            if (dialogDataModel.getArray(AbstractModelSubDialog.MODEL_TERMS_KEY).length == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_MODEL_NOT_SPECIFIED_MESSAGE"), VersionInfo.getAppVersionString());
                return false;
            }
            if (this.mFixFactorList.getModel().getSize() > 0 || this.mCovarList.getModel().getSize() > 0) {
                ISpssVariable iSpssVariable;
                int n;
                String string = "";
                for (n = 0; n < this.mFixFactorList.getModel().getSize(); ++n) {
                    iSpssVariable = this.mFixFactorList.getModel().getElementAt(n);
                    if (this.isVariablePresentInModel(iSpssVariable.getName())) continue;
                    string = string + iSpssVariable.getName() + " ";
                }
                for (n = 0; n < this.mCovarList.getModel().getSize(); ++n) {
                    iSpssVariable = this.mCovarList.getModel().getElementAt(n);
                    if (this.isVariablePresentInModel(iSpssVariable.getName())) continue;
                    string = string + iSpssVariable.getName() + " ";
                }
                string = string.trim();
                if (!(string = string.replace(" ", ", ")).equals("")) {
                    String string2 = String.format(this.getResString("ERR_GLM_UNUSED_FACTORS_AND_COVARIATE_MESSAGE"), string);
                    return SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), string2, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION) == 0;
                }
            }
            if (this.mIsBootstrapOK && BootstrapDlg.isStrataVariableListEmpty(this)) {
                this.runSubDialog(new BootstrapDlg(this));
                return false;
            }
        }
        return true;
    }

    public boolean isVariablePresentInModel(String string) {
        boolean bl = false;
        Object[] objectArray = this.getDialogDataModel().getArray(AbstractModelSubDialog.MODEL_TERMS_KEY);
        if (objectArray != null) {
            for (Object object : objectArray) {
                String string2 = object.toString();
                if (string2.contains("*") || string2.contains("(")) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, "*");
                    int n = stringTokenizer.countTokens();
                    for (int i = 0; i < n; ++i) {
                        StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "(");
                        while (stringTokenizer2.hasMoreTokens()) {
                            String string3 = stringTokenizer2.nextToken();
                            if (!stringTokenizer2.hasMoreTokens()) {
                                string3 = string3.replace(")", "");
                                string3 = string3.trim();
                            }
                            if (!string3.equals(string)) continue;
                            return true;
                        }
                    }
                    continue;
                }
                if (!string2.equals(string)) continue;
                return true;
            }
        }
        return bl;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(MODEL_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultivariateDlg.this.runModelSubDlg();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton);
        toggleButtonAction = new ToggleButtonAction(CONTRAST_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultivariateDlg.this.runContrastSubDlg();
            }
        };
        JButton jButton2 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton2);
        toggleButtonAction = new ToggleButtonAction(PLOTS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultivariateDlg.this.runPlotsSubDlg();
            }
        };
        JButton jButton3 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton3);
        toggleButtonAction = new ToggleButtonAction(POST_HOC_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultivariateDlg.this.runPostHocSubDlg();
            }
        };
        this.mPostHocButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mPostHocButton);
        toggleButtonAction = new ToggleButtonAction(EM_MEANS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultivariateDlg.this.runEMMeansSubDlg();
            }
        };
        JButton jButton4 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton4);
        toggleButtonAction = new ToggleButtonAction(SAVE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultivariateDlg.this.runSaveSubDlg();
            }
        };
        JButton jButton5 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton5);
        toggleButtonAction = new ToggleButtonAction(OPTIONS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultivariateDlg.this.runOptionsSubDlg();
            }
        };
        JButton jButton6 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton6);
        this.mIsBootstrapOK = false;
        if (VersionInfo.allowBootstrapping()) {
            this.mIsBootstrapOK = true;
            toggleButtonAction = new ToggleButtonAction("IDS_COMMON_BOOTSTRAPPING_BUTTON"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MultivariateDlg.this.runSubDialog(new BootstrapDlg(MultivariateDlg.this));
                }
            };
            JButton jButton7 = new JButton(toggleButtonAction);
            this.addOptionsPanelButton(jPanel, jButton7);
            if (BootstrapDlg.isCurrentDatasetInMIMode()) {
                jButton7.setEnabled(false);
                this.mIsBootstrapOK = false;
            }
        }
        return jPanel;
    }

    protected void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mDepVarList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mDepVarList.setMaxLimitOfList(200);
        this.mDepVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mDepVarList.getModel().addListDataListener(this);
        this.mDepVarListScroll = new JScrollPane(this.mDepVarList);
        this.mDepVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mDepVarList.getFixedCellHeight() * 3 + 2));
        this.mDepVarListScroll.setPreferredSize(this.mDepVarList.getMinimumSize());
        this.mDepVarList.setIdentifier(DEP_VAR_LIST);
        this.mDepVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mFixFactorList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mFixFactorList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mFixFactorList.getModel().addListDataListener(this);
        this.mFixScrollPane = new JScrollPane(this.mFixFactorList);
        this.mFixFactorList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mFixFactorList.getFixedCellHeight() * 3 + 2));
        this.mFixScrollPane.setPreferredSize(this.mFixFactorList.getMinimumSize());
        this.mFixFactorList.setIdentifier(FIX_FACTOR_LIST);
        this.mCovarList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mCovarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mCovarList.getModel().addListDataListener(this);
        this.mCovarScrollPane = new JScrollPane(this.mCovarList);
        this.mCovarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mCovarList.getFixedCellHeight() * 3 + 2));
        this.mCovarScrollPane.setPreferredSize(this.mCovarList.getMinimumSize());
        this.mCovarList.setIdentifier(COVARIATE_LIST);
        this.mCovarList.addVarFilter(new SpssVarFilter(8, false));
        this.mWlsWtList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mWlsWtList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mWlsWtList.getModel().addListDataListener(this);
        this.mWlsWtListScroll = new JScrollPane(this.mWlsWtList);
        this.mWlsWtListScroll.setHorizontalScrollBarPolicy(31);
        this.mWlsWtListScroll.setVerticalScrollBarPolicy(21);
        this.mWlsWtListScroll.setPreferredSize(this.mWlsWtList.getMinimumSize());
        this.mWlsWtList.setIdentifier(WLSWEIGHT_LIST);
        this.mWlsWtList.addVarFilter(new SpssVarFilter(8, false));
        this.mDepVarListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mDepVarListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mDepVarListArrow.registerVariableList(this.mDepVarList, SpssArrowButton.ButtonOrientation.left);
        this.mFixFactorListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mFixFactorListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mFixFactorListArrow.registerVariableList(this.mFixFactorList, SpssArrowButton.ButtonOrientation.left);
        this.mCovarListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCovarListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mCovarListArrow.registerVariableList(this.mCovarList, SpssArrowButton.ButtonOrientation.left);
        this.mWlsWtListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mWlsWtListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mWlsWtListArrow.registerVariableList(this.mWlsWtList, SpssArrowButton.ButtonOrientation.left);
        this.mSavemap = new LinkedHashMap();
        this.setDefaults();
    }

    protected void setDefaults() {
        this.enableOkPaste(false);
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
        this.validateDialogDataModel();
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mDepVarListArrow);
        vector.add(this.mFixFactorListArrow);
        vector.add(this.mCovarListArrow);
        vector.add(this.mWlsWtListArrow);
        vector.add(this.mDepVarList);
        vector.add(this.mFixFactorList);
        vector.add(this.mCovarList);
        vector.add(this.mWlsWtList);
        int n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setupViewPanel(JPanel jPanel) {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_MULTIVARIATE_DEPENDENT_VARIABLE");
        jLabel.setLabelFor(this.mDepVarList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_MULTIVARIATE_FIXED_FACTOR");
        jLabel2.setLabelFor(this.mFixFactorList);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_MULTIVARIATE_COVARIATE");
        jLabel3.setLabelFor(this.mCovarList);
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_MULTIVARIATE_WLSWEIGHT");
        jLabel4.setLabelFor(this.mWlsWtList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel5 = DialogUtil.createLabel(this, "IDS_MULTIVARIATE_SOURCE_LIST_LABEL");
        jLabel5.setLabelFor(this.mSrcVarList);
        gridBagConstraints.fill = 0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel5, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        Insets insets = DialogUtil.getArrowButtonInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(0, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 8, n, null);
        Insets insets3 = DialogUtil.getStandardControlInsets();
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mDepVarListArrow, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, insets3);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mDepVarListScroll, gridBagConstraints, 2, 1, 1, 1, n, insets3);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mFixFactorListArrow, gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        Insets insets4 = new Insets(n2, insets3.left, insets3.bottom, insets3.right);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 2, 1, 1, n, insets4);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mFixScrollPane, gridBagConstraints, 2, 3, 1, 1, n, insets3);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mCovarListArrow, gridBagConstraints, 1, 5, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 4, 1, 1, n, insets4);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mCovarScrollPane, gridBagConstraints, 2, 5, 1, 1, n, insets3);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mWlsWtListArrow, gridBagConstraints, 1, 7, 1, 1, n, insets2);
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 2, 6, 1, 1, n, new Insets(insets4.top, insets4.left, insets4.bottom - 9, insets4.right));
        n = 20;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mWlsWtListScroll, gridBagConstraints, 2, 7, 1, 1, n, insets3);
    }

    private void runModelSubDlg() {
        this.runSubDialog(new GLMCommonModel(this, this.getResString("IDS_MULTIVARIATE_MODEL_TITLE"), this.mFixFactorList.getModel(), this.mCovarList.getModel(), null, "IDS_MULTIVARIATE_FULL_FACTORIAL"));
    }

    private void runContrastSubDlg() {
        this.runSubDialog(new GLMCommonContrast((BaseProcedureDialog)this, this.getResString("IDS_MULTIVARIATE_CONTRASTS_TITLE"), null, this.mFixFactorList.getModel(), null));
    }

    private void runPlotsSubDlg() {
        this.runSubDialog(new GLMCommonPlots((BaseProcedureDialog)this, this.getResString("IDS_MULTIVARIATE_PROFILEPLOTS_TITLE"), null, this.mFixFactorList.getModel(), null));
    }

    private void runPostHocSubDlg() {
        this.runSubDialog(new GLMCommonPostHoc(this.mFixFactorList.getModel(), this));
    }

    private void runEMMeansSubDlg() {
        this.runSubDialog(new GLMCommonEMMeans(this));
    }

    private void runSaveSubDlg() {
        this.runSubDialog(new GLMCommonSave(this));
    }

    private void runOptionsSubDlg() {
        this.runSubDialog(new GLMCommonOptions(this));
    }

    private void getSaveCheckMap() {
        this.mSavemap.put("IDS_PRE_UNSTANDARDIZED", "PRED");
        this.mSavemap.put("IDS_STANDARD_ERROR", "SEPRED");
        this.mSavemap.put("IDS_RES_UNSTANDARDIZED", "RESID");
        this.mSavemap.put("IDS_RES_STANDARDIZED", "ZRESID");
        this.mSavemap.put("IDS_STUDIENTIZED", "SRESID");
        this.mSavemap.put("IDS_DELETED", "DRESID");
        this.mSavemap.put("IDS_COOKS_DISTANCE", "COOK");
        this.mSavemap.put("IDS_LEVERAGE_VALUES", "LEVER");
    }

    private LinkedHashMap<String, String> getDisplayMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("IDS_DISCRIPTIVE_STATITICS", "DESCRIPTIVE");
        linkedHashMap.put("IDS_ESTIMATE_OF_EFFECT_SIZE", "ETASQ");
        linkedHashMap.put("IDS_OBSERVED_POWER", "OPOWER");
        linkedHashMap.put("IDS_UNIVARIATE_PARAMETER_ESTIMATES", "PARAMETER");
        linkedHashMap.put("IDS_MULTIVARIATE_SSCP_MATRICES", "TEST(SSCP)");
        linkedHashMap.put("IDS_MULTIVARIATE_RESIDUAL_SSCP_MAT", "RSSCP");
        linkedHashMap.put("IDS_MULTIVARIATE_TRANSFORM_MATRIX", "TEST(MMATRIX)");
        linkedHashMap.put("IDS_HOMOGENEITY_TESTS", "HOMOGENEITY");
        linkedHashMap.put("IDS_LACK_OF_FIT", "LOF");
        linkedHashMap.put("IDS_GENERAL_ESTIMABLE_FUNCTION", "GEF");
        return linkedHashMap;
    }

    public void validateDialogDataModel() {
        Object object;
        Object object2;
        Object object3;
        int n;
        Object object4;
        Object object5;
        Object object6;
        int n2;
        int n3;
        Object[] objectArray;
        String string = this.mFixFactorList.getVariablesStringList();
        String string2 = this.mCovarList.getVariablesStringList();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        stringTokenizer = new StringTokenizer(string2, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector2.add(stringTokenizer.nextToken());
        }
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Vector<String> vector3 = new Vector<String>();
        Object[] objectArray2 = dialogDataModel.getArray("IDS_OPTIONS_TARGET_LIST");
        if (objectArray2 != null) {
            boolean bl = true;
            objectArray = objectArray2;
            n3 = objectArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                object6 = objectArray[n2];
                String string3 = object6.toString();
                object5 = new StringTokenizer(string3, "*");
                int n4 = ((StringTokenizer)object5).countTokens();
                block3: for (int i = 0; i < n4; ++i) {
                    object4 = new StringTokenizer(((StringTokenizer)object5).nextToken(), "(");
                    int n5 = ((StringTokenizer)object4).countTokens();
                    for (n = 0; n < n5; ++n) {
                        object3 = ((StringTokenizer)object4).nextToken();
                        if (!((StringTokenizer)object4).hasMoreTokens()) {
                            object3 = ((String)object3).replace(")", "");
                            object3 = ((String)object3).trim();
                        }
                        if (vector.contains(object3) || ((String)object3).equals(OVERALL)) {
                            if (i >= n4 - 1) continue;
                            continue;
                        }
                        bl = false;
                        continue block3;
                    }
                }
                if (!bl) continue;
                vector3.add(string3);
            }
        }
        dialogDataModel.putArray("IDS_OPTIONS_TARGET_LIST", vector3.toArray());
        object5 = new Vector();
        object4 = dialogDataModel.getArray("IDS_REP_MEA_PLOT_TARGET_LIST");
        if (object4 != null) {
            for (Object object7 : object4) {
                String string4;
                object6 = object7.toString();
                object3 = new StringTokenizer((String)object6, "*");
                int n6 = ((StringTokenizer)object3).countTokens();
                for (n = 0; n < n6 && vector.contains(string4 = ((StringTokenizer)object3).nextToken()); ++n) {
                    if (n < n6 - 1) continue;
                    ((Vector)object5).add(object6);
                }
            }
        }
        dialogDataModel.putArray("IDS_REP_MEA_PLOT_TARGET_LIST", ((Vector)object5).toArray());
        object3 = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource((LocallyUniqueId)object3);
        Vector<Object> vector4 = new Vector<Object>();
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray("IDS_POSTHOC_TARGET_LIST");
        if (iSpssVariableArray != null) {
            objectArray = iSpssVariableArray;
            n3 = objectArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                object6 = objectArray[n2];
                if (!vector.contains(object6.getName())) continue;
                vector4.add(object6);
            }
        }
        int n7 = vector4.size();
        ISpssVariable[] iSpssVariableArray2 = new ISpssVariable[n7];
        for (n2 = 0; n2 < n7; ++n2) {
            iSpssVariableArray2[n2] = (ISpssVariable)vector4.get(n2);
        }
        dialogDataModel.putVarArray("IDS_POSTHOC_TARGET_LIST", iSpssVariableArray2);
        ISpssVariable[] iSpssVariableArray3 = dialogDataModel.getVarArray("IDS_SOURCE_LIST");
        boolean bl = iSpssVariableArray3 != null && iSpssVariableArray3.length > 0;
        ISpssVariable[] iSpssVariableArray4 = !bl ? null : new ISpssVariable[this.mFixFactorList.getModel().getSize()];
        HashMap<Integer, Object> hashMap = GLMCommonContrast.loadLuidKeyMap(dialogDataModel, "IDS_SOURCE_LIST", false);
        HashMap<Integer, Object> hashMap2 = new HashMap<Integer, Object>();
        if (bl) {
            int n8 = 0;
            for (int i = 0; i < iSpssVariableArray3.length; ++i) {
                object2 = iSpssVariableArray3[i];
                if (!(object2 instanceof ISpssVariable) || !vector.contains((object = object2).getName())) continue;
                iSpssVariableArray4[n8++] = object;
                hashMap2.put(object.getId().asInt(), hashMap.get(object.getId().asInt()));
            }
        }
        dialogDataModel.putVarArray("IDS_SOURCE_LIST", iSpssVariableArray4);
        GLMCommonContrast.saveLuidKeyMap(dialogDataModel, hashMap2, "IDS_SOURCE_LIST", null);
        object2 = new Vector();
        object = dialogDataModel.getArray(AbstractModelSubDialog.MODEL_TERMS_KEY);
        if (object != null) {
            boolean bl2 = true;
            for (Object object8 : object) {
                String string5 = object8.toString();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string5, "*");
                int n9 = stringTokenizer2.countTokens();
                block11: for (int i = 0; i < n9; ++i) {
                    StringTokenizer stringTokenizer3 = new StringTokenizer(stringTokenizer2.nextToken(), "(");
                    int n10 = stringTokenizer3.countTokens();
                    for (int j = 0; j < n10; ++j) {
                        String string6 = stringTokenizer3.nextToken();
                        if (!stringTokenizer3.hasMoreTokens()) {
                            string6 = string6.replace(")", "");
                            string6 = string6.trim();
                        }
                        if (vector.contains(string6) || vector2.contains(string6)) {
                            if (i >= n9 - 1) continue;
                            continue;
                        }
                        bl2 = false;
                        continue block11;
                    }
                }
                if (!bl2) continue;
                ((Vector)object2).add(string5);
            }
        }
        dialogDataModel.putArray(AbstractModelSubDialog.MODEL_TERMS_KEY, ((Vector)object2).toArray());
    }

    private void resetPostHocSubDialog() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        dialogDataModel.putVarArray("IDS_POSTHOC_TARGET_LIST", null);
        String[] stringArray = new String[]{"IDS_WALLER_DUNCAN", "IDS_GABRIEL", "IDS_HOCHBERGSGT2", "IDS_TURKEYSB", "IDS_SNK", "IDS_REGWQ", "IDS_REGWF", "IDS_SCHEFFE", "IDS_SIDAK", "IDS_BONFERRONI", "IDS_LSD", "IDS_TAMHANES_T2", "IDS_DUNNETTS_T3", "IDS_DUNNETTS_C", "IDS_GAMES_HOWELL", "IDS_TURKEY", "IDS_DUNCAN", "IDS_DUNNETT", "IDS_LTCONTROL", "IDS_GTCONTROL", "IDS_TWOSIDED"};
        for (int i = 0; i < stringArray.length; ++i) {
            dialogDataModel.putBoolean(stringArray[i], false);
            if (i != stringArray.length - 1) continue;
            dialogDataModel.putBoolean(stringArray[i], true);
        }
        dialogDataModel.putString("IDS_ERROR_RATIO_EDIT", "100");
        dialogDataModel.putInteger("IDS_CATEGORY_COMBO", 1);
    }

    private ArrayList<ISpssVariable> getValidVarsFromPostHocSubDialog(String string) {
        ISpssVariable[] iSpssVariableArray = this.getDialogDataModel().getVarArray(string);
        ISpssVariable[] iSpssVariableArray2 = this.getDialogDataModel().getVarArray(FIX_FACTOR_LIST);
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        if (iSpssVariableArray != null) {
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                boolean bl = false;
                for (ISpssVariable iSpssVariable2 : iSpssVariableArray2) {
                    if (!iSpssVariable2.getName().equals(iSpssVariable.getName())) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                arrayList.add(iSpssVariable);
            }
        }
        return arrayList;
    }

    public class Combinations {
        private Object[] objects;
        private int numInGroup;
        private int[] index;
        private boolean isDone = false;

        public Combinations() {
        }

        private Combinations(Object[] objectArray, int n) {
            this.objects = objectArray;
            this.numInGroup = n;
            this.index = new int[this.numInGroup];
            for (int i = 0; i < this.numInGroup; ++i) {
                this.index[i] = i;
            }
        }

        public boolean isDone() {
            return this.isDone;
        }

        private void moveIndex() {
            int n = this.indexBelowMax();
            if (n >= 0) {
                this.index[n] = this.index[n] + 1;
                for (int i = n + 1; i < this.numInGroup; ++i) {
                    this.index[i] = this.index[i - 1] + 1;
                }
            } else {
                this.isDone = true;
            }
        }

        public Object nextElement() {
            if (this.isDone) {
                return null;
            }
            Object[] objectArray = new Object[this.numInGroup];
            for (int i = 0; i < this.numInGroup; ++i) {
                objectArray[i] = this.objects[this.index[i]];
            }
            this.moveIndex();
            return objectArray;
        }

        private int indexBelowMax() {
            for (int i = this.numInGroup - 1; i >= 0; --i) {
                if (this.index[i] >= this.objects.length - this.numInGroup + i) continue;
                return i;
            }
            return -1;
        }

        public Vector<String> generateCombinations(Vector<String> vector) {
            Vector<String> vector2 = new Vector<String>();
            Object[] objectArray = vector.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Combinations combinations = new Combinations(objectArray, i + 1);
                while (!combinations.isDone()) {
                    Object[] objectArray2 = (Object[])combinations.nextElement();
                    StringBuffer stringBuffer = new StringBuffer("");
                    for (Object object : objectArray2) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append("*");
                        }
                        stringBuffer.append(object.toString());
                    }
                    vector2.add(stringBuffer.toString());
                }
            }
            return vector2;
        }
    }
}

