/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.multivariate;

import com.spss.java_client.ui.controls.SerializableList;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.adv_stats.multivariate.MultivariateDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;

public class MultivariateContrast
extends BaseSubDialog
implements ItemListener {
    static final String CHANGE_BUTTON = "IDS_MULTIVARIATE_CHANGE_BUTTON";
    static final String SRC_LIST = "IDS_SOURCE_LIST";
    static final String LAST_RADIO = "IDS_MULTIVARIATE_CONTRAST_LAST";
    static final String RADIO_FIRST = "IDS_MULTIVARIATE_CONTRAST_FIRST";
    static final String CONTRAST_COMBO = "IDS_CONTRAST_COMBO";
    private JLabel mRefCategorylabel;
    private JButton mChangeButton;
    private JComboBox mContrastCombo;
    private JScrollPane mFactorSrollPane;
    private JRadioButton mLastRadio;
    private JRadioButton mFirstRadio;
    private SpssButtonGroup mRadioGroup;
    private SerializableList mFactorList;

    public MultivariateContrast(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_MULTIVARIATE_CONTRASTS_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_GLMU_CON";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = this.mContrastCombo.getSelectedIndex() == 1 || this.mContrastCombo.getSelectedIndex() == 2;
        this.mRefCategorylabel.setEnabled(bl);
        this.mLastRadio.setEnabled(bl);
        this.mFirstRadio.setEnabled(bl);
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        this.mFactorList.setModel(this.getListModel());
        this.mFactorList.setSelectedIndex(0);
        this.mContrastCombo.setEnabled(this.mFactorList.getModel().getSize() > 0);
        this.mChangeButton.setEnabled(this.mFactorList.getModel().getSize() > 0);
    }

    @Override
    protected void init() {
        super.init();
        this.initVar();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupPlotPanel();
        JPanel jPanel3 = this.setupContrastPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, 0, 0, 0);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 2, 1, 1, n, insets);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    protected void initVar() {
        this.mFactorList = new SerializableList(SRC_LIST);
        this.mFactorSrollPane = new JScrollPane(this.mFactorList);
        this.mFactorList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mFactorList.getFixedCellHeight() * 5 + 2));
        this.mFactorSrollPane.setPreferredSize(this.mFactorList.getMinimumSize());
        this.mRefCategorylabel = new JLabel(this.getResString("IDS_MULTIVARIATE_REFERENCE_CATEGORY"));
        this.mRefCategorylabel.setEnabled(false);
        ControlAction controlAction = new ToggleButtonAction(this, LAST_RADIO);
        this.mLastRadio = new JRadioButton(controlAction);
        this.mLastRadio.setSelected(true);
        this.mLastRadio.setEnabled(false);
        controlAction = new ToggleButtonAction(this, RADIO_FIRST);
        this.mFirstRadio = new JRadioButton(controlAction);
        this.mFirstRadio.setEnabled(false);
        this.mRadioGroup = new SpssButtonGroup();
        this.mRadioGroup.add(this.mLastRadio);
        this.mRadioGroup.add(this.mFirstRadio);
        controlAction = new ComboboxAction(this, CONTRAST_COMBO);
        this.mContrastCombo = new JComboBox<String>(this.getResStringArray("IDS_MULTIVARIATE_CONTRAST_COMBO"));
        this.mContrastCombo.setAction(controlAction);
        this.mContrastCombo.addItemListener(this);
        controlAction = new ToggleButtonAction(this, CHANGE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultivariateContrast.this.changeListData();
            }
        };
        this.mChangeButton = new JButton(controlAction);
        this.mChangeButton.addItemListener(this);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mFactorList);
        vector.add(this.mContrastCombo);
        vector.add(this.mRadioGroup);
        vector.add(this.mChangeButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void changeListData() {
        String string = this.mContrastCombo.getSelectedItem().toString();
        if (this.mFirstRadio.isEnabled() && this.mFirstRadio.isSelected()) {
            string = string + "(" + this.mFirstRadio.getText().toLowerCase() + ")";
        }
        Object[] objectArray = this.mFactorList.getSelectedValues();
        int[] nArray = this.mFactorList.getSelectedIndices();
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = objectArray[i].toString();
            int n = string2.indexOf(40);
            String string3 = string2.substring(n + 1, string2.length() - 1);
            string2 = string2.replace(string3, string);
            ((DefaultListModel)this.mFactorList.getModel()).setElementAt(string2, nArray[i]);
        }
    }

    private ListModel getListModel() {
        DefaultListModel defaultListModel = (DefaultListModel)this.mFactorList.getModel();
        String string = ((MultivariateDlg)this.mParentDlg).getFixedFactorList();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (this.hasItem(string2)) continue;
            defaultListModel.addElement(string2 + "(None)");
        }
        return defaultListModel;
    }

    private boolean hasItem(String string) {
        boolean bl = false;
        DefaultListModel defaultListModel = (DefaultListModel)this.mFactorList.getModel();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            String string2 = defaultListModel.get(i).toString();
            if (!string.equals(string2.substring(0, string2.indexOf(40)))) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private JPanel setupPlotPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(this.getResString("IDS_MULTIVARIATE_CONTRAST_FACTORS"));
        jLabel.setDisplayedMnemonic(this.getDlgAccessKey("IDK_MULTIVARIATE_CONTRAST_FACTORS_KEY"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mFactorSrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setupContrastPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_MULTIVARIATE_CHANGE_CONTRASTS"));
        jPanel.setBorder(titledBorder);
        JLabel jLabel = new JLabel(this.getResString("IDS_MULTIVARIATE_CONTRAST"));
        jLabel.setDisplayedMnemonic(this.getDlgAccessKey("IDK_MULTIVARIATE_CONTRAST_KEY"));
        jLabel.setLabelFor(this.mContrastCombo);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 10;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(insets.top, n2, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mContrastCombo, gridBagConstraints, 1, 0, 2, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mChangeButton, gridBagConstraints, 3, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        Insets insets3 = new Insets(n2 / 2, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mRefCategorylabel, gridBagConstraints, 0, 1, 2, 0, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mLastRadio, gridBagConstraints, 2, 1, 1, 0, n, insets2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mFirstRadio, gridBagConstraints, 3, 1, 1, 0, n, insets2);
        return jPanel;
    }
}

