/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.mixed_models;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssCovariateVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssFactorVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.ModelTermsList;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.adv_stats.mixed_models.MixedModelMainDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MixedModelRandom
extends BaseSubDialog
implements ActionListener,
ItemListener,
ListSelectionListener,
ListDataListener {
    static final String RANDOM_TARGET_LIST_KEY = "RANDOM_TARGET_LIST_KEY";
    static final String RANDOM_SUBJECT_LIST_KEY = "RANDOM_SUBJECT_LIST_KEY";
    static final int MAX_NUMBER_OF_EFFECTS = 8;
    static final String RAND_MODEL_LIST_ITEMS_KEY = "RAND_MODEL_LIST_ITEMS_KEY_";
    static final String MODEL_LAYER_KEY = "RAND_MODEL_LAYER_KEY_";
    static final String COMBINATION_LAYER_KEY = "RAND_COMBINATION_LAYER_KEY_";
    static final String COVARIANCE_TYPE_LAYER_KEY = "RAND_COVARIANCE_TYPE_LAYER_KEY_";
    static final String INCLUDE_INTERCEPT_LAYER_KEY = "RAND_INCLUDE_INTERCEPT_LAYER_KEY_";
    static final String DISPLAY_PARAM_LAYER_KEY = "RAND_DISPLAY_PARAM_LAYER_KEY_";
    static boolean IS_MODEL_EMPTY = true;
    static final String COVARIANCE_COMBO = "IDS_RANDOM_COVARIANCE_TYPE";
    private static final String FACT_COV_SUBJ_LIST_VAR_KEY = "RAND_VAR_IDS";
    private static final String RANDOM_BUILD_TERMS_RADIO_KEY = "IDS_RANDOM_BUILD_TERMS";
    private static final String RANDOM_BUILD_NESTED_TERMS_RADIO_KEY = "IDS_RANDOM_BUILD_NESTED_TERMS";
    private static final String RANDOM_INCLUDE_INTERCEPT_CHECK_KEY = "IDS_RANDOM_INCLUDE_INTERCEPTS";
    private static final String DISPLAY_PARAMETER_CHECK = "IDS_RANDOM_DISPLAY_PARAMETER";
    private static final String DISPLAY_PARAMETER_CHECK_KEY = "IDS_RANDOM_DISPLAY_PARAMETER_KEY";
    private static final String RANDOM_BY_BUTTON_KEY = "IDS_RANDOM_BY_BUTTON";
    private static final String RANDOM_WITH_IN_BUTTON_KEY = "IDS_RANDOM_WITH_IN_BUTTON";
    private static final String RANDOM_CLEAR_TERM_BUTTON_KEY = "IDS_RANDOM_CLEAR_TERM_BUTTON";
    private static final String RANDOM_ADD_BUTTON_KEY = "IDS_RANDOM_ADD_BUTTON";
    private static final String RANDOM_REMOVE_BUTTON_KEY = "IDS_RANDOM_REMOVE_BUTTON";
    private static final String RANDOM_NEXT_BUTTON_KEY = "IDS_RANDOM_NEXT_BUTTON";
    private static final String RANDOM_PREVIOUS_BUTTON_KEY = "IDS_RANDOM_PREVIOUS_BUTTON";
    private static final String CURRENT_LAYER_KEY = "RAND_CURRENT_LAYER_KEY";
    private static final String COMBO_BOX_KEY = "RAND_COMBO_BOX_KEY";
    private static final String WITHIN_TEXT_STRING = "()";
    private static final String BY_TEXT_STRING = "*";
    private TargetVariableList mSrcVarList;
    private SrcVariableList mSubjectList;
    private ModelTermsList mModelList;
    private TargetVariableList mCombinationList;
    private JComboBox mBuildTermCombo;
    private JComboBox mCovarianceCombo;
    private JRadioButton mBuildNestedRadio;
    private JRadioButton mBuildTermRadio;
    private JCheckBox mIncludeIntercept;
    private ArrowButton mArrowButton;
    private ArrowButton mSubjectArrowButton;
    private JButton mByButton;
    private JButton mWithInButton;
    private JButton mClearTermButton;
    private JButton mAddButton;
    private JButton mRemoveButton;
    private JButton mNextButton;
    private JButton mPreviousButton;
    private JLabel mBuildTermLabel;
    private JTextArea mBuildTermText;
    private JPanel mByWithinPanel;
    private Vector<Object> mTabOrder;
    private HashMap<Integer, Set<String>> mModelVariables;
    private StringBuffer mCurrentCombination;
    private int mCurrentEffect;
    private Map<Integer, Layer> mLayers;
    private SpssButtonGroup mButtonGroup;
    private int mInsertPos;
    private JCheckBox mDisplayParam;

    public MixedModelRandom(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_MIXED_MODEL_RANDOM_EFFECTS_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_mixl_rand";
    }

    @Override
    public boolean continuePressed() {
        int n;
        boolean bl = super.continuePressed();
        this.saveCurrentState();
        DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
        this.saveState(dialogDataModel);
        if (this.isSameVarInDiffLayers()) {
            return false;
        }
        if (this.isInterceptOnTwoLayers()) {
            return false;
        }
        this.saveVariables();
        Object object = this.mLayers.values().iterator();
        while (object.hasNext()) {
            Layer layer = object.next();
            if (layer != null && (layer.isIntercept() || layer.getModelItems().size() > 0)) {
                IS_MODEL_EMPTY = false;
                break;
            }
            IS_MODEL_EMPTY = true;
        }
        if (bl && (n = ((String)(object = this.mBuildTermText.getText().trim())).length()) > 0) {
            int n2 = ((String)object).charAt(n - 1) == '*' || ((String)object).contains(WITHIN_TEXT_STRING) ? SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_INCOMPLETE_EFFECT_MSG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION) : SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_EFFECT_NOT_ADDED_MSG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION);
            boolean bl2 = bl = n2 != 1;
            if (!bl) {
                this.mSrcVarList.requestFocus();
            }
            return bl;
        }
        return bl;
    }

    boolean isSameVarInDiffLayers() {
        for (int i = 1; i <= 8; ++i) {
            Set<String> set;
            for (int j = i + 1; j <= 8 && (set = this.mModelVariables.get(i)) != null; ++j) {
                Set<String> set2 = this.mModelVariables.get(j);
                if (set2 == null) continue;
                for (String string : set) {
                    for (String string2 : set2) {
                        if (!string.equals(string2) && !this.isEqualIgnoringOrder(string, string2)) continue;
                        String string3 = string.substring(string.lastIndexOf(36) + 1);
                        String string4 = MessageFormat.format(this.getResString("ERR_DUPLICATE_RANDOM_MSG1"), string3, i, j);
                        SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), string4, VersionInfo.getAppVersionString());
                        return true;
                    }
                }
            }
        }
        return false;
    }

    boolean isInterceptOnTwoLayers() {
        boolean bl = false;
        ArrayList<Layer> arrayList = new ArrayList<Layer>(this.mLayers.values());
        Iterator<Layer> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Layer layer = iterator.next();
            if (layer != null && layer.isIntercept()) continue;
            iterator.remove();
        }
        if (arrayList.size() > 1) {
            block1: for (Layer layer : arrayList) {
                if (bl) break;
                List<ISpssVariable> list = layer.getCombinationItems();
                List<Layer> list2 = arrayList.subList(arrayList.indexOf(layer) + 1, arrayList.size());
                for (Layer layer2 : list2) {
                    boolean bl2;
                    if (bl) continue block1;
                    List<ISpssVariable> list3 = layer2.getCombinationItems();
                    if (list.size() != list3.size() || !(bl2 = list.size() == 0 && list3.size() == 0 || list.equals(list3))) continue;
                    bl = true;
                    MatchingLayers matchingLayers = this.findMatchingLayers(layer, layer2);
                    String string = MessageFormat.format(this.getResString("ERR_DUPLICATE_INTERCEPT"), matchingLayers.layer1, matchingLayers.layer2);
                    SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
                }
            }
        }
        return bl;
    }

    private MatchingLayers findMatchingLayers(Layer layer, Layer layer2) {
        MatchingLayers matchingLayers = new MatchingLayers();
        Iterator<Map.Entry<Integer, Layer>> iterator = this.mLayers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Layer> entry;
            List<ISpssVariable> list;
            Map.Entry<Integer, Layer> entry2 = iterator.next();
            List<ISpssVariable> list2 = entry2.getValue().getCombinationItems();
            if (!list2.equals(list = layer.getCombinationItems())) continue;
            matchingLayers.layer1 = entry2.getKey();
            while (iterator.hasNext()) {
                List<ISpssVariable> list3;
                entry = iterator.next();
                List<ISpssVariable> list4 = entry.getValue().getCombinationItems();
                if (!list4.equals(list3 = layer2.getCombinationItems())) continue;
                matchingLayers.layer2 = (Integer)entry.getKey();
                break;
            }
            if (matchingLayers.layer1 <= matchingLayers.layer2) break;
            entry = matchingLayers.layer1;
            matchingLayers.layer1 = matchingLayers.layer2;
            matchingLayers.layer2 = entry;
            break;
        }
        return matchingLayers;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mArrowButton) {
            this.arrowButtonAction();
        } else if (object == this.mIncludeIntercept) {
            this.updateNextButton();
        }
    }

    private void updateNextButton() {
        boolean bl = this.mModelList.getModel().getSize() > 0;
        boolean bl2 = this.mIncludeIntercept.isSelected();
        boolean bl3 = this.mCombinationList.getModel().getSize() > 0;
        boolean bl4 = bl2 && bl3;
        boolean bl5 = this.mLayers.get(this.mCurrentEffect + 1) != null;
        this.mNextButton.setEnabled((bl4 || bl || bl5) && this.mCurrentEffect < 8);
    }

    private void arrowButtonAction() {
        boolean bl = false;
        SpssVariable spssVariable = (SpssVariable)this.mSrcVarList.getSelectedValue();
        if (spssVariable instanceof SpssFactorVariable) {
            bl = true;
        } else if (spssVariable instanceof SpssCovariateVariable) {
            bl = false;
        }
        if (this.mSrcVarList.getSelectedIndices().length > 1) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_SINGLE_VAR_MSG"), VersionInfo.getAppVersionString());
        } else if (this.mBuildTermText.getText().endsWith(")") && !bl) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_COVARIATE_EFFECT_NOT_NESTED_MSG"), VersionInfo.getAppVersionString());
        } else if (bl && this.mBuildTermText.getText().contains(((ISpssVariable)this.mSrcVarList.getSelectedValue()).getName())) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_UNIQUE_FACTORS_MSG"), VersionInfo.getAppVersionString());
        } else {
            this.mModelList.clearSelection();
            this.mBuildTermText.insert(((ISpssVariable)this.mSrcVarList.getSelectedValue()).getName(), this.mInsertPos);
            this.mInsertPos += ((ISpssVariable)this.mSrcVarList.getSelectedValue()).getName().length();
            this.enableLowerComponents(true);
            this.mArrowButton.setEnabled(false);
            this.mAddButton.setEnabled(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = this.mBuildTermRadio.isSelected();
        this.enableLowerComponents(!bl);
        boolean bl2 = this.mWithInButton.isEnabled();
        if (this.mSrcVarList.getSelectedIndices().length >= 1) {
            if (!bl2) {
                this.mArrowButton.setEnabled(!bl);
                this.mAddButton.setEnabled(bl);
            }
        } else {
            this.mArrowButton.setEnabled(false);
            this.mAddButton.setEnabled(false);
            this.enableLowerComponents(false);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MixedModelRandom.this.mModelList.getSelectedIndices().length >= 1) {
                    MixedModelRandom.this.mRemoveButton.setEnabled(true);
                } else {
                    MixedModelRandom.this.mRemoveButton.setEnabled(false);
                }
            }
        });
        this.mBuildTermCombo.setEnabled(bl);
        this.mBuildTermText.setEnabled(!bl);
        this.mBuildTermLabel.setEnabled(!bl);
        if (!bl && this.mBuildTermText.getText().length() > 0) {
            this.mClearTermButton.setEnabled(true);
        } else {
            this.mClearTermButton.setEnabled(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl;
        if (listSelectionEvent.getSource() == this.mSrcVarList) {
            boolean bl2;
            bl = this.mBuildTermRadio.isSelected();
            boolean bl3 = bl2 = this.mWithInButton.isEnabled() && this.mByButton.isEnabled();
            if (this.mSrcVarList.getSelectedIndices().length >= 1) {
                if (!bl2) {
                    this.mAddButton.setEnabled(bl);
                    this.mArrowButton.setEnabled(!bl);
                }
            } else {
                this.mAddButton.setEnabled(false);
                this.enableLowerComponents(false);
            }
        }
        if (listSelectionEvent.getSource() == this.mModelList) {
            bl = this.mModelList.getSelectedIndices().length >= 1;
            this.mRemoveButton.setEnabled(bl);
        }
        if (this.mBuildTermRadio.isSelected()) {
            bl = this.mModelList.getSelectedIndices().length >= 1;
            this.mRemoveButton.setEnabled(bl);
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (this.mModelList.getModel().getSize() > 0) {
            this.mRemoveButton.setEnabled(true);
        }
        if (listDataEvent.getSource() == this.mCombinationList.getModel()) {
            this.updateCombination();
        }
        this.updateNextButton();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mCombinationList.getModel()) {
            this.updateCombination();
        }
        this.updateNextButton();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mCombinationList.getModel()) {
            this.updateCombination();
        }
        this.updateNextButton();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.mBuildTermRadio.setSelected(true);
        this.mAddButton.setEnabled(false);
        this.mRemoveButton.setEnabled(false);
        this.enableLowerComponents(false);
        this.pack();
        this.setTabPolicy();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        Object object;
        boolean bl = super.saveState(dialogDataModel);
        if (bl) {
            this.saveCurrentState();
            dialogDataModel.putInteger(CURRENT_LAYER_KEY, this.mCurrentEffect);
            dialogDataModel.putObject(RAND_MODEL_LIST_ITEMS_KEY, this.mModelVariables);
            for (int i = 1; i <= 8; ++i) {
                object = this.mLayers.get(i);
                if (null != object && (((Layer)object).getModelItems().size() != 0 || ((Layer)object).getCombinationItems().size() != 0)) {
                    if (((Layer)object).getModelItems().size() != 0) {
                        dialogDataModel.putArray(MODEL_LAYER_KEY + i, ((Layer)object).getModelItems().toArray());
                    } else {
                        dialogDataModel.putArray(MODEL_LAYER_KEY + i, new Object[0]);
                    }
                    if (((Layer)object).getCombinationItems().size() != 0) {
                        List<ISpssVariable> list = ((Layer)object).getCombinationItems();
                        ISpssVariable[] iSpssVariableArray = new ISpssVariable[list.size()];
                        dialogDataModel.putVarArray(COMBINATION_LAYER_KEY + i, list.toArray(iSpssVariableArray));
                    } else {
                        dialogDataModel.putVarArray(COMBINATION_LAYER_KEY + i, new ISpssVariable[0]);
                    }
                    dialogDataModel.putInteger(COVARIANCE_TYPE_LAYER_KEY + i, ((Layer)object).getCovarianceType());
                    dialogDataModel.putBoolean(INCLUDE_INTERCEPT_LAYER_KEY + i, ((Layer)object).isIntercept());
                    dialogDataModel.putBoolean(DISPLAY_PARAM_LAYER_KEY + i, ((Layer)object).isDisplayParam());
                    continue;
                }
                dialogDataModel.putBoolean(INCLUDE_INTERCEPT_LAYER_KEY + i, object == null ? null : Boolean.valueOf(((Layer)object).isIntercept()));
                dialogDataModel.putInteger(COVARIANCE_TYPE_LAYER_KEY + i, object == null ? null : Integer.valueOf(((Layer)object).getCovarianceType()));
                dialogDataModel.putBoolean(DISPLAY_PARAM_LAYER_KEY + i, object == null ? null : Boolean.valueOf(((Layer)object).isDisplayParam()));
                dialogDataModel.putArray(MODEL_LAYER_KEY + i, new Object[0]);
            }
            dialogDataModel.putInteger(COMBO_BOX_KEY, this.mBuildTermCombo.getSelectedIndex());
        }
        dialogDataModel.putArray(RANDOM_TARGET_LIST_KEY, this.getTargetListElement().toArray());
        ArrayList<ISpssVariable> arrayList = this.getSubjectListElement();
        object = new ISpssVariable[arrayList.size()];
        dialogDataModel.putVarArray(RANDOM_SUBJECT_LIST_KEY, arrayList.toArray((T[])object));
        return bl;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        Integer n;
        Object object;
        super.loadState(dialogDataModel);
        VariableList variableList = ((MixedModelMainDlg)this.mParentDlg).getFactorsList();
        VariableList variableList2 = ((MixedModelMainDlg)this.mParentDlg).getCovariatesList();
        VarListModel varListModel = variableList.getModel();
        VarListModel varListModel2 = this.mSrcVarList.getModel();
        varListModel2.removeAll();
        int n2 = varListModel.getSize();
        for (int i = 0; i < n2; ++i) {
            varListModel2.addElement((ISpssVariable)new SpssFactorVariable((SpssVariable)varListModel.getElementAt(i)));
        }
        VarListModel varListModel3 = variableList2.getModel();
        n2 = varListModel3.getSize();
        for (int i = 0; i < n2; ++i) {
            varListModel2.addElement((ISpssVariable)new SpssCovariateVariable((SpssVariable)varListModel3.getElementAt(i)));
        }
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        DialogDataModel dialogDataModel2 = new DialogDataModel();
        ProcedureDlgMgr.getMgr().loadPersistentState("analyze_mixed_linear", dialogDataModel2);
        ISpssVariable[] iSpssVariableArray = dialogDataModel2.getVarArray("SUBJECT_VARIABLE_LIST_KEY");
        VarListModel varListModel4 = this.mSubjectList.getModel();
        varListModel4.removeAll();
        if (null != iSpssVariableArray) {
            for (ISpssVariable object2 : iSpssVariableArray) {
                int n3 = iSpssDataSrc.findVarIndex(object2.getId());
                if (n3 == -1) continue;
                object = iSpssDataSrc.getVariable(n3);
                varListModel4.addElement((ISpssVariable)object);
            }
        }
        this.mCurrentEffect = null == dialogDataModel.getInteger(CURRENT_LAYER_KEY) ? 1 : dialogDataModel.getInteger(CURRENT_LAYER_KEY);
        for (int i = 1; i <= 8; ++i) {
            Boolean bl = dialogDataModel.getBoolean(INCLUDE_INTERCEPT_LAYER_KEY + i);
            Integer n4 = dialogDataModel.getInteger(COVARIANCE_TYPE_LAYER_KEY + i);
            Boolean bl2 = dialogDataModel.getBoolean(DISPLAY_PARAM_LAYER_KEY + i);
            object = new Layer();
            if (null == bl) continue;
            ((Layer)object).setIntercept(bl);
            ((Layer)object).setDisplayParam(bl2);
            ISpssVariable[] iSpssVariableArray2 = dialogDataModel.getVarArray(COMBINATION_LAYER_KEY + i);
            LinkedList<ISpssVariable> linkedList = new LinkedList<ISpssVariable>();
            linkedList.addAll(Arrays.asList(iSpssVariableArray2));
            ((Layer)object).setCombinationItems(linkedList);
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            linkedHashSet.addAll(Arrays.asList(dialogDataModel.getArray(MODEL_LAYER_KEY + i)));
            ((Layer)object).setModelItems(linkedHashSet);
            if (n4 != null) {
                ((Layer)object).setCovarianceType(n4);
            }
            this.mLayers.put(i, (Layer)object);
        }
        Object object3 = dialogDataModel.getObject(RAND_MODEL_LIST_ITEMS_KEY);
        if (object3 != null) {
            this.mModelVariables = (HashMap)object3;
        }
        if ((n = dialogDataModel.getInteger(COMBO_BOX_KEY)) != null) {
            this.mBuildTermCombo.setSelectedIndex(n);
        }
        this.validateDialogDataModel();
        this.loadCurrentState();
    }

    private ArrayList<String> getTargetListElement() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.mSrcVarList.getModel().getSize(); ++i) {
            arrayList.add(this.mSrcVarList.getModel().getElementAt(i).getName());
        }
        return arrayList;
    }

    private ArrayList<ISpssVariable> getSubjectListElement() {
        ArrayList<ISpssVariable> arrayList = new ArrayList<ISpssVariable>();
        for (int i = 0; i < this.mSubjectList.getModel().getSize(); ++i) {
            arrayList.add(this.mSubjectList.getModel().getElementAt(i));
        }
        return arrayList;
    }

    private void initVars() {
        this.mBuildTermRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, RANDOM_BUILD_TERMS_RADIO_KEY));
        this.mBuildNestedRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, RANDOM_BUILD_NESTED_TERMS_RADIO_KEY));
        this.mSrcVarList = new TargetVariableList();
        this.mSrcVarList.setLoadFromPersistent(false);
        this.mSrcVarList.setShowVarLabels(false, false);
        this.mModelList = new ModelTermsList(MODEL_LAYER_KEY);
        this.mModelList.setSerializable(false);
        String[] stringArray = new String[]{this.getResString("IDS_MIXED_MODEL_FACTORIAL"), this.getResString("IDS_MIXED_MODEL_MAIN_EFFECTS"), this.getResString("IDS_MIXED_MODEL_INTERACTION"), this.getResString("IDS_MIXED_MODEL_2_WAY"), this.getResString("IDS_MIXED_MODEL_3_WAY"), this.getResString("IDS_MIXED_MODEL_4_WAY"), this.getResString("IDS_MIXED_MODEL_5_WAY")};
        this.mBuildTermCombo = new JComboBox<String>(stringArray);
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.down);
        this.mByButton = new JButton(new ByAction(this, RANDOM_BY_BUTTON_KEY));
        this.mWithInButton = new JButton(new WithInAction(this, RANDOM_WITH_IN_BUTTON_KEY));
        this.mClearTermButton = new JButton(new ClearAction(this, RANDOM_CLEAR_TERM_BUTTON_KEY));
        this.mAddButton = new JButton(new AddAction(this, RANDOM_ADD_BUTTON_KEY));
        this.mRemoveButton = new JButton(new RemoveAction(this, RANDOM_REMOVE_BUTTON_KEY));
        this.mBuildTermLabel = new JLabel(this.getResString("IDS_BUILD_TERMS_LABEL"));
        this.mBuildTermText = new JTextArea();
        this.mInsertPos = 0;
        this.mIncludeIntercept = new JCheckBox(new ToggleButtonAction(this, RANDOM_INCLUDE_INTERCEPT_CHECK_KEY));
        this.mIncludeIntercept.addActionListener(this);
        this.mSubjectList = new SrcVariableList(VariableList.VarMoveType.eKeepOriginal);
        this.mCombinationList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mCombinationList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mCombinationList.setAllowDuplicates(true);
        this.mCombinationList.setLoadFromPersistent(false);
        this.mSrcVarList.setLoadFromPersistent(false);
        this.mPreviousButton = new JButton(new PreviousAction(this, RANDOM_PREVIOUS_BUTTON_KEY));
        this.mNextButton = new JButton(new NextAction(this, RANDOM_NEXT_BUTTON_KEY));
        VersionInfo versionInfo = new VersionInfo();
        String[] stringArray2 = new String[]{this.getResString("IDS_VARIANCE_COMPONENTS"), this.getResString("IDS_ANTE_DEP"), this.getResString("IDS_AR_1"), this.getResString("IDS_AR_1_HETR"), this.getResString("IDS_ARMA_1_1"), this.getResString("IDS_COMP_SYM"), this.getResString("IDS_COMP_SYM_COR_METX"), this.getResString("IDS_COMP_SYM_HETR"), this.getResString("IDS_DIAGONAL"), this.getResString("IDS_FACTOR_ANA_FIRST_ORDER"), this.getResString("IDS_FACTOR_ANA_FIRST_ORDER_HETR"), this.getResString("IDS_HUYNCH"), this.getResString("IDS_SCALED_IDENTITY"), this.getResString("IDS_TOEPLITZ"), this.getResString("IDS_TOEPLITZ_HETR"), this.getResString("IDS_UNSTRUCTURED"), this.getResString("IDS_UNSTRUCTURED_COR_METX")};
        ComboboxAction comboboxAction = new ComboboxAction(this, COVARIANCE_COMBO);
        this.mCovarianceCombo = new JComboBox<String>(stringArray2);
        this.mCovarianceCombo.setAction(comboboxAction);
        this.mCovarianceCombo.addItemListener(this);
        this.mCovarianceCombo.setSelectedItem(this.getResString("IDS_VARIABLE_COMPONENTS"));
        int n = DialogUtil.getVarListHeight();
        int n2 = (int)((double)n * 0.8);
        int n3 = (int)((double)n * 0.6);
        int n4 = DialogUtil.getVarListWidth();
        this.mSrcVarList.setMinimumSize(new Dimension(n4, n2));
        this.mSubjectList.setMinimumSize(new Dimension(n4, n3));
        this.mModelList.setMinimumSize(new Dimension(n4 * 2, n2));
        this.mCombinationList.setMinimumSize(new Dimension(n4 * 2, n3));
        this.mByWithinPanel = new JPanel(new GridBagLayout());
        Dimension dimension = this.mWithInButton.getMinimumSize();
        Dimension dimension2 = this.mByButton.getMinimumSize();
        dimension = dimension.width > dimension2.width ? dimension : dimension2;
        this.mWithInButton.setPreferredSize(dimension);
        this.mWithInButton.setMinimumSize(dimension);
        this.mByButton.setPreferredSize(dimension);
        this.mByButton.setMinimumSize(dimension);
        Dimension dimension3 = this.mAddButton.getMinimumSize();
        Dimension dimension4 = this.mRemoveButton.getMinimumSize();
        dimension3 = dimension3.width > dimension4.width ? dimension3 : dimension4;
        this.mAddButton.setPreferredSize(dimension3);
        this.mAddButton.setMinimumSize(dimension3);
        this.mRemoveButton.setPreferredSize(dimension3);
        this.mRemoveButton.setMinimumSize(dimension3);
        Dimension dimension5 = this.mPreviousButton.getMinimumSize();
        Dimension dimension6 = this.mNextButton.getMinimumSize();
        dimension5 = dimension5.width > dimension6.width ? dimension5 : dimension6;
        this.mPreviousButton.setPreferredSize(dimension5);
        this.mPreviousButton.setMinimumSize(dimension5);
        this.mNextButton.setPreferredSize(dimension5);
        this.mNextButton.setMinimumSize(dimension5);
        this.mTabOrder = new Vector();
        this.mModelVariables = new HashMap();
        this.mCurrentCombination = new StringBuffer();
        this.mLayers = new HashMap<Integer, Layer>();
        this.mCurrentEffect = 1;
        this.mDisplayParam = new JCheckBox(new ToggleButtonAction((BaseDialog)this, DISPLAY_PARAMETER_CHECK, DISPLAY_PARAMETER_CHECK_KEY));
        this.mDisplayParam.addActionListener(this);
    }

    private void setupViewPanel(JPanel jPanel) {
        this.setBorderTitleString();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        Insets insets = UIToolDialogUtil.getStandardDialogInsets();
        Insets insets2 = new Insets(0, insets.left * 3, 0, insets.right * 3);
        DialogUtil.addUsingGBL(jPanel, this.setupPrevNextPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.fill = 2;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_RANDOM_EFFECTS_BORDER");
        jLabel.setOpaque(true);
        DialogUtil.addUsingGBL(jPanel, this.setTitleOnSeparator(jLabel), gridBagConstraints, 0, 1, 1, 1, n, null);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setupRandomEffectsPanel(), gridBagConstraints, 0, 2, 1, 1, n, null);
    }

    private JPanel setTitleOnSeparator(JLabel jLabel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2 / 3, 0, 0);
        gridBagConstraints.fill = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(" ");
        jLabel.setOpaque(true);
        jLabel.setFont(titledBorder.getTitleFont());
        jLabel.setForeground(titledBorder.getTitleColor());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        Insets insets2 = new Insets(8, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, new JSeparator(), gridBagConstraints2, 0, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        jPanel.setComponentZOrder(jLabel, 0);
        return jPanel;
    }

    private JPanel setupPrevNextPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        JLabel jLabel = DialogUtil.createLabel(this, COVARIANCE_COMBO);
        jLabel.setLabelFor(this.mCovarianceCombo);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardButtonInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mPreviousButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, 21, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets2 = new Insets(insets.top, insets.left * 20, 0, insets.right * 4);
        DialogUtil.addUsingGBL(jPanel, this.mCovarianceCombo, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mNextButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupRandomEffectsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        this.mButtonGroup = new SpssButtonGroup();
        this.mButtonGroup.add(this.mBuildTermRadio);
        this.mButtonGroup.add(this.mBuildNestedRadio);
        this.mBuildTermRadio.addItemListener(this);
        this.mBuildNestedRadio.addItemListener(this);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_RANDOM_FACT_AND_COVAR");
        jLabel.setLabelFor(this.mSrcVarList);
        this.mSrcVarList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mSrcVarList.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        jScrollPane.setMinimumSize(this.mSrcVarList.getMinimumSize());
        jScrollPane.setVerticalScrollBarPolicy(20);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_RANDOM_MODEL");
        jLabel2.setLabelFor(this.mModelList);
        this.mModelList.addListSelectionListener(this);
        this.mModelList.getModel().addListDataListener(this);
        JScrollPane jScrollPane2 = new JScrollPane(this.mModelList);
        jScrollPane2.setPreferredSize(this.mModelList.getMinimumSize());
        this.mArrowButton.addActionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardButtonInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mBuildTermRadio, gridBagConstraints, 0, 0, 3, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mBuildNestedRadio, gridBagConstraints, 3, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mIncludeIntercept, gridBagConstraints, 5, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 3, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets2 = new Insets(insets.top, insets.left, insets.top * 3, insets.right);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 2, 3, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mBuildTermCombo, gridBagConstraints, 3, 2, 1, 1, 10, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 4, 1, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 4, 2, 2, 1, n, insets2);
        Dimension dimension = this.mArrowButton.getPreferredSize();
        dimension.height = this.mByButton.getPreferredSize().height;
        this.mArrowButton.setPreferredSize(dimension);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mByWithinPanel, this.mArrowButton, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(this.mByWithinPanel, this.mByButton, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(this.mByWithinPanel, this.mWithInButton, gridBagConstraints, 2, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mByWithinPanel, gridBagConstraints, 0, 3, 1, 1, n, null);
        Insets insets3 = new Insets(insets2.top, insets2.left * 8, insets2.top, insets2.left * 8);
        n = 19;
        DialogUtil.addUsingGBL(jPanel, this.mClearTermButton, gridBagConstraints, 3, 3, 1, 1, n, insets3);
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mAddButton, gridBagConstraints, 4, 3, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mRemoveButton, gridBagConstraints, 5, 3, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mBuildTermLabel, gridBagConstraints, 0, 4, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        jScrollPane = new JScrollPane(this.mBuildTermText);
        this.mBuildTermText.setEditable(false);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        this.mBuildTermText.setOpaque(false);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 5, 6, 1, n, insets2);
        Insets insets4 = new Insets(insets.top, 0, insets.bottom, 0);
        DialogUtil.addUsingGBL(jPanel, new JSeparator(), gridBagConstraints, 0, 6, 6, 1, n, insets4);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_RANDOM_SUBJECT_BORDER");
        DialogUtil.addUsingGBL(jPanel, this.setTitleOnSeparator(jLabel3), gridBagConstraints, 0, 7, 6, 1, n, insets4);
        this.mSubjectArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_RANDOM_SUBJECT_LABEL");
        jLabel4.setLabelFor(this.mSubjectList);
        JLabel jLabel5 = DialogUtil.createLabel(this, "IDS_RANDOM_COMBINATIONS_LABEL");
        jLabel5.setLabelFor(this.mCombinationList);
        this.mCombinationList.getModel().addListDataListener(this);
        gridBagConstraints = new GridBagConstraints();
        n = 23;
        Dimension dimension2 = this.mSubjectList.getMinimumSize();
        dimension2.width = this.mByWithinPanel.getPreferredSize().width;
        this.mSubjectList.setMinimumSize(dimension2);
        JScrollPane jScrollPane3 = new JScrollPane(this.mSubjectList);
        jScrollPane3.setPreferredSize(this.mSubjectList.getMinimumSize());
        jScrollPane3.setMinimumSize(this.mSubjectList.getMinimumSize());
        jScrollPane3.setVerticalScrollBarPolicy(20);
        jScrollPane3.setHorizontalScrollBarPolicy(31);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, jLabel4, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel2, jScrollPane3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 8, 3, 1, n, null);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        this.mSubjectArrowButton = new ArrowButton();
        DialogUtil.addUsingGBL(jPanel3, this.mSubjectArrowButton, gridBagConstraints, 0, 1, 1, 1, 10, DialogUtil.getArrowButtonInsets());
        DialogUtil.addUsingGBL(jPanel3, jLabel5, gridBagConstraints, 1, 0, 1, 1, n, insets);
        jScrollPane3 = new JScrollPane(this.mCombinationList);
        jScrollPane3.setPreferredSize(this.mCombinationList.getMinimumSize());
        jScrollPane3.setVerticalScrollBarPolicy(20);
        jScrollPane3.setHorizontalScrollBarPolicy(30);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel3, jScrollPane3, gridBagConstraints, 1, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 3, 8, 3, 1, n, null);
        Insets insets5 = new Insets(insets.top * 4, 0, insets.bottom * 2, 0);
        DialogUtil.addUsingGBL(jPanel, new JSeparator(), gridBagConstraints, 0, 9, 6, 1, n, insets5);
        Insets insets6 = new Insets(insets.top * 6, insets.left, insets.top * 6, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mDisplayParam, gridBagConstraints, 0, 10, 6, 1, n, insets6);
        this.mSubjectArrowButton.registerVariableList(this.mSubjectList, SpssArrowButton.ButtonOrientation.right);
        this.mSubjectArrowButton.registerVariableList(this.mCombinationList, SpssArrowButton.ButtonOrientation.left);
        return jPanel;
    }

    private void setBorderTitleString() {
        int n = this.mCurrentEffect;
        int n2 = this.mLayers.size();
        for (Layer object2 : this.mLayers.values()) {
            if (!object2.isIntercept() || object2.getModelItems().size() != 0 || object2.getCombinationItems().size() != 0) continue;
            --n2;
        }
        if (n <= 0) {
            n = 1;
        }
        if (n2 <= 0) {
            n2 = 1;
        }
        if (n2 < n) {
            n2 = n;
        }
        Object object3 = this.getResString("IDS_RANDOM_UPPER_BORDER");
        object3 = MessageFormat.format((String)object3, Integer.toString(n), Integer.toString(n2));
        TitledBorder titledBorder = BorderFactory.createTitledBorder((String)object3);
        this.getViewPanel().setBorder(titledBorder);
        titledBorder.getBorderInsets(this.getViewPanel(), new Insets(0, 0, 0, 0));
    }

    private void enableLowerComponents(boolean bl) {
        String string = this.mBuildTermText.getText();
        if (bl && (string.length() == 0 || string.endsWith(BY_TEXT_STRING) || string.contains(WITHIN_TEXT_STRING))) {
            this.mArrowButton.setEnabled(true);
        } else {
            this.mArrowButton.setEnabled(false);
        }
        if (bl && string.length() > 0 && !string.endsWith(BY_TEXT_STRING) && !string.contains(WITHIN_TEXT_STRING)) {
            this.mByButton.setEnabled(true);
            this.mWithInButton.setEnabled(true);
        } else {
            this.mByButton.setEnabled(false);
            this.mWithInButton.setEnabled(false);
        }
        if (bl && string.length() > 0) {
            this.mClearTermButton.setEnabled(true);
        } else {
            this.mClearTermButton.setEnabled(false);
        }
    }

    private void enablePreviousNext(boolean bl, boolean bl2) {
        this.mPreviousButton.setEnabled(bl);
        this.mNextButton.setEnabled(bl2);
    }

    private void setTabPolicy() {
        this.mTabOrder.add(this.mPreviousButton);
        this.mTabOrder.add(this.mNextButton);
        this.mTabOrder.add(this.mCovarianceCombo);
        this.mTabOrder.add(this.mButtonGroup);
        this.mTabOrder.add(this.mIncludeIntercept);
        this.mTabOrder.add(this.mSrcVarList);
        this.mTabOrder.add(this.mArrowButton);
        this.mTabOrder.add(this.mByButton);
        this.mTabOrder.add(this.mWithInButton);
        this.mTabOrder.add(this.mClearTermButton);
        this.mTabOrder.add(this.mBuildTermCombo);
        this.mTabOrder.add(this.mAddButton);
        this.mTabOrder.add(this.mModelList);
        this.mTabOrder.add(this.mRemoveButton);
        this.mTabOrder.add(this.mSubjectList);
        this.mTabOrder.add(this.mSubjectArrowButton);
        this.mTabOrder.add(this.mCombinationList);
        this.mTabOrder.add(this.mDisplayParam);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.mTabOrder.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mTabOrder, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private int[] buildNWayItemsList(String string, int[] nArray, int n, List<String> list) {
        int[] nArray2 = new int[]{0, 0};
        if (!this.checkVarInOtherLayers(string)) {
            this.showErrorDuplicateModel(string);
            nArray2[0] = n;
            nArray2[1] = -1;
        } else {
            if (!this.checkVariableForModel(string)) {
                nArray[n++] = ((DefaultListModel)this.mModelList.getModel()).indexOf(string);
            } else {
                Set<String> set = this.mModelVariables.get(this.mCurrentEffect);
                list.add(string);
                set.add(this.mCurrentCombination + "$" + string);
            }
            nArray2[0] = n;
        }
        return nArray2;
    }

    private int get2WayItems(List<String> list, List<String> list2, int[] nArray, int n) {
        int n2 = list.size();
        if (n2 < 2) {
            return n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                stringBuffer.setLength(0);
                stringBuffer.append(list.get(i)).append(BY_TEXT_STRING);
                stringBuffer.append(list.get(j));
                String string = stringBuffer.toString();
                int[] nArray2 = this.buildNWayItemsList(string, nArray, n, list2);
                if (nArray2[1] == -1) {
                    return -1;
                }
                n = nArray2[0];
            }
        }
        return n;
    }

    private int get3WayItems(List<String> list, List<String> list2, int[] nArray, int n) {
        int n2 = list.size();
        if (n2 < 3) {
            return n;
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                for (int k = j + 1; k < n2; ++k) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(list.get(i)).append(BY_TEXT_STRING);
                    stringBuffer.append(list.get(j)).append(BY_TEXT_STRING);
                    stringBuffer.append(list.get(k));
                    String string = stringBuffer.toString();
                    int[] nArray2 = this.buildNWayItemsList(string, nArray, n, list2);
                    if (nArray2[1] == -1) {
                        return -1;
                    }
                    n = nArray2[0];
                }
            }
        }
        return n;
    }

    private int get4WayItems(List<String> list, List<String> list2, int[] nArray, int n) {
        int n2 = list.size();
        if (n2 < 4) {
            return n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                for (int k = j + 1; k < n2; ++k) {
                    for (int i2 = k + 1; i2 < n2; ++i2) {
                        stringBuffer.setLength(0);
                        stringBuffer.append(list.get(i)).append(BY_TEXT_STRING);
                        stringBuffer.append(list.get(j)).append(BY_TEXT_STRING);
                        stringBuffer.append(list.get(k)).append(BY_TEXT_STRING);
                        stringBuffer.append(list.get(i2));
                        String string = stringBuffer.toString();
                        int[] nArray2 = this.buildNWayItemsList(string, nArray, n, list2);
                        if (nArray2[1] == -1) {
                            return -1;
                        }
                        n = nArray2[0];
                    }
                }
            }
        }
        return n;
    }

    private int get5WayItems(List<String> list, List<String> list2, int[] nArray, int n) {
        int n2 = list.size();
        if (n2 < 5) {
            return n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                for (int k = j + 1; k < n2; ++k) {
                    for (int i2 = k + 1; i2 < n2; ++i2) {
                        for (int i3 = i2 + 1; i3 < n2; ++i3) {
                            stringBuffer.setLength(0);
                            stringBuffer.append(list.get(i)).append(BY_TEXT_STRING);
                            stringBuffer.append(list.get(j)).append(BY_TEXT_STRING);
                            stringBuffer.append(list.get(k)).append(BY_TEXT_STRING);
                            stringBuffer.append(list.get(i2)).append(BY_TEXT_STRING);
                            stringBuffer.append(list.get(i3));
                            String string = stringBuffer.toString();
                            int[] nArray2 = this.buildNWayItemsList(string, nArray, n, list2);
                            if (nArray2[1] == -1) {
                                return -1;
                            }
                            n = nArray2[0];
                        }
                    }
                }
            }
        }
        return n;
    }

    private int get6WayItems(List<String> list, List<String> list2, int[] nArray, int n) {
        int n2 = list.size();
        if (n2 < 6) {
            return n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                for (int k = j + 1; k < n2; ++k) {
                    for (int i2 = k + 1; i2 < n2; ++i2) {
                        for (int i3 = i2 + 1; i3 < n2; ++i3) {
                            for (int i4 = i3 + 1; i4 < n2; ++i4) {
                                stringBuffer.setLength(0);
                                stringBuffer.append(list.get(i)).append(BY_TEXT_STRING);
                                stringBuffer.append(list.get(j)).append(BY_TEXT_STRING);
                                stringBuffer.append(list.get(k)).append(BY_TEXT_STRING);
                                stringBuffer.append(list.get(i2)).append(BY_TEXT_STRING);
                                stringBuffer.append(list.get(i3)).append(BY_TEXT_STRING);
                                stringBuffer.append(list.get(i4));
                                String string = stringBuffer.toString();
                                int[] nArray2 = this.buildNWayItemsList(string, nArray, n, list2);
                                if (nArray2[1] == -1) {
                                    return -1;
                                }
                                n = nArray2[0];
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    private int get7WayItems(List<String> list, List<String> list2, int[] nArray, int n) {
        int n2 = list.size();
        if (n2 < 7) {
            return n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                for (int k = j + 1; k < n2; ++k) {
                    for (int i2 = k + 1; i2 < n2; ++i2) {
                        for (int i3 = i2 + 1; i3 < n2; ++i3) {
                            for (int i4 = i3 + 1; i4 < n2; ++i4) {
                                for (int i5 = i4 + 1; i5 < n2; ++i5) {
                                    stringBuffer.setLength(0);
                                    stringBuffer.append(list.get(i)).append(BY_TEXT_STRING);
                                    stringBuffer.append(list.get(j)).append(BY_TEXT_STRING);
                                    stringBuffer.append(list.get(k)).append(BY_TEXT_STRING);
                                    stringBuffer.append(list.get(i2)).append(BY_TEXT_STRING);
                                    stringBuffer.append(list.get(i3)).append(BY_TEXT_STRING);
                                    stringBuffer.append(list.get(i4)).append(BY_TEXT_STRING);
                                    stringBuffer.append(list.get(i5));
                                    String string = stringBuffer.toString();
                                    int[] nArray2 = this.buildNWayItemsList(string, nArray, n, list2);
                                    if (nArray2[1] == -1) {
                                        return -1;
                                    }
                                    n = nArray2[0];
                                }
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    private int get8WayItems(List<String> list, List<String> list2, int[] nArray, int n) {
        int n2 = list.size();
        if (n2 < 8) {
            return n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                for (int k = j + 1; k < n2; ++k) {
                    for (int i2 = k + 1; i2 < n2; ++i2) {
                        for (int i3 = i2 + 1; i3 < n2; ++i3) {
                            for (int i4 = i3 + 1; i4 < n2; ++i4) {
                                for (int i5 = i4 + 1; i5 < n2; ++i5) {
                                    for (int i6 = i5 + 1; i6 < n2; ++i6) {
                                        stringBuffer.setLength(0);
                                        stringBuffer.append(list.get(i)).append(BY_TEXT_STRING);
                                        stringBuffer.append(list.get(j)).append(BY_TEXT_STRING);
                                        stringBuffer.append(list.get(k)).append(BY_TEXT_STRING);
                                        stringBuffer.append(list.get(i2)).append(BY_TEXT_STRING);
                                        stringBuffer.append(list.get(i3)).append(BY_TEXT_STRING);
                                        stringBuffer.append(list.get(i4)).append(BY_TEXT_STRING);
                                        stringBuffer.append(list.get(i5)).append(BY_TEXT_STRING);
                                        stringBuffer.append(list.get(i6));
                                        String string = stringBuffer.toString();
                                        int[] nArray2 = this.buildNWayItemsList(string, nArray, n, list2);
                                        if (nArray2[1] == -1) {
                                            return -1;
                                        }
                                        n = nArray2[0];
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    private int get9WayItems(List<String> list, List<String> list2, int[] nArray, int n) {
        int n2 = list.size();
        if (n2 < 9) {
            return n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                for (int k = j + 1; k < n2; ++k) {
                    for (int i2 = k + 1; i2 < n2; ++i2) {
                        for (int i3 = i2 + 1; i3 < n2; ++i3) {
                            for (int i4 = i3 + 1; i4 < n2; ++i4) {
                                for (int i5 = i4 + 1; i5 < n2; ++i5) {
                                    for (int i6 = i5 + 1; i6 < n2; ++i6) {
                                        for (int i7 = i6 + 1; i7 < n2; ++i7) {
                                            stringBuffer.setLength(0);
                                            stringBuffer.append(list.get(i)).append(BY_TEXT_STRING);
                                            stringBuffer.append(list.get(j)).append(BY_TEXT_STRING);
                                            stringBuffer.append(list.get(k)).append(BY_TEXT_STRING);
                                            stringBuffer.append(list.get(i2)).append(BY_TEXT_STRING);
                                            stringBuffer.append(list.get(i3)).append(BY_TEXT_STRING);
                                            stringBuffer.append(list.get(i4)).append(BY_TEXT_STRING);
                                            stringBuffer.append(list.get(i5)).append(BY_TEXT_STRING);
                                            stringBuffer.append(list.get(i6)).append(BY_TEXT_STRING);
                                            stringBuffer.append(list.get(i7));
                                            String string = stringBuffer.toString();
                                            int[] nArray2 = this.buildNWayItemsList(string, nArray, n, list2);
                                            if (nArray2[1] == -1) {
                                                return -1;
                                            }
                                            n = nArray2[0];
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    private int get10WayItems(List<String> list, List<String> list2, int[] nArray, int n) {
        int n2 = list.size();
        if (n2 < 10) {
            return n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                for (int k = j + 1; k < n2; ++k) {
                    for (int i2 = k + 1; i2 < n2; ++i2) {
                        for (int i3 = i2 + 1; i3 < n2; ++i3) {
                            for (int i4 = i3 + 1; i4 < n2; ++i4) {
                                for (int i5 = i4 + 1; i5 < n2; ++i5) {
                                    for (int i6 = i5 + 1; i6 < n2; ++i6) {
                                        for (int i7 = i6 + 1; i7 < n2; ++i7) {
                                            for (int i8 = i7 + 1; i8 < n2; ++i8) {
                                                stringBuffer.setLength(0);
                                                stringBuffer.append(list.get(i)).append(BY_TEXT_STRING);
                                                stringBuffer.append(list.get(j)).append(BY_TEXT_STRING);
                                                stringBuffer.append(list.get(k)).append(BY_TEXT_STRING);
                                                stringBuffer.append(list.get(i2)).append(BY_TEXT_STRING);
                                                stringBuffer.append(list.get(i3)).append(BY_TEXT_STRING);
                                                stringBuffer.append(list.get(i4)).append(BY_TEXT_STRING);
                                                stringBuffer.append(list.get(i5)).append(BY_TEXT_STRING);
                                                stringBuffer.append(list.get(i6)).append(BY_TEXT_STRING);
                                                stringBuffer.append(list.get(i7)).append(BY_TEXT_STRING);
                                                stringBuffer.append(list.get(i8));
                                                String string = stringBuffer.toString();
                                                int[] nArray2 = this.buildNWayItemsList(string, nArray, n, list2);
                                                if (nArray2[1] == -1) {
                                                    return -1;
                                                }
                                                n = nArray2[0];
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    private int get11WayItems(List<String> list, List<String> list2, int[] nArray, int n) {
        int n2 = list.size();
        if (n2 < 11) {
            return n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                for (int k = j + 1; k < n2; ++k) {
                    for (int i2 = k + 1; i2 < n2; ++i2) {
                        for (int i3 = i2 + 1; i3 < n2; ++i3) {
                            for (int i4 = i3 + 1; i4 < n2; ++i4) {
                                for (int i5 = i4 + 1; i5 < n2; ++i5) {
                                    for (int i6 = i5 + 1; i6 < n2; ++i6) {
                                        for (int i7 = i6 + 1; i7 < n2; ++i7) {
                                            for (int i8 = i7 + 1; i8 < n2; ++i8) {
                                                for (int i9 = i8 + 1; i9 < n2; ++i9) {
                                                    stringBuffer.setLength(0);
                                                    stringBuffer.append(list.get(i)).append(BY_TEXT_STRING);
                                                    stringBuffer.append(list.get(j)).append(BY_TEXT_STRING);
                                                    stringBuffer.append(list.get(k)).append(BY_TEXT_STRING);
                                                    stringBuffer.append(list.get(i2)).append(BY_TEXT_STRING);
                                                    stringBuffer.append(list.get(i3)).append(BY_TEXT_STRING);
                                                    stringBuffer.append(list.get(i4)).append(BY_TEXT_STRING);
                                                    stringBuffer.append(list.get(i5)).append(BY_TEXT_STRING);
                                                    stringBuffer.append(list.get(i6)).append(BY_TEXT_STRING);
                                                    stringBuffer.append(list.get(i7)).append(BY_TEXT_STRING);
                                                    stringBuffer.append(list.get(i8)).append(BY_TEXT_STRING);
                                                    stringBuffer.append(list.get(i9));
                                                    String string = stringBuffer.toString();
                                                    int[] nArray2 = this.buildNWayItemsList(string, nArray, n, list2);
                                                    if (nArray2[1] == -1) {
                                                        return -1;
                                                    }
                                                    n = nArray2[0];
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    private int get12WayItems(List<String> list, List<String> list2, int[] nArray, int n) {
        int n2 = list.size();
        if (n2 < 12) {
            return n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                for (int k = j + 1; k < n2; ++k) {
                    for (int i2 = k + 1; i2 < n2; ++i2) {
                        for (int i3 = i2 + 1; i3 < n2; ++i3) {
                            for (int i4 = i3 + 1; i4 < n2; ++i4) {
                                for (int i5 = i4 + 1; i5 < n2; ++i5) {
                                    for (int i6 = i5 + 1; i6 < n2; ++i6) {
                                        for (int i7 = i6 + 1; i7 < n2; ++i7) {
                                            for (int i8 = i7 + 1; i8 < n2; ++i8) {
                                                for (int i9 = i8 + 1; i9 < n2; ++i9) {
                                                    for (int i10 = i9 + 1; i10 < n2; ++i10) {
                                                        stringBuffer.setLength(0);
                                                        stringBuffer.append(list.get(i)).append(BY_TEXT_STRING);
                                                        stringBuffer.append(list.get(j)).append(BY_TEXT_STRING);
                                                        stringBuffer.append(list.get(k)).append(BY_TEXT_STRING);
                                                        stringBuffer.append(list.get(i2)).append(BY_TEXT_STRING);
                                                        stringBuffer.append(list.get(i3)).append(BY_TEXT_STRING);
                                                        stringBuffer.append(list.get(i4)).append(BY_TEXT_STRING);
                                                        stringBuffer.append(list.get(i5)).append(BY_TEXT_STRING);
                                                        stringBuffer.append(list.get(i6)).append(BY_TEXT_STRING);
                                                        stringBuffer.append(list.get(i7)).append(BY_TEXT_STRING);
                                                        stringBuffer.append(list.get(i8)).append(BY_TEXT_STRING);
                                                        stringBuffer.append(list.get(i9)).append(BY_TEXT_STRING);
                                                        stringBuffer.append(list.get(i10));
                                                        String string = stringBuffer.toString();
                                                        int[] nArray2 = this.buildNWayItemsList(string, nArray, n, list2);
                                                        if (nArray2[1] == -1) {
                                                            return -1;
                                                        }
                                                        n = nArray2[0];
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    private int get13WayItems(List<String> list, List<String> list2, int[] nArray, int n) {
        int n2 = list.size();
        if (n2 < 13) {
            return n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                for (int k = j + 1; k < n2; ++k) {
                    for (int i2 = k + 1; i2 < n2; ++i2) {
                        for (int i3 = i2 + 1; i3 < n2; ++i3) {
                            for (int i4 = i3 + 1; i4 < n2; ++i4) {
                                for (int i5 = i4 + 1; i5 < n2; ++i5) {
                                    for (int i6 = i5 + 1; i6 < n2; ++i6) {
                                        for (int i7 = i6 + 1; i7 < n2; ++i7) {
                                            for (int i8 = i7 + 1; i8 < n2; ++i8) {
                                                for (int i9 = i8 + 1; i9 < n2; ++i9) {
                                                    for (int i10 = i9 + 1; i10 < n2; ++i10) {
                                                        for (int i11 = i10 + 1; i11 < n2; ++i11) {
                                                            stringBuffer.setLength(0);
                                                            stringBuffer.append(list.get(i)).append(BY_TEXT_STRING);
                                                            stringBuffer.append(list.get(j)).append(BY_TEXT_STRING);
                                                            stringBuffer.append(list.get(k)).append(BY_TEXT_STRING);
                                                            stringBuffer.append(list.get(i2)).append(BY_TEXT_STRING);
                                                            stringBuffer.append(list.get(i3)).append(BY_TEXT_STRING);
                                                            stringBuffer.append(list.get(i4)).append(BY_TEXT_STRING);
                                                            stringBuffer.append(list.get(i5)).append(BY_TEXT_STRING);
                                                            stringBuffer.append(list.get(i6)).append(BY_TEXT_STRING);
                                                            stringBuffer.append(list.get(i7)).append(BY_TEXT_STRING);
                                                            stringBuffer.append(list.get(i8)).append(BY_TEXT_STRING);
                                                            stringBuffer.append(list.get(i9)).append(BY_TEXT_STRING);
                                                            stringBuffer.append(list.get(i10)).append(BY_TEXT_STRING);
                                                            stringBuffer.append(list.get(i11));
                                                            String string = stringBuffer.toString();
                                                            int[] nArray2 = this.buildNWayItemsList(string, nArray, n, list2);
                                                            if (nArray2[1] == -1) {
                                                                return -1;
                                                            }
                                                            n = nArray2[0];
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    private int get14WayItems(List<String> list, List<String> list2, int[] nArray, int n) {
        int n2 = list.size();
        if (n2 < 14) {
            return n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                for (int k = j + 1; k < n2; ++k) {
                    for (int i2 = k + 1; i2 < n2; ++i2) {
                        for (int i3 = i2 + 1; i3 < n2; ++i3) {
                            for (int i4 = i3 + 1; i4 < n2; ++i4) {
                                for (int i5 = i4 + 1; i5 < n2; ++i5) {
                                    for (int i6 = i5 + 1; i6 < n2; ++i6) {
                                        for (int i7 = i6 + 1; i7 < n2; ++i7) {
                                            for (int i8 = i7 + 1; i8 < n2; ++i8) {
                                                for (int i9 = i8 + 1; i9 < n2; ++i9) {
                                                    for (int i10 = i9 + 1; i10 < n2; ++i10) {
                                                        for (int i11 = i10 + 1; i11 < n2; ++i11) {
                                                            for (int i12 = i11 + 1; i12 < n2; ++i12) {
                                                                stringBuffer.setLength(0);
                                                                stringBuffer.append(list.get(i)).append(BY_TEXT_STRING);
                                                                stringBuffer.append(list.get(j)).append(BY_TEXT_STRING);
                                                                stringBuffer.append(list.get(k)).append(BY_TEXT_STRING);
                                                                stringBuffer.append(list.get(i2)).append(BY_TEXT_STRING);
                                                                stringBuffer.append(list.get(i3)).append(BY_TEXT_STRING);
                                                                stringBuffer.append(list.get(i4)).append(BY_TEXT_STRING);
                                                                stringBuffer.append(list.get(i5)).append(BY_TEXT_STRING);
                                                                stringBuffer.append(list.get(i6)).append(BY_TEXT_STRING);
                                                                stringBuffer.append(list.get(i7)).append(BY_TEXT_STRING);
                                                                stringBuffer.append(list.get(i8)).append(BY_TEXT_STRING);
                                                                stringBuffer.append(list.get(i9)).append(BY_TEXT_STRING);
                                                                stringBuffer.append(list.get(i10)).append(BY_TEXT_STRING);
                                                                stringBuffer.append(list.get(i11)).append(BY_TEXT_STRING);
                                                                stringBuffer.append(list.get(i12));
                                                                String string = stringBuffer.toString();
                                                                int[] nArray2 = this.buildNWayItemsList(string, nArray, n, list2);
                                                                if (nArray2[1] == -1) {
                                                                    return -1;
                                                                }
                                                                n = nArray2[0];
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    private void showErrorDuplicateModel(String string) {
        String string2 = MessageFormat.format(this.getResString("ERR_DUPLICATE_RANDOM_MSG"), string);
        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string2, VersionInfo.getAppVersionString());
    }

    private boolean checkVariableForModel(String string) {
        if (!this.mModelVariables.containsKey(this.mCurrentEffect) || this.mModelVariables.get(this.mCurrentEffect) == null) {
            HashSet hashSet = new HashSet();
            this.mModelVariables.put(this.mCurrentEffect, hashSet);
        } else {
            Set<String> set = this.mModelVariables.get(this.mCurrentEffect);
            if (set != null && (set.contains(this.mCurrentCombination + "$" + string) || this.checkVarIgnoringOrder(this.mCurrentCombination + "$" + string, set))) {
                return false;
            }
        }
        return true;
    }

    private boolean checkVarIgnoringOrder(String string, Set<String> set) {
        if (!string.contains(BY_TEXT_STRING)) {
            return false;
        }
        for (String string2 : set) {
            if (!this.isEqualIgnoringOrder(string, string2)) continue;
            return true;
        }
        return false;
    }

    private boolean isEqualIgnoringOrder(String string, String string2) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl = false;
        boolean bl2 = false;
        if (string.charAt(string.length() - 1) == '$') {
            bl = true;
        }
        if (string2.charAt(string2.length() - 1) == '$') {
            bl2 = true;
        }
        if (bl != bl2) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(string.lastIndexOf(36) + 1), "*()");
        String string3 = string.substring(0, string.lastIndexOf(36));
        String string4 = string2.substring(0, string2.lastIndexOf(36));
        if (bl && bl2 && !string3.equals(string4)) {
            return false;
        }
        int n = stringTokenizer.countTokens();
        if (n == 1) {
            return string.equals(string2);
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            arrayList.add((String)object);
            if (hashMap.containsKey(object)) {
                int n2 = (Integer)hashMap.get(object) + 1;
                hashMap.put((String)object, n2);
                continue;
            }
            hashMap.put((String)object, 1);
        }
        String string5 = string2.substring(string2.lastIndexOf(36) + 1);
        if (!string5.contains(BY_TEXT_STRING) && !string5.contains("(")) {
            return false;
        }
        object = new StringTokenizer(string5, "*()");
        if (!string3.equals(string4)) {
            return false;
        }
        if (n == ((StringTokenizer)object).countTokens()) {
            int n3;
            arrayList2.clear();
            hashMap2.clear();
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string6 = ((StringTokenizer)object).nextToken();
                arrayList2.add(string6);
                if (hashMap2.containsKey(string6)) {
                    n3 = hashMap2.get(string6) + 1;
                    hashMap2.put(string6, n3);
                    continue;
                }
                hashMap2.put(string6, 1);
            }
            if (!this.compareMap(hashMap, hashMap2)) {
                return false;
            }
            int n4 = 0;
            for (String string7 : arrayList) {
                n3 = 0;
                for (String string8 : arrayList2) {
                    if (!string7.equals(string8)) continue;
                    n3 = 1;
                    if (++n4 != n) break;
                    String string9 = string2.substring(string2.lastIndexOf(36) + 1);
                    int n5 = ((DefaultListModel)this.mModelList.getModel()).indexOf(string9);
                    this.mModelList.setSelectedIndex(n5);
                    return true;
                }
                if (n3 != 0) continue;
                break;
            }
        }
        return false;
    }

    boolean compareMap(Map<String, Integer> map, Map<String, Integer> map2) {
        for (String string : map.keySet()) {
            int n = map.get(string);
            if (map2.containsKey(string)) {
                int n2 = map2.get(string);
                if (n == n2) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean checkVarInOtherLayers(String string) {
        for (int n : this.mModelVariables.keySet()) {
            Set<String> set;
            if (n == this.mCurrentEffect || !this.containTerm(set = this.mModelVariables.get(n), string)) continue;
            return false;
        }
        return true;
    }

    private boolean containTerm(Set<String> set, String string) {
        boolean bl = false;
        for (String string2 : set) {
            String string3;
            boolean bl2 = true;
            int n = string2.lastIndexOf(36);
            if (n > -1 && !(string3 = string2.substring(0, n)).equals(this.mCurrentCombination.toString())) {
                bl2 = false;
            }
            if (!bl2 || n <= -1) continue;
            string3 = string2.substring(n + 1);
            ArrayList<String> arrayList = this.getParsedVarArray(string3);
            ArrayList<String> arrayList2 = this.getParsedVarArray(string);
            if (arrayList2.size() != arrayList.size() || !arrayList2.containsAll(arrayList)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private ArrayList<String> getParsedVarArray(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "*()");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(string2);
        }
        return arrayList;
    }

    private void saveCurrentState() {
        Layer layer = this.mLayers.get(this.mCurrentEffect);
        if (null == layer) {
            layer = new Layer();
        }
        DefaultListModel defaultListModel = (DefaultListModel)this.mModelList.getModel();
        int n = defaultListModel.getSize();
        Set<String> set = layer.getModelItems();
        set.clear();
        for (int i = 0; i < n; ++i) {
            set.add((String)defaultListModel.getElementAt(i));
        }
        VarListModel varListModel = this.mCombinationList.getModel();
        n = varListModel.getSize();
        List<ISpssVariable> list = layer.getCombinationItems();
        list.clear();
        for (int i = 0; i < n; ++i) {
            list.add(varListModel.getElementAt(i));
        }
        layer.setModelItems(set);
        layer.setCombinationItems(list);
        layer.setCovarianceType(this.mCovarianceCombo.getSelectedIndex());
        layer.setIntercept(this.mIncludeIntercept.isSelected());
        layer.setDisplayParam(this.mDisplayParam.isSelected());
        this.mLayers.put(this.mCurrentEffect, layer);
    }

    private void removeEmptyLayer() {
        Layer layer = this.mLayers.get(this.mCurrentEffect);
        int n = this.mCurrentEffect;
        int n2 = layer.getCombinationItems().size();
        int n3 = layer.getModelItems().size();
        if (n3 == 0 && n2 == 0) {
            int n4 = this.mCurrentEffect;
            while (this.mLayers.get(++this.mCurrentEffect) != null) {
                Set<String> set = this.mModelVariables.get(this.mCurrentEffect);
                if (set != null) {
                    this.mModelVariables.put(n4, set);
                } else {
                    this.mModelVariables.remove(n4);
                }
                Layer layer2 = this.mLayers.get(n4);
                layer = this.mLayers.get(this.mCurrentEffect);
                layer2.setCombinationItems(layer.getCombinationItems());
                layer2.setModelItems(layer.getModelItems());
                layer2.setCovarianceType(layer.getCovarianceType());
                layer2.setIntercept(layer.isIntercept());
                n4 = this.mCurrentEffect;
            }
            this.mModelVariables.remove(n4);
            if (!this.mLayers.get(n4).isIntercept()) {
                this.mLayers.remove(n4);
            }
            this.mCurrentEffect = n;
        }
    }

    private void loadCurrentState() {
        ((DefaultListModel)this.mModelList.getModel()).clear();
        this.mCombinationList.getModel().removeAll();
        Layer layer = this.mLayers.get(this.mCurrentEffect);
        if (null != layer) {
            Set<String> set = layer.getModelItems();
            DefaultListModel defaultListModel = (DefaultListModel)this.mModelList.getModel();
            defaultListModel.clear();
            for (String object2 : set) {
                defaultListModel.addElement(object2);
            }
            VarListModel varListModel = this.mCombinationList.getModel();
            List<ISpssVariable> list = layer.getCombinationItems();
            varListModel.removeAll();
            this.mCurrentCombination.setLength(0);
            for (ISpssVariable iSpssVariable : list) {
                this.mCurrentCombination.append(iSpssVariable.getName()).append(BY_TEXT_STRING);
                varListModel.addElement(iSpssVariable);
            }
            if (list.size() == 0) {
                this.mCurrentCombination.append("$");
            }
        } else {
            layer = new Layer();
            this.mCurrentCombination.setLength(0);
            this.mCurrentCombination.append("$");
            this.mLayers.put(this.mCurrentEffect, layer);
        }
        this.mCovarianceCombo.setSelectedIndex(layer.getCovarianceType());
        this.mIncludeIntercept.setSelected(layer.isIntercept());
        this.mDisplayParam.setSelected(layer.isDisplayParam());
        this.setBorderTitleString();
        this.enablePreviousNext(this.mLayers.containsKey(this.mCurrentEffect - 1), this.mLayers.containsKey(this.mCurrentEffect + 1) || this.mModelList.getModel().getSize() > 0);
        if (this.mCurrentEffect == 8) {
            this.mNextButton.setEnabled(false);
        }
    }

    private void updateCombination() {
        VarListModel varListModel = this.mCombinationList.getModel();
        int n = varListModel.getSize();
        this.mCurrentCombination.setLength(0);
        for (int i = 0; i < n; ++i) {
            this.mCurrentCombination.append(varListModel.getElementAt(i).getName()).append(BY_TEXT_STRING);
        }
        if (n == 0) {
            this.mCurrentCombination.append("$");
        }
        String string = this.mCurrentCombination.toString();
        if (this.mModelVariables.containsKey(this.mCurrentEffect)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Set<String> set = this.mModelVariables.remove(this.mCurrentEffect);
            for (String string2 : set) {
                int n2 = string2.lastIndexOf(36) + 1;
                string2 = string + '$' + string2.substring(n2);
                arrayList.add(string2);
            }
            set.clear();
            set.addAll(arrayList);
            this.mModelVariables.put(this.mCurrentEffect, set);
        }
    }

    private void saveVariables() {
        ISpssVariable iSpssVariable;
        int n;
        HashMap<String, LocallyUniqueId> hashMap = new HashMap<String, LocallyUniqueId>();
        VarListModel varListModel = this.mSrcVarList.getModel();
        for (n = 0; n < varListModel.getSize(); ++n) {
            iSpssVariable = (ISpssVariable)varListModel.getElementAt(n);
            hashMap.put(iSpssVariable.getName(), iSpssVariable.getId());
        }
        varListModel = this.mSubjectList.getModel();
        for (n = 0; n < varListModel.getSize(); ++n) {
            iSpssVariable = (ISpssVariable)varListModel.getElementAt(n);
            hashMap.put(iSpssVariable.getName(), iSpssVariable.getId());
        }
        ((MixedModelMainDlg)((Object)this.getParent())).getDialogDataModel().putObject(FACT_COV_SUBJ_LIST_VAR_KEY, hashMap);
    }

    private void validateDialogDataModel() {
        Object object;
        int n;
        Object object2;
        Map.Entry entry22;
        DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
        if (dialogDataModel == null) {
            return;
        }
        Object object3 = dialogDataModel.getObject(FACT_COV_SUBJ_LIST_VAR_KEY);
        if (object3 == null) {
            return;
        }
        HashMap hashMap = (HashMap)object3;
        HashMap<Object, String> hashMap2 = new HashMap<Object, String>();
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        for (Map.Entry entry22 : hashMap.entrySet()) {
            object2 = (LocallyUniqueId)entry22.getValue();
            int n2 = iSpssDataSrc.findVarIndex((LocallyUniqueId)object2);
            if (n2 != -1) {
                hashMap2.put(object2, iSpssDataSrc.getVariable(n2).getName());
                continue;
            }
            hashMap2.put(object2, "");
        }
        StringBuffer stringBuffer = new StringBuffer();
        entry22 = new ArrayList();
        for (Set collection2 : this.mModelVariables.values()) {
            if (collection2 == null) continue;
            ((ArrayList)((Object)entry22)).clear();
            for (String string : collection2) {
                String layer;
                LocallyUniqueId locallyUniqueId2;
                String string2;
                stringBuffer.setLength(0);
                n = 1;
                int layer2 = string.lastIndexOf(36);
                if (layer2 == string.length() - 1) {
                    n = 0;
                }
                boolean i = true;
                if (!string.startsWith("$$")) {
                    string2 = string.substring(0, layer2);
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, BY_TEXT_STRING);
                    while (stringTokenizer.hasMoreTokens()) {
                        locallyUniqueId2 = (LocallyUniqueId)hashMap.get(stringTokenizer.nextToken());
                        layer = (String)hashMap2.get(locallyUniqueId2);
                        if (layer != null && layer.length() > 0) {
                            stringBuffer.append(layer).append(BY_TEXT_STRING);
                            continue;
                        }
                        i = false;
                        break;
                    }
                    stringBuffer.append("$");
                } else {
                    stringBuffer.append("$$");
                }
                if (!i || n == 0) continue;
                string2 = string.substring(layer2 + 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, BY_TEXT_STRING);
                while (stringTokenizer.hasMoreTokens()) {
                    locallyUniqueId2 = (LocallyUniqueId)hashMap.get(stringTokenizer.nextToken());
                    layer = (String)hashMap2.get(locallyUniqueId2);
                    if (layer != null && layer.length() > 0) {
                        stringBuffer.append(layer).append(BY_TEXT_STRING);
                        continue;
                    }
                    i = false;
                    break;
                }
                if (!i) continue;
                ((ArrayList)((Object)entry22)).add(stringBuffer.substring(0, stringBuffer.length() - 1));
            }
            if (((ArrayList)((Object)entry22)).size() <= 0) continue;
            collection2.clear();
            object = ((ArrayList)((Object)entry22)).iterator();
            while (object.hasNext()) {
                String string;
                string = (String)object.next();
                collection2.add(string);
            }
        }
        if (dialogDataModel.getArray(RANDOM_TARGET_LIST_KEY) != null) {
            object2 = new ArrayList();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object iSpssVariable : dialogDataModel.getArray("TARGET_LIST_KEY")) {
                ((ArrayList)object2).add(iSpssVariable.toString());
            }
            for (Object object4 : dialogDataModel.getArray(RANDOM_TARGET_LIST_KEY)) {
                arrayList.add(object4.toString());
            }
            arrayList.removeAll((Collection<?>)object2);
            ((ArrayList)object2).clear();
            for (String string : arrayList) {
                for (n = 1; n <= this.mCurrentEffect; ++n) {
                    Layer layer = this.mLayers.get(n);
                    if (null == layer) continue;
                    for (Object object5 : layer.getModelItems().toArray()) {
                        if (object5.toString().contains(string)) continue;
                        ((ArrayList)object2).add(object5.toString());
                    }
                    layer.setModelItems(new LinkedHashSet<String>((Collection<String>)object2));
                    ((ArrayList)object2).clear();
                }
            }
        }
        if (dialogDataModel.getArray(RANDOM_TARGET_LIST_KEY) != null) {
            object2 = new ArrayList();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            object = dialogDataModel.getVarArray("MAIN DIALOG_SUBJECT_TARGET_LIST_KEY");
            arrayList.addAll(Arrays.asList(object));
            ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray(RANDOM_SUBJECT_LIST_KEY);
            ((ArrayList)object2).addAll(Arrays.asList(iSpssVariableArray));
            ((ArrayList)object2).removeAll(arrayList);
            arrayList.clear();
            Iterator iterator = ((ArrayList)object2).iterator();
            while (iterator.hasNext()) {
                ISpssVariable iSpssVariable = (ISpssVariable)iterator.next();
                for (int i = 1; i <= this.mCurrentEffect; ++i) {
                    Layer layer = this.mLayers.get(i);
                    if (null == layer) continue;
                    for (ISpssVariable iSpssVariable2 : layer.getCombinationItems()) {
                        if (iSpssVariable2.getName().equals(iSpssVariable.getName())) continue;
                        arrayList.add(iSpssVariable2);
                    }
                    layer.setCombinationItems(new ArrayList<ISpssVariable>(arrayList));
                    arrayList.clear();
                }
            }
        }
    }

    private void initializeArray(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            nArray[i] = -1;
        }
    }

    private class Layer {
        List<ISpssVariable> mCombinationItems = new LinkedList<ISpssVariable>();
        Set<String> mModelItems = new LinkedHashSet<String>();
        int mCovarianceType = 0;
        boolean mIsIntercept = false;
        boolean mIsDisplayParam = false;

        public boolean isIntercept() {
            return this.mIsIntercept;
        }

        public void setIntercept(boolean bl) {
            this.mIsIntercept = bl;
        }

        public boolean isDisplayParam() {
            return this.mIsDisplayParam;
        }

        public void setDisplayParam(boolean bl) {
            this.mIsDisplayParam = bl;
        }

        public List<ISpssVariable> getCombinationItems() {
            return this.mCombinationItems;
        }

        public void setCombinationItems(List<ISpssVariable> list) {
            this.mCombinationItems = list;
        }

        public int getCovarianceType() {
            return this.mCovarianceType;
        }

        public void setCovarianceType(int n) {
            this.mCovarianceType = n;
        }

        public Set<String> getModelItems() {
            return this.mModelItems;
        }

        public void setModelItems(Set<String> set) {
            this.mModelItems = set;
        }
    }

    private class NextAction
    extends ToggleButtonAction {
        public NextAction(BaseDialog baseDialog, String string) {
            super(baseDialog, string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = false;
            if (MixedModelRandom.this.mModelList.getModel().getSize() == 0 && MixedModelRandom.this.mCombinationList.getModel().getSize() == 0) {
                Layer layer = (Layer)MixedModelRandom.this.mLayers.get(MixedModelRandom.this.mCurrentEffect + 1);
                if (layer == null || layer.getModelItems().size() == 0 && layer.getCombinationItems().size() == 0) {
                    MixedModelRandom.this.saveCurrentState();
                    MixedModelRandom.this.mNextButton.setEnabled(false);
                    return;
                }
            } else {
                bl = true;
            }
            MixedModelRandom.this.saveCurrentState();
            MixedModelRandom.this.removeEmptyLayer();
            if (bl) {
                MixedModelRandom.this.mCurrentEffect++;
            }
            MixedModelRandom.this.loadCurrentState();
        }
    }

    private class PreviousAction
    extends ToggleButtonAction {
        public PreviousAction(BaseDialog baseDialog, String string) {
            super(baseDialog, string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MixedModelRandom.this.saveCurrentState();
            MixedModelRandom.this.removeEmptyLayer();
            MixedModelRandom.this.mCurrentEffect--;
            MixedModelRandom.this.loadCurrentState();
        }
    }

    private class RemoveAction
    extends ToggleButtonAction {
        public RemoveAction(BaseDialog baseDialog, String string) {
            super(baseDialog, string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = MixedModelRandom.this.mModelList.getSelectedValues();
            Set set = (Set)MixedModelRandom.this.mModelVariables.get(MixedModelRandom.this.mCurrentEffect);
            Layer layer = (Layer)MixedModelRandom.this.mLayers.get(MixedModelRandom.this.mCurrentEffect);
            DefaultListModel defaultListModel = (DefaultListModel)MixedModelRandom.this.mModelList.getModel();
            for (String string : stringArray) {
                defaultListModel.removeElement(string);
                if (set != null) {
                    set.remove(MixedModelRandom.this.mCurrentCombination + "$" + string);
                }
                if (layer == null) continue;
                layer.mModelItems.remove(string);
            }
            if (MixedModelRandom.this.mModelList.getModel().getSize() == 0) {
                MixedModelRandom.this.mRemoveButton.setEnabled(false);
            }
        }
    }

    private class AddAction
    extends ToggleButtonAction {
        public AddAction(BaseDialog baseDialog, String string) {
            super(baseDialog, string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MixedModelRandom.this.mBuildTermRadio.isSelected()) {
                DefaultListModel defaultListModel = (DefaultListModel)MixedModelRandom.this.mModelList.getModel();
                ISpssVariable[] iSpssVariableArray = MixedModelRandom.this.mSrcVarList.getSelectedValues();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                    arrayList.add(iSpssVariable.getName());
                }
                int n = MixedModelRandom.this.mBuildTermCombo.getSelectedIndex();
                LinkedList<String> linkedList = new LinkedList<String>();
                int[] nArray = new int[]{-1};
                MixedModelRandom.this.initializeArray(nArray);
                int n2 = 0;
                int n3 = 0;
                switch (n) {
                    case 0: {
                        int n4 = arrayList.size();
                        nArray = new int[(int)Math.pow(2.0, n4) - 1];
                        MixedModelRandom.this.initializeArray(nArray);
                        boolean bl = true;
                        for (String object : arrayList) {
                            if (!MixedModelRandom.this.checkVarInOtherLayers(object)) {
                                bl = false;
                                MixedModelRandom.this.showErrorDuplicateModel(object);
                                break;
                            }
                            if (!MixedModelRandom.this.checkVariableForModel(object)) {
                                nArray[n2++] = ((DefaultListModel)MixedModelRandom.this.mModelList.getModel()).indexOf(object);
                                continue;
                            }
                            linkedList.add(object);
                        }
                        if (bl) {
                            n2 = MixedModelRandom.this.get2WayItems(arrayList, linkedList, nArray, n2);
                            n2 = MixedModelRandom.this.get3WayItems(arrayList, linkedList, nArray, n2);
                            n2 = MixedModelRandom.this.get4WayItems(arrayList, linkedList, nArray, n2);
                            n2 = MixedModelRandom.this.get5WayItems(arrayList, linkedList, nArray, n2);
                            n2 = MixedModelRandom.this.get6WayItems(arrayList, linkedList, nArray, n2);
                            n2 = MixedModelRandom.this.get7WayItems(arrayList, linkedList, nArray, n2);
                            n2 = MixedModelRandom.this.get8WayItems(arrayList, linkedList, nArray, n2);
                            n2 = MixedModelRandom.this.get9WayItems(arrayList, linkedList, nArray, n2);
                            n2 = MixedModelRandom.this.get10WayItems(arrayList, linkedList, nArray, n2);
                            n2 = MixedModelRandom.this.get11WayItems(arrayList, linkedList, nArray, n2);
                            n2 = MixedModelRandom.this.get12WayItems(arrayList, linkedList, nArray, n2);
                            n2 = MixedModelRandom.this.get13WayItems(arrayList, linkedList, nArray, n2);
                            n2 = MixedModelRandom.this.get14WayItems(arrayList, linkedList, nArray, n2);
                        }
                        if (!bl || n2 == -1) break;
                        n3 = linkedList.size();
                        if (n3 == 0) {
                            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)MixedModelRandom.this), MixedModelRandom.this.getResString("ERR_MODEL_DUPLICATE_MSG1"), VersionInfo.getAppVersionString());
                        }
                        Set set = (Set)MixedModelRandom.this.mModelVariables.get(MixedModelRandom.this.mCurrentEffect);
                        for (String stringBuffer : linkedList) {
                            defaultListModel.addElement(stringBuffer);
                            set.add(MixedModelRandom.this.mCurrentCombination + "$" + stringBuffer);
                            nArray[n2++] = ((DefaultListModel)MixedModelRandom.this.mModelList.getModel()).indexOf(stringBuffer);
                        }
                        break;
                    }
                    case 1: {
                        nArray = new int[arrayList.size()];
                        MixedModelRandom.this.initializeArray(nArray);
                        boolean bl = false;
                        for (String string : arrayList) {
                            if (!MixedModelRandom.this.checkVarInOtherLayers(string)) {
                                MixedModelRandom.this.showErrorDuplicateModel(string);
                                bl = true;
                                break;
                            }
                            if (MixedModelRandom.this.checkVariableForModel(string)) {
                                ++n3;
                                linkedList.add(string);
                                continue;
                            }
                            nArray[n2++] = ((DefaultListModel)MixedModelRandom.this.mModelList.getModel()).indexOf(string);
                        }
                        if (bl) break;
                        if (n3 == 0) {
                            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)MixedModelRandom.this), MixedModelRandom.this.getResString("ERR_MODEL_DUPLICATE_MSG1"), VersionInfo.getAppVersionString());
                        } else if (n3 < nArray.length) {
                            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)MixedModelRandom.this), MixedModelRandom.this.getResString("ERR_MODEL_DUPLICATE_MSG2"), VersionInfo.getAppVersionString());
                        }
                        Set set = (Set)MixedModelRandom.this.mModelVariables.get(MixedModelRandom.this.mCurrentEffect);
                        for (String string : linkedList) {
                            defaultListModel.addElement(string);
                            nArray[n2++] = ((DefaultListModel)MixedModelRandom.this.mModelList.getModel()).indexOf(string);
                            set.add(MixedModelRandom.this.mCurrentCombination + "$" + string);
                        }
                        break;
                    }
                    case 2: {
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int i = 0; i < iSpssVariableArray.length; ++i) {
                            if (i == iSpssVariableArray.length - 1) {
                                stringBuffer.append(iSpssVariableArray[i].getName());
                                continue;
                            }
                            stringBuffer.append(iSpssVariableArray[i].getName()).append(MixedModelRandom.BY_TEXT_STRING);
                        }
                        String string = stringBuffer.toString();
                        if (iSpssVariableArray.length <= 0) break;
                        if (!MixedModelRandom.this.checkVarInOtherLayers(string)) {
                            MixedModelRandom.this.showErrorDuplicateModel(string);
                            break;
                        }
                        if (MixedModelRandom.this.checkVariableForModel(string)) {
                            defaultListModel.addElement(string);
                            ((Set)MixedModelRandom.this.mModelVariables.get(MixedModelRandom.this.mCurrentEffect)).add(MixedModelRandom.this.mCurrentCombination + "$" + string);
                        } else {
                            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)MixedModelRandom.this), MixedModelRandom.this.getResString("ERR_MODEL_DUPLICATE_MSG1"), VersionInfo.getAppVersionString());
                        }
                        nArray[n2] = ((DefaultListModel)MixedModelRandom.this.mModelList.getModel()).indexOf(string);
                        break;
                    }
                    case 3: {
                        int n11 = arrayList.size();
                        if (n11 < 2) break;
                        int n12 = n11 * (n11 - 1) / 2;
                        nArray = new int[n12];
                        MixedModelRandom.this.initializeArray(nArray);
                        n2 = MixedModelRandom.this.get2WayItems(arrayList, linkedList, nArray, n2);
                        n3 = linkedList.size();
                        if (n3 == 0) {
                            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)MixedModelRandom.this), MixedModelRandom.this.getResString("ERR_MODEL_DUPLICATE_MSG1"), VersionInfo.getAppVersionString());
                        } else if (n3 < n12) {
                            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)MixedModelRandom.this), MixedModelRandom.this.getResString("ERR_MODEL_DUPLICATE_MSG2"), VersionInfo.getAppVersionString());
                        }
                        for (String string : linkedList) {
                            defaultListModel.addElement(string);
                            nArray[n2++] = ((DefaultListModel)MixedModelRandom.this.mModelList.getModel()).indexOf(string);
                        }
                        break;
                    }
                    case 4: {
                        int n4 = arrayList.size();
                        if (n4 < 3) break;
                        int n5 = n4 * (n4 - 1) * (n4 - 2) / 6;
                        nArray = new int[n5];
                        MixedModelRandom.this.initializeArray(nArray);
                        n2 = MixedModelRandom.this.get3WayItems(arrayList, linkedList, nArray, n2);
                        n3 = linkedList.size();
                        if (n3 == 0) {
                            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)MixedModelRandom.this), MixedModelRandom.this.getResString("ERR_MODEL_DUPLICATE_MSG1"), VersionInfo.getAppVersionString());
                        } else if (n3 < n5) {
                            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)MixedModelRandom.this), MixedModelRandom.this.getResString("ERR_MODEL_DUPLICATE_MSG2"), VersionInfo.getAppVersionString());
                        }
                        for (String string : linkedList) {
                            defaultListModel.addElement(string);
                            nArray[n2++] = ((DefaultListModel)MixedModelRandom.this.mModelList.getModel()).indexOf(string);
                        }
                        break;
                    }
                    case 5: {
                        int n6 = arrayList.size();
                        if (n6 < 4) break;
                        int n7 = n6 * (n6 - 1) * (n6 - 2) * (n6 - 3) / 24;
                        nArray = new int[n7];
                        MixedModelRandom.this.initializeArray(nArray);
                        n2 = MixedModelRandom.this.get4WayItems(arrayList, linkedList, nArray, n2);
                        n3 = linkedList.size();
                        if (n3 == 0) {
                            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)MixedModelRandom.this), MixedModelRandom.this.getResString("ERR_MODEL_DUPLICATE_MSG1"), VersionInfo.getAppVersionString());
                        } else if (n3 < n7) {
                            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)MixedModelRandom.this), MixedModelRandom.this.getResString("ERR_MODEL_DUPLICATE_MSG2"), VersionInfo.getAppVersionString());
                        }
                        for (String string : linkedList) {
                            defaultListModel.addElement(string);
                            nArray[n2++] = ((DefaultListModel)MixedModelRandom.this.mModelList.getModel()).indexOf(string);
                        }
                        break;
                    }
                    case 6: {
                        int n8 = arrayList.size();
                        if (n8 < 5) break;
                        int n9 = n8 * (n8 - 1) * (n8 - 2) * (n8 - 3) * (n8 - 4) / 120;
                        nArray = new int[n9];
                        MixedModelRandom.this.initializeArray(nArray);
                        n2 = MixedModelRandom.this.get5WayItems(arrayList, linkedList, nArray, n2);
                        n3 = linkedList.size();
                        if (n3 == 0) {
                            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)MixedModelRandom.this), MixedModelRandom.this.getResString("ERR_MODEL_DUPLICATE_MSG1"), VersionInfo.getAppVersionString());
                        } else if (n3 < n9) {
                            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)MixedModelRandom.this), MixedModelRandom.this.getResString("ERR_MODEL_DUPLICATE_MSG2"), VersionInfo.getAppVersionString());
                        }
                        for (String string : linkedList) {
                            defaultListModel.addElement(string);
                            nArray[n2++] = ((DefaultListModel)MixedModelRandom.this.mModelList.getModel()).indexOf(string);
                        }
                        break;
                    }
                }
                if (MixedModelRandom.this.mModelList.getModel().getSize() > 0) {
                    MixedModelRandom.this.mModelList.requestFocus();
                    MixedModelRandom.this.mSrcVarList.clearSelection();
                    MixedModelRandom.this.mAddButton.setEnabled(false);
                    MixedModelRandom.this.mRemoveButton.setEnabled(true);
                    MixedModelRandom.this.mModelList.clearSelection();
                    MixedModelRandom.this.mModelList.setSelectedIndices(nArray);
                    MixedModelRandom.this.mModelList.ensureIndexIsVisible(nArray[0]);
                }
            } else {
                Set<String> set;
                String string = MixedModelRandom.this.mBuildTermText.getText().trim();
                boolean bl = MixedModelRandom.this.checkVarInOtherLayers(string);
                if (!bl) {
                    MixedModelRandom.this.showErrorDuplicateModel(string);
                    return;
                }
                DefaultListModel defaultListModel = (DefaultListModel)MixedModelRandom.this.mModelList.getModel();
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string);
                this.filterUniqueItems(arrayList, defaultListModel);
                if (bl && arrayList.size() == 0) {
                    SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)MixedModelRandom.this.mParentDlg), MixedModelRandom.this.getResString("ERR_MODEL_DUPLICATE_MSG1"), VersionInfo.getAppVersionString());
                    return;
                }
                if (MixedModelRandom.this.mModelVariables.get(MixedModelRandom.this.mCurrentEffect) == null) {
                    set = new HashSet();
                    MixedModelRandom.this.mModelVariables.put(MixedModelRandom.this.mCurrentEffect, set);
                }
                if ((set = (Set)MixedModelRandom.this.mModelVariables.get(MixedModelRandom.this.mCurrentEffect)) != null && bl) {
                    ((DefaultListModel)MixedModelRandom.this.mModelList.getModel()).addElement(MixedModelRandom.this.mBuildTermText.getText());
                    set.add(MixedModelRandom.this.mCurrentCombination + "$" + MixedModelRandom.this.mBuildTermText.getText());
                }
                MixedModelRandom.this.mBuildTermText.setText("");
                MixedModelRandom.this.mInsertPos = 0;
                MixedModelRandom.this.enableLowerComponents(false);
                MixedModelRandom.this.mAddButton.setEnabled(false);
                MixedModelRandom.this.mSrcVarList.clearSelection();
                MixedModelRandom.this.mModelList.requestFocus();
                int n = ((DefaultListModel)MixedModelRandom.this.mModelList.getModel()).indexOf(string);
                if (n != -1) {
                    MixedModelRandom.this.mModelList.setSelectedIndex(n);
                }
            }
        }

        protected void filterUniqueItems(ArrayList<String> arrayList, DefaultListModel defaultListModel) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ArrayList<String> arrayList4 = new ArrayList<String>();
            if (arrayList.get(0).contains("(") || arrayList.get(0).contains(MixedModelRandom.BY_TEXT_STRING)) {
                StringTokenizer stringTokenizer = new StringTokenizer(arrayList.get(0), "*()");
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    arrayList4.add(string);
                }
            }
            int n = defaultListModel.getSize();
            for (int i = 0; i < n; ++i) {
                String string = (String)defaultListModel.getElementAt(i);
                arrayList2.add(string);
                arrayList3.clear();
                if (string.contains("(") || string.contains(MixedModelRandom.BY_TEXT_STRING)) {
                    StringTokenizer stringTokenizer = new StringTokenizer(MixedModelRandom.this.mModelList.getModel().getElementAt(i).toString(), "*()");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        arrayList3.add(string2);
                    }
                }
                Collections.sort(arrayList4);
                Collections.sort(arrayList3);
                if (arrayList3.size() > 0 && arrayList4.size() > 0 && arrayList3.size() == arrayList4.size() && arrayList3.containsAll(arrayList4)) {
                    arrayList.remove(0);
                    continue;
                }
                if (arrayList3.size() != 0 || arrayList4.size() != 0) continue;
                arrayList.removeAll(arrayList2);
            }
        }
    }

    private class ClearAction
    extends ToggleButtonAction {
        public ClearAction(BaseDialog baseDialog, String string) {
            super(baseDialog, string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MixedModelRandom.this.mBuildTermText.setText("");
            MixedModelRandom.this.mInsertPos = 0;
            MixedModelRandom.this.enableLowerComponents(false);
            MixedModelRandom.this.mAddButton.setEnabled(false);
            MixedModelRandom.this.mSrcVarList.requestFocus();
        }
    }

    private class WithInAction
    extends ToggleButtonAction {
        public WithInAction(BaseDialog baseDialog, String string) {
            super(baseDialog, string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MixedModelRandom.this.mBuildTermText.insert(MixedModelRandom.WITHIN_TEXT_STRING, MixedModelRandom.this.mInsertPos++);
            MixedModelRandom.this.mWithInButton.setEnabled(false);
            MixedModelRandom.this.mByButton.setEnabled(false);
            MixedModelRandom.this.mAddButton.setEnabled(false);
            MixedModelRandom.this.mArrowButton.setEnabled(true);
            MixedModelRandom.this.mSrcVarList.requestFocus();
        }
    }

    private class ByAction
    extends ToggleButtonAction {
        public ByAction(BaseDialog baseDialog, String string) {
            super(baseDialog, string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MixedModelRandom.this.mBuildTermText.insert(MixedModelRandom.BY_TEXT_STRING, MixedModelRandom.this.mInsertPos++);
            MixedModelRandom.this.mWithInButton.setEnabled(false);
            MixedModelRandom.this.mByButton.setEnabled(false);
            MixedModelRandom.this.mAddButton.setEnabled(false);
            MixedModelRandom.this.mArrowButton.setEnabled(true);
            MixedModelRandom.this.mSrcVarList.requestFocus();
        }
    }

    private class MatchingLayers {
        Integer layer1 = 0;
        Integer layer2 = 0;

        private MatchingLayers() {
        }
    }
}

