/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.mixed_models;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.adv_stats.mixed_models.MixedModelEMMeans;
import com.spss.java_client.ui.dialogs.adv_stats.mixed_models.MixedModelEstimation;
import com.spss.java_client.ui.dialogs.adv_stats.mixed_models.MixedModelFixed;
import com.spss.java_client.ui.dialogs.adv_stats.mixed_models.MixedModelRandom;
import com.spss.java_client.ui.dialogs.adv_stats.mixed_models.MixedModelSave;
import com.spss.java_client.ui.dialogs.adv_stats.mixed_models.MixedModelStats;
import com.spss.java_client.ui.dialogs.adv_stats.res.AdvStatsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BootstrapDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class MixedModelMainDlg
extends BaseProcedureDialog
implements ListDataListener,
IVarMoveHandler {
    public static final String OVERALL = "(OVERALL)";
    static final String SOURCE_LIST_VAR_IDS_KEY = "IDS_SOURCE_LIST";
    static final String MAIN_DIALOG_SUBJECT_TARGET_LIST_KEY = "MAIN DIALOG_SUBJECT_TARGET_LIST_KEY";
    static final String TARGET_LIST_KEY = "TARGET_LIST_KEY";
    static final String FACTORS_TARGET_LIST_KEY = "FACTORS_TARGET_LIST_KEY";
    static final String COVARIATES_TARGET_LIST_KEY = "COVARIATES_TARGET_LIST_KEY";
    static final String DEP_VAR_TARGET_LIST_KEY = "IDS_DEPENDENT_VAR";
    static final String RES_WEIGHT_TARGET_LIST_KEY = "IDS_RESIDUAL_WEIGHT";
    private static final String FIXED_BUTTON = "IDS_FIXED_3DOT_BUTTON";
    private static final String RANDOM_BUTTON = "IDS_RANDOM_3DOT_BUTTON";
    private static final String ESTIMATION_BUTTON = "IDS_ESTIMATION_3DOT_BUTTON";
    private static final String STATISTICS_BUTTON = "IDS_COMMON_STATS_3DOT";
    private static final String EM_MEANS_BUTTON = "IDS_EM_MEANS_3DOT_BUTTON";
    private static final String SAVE_BUTTON = "IDS_SAVE_3DOT_BUTTON";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mDepVarList;
    private TargetVariableList mFactorList;
    private TargetVariableList mCovarList;
    private TargetVariableList mResWeightList;
    private Vector<Object> mTabOrder;
    private JButton mFixButton;
    private JButton mBootstrappingButton;
    private DialogDataModel mLinearDlgModel;
    private boolean mIsBootstrapOK;

    public MixedModelMainDlg(JFrame jFrame) {
        super(jFrame, false, AdvStatsResBundle.getDefaultResourceBundleName(), AdvStatsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_LINEAR_MIXED_MODEL_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mDepVarList.getModel()) {
            this.enableOkPaste(true);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        Object object = listDataEvent.getSource();
        if (object == this.mDepVarList.getModel()) {
            this.enableOkPaste(false);
        } else if (object == this.mFactorList.getModel() || object == this.mCovarList.getModel()) {
            this.validateDialogDataModel();
            if (object == this.mFactorList.getModel()) {
                this.enableBootstrappingButton();
            }
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void reset() {
        super.reset();
        this.mSrcVarList.loadFromActiveDataset();
        this.mDepVarList.removeAll();
        this.mFactorList.removeAll();
        this.mCovarList.removeAll();
        this.mResWeightList.removeAll();
        this.enableOkPaste(false);
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        MixedModelRandom.IS_MODEL_EMPTY = true;
        this.enableBootstrappingButton();
    }

    @Override
    protected boolean canBeRecalled() {
        return false;
    }

    @Override
    public String generateSyntax() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        boolean bl = false;
        DialogDataModel dialogDataModel2 = (DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY);
        if (this.mIsBootstrapOK && this.mBootstrappingButton.isEnabled() && dialogDataModel2 != null) {
            bl = true;
            String string = this.mDepVarList.getVariablesStringList();
            String string2 = this.mFactorList.getVariablesStringList() + " " + this.mCovarList.getVariablesStringList() + " " + this.mResWeightList.getVariablesStringList();
            stringBuffer.append(BootstrapDlg.getBootstrapSyntax(string, string2, dialogDataModel2));
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("MIXED"));
        boolean bl2 = false;
        if (this.mDepVarList.getModel().getSize() != 0) {
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mDepVarList.getVariablesStringList()));
            bl2 = true;
        }
        if (this.mFactorList.getModel().getSize() != 0) {
            if (bl2) {
                stringBuffer.append(" BY ").append(this.mFactorList.getVariablesStringList());
            } else {
                stringBuffer.append(SyntaxUtil.getMainCommandParamters("BY "));
                stringBuffer.append(this.mFactorList.getVariablesStringList());
                bl2 = true;
            }
        }
        if (this.mCovarList.getModel().getSize() != 0) {
            if (bl2) {
                stringBuffer.append(" WITH ").append(this.mCovarList.getVariablesStringList());
            } else {
                stringBuffer.append(SyntaxUtil.getMainCommandParamters("WITH "));
                stringBuffer.append(this.mCovarList.getVariablesStringList());
            }
        }
        stringBuffer.append("\n");
        stringBuffer.append(this.generateCriteriaSubCommand(dialogDataModel));
        stringBuffer.append(this.generateFixedDlgSyntax(dialogDataModel));
        stringBuffer.append(this.generateMethodSubCommand(dialogDataModel));
        stringBuffer.append(this.generatePrintSubCommand(dialogDataModel));
        stringBuffer.append(this.generateRandomDlgSyntax(dialogDataModel));
        stringBuffer.append(this.generateRegWgtSubCommand());
        stringBuffer.append(this.generateRepeatedSubCommand(this.mLinearDlgModel));
        stringBuffer.append(this.generateSaveSubCommand(dialogDataModel));
        stringBuffer.append(this.generateEMMeansDlgSyntax(dialogDataModel));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (bl) {
            stringBuffer.append(BootstrapDlg.getRestoreSyntax((DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY)));
        }
        return stringBuffer.toString();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_mixl";
    }

    @Override
    public String getIActionKey() {
        return "analyze_mixed";
    }

    @Override
    public boolean okPastePressed() {
        int n;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        if (!(this.mFactorList.getModel().getSize() <= 0 && this.mCovarList.getModel().getSize() <= 0 || dialogDataModel.getObject("FIXED_MODEL_LIST_ITEMS_KEY_") != null && ((LinkedHashSet)dialogDataModel.getObject("FIXED_MODEL_LIST_ITEMS_KEY_")).size() != 0 || !MixedModelRandom.IS_MODEL_EMPTY || (n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_NO_MODEL_DEFINED_MSG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION)) != 1)) {
            this.mFixButton.requestFocus();
            return false;
        }
        if (this.mIsBootstrapOK && this.mBootstrappingButton.isEnabled() && BootstrapDlg.isStrataVariableListEmpty(this)) {
            this.runSubDialog(new BootstrapDlg(this));
            return false;
        }
        String string = this.getResString("IDS_MIXED_MODE_LINEAR_TITLE");
        if (string.contains(":")) {
            string = string.substring(0, string.indexOf(58));
        }
        ProcedureDlgMgr.getMgr().addRecallItem(string, "analyze_mixed_linear");
        return true;
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
        this.enableBootstrappingButton();
    }

    public void validateDialogDataModel() {
        Object object;
        Object object2;
        Object[] objectArray;
        String string = this.mFactorList.getVariablesStringList();
        String string2 = this.mCovarList.getVariablesStringList();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        stringTokenizer = new StringTokenizer(string2, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector2.add(stringTokenizer.nextToken());
        }
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Vector<String> vector3 = new Vector<String>();
        LinkedHashSet linkedHashSet = (LinkedHashSet)dialogDataModel.getObject("FIXED_MODEL_LIST_ITEMS_KEY_");
        Object[] objectArray2 = objectArray = linkedHashSet == null ? null : linkedHashSet.toArray();
        if (objectArray != null) {
            Object[] objectArray3 = objectArray;
            int n = objectArray3.length;
            for (int i = 0; i < n; ++i) {
                Object object3 = objectArray3[i];
                String string3 = object3.toString();
                object2 = new StringTokenizer(string3, "*()");
                int n2 = ((StringTokenizer)object2).countTokens();
                for (int j = 0; j < n2 && (vector.contains(object = ((StringTokenizer)object2).nextToken()) || vector2.contains(object)); ++j) {
                    if (j < n2 - 1) continue;
                    vector3.add(string3);
                }
            }
            linkedHashSet.clear();
            linkedHashSet.addAll(vector3);
            dialogDataModel.putObject("FIXED_MODEL_LIST_ITEMS_KEY_", linkedHashSet);
        }
        if (vector3.isEmpty()) {
            vector3.add(OVERALL);
        }
        dialogDataModel.putArray("IDS_EMMEANS_SOURCE_LIST", vector3.toArray());
        object2 = new Vector();
        object = dialogDataModel.getArray("IDS_EMMEANS_TARGET_LIST");
        if (object != null) {
            for (Object object4 : object) {
                if (!vector3.contains(object4.toString())) continue;
                ((Vector)object2).add(object4.toString());
            }
            dialogDataModel.putArray("IDS_EMMEANS_TARGET_LIST", ((Vector)object2).toArray());
        }
    }

    @Override
    public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
        if ((variableList.getIdentifier().equals(DEP_VAR_TARGET_LIST_KEY) || variableList.getIdentifier().equals(RES_WEIGHT_TARGET_LIST_KEY)) && this.checkForSubjectVariable(iSpssVariableArray)) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_SUBJECT_VALUE_MSG"), VersionInfo.getAppVersionString());
            return false;
        }
        if ((variableList.getIdentifier().equals(DEP_VAR_TARGET_LIST_KEY) || variableList.getIdentifier().equals(RES_WEIGHT_TARGET_LIST_KEY)) && this.checkForRepeatedVariable()) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_REPEATED_VALUE_MSG"), VersionInfo.getAppVersionString());
            return false;
        }
        if ((variableList.getIdentifier().equals(DEP_VAR_TARGET_LIST_KEY) || variableList.getIdentifier().equals(RES_WEIGHT_TARGET_LIST_KEY)) && this.checkForKroneckerVariable()) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_KRONECKER_VALUE_MSG"), VersionInfo.getAppVersionString());
            return false;
        }
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.setTabPolicy();
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, FIXED_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MixedModelMainDlg.this.getDialogDataModel().putArray(MixedModelMainDlg.TARGET_LIST_KEY, MixedModelMainDlg.this.getTargetListElement().toArray());
                MixedModelMainDlg.this.runFixedSubDlg();
            }
        };
        this.mFixButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mFixButton);
        toggleButtonAction = new ToggleButtonAction(this, RANDOM_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ISpssVariable[] iSpssVariableArray = MixedModelMainDlg.this.mLinearDlgModel.getVarArray("SUBJECT_TARGET_LIST_KEY");
                MixedModelMainDlg.this.getDialogDataModel().putArray(MixedModelMainDlg.TARGET_LIST_KEY, MixedModelMainDlg.this.getTargetListElement().toArray());
                MixedModelMainDlg.this.getDialogDataModel().putVarArray(MixedModelMainDlg.MAIN_DIALOG_SUBJECT_TARGET_LIST_KEY, iSpssVariableArray);
                MixedModelMainDlg.this.runRandomSubDlg();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton);
        toggleButtonAction = new ToggleButtonAction(this, ESTIMATION_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MixedModelMainDlg.this.runEstimationSubDlg();
            }
        };
        JButton jButton2 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton2);
        toggleButtonAction = new ToggleButtonAction(STATISTICS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MixedModelMainDlg.this.runStatisticsSubDlg();
            }
        };
        JButton jButton3 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton3);
        toggleButtonAction = new ToggleButtonAction(this, EM_MEANS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MixedModelMainDlg.this.runEMMeansSubDlg();
            }
        };
        JButton jButton4 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton4);
        toggleButtonAction = new ToggleButtonAction(this, SAVE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MixedModelMainDlg.this.runSaveSubDlg();
            }
        };
        JButton jButton5 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton5);
        this.mIsBootstrapOK = false;
        if (VersionInfo.allowBootstrapping()) {
            this.mIsBootstrapOK = true;
            toggleButtonAction = new ToggleButtonAction("IDS_COMMON_BOOTSTRAPPING_BUTTON"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MixedModelMainDlg.this.runSubDialog(new BootstrapDlg(MixedModelMainDlg.this));
                }
            };
            this.mBootstrappingButton = new JButton(toggleButtonAction);
            this.addOptionsPanelButton(jPanel, this.mBootstrappingButton);
            if (BootstrapDlg.isCurrentDatasetInMIMode()) {
                this.mBootstrappingButton.setEnabled(false);
                this.mIsBootstrapOK = false;
            }
        }
        return jPanel;
    }

    private ArrayList<String> getTargetListElement() {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < this.mFactorList.getModel().getSize(); ++n) {
            arrayList.add(this.mFactorList.getModel().getElementAt(n).getName());
        }
        for (n = 0; n < this.mCovarList.getModel().getSize(); ++n) {
            arrayList.add(this.mCovarList.getModel().getElementAt(n).getName());
        }
        return arrayList;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        SpssVarFilter spssVarFilter = new SpssVarFilter(8, true, false);
        this.mDepVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mDepVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mDepVarList.getModel().addListDataListener(this);
        this.mDepVarList.setIdentifier(DEP_VAR_TARGET_LIST_KEY);
        this.mDepVarList.addVarFilter(spssVarFilter);
        this.mFactorList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mFactorList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mFactorList.getModel().addListDataListener(this);
        this.mFactorList.setIdentifier(FACTORS_TARGET_LIST_KEY);
        this.mCovarList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mCovarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mCovarList.getModel().addListDataListener(this);
        this.mCovarList.setIdentifier(COVARIATES_TARGET_LIST_KEY);
        this.mCovarList.addVarFilter(spssVarFilter);
        this.mResWeightList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mResWeightList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mResWeightList.getModel().addListDataListener(this);
        this.mResWeightList.setIdentifier(RES_WEIGHT_TARGET_LIST_KEY);
        this.mResWeightList.addVarFilter(spssVarFilter);
        this.mTabOrder = new Vector();
        this.mLinearDlgModel = new DialogDataModel();
        ProcedureDlgMgr.getMgr().loadPersistentState("analyze_mixed_linear", this.mLinearDlgModel);
    }

    private StringBuffer generateCriteriaSubCommand(DialogDataModel dialogDataModel) {
        Boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(UIToolResUtil.getSPSSLocale());
        stringBuffer.append(SyntaxUtil.getSubCommand("/CRITERIA="));
        Boolean bl2 = dialogDataModel.getBoolean("IDS_SATTER_RADIO_BUTTON");
        if (bl2 == null || bl2.booleanValue()) {
            stringBuffer.append("DFMETHOD(SATTERTHWAITE)");
        } else {
            bl2 = dialogDataModel.getBoolean("IDS_RESIDUAL_RADIO_BUTTON");
            if (bl2.booleanValue()) {
                stringBuffer.append("DFMETHOD(RESIDUAL)");
            } else {
                stringBuffer.append("DFMETHOD(KENWARDROGER)");
            }
        }
        String string = dialogDataModel.getString("IDS_CONFIDENCE_INTERVAL");
        string = null == string ? "95" : string;
        stringBuffer.append(" CIN(").append(string).append(")");
        string = dialogDataModel.getString("IDS_MAX_ITERATION_TEXT");
        string = null == string ? "100" : string;
        stringBuffer.append(" MXITER(").append(string).append(")");
        string = dialogDataModel.getString("IDS_MAX_STEP_HALV_TEXT");
        string = null == string ? "10" : string;
        stringBuffer.append(" MXSTEP(").append(string).append(")");
        string = dialogDataModel.getString("IDS_MAX_SCORING_STEPS");
        string = null == string ? "1" : string;
        stringBuffer.append(" SCORING(").append(string).append(")");
        String string2 = dialogDataModel.getString("IDS_SINGULARITY_TOLERANCE");
        String string3 = string2 = null == string2 ? "0.000000000001" : string2;
        if (string2.indexOf(decimalFormatSymbols.getDecimalSeparator()) != -1) {
            string2 = string2.replace(decimalFormatSymbols.getDecimalSeparator(), '.');
        }
        stringBuffer.append(" SINGULAR(").append(string2).append(")");
        string2 = dialogDataModel.getString("IDS_VALUE_HC");
        String string4 = string2 = null == string2 ? "0" : string2;
        if (string2.indexOf(decimalFormatSymbols.getDecimalSeparator()) != -1) {
            string2 = string2.replace(decimalFormatSymbols.getDecimalSeparator(), '.');
        }
        if ((bl = dialogDataModel.getBoolean("IDS_ABSOLUTE_HC_RADIO")) == null || bl.booleanValue()) {
            stringBuffer.append(" HCONVERGE(").append(string2).append(", ABSOLUTE)");
        } else {
            stringBuffer.append(" HCONVERGE(").append(string2).append(", RELATIVE)");
        }
        string2 = dialogDataModel.getString("IDS_VALUE_LLC");
        String string5 = string2 = null == string2 ? "0" : string2;
        if (string2.indexOf(decimalFormatSymbols.getDecimalSeparator()) != -1) {
            string2 = string2.replace(decimalFormatSymbols.getDecimalSeparator(), '.');
        }
        if ((bl = dialogDataModel.getBoolean("IDS_ABSOLUTE_LLC_RADIO")) == null || bl.booleanValue()) {
            stringBuffer.append(" LCONVERGE(").append(string2).append(", ABSOLUTE)");
        } else {
            stringBuffer.append(" LCONVERGE(").append(string2).append(", RELATIVE)");
        }
        string2 = dialogDataModel.getString("IDS_VALUE_PC");
        String string6 = string2 = null == string2 ? "0.000001" : string2;
        if (string2.indexOf(decimalFormatSymbols.getDecimalSeparator()) != -1) {
            string2 = string2.replace(decimalFormatSymbols.getDecimalSeparator(), '.');
        }
        if ((bl = dialogDataModel.getBoolean("IDS_ABSOLUTE_PC_RADIO")) == null || bl.booleanValue()) {
            stringBuffer.append(" PCONVERGE(").append(string2).append(", ABSOLUTE)");
        } else {
            stringBuffer.append(" PCONVERGE(").append(string2).append(", RELATIVE)");
        }
        return stringBuffer.append("\n");
    }

    private StringBuffer generateRegWgtSubCommand() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.mResWeightList.getModel().getSize() != 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/REGWGT="));
            stringBuffer.append(this.mResWeightList.getVariablesStringList());
        }
        return stringBuffer;
    }

    private String generateMethodSubCommand(DialogDataModel dialogDataModel) {
        String string = "";
        Boolean bl = dialogDataModel.getBoolean("IDS_REML_RADIO_BUTTON");
        string = string + "\n";
        string = bl == null || bl != false ? string + SyntaxUtil.getSubCommand("/METHOD=REML") : string + SyntaxUtil.getSubCommand("/METHOD=ML");
        return string;
    }

    private String generateSaveSubCommand(DialogDataModel dialogDataModel) {
        String string = "";
        String string2 = "";
        HashMap<String, String> hashMap = this.getSaveCheckMap();
        for (Map.Entry<String, String> entry : hashMap.entrySet()) {
            Boolean bl = dialogDataModel.getBoolean(entry.getKey());
            if (bl == null || !bl.booleanValue()) continue;
            string2 = string2 + entry.getValue() + " ";
        }
        if ((string2 = string2.trim()).length() > 0) {
            string = string + "\n";
            string = string + SyntaxUtil.getSubCommand("/SAVE=");
            string = string + string2;
        }
        return string;
    }

    private String generatePrintSubCommand(DialogDataModel dialogDataModel) {
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        Boolean bl = dialogDataModel.getBoolean("IDS_PRINT_ITER_HISTORY");
        if (bl != null && bl.booleanValue()) {
            stringBuffer2.append("HISTORY").append("(").append(dialogDataModel.getString("IDS_STEPS")).append(")");
        }
        int n = 0;
        HashMap<String, String> hashMap = this.getPrintCheckMap();
        for (Map.Entry<String, String> entry : hashMap.entrySet()) {
            if (n == 5) {
                stringBuffer.append(stringBuffer2).append(" ");
            }
            if ((bl = dialogDataModel.getBoolean(entry.getKey())) != null && bl.booleanValue()) {
                stringBuffer.append(entry.getValue()).append(" ");
            }
            ++n;
        }
        String string2 = stringBuffer.toString().trim();
        if (string2.length() > 0) {
            string = string + "\n";
            string = string + SyntaxUtil.getSubCommand("/PRINT=");
            string = string + (String)string2;
        }
        return string;
    }

    private StringBuffer generateRepeatedSubCommand(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getListVarAsString(dialogDataModel.getVarArray("TARGET_VARIABLE_LIST_KEY_SOMETHING"), '*').toString();
        if (!string.trim().equals("")) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/REPEATED="));
            stringBuffer.append(string);
            stringBuffer.append(" |");
            string = this.getListVarAsString(dialogDataModel.getVarArray("KRONECKER_VARIABLE_LIST_KEY"), '*').toString();
            if (!string.trim().equals("")) {
                stringBuffer.append(" KRONECKER");
                stringBuffer.append("(");
                stringBuffer.append(string);
                stringBuffer.append(")");
            }
            if (!(string = this.getListVarAsString(dialogDataModel.getVarArray("SUBJECT_VARIABLE_LIST_KEY"), '*').toString()).trim().equals("")) {
                stringBuffer.append(" SUBJECT");
                stringBuffer.append("(");
                stringBuffer.append(string);
                stringBuffer.append(")");
            }
            stringBuffer.append(" COVTYPE(");
            stringBuffer.append(this.getCovariateValue(false).get(dialogDataModel.getInteger("IDS_REP_COVAR_TYPE")));
            stringBuffer.append(")");
            String string2 = this.getListVarAsString(dialogDataModel.getVarArray("TARGET_SPATIAL_VARIABLE_LIST_KEY"), ' ').toString();
            if (string2.trim().length() > 0) {
                stringBuffer.append(" SPCOORDS(");
                stringBuffer.append(string2);
                stringBuffer.append(")");
            }
        }
        return stringBuffer;
    }

    private StringBuffer generateFixedDlgSyntax(DialogDataModel dialogDataModel) {
        Serializable serializable;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SyntaxUtil.getSubCommand("/FIXED="));
        Boolean bl = dialogDataModel.getBoolean("IDS_INCLUDE_INTERCEPTS");
        if (dialogDataModel.getObject("FIXED_MODEL_LIST_ITEMS_KEY_") != null) {
            Object[] objectArray;
            serializable = (LinkedHashSet)dialogDataModel.getObject("FIXED_MODEL_LIST_ITEMS_KEY_");
            for (Object object : objectArray = ((HashSet)serializable).toArray()) {
                stringBuffer.append(object).append(" ");
            }
        }
        stringBuffer.append("|");
        if (bl != null && !bl.booleanValue()) {
            stringBuffer.append(" NOINT");
        }
        if (null != (serializable = dialogDataModel.getInteger("IDS_SUM_OF_SQUARES")) && (Integer)serializable == 0) {
            stringBuffer.append(" SSTYPE(1)");
        } else {
            stringBuffer.append(" SSTYPE(3)");
        }
        return stringBuffer;
    }

    private StringBuffer generateRandomDlgSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 1; i <= 8; ++i) {
            String string;
            ISpssVariable[] iSpssVariableArray;
            boolean bl = false;
            Boolean bl2 = dialogDataModel.getBoolean("RAND_INCLUDE_INTERCEPT_LAYER_KEY_" + i);
            if (null == bl2) break;
            stringBuffer2.setLength(0);
            stringBuffer2.append("\n");
            stringBuffer2.append(SyntaxUtil.getSubCommand("/RANDOM="));
            if (bl2.booleanValue()) {
                bl = true;
                stringBuffer2.append("INTERCEPT ");
            }
            this.ensureVarsConsistent(dialogDataModel, this.mFactorList, this.mCovarList, i);
            Object[] objectArray = dialogDataModel.getArray("RAND_MODEL_LAYER_KEY_" + i);
            int n = objectArray.length;
            for (int j = 0; j < n; ++j) {
                if (!bl) {
                    bl = true;
                }
                stringBuffer2.append(objectArray[j]).append(" ");
            }
            stringBuffer2.append("| ");
            if (this.mLinearDlgModel != null && (iSpssVariableArray = this.mLinearDlgModel.getVarArray("SUBJECT_TARGET_LIST_KEY")).length > 0 && !(string = this.getListVarAsString(dialogDataModel.getVarArray("RAND_COMBINATION_LAYER_KEY_" + i), '*').toString()).trim().equals("")) {
                stringBuffer2.append("SUBJECT(").append(string);
                stringBuffer2.append(") ");
            }
            stringBuffer2.append("COVTYPE(").append(this.getCovariateValue(true).get(dialogDataModel.getInteger("RAND_COVARIANCE_TYPE_LAYER_KEY_" + i))).append(")");
            Boolean bl3 = dialogDataModel.getBoolean("RAND_DISPLAY_PARAM_LAYER_KEY_" + i);
            if (bl3.booleanValue()) {
                stringBuffer2.append(" SOLUTION");
            }
            if (!bl) continue;
            stringBuffer.append(stringBuffer2);
        }
        return stringBuffer;
    }

    private void ensureVarsConsistent(DialogDataModel dialogDataModel, TargetVariableList targetVariableList, TargetVariableList targetVariableList2, int n) {
        int n2;
        int n3;
        HashSet<String> hashSet = new HashSet<String>();
        if (targetVariableList != null) {
            n3 = targetVariableList.getModel().getSize();
            for (n2 = 0; n2 < n3; ++n2) {
                hashSet.add(targetVariableList.getModel().getElementAt(n2).getName());
            }
        }
        if (targetVariableList2 != null) {
            n3 = targetVariableList2.getModel().getSize();
            for (n2 = 0; n2 < n3; ++n2) {
                hashSet.add(targetVariableList2.getModel().getElementAt(n2).getName());
            }
        }
        if (targetVariableList != null && targetVariableList2 != null) {
            Object[] objectArray = dialogDataModel.getArray("RAND_MODEL_LAYER_KEY_" + n);
            ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList(objectArray));
            ArrayList<Object> arrayList2 = new ArrayList<Object>(Arrays.asList(objectArray));
            int n4 = arrayList.size();
            for (int i = n4 - 1; i >= 0; --i) {
                Object object = arrayList.get(i);
                if (!(object instanceof String)) continue;
                String string = (String)object;
                Set<String> set = MixedModelMainDlg.parseTermString(string);
                set.removeAll(hashSet);
                if (set.size() <= 0) continue;
                arrayList2.remove(string);
            }
            if (n4 > 0) {
                dialogDataModel.putArray("RAND_MODEL_LAYER_KEY_" + n, arrayList2.toArray());
            }
        }
    }

    private static Set<String> parseTermString(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "*()");
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        return hashSet;
    }

    private StringBuffer generateEMMeansDlgSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = dialogDataModel.getArray("IDS_EMMEANS_TARGET_LIST");
        if (null != objectArray) {
            boolean bl = dialogDataModel.getBoolean("IDS_COMPARE_MAIN_EFFECTS");
            String string = this.getEMMeansValue(dialogDataModel.getInteger("IDS_CONFIDENCE_INTERVAL_ADJUST"));
            Object[] objectArray2 = dialogDataModel.getArray("EMMEANS_RADIO_VALUES_KEY");
            Object[] objectArray3 = dialogDataModel.getArray("EMMEANS_CUSTOM_VALUES_KEY");
            int n = 0;
            int n2 = 0;
            for (Object object : objectArray) {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/EMMEANS=TABLES"));
                boolean bl2 = object.equals(OVERALL);
                if (bl2) {
                    stringBuffer.append(object);
                } else {
                    stringBuffer.append("(");
                    stringBuffer.append(object);
                    stringBuffer.append(") ");
                }
                if (bl && !bl2 && -1 == ((String)object).indexOf(42)) {
                    Integer n3 = (Integer)objectArray2[n];
                    stringBuffer.append("COMPARE ");
                    if (n3 > 1) {
                        stringBuffer.append("REFCAT(");
                        if (4 == n3) {
                            stringBuffer.append(objectArray3[n2++]);
                        } else {
                            stringBuffer.append(this.getEMMeansRadioValue(n3));
                        }
                        stringBuffer.append(") ");
                    }
                    stringBuffer.append("ADJ(").append(string);
                    stringBuffer.append(")");
                }
                ++n;
            }
        }
        return stringBuffer;
    }

    private String getEMMeansRadioValue(Integer n) {
        switch (n) {
            case 1: {
                return "NONE";
            }
            case 2: {
                return "FIRST";
            }
            case 3: {
                return "LAST";
            }
        }
        return null;
    }

    private StringBuffer getListVarAsString(Object[] objectArray, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != objectArray) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                if (i != n - 1) {
                    stringBuffer.append(((ISpssVariable)objectArray[i]).getName()).append(c);
                    continue;
                }
                stringBuffer.append(((ISpssVariable)objectArray[i]).getName());
            }
        }
        return stringBuffer;
    }

    private void setupViewPanel(JPanel jPanel) {
        JLabel jLabel = DialogUtil.createLabel(this, DEP_VAR_TARGET_LIST_KEY);
        jLabel.setLabelFor(this.mDepVarList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_FACTOR");
        jLabel2.setLabelFor(this.mFactorList);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_COVARIATE");
        jLabel3.setLabelFor(this.mCovarList);
        JLabel jLabel4 = DialogUtil.createLabel(this, RES_WEIGHT_TARGET_LIST_KEY);
        jLabel4.setLabelFor(this.mResWeightList);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mSrcVarList.setSelectedIndex(0);
        JLabel jLabel5 = DialogUtil.createLabel(this, "IDS_MIXED_MODE_LINEAR_SOURCE_LIST_LABEL");
        jLabel5.setLabelFor(this.mSrcVarList);
        JScrollPane jScrollPane2 = new JScrollPane(this.mDepVarList);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setVerticalScrollBarPolicy(21);
        jScrollPane2.setPreferredSize(this.mDepVarList.getMinimumSize());
        JScrollPane jScrollPane3 = new JScrollPane(this.mFactorList);
        jScrollPane3.setPreferredSize(this.mFactorList.getMinimumSize());
        JScrollPane jScrollPane4 = new JScrollPane(this.mCovarList);
        jScrollPane4.setPreferredSize(this.mCovarList.getMinimumSize());
        JScrollPane jScrollPane5 = new JScrollPane(this.mResWeightList);
        jScrollPane5.setHorizontalScrollBarPolicy(31);
        jScrollPane5.setVerticalScrollBarPolicy(21);
        jScrollPane5.setPreferredSize(this.mResWeightList.getMinimumSize());
        ArrowButton arrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        arrowButton.setVarMoveHandler(this);
        arrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        arrowButton.registerVariableList(this.mDepVarList, SpssArrowButton.ButtonOrientation.left);
        ArrowButton arrowButton2 = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        arrowButton2.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        arrowButton2.registerVariableList(this.mFactorList, SpssArrowButton.ButtonOrientation.left);
        ArrowButton arrowButton3 = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        arrowButton3.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        arrowButton3.registerVariableList(this.mCovarList, SpssArrowButton.ButtonOrientation.left);
        ArrowButton arrowButton4 = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        arrowButton4.setVarMoveHandler(this);
        this.mVarMoveHandler = this;
        arrowButton4.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        arrowButton4.registerVariableList(this.mResWeightList, SpssArrowButton.ButtonOrientation.left);
        this.mTabOrder.add(this.mSrcVarList);
        this.mTabOrder.add(arrowButton);
        this.mTabOrder.add(arrowButton2);
        this.mTabOrder.add(arrowButton3);
        this.mTabOrder.add(arrowButton4);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel5, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = DialogUtil.getArrowButtonInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(0, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 9, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 20;
        DialogUtil.addUsingGBL(jPanel, arrowButton, gridBagConstraints, 1, 0, 1, 2, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 1, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, arrowButton2, gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        Insets insets3 = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 2, 1, 1, n, insets3);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane3, gridBagConstraints, 2, 3, 1, 1, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, arrowButton3, gridBagConstraints, 1, 5, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 4, 1, 1, n, insets3);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane4, gridBagConstraints, 2, 5, 1, 1, n, null);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, arrowButton4, gridBagConstraints, 1, 6, 1, 2, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 2, 6, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, jScrollPane5, gridBagConstraints, 2, 7, 1, 1, n, null);
    }

    VariableList getFactorsList() {
        return this.mFactorList;
    }

    VariableList getCovariatesList() {
        return this.mCovarList;
    }

    private void runFixedSubDlg() {
        this.runSubDialog(new MixedModelFixed(this));
    }

    private void runRandomSubDlg() {
        this.runSubDialog(new MixedModelRandom(this));
        this.enableBootstrappingButton();
    }

    private void runEstimationSubDlg() {
        this.runSubDialog(new MixedModelEstimation(this));
    }

    private void runStatisticsSubDlg() {
        this.runSubDialog(new MixedModelStats(this));
    }

    private void runSaveSubDlg() {
        this.runSubDialog(new MixedModelSave(this));
    }

    private void runEMMeansSubDlg() {
        this.runSubDialog(new MixedModelEMMeans(this));
    }

    private void setTabPolicy() {
        int n;
        this.mTabOrder.add(this.mDepVarList);
        this.mTabOrder.add(this.mFactorList);
        this.mTabOrder.add(this.mCovarList);
        this.mTabOrder.add(this.mResWeightList);
        int n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            if (!(this.mOptionButtonPanel.getComponent(n) instanceof JButton)) continue;
            this.mTabOrder.add(this.mOptionButtonPanel.getComponent(n));
        }
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.mTabOrder.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mTabOrder, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private boolean checkForSubjectVariable(ISpssVariable[] iSpssVariableArray) {
        boolean bl = false;
        if (this.mLinearDlgModel != null) {
            ISpssVariable[] iSpssVariableArray2 = this.mLinearDlgModel.getVarArray("SUBJECT_TARGET_LIST_KEY");
            int n = iSpssVariableArray.length;
            if (null != iSpssVariableArray2) {
                block0: for (int i = 0; !bl && i < n; ++i) {
                    ISpssVariable iSpssVariable = iSpssVariableArray[i];
                    for (ISpssVariable iSpssVariable2 : iSpssVariableArray2) {
                        if (!iSpssVariable.getId().equals((Object)iSpssVariable2.getId())) continue;
                        bl = true;
                        continue block0;
                    }
                }
            }
        }
        return bl;
    }

    private boolean checkForRepeatedVariable() {
        boolean bl = false;
        if (this.mLinearDlgModel != null) {
            ISpssVariable[] iSpssVariableArray = this.mLinearDlgModel.getVarArray("REPEATED_TARGET_LIST_KEY");
            ISpssVariable[] iSpssVariableArray2 = this.mSrcVarList.getSelectedValues();
            int n = iSpssVariableArray2.length;
            if (null != iSpssVariableArray) {
                block0: for (int i = 0; !bl && i < n; ++i) {
                    ISpssVariable iSpssVariable = iSpssVariableArray2[i];
                    for (ISpssVariable iSpssVariable2 : iSpssVariableArray) {
                        if (!iSpssVariable.getId().equals((Object)iSpssVariable2.getId())) continue;
                        bl = true;
                        continue block0;
                    }
                }
            }
        }
        return bl;
    }

    private boolean checkForKroneckerVariable() {
        boolean bl = false;
        if (this.mLinearDlgModel != null) {
            ISpssVariable[] iSpssVariableArray = this.mLinearDlgModel.getVarArray("KRONECKER_TARGET_LIST_KEY");
            ISpssVariable[] iSpssVariableArray2 = this.mSrcVarList.getSelectedValues();
            int n = iSpssVariableArray2.length;
            if (null != iSpssVariableArray) {
                block0: for (int i = 0; !bl && i < n; ++i) {
                    ISpssVariable iSpssVariable = iSpssVariableArray2[i];
                    for (ISpssVariable iSpssVariable2 : iSpssVariableArray) {
                        if (!iSpssVariable.getId().equals((Object)iSpssVariable2.getId())) continue;
                        bl = true;
                        continue block0;
                    }
                }
            }
        }
        return bl;
    }

    private HashMap<String, String> getSaveCheckMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("IDS_FIXED_PREDICTED_VALUE", "FIXPRED");
        linkedHashMap.put("IDS_FIXED_STAND_ERROR", "SEFIXP");
        linkedHashMap.put("IDS_FIXED_FREEDOM_DEGREE", "DFFIXP");
        linkedHashMap.put("IDS_RESIDUAL_PREDICTED_VALUE", "PRED");
        linkedHashMap.put("IDS_RESIDUAL_STAND_ERROR", "SEPRED");
        linkedHashMap.put("IDS_RESIDUAL_FREEDOM_DEGREE", "DFPRED");
        linkedHashMap.put("IDS_RESIDUAL", "RESID");
        return linkedHashMap;
    }

    private HashMap<String, String> getPrintCheckMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("IDS_CASE_PROCESS_SUMMARY", "CPS");
        linkedHashMap.put("IDS_COREL_PARAM_ESTIMATE", "CORB");
        linkedHashMap.put("IDS_COVAR_PARAM_ESTIMATE", "COVB");
        linkedHashMap.put("IDS_DESC_STATS", "DESCRIPTIVES");
        linkedHashMap.put("IDS_COVAR_RANDOM_EFFECT", "G");
        linkedHashMap.put("IDS_CONTRAST_COFF_MTRX", "LMATRIX");
        linkedHashMap.put("IDS_COVAR_RESIDUAL", "R");
        linkedHashMap.put("IDS_PARAM_ESTIMATE", "SOLUTION");
        linkedHashMap.put("IDS_TEST_COVAR_PARAM", "TESTCOV");
        return linkedHashMap;
    }

    private HashMap<Integer, String> getCovariateValue(boolean bl) {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        int n = 0;
        if (bl) {
            hashMap.put(n++, "VC");
        }
        hashMap.put(n++, "AD1");
        hashMap.put(n++, "AR1");
        hashMap.put(n++, "ARH1");
        hashMap.put(n++, "ARMA1");
        hashMap.put(n++, "CS");
        hashMap.put(n++, "CSR");
        hashMap.put(n++, "CSH");
        hashMap.put(n++, "DIAG");
        hashMap.put(n++, "UN_AR1");
        hashMap.put(n++, "UN_UN");
        hashMap.put(n++, "UN_CS");
        hashMap.put(n++, "FA1");
        hashMap.put(n++, "FAH1");
        hashMap.put(n++, "HF");
        hashMap.put(n++, "ID");
        hashMap.put(n++, "TP");
        hashMap.put(n++, "TPH");
        hashMap.put(n++, "UN");
        hashMap.put(n++, "UNR");
        hashMap.put(n++, "SP_POWER");
        hashMap.put(n++, "SP_EXPONENTIAL");
        hashMap.put(n++, "SP_GAUSSIAN");
        hashMap.put(n++, "SP_LINEAR");
        hashMap.put(n++, "SP_LINEARLOG");
        hashMap.put(n, "SP_SPHERICAL");
        return hashMap;
    }

    private String getEMMeansValue(int n) {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, "LSD");
        hashMap.put(1, "BONFERRONI");
        hashMap.put(2, "SIDAK");
        return (String)hashMap.get(n);
    }

    private void enableBootstrappingButton() {
        if (this.mBootstrappingButton != null && this.mIsBootstrapOK) {
            DialogDataModel dialogDataModel = this.getDialogDataModel();
            if (dialogDataModel == null && this.mLinearDlgModel == null) {
                return;
            }
            ISpssVariable[] iSpssVariableArray = null;
            if (this.mLinearDlgModel != null) {
                iSpssVariableArray = this.mLinearDlgModel.getVarArray("TARGET_VARIABLE_LIST_KEY_SOMETHING");
            }
            boolean bl = false;
            if (dialogDataModel != null) {
                Object[] objectArray;
                Boolean bl2;
                for (int i = 1; !(i > 8 || null != (bl2 = dialogDataModel.getBoolean("RAND_INCLUDE_INTERCEPT_LAYER_KEY_" + i)) && (objectArray = dialogDataModel.getArray("RAND_MODEL_LAYER_KEY_" + i)) != null && objectArray.length > 0 && (bl = this.containAFactor(objectArray))); ++i) {
                }
            }
            if (iSpssVariableArray != null && iSpssVariableArray.length > 0 || bl) {
                this.mBootstrappingButton.setEnabled(false);
            } else {
                this.mBootstrappingButton.setEnabled(true);
            }
        }
    }

    private boolean containAFactor(Object[] objectArray) {
        boolean bl = false;
        for (Object object : objectArray) {
            if (this.mFactorList.getModel().findElementIndexesByName((String)object).length <= 0) continue;
            return true;
        }
        return bl;
    }
}

