/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.mixed_models;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.adv_stats.res.AdvStatsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.ProcedureAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.doc_util.ProcedureDialogLoader;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.util.TraceSettings;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class MixedModelLinearDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener {
    static final String SOURCE_LIST_KEY = "SOURCE_LIST_KEY";
    static final String SUBJECT_TARGET_LIST_KEY = "SUBJECT_TARGET_LIST_KEY";
    static final String SUBJECT_VARIABLE_LIST_KEY = "SUBJECT_VARIABLE_LIST_KEY";
    static final String REPEATED_TARGET_LIST_KEY = "REPEATED_TARGET_LIST_KEY";
    static final String KRONECKER_TARGET_LIST_KEY = "KRONECKER_TARGET_LIST_KEY";
    static final String SPATIAL_TARGET_LIST_KEY = "SPATIAL_TARGET_LIST_KEY";
    static final String REPEATED_VARIABLE_LIST_KEY = "TARGET_VARIABLE_LIST_KEY_SOMETHING";
    static final String SPATIAL_VARIABLE_LIST_KEY = "TARGET_SPATIAL_VARIABLE_LIST_KEY";
    static final String KRONECKER_VARIABLE_LIST_KEY = "KRONECKER_VARIABLE_LIST_KEY";
    static final String CO_VAR_COMBO = "IDS_REP_COVAR_TYPE";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetSubVarList;
    private TargetVariableList mTargetRepVarList;
    private TargetVariableList mTargetKronVarList;
    private TargetVariableList mTargetSpatialVarList;
    private JComboBox mCoVarCombo;
    private Vector<Object> mTabOrder;
    private DialogDataModel mMainDlgModel;
    private MixedModelLinearVarMoveHandler mVarMoveHandler;
    private ArrowButton mSpatialArrowButton;
    private ArrowButton mKronArrowButton;

    public MixedModelLinearDlg(JFrame jFrame) {
        super(jFrame, false, AdvStatsResBundle.getDefaultResourceBundleName(), AdvStatsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_MIXED_MODE_LINEAR_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_mixi";
    }

    @Override
    public String getIActionKey() {
        return "analyze_mixed_linear";
    }

    @Override
    public String generateSyntax() {
        return null;
    }

    @Override
    protected boolean canBeRecalled() {
        return false;
    }

    @Override
    public void reset() {
        super.reset();
        this.clearModel();
        this.mTargetSubVarList.removeAll();
        this.mTargetRepVarList.removeAll();
        this.mTargetKronVarList.removeAll();
        this.mTargetSpatialVarList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mCoVarCombo.setSelectedItem(this.getResString("IDS_DIAGONAL"));
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        boolean bl = this.mTargetRepVarList.getModel().getSize() > 0;
        this.mCoVarCombo.setEnabled(bl);
        if (bl && this.isSpatialCovType()) {
            this.mTargetSpatialVarList.setEnabled(true);
            if (this.mSrcVarList.getSelectedIndex() >= 0 || this.mTargetSpatialVarList.getSelectedIndex() > 0) {
                this.mSpatialArrowButton.setEnabled(true);
            } else {
                this.mSpatialArrowButton.setEnabled(false);
            }
        } else {
            this.mTargetSpatialVarList.setEnabled(false);
            this.mSpatialArrowButton.setEnabled(false);
        }
        if (bl && this.isKroneckerType()) {
            this.mTargetKronVarList.setEnabled(true);
            if (this.mSrcVarList.getSelectedIndex() >= 0 || this.mTargetKronVarList.getSelectedIndex() > 0) {
                this.mKronArrowButton.setEnabled(true);
            } else {
                this.mKronArrowButton.setEnabled(false);
            }
        } else {
            this.mTargetKronVarList.setEnabled(false);
            this.mKronArrowButton.setEnabled(false);
        }
        this.enableContinue();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        boolean bl = this.mTargetRepVarList.getModel().getSize() > 0;
        this.mCoVarCombo.setEnabled(bl);
        if (bl && this.isSpatialCovType()) {
            this.mTargetSpatialVarList.setEnabled(true);
            if (this.mSrcVarList.getSelectedIndex() >= 0 || this.mTargetSpatialVarList.getSelectedIndex() > 0) {
                this.mSpatialArrowButton.setEnabled(true);
            } else {
                this.mSpatialArrowButton.setEnabled(false);
            }
        } else {
            this.mTargetSpatialVarList.setEnabled(false);
            this.mSpatialArrowButton.setEnabled(false);
        }
        if (bl && this.isKroneckerType()) {
            this.mTargetKronVarList.setEnabled(true);
            if (this.mSrcVarList.getSelectedIndex() >= 0 || this.mTargetKronVarList.getSelectedIndex() > 0) {
                this.mKronArrowButton.setEnabled(true);
            } else {
                this.mKronArrowButton.setEnabled(false);
            }
        } else {
            this.mTargetKronVarList.setEnabled(false);
            this.mKronArrowButton.setEnabled(false);
        }
        this.enableContinue();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.mCoVarCombo.setEnabled(this.mTargetRepVarList.getModel().getSize() > 0);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mCoVarCombo && itemEvent.getStateChange() == 1) {
            if (this.isSpatialCovType()) {
                this.mTargetSpatialVarList.setEnabled(true);
                if (this.mSrcVarList.getSelectedIndex() >= 0 || this.mTargetSpatialVarList.getSelectedIndex() > 0) {
                    this.mSpatialArrowButton.setEnabled(true);
                } else {
                    this.mSpatialArrowButton.setEnabled(false);
                }
            } else {
                this.mTargetSpatialVarList.setEnabled(false);
                this.mSpatialArrowButton.setEnabled(false);
            }
            if (this.isKroneckerType()) {
                this.mTargetKronVarList.setEnabled(true);
                if (this.mSrcVarList.getSelectedIndex() >= 0 || this.mTargetKronVarList.getSelectedIndex() > 0) {
                    this.mKronArrowButton.setEnabled(true);
                } else {
                    this.mKronArrowButton.setEnabled(false);
                }
            } else {
                this.mTargetKronVarList.setEnabled(false);
                this.mKronArrowButton.setEnabled(false);
            }
        }
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupLists(jPanel);
        this.mSrcVarList.setSelectedIndex(0);
        this.enableContinue();
        this.setTabPolicy();
        this.pack();
    }

    @Override
    protected boolean okPastePressed() {
        boolean bl = this.doValidation();
        if (!bl) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERROR_MIXED_SPATIAL_LIST_EMPTY"), VersionInfo.getAppVersionString());
            return false;
        }
        if (!this.doKronValidation()) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERROR_KRONECKER_LIST_EMPTY"), VersionInfo.getAppVersionString());
            return false;
        }
        MixedModelLinearDlg.saveState(this.getDialogDataModel(), (Container)((Object)this));
        this.saveVariables();
        if (this.mTargetKronVarList.isEnabled() && this.isSameVars()) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERROR_REPEATED_KRONECKER_LIST_SAME"), VersionInfo.getAppVersionString());
            return false;
        }
        ProcedureDlgMgr.getMgr().savePersistentState(this.getIActionKey(), this.getDialogDataModel());
        ProcedureAction procedureAction = (ProcedureAction)ActionCatalog.getActionCatalog().getSpssAction("analyze_mixed");
        ProcedureDialogLoader.showDialog(procedureAction, (JFrame)this.getParent());
        this.setVisible(false);
        return true;
    }

    @Override
    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = super.setupCmdButtonPanel();
        jPanel.remove(this.getPasteButton());
        this.getOkButton().setText(ResUtil.getCommonDlgString("IDS_CONTINUE"));
        this.getRootPane().setDefaultButton(this.getOkButton());
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void enableContinue() {
        boolean bl = true;
        if (this.mTargetRepVarList.getModel().getSize() > 0 && this.mTargetSubVarList.getModel().getSize() == 0) {
            bl = false;
        }
        this.getOkButton().setEnabled(bl);
    }

    private void initVars() {
        this.mVarMoveHandler = new MixedModelLinearVarMoveHandler(this);
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mTargetSpatialVarList = new TargetVariableList();
        this.mTargetSpatialVarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mSpatialArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mSpatialArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mSpatialArrowButton.registerVariableList(this.mTargetSpatialVarList, SpssArrowButton.ButtonOrientation.left);
        this.mTargetKronVarList = new TargetVariableList();
        this.mTargetKronVarList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mKronArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mKronArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mKronArrowButton.registerVariableList(this.mTargetKronVarList, SpssArrowButton.ButtonOrientation.left);
        this.mKronArrowButton.setVarMoveHandler(this.mVarMoveHandler);
        VersionInfo versionInfo = new VersionInfo();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getResString("IDS_ANTE_DEP"));
        arrayList.add(this.getResString("IDS_AR_1"));
        arrayList.add(this.getResString("IDS_AR_1_HETR"));
        arrayList.add(this.getResString("IDS_ARMA_1_1"));
        arrayList.add(this.getResString("IDS_COMP_SYM"));
        arrayList.add(this.getResString("IDS_COMP_SYM_COR_METX"));
        arrayList.add(this.getResString("IDS_COMP_SYM_HETR"));
        arrayList.add(this.getResString("IDS_DIAGONAL"));
        arrayList.add(this.getResString("IDS_DIRECT_AR1"));
        arrayList.add(this.getResString("IDS_DIRECT_UN"));
        arrayList.add(this.getResString("IDS_DIRECT_CS"));
        arrayList.add(this.getResString("IDS_FACTOR_ANA_FIRST_ORDER"));
        arrayList.add(this.getResString("IDS_FACTOR_ANA_FIRST_ORDER_HETR"));
        arrayList.add(this.getResString("IDS_HUYNCH"));
        arrayList.add(this.getResString("IDS_SCALED_IDENTITY"));
        arrayList.add(this.getResString("IDS_TOEPLITZ"));
        arrayList.add(this.getResString("IDS_TOEPLITZ_HETR"));
        arrayList.add(this.getResString("IDS_UNSTRUCTURED"));
        arrayList.add(this.getResString("IDS_UNSTRUCTURED_COR_METX"));
        arrayList.add(this.getResString("IDS_SP_POWER"));
        arrayList.add(this.getResString("IDS_SP_EXPONENTIAL"));
        arrayList.add(this.getResString("IDS_SP_GAUSSIAN"));
        arrayList.add(this.getResString("IDS_SP_LINEAR"));
        arrayList.add(this.getResString("IDS_SP_LINEARLOG"));
        arrayList.add(this.getResString("IDS_SP_SPHERICAL"));
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        ComboboxAction comboboxAction = new ComboboxAction(this, CO_VAR_COMBO);
        this.mCoVarCombo = new JComboBox<String>(stringArray);
        this.mCoVarCombo.setAction(comboboxAction);
        this.mCoVarCombo.setEnabled(false);
        this.mCoVarCombo.addItemListener(this);
        this.mCoVarCombo.setSelectedItem(this.getResString("IDS_DIAGONAL"));
        this.mTargetSubVarList = new TargetVariableList();
        this.mTargetSubVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetRepVarList = new TargetVariableList();
        this.mTargetRepVarList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mTargetSpatialVarList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mSrcVarList.setIdentifier(SOURCE_LIST_KEY);
        this.mTargetRepVarList.setIdentifier(REPEATED_TARGET_LIST_KEY);
        this.mTargetKronVarList.setIdentifier(KRONECKER_TARGET_LIST_KEY);
        this.mTargetSubVarList.setIdentifier(SUBJECT_TARGET_LIST_KEY);
        this.mTargetSpatialVarList.setIdentifier(SPATIAL_TARGET_LIST_KEY);
        this.mTabOrder = new Vector();
        this.mMainDlgModel = new DialogDataModel();
        ProcedureDlgMgr.getMgr().loadPersistentState("analyze_mixed", this.mMainDlgModel);
    }

    private void setupLists(JPanel jPanel) {
        JLabel jLabel = new JLabel(this.getResString("IDS_NOTE_1"), 10);
        JLabel jLabel2 = new JLabel(this.getResString("IDS_NOTE_2"), 10);
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_NOTE_3"));
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFocusable(false);
        jTextArea.setRows(2);
        jTextArea.setMinimumSize(new Dimension(160, 30));
        jTextArea.setPreferredSize(new Dimension(160, 30));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 4, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 4, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 2, 4, 1, n, insets);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_MIXED_MODE_LINEAR_SOURCE_LIST_LABEL");
        jLabel3.setLabelFor(this.mSrcVarList);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 3, 1, 1, n, null);
        this.mSrcVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetSubVarList.getFixedCellHeight() * 12 + 2));
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mTabOrder.add(this.mSrcVarList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 4, 1, 8, n, null);
        ArrowButton arrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        arrowButton.setVarMoveHandler(this.mVarMoveHandler);
        this.mTabOrder.add(arrowButton);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        Insets insets3 = new Insets(0, insets2.left, 0, insets2.right);
        DialogUtil.addUsingGBL(jPanel, arrowButton, gridBagConstraints, 1, 4, 1, 1, n, insets3);
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_SUBJECT");
        jLabel4.setLabelFor(this.mTargetSubVarList);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        gridBagConstraints.fill = 2;
        insets = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 2, 3, 1, 1, n, insets);
        jScrollPane = new JScrollPane(this.mTargetSubVarList);
        this.mTargetSubVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetSubVarList.getFixedCellHeight() * 5 + 2));
        jScrollPane.setPreferredSize(this.mTargetSubVarList.getMinimumSize());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 4, 1, 1, n, null);
        this.mTargetSubVarList.getModel().addListDataListener(this);
        ArrowButton arrowButton2 = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        arrowButton2.setVarMoveHandler(this.mVarMoveHandler);
        this.mTabOrder.add(arrowButton2);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, arrowButton2, gridBagConstraints, 1, 6, 1, 1, n, insets3);
        JLabel jLabel5 = DialogUtil.createLabel(this, "IDS_REPEATED");
        jLabel5.setLabelFor(this.mTargetRepVarList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel5, gridBagConstraints, 2, 5, 1, 1, n, insets);
        jScrollPane = new JScrollPane(this.mTargetRepVarList);
        this.mTargetRepVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetRepVarList.getFixedCellHeight() * 5 + 2));
        jScrollPane.setPreferredSize(this.mTargetRepVarList.getMinimumSize());
        n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mTargetRepVarList.getModel().addListDataListener(this);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 6, 1, 1, n, null);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JLabel jLabel6 = DialogUtil.createLabel(this, CO_VAR_COMBO);
        jLabel6.setLabelFor(this.mCoVarCombo);
        gridBagConstraints.weightx = 0.0;
        insets = DialogUtil.getStandardControlInsets();
        Insets insets4 = new Insets(n2, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel2, jLabel6, gridBagConstraints, 0, 0, 1, 1, n, insets4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets5 = new Insets(n2, insets.left, insets.bottom, 0);
        DialogUtil.addUsingGBL(jPanel2, this.mCoVarCombo, gridBagConstraints, 0, 1, 1, 1, n, insets5);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 2, 7, 1, 1, n, null);
        this.mTabOrder.add(this.mKronArrowButton);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mKronArrowButton, gridBagConstraints, 1, 9, 1, 1, n, insets3);
        JLabel jLabel7 = DialogUtil.createLabel(this, "IDS_KRONECKER");
        jLabel7.setLabelFor(this.mTargetKronVarList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel7, gridBagConstraints, 2, 8, 1, 1, n, insets);
        jScrollPane = new JScrollPane(this.mTargetKronVarList);
        this.mTargetKronVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetKronVarList.getFixedCellHeight() * 5 + 2));
        jScrollPane.setPreferredSize(this.mTargetKronVarList.getMinimumSize());
        n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mTargetKronVarList.getModel().addListDataListener(this);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 9, 1, 1, n, null);
        this.mTabOrder.add(this.mSpatialArrowButton);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSpatialArrowButton, gridBagConstraints, 1, 11, 1, 1, n, insets3);
        JLabel jLabel8 = DialogUtil.createLabel(this, "IDS_SPATIAL_COV_COORD");
        jLabel8.setLabelFor(this.mTargetSpatialVarList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel8, gridBagConstraints, 2, 10, 1, 1, n, insets);
        jScrollPane = new JScrollPane(this.mTargetSpatialVarList);
        this.mTargetSpatialVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetSpatialVarList.getFixedCellHeight() * 5 + 2));
        jScrollPane.setPreferredSize(this.mTargetSpatialVarList.getMinimumSize());
        n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mTargetSpatialVarList.getModel().addListDataListener(this);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 11, 1, 1, n, null);
        arrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        arrowButton2.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        arrowButton.registerVariableList(this.mTargetSubVarList, SpssArrowButton.ButtonOrientation.left);
        arrowButton2.registerVariableList(this.mTargetRepVarList, SpssArrowButton.ButtonOrientation.left);
    }

    private void saveVariables() {
        ISpssVariable iSpssVariable;
        int n;
        VarListModel varListModel = this.mTargetSubVarList.getModel();
        int n2 = varListModel.getSize();
        ISpssVariable[] iSpssVariableArray = new ISpssVariable[n2];
        for (n = 0; n < n2; ++n) {
            iSpssVariable = varListModel.getElementAt(n);
            try {
                iSpssVariableArray[n] = iSpssVariable.clone();
                continue;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                TraceSettings.trace((String)cloneNotSupportedException.getMessage());
            }
        }
        this.getDialogDataModel().putVarArray(SUBJECT_VARIABLE_LIST_KEY, iSpssVariableArray);
        varListModel = this.mTargetRepVarList.getModel();
        n2 = varListModel.getSize();
        iSpssVariableArray = new ISpssVariable[n2];
        for (n = 0; n < n2; ++n) {
            iSpssVariable = varListModel.getElementAt(n);
            try {
                iSpssVariableArray[n] = iSpssVariable.clone();
                continue;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                TraceSettings.trace((String)cloneNotSupportedException.getMessage());
            }
        }
        this.getDialogDataModel().putVarArray(REPEATED_VARIABLE_LIST_KEY, iSpssVariableArray);
        if (this.mTargetKronVarList.isEnabled()) {
            varListModel = this.mTargetKronVarList.getModel();
            n2 = varListModel.getSize();
            iSpssVariableArray = new ISpssVariable[n2];
            for (n = 0; n < n2; ++n) {
                iSpssVariable = varListModel.getElementAt(n);
                try {
                    iSpssVariableArray[n] = iSpssVariable.clone();
                    continue;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    TraceSettings.trace((String)cloneNotSupportedException.getMessage());
                }
            }
            this.getDialogDataModel().putVarArray(KRONECKER_VARIABLE_LIST_KEY, iSpssVariableArray);
        } else {
            this.getDialogDataModel().putVarArray(KRONECKER_VARIABLE_LIST_KEY, null);
        }
        if (this.mTargetSpatialVarList.isEnabled()) {
            varListModel = this.mTargetSpatialVarList.getModel();
            n2 = varListModel.getSize();
            iSpssVariableArray = new ISpssVariable[n2];
            for (n = 0; n < n2; ++n) {
                iSpssVariable = varListModel.getElementAt(n);
                try {
                    iSpssVariableArray[n] = iSpssVariable.clone();
                    continue;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    TraceSettings.trace((String)cloneNotSupportedException.getMessage());
                }
            }
            this.getDialogDataModel().putVarArray(SPATIAL_VARIABLE_LIST_KEY, iSpssVariableArray);
        } else {
            this.getDialogDataModel().putVarArray(SPATIAL_VARIABLE_LIST_KEY, null);
        }
    }

    private void setTabPolicy() {
        this.mTabOrder.add(this.mTargetSubVarList);
        this.mTabOrder.add(this.mTargetRepVarList);
        this.mTabOrder.add(this.mTargetKronVarList);
        this.mTabOrder.add(this.mTargetSpatialVarList);
        this.mTabOrder.add(this.mCoVarCombo);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.mTabOrder.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mTabOrder, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void clearModel() {
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame != null) {
            DataFrame dataFrame = (DataFrame)spssFrame;
            LocallyUniqueId locallyUniqueId = dataFrame.getDatasetId();
            ProcedureDlgMgr.getMgr().removePersistenceData(locallyUniqueId, "analyze_mixed");
        }
        if (this.mMainDlgModel != null) {
            this.mMainDlgModel.clear();
        }
    }

    private boolean doValidation() {
        boolean bl = true;
        if (this.mTargetSpatialVarList.isEnabled() && this.mTargetSpatialVarList.getModel().getSize() == 0) {
            bl = false;
        }
        return bl;
    }

    private boolean doKronValidation() {
        boolean bl = true;
        if (this.mTargetKronVarList.isEnabled() && this.mTargetKronVarList.getModel().getSize() == 0) {
            bl = false;
        }
        return bl;
    }

    private boolean isSameVars() {
        boolean bl = false;
        if (this.mTargetKronVarList.getModel().getSize() == this.mTargetRepVarList.getModel().getSize()) {
            int n = this.mTargetKronVarList.getModel().getSize();
            ISpssVariable[] iSpssVariableArray = this.getDialogDataModel().getVarArray(KRONECKER_VARIABLE_LIST_KEY);
            ISpssVariable[] iSpssVariableArray2 = this.getDialogDataModel().getVarArray(REPEATED_VARIABLE_LIST_KEY);
            for (int i = 0; i < n; ++i) {
                bl = false;
                for (int j = 0; j < n; ++j) {
                    if (!iSpssVariableArray[i].equals(iSpssVariableArray2[j])) continue;
                    bl = true;
                    break;
                }
                if (!bl) break;
            }
        }
        return bl;
    }

    private boolean isSpatialCovType() {
        int n;
        boolean bl = false;
        if (this.mCoVarCombo.isEnabled() && (n = this.mCoVarCombo.getSelectedIndex()) >= 19) {
            bl = true;
        }
        return bl;
    }

    private boolean isKroneckerType() {
        int n;
        boolean bl = false;
        if (this.mCoVarCombo.isEnabled() && (n = this.mCoVarCombo.getSelectedIndex()) >= 8 && n <= 10) {
            bl = true;
        }
        return bl;
    }

    private class MixedModelLinearVarMoveHandler
    implements IVarMoveHandler {
        private BaseDialog mParent;

        public MixedModelLinearVarMoveHandler(BaseDialog baseDialog) {
            this.mParent = baseDialog;
        }

        @Override
        public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
            String string = variableList.getIdentifier();
            if (string != null) {
                Object object;
                if (MixedModelLinearDlg.this.mMainDlgModel != null) {
                    object = MixedModelLinearDlg.this.mMainDlgModel.getVarArray("IDS_DEPENDENT_VAR");
                    ISpssVariable[] iSpssVariableArray2 = MixedModelLinearDlg.this.mMainDlgModel.getVarArray("IDS_RESIDUAL_WEIGHT");
                    if (this.checkVars(iSpssVariableArray, (ISpssVariable[])object)) {
                        SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, MixedModelLinearDlg.this.getResString("ERR_DEPENDENT_VALUE_MSG"), VersionInfo.getAppVersionString());
                        return false;
                    }
                    if (this.checkVars(iSpssVariableArray, iSpssVariableArray2)) {
                        SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, MixedModelLinearDlg.this.getResString("ERR_WEIGHT_VALUE_MSG"), VersionInfo.getAppVersionString());
                        return false;
                    }
                }
                if (string.equals(MixedModelLinearDlg.SPATIAL_TARGET_LIST_KEY) && !this.isNumericVar(iSpssVariableArray)) {
                    SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, MixedModelLinearDlg.this.getResString("ERR_WEIGHT_VALUE_MSG"), VersionInfo.getAppVersionString());
                    return false;
                }
                if (string.equals(MixedModelLinearDlg.SUBJECT_TARGET_LIST_KEY) && this.isUsedByRepeatOrSpatialOrKronecker(iSpssVariableArray)) {
                    object = MixedModelLinearDlg.this.getResString("ERR_USED_SUBJECT_MSG");
                    SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, (String)object, VersionInfo.getAppVersionString());
                    return false;
                }
            }
            return true;
        }

        private boolean checkVars(ISpssVariable[] iSpssVariableArray, ISpssVariable[] iSpssVariableArray2) {
            int n = iSpssVariableArray.length;
            if (null != iSpssVariableArray2) {
                for (int i = 0; i < n; ++i) {
                    ISpssVariable iSpssVariable = iSpssVariableArray[i];
                    for (ISpssVariable iSpssVariable2 : iSpssVariableArray2) {
                        if (!iSpssVariable.getId().equals((Object)iSpssVariable2.getId())) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private boolean isNumericVar(ISpssVariable[] iSpssVariableArray) {
            boolean bl = true;
            for (int i = 0; i < iSpssVariableArray.length; ++i) {
                ISpssVariable iSpssVariable = iSpssVariableArray[i];
                FormatType formatType = iSpssVariable.getFormat().getFormatType();
                if (!formatType.isStringFormat()) continue;
                return false;
            }
            return bl;
        }

        private boolean isUsedByRepeatOrSpatialOrKronecker(ISpssVariable[] iSpssVariableArray) {
            boolean bl = false;
            for (int i = 0; i < iSpssVariableArray.length; ++i) {
                ISpssVariable iSpssVariable = iSpssVariableArray[i];
                if (MixedModelLinearDlg.this.mTargetRepVarList.getModel().findElementIndex(iSpssVariable) >= 0) {
                    bl = true;
                    break;
                }
                if (MixedModelLinearDlg.this.mTargetSpatialVarList.isEnabled() && MixedModelLinearDlg.this.mTargetSpatialVarList.getModel().findElementIndex(iSpssVariable) >= 0) {
                    bl = true;
                    break;
                }
                if (!MixedModelLinearDlg.this.mTargetKronVarList.isEnabled() || MixedModelLinearDlg.this.mTargetKronVarList.getModel().findElementIndex(iSpssVariable) < 0) continue;
                bl = true;
                break;
            }
            return bl;
        }
    }
}

