/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.mixed_models;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.PlainListArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.adv_stats.mixed_models.MixedModelMainDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.shared.core_tools.format.ValueFormatter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MixedModelEMMeans
extends BaseSubDialog
implements ListSelectionListener,
ItemListener,
ListDataListener,
DocumentListener,
FocusListener {
    protected static final String EMMEANS_CUSTOM_VALUES_KEY = "EMMEANS_CUSTOM_VALUES_KEY";
    protected static final String EMMEANS_RADIO_VALUES_KEY = "EMMEANS_RADIO_VALUES_KEY";
    public static final String OVERALL = "(OVERALL)";
    protected static final String COMP_MAIN_EFFECTS_CHECK_KEY = "IDS_COMPARE_MAIN_EFFECTS";
    protected static final String CONF_INTERVAL_ADJUST_COMBO_KEY = "IDS_CONFIDENCE_INTERVAL_ADJUST";
    protected static final String IDS_EMMEANS_TARGET_LIST = "IDS_EMMEANS_TARGET_LIST";
    protected static final String IDS_EMMEANS_SOURCE_LIST = "IDS_EMMEANS_SOURCE_LIST";
    private static final String NONE_RADIO_KEY = "IDS_NONE_RADIO";
    private static final String FIRST_RADIO_KEY = "IDS_FIRST_RADIO";
    private static final String LAST_RADIO_KEY = "IDS_LAST_RADIO";
    private static final String CUSTOM_RADIO_KEY = "IDS_CUSTOM_RADIO";
    private static final String VALUE_TEXT_KEY = "IDS_VALUE_TEXTFIELD";
    private PlainList mSrcVarList;
    private PlainList mTargetVarList;
    private JCheckBox mCompMainEffectCheck;
    private JRadioButton mNoneRadio;
    private JRadioButton mFirstRadio;
    private JRadioButton mLastRadio;
    private JRadioButton mCustomRadio;
    private JComboBox mConfiIntervalCombo;
    private PlainListArrowButton mArrowButton;
    private StringTextField mValueEdit;
    private JPanel mReferenceCategoryPanel;
    private JLabel mConfIntervalLabel;
    private JLabel mValueLabel;
    private Map<String, ISpssVariable> mBaiscVariableMap;
    private Set<String> mFactorsSet;
    private Map<String, Integer> mTargetMap;
    private Map<String, String> mCustomValueMap;
    private SpssButtonGroup mButtonGroup;
    private Vector<Object> mTabOrder;

    public MixedModelEMMeans(MixedModelMainDlg mixedModelMainDlg) {
        super(mixedModelMainDlg, mixedModelMainDlg.getResString("IDS_MIXED_MODEL_EM_MEANS_TITLE"), true);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_mixl_emm";
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (((PlainList)listSelectionEvent.getSource()).equals(this.mTargetVarList)) {
            boolean bl = false;
            this.mCompMainEffectCheck.setEnabled(this.isTargetListContainsMainEffect());
            this.mConfIntervalLabel.setEnabled(true);
            this.mConfiIntervalCombo.setEnabled(true);
            if (this.mTargetVarList.getSelectedIndices().length == 1) {
                bl = !this.mTargetVarList.getSelectedValue().toString().contains("(") && !this.mTargetVarList.getSelectedValue().toString().contains("*");
            }
            this.enableLowerPanel(bl);
            if (this.mTargetVarList.getSelectedIndices().length == 1) {
                String string = (String)this.mTargetVarList.getSelectedValue();
                if (null == this.mTargetMap.get(string)) {
                    this.mTargetMap.put((String)this.mTargetVarList.getSelectedValue(), 1);
                }
                if (this.mCompMainEffectCheck.isSelected()) {
                    this.selectRadio(this.mTargetMap.get(string));
                }
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.mCustomValueMap.put((String)this.mTargetVarList.getSelectedValue(), this.mValueEdit.getText());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.mCustomValueMap.put((String)this.mTargetVarList.getSelectedValue(), this.mValueEdit.getText());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.mCustomValueMap.put((String)this.mTargetVarList.getSelectedValue(), this.mValueEdit.getText());
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mCustomRadio)) {
            this.mCustomValueMap.put((String)this.mTargetVarList.getSelectedValue(), this.mValueEdit.getText());
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public boolean continuePressed() {
        boolean bl = true;
        Set<String> set = this.mCustomValueMap.keySet();
        DefaultListModel defaultListModel = (DefaultListModel)this.mTargetVarList.getModel();
        for (String string : set) {
            if (!defaultListModel.contains(string) || this.mTargetMap.get(string) != 4) continue;
            if (this.mCustomValueMap.get(string) == null || this.mCustomValueMap.get(string).equals("")) {
                bl = false;
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_EMMEANS_BAD_VALUE_MSG"), VersionInfo.getAppVersionString());
                break;
            }
            ISpssVariable iSpssVariable = this.mBaiscVariableMap.get(string);
            if (iSpssVariable.getType() != 0) continue;
            OBS oBS = new OBS();
            SPSS_Format sPSS_Format = iSpssVariable.getFormat();
            if (!this.stringToObs(this.mCustomValueMap.get(string), oBS, sPSS_Format)) {
                bl = false;
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_EMMEANS_BAD_VALUE_MSG"), VersionInfo.getAppVersionString());
                return bl;
            }
            this.mCustomValueMap.put((String)this.mTargetVarList.getSelectedValue(), this.mValueEdit.getText());
        }
        return bl;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = false;
        if (itemEvent.getSource().equals(this.mCompMainEffectCheck)) {
            boolean bl2 = false;
            boolean bl3 = this.mCompMainEffectCheck.isSelected();
            if (bl3 && this.mTargetVarList.getSelectedIndices().length == 1) {
                bl2 = !this.mTargetVarList.getSelectedValue().toString().contains("(") && !this.mTargetVarList.getSelectedValue().toString().contains("*");
            }
            this.enableLowerPanel(bl2);
            bl = !bl;
        } else if (itemEvent.getSource().equals(this.mCustomRadio) && this.mCustomRadio.isEnabled()) {
            boolean bl4 = this.mCustomRadio.isSelected();
            this.mValueLabel.setEnabled(bl4);
            this.mValueEdit.setEnabled(bl4);
            this.mValueEdit.setOpaque(bl4);
        }
        if (this.mCompMainEffectCheck.isSelected() && !bl) {
            this.updateTargetMap();
        } else {
            String string = (String)this.mTargetVarList.getSelectedValue();
            if (string != null && !string.contains("*") && !string.equals(OVERALL)) {
                this.selectRadio(this.mTargetMap.get(string));
            }
            bl = false;
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (this.mTargetVarList.getModel().getSize() > 0) {
            boolean bl = this.checkSelection();
            this.mCompMainEffectCheck.setEnabled(bl);
            this.enableLowerPanel(bl);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (this.mTargetVarList.getModel().getSize() < 1) {
            this.enableLowerPanel(false);
            this.mCompMainEffectCheck.setEnabled(false);
            this.mConfiIntervalCombo.setEnabled(false);
            this.mConfIntervalLabel.setEnabled(false);
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        boolean bl = super.saveState(dialogDataModel);
        DefaultListModel defaultListModel = (DefaultListModel)this.mTargetVarList.getModel();
        int n = defaultListModel.getSize();
        Object[] objectArray = new Object[n];
        Object[] objectArray2 = new String[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string = (String)defaultListModel.get(i);
            Integer n3 = this.mTargetMap.get(string);
            n3 = null != n3 ? n3 : 1;
            objectArray[i] = n3;
            if (n3 != 4) continue;
            objectArray2[n2++] = this.mCustomValueMap.get(string);
        }
        dialogDataModel.putArray(EMMEANS_RADIO_VALUES_KEY, objectArray);
        dialogDataModel.putArray(EMMEANS_CUSTOM_VALUES_KEY, objectArray2);
        return bl;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        this.mTargetVarList.removeListSelectionListener(this);
        this.mTargetVarList.getModel().removeListDataListener(this);
        super.loadState(dialogDataModel);
        this.mTargetVarList.addListSelectionListener(this);
        this.mTargetVarList.getModel().addListDataListener(this);
        this.loadDataInSrc();
        this.mSrcVarList.setSelectedIndex(0);
        Object[] objectArray = dialogDataModel.getArray(EMMEANS_RADIO_VALUES_KEY);
        Object[] objectArray2 = dialogDataModel.getArray(EMMEANS_CUSTOM_VALUES_KEY);
        DefaultListModel defaultListModel = (DefaultListModel)this.mTargetVarList.getModel();
        int n = defaultListModel.getSize();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string = (String)defaultListModel.get(i);
            int n3 = (Integer)objectArray[i];
            this.mTargetMap.put(string, n3);
            if (n3 != 4) continue;
            this.mCustomValueMap.put(string, (String)objectArray2[n2++]);
        }
        this.mCompMainEffectCheck.setEnabled(this.isTargetListContainsMainEffect());
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupLists(jPanel);
        this.setDefaults();
        this.setTabPolicy();
        this.pack();
    }

    private void initVars() {
        ControlAction controlAction = new ToggleButtonAction(this, COMP_MAIN_EFFECTS_CHECK_KEY);
        this.mCompMainEffectCheck = new JCheckBox(controlAction);
        this.mCompMainEffectCheck.addItemListener(this);
        this.mButtonGroup = new SpssButtonGroup();
        controlAction = new ToggleButtonAction(this, NONE_RADIO_KEY);
        this.mNoneRadio = new JRadioButton(controlAction);
        this.mNoneRadio.addItemListener(this);
        controlAction = new ToggleButtonAction(this, FIRST_RADIO_KEY);
        this.mFirstRadio = new JRadioButton(controlAction);
        this.mFirstRadio.addItemListener(this);
        controlAction = new ToggleButtonAction(this, LAST_RADIO_KEY);
        this.mLastRadio = new JRadioButton(controlAction);
        this.mLastRadio.addItemListener(this);
        controlAction = new ToggleButtonAction(this, CUSTOM_RADIO_KEY);
        this.mCustomRadio = new JRadioButton(controlAction);
        this.mCustomRadio.addItemListener(this);
        this.mCustomRadio.addFocusListener(this);
        this.mButtonGroup.add(this.mNoneRadio);
        this.mButtonGroup.add(this.mFirstRadio);
        this.mButtonGroup.add(this.mLastRadio);
        this.mButtonGroup.add(this.mCustomRadio);
        String[] stringArray = new String[]{this.getResString("IDS_COMBO_LSD_NONE"), this.getResString("IDS_COMBO_BONFERRONI"), this.getResString("IDS_COMBO_SIDAK")};
        controlAction = new ComboboxAction(this, CONF_INTERVAL_ADJUST_COMBO_KEY);
        this.mConfiIntervalCombo = new JComboBox<String>(stringArray);
        this.mConfiIntervalCombo.setAction(controlAction);
        this.mConfiIntervalCombo.setSelectedItem(0);
        this.mConfiIntervalCombo.setEnabled(false);
        this.mSrcVarList = new PlainList(IDS_EMMEANS_SOURCE_LIST, PlainList.DragType.eAutoDragCopy);
        this.mSrcVarList.setDataSource(true);
        this.mSrcVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mSrcVarList.getFixedCellHeight() * 21 + 2));
        this.mTargetVarList = new PlainList(IDS_EMMEANS_TARGET_LIST, PlainList.DragType.eAutoDragCopy);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth() * 2, this.mSrcVarList.getFixedCellHeight() * 6 + 2));
        this.mTargetVarList.addListSelectionListener(this);
        this.mArrowButton = new PlainListArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mValueEdit = new StringTextField();
        this.mValueEdit.setAction(new TextFieldAction(this, VALUE_TEXT_KEY));
        this.mValueEdit.setEnabled(false);
        this.mValueEdit.setOpaque(false);
        this.mValueEdit.getDocument().addDocumentListener(this);
        this.mConfIntervalLabel = DialogUtil.createLabel(this, CONF_INTERVAL_ADJUST_COMBO_KEY);
        this.mConfIntervalLabel.setLabelFor(this.mConfiIntervalCombo);
        this.mConfIntervalLabel.setEnabled(false);
        this.mValueLabel = DialogUtil.createLabel(this, VALUE_TEXT_KEY);
        this.mValueLabel.setLabelFor((Component)((Object)this.mValueEdit));
        this.mValueLabel.setEnabled(false);
        this.enableLowerPanel(false);
        this.mTargetMap = new HashMap<String, Integer>();
        this.mCustomValueMap = new HashMap<String, String>();
        this.mTabOrder = new Vector();
    }

    private boolean stringToObs(String string, OBS oBS, SPSS_Format sPSS_Format) {
        if (!CellValueFormatter.stringToObs((String)string, (SPSS_Format)sPSS_Format, (OBS)oBS)) {
            Object object;
            if (sPSS_Format.getFormatType().isDateOrTimeFormat() && (object = CellValueFormatter.parseDate((String)string)) instanceof Date) {
                oBS.setNum(ValueFormatter.convertJavaDateLongToDouble((long)((Date)object).getTime()));
                return true;
            }
            return false;
        }
        return true;
    }

    private void setupLists(JPanel jPanel) {
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_EM_MEANS_LIST_PANEL_BORDER"));
        jPanel.setBorder(titledBorder);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        JScrollPane jScrollPane2 = new JScrollPane(this.mTargetVarList);
        jScrollPane2.setMinimumSize(this.mTargetVarList.getMinimumSize());
        jScrollPane2.setPreferredSize(this.mTargetVarList.getMinimumSize());
        this.mTargetVarList.getModel().addListDataListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, 0, 0, 0);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_FACTORS_AND_INTERACTION");
        jLabel.setLabelFor(this.mSrcVarList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_DISPLAY_MEANS");
        jLabel2.setLabelFor(this.mTargetVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 2, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 5, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        Insets insets3 = new Insets(0, insets2.left, 0, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        gridBagConstraints.fill = 1;
        n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 2, 1, n, new Insets(0, 0, 0, 75));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mCompMainEffectCheck, gridBagConstraints, 2, 2, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mConfIntervalLabel, gridBagConstraints, 2, 3, 1, 1, n, new Insets(0, 25, 0, 0));
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mConfiIntervalCombo, gridBagConstraints, 2, 4, 1, 1, n, new Insets(0, 25, 0, 75));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.setupRefCategoryPanel(), gridBagConstraints, 2, 5, 1, 1, n, new Insets(0, 25, 0, 0));
    }

    private JPanel setupRefCategoryPanel() {
        this.mReferenceCategoryPanel = new JPanel(true);
        this.mReferenceCategoryPanel.setLayout(new GridBagLayout());
        this.mReferenceCategoryPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_REFERENCE_CATEGORY_BORDER")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        DialogUtil.addUsingGBL(this.mReferenceCategoryPanel, this.mNoneRadio, gridBagConstraints, 0, 0, 2, 1, n, new Insets(0, 10, 0, 0));
        DialogUtil.addUsingGBL(this.mReferenceCategoryPanel, this.mFirstRadio, gridBagConstraints, 0, 1, 2, 1, n, new Insets(0, 10, 0, 0));
        DialogUtil.addUsingGBL(this.mReferenceCategoryPanel, this.mLastRadio, gridBagConstraints, 0, 2, 2, 1, n, new Insets(0, 10, 0, 0));
        DialogUtil.addUsingGBL(this.mReferenceCategoryPanel, this.mCustomRadio, gridBagConstraints, 0, 3, 2, 1, n, new Insets(0, 10, 0, 0));
        DialogUtil.addUsingGBL(this.mReferenceCategoryPanel, this.mValueLabel, gridBagConstraints, 1, 4, 1, 1, n, new Insets(0, 40, 0, 0));
        DialogUtil.addUsingGBL(this.mReferenceCategoryPanel, (JComponent)((Object)this.mValueEdit), gridBagConstraints, 1, 5, 1, 1, n, new Insets(0, 40, 0, 5));
        this.pack();
        return this.mReferenceCategoryPanel;
    }

    private boolean isTargetListContainsMainEffect() {
        for (int i = 0; i < this.mTargetVarList.getModel().getSize(); ++i) {
            String string = this.mTargetVarList.getModel().getElementAt(i).toString();
            if (string.contains("(") || string.contains("*")) continue;
            return true;
        }
        return false;
    }

    private void setDefaults() {
        this.enableLowerPanel(false);
        this.mCompMainEffectCheck.setEnabled(false);
        this.mConfiIntervalCombo.setEnabled(false);
        this.mConfIntervalLabel.setEnabled(false);
        this.mNoneRadio.setSelected(true);
        this.mSrcVarList.setSelectedIndex(0);
    }

    private void loadDataInSrc() {
        DialogDataModel dialogDataModel = ((BaseProcedureDialog)((Object)this.getParent())).getDialogDataModel();
        Object[] objectArray = dialogDataModel.getArray("IDS_MODEL_LIST_KEY");
        DefaultListModel defaultListModel = (DefaultListModel)this.mSrcVarList.getModel();
        defaultListModel.clear();
        defaultListModel.addElement(OVERALL);
        HashSet<String> hashSet = new HashSet<String>();
        if (null != objectArray) {
            for (Object object : objectArray) {
                String string = (String)object;
                if (!this.checkForFactorsOnly(string)) continue;
                defaultListModel.addElement(string);
                if (string.indexOf(42) != -1) continue;
                hashSet.add(string);
            }
        }
        this.addToBasicVariable(hashSet);
    }

    private boolean checkForFactorsOnly(String string) {
        String[] stringArray = string.split("\\*");
        Set<String> set = this.getFactorsSet();
        for (String string2 : stringArray) {
            if (set.contains(string2)) continue;
            return false;
        }
        return true;
    }

    private Set<String> getFactorsSet() {
        if (null == this.mFactorsSet) {
            this.mFactorsSet = new HashSet<String>();
            VarListModel varListModel = ((MixedModelMainDlg)this.mParentDlg).getFactorsList().getModel();
            int n = varListModel.getSize();
            for (int i = 0; i < n; ++i) {
                this.mFactorsSet.add(varListModel.getElementAt(i).getName());
            }
        }
        return this.mFactorsSet;
    }

    private void addToBasicVariable(Set set) {
        if (null == this.mBaiscVariableMap) {
            this.mBaiscVariableMap = new HashMap<String, ISpssVariable>();
        }
        VariableList variableList = ((MixedModelMainDlg)this.mParentDlg).getFactorsList();
        VarListModel varListModel = variableList.getModel();
        int n = varListModel.getSize();
        for (int i = 0; i < n; ++i) {
            ISpssVariable iSpssVariable = varListModel.getElementAt(i);
            if (!set.contains(iSpssVariable.getName())) continue;
            this.mBaiscVariableMap.put(iSpssVariable.getName(), iSpssVariable);
        }
    }

    private void enableLowerPanel(boolean bl) {
        boolean bl2 = this.mCompMainEffectCheck.isSelected();
        bl = bl && bl2;
        this.mNoneRadio.setEnabled(bl);
        this.mFirstRadio.setEnabled(bl);
        this.mLastRadio.setEnabled(bl);
        this.mCustomRadio.setEnabled(bl);
        this.mConfIntervalLabel.setEnabled(bl2);
        this.mConfiIntervalCombo.setEnabled(bl2);
        bl = bl && this.mCustomRadio.isSelected();
        this.mValueLabel.setEnabled(bl);
        this.mValueEdit.setEnabled(bl);
        this.mValueEdit.setOpaque(bl);
    }

    private boolean checkSelection() {
        return true;
    }

    private void selectRadio(int n) {
        switch (n) {
            case 1: {
                this.mNoneRadio.setSelected(true);
                break;
            }
            case 2: {
                this.mFirstRadio.setSelected(true);
                break;
            }
            case 3: {
                this.mLastRadio.setSelected(true);
                break;
            }
            case 4: {
                this.mCustomRadio.setSelected(true);
                this.mValueEdit.setText(this.mCustomValueMap.get(this.mTargetVarList.getSelectedValue()));
                break;
            }
        }
    }

    private void setTabPolicy() {
        this.mTabOrder.add(this.mSrcVarList);
        this.mTabOrder.add(this.mArrowButton);
        this.mTabOrder.add(this.mTargetVarList);
        this.mTabOrder.add(this.mCompMainEffectCheck);
        this.mTabOrder.add(this.mConfiIntervalCombo);
        this.mTabOrder.add(this.mButtonGroup);
        this.mTabOrder.add(this.mValueEdit);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.mTabOrder.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mTabOrder, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void updateTargetMap() {
        String string = (String)this.mTargetVarList.getSelectedValue();
        if (this.mNoneRadio.isSelected()) {
            this.mTargetMap.put(string, 1);
        } else if (this.mFirstRadio.isSelected()) {
            this.mTargetMap.put(string, 2);
        } else if (this.mLastRadio.isSelected()) {
            this.mTargetMap.put(string, 3);
        } else {
            this.mTargetMap.put(string, 4);
        }
    }
}

