/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.loglinear_model_select;

import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.AbstractModelSubDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormatSymbols;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class LoglinearModelSelectOptions
extends BaseSubDialog
implements DocumentListener,
FocusListener {
    static final String IDS_FREQUENCY_KEY = "IDS_DISPLAY_FREQ_CHBOX";
    static final String IDS_RESIDUALS_KEY = "IDS_DISPLAY_RESIDUALS_CHBOX";
    static final String IDS_PLOT_RESIDUALS_KEY = "IDS_PLOT_RESIDUALS_CHBOX";
    static final String IDS_NORMAL_PROBABILITY_KEY = "IDS_PLOT_NORMAL_PROB_CHBOX";
    static final String IDS_PARAMETER_ESTIMATES_KEY = "IDS_DISPLAY_SATURATED_MODEL_PARA_CHBOX";
    static final String IDS_ASS_TABLE_KEY = "IDS_DISPLAY_SATURATED_MODEL_ASSO_CHBOX";
    static final String IDS_MAX_ITERATIONS_KEY = "IDS_MODEL_CRITERIA_MAX_ITERATIONS";
    static final String IDS_CONVERGENCE_KEY = "IDS_MODEL_CRITERIA_CONVERGENCE";
    static final String IDS_DELTA_KEY = "IDS_MODEL_CRITERIA_DELTA";
    static final String DEFAULT_MAX_ITER_TEXT = "20";
    static final String DEFAULT_DELTA_TEXT = ".5";
    static JComboBox mConvergenceCombo;
    private JCheckBox mFrequencies;
    private JCheckBox mResiduals;
    private JCheckBox mPlotResiduals;
    private JCheckBox mNormalProbability;
    private JCheckBox mparameterEstimates;
    private JCheckBox mAssociationTable;
    private JLabel mFreqLabel;
    private JLabel mResidualLabel;
    private JLabel mPlotResidualLabel;
    private JLabel mNormalProbLabel;
    private JLabel mParameterLabel;
    private JLabel mAssLabel;
    private JLabel mMaximumIterations;
    private JLabel mConvergence;
    private JLabel mDelta;
    private IntTextField mMaxIterationsText;
    private FloatTextField mDeltaTextField;
    private JPanel mDisplayPanel;
    private JPanel mPlotPanel;
    private JPanel mSaturatedModelPanel;
    private JPanel mModelCriteriaPanel;

    public LoglinearModelSelectOptions(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_hilo_opt";
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument().getLength() > 0) {
            this.enableContinue(this.mMaxIterationsText.getText().length() > 0 && this.mDeltaTextField.getText().length() > 0);
        } else {
            this.enableContinue(false);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument().getLength() > 0) {
            this.enableContinue(this.mMaxIterationsText.getText().length() > 0 && this.mDeltaTextField.getText().length() > 0);
        } else {
            this.enableContinue(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument().getLength() > 0) {
            this.enableContinue(this.mMaxIterationsText.getText().length() > 0 && this.mDeltaTextField.getText().length() > 0);
        } else {
            this.enableContinue(false);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object == this.mMaxIterationsText) {
            this.mMaxIterationsText.selectAll();
        }
        if (object == this.mDeltaTextField) {
            this.mDeltaTextField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        JPanel jPanel = this.getViewPanel();
        this.mDisplayPanel = this.setupDisplayPanel();
        this.mPlotPanel = this.setupPlotPanel();
        this.mSaturatedModelPanel = this.setupSaturatedModelPanel();
        this.mModelCriteriaPanel = this.setupModelCriteriaPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mDisplayPanel, gridBagConstraints, 0, 0, 1, 1, 23, insets);
        DialogUtil.addUsingGBL(jPanel, this.mPlotPanel, gridBagConstraints, 1, 0, 1, 1, 23, null);
        insets.set(n, 0, 0, 0);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mSaturatedModelPanel, gridBagConstraints, 0, 1, 2, 1, 23, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mModelCriteriaPanel, gridBagConstraints, 0, 2, 2, 1, 23, insets);
        this.initDialog();
        this.pack();
    }

    private void setDefaults() {
        this.mFrequencies.setSelected(true);
        this.mResiduals.setSelected(true);
        this.mNormalProbability.setEnabled(false);
        this.mPlotResiduals.setEnabled(false);
        this.mMaxIterationsText.setText(DEFAULT_MAX_ITER_TEXT);
        mConvergenceCombo.setSelectedIndex(0);
        this.mDeltaTextField.setText(DEFAULT_DELTA_TEXT);
    }

    private void initVars() {
        ControlAction controlAction = new ToggleButtonAction(this.mParentDlg, IDS_FREQUENCY_KEY);
        this.mFrequencies = new JCheckBox(controlAction);
        this.mFreqLabel = DialogUtil.createLabel(this.mParentDlg, IDS_FREQUENCY_KEY);
        this.mFreqLabel.setLabelFor(this.mFrequencies);
        controlAction = new ToggleButtonAction(this.mParentDlg, IDS_RESIDUALS_KEY);
        this.mResiduals = new JCheckBox(controlAction);
        this.mResidualLabel = DialogUtil.createLabel(this.mParentDlg, IDS_RESIDUALS_KEY);
        this.mResidualLabel.setLabelFor(this.mResiduals);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mFrequencies);
        spssButtonGroup.add(this.mResiduals);
        controlAction = new ToggleButtonAction(this.mParentDlg, IDS_NORMAL_PROBABILITY_KEY);
        this.mNormalProbability = new JCheckBox(controlAction);
        this.mNormalProbLabel = DialogUtil.createLabel(this.mParentDlg, IDS_NORMAL_PROBABILITY_KEY);
        this.mNormalProbLabel.setLabelFor(this.mNormalProbability);
        controlAction = new ToggleButtonAction(this.mParentDlg, IDS_PLOT_RESIDUALS_KEY);
        this.mPlotResiduals = new JCheckBox(controlAction);
        spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mNormalProbability);
        spssButtonGroup.add(this.mPlotResiduals);
        this.mPlotResidualLabel = DialogUtil.createLabel(this.mParentDlg, IDS_PLOT_RESIDUALS_KEY);
        this.mPlotResidualLabel.setLabelFor(this.mPlotResiduals);
        controlAction = new ToggleButtonAction(this.mParentDlg, IDS_PARAMETER_ESTIMATES_KEY);
        this.mparameterEstimates = new JCheckBox(controlAction);
        this.mParameterLabel = DialogUtil.createLabel(this.mParentDlg, IDS_PARAMETER_ESTIMATES_KEY);
        this.mParameterLabel.setLabelFor(this.mparameterEstimates);
        controlAction = new ToggleButtonAction(this.mParentDlg, IDS_ASS_TABLE_KEY);
        this.mAssociationTable = new JCheckBox(controlAction);
        this.mAssLabel = DialogUtil.createLabel(this.mParentDlg, IDS_ASS_TABLE_KEY);
        this.mAssLabel.setLabelFor(this.mAssociationTable);
        spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mparameterEstimates);
        spssButtonGroup.add(this.mAssociationTable);
        this.mMaximumIterations = DialogUtil.createLabel(this.mParentDlg, IDS_MAX_ITERATIONS_KEY);
        controlAction = new TextFieldAction(this.mParentDlg, IDS_MAX_ITERATIONS_KEY);
        this.mMaxIterationsText = new IntTextField(1, 999, true);
        this.mMaxIterationsText.setDocument((Document)new FixedLengthNumericDocument(3, true, false));
        this.mMaxIterationsText.setColumns(2);
        this.mMaxIterationsText.setAction((Action)controlAction);
        this.mMaximumIterations.setLabelFor((Component)this.mMaxIterationsText);
        this.mMaxIterationsText.getDocument().addDocumentListener(this);
        this.mMaxIterationsText.addFocusListener((FocusListener)this);
        this.mConvergence = DialogUtil.createLabel(this.mParentDlg, IDS_CONVERGENCE_KEY);
        controlAction = new ComboboxAction(this.mParentDlg, IDS_CONVERGENCE_KEY);
        String[] stringArray = new String[]{this.getResString("IDS_MODEL_CONVERGENCE_DEFAUT"), "0.75", "0.5", "0.25", "0.1", "0.01", "0.001", "0.0001"};
        Vector<String> vector = new Vector<String>();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(UIToolResUtil.getSPSSLocale());
        String string = null;
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string2;
            string = string2 = stringArray2[i];
            if (decimalFormatSymbols.getDecimalSeparator() != '.') {
                string = string2.replace('.', decimalFormatSymbols.getDecimalSeparator());
            }
            vector.add(string);
        }
        mConvergenceCombo = new JComboBox(vector);
        mConvergenceCombo.setAction(controlAction);
        this.mConvergence.setLabelFor(mConvergenceCombo);
        this.mDelta = DialogUtil.createLabel(this.mParentDlg, IDS_DELTA_KEY);
        controlAction = new TextFieldAction(this.mParentDlg, IDS_DELTA_KEY);
        this.mDeltaTextField = new FloatTextField(0.0, 1.0, 3, true);
        this.mDeltaTextField.setDocument((Document)new FixedLengthNumericDocument(4, true, true));
        this.mDeltaTextField.setColumns(2);
        this.mDeltaTextField.setAction((Action)controlAction);
        this.mDelta.setLabelFor((Component)this.mDeltaTextField);
        this.mDeltaTextField.getDocument().addDocumentListener(this);
        this.mDeltaTextField.addFocusListener((FocusListener)this);
    }

    private void initDialog() {
        Boolean bl = this.mParentDlg.getDialogDataModel().getBoolean(AbstractModelSubDialog.MODEL_CUSTOM_KEY);
        if (bl != null && bl.booleanValue()) {
            this.setComponentEnableState(this.mPlotPanel, bl);
            this.setComponentEnableState(this.mSaturatedModelPanel, bl == false);
            this.mPlotResiduals.setEnabled(bl);
            this.mNormalProbability.setEnabled(bl);
            this.mAssociationTable.setEnabled(bl == false);
            this.mparameterEstimates.setEnabled(bl == false);
        } else {
            this.setComponentEnableState(this.mPlotPanel, false);
            this.setComponentEnableState(this.mSaturatedModelPanel, true);
        }
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mFrequencies);
        vector.add(this.mResiduals);
        vector.add(this.mPlotResiduals);
        vector.add(this.mNormalProbability);
        vector.add(this.mparameterEstimates);
        vector.add(this.mAssociationTable);
        vector.add(this.mMaxIterationsText);
        vector.add(mConvergenceCombo);
        vector.add(this.mDeltaTextField);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private JPanel setupDisplayPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mFrequencies, this.mResiduals};
        JPanel jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_OPTION_DISPLAY"), 2);
        return jPanel;
    }

    private JPanel setupPlotPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mPlotResiduals, this.mNormalProbability};
        JPanel jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_PLOT"), 2);
        return jPanel;
    }

    private JPanel setupSaturatedModelPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mparameterEstimates, this.mAssociationTable};
        JPanel jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_DISPLAY_SATURATED_MODEL"), 1);
        return jPanel;
    }

    private JPanel setupModelCriteriaPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_MODEL_CRITERIA")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mMaximumIterations, gridBagConstraints, 0, 0, 1, 1, n, insets);
        Insets insets2 = new Insets(0, 0, DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin() * 25);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxIterationsText, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mConvergence, gridBagConstraints, 0, 1, 1, 1, n, insets);
        Insets insets3 = new Insets(0, 0, DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin() * 15);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, mConvergenceCombo, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mDelta, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mDeltaTextField, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        return jPanel;
    }
}

