/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.loglinear_general;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.adv_stats.LoglinearCommonOptions;
import com.spss.java_client.ui.dialogs.adv_stats.LoglinearCommonSave;
import com.spss.java_client.ui.dialogs.adv_stats.loglinear_general.LoglinearGeneralModel;
import com.spss.java_client.ui.dialogs.adv_stats.res.AdvStatsResBundle;
import com.spss.java_client.ui.dialogs.common.AbstractModelSubDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class LoglinearGeneralDlg
extends BaseProcedureDialog
implements ListDataListener {
    private static final String LOGLINEAR_POISSON_KEY = "IDS_LOGLINEAR_POISSON";
    private static final String LOGLINEAR_MULT_KEY = "IDS_LOGLINEAR_MULT";
    JRadioButton mPoissonRadio;
    JRadioButton multinomialRadio;
    TargetVariableList mTargetVarFactorList;
    TargetVariableList mTargetVarCovarList;
    private SrcVariableList mSrcVarList;
    private JScrollPane mSrcScrollPane;
    private ArrowButton mTargetVarFactorListArrowButton;
    private JLabel mFactorLabel;
    private JScrollPane mTargetVarFactorListScrollPane;
    private ArrowButton mTargetVarCovarListArrowButton;
    private JLabel mCellCovariateLabel;
    private JScrollPane mTargetVarCovarListScrollPane;
    private TargetVariableList mTargetVarStructList;
    private ArrowButton mTargetVarStructListArrowButton;
    private JLabel mCellStructureLabel;
    private JScrollPane mTargetVarStructListScrollPane;
    private TargetVariableList mTargetVarContrastList;
    private ArrowButton mTargetVarContrastListArrowButton;
    private JLabel mContrastVarLabel;
    private JScrollPane mTargetVarContrastListScrollPane;
    private SpssButtonGroup buttonGroup;
    private LoglinearCommonOptions mOptionDlg;
    private LoglinearGeneralModel mModelDlg;
    private JButton mSaveButton;
    private JButton mModelButton;
    private JButton mOptionsButton;
    private GridBagConstraints mGridConstraints;

    public LoglinearGeneralDlg(JFrame jFrame) {
        super(jFrame, false, AdvStatsResBundle.getDefaultResourceBundleName(), AdvStatsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_LOGLINEAR_GENERAL"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_logl";
    }

    @Override
    public String generateSyntax() {
        Boolean bl;
        String string;
        String string2;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        String string3 = SyntaxUtil.startSyntax().toString();
        string3 = string3 + SyntaxUtil.getMainCommand("GENLOG");
        String string4 = SyntaxUtil.getMainCommandParamters(this.mTargetVarFactorList.getVariablesStringList()).toString();
        if (string4 != null && string4.length() > 0) {
            string3 = string3 + string4;
        }
        if ((string2 = this.mTargetVarCovarList.getVariablesStringList()) != null && string2.length() > 0) {
            string3 = string3 + " WITH " + string2;
        }
        if ((string = this.mTargetVarStructList.getVariablesStringList()) != null && string.length() > 0) {
            string3 = string3 + "\n" + SyntaxUtil.getSubCommand("/CSTRUCTURE=").toString() + string;
        }
        if ((string = this.mTargetVarContrastList.getVariablesStringList()) != null && string.length() > 0) {
            string3 = string3 + "\n" + SyntaxUtil.getSubCommand("/GLOR=").toString() + string;
        }
        string3 = (bl = dialogDataModel.getBoolean(LOGLINEAR_POISSON_KEY)) != null && bl != false ? string3 + "\n" + SyntaxUtil.getSubCommand("/MODEL=POISSON").toString() : string3 + "\n" + SyntaxUtil.getSubCommand("/MODEL=MULTINOMIAL").toString();
        Boolean bl2 = dialogDataModel.getBoolean(AbstractModelSubDialog.MODEL_CUSTOM_KEY);
        string3 = string3 + "\n" + SyntaxUtil.getSubCommand("/PRINT=").toString();
        string3 = string3 + LoglinearCommonOptions.getOptionSyntax(dialogDataModel);
        if (bl2 != null && bl2.booleanValue()) {
            Object[] objectArray;
            string3 = string3 + SyntaxUtil.getSubCommand("/DESIGN ").toString();
            for (Object object : objectArray = dialogDataModel.getArray(AbstractModelSubDialog.MODEL_TERMS_KEY)) {
                if (!this.isTermValid(object.toString(), string4 + string2)) continue;
                string3 = string3 + object + " ";
            }
        }
        if (!string3.endsWith("\n")) {
            string3 = string3 + "\n";
        }
        string3 = string3 + LoglinearCommonSave.addSaveSyntax(dialogDataModel);
        string3 = string3.trim();
        string3 = string3 + SyntaxUtil.terminateSyntax();
        return string3;
    }

    @Override
    public final String getIActionKey() {
        return "analyze_loglinear_general";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarFactorList.getModel().getSize() > 0);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarFactorList.getModel().getSize() > 0);
        this.updateDialogDataModel();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarFactorList.getModel().getSize() > 0);
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetVarFactorList.removeAll();
        this.mTargetVarCovarList.removeAll();
        this.mTargetVarStructList.removeAll();
        this.mTargetVarContrastList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mPoissonRadio.setSelected(true);
    }

    @Override
    public boolean okPastePressed() {
        return this.validateDialog();
    }

    public void updateDialogDataModel() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        String string = this.mTargetVarFactorList.getVariablesStringList();
        String string2 = this.mTargetVarCovarList.getVariablesStringList();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector2.add(stringTokenizer.nextToken());
        }
        stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector3.add(stringTokenizer.nextToken());
        }
        Object[] objectArray = dialogDataModel.getArray(AbstractModelSubDialog.MODEL_TERMS_KEY);
        if (objectArray != null) {
            for (Object object : objectArray) {
                String string3;
                String string4 = object.toString();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string4, "*");
                int n = stringTokenizer2.countTokens();
                for (int i = 0; i < n && (vector2.contains(string3 = stringTokenizer2.nextToken()) || vector3.contains(string3)); ++i) {
                    if (i < n - 1) continue;
                    vector.add(string4);
                }
            }
        }
        dialogDataModel.putArray(AbstractModelSubDialog.MODEL_TERMS_KEY, vector.toArray());
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setupLists(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mSaveButton.setEnabled(false);
        }
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.updateDialogDataModel();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_COMMON_SAVE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoglinearCommonSave loglinearCommonSave = new LoglinearCommonSave(LoglinearGeneralDlg.this, LoglinearGeneralDlg.this.getResString("IDS_LOGLINEAR_GENERAL_SAVE"));
                LoglinearGeneralDlg.this.runSubDialog(loglinearCommonSave);
            }
        };
        this.mSaveButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mSaveButton);
        toggleButtonAction = new ToggleButtonAction("IDS_COMMON_MODEL_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoglinearGeneralDlg.this.mModelDlg = new LoglinearGeneralModel((BaseProcedureDialog)LoglinearGeneralDlg.this, LoglinearGeneralDlg.this.mTargetVarFactorList.getModel(), LoglinearGeneralDlg.this.mTargetVarCovarList.getModel());
                LoglinearGeneralDlg.this.runSubDialog(LoglinearGeneralDlg.this.mModelDlg);
            }
        };
        this.mModelButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mModelButton);
        toggleButtonAction = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoglinearGeneralDlg.this.mOptionDlg = new LoglinearCommonOptions(LoglinearGeneralDlg.this, LoglinearGeneralDlg.this.getResString("IDS_LOGLINEAR_GENERAL_OPTIONS"));
                LoglinearGeneralDlg.this.runSubDialog(LoglinearGeneralDlg.this.mOptionDlg);
            }
        };
        this.mOptionsButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mOptionsButton);
        return jPanel;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setIdentifier("LogLinSrcList");
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mTargetVarFactorList = new TargetVariableList();
        this.mTargetVarFactorList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetVarFactorList.setIdentifier("LogLinFactorList");
        this.mTargetVarFactorList.setMaxLimitOfList(10);
        this.mTargetVarFactorListScrollPane = new JScrollPane(this.mTargetVarFactorList);
        this.mTargetVarFactorList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarFactorList.getFixedCellHeight() * 3 + 2));
        this.mTargetVarFactorListScrollPane.setPreferredSize(this.mTargetVarFactorList.getMinimumSize());
        this.mTargetVarFactorList.getModel().addListDataListener(this);
        this.mFactorLabel = DialogUtil.createLabel(this, "IDS_LOGLINEAR_FACTOR");
        this.mFactorLabel.setLabelFor(this.mTargetVarFactorList);
        this.mTargetVarFactorListArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mTargetVarFactorListArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mTargetVarFactorListArrowButton.registerVariableList(this.mTargetVarFactorList, SpssArrowButton.ButtonOrientation.left);
        this.mTargetVarCovarList = new TargetVariableList();
        this.mTargetVarCovarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetVarCovarList.setIdentifier("LogLinCovarList");
        this.mTargetVarCovarList.setMaxLimitOfList(200);
        this.mTargetVarCovarListScrollPane = new JScrollPane(this.mTargetVarCovarList);
        this.mTargetVarCovarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarCovarList.getFixedCellHeight() * 2 + 2));
        this.mTargetVarCovarListScrollPane.setPreferredSize(this.mTargetVarCovarList.getMinimumSize());
        this.mTargetVarCovarList.getModel().addListDataListener(this);
        this.mCellCovariateLabel = DialogUtil.createLabel(this, "IDS_LOGLINEAR_COV");
        this.mCellCovariateLabel.setLabelFor(this.mTargetVarCovarList);
        this.mTargetVarCovarListArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mTargetVarCovarListArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mTargetVarCovarListArrowButton.registerVariableList(this.mTargetVarCovarList, SpssArrowButton.ButtonOrientation.left);
        TargetVariableList.TargetListType targetListType = TargetVariableList.TargetListType.single_item;
        this.mTargetVarStructList = new TargetVariableList(targetListType);
        this.mTargetVarStructList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetVarStructList.setIdentifier("LogLinStructList");
        this.mTargetVarStructListScrollPane = new JScrollPane(this.mTargetVarStructList);
        this.mTargetVarStructListScrollPane.setPreferredSize(this.mTargetVarStructList.getMinimumSize());
        this.mTargetVarStructListScrollPane.setVerticalScrollBarPolicy(21);
        this.mTargetVarStructListScrollPane.setHorizontalScrollBarPolicy(31);
        this.mTargetVarStructList.getModel().addListDataListener(this);
        this.mCellStructureLabel = DialogUtil.createLabel(this, "IDS_LOGLINEAR_STRUCTURE");
        this.mCellStructureLabel.setLabelFor(this.mTargetVarStructList);
        this.mTargetVarStructListArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mTargetVarStructListArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mTargetVarStructListArrowButton.registerVariableList(this.mTargetVarStructList, SpssArrowButton.ButtonOrientation.left);
        this.mTargetVarContrastList = new TargetVariableList();
        this.mTargetVarContrastList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetVarContrastList.setIdentifier("LogLinContrastList");
        this.mTargetVarContrastListScrollPane = new JScrollPane(this.mTargetVarContrastList);
        this.mTargetVarContrastList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarContrastList.getFixedCellHeight() * 2 + 2));
        this.mTargetVarContrastListScrollPane.setPreferredSize(this.mTargetVarContrastList.getMinimumSize());
        this.mTargetVarContrastList.getModel().addListDataListener(this);
        this.mContrastVarLabel = DialogUtil.createLabel(this, "IDS_LOGLINEAR_VAR");
        this.mContrastVarLabel.setLabelFor(this.mTargetVarContrastList);
        this.mTargetVarContrastListArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mTargetVarContrastListArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mTargetVarContrastListArrowButton.registerVariableList(this.mTargetVarContrastList, SpssArrowButton.ButtonOrientation.left);
        this.mPoissonRadio = new JRadioButton(new ToggleButtonAction(this, LOGLINEAR_POISSON_KEY));
        this.multinomialRadio = new JRadioButton(new ToggleButtonAction(this, LOGLINEAR_MULT_KEY));
        this.buttonGroup = new SpssButtonGroup();
        this.buttonGroup.add(this.mPoissonRadio);
        this.buttonGroup.add(this.multinomialRadio);
        this.buttonGroup.setSelected(this.mPoissonRadio.getModel(), true);
        this.mGridConstraints = new GridBagConstraints();
    }

    private void setupLists(JPanel jPanel) {
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.weighty = 0.0;
        int n = 23;
        this.mGridConstraints.fill = 0;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getArrowButtonInsets();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_LOGLINEAR_GENERAL_SRCLIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, this.mGridConstraints, 0, 0, 1, 1, n, null);
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 1.0;
        this.mGridConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, this.mGridConstraints, 0, 1, 1, 7, n, null);
        this.mGridConstraints.fill = 2;
        this.mGridConstraints.weighty = 0.0;
        Insets insets2 = new Insets(0, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mFactorLabel, this.mGridConstraints, 2, 0, 1, 1, n, insets2);
        this.mGridConstraints.fill = 0;
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mTargetVarFactorListArrowButton, this.mGridConstraints, 1, 1, 1, 1, 10, insets2);
        this.mGridConstraints.fill = 1;
        insets2.set(0, insets.left, 0, 0);
        this.mGridConstraints.weighty = 1.0;
        this.mGridConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mTargetVarFactorListScrollPane, this.mGridConstraints, 2, 1, 1, 1, n, insets2);
        this.mGridConstraints.fill = 2;
        this.mGridConstraints.weighty = 0.0;
        insets2.set(n2, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mCellCovariateLabel, this.mGridConstraints, 2, 2, 1, 1, n, insets2);
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.weighty = 1.0;
        this.mGridConstraints.fill = 0;
        insets2.set(0, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTargetVarCovarListArrowButton, this.mGridConstraints, 1, 3, 1, 1, 10, insets2);
        this.mGridConstraints.fill = 1;
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 1.0;
        insets2.set(0, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTargetVarCovarListScrollPane, this.mGridConstraints, 2, 3, 1, 1, n, insets2);
        this.mGridConstraints.fill = 2;
        this.mGridConstraints.weighty = 0.0;
        insets2.set(n2, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mCellStructureLabel, this.mGridConstraints, 2, 4, 1, 1, n, insets2);
        this.mGridConstraints.fill = 0;
        insets2.set(0, insets.left, 0, 0);
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mTargetVarStructListArrowButton, this.mGridConstraints, 1, 4, 1, 2, 20, insets2);
        this.mGridConstraints.fill = 2;
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 0.0;
        insets2.set(0, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTargetVarStructListScrollPane, this.mGridConstraints, 2, 5, 1, 1, n, insets2);
        this.mGridConstraints.fill = 2;
        this.mGridConstraints.weighty = 0.0;
        insets2.set(n2, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mContrastVarLabel, this.mGridConstraints, 2, 6, 1, 1, n, insets2);
        this.mGridConstraints.fill = 0;
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.weighty = 1.0;
        insets2.set(insets.top, insets.left, insets.bottom, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTargetVarContrastListArrowButton, this.mGridConstraints, 1, 7, 1, 1, 10, insets2);
        this.mGridConstraints.fill = 1;
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 1.0;
        insets2.set(0, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTargetVarContrastListScrollPane, this.mGridConstraints, 2, 7, 1, 1, n, insets2);
        JComponent[] jComponentArray = new JComponent[]{this.mPoissonRadio, this.multinomialRadio};
        JPanel jPanel2 = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.xaxis, this.getResString("IDS_LOGLINEAR_DISTRIB"));
        insets2.set(5, 0, 0, n2 * 2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mGridConstraints, 0, 8, 3, 1, n, insets2);
    }

    private boolean validateDialog() {
        boolean bl = true;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl2 = dialogDataModel.getBoolean(AbstractModelSubDialog.MODEL_CUSTOM_KEY);
        if (bl2 != null && bl2.booleanValue() && dialogDataModel.getArray(AbstractModelSubDialog.MODEL_TERMS_KEY).length == 0) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_LOGLINEAR_GENERAL_MODEL_NOT_SPECIFIED_WARNING"), VersionInfo.getAppVersionString());
            return false;
        }
        if (this.mTargetVarCovarList.getModel().getSize() > 0 && (bl2 == null || bl2 == Boolean.FALSE)) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_LOGLINEAR_ERROR_MSG"), VersionInfo.getAppVersionString());
            bl = false;
        }
        if (bl) {
            String string;
            int n;
            String string2 = this.getUnUsedFactors();
            if (bl2 == Boolean.TRUE && string2.length() > 0 && ((n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), string = String.format(this.getResString("ERR_LOGLINEAR_WARN_MSG"), string2), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eInformation, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) == 3 || n == -1)) {
                bl = false;
            }
        }
        return bl;
    }

    private String getUnUsedFactors() {
        int n;
        String string = "";
        HashSet<String> hashSet = new HashSet<String>();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Object[] objectArray = dialogDataModel.getArray(AbstractModelSubDialog.MODEL_TERMS_KEY);
        if (objectArray == null) {
            return string;
        }
        for (Object object : objectArray) {
            if (!(object instanceof String)) continue;
            String string2 = (String)object;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "*");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3 == null || string3.length() <= 0) continue;
                hashSet.add(string3.trim());
            }
        }
        HashSet hashSet2 = new HashSet();
        int n2 = this.mTargetVarFactorList.getModel().getSize();
        for (n = 0; n < n2; ++n) {
            hashSet2.add(this.mTargetVarFactorList.getModel().getElementAt(n).getName());
        }
        n2 = this.mTargetVarCovarList.getModel().getSize();
        for (n = 0; n < n2; ++n) {
            hashSet2.add(this.mTargetVarCovarList.getModel().getElementAt(n).getName());
        }
        hashSet2.removeAll(hashSet);
        if (hashSet2.size() > 0) {
            Iterator iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                Object object;
                object = (String)iterator.next();
                string = string + (String)object + " ";
            }
        }
        return string;
    }

    private boolean isTermValid(String string, String string2) {
        boolean bl = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "*");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3 == null || string2.indexOf(string3.trim()) != -1) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mTargetVarFactorListArrowButton);
        vector.add(this.mTargetVarCovarListArrowButton);
        vector.add(this.mTargetVarStructListArrowButton);
        vector.add(this.mTargetVarContrastListArrowButton);
        vector.add(this.mTargetVarFactorList);
        vector.add(this.mTargetVarCovarList);
        vector.add(this.mTargetVarStructList);
        vector.add(this.mTargetVarContrastList);
        vector.add(this.buttonGroup);
        vector.add(this.mSaveButton);
        vector.add(this.mModelButton);
        vector.add(this.mOptionsButton);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            if (!(this.mCmdButtonPanel.getComponent(i) instanceof JButton)) continue;
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    public TargetVariableList getCovarList() {
        return this.mTargetVarCovarList;
    }
}

