/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.logit;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableCombinations;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.adv_stats.LoglinearCommonOptions;
import com.spss.java_client.ui.dialogs.adv_stats.LoglinearCommonSave;
import com.spss.java_client.ui.dialogs.adv_stats.logit.LogitModel;
import com.spss.java_client.ui.dialogs.adv_stats.res.AdvStatsResBundle;
import com.spss.java_client.ui.dialogs.common.AbstractModelSubDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class LogitDlg
extends BaseProcedureDialog
implements ListDataListener {
    public static final String COVARIATE_KEY = "IDS_LOGIT_COVARIATE_LIST_KEY";
    private static final String SAVE_BUTTON = "IDS_COMMON_SAVE_BUTTON";
    private static final String MODEL_BUTTON = "IDS_COMMON_MODEL_BUTTON";
    private static final String OPTION_BUTTON = "IDS_COMMON_OPTIONS_3DOT";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mDependentTargetList;
    private TargetVariableList mFactorTargetList;
    private TargetVariableList mCovariateTargetList;
    private TargetVariableList mStructureTargetList;
    private TargetVariableList mContrastTargetList;
    private ArrowButton mDependentArrow;
    private ArrowButton mFactorArrow;
    private ArrowButton mCovariateArrow;
    private ArrowButton mStrutureArrow;
    private ArrowButton mContrastArrow;
    private GridBagConstraints mConstraints;
    private int mAnchor;
    private JButton mSaveButton;
    private JButton mModelButton;
    private JButton mOptionButton;

    public LogitDlg(JFrame jFrame) {
        super(jFrame, false, AdvStatsResBundle.getDefaultResourceBundleName(), AdvStatsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_ANALYZE_LOGLINEAR_LOGIT_TITLE"));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean okPastePressed() {
        super.okPastePressed();
        Boolean bl = this.getDialogDataModel().getBoolean(AbstractModelSubDialog.MODEL_CUSTOM_KEY);
        if (bl != null && bl.booleanValue() && this.getDialogDataModel().getArray(AbstractModelSubDialog.MODEL_TERMS_KEY).length == 0 && (this.getDialogDataModel().getBoolean("IDS_MOD_INCLUDE_CHECK") == null || !this.getDialogDataModel().getBoolean("IDS_MOD_INCLUDE_CHECK").booleanValue())) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_LOGIT_MODEL_NOT_SPECIFIED_WARNING"), VersionInfo.getAppVersionString());
            return false;
        }
        if (!(bl != null && bl.booleanValue() || this.mCovariateTargetList.getModel().getSize() <= 0)) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_LOGIT_COVARIATE_WARNING"), VersionInfo.getAppVersionString());
            return false;
        }
        if (this.mDependentTargetList.getModel().getSize() + this.mFactorTargetList.getModel().getSize() > 10) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_LOGIT_DEPEND_FACTOR_WARNING"), VersionInfo.getAppVersionString());
            return false;
        }
        if (bl != null && bl.booleanValue() && this.getDialogDataModel().getArray("IDS_MODEL_TERMS").length > 0) {
            int n;
            int n2;
            Object[] objectArray;
            boolean bl2 = false;
            for (Object objectArray2 : objectArray = this.getDialogDataModel().getArray("IDS_MODEL_TERMS")) {
                if (objectArray2.toString().indexOf("*") == -1) continue;
                bl2 = true;
            }
            if (bl2) {
                objectArray = this.tokenModelTerms(objectArray);
            }
            Object[] objectArray3 = new Object[this.mFactorTargetList.getModel().getSize()];
            for (int i = 0; i < this.mFactorTargetList.getModel().getSize(); ++i) {
                objectArray3[i] = this.mFactorTargetList.getModel().getElementAt(i).getName();
            }
            Vector<Object> vector = new Vector<Object>();
            vector.addAll(Arrays.asList(objectArray3));
            for (n2 = 0; n2 < this.mCovariateTargetList.getModel().getSize(); ++n2) {
                vector.add(this.mCovariateTargetList.getModel().getElementAt(n2).getName());
            }
            block3: for (n2 = vector.size() - 1; n2 >= 0; --n2) {
                Object[] string = objectArray;
                n = string.length;
                for (int i = 0; i < n; ++i) {
                    Object object = string[i];
                    if (!vector.get(n2).toString().equals(object.toString())) continue;
                    vector.remove(n2);
                    continue block3;
                }
            }
            if (vector.size() > 0) {
                String string;
                String string2 = vector.get(0).toString();
                if (vector.size() > 1) {
                    void var7_13;
                    boolean bl3 = true;
                    while (var7_13 < vector.size()) {
                        string2 = string2 + ", " + vector.get((int)var7_13);
                        ++var7_13;
                    }
                }
                if ((n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), string = String.format(this.getResString("ERR_LOGIT_MODEL_NOT_INCLUDED_ERROR"), string2), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) == 3 || n == -1) {
                    return false;
                }
            }
        }
        return super.okPastePressed();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mDependentTargetList.getModel().getSize() > 0);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mDependentTargetList.getModel().getSize() > 0);
        this.updateDialogDataModel();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mDependentTargetList.getModel().getSize() > 0);
    }

    @Override
    public String generateSyntax() {
        Object object;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("GENLOG"));
        String string = this.mDependentTargetList.getVariablesStringList();
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(string));
        if (this.mFactorTargetList.getModel().getSize() > 0) {
            string = this.mFactorTargetList.getVariablesStringList();
            stringBuffer.append(" BY ").append(string);
        }
        if (this.mCovariateTargetList.getModel().getSize() > 0) {
            string = this.mCovariateTargetList.getVariablesStringList();
            stringBuffer.append(" WITH ").append(string);
        }
        if (this.mStructureTargetList.getModel().getSize() > 0) {
            string = this.mStructureTargetList.getVariablesStringList();
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/CSTRUCTURE="));
            stringBuffer.append(string);
        }
        if (this.mContrastTargetList.getModel().getSize() > 0) {
            string = this.mContrastTargetList.getVariablesStringList();
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/GLOR="));
            stringBuffer.append(string);
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/MODEL=MULTINOMIAL"));
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/PRINT="));
        stringBuffer.append(LoglinearCommonOptions.getOptionSyntax(dialogDataModel));
        Boolean bl = dialogDataModel.getBoolean(AbstractModelSubDialog.MODEL_CUSTOM_KEY);
        if (bl != null && bl.booleanValue()) {
            Vector<Object> vector;
            stringBuffer.append(SyntaxUtil.getSubCommand("/DESIGN"));
            object = dialogDataModel.getArray("IDS_MODEL_TERMS");
            Vector<String> vector2 = new Vector<String>();
            for (int i = 0; i < this.mDependentTargetList.getModel().getSize(); ++i) {
                vector2.add(this.mDependentTargetList.getModel().getElementAt(i).getName());
            }
            VariableCombinations variableCombinations = new VariableCombinations(vector2, 1, vector2.size());
            Vector<String> vector3 = variableCombinations.getCombinations();
            vector3 = variableCombinations.sortByDependentElements(vector2, vector3);
            if (((Object)object).length > 0) {
                vector = variableCombinations.getCombinationsOfTwoArrays((Object[])object, vector3.toArray());
            } else {
                vector = new Vector();
                for (String object2 : vector3) {
                    vector.add(object2);
                }
            }
            bl = dialogDataModel.getBoolean("IDS_MOD_INCLUDE_CHECK");
            if (bl != null && !bl.booleanValue()) {
                vector = variableCombinations.removeFirstListCombination(vector, vector3);
            }
            for (Object object2 : vector) {
                stringBuffer.append(" ").append(object2);
            }
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) != '\n') {
            stringBuffer.append("\n");
        }
        stringBuffer.append(LoglinearCommonSave.addSaveSyntax(dialogDataModel));
        object = stringBuffer.toString();
        object = ((String)object).trim();
        object = (String)object + SyntaxUtil.terminateSyntax();
        return object;
    }

    @Override
    public String getIActionKey() {
        return "analyze_loglinear_logit";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_logi";
    }

    @Override
    public void reset() {
        super.reset();
        this.mDependentTargetList.removeAll();
        this.mFactorTargetList.removeAll();
        this.mContrastTargetList.removeAll();
        this.mCovariateTargetList.removeAll();
        this.mStructureTargetList.removeAll();
        this.setDefaults();
    }

    public void updateDialogDataModel() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        String string = this.mFactorTargetList.getVariablesStringList();
        String string2 = this.mCovariateTargetList.getVariablesStringList();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector2.add(stringTokenizer.nextToken());
        }
        stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector3.add(stringTokenizer.nextToken());
        }
        Object[] objectArray = dialogDataModel.getArray(AbstractModelSubDialog.MODEL_TERMS_KEY);
        if (objectArray != null) {
            for (Object object : objectArray) {
                String string3;
                String string4 = object.toString();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string4, "*");
                int n = stringTokenizer2.countTokens();
                for (int i = 0; i < n && (vector2.contains(string3 = stringTokenizer2.nextToken()) || vector3.contains(string3)); ++i) {
                    if (i < n - 1) continue;
                    vector.add(string4);
                }
            }
        }
        dialogDataModel.putArray(AbstractModelSubDialog.MODEL_TERMS_KEY, vector.toArray());
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.updateDialogDataModel();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.setDefaults();
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void runSaveSubDialog() {
        this.runSubDialog(new LoglinearCommonSave(this, this.getResString("IDS_LOGIT_SAVE_TITLE")));
    }

    private void runModelSubDialog() {
        VarListModel varListModel = this.mFactorTargetList.getModel();
        VarListModel varListModel2 = this.mCovariateTargetList.getModel();
        this.runSubDialog(new LogitModel(this, this.getResString("IDS_LOGLINEAR_LOGIT_MODEL_TITLE"), varListModel, varListModel2, null, "IDS_MODEL_SATURATED"));
    }

    private void runOptionSubDialog() {
        this.runSubDialog(new LoglinearCommonOptions(this, this.getResString("IDS_OPTION_TITLE")));
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        SpssVarFilter spssVarFilter = new SpssVarFilter(8, false);
        this.mSrcVarList.addVarFilter(spssVarFilter);
        this.mDependentTargetList = new TargetVariableList();
        this.mDependentTargetList.setIdentifier("IDS_LOGIT_DEPEND_LABEL");
        this.mDependentTargetList.addVarFilter(spssVarFilter);
        this.mDependentTargetList.getModel().addListDataListener(this);
        this.mFactorTargetList = new TargetVariableList();
        this.mFactorTargetList.setIdentifier("FactorList");
        this.mFactorTargetList.addVarFilter(spssVarFilter);
        this.mFactorTargetList.getModel().addListDataListener(this);
        this.mCovariateTargetList = new TargetVariableList();
        this.mCovariateTargetList.setIdentifier(COVARIATE_KEY);
        this.mCovariateTargetList.addVarFilter(spssVarFilter);
        this.mCovariateTargetList.getModel().addListDataListener(this);
        this.mStructureTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mStructureTargetList.setIdentifier("StructureList");
        this.mStructureTargetList.addVarFilter(spssVarFilter);
        this.mStructureTargetList.getModel().addListDataListener(this);
        this.mContrastTargetList = new TargetVariableList();
        this.mContrastTargetList.setIdentifier("ContrastList");
        this.mContrastTargetList.addVarFilter(spssVarFilter);
        this.mContrastTargetList.getModel().addListDataListener(this);
        this.mDependentArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mFactorArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCovariateArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mStrutureArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mContrastArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mConstraints = new GridBagConstraints();
        this.mAnchor = 23;
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(SAVE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogitDlg.this.runSaveSubDialog();
            }
        };
        this.mSaveButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(MODEL_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogitDlg.this.runModelSubDialog();
            }
        };
        this.mModelButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(OPTION_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogitDlg.this.runOptionSubDialog();
            }
        };
        this.mOptionButton = new JButton(toggleButtonAction);
        this.mDependentArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mDependentArrow.registerVariableList(this.mDependentTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mCovariateArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mCovariateArrow.registerVariableList(this.mCovariateTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mFactorArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mFactorArrow.registerVariableList(this.mFactorTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mStrutureArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mStrutureArrow.registerVariableList(this.mStructureTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mContrastArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mContrastArrow.registerVariableList(this.mContrastTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mDependentTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mFactorTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mCovariateTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mStructureTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mContrastTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mFactorTargetList.setMaxLimitOfList(9);
        this.mDependentTargetList.setMaxLimitOfList(10);
        this.mCovariateTargetList.setMaxLimitOfList(200);
    }

    private void setDefaults() {
        this.mDependentTargetList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mSaveButton.setEnabled(false);
        }
    }

    private Object[] tokenModelTerms(Object[] objectArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object : objectArray) {
            StringTokenizer stringTokenizer = new StringTokenizer(object.toString(), "*");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                hashSet.add(string);
            }
        }
        return hashSet.toArray();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mDependentArrow);
        vector.add(this.mFactorArrow);
        vector.add(this.mCovariateArrow);
        vector.add(this.mStrutureArrow);
        vector.add(this.mContrastArrow);
        vector.add(this.mDependentTargetList);
        vector.add(this.mFactorTargetList);
        vector.add(this.mCovariateTargetList);
        vector.add(this.mStructureTargetList);
        vector.add(this.mContrastTargetList);
        vector.add(this.mSaveButton);
        vector.add(this.mModelButton);
        vector.add(this.mOptionButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setupPanel(JPanel jPanel) {
        Insets insets = new Insets(0, DialogUtil.getComponentGroupGap(), 0, DialogUtil.getComponentGroupGap());
        this.mConstraints.fill = 1;
        this.mConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setupListPanel(), this.mConstraints, 0, 0, 1, 1, this.mAnchor, insets);
        this.mConstraints.weightx = 0.0;
        this.mConstraints.fill = 0;
        this.mAnchor = 24;
        DialogUtil.addUsingGBL(jPanel, this.setupOptionButtonPanel(), this.mConstraints, 1, 0, 1, 1, this.mAnchor, insets);
    }

    private JPanel setupListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.mConstraints.weightx = 1.0;
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mConstraints.fill = 2;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_LOGIT_SOURCE_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, this.mConstraints, 0, 0, 1, 1, this.mAnchor, null);
        this.mConstraints.fill = 1;
        this.mConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, this.mConstraints, 0, 1, 1, 9, this.mAnchor, null);
        Insets insets = DialogUtil.getStandardControlInsets();
        this.mAnchor = 10;
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mDependentArrow, this.mConstraints, 1, 1, 1, 1, this.mAnchor, insets2);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_LOGIT_DEPEND_LABEL");
        jLabel2.setLabelFor(this.mDependentTargetList);
        this.mConstraints.weightx = 1.0;
        this.mAnchor = 23;
        this.mConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, this.mConstraints, 2, 0, 1, 1, this.mAnchor, null);
        this.mConstraints.weighty = 1.0;
        Insets insets3 = new Insets(0, 0, 0, DialogUtil.getGroupBoxInnerMargin());
        this.mConstraints.fill = 1;
        jScrollPane = new JScrollPane(this.mDependentTargetList);
        this.mDependentTargetList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mDependentTargetList.getFixedCellHeight() * 2 + 2));
        jScrollPane.setPreferredSize(this.mDependentTargetList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, this.mConstraints, 2, 1, 1, 1, this.mAnchor, insets3);
        this.mAnchor = 10;
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mFactorArrow, this.mConstraints, 1, 3, 1, 1, this.mAnchor, insets2);
        Insets insets4 = new Insets(insets.top + 10, 0, 0, 0);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_LOGIT_FACTOR_LABEL");
        jLabel3.setLabelFor(this.mFactorTargetList);
        this.mConstraints.weightx = 1.0;
        this.mAnchor = 23;
        this.mConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel3, this.mConstraints, 2, 2, 1, 1, this.mAnchor, insets4);
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        jScrollPane = new JScrollPane(this.mFactorTargetList);
        this.mFactorTargetList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mFactorTargetList.getFixedCellHeight() * 2 + 2));
        jScrollPane.setPreferredSize(this.mFactorTargetList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, this.mConstraints, 2, 3, 1, 1, this.mAnchor, insets3);
        this.mAnchor = 10;
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mCovariateArrow, this.mConstraints, 1, 5, 1, 1, this.mAnchor, insets2);
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_LOGIT_COVARIATE_LABEL");
        jLabel4.setLabelFor(this.mCovariateTargetList);
        this.mConstraints.weightx = 1.0;
        this.mAnchor = 23;
        this.mConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel4, this.mConstraints, 2, 4, 1, 1, this.mAnchor, insets4);
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        jScrollPane = new JScrollPane(this.mCovariateTargetList);
        this.mCovariateTargetList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mCovariateTargetList.getFixedCellHeight() * 2 + 2));
        jScrollPane.setPreferredSize(this.mCovariateTargetList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, this.mConstraints, 2, 5, 1, 1, this.mAnchor, insets3);
        this.mAnchor = 20;
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        Insets insets5 = new Insets(0, insets2.left, 0, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.mStrutureArrow, this.mConstraints, 1, 6, 1, 2, this.mAnchor, insets5);
        JLabel jLabel5 = DialogUtil.createLabel(this, "IDS_LOGIT_STRUCTURE_LABEL");
        jLabel5.setLabelFor(this.mStructureTargetList);
        this.mConstraints.weightx = 1.0;
        this.mAnchor = 20;
        this.mConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel5, this.mConstraints, 2, 6, 1, 1, this.mAnchor, insets4);
        this.mAnchor = 23;
        this.mConstraints.fill = 2;
        jScrollPane = new JScrollPane(this.mStructureTargetList);
        jScrollPane.setPreferredSize(this.mStructureTargetList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, this.mConstraints, 2, 7, 1, 1, this.mAnchor, insets3);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        this.mAnchor = 10;
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mContrastArrow, this.mConstraints, 1, 9, 1, 1, this.mAnchor, insets2);
        JLabel jLabel6 = DialogUtil.createLabel(this, "IDS_LOGIT_CONTRAST_LABEL");
        jLabel6.setLabelFor(this.mContrastTargetList);
        this.mConstraints.weightx = 1.0;
        this.mAnchor = 23;
        this.mConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel6, this.mConstraints, 2, 8, 1, 1, this.mAnchor, insets4);
        this.mAnchor = 23;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        jScrollPane = new JScrollPane(this.mContrastTargetList);
        this.mContrastTargetList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mContrastTargetList.getFixedCellHeight() * 2 + 2));
        jScrollPane.setPreferredSize(this.mContrastTargetList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, this.mConstraints, 2, 9, 1, 1, this.mAnchor, insets3);
        return jPanel;
    }

    private JPanel setupOptionButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.mConstraints.fill = 0;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSaveButton, this.mConstraints, 3, 0, 1, 1, this.mAnchor, insets);
        insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mModelButton, this.mConstraints, 3, 1, 1, 1, this.mAnchor, insets);
        this.mConstraints.weighty = 1.0;
        insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mOptionButton, this.mConstraints, 3, 2, 1, 1, this.mAnchor, insets);
        UIToolDialogUtil.normalizeButtonWidths((JPanel)jPanel);
        return jPanel;
    }
}

