/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.kaplan_meier;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class KaplanMeierOptions
extends BaseSubDialog {
    static final String KAPLAN_MEIER_OPTIONS_STATS_SURVIVAL_KEY = "IDS_KAPLAN_MEIER_OPTIONS_STATS_SURVIVAL";
    static final String KAPLAN_MEIER_OPTIONS_STATS_MEAN_KEY = "IDS_KAPLAN_MEIER_OPTIONS_STATS_MEAN";
    static final String KAPLAN_MEIER_OPTIONS_STATS_QUARTILES_KEY = "IDS_KAPLAN_MEIER_OPTIONS_STATS_QUARTILES";
    static final String KAPLAN_MEIER_OPTIONS_PLOTS_SURVIVAL_KEY = "IDS_KAPLAN_MEIER_OPTIONS_PLOTS_SURVIVAL";
    static final String KAPLAN_MEIER_OPTIONS_PLOTS_MINUS_KEY = "IDS_KAPLAN_MEIER_OPTIONS_PLOTS_MINUS";
    static final String KAPLAN_MEIER_OPTIONS_PLOTS_HAZARD_KEY = "IDS_KAPLAN_MEIER_OPTIONS_PLOTS_HAZARD";
    static final String KAPLAN_MEIER_OPTIONS_PLOTS_LOGSURVIVAL_KEY = "IDS_KAPLAN_MEIER_OPTIONS_PLOTS_LOGSURVIVAL";
    private JCheckBox mSurvivalTablesCheck;
    private JCheckBox mMeanAndMedianCheck;
    private JCheckBox mQuartilesCheck;
    private JCheckBox mSurvivalCheck;
    private JCheckBox mOneMinusCheck;
    private JCheckBox mHazardCheck;
    private JCheckBox mLogSurvivalCheck;

    public KaplanMeierOptions(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_KAPLAN_MEIER_OPTIONS_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_kmei_opt";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        Insets insets = new Insets(0, 0, n, 0);
        DialogUtil.addUsingGBL(jPanel, this.setupStatisticsPanel(), gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.setupPlotsPanel(), gridBagConstraints, 0, 1, 2, 1, n2, null);
        this.pack();
    }

    private JPanel setupStatisticsPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mSurvivalTablesCheck, this.mMeanAndMedianCheck, this.mQuartilesCheck};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_KAPLAN_MEIER_OPTIONS_STATS"));
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupPlotsPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mSurvivalCheck, this.mOneMinusCheck, this.mHazardCheck, this.mLogSurvivalCheck};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_KAPLAN_MEIER_OPTIONS_PLOTS"));
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, KAPLAN_MEIER_OPTIONS_STATS_SURVIVAL_KEY);
        this.mSurvivalTablesCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, KAPLAN_MEIER_OPTIONS_STATS_MEAN_KEY);
        this.mMeanAndMedianCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, KAPLAN_MEIER_OPTIONS_STATS_QUARTILES_KEY);
        this.mQuartilesCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, KAPLAN_MEIER_OPTIONS_PLOTS_SURVIVAL_KEY);
        this.mSurvivalCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, KAPLAN_MEIER_OPTIONS_PLOTS_MINUS_KEY);
        this.mOneMinusCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, KAPLAN_MEIER_OPTIONS_PLOTS_HAZARD_KEY);
        this.mHazardCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, KAPLAN_MEIER_OPTIONS_PLOTS_LOGSURVIVAL_KEY);
        this.mLogSurvivalCheck = new JCheckBox(toggleButtonAction);
        this.mSurvivalTablesCheck.setSelected(true);
        this.mMeanAndMedianCheck.setSelected(true);
    }
}

