/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.kaplan_meier;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.adv_stats.kaplan_meier.KMSpssVarFormatter;
import com.spss.java_client.ui.dialogs.adv_stats.kaplan_meier.KMVarListModel;
import com.spss.java_client.ui.dialogs.adv_stats.kaplan_meier.KaplanMeierCompareFactors;
import com.spss.java_client.ui.dialogs.adv_stats.kaplan_meier.KaplanMeierDefineEvent;
import com.spss.java_client.ui.dialogs.adv_stats.kaplan_meier.KaplanMeierOptions;
import com.spss.java_client.ui.dialogs.adv_stats.kaplan_meier.KaplanMeierSave;
import com.spss.java_client.ui.dialogs.adv_stats.res.AdvStatsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BootstrapDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.util.CharacterUtil;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class KaplanMeierDlg
extends BaseProcedureDialog
implements ListDataListener,
MouseListener {
    private SrcVariableList mSrcVarList;
    TargetVariableList mTargetVarTimeList;
    private ArrowButton mTimeButton;
    TargetVariableList mTargetVarStatusList;
    private ArrowButton mVarStatusButton;
    KMSpssVarFormatter mStatusFormatter;
    TargetVariableList mTargetVarFactorList;
    private ArrowButton mFactorButton;
    TargetVariableList mTargetVarStrataList;
    private ArrowButton mStrataButton;
    TargetVariableList mTargetVarLabelList;
    private ArrowButton mVarLabelButton;
    private JButton mDefineEventButton;
    private JButton mCompareFactorButton;
    private JButton mSaveButton;
    private JButton mOptionButton;
    private JButton mBootstrappingButton;
    private boolean mIsEventDefined = false;
    private boolean mStatusVarIsString = false;
    private boolean mStatusSet = false;
    private boolean mIsBootstrapOK;

    public KaplanMeierDlg(JFrame jFrame) {
        super(jFrame, false, AdvStatsResBundle.getDefaultResourceBundleName(), AdvStatsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_KAPLAN_MEIER"));
        this.setLocationRelativeTo(this.getParent());
        this.initDialog();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object instanceof TargetVariableList) {
            TargetVariableList targetVariableList = (TargetVariableList)object;
            String string = targetVariableList.getIdentifier();
            if (string.equals("KaplanStatusList")) {
                this.mDefineEventButton.setEnabled(true);
            } else {
                this.mDefineEventButton.setEnabled(false);
            }
        } else if (object instanceof SrcVariableList) {
            if (this.mTargetVarStatusList.getModel().getSize() > 0) {
                this.mDefineEventButton.setEnabled(false);
            }
            this.mSrcVarList.requestFocus();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public String getDialogHelpID() {
        return "idh_kmei";
    }

    @Override
    public boolean okPastePressed() {
        if (this.mIsBootstrapOK && BootstrapDlg.isStrataVariableListEmpty(this)) {
            this.runSubDialog(new BootstrapDlg(this));
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public String generateSyntax() {
        String string;
        String string2;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        String string3 = SyntaxUtil.startSyntax().toString();
        if (this.mIsBootstrapOK) {
            string2 = "";
            string = this.mTargetVarStatusList.getVariablesStringList() + " " + this.mTargetVarTimeList.getVariablesStringList() + " " + this.mTargetVarFactorList.getVariablesStringList() + " " + this.mTargetVarStrataList.getVariablesStringList() + " ";
            string3 = string3 + BootstrapDlg.getBootstrapSyntax(string2, string, (DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY));
        }
        string3 = string3 + SyntaxUtil.getMainCommand("KM");
        string2 = this.mTargetVarTimeList.getVariablesStringList();
        if (string2 != null && string2.length() > 0) {
            string3 = string3 + SyntaxUtil.getMainCommandParamters(string2);
        }
        if ((string2 = this.mTargetVarFactorList.getVariablesStringList()) != null && string2.length() > 0) {
            string3 = string3 + " BY " + string2;
        }
        if ((string2 = this.mTargetVarStrataList.getVariablesStringList()) != null && string2.length() > 0) {
            string3 = string3 + "\n" + SyntaxUtil.getSubCommand("/STRATA=") + string2;
        }
        if ((string2 = this.mTargetVarLabelList.getVariablesStringList()) != null && string2.length() > 0) {
            string3 = string3 + "\n" + SyntaxUtil.getSubCommand("/ID=") + string2;
        }
        if ((string2 = this.mTargetVarStatusList.getVariablesStringList()) != null && string2.length() > 0) {
            string3 = string3 + "\n" + SyntaxUtil.getSubCommand("/STATUS=") + string2 + "(" + this.getEventString() + ")";
        }
        string3 = string3 + "\n" + SyntaxUtil.getSubCommand("/PRINT");
        string = "";
        boolean bl = false;
        Boolean bl2 = dialogDataModel.getBoolean("IDS_KAPLAN_MEIER_OPTIONS_STATS_SURVIVAL");
        if (bl2 == null) {
            string = string + " TABLE";
            bl = true;
        } else if (bl2.booleanValue()) {
            string = string + " TABLE";
            bl = true;
        }
        bl2 = dialogDataModel.getBoolean("IDS_KAPLAN_MEIER_OPTIONS_STATS_MEAN");
        if (bl2 == null) {
            string = string + " MEAN";
            bl = true;
        } else if (bl2.booleanValue()) {
            string = string + " MEAN";
            bl = true;
        }
        if (!bl) {
            string = string + " NONE";
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_KAPLAN_MEIER_OPTIONS_STATS_QUARTILES")) != null && bl2.booleanValue()) {
            string = string + "\n" + SyntaxUtil.getSubCommand("/PERCENTILES");
        }
        string3 = string3 + string;
        bl = false;
        string = "";
        bl2 = dialogDataModel.getBoolean("IDS_KAPLAN_MEIER_OPTIONS_PLOTS_SURVIVAL");
        if (bl2 != null && bl2.booleanValue()) {
            string = string + " SURVIVAL";
            bl = true;
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_KAPLAN_MEIER_OPTIONS_PLOTS_MINUS")) != null && bl2.booleanValue()) {
            string = string + " OMS";
            bl = true;
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_KAPLAN_MEIER_OPTIONS_PLOTS_HAZARD")) != null && bl2.booleanValue()) {
            string = string + " HAZARD";
            bl = true;
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_KAPLAN_MEIER_OPTIONS_PLOTS_LOGSURVIVAL")) != null && bl2.booleanValue()) {
            string = string + " LOGSURV";
            bl = true;
        }
        if (bl) {
            string3 = string3 + "\n" + SyntaxUtil.getSubCommand("/PLOT");
        }
        string3 = string3 + string;
        bl = false;
        string = "";
        bl2 = dialogDataModel.getBoolean("IDS_KAPLAN_MEIER_COMPARE_FACTOR_LOGRANK");
        if (bl2 != null && bl2.booleanValue()) {
            string = string + " LOGRANK";
            bl = true;
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_KAPLAN_MEIER_COMPARE_FACTOR_BRESLOW")) != null && bl2.booleanValue()) {
            string = string + " BRESLOW";
            bl = true;
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_KAPLAN_MEIER_COMPARE_FACTOR_TARONE_WARE")) != null && bl2.booleanValue()) {
            string = string + " TARONE";
            bl = true;
        }
        if (bl) {
            string3 = string3 + "\n" + SyntaxUtil.getSubCommand("/TEST");
        }
        string3 = string3 + string;
        string = "";
        if (bl) {
            bl = false;
            bl2 = dialogDataModel.getBoolean("IDS_KAPLAN_MEIER_COMPARE_FACTOR_LINEAR");
            if (bl2 != null && bl2.booleanValue()) {
                string3 = string3 + "\n" + SyntaxUtil.getSubCommand("/TREND");
            }
            if ((bl2 = dialogDataModel.getBoolean("IDS_KAPLAN_MEIER_COMPARE_FACTOR_POOLED")) != null && bl2.booleanValue()) {
                string = string + " OVERALL POOLED";
                bl = true;
            }
            if ((bl2 = dialogDataModel.getBoolean("IDS_KAPLAN_MEIER_COMPARE_FACTOR_EACH")) != null && bl2.booleanValue()) {
                string = string + " OVERALL STRATA";
                bl = true;
            }
            if ((bl2 = dialogDataModel.getBoolean("IDS_KAPLAN_MEIER_COMPARE_FACTOR_PAIRWISE")) != null && bl2.booleanValue()) {
                string = string + " PAIRWISE POOLED";
                bl = true;
            }
            if ((bl2 = dialogDataModel.getBoolean("IDS_KAPLAN_MEIER_COMPARE_FACTOR_PAIREACH")) != null && bl2.booleanValue()) {
                string = string + " PAIRWISE STRATA";
                bl = true;
            }
            if (bl) {
                string3 = string3 + "\n" + SyntaxUtil.getSubCommand("/COMPARE");
            }
        }
        string3 = string3 + string;
        bl2 = dialogDataModel.getBoolean("IDS_KAPLAN_MEIER_SAVE_SURVIVAL");
        string = "";
        bl = false;
        if (bl2 != null && bl2.booleanValue()) {
            string = string + " SURVIVAL";
            bl = true;
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_KAPLAN_MEIER_SAVE_STANDARD")) != null && bl2.booleanValue()) {
            string = string + " SE";
            bl = true;
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_KAPLAN_MEIER_SAVE_HAZARD")) != null && bl2.booleanValue()) {
            string = string + " HAZARD";
            bl = true;
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_KAPLAN_MEIER_SAVE_CUMULATIVE")) != null && bl2.booleanValue()) {
            string = string + " CUMEVENT";
            bl = true;
        }
        if (bl) {
            string3 = string3 + "\n" + SyntaxUtil.getSubCommand("/SAVE");
        }
        string3 = string3 + string;
        string3 = string3 + SyntaxUtil.terminateSyntax();
        return string3;
    }

    @Override
    public final String getIActionKey() {
        return "analyze_survival_kaplan_meier";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (this.mTargetVarStatusList.getModel().getSize() > 0 && !this.mStatusSet) {
            this.mDefineEventButton.setEnabled(true);
            KMVarListModel kMVarListModel = (KMVarListModel)this.mTargetVarStatusList.getModel();
            ISpssVariable iSpssVariable = kMVarListModel.getElementAt(0);
            this.mStatusVarIsString = iSpssVariable.getType() > 0;
            this.mStatusSet = true;
        }
        if (this.mTargetVarFactorList.getModel().getSize() > 0) {
            this.mCompareFactorButton.setEnabled(true);
        }
        this.updateOkAndPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource().equals(this.mTargetVarStatusList.getModel())) {
            this.getDialogDataModel().putString(KaplanMeierDefineEvent.EVENT_KEY, null);
        }
        if (this.mTargetVarStatusList.getModel().getSize() == 0) {
            this.mDefineEventButton.setEnabled(false);
            this.mStatusSet = false;
            this.mIsEventDefined = false;
            this.mStatusVarIsString = false;
        }
        if (this.mTargetVarFactorList.getModel().getSize() == 0) {
            this.mCompareFactorButton.setEnabled(false);
        }
        this.updateOkAndPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        String string = this.getEventString();
        if (string.length() > 0) {
            this.mIsEventDefined = true;
        }
        this.updateOkAndPaste();
    }

    @Override
    public void reset() {
        super.reset();
        this.mStatusVarIsString = false;
        this.mIsEventDefined = false;
        this.mTargetVarTimeList.removeAll();
        this.mTargetVarStatusList.removeAll();
        this.mTargetVarFactorList.removeAll();
        this.mTargetVarStrataList.removeAll();
        this.mTargetVarLabelList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.requestFocusInWindow();
        this.setDefaults();
    }

    public boolean IsStringObject() {
        return this.mStatusVarIsString;
    }

    protected void updateOkAndPaste() {
        this.enableOkPaste(this.mTargetVarTimeList.getModel().getSize() > 0 && this.mTargetVarStatusList.getModel().getSize() > 0 && this.mIsEventDefined);
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KaplanMeierCompareFactors kaplanMeierCompareFactors = new KaplanMeierCompareFactors(KaplanMeierDlg.this);
                KaplanMeierDlg.this.runSubDialog(kaplanMeierCompareFactors);
            }
        };
        String string = "IDS_KAPLAN_MEIER_COMPFACTOR";
        abstractAction.putValue("Name", this.getResString(string));
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            string = string.replace("IDS_", "IDK_");
            abstractAction.putValue("MnemonicKey", this.getDlgAccessKey(string + "_KEY"));
        }
        this.mCompareFactorButton = new JButton(abstractAction);
        this.addOptionsPanelButton(jPanel, this.mCompareFactorButton);
        this.mCompareFactorButton.setEnabled(false);
        abstractAction = new ToggleButtonAction("IDS_COMMON_SAVE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KaplanMeierSave kaplanMeierSave = new KaplanMeierSave(KaplanMeierDlg.this);
                KaplanMeierDlg.this.runSubDialog(kaplanMeierSave);
            }
        };
        this.mSaveButton = new JButton(abstractAction);
        this.addOptionsPanelButton(jPanel, this.mSaveButton);
        abstractAction = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KaplanMeierOptions kaplanMeierOptions = new KaplanMeierOptions(KaplanMeierDlg.this);
                KaplanMeierDlg.this.runSubDialog(kaplanMeierOptions);
            }
        };
        this.mOptionButton = new JButton(abstractAction);
        this.addOptionsPanelButton(jPanel, this.mOptionButton);
        this.mIsBootstrapOK = false;
        if (this.mIsBootstrapOK) {
            this.mIsBootstrapOK = true;
            abstractAction = new ToggleButtonAction("IDS_COMMON_BOOTSTRAPPING_BUTTON"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    KaplanMeierDlg.this.runSubDialog(new BootstrapDlg(KaplanMeierDlg.this));
                }
            };
            this.mBootstrappingButton = new JButton(abstractAction);
            this.addOptionsPanelButton(jPanel, this.mBootstrappingButton);
            if (BootstrapDlg.isCurrentDatasetInMIMode()) {
                this.mBootstrappingButton.setEnabled(false);
                this.mIsBootstrapOK = false;
            }
        }
        return jPanel;
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mStatusFormatter.setVarMap(this.getDialogDataModel().getMap(this.mTargetVarStatusList.getIdentifier()));
        if (this.getEventString().length() > 0) {
            this.mIsEventDefined = true;
        }
        this.updateOkAndPaste();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocusInWindow();
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putMap(this.mTargetVarStatusList.getIdentifier(), this.mStatusFormatter.getVarMapForSerialization());
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupLists(jPanel);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    private void setDefaults() {
        this.mSrcVarList.setSelectedIndex(0);
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mSaveButton.setEnabled(false);
        }
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setIdentifier("KaplanSrcList");
        this.mSrcVarList.addMouseListener(this);
        TargetVariableList.TargetListType targetListType = TargetVariableList.TargetListType.single_item;
        this.mTargetVarTimeList = new TargetVariableList(targetListType);
        this.mTargetVarTimeList.addMouseListener(this);
        this.mTargetVarTimeList.setIdentifier("KaplanTimeList");
        this.mTargetVarTimeList.addVarFilter(new SpssVarFilter(16, false, false));
        this.mTargetVarStatusList = new TargetVariableList(targetListType);
        this.mStatusFormatter = new KMSpssVarFormatter(this.mTargetVarStatusList);
        this.mTargetVarStatusList.setModel(new KMVarListModel(this.mStatusFormatter));
        this.mTargetVarStatusList.setCellRenderer(new CustomVarListCellRenderer(this.mStatusFormatter));
        this.mTargetVarStatusList.setIdentifier("KaplanStatusList");
        this.mTargetVarStatusList.addMouseListener(this);
        this.mTargetVarFactorList = new TargetVariableList(targetListType);
        this.mTargetVarFactorList.addMouseListener(this);
        this.mTargetVarFactorList.setIdentifier("KaplanFactorList");
        this.mTargetVarStrataList = new TargetVariableList(targetListType);
        this.mTargetVarStrataList.addMouseListener(this);
        this.mTargetVarStrataList.setIdentifier("KaplanStrataList");
        this.mTargetVarLabelList = new TargetVariableList(targetListType);
        this.mTargetVarLabelList.addMouseListener(this);
        this.mTargetVarLabelList.setIdentifier("KaplanLabelCaseList");
        this.mVarStatusButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mFactorButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mStrataButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mVarLabelButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
    }

    private void setupLists(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_KAPLAN_MEIER_SOURCE_LIST_LABEL");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 20;
        Insets insets = new Insets(0, 0, 0, 0);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 11, n, insets);
        Insets insets2 = new Insets(0, DialogUtil.getArrowButtonInsets().left, 0, DialogUtil.getArrowButtonInsets().right);
        Insets insets3 = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        this.setTargetListWithArrow(jPanel, this.mTargetVarTimeList, this.mTimeButton, "IDS_KAPLAN_MEIER_TIME", gridBagConstraints, insets, insets2, insets3, 1, 0);
        this.setTargetListWithArrow(jPanel, this.mTargetVarStatusList, this.mVarStatusButton, "IDS_COX_REG_STATUS_COLON", gridBagConstraints, insets, insets2, insets3, 1, 2);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KaplanMeierDefineEvent kaplanMeierDefineEvent = new KaplanMeierDefineEvent(KaplanMeierDlg.this);
                if (KaplanMeierDlg.this.mStatusVarIsString) {
                    kaplanMeierDefineEvent.setString();
                } else {
                    kaplanMeierDefineEvent.mRangeValueRadio.setEnabled(true);
                }
                KaplanMeierDlg.this.runSubDialog(kaplanMeierDefineEvent);
                String string = KaplanMeierDlg.this.getEventString();
                if (string.length() > 0) {
                    ((KMVarListModel)KaplanMeierDlg.this.mTargetVarStatusList.getModel()).setElementPropertyAt(0, string);
                    KaplanMeierDlg.this.mIsEventDefined = true;
                    KaplanMeierDlg.this.updateOkAndPaste();
                }
            }
        };
        String string = "IDS_KAPLAN_MEIER_DEFEVENT";
        abstractAction.putValue("Name", this.getResString(string));
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            string = string.replace("IDS_", "IDK_");
            abstractAction.putValue("MnemonicKey", this.getDlgAccessKey(string + "_KEY"));
        }
        this.mDefineEventButton = new JButton(abstractAction);
        this.mDefineEventButton.setEnabled(false);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mDefineEventButton, gridBagConstraints, 2, 4, 1, 1, n, insets3);
        this.setTargetListWithArrow(jPanel, this.mTargetVarFactorList, this.mFactorButton, "IDS_KAPLAN_MEIER_FACTOR", gridBagConstraints, insets, insets2, insets3, 1, 6);
        this.setTargetListWithArrow(jPanel, this.mTargetVarStrataList, this.mStrataButton, "IDS_KAPLAN_MEIER_STRATA", gridBagConstraints, insets, insets2, insets3, 1, 8);
        this.setTargetListWithArrow(jPanel, this.mTargetVarLabelList, this.mVarLabelButton, "IDS_KAPLAN_MEIER_LABELCASEBY", gridBagConstraints, insets, insets2, insets3, 1, 10);
    }

    private void setTargetListWithArrow(JPanel jPanel, TargetVariableList targetVariableList, ArrowButton arrowButton, String string, GridBagConstraints gridBagConstraints, Insets insets, Insets insets2, Insets insets3, int n, int n2) {
        JLabel jLabel = DialogUtil.createLabel(this, string);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n3 = 21;
        gridBagConstraints.fill = 2;
        if (string.equals("IDS_KAPLAN_MEIER_TIME")) {
            DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, n + 1, n2, 1, 1, n3, null);
        } else {
            DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, n + 1, n2, 1, 1, n3, insets3);
        }
        targetVariableList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        n3 = 23;
        gridBagConstraints.weighty = 0.0;
        JScrollPane jScrollPane = new JScrollPane(targetVariableList);
        jScrollPane.setPreferredSize(targetVariableList.getMinimumSize());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, n + 1, n2 + 1, 1, 1, n3, insets);
        targetVariableList.getModel().addListDataListener(this);
        jLabel.setLabelFor(targetVariableList);
        n3 = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        if (string.equals("IDS_KAPLAN_MEIER_TIME")) {
            this.mTimeButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
            DialogUtil.addUsingGBL(jPanel, this.mTimeButton, gridBagConstraints, n, n2, 1, 2, n3, insets2);
        } else {
            DialogUtil.addUsingGBL(jPanel, arrowButton, gridBagConstraints, n, n2, 1, 2, n3, insets2);
        }
        if (string.equals("IDS_KAPLAN_MEIER_TIME")) {
            this.mTimeButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
            this.mTimeButton.registerVariableList(targetVariableList, SpssArrowButton.ButtonOrientation.left);
        } else {
            arrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
            arrowButton.registerVariableList(targetVariableList, SpssArrowButton.ButtonOrientation.left);
        }
    }

    private String getEventString() {
        String string = "";
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        if (dialogDataModel.getString(KaplanMeierDefineEvent.EVENT_KEY) == null) {
            return string;
        }
        Boolean bl = dialogDataModel.getBoolean("IDS_COX_REG_SINGLE_VALUE_COLON");
        if (bl != null && bl.booleanValue()) {
            string = this.mStatusVarIsString ? CharacterUtil.smartQuote((String)dialogDataModel.getString("IDS_KAPLAN_MEIER_DEFINE_EVENT_SINGLE_EDIT")) : dialogDataModel.getString("IDS_KAPLAN_MEIER_DEFINE_EVENT_SINGLE_EDIT");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_COX_REG_RANGE_OF_VALUES_COLON")) != null && bl.booleanValue()) {
            string = dialogDataModel.getString("IDS_KAPLAN_MEIER_DEFINE_EVENT_RANGE_LOW_EDIT") + " THRU " + dialogDataModel.getString("IDS_KAPLAN_MEIER_DEFINE_EVENT_RANGE_HIGH_EDIT");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_COX_REG_LIST_OF_VALUES_COLON")) != null && bl.booleanValue()) {
            String[] stringArray;
            for (String string2 : stringArray = (String[])dialogDataModel.getArray("IDS_LAYERS")) {
                string = this.mStatusVarIsString ? string + CharacterUtil.smartQuote((String)string2) : string + string2;
                string = string + " ";
            }
            if (string.length() > 0) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    private void initDialog() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        dialogDataModel.putBoolean("IDS_KAPLAN_MEIER_OPTIONS_STATS_SURVIVAL", true);
        dialogDataModel.putBoolean("IDS_KAPLAN_MEIER_OPTIONS_STATS_MEAN", true);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mTimeButton);
        vector.add(this.mVarStatusButton);
        vector.add(this.mFactorButton);
        vector.add(this.mStrataButton);
        vector.add(this.mVarLabelButton);
        vector.add(this.mTargetVarTimeList);
        vector.add(this.mTargetVarStatusList);
        vector.add(this.mDefineEventButton);
        if (this.mTargetVarFactorList.getModel().getSize() > 0) {
            vector.add(this.mTargetVarFactorList);
        }
        if (this.mTargetVarStrataList.getModel().getSize() > 0) {
            vector.add(this.mTargetVarStrataList);
        }
        if (this.mTargetVarLabelList.getModel().getSize() > 0) {
            vector.add(this.mCompareFactorButton);
        }
        vector.add(this.mSaveButton);
        vector.add(this.mOptionButton);
        if (VersionInfo.allowBootstrapping()) {
            vector.add(this.mBootstrappingButton);
        }
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }
}

