/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.kaplan_meier;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ACREvent;
import com.spss.java_client.ui.controls.ACRWidget;
import com.spss.java_client.ui.controls.IACRListener;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.adv_stats.kaplan_meier.KaplanMeierDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class KaplanMeierDefineEvent
extends BaseSubDialog
implements ItemListener,
IACRListener,
DocumentListener,
FocusListener {
    static final String KAPLAN_MEIER_DEFINE_EVENT_SINGLE_KEY = "IDS_COX_REG_SINGLE_VALUE_COLON";
    static final String KAPLAN_MEIER_DEFINE_EVENT_RANGE_KEY = "IDS_COX_REG_RANGE_OF_VALUES_COLON";
    static final String KAPLAN_MEIER_DEFINE_EVENT_LIST_KEY = "IDS_COX_REG_LIST_OF_VALUES_COLON";
    static final String KAPLAN_MEIER_DEFINE_EVENT_ADD_KEY = "IDS_KAPLAN_MEIER_DEFINE_EVENT_ADD";
    static final String KAPLAN_MEIER_DEFINE_EVENT_CHANGE_KEY = "IDS_KAPLAN_MEIER_DEFINE_EVENT_CHANGE";
    static final String KAPLAN_MEIER_DEFINE_EVENT_REMOVE_KEY = "IDS_KAPLAN_MEIER_DEFINE_EVENT_REMOVE";
    static final String KAPLAN_MEIER_DEFINE_EVENT_SINGLE_VALUE_KEY = "IDS_KAPLAN_MEIER_DEFINE_EVENT_SINGLE_EDIT";
    static final String KAPLAN_MEIER_DEFINE_EVENT_RANGE_LOW_VALUE_KEY = "IDS_KAPLAN_MEIER_DEFINE_EVENT_RANGE_LOW_EDIT";
    static final String KAPLAN_MEIER_DEFINE_EVENT_RANGE_HIGH_VALUE_KEY = "IDS_KAPLAN_MEIER_DEFINE_EVENT_RANGE_HIGH_EDIT";
    static final String KAPLAN_MEIER_DEFINE_EVENT_LIST_VALUE_KEY = "IDS_KAPLAN_MEIER_DEFINE_EVENT_LIST_EDIT";
    public static String EVENT_KEY = "EVENT_KEY";
    static final String LAYER_COUNT_KEY = "IDS_LAYER_COUNT";
    static final String LAYERS_KEY = "IDS_LAYERS";
    static final String CURRENT_LAYER_KEY = "IDS_CURRENT_LAYER";
    private final double MIN_VALUE = -999.0;
    private final double MAX_VALUE = 9999.0;
    private final int MAX_PRE = 3;
    private ACRWidget mACRWidget;
    private JRadioButton mSingleValueRadio;
    private JTextField mSingleValueEdit;
    JRadioButton mRangeValueRadio;
    private FloatTextField mRangeValueLowEdit;
    private JLabel mThroughLabel;
    private FloatTextField mRangeValueHighEdit;
    private JRadioButton mListValueRadio;
    private JTextField mListValueEdit;
    private boolean mIsString = false;
    private Vector<String[]> mLayers;
    private SpssButtonGroup mGroup;

    public KaplanMeierDefineEvent(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_KAPLAN_MEIER_DEFINE_EVENT"), true);
        this.setLocationRelativeTo(this.getParent());
        this.addLayer();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_kmei_evnt";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        Object object = itemEvent.getItem();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (object == this.mSingleValueRadio) {
            this.mSingleValueEdit.setEnabled(bl);
            this.mSingleValueEdit.setOpaque(bl);
            this.updateContinueButton();
        } else if (object == this.mRangeValueRadio && !this.mIsString) {
            this.mRangeValueLowEdit.setEnabled(bl);
            this.mRangeValueLowEdit.setOpaque(bl);
            this.mThroughLabel.setEnabled(bl);
            this.mRangeValueHighEdit.setEnabled(bl);
            this.mRangeValueHighEdit.setOpaque(bl);
            this.updateContinueButton();
        } else if (object == this.mListValueRadio) {
            this.mListValueEdit.setEnabled(bl);
            this.mListValueEdit.setOpaque(bl);
            this.mACRWidget.setEnabled(bl);
            this.updateContinueButton();
        }
        this.disableRange();
    }

    private void disableRange() {
        if (this.mIsString) {
            this.mRangeValueRadio.setEnabled(false);
            this.mRangeValueLowEdit.setEnabled(false);
            this.mRangeValueLowEdit.setOpaque(false);
            this.mThroughLabel.setEnabled(false);
            this.mRangeValueHighEdit.setEnabled(false);
            this.mRangeValueHighEdit.setOpaque(false);
        }
    }

    @Override
    public void listChanged(ACREvent aCREvent) {
        this.updateContinueButton();
    }

    @Override
    public boolean continuePressed() {
        this.saveLayer();
        if (this.mRangeValueRadio != null && this.mRangeValueRadio.isSelected()) {
            String string = this.mRangeValueLowEdit.getText();
            String string2 = this.mRangeValueHighEdit.getText();
            if (string.length() > 0 && string2.length() > 0 && Double.parseDouble(string) >= Double.parseDouble(string2)) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_KAPLAN_MEIER_DEFINE_EVENT_RANGE_WARNING"), VersionInfo.getAppVersionString());
                return false;
            }
        }
        return true;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mSingleValueEdit)) {
            this.mSingleValueEdit.selectAll();
        } else if (focusEvent.getSource().equals(this.mListValueEdit)) {
            this.mListValueEdit.selectAll();
        } else if (focusEvent.getSource().equals(this.mRangeValueHighEdit)) {
            this.mRangeValueHighEdit.selectAll();
        } else if (focusEvent.getSource().equals(this.mRangeValueLowEdit)) {
            this.mRangeValueLowEdit.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        this.mLayers = new Vector();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.pack();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        boolean bl = super.saveState(dialogDataModel);
        if (bl) {
            dialogDataModel.putString(EVENT_KEY, "GOOD");
            if (this.mLayers.size() > 0) {
                dialogDataModel.putArray(LAYERS_KEY, this.mLayers.get(0));
            }
        }
        return bl;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        this.mLayers.clear();
        String[] stringArray = (String[])dialogDataModel.getArray(LAYERS_KEY);
        if (stringArray == null || stringArray != null && stringArray.length == 0) {
            this.mLayers.add(new String[0]);
        } else {
            this.mLayers.add(stringArray);
        }
        if (dialogDataModel.getString(EVENT_KEY) == null) {
            this.setDefaults();
            this.mLayers.set(0, new String[0]);
        }
        this.doListPopulate();
    }

    private void doListPopulate() {
        this.mACRWidget.clear();
        String[] stringArray = this.mLayers.get(0);
        this.mACRWidget.setListItems(stringArray);
        this.repaint();
    }

    private void addLayer() {
        this.mLayers.add(new String[0]);
    }

    void setString() {
        this.mIsString = true;
    }

    private JPanel setupSingleValuePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, 2 * n + 3);
        DialogUtil.addUsingGBL(jPanel, this.mSingleValueRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        insets2.set(insets.top, 0, insets.bottom, 2);
        DialogUtil.addUsingGBL(jPanel, this.mSingleValueEdit, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
        return jPanel;
    }

    private JPanel setupRangeOfValuePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mRangeValueRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        Insets insets2 = new Insets(insets.top, 0, insets.bottom, n);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mRangeValueLowEdit, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 0.0;
        insets2.set(0, 0, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mThroughLabel, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        insets2.set(insets.top, 0, insets.bottom, 2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mRangeValueHighEdit, gridBagConstraints, 3, 0, 1, 1, n2, insets2);
        return jPanel;
    }

    private JPanel setupListOfValuesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, 2 * n + 3);
        gridBagConstraints.weightx = 0.0;
        insets2.set(insets.top, insets.left, insets.bottom, 2 * n - 1);
        DialogUtil.addUsingGBL(jPanel, this.mListValueRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        insets2.set(insets.top, 0, insets.bottom, 2);
        DialogUtil.addUsingGBL(jPanel, this.mListValueEdit, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
        return jPanel;
    }

    private void setupPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        Insets insets2 = new Insets(0, 0, 0, 0);
        JLabel jLabel = new JLabel(this.getResString("IDS_KAPLAN_MEIER_DEFINE_EVENT_STATE"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.setupSingleValuePanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.setupRangeOfValuePanel(), gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.setupListOfValuesPanel(), gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets2 = new Insets(insets.top + 2, 40, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mACRWidget, gridBagConstraints, 0, 4, 3, 1, n, insets2);
    }

    private void initVars() {
        this.mSingleValueRadio = new JRadioButton(new ToggleButtonAction(this, KAPLAN_MEIER_DEFINE_EVENT_SINGLE_KEY));
        this.mSingleValueRadio.addItemListener(this);
        if (((KaplanMeierDlg)this.mParentDlg).IsStringObject()) {
            this.mSingleValueEdit = new StringTextField();
            this.mListValueEdit = new StringTextField();
            this.mIsString = true;
        } else {
            this.mSingleValueEdit = new FloatTextField(-999.0, 9999.0, 3, false);
            this.mListValueEdit = new FloatTextField(-999.0, 9999.0, 3, false);
        }
        this.mSingleValueEdit.addFocusListener(this);
        this.mListValueEdit.addFocusListener(this);
        this.mACRWidget = new ACRWidget(this.mListValueEdit);
        this.mACRWidget.addACRListener(this);
        this.mACRWidget.setSerializable(false);
        this.mACRWidget.setAllowDuplicates(false);
        Dimension dimension = (Dimension)this.mListValueEdit.getPreferredSize().clone();
        dimension.width = 60;
        this.mListValueEdit.setPreferredSize(dimension);
        this.mListValueRadio = new JRadioButton(new ToggleButtonAction(this, KAPLAN_MEIER_DEFINE_EVENT_LIST_KEY));
        this.mListValueRadio.addItemListener(this);
        dimension = (Dimension)this.mSingleValueEdit.getPreferredSize().clone();
        dimension.width = 60;
        this.mSingleValueEdit.setPreferredSize(dimension);
        this.mSingleValueEdit.setAction(new TextFieldAction(this.mParentDlg, KAPLAN_MEIER_DEFINE_EVENT_SINGLE_VALUE_KEY));
        this.mSingleValueEdit.getDocument().addDocumentListener(this);
        this.mRangeValueRadio = new JRadioButton(new ToggleButtonAction(this, KAPLAN_MEIER_DEFINE_EVENT_RANGE_KEY));
        this.mRangeValueRadio.addItemListener(this);
        this.mRangeValueLowEdit = new FloatTextField(-999.0, 9999.0, 3, false);
        dimension = (Dimension)this.mRangeValueLowEdit.getPreferredSize().clone();
        dimension.width = 60;
        this.mRangeValueLowEdit.setPreferredSize(dimension);
        this.mRangeValueLowEdit.setAction((Action)new TextFieldAction(this.mParentDlg, KAPLAN_MEIER_DEFINE_EVENT_RANGE_LOW_VALUE_KEY));
        this.mRangeValueLowEdit.getDocument().addDocumentListener(this);
        this.mRangeValueLowEdit.addFocusListener((FocusListener)this);
        if (this.mIsString) {
            this.mRangeValueLowEdit.setEditable(false);
        }
        this.mRangeValueHighEdit = new FloatTextField(-999.0, 9999.0, 3, false);
        this.mThroughLabel = DialogUtil.createLabel(this, "IDS_KAPLAN_MEIER_DEFINE_EVENT_THROUGH");
        this.mThroughLabel.setLabelFor((Component)this.mRangeValueHighEdit);
        dimension = (Dimension)this.mRangeValueHighEdit.getPreferredSize().clone();
        dimension.width = 160;
        this.mRangeValueHighEdit.setPreferredSize(dimension);
        this.mRangeValueHighEdit.setAction((Action)new TextFieldAction(this.mParentDlg, KAPLAN_MEIER_DEFINE_EVENT_RANGE_HIGH_VALUE_KEY));
        this.mRangeValueHighEdit.getDocument().addDocumentListener(this);
        this.mRangeValueHighEdit.addFocusListener((FocusListener)this);
        if (this.mIsString) {
            this.mRangeValueHighEdit.setEditable(false);
        }
        this.mGroup = new SpssButtonGroup();
        this.mGroup.add(this.mSingleValueRadio);
        this.mGroup.add(this.mRangeValueRadio);
        this.mGroup.add(this.mListValueRadio);
    }

    private void setDefaults() {
        this.mSingleValueRadio.setSelected(true);
        this.mRangeValueLowEdit.setOpaque(false);
        this.mRangeValueLowEdit.setText("");
        this.mRangeValueLowEdit.setEnabled(false);
        this.mRangeValueHighEdit.setOpaque(false);
        this.mRangeValueHighEdit.setEnabled(false);
        this.mRangeValueHighEdit.setText("");
        this.mThroughLabel.setEnabled(false);
        this.mListValueEdit.setEnabled(false);
        this.mListValueEdit.setText("");
        this.mListValueEdit.setOpaque(false);
        this.mACRWidget.setOpaque(false);
        this.mACRWidget.setEnabled(false);
        this.mSingleValueEdit.setText("");
    }

    private void updateContinueButton() {
        boolean bl = false;
        if (this.mSingleValueRadio.isEnabled() && this.mSingleValueRadio.isSelected()) {
            boolean bl2 = bl = this.mSingleValueEdit.getText().length() > 0;
        }
        if (this.mRangeValueRadio.isEnabled() && this.mRangeValueRadio.isSelected()) {
            boolean bl3 = bl = this.mRangeValueLowEdit.getText().length() > 0 && this.mRangeValueHighEdit.getText().length() > 0;
        }
        if (this.mListValueRadio.isEnabled() && this.mListValueRadio.isSelected()) {
            bl = this.mACRWidget.getList().getModel().getSize() > 0;
        }
        this.enableContinue(bl);
    }

    private boolean saveLayer() {
        boolean bl = false;
        String[] stringArray = this.mACRWidget.getListItems();
        if (stringArray.length > 0) {
            if (this.mLayers.size() > 0) {
                this.mLayers.set(0, stringArray);
            } else {
                this.mLayers.add(stringArray);
            }
            bl = true;
        }
        return bl;
    }
}

