/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.kaplan_meier;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class KaplanMeierCompareFactors
extends BaseSubDialog
implements ItemListener {
    static final String KAPLAN_MEIER_COMPARE_FACTOR_LOGRANK_KEY = "IDS_KAPLAN_MEIER_COMPARE_FACTOR_LOGRANK";
    static final String KAPLAN_MEIER_COMPARE_FACTOR_BRESLOW_KEY = "IDS_KAPLAN_MEIER_COMPARE_FACTOR_BRESLOW";
    static final String KAPLAN_MEIER_COMPARE_FACTOR_TARONE_WARE_KEY = "IDS_KAPLAN_MEIER_COMPARE_FACTOR_TARONE_WARE";
    static final String KAPLAN_MEIER_COMPARE_FACTOR_LINEAR_KEY = "IDS_KAPLAN_MEIER_COMPARE_FACTOR_LINEAR";
    static final String KAPLAN_MEIER_COMPARE_FACTOR_POOLED_KEY = "IDS_KAPLAN_MEIER_COMPARE_FACTOR_POOLED";
    static final String KAPLAN_MEIER_COMPARE_FACTOR_EACH_KEY = "IDS_KAPLAN_MEIER_COMPARE_FACTOR_EACH";
    static final String KAPLAN_MEIER_COMPARE_FACTOR_PAIRWISE_KEY = "IDS_KAPLAN_MEIER_COMPARE_FACTOR_PAIRWISE";
    static final String KAPLAN_MEIER_COMPARE_FACTOR_PAIREACH_KEY = "IDS_KAPLAN_MEIER_COMPARE_FACTOR_PAIREACH";
    private JCheckBox mLogRank;
    private JCheckBox mBreslow;
    private JCheckBox mTaroneWare;
    private JCheckBox mLinearTrend;
    private JRadioButton mPooledRadio;
    private JRadioButton mEachRadio;
    private JRadioButton mPairwiseOverRadio;
    private JRadioButton mPairwiseEachRadio;
    private SpssButtonGroup mGroup;

    public KaplanMeierCompareFactors(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_KAPLAN_MEIER_COMPARE_FACTOR"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_kmei_comp";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (this.mLogRank == object || this.mBreslow == object || this.mTaroneWare == object) {
            this.mLinearTrend.setEnabled(itemEvent.getStateChange() == 1);
            this.mPooledRadio.setEnabled(itemEvent.getStateChange() == 1);
            this.mEachRadio.setEnabled(itemEvent.getStateChange() == 1);
            this.mPairwiseOverRadio.setEnabled(itemEvent.getStateChange() == 1);
            this.mPairwiseEachRadio.setEnabled(itemEvent.getStateChange() == 1);
        }
        this.continueCheck();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        Insets insets = new Insets(0, 0, n, 0);
        DialogUtil.addUsingGBL(jPanel, this.setupTestStatisticsPanel(), gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.setupFactorLevelPanel(), gridBagConstraints, 0, 1, 2, 1, n2, null);
        this.pack();
    }

    private void continueCheck() {
        boolean bl;
        boolean bl2 = bl = this.mLogRank.isSelected() || this.mBreslow.isSelected() || this.mTaroneWare.isSelected();
        if (bl) {
            this.mLinearTrend.setEnabled(bl);
            this.mPooledRadio.setEnabled(bl);
            this.mEachRadio.setEnabled(bl);
            this.mPairwiseOverRadio.setEnabled(bl);
            this.mPairwiseEachRadio.setEnabled(bl);
            this.trendLevelCheck();
            this.pairwiseCheck();
        }
    }

    private void trendLevelCheck() {
        if (this.mLinearTrend.isSelected()) {
            this.mPairwiseOverRadio.setEnabled(false);
            this.mPairwiseEachRadio.setEnabled(false);
        }
    }

    private void pairwiseCheck() {
        if (this.mPairwiseOverRadio.isSelected() || this.mPairwiseEachRadio.isSelected()) {
            this.mLinearTrend.setEnabled(false);
        }
    }

    private JPanel setupTestStatisticsPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mLogRank, this.mBreslow, this.mTaroneWare};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.xaxis, this.getResString("IDS_KAPLAN_MEIER_COMPARE_FACTOR_TITLE"));
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, KAPLAN_MEIER_COMPARE_FACTOR_LOGRANK_KEY);
        this.mLogRank = new JCheckBox(toggleButtonAction);
        this.mLogRank.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, KAPLAN_MEIER_COMPARE_FACTOR_BRESLOW_KEY);
        this.mBreslow = new JCheckBox(toggleButtonAction);
        this.mBreslow.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, KAPLAN_MEIER_COMPARE_FACTOR_TARONE_WARE_KEY);
        this.mTaroneWare = new JCheckBox(toggleButtonAction);
        this.mTaroneWare.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, KAPLAN_MEIER_COMPARE_FACTOR_LINEAR_KEY);
        this.mLinearTrend = new JCheckBox(toggleButtonAction);
        this.mLinearTrend.addItemListener(this);
        this.mPooledRadio = new JRadioButton(new ToggleButtonAction(this, KAPLAN_MEIER_COMPARE_FACTOR_POOLED_KEY));
        this.mEachRadio = new JRadioButton(new ToggleButtonAction(this, KAPLAN_MEIER_COMPARE_FACTOR_EACH_KEY));
        this.mPairwiseOverRadio = new JRadioButton(new ToggleButtonAction(this, KAPLAN_MEIER_COMPARE_FACTOR_PAIRWISE_KEY));
        this.mPairwiseOverRadio.addItemListener(this);
        this.mPairwiseEachRadio = new JRadioButton(new ToggleButtonAction(this, KAPLAN_MEIER_COMPARE_FACTOR_PAIREACH_KEY));
        this.mPairwiseEachRadio.addItemListener(this);
        this.mGroup = new SpssButtonGroup();
        this.mGroup.add(this.mPooledRadio);
        this.mGroup.add(this.mEachRadio);
        this.mGroup.add(this.mPairwiseOverRadio);
        this.mGroup.add(this.mPairwiseEachRadio);
    }

    private void setDefaults() {
        this.mLinearTrend.setEnabled(false);
        this.mPooledRadio.setSelected(true);
        this.mPooledRadio.setEnabled(false);
        this.mEachRadio.setEnabled(false);
        this.mPairwiseOverRadio.setEnabled(false);
        this.mPairwiseEachRadio.setEnabled(false);
    }

    private JPanel setupFactorLevelPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(""));
        DialogUtil.addUsingGBL(jPanel, this.mLinearTrend, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mPooledRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mEachRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mPairwiseOverRadio, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mPairwiseEachRadio, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        return jPanel;
    }
}

