/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.cox_regression;

import com.spss.charteditor.component.LimitedPlainDocument;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.CustomVarListModel;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFormatter;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.adv_stats.AbstractCoxDialog;
import com.spss.java_client.ui.dialogs.adv_stats.cox_regression.CoxRegressionCategorical;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.controls.SPSSTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;

public class CoxRegressionPlots
extends BaseSubDialog
implements ActionListener,
ItemListener,
ListSelectionListener,
FocusListener,
DocumentListener {
    static final String SURVIVAL_CHECK = "IDS_COX_PLOT_SURVIVAL";
    static final String HAZARD_CHECK = "IDS_COX_PLOT_HAZARD";
    static final String LOG_MINUS_LOG_CHECK = "IDS_COX_PLOT_LOG_MINUS_LOG";
    static final String ONE_MINUS_SURVIVAL_CHECK = "IDS_COX_PLOT_ONE_MINUS_SURVIVAL";
    static final String MEAN_CHECK = "IDS_COX_PLOT_MEAN";
    static final String VALUE_CHECK = "IDS_COX_PLOT_VALUE_COLON";
    static final String VALUE_EDIT = "IDS_COX_PLOT_VALUE_COLON_EDIT";
    static final String COVARIATE_VALUES = "IDS_COVARIATE_VALUES_PLOTTED_AT";
    static final String SEPARATE_LINES_IDENTIFIER = "IDS_SEPARATE_LINES_FOR";
    static final String SEPARATE_LINES = "IDS_SEPARATE_LINES_FOR_DISPLAY";
    static final String COVARIATE_VALUES_ARRAY = "IDS_COVARIATE_VALUES_ARRAY";
    private static final String ACTION_CMD = "arrowPressed";
    private TargetVariableList mCovariatesPlottedAtList;
    private TargetVariableList mSeparateLinesForList;
    private JRadioButton mMeanRadio;
    private JRadioButton mValueRadio;
    private CustomTextField mValueEdit;
    private JCheckBox mHazardCheck;
    private JCheckBox mSurvivalCheck;
    private JCheckBox mLogMinusLogCheck;
    private JCheckBox mOneMinusSurvivalCheck;
    private ArrowButton mArrowButton;
    private List<JComponent> mChangeValueComponents;
    private List<JComponent> mAllComponents;
    private boolean isStringPrevious;
    private SpssButtonGroup mBtnGroup;
    private JButton mChangeButton;
    private HashMap<String, SerializableObject> mAttributeMap;

    public CoxRegressionPlots(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_COX_REG_PLOTS_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_cox_plo";
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.mChangeButton.setEnabled(this.mValueEdit.isEnabled() && !this.mValueEdit.getText().equals(""));
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.mChangeButton.setEnabled(this.mValueEdit.isEnabled() && !this.mValueEdit.getText().equals(""));
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.mChangeButton.setEnabled(this.mValueEdit.isEnabled() && !this.mValueEdit.getText().equals(""));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.mCovariatesPlottedAtList.getSelectedIndices();
        CovariatePlotModel covariatePlotModel = (CovariatePlotModel)this.mCovariatesPlottedAtList.getModel();
        for (int n : nArray) {
            ISpssVariable iSpssVariable = covariatePlotModel.getElementAt(n);
            CoVariateAttributes coVariateAttributes = (CoVariateAttributes)this.mAttributeMap.get(this.asString(iSpssVariable));
            if (this.mValueRadio.isSelected()) {
                coVariateAttributes.setIsValue(this.mValueEdit.getText());
                if (iSpssVariable.getType() > 0) {
                    coVariateAttributes.setIsStringType();
                }
            } else {
                coVariateAttributes.setIsMean();
            }
            covariatePlotModel.elementAttributesChanged(n);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = this.mSurvivalCheck.isSelected() || this.mHazardCheck.isSelected() || this.mLogMinusLogCheck.isSelected() || this.mOneMinusSurvivalCheck.isSelected();
        this.enableAllComponents(bl);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ISpssVariable iSpssVariable = (ISpssVariable)this.mCovariatesPlottedAtList.getSelectedValue();
        if (iSpssVariable != null) {
            short s = iSpssVariable.getType();
            this.mValueEdit.getDocument().removeDocumentListener(this);
            if (this.isStringPrevious && s == 0) {
                this.mValueEdit.setText("");
                this.mValueEdit.setVariableType(0);
                this.mValueEdit.setDocumentAgain();
            } else if (!this.isStringPrevious && s > 0) {
                String string = this.mValueEdit.getText();
                this.mValueEdit.setVariableType(1);
                this.mValueEdit.setDocumentAgain();
                this.mValueEdit.setText(string);
            }
            this.isStringPrevious = s > 0;
            this.mValueEdit.getDocument().addDocumentListener(this);
        }
        this.enableChangeValue(iSpssVariable != null);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.enableChangeValue(this.mCovariatesPlottedAtList.hasFocus() && this.mCovariatesPlottedAtList.getModel().getSize() > 0);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mCovariatesPlottedAtList) {
            this.enableChangeValue(true);
            return;
        }
        this.enableChangeValue(this.mCovariatesPlottedAtList.hasFocus() && this.mCovariatesPlottedAtList.getModel().getSize() > 0);
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        ISpssVariable iSpssVariable;
        ArrayList arrayList = new ArrayList();
        CovariatePlotModel covariatePlotModel = (CovariatePlotModel)this.mCovariatesPlottedAtList.getModel();
        HashMap<String, SerializableObject> hashMap = new HashMap<String, SerializableObject>();
        for (int i = 0; i < covariatePlotModel.getSize(); ++i) {
            iSpssVariable = covariatePlotModel.getElementAt(i);
            CoVariateAttributes coVariateAttributes = (CoVariateAttributes)this.mAttributeMap.get(this.asString(iSpssVariable));
            hashMap.put(iSpssVariable.getName(), coVariateAttributes);
        }
        dialogDataModel.putSerializableMap(COVARIATE_VALUES_ARRAY, hashMap);
        VarListModel varListModel = this.mSeparateLinesForList.getModel();
        if (varListModel.getSize() > 0) {
            iSpssVariable = varListModel.getElementAt(0);
            dialogDataModel.putString(SEPARATE_LINES, iSpssVariable.getName());
            CoxRegressionCategorical.IS_SEPERATE_VARIABLE_REMOVED = false;
        } else {
            dialogDataModel.putString(SEPARATE_LINES, null);
        }
        dialogDataModel.putSerializableMap(this.mCovariatesPlottedAtList.getIdentifier(), this.mAttributeMap);
        return super.saveState(dialogDataModel);
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        HashMap<String, SerializableObject> hashMap;
        CoVariateAttributes coVariateAttributes;
        Object object;
        int n;
        super.loadState(dialogDataModel);
        VarListModel varListModel = this.mSeparateLinesForList.getModel();
        if (CoxRegressionCategorical.IS_SEPERATE_VARIABLE_REMOVED) {
            varListModel.removeAll();
        }
        Set<ISpssVariable> set = ((AbstractCoxDialog)this.mParentDlg).getVariableSet();
        VarListModel varListModel2 = this.mCovariatesPlottedAtList.getModel();
        this.mAttributeMap = new HashMap();
        varListModel2.removeAll();
        if (varListModel.getSize() > 0 && !this.isVarInSet(set, varListModel.getElementAt(0))) {
            varListModel.removeAll();
        }
        for (ISpssVariable object22 : set) {
            if (!this.isVarExist(varListModel, (SpssVariable)object22)) {
                varListModel2.addElement(object22);
            }
            this.mAttributeMap.put(this.asString(object22), new CoVariateAttributes());
        }
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray("CAT_TARGET_VAR");
        if (iSpssVariableArray != null) {
            ISpssVariable[] iSpssVariableArray2 = iSpssVariableArray;
            n = iSpssVariableArray2.length;
            for (int i = 0; i < n; ++i) {
                object = iSpssVariableArray2[i];
                coVariateAttributes = (CoVariateAttributes)this.mAttributeMap.get(this.asString((ISpssVariable)object));
                if (coVariateAttributes == null) continue;
                coVariateAttributes.setCategorical(true);
            }
        }
        if ((hashMap = dialogDataModel.getSerializableMap(this.mCovariatesPlottedAtList.getIdentifier())) != null) {
            for (n = 0; n < varListModel2.getSize(); ++n) {
                ISpssVariable iSpssVariable = varListModel2.getElementAt(n);
                object = (CoVariateAttributes)hashMap.get(this.asString(iSpssVariable));
                coVariateAttributes = (CoVariateAttributes)this.mAttributeMap.get(this.asString(iSpssVariable));
                if (object == null || coVariateAttributes == null) continue;
                if (((CoVariateAttributes)object).isMean()) {
                    coVariateAttributes.setIsMean();
                    continue;
                }
                coVariateAttributes.setIsValue(((CoVariateAttributes)object).getValue());
                if (iSpssVariable.getType() <= 0) continue;
                coVariateAttributes.setIsStringType();
            }
        }
    }

    private boolean isVarInSet(Set<ISpssVariable> set, ISpssVariable iSpssVariable) {
        for (ISpssVariable iSpssVariable2 : set) {
            if (!iSpssVariable2.getName().equals(iSpssVariable.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupPlotTypePanel();
        int n = 10;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(0, 0, n2, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 3, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 26;
        Insets insets2 = DialogUtil.getStandardControlInsets();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_COX_PLOT_COVARIATES_VALUES_PLOTTED_COLON");
        jLabel.setLabelFor(this.mCovariatesPlottedAtList);
        this.mAllComponents.add(jLabel);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, 23, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JScrollPane jScrollPane = new JScrollPane(this.mCovariatesPlottedAtList);
        gridBagConstraints.fill = 1;
        this.mAllComponents.add(jScrollPane);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 10;
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 2, 1, 1, n, DialogUtil.getArrowButtonInsets());
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jLabel = DialogUtil.createLabel(this, "IDS_COX_PLOT_SEPARATE_LINES_FOR");
        jLabel.setLabelFor(this.mSeparateLinesForList);
        this.mAllComponents.add(jLabel);
        gridBagConstraints.fill = 2;
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        n = 20;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel3, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        n = 23;
        jScrollPane = new JScrollPane(this.mSeparateLinesForList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setPreferredSize(this.mSeparateLinesForList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel3, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        n = 10;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 2, 2, 1, 1, n, new Insets(0, 0, n3, 0));
        JPanel jPanel4 = this.setupChangeValue();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        n = 21;
        insets = new Insets(0, 0, n2, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 5, 2, 1, n, insets);
        this.enableAllComponents(false);
        this.mMeanRadio.setSelected(true);
        this.setTabTraversalPolicy();
        this.pack();
    }

    private boolean isVarExist(VarListModel varListModel, SpssVariable spssVariable) {
        for (int i = 0; i < varListModel.getSize(); ++i) {
            if (!varListModel.getElementAt(i).getName().equals(spssVariable.getName())) continue;
            return true;
        }
        return false;
    }

    private void initVars() {
        this.mValueRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, VALUE_CHECK));
        this.mMeanRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, MEAN_CHECK));
        this.mValueRadio.addItemListener(this);
        this.mMeanRadio.addItemListener(this);
        this.mValueEdit = new CustomTextField();
        this.mValueEdit.setColumns(9);
        this.mValueEdit.getDocument().addDocumentListener(this);
        this.mChangeValueComponents = new ArrayList<JComponent>();
        this.mAllComponents = new ArrayList<JComponent>();
        this.mCovariatesPlottedAtList = new TargetVariableList();
        PlottedAtSpssVarFormatter plottedAtSpssVarFormatter = new PlottedAtSpssVarFormatter(this.mCovariatesPlottedAtList);
        this.mCovariatesPlottedAtList.setModel(new CovariatePlotModel(plottedAtSpssVarFormatter));
        this.mCovariatesPlottedAtList.setCellRenderer(new CustomVarListCellRenderer(plottedAtSpssVarFormatter));
        this.mCovariatesPlottedAtList.setIdentifier(COVARIATE_VALUES);
        this.mCovariatesPlottedAtList.setDragType(VariableList.VarMoveType.eDoNothing);
        this.mCovariatesPlottedAtList.addListSelectionListener(this);
        this.mCovariatesPlottedAtList.addFocusListener(this);
        this.mAllComponents.add(this.mCovariatesPlottedAtList);
        this.mSeparateLinesForList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mSeparateLinesForList.setIdentifier(SEPARATE_LINES_IDENTIFIER);
        this.mSeparateLinesForList.setDragType(VariableList.VarMoveType.eDoNothing);
        this.mSeparateLinesForList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                String string = " ";
                if (object instanceof ISpssVariable) {
                    string = CoxRegressionPlots.this.getDisplayString((ISpssVariable)object);
                    if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                        string = ComponentState.prepareStringForBidiRendering((String)string);
                    }
                }
                return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            }
        });
        this.mArrowButton = new ArrowButton();
        this.mVarMoveHandler = new CategoricalVarMoveHandler();
        this.mArrowButton.setVarMoveHandler(this.mVarMoveHandler);
        this.mArrowButton.registerVariableList(this.mCovariatesPlottedAtList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mSeparateLinesForList, SpssArrowButton.ButtonOrientation.left);
        this.mAllComponents.add(this.mArrowButton);
        this.mAllComponents.add(this.mSeparateLinesForList);
        this.mBtnGroup = new SpssButtonGroup();
        this.mBtnGroup.add(this.mMeanRadio);
        this.mChangeValueComponents.add(this.mMeanRadio);
        this.mBtnGroup.add(this.mValueRadio);
        this.mChangeValueComponents.add(this.mValueRadio);
        this.mValueEdit.setAction(new TextFieldAction(this.mParentDlg, VALUE_EDIT));
        this.mChangeValueComponents.add((JComponent)((Object)this.mValueEdit));
        this.mValueEdit.getDocument().addDocumentListener(this);
    }

    private void setTabTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSurvivalCheck);
        vector.add(this.mHazardCheck);
        vector.add(this.mLogMinusLogCheck);
        vector.add(this.mOneMinusSurvivalCheck);
        vector.add(this.mCovariatesPlottedAtList);
        vector.add(this.mArrowButton);
        vector.add(this.mSeparateLinesForList);
        vector.add(this.mBtnGroup);
        vector.add((Object)this.mValueEdit);
        vector.add(this.mChangeButton);
        Component[] componentArray = this.mCmdButtonPanel.getComponents();
        vector.addAll(Arrays.asList(componentArray));
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void enableChangeValue(boolean bl) {
        for (JComponent jComponent : this.mChangeValueComponents) {
            jComponent.setEnabled(bl && this.mCovariatesPlottedAtList.getSelectedIndices().length > 0);
        }
        boolean bl2 = bl && this.mCovariatesPlottedAtList.getSelectedIndices().length > 0;
        boolean bl3 = bl2 && this.mValueRadio.isSelected();
        this.mValueEdit.setEnabled(bl3);
        if (bl2) {
            this.mChangeButton.setEnabled(this.mMeanRadio.isSelected() || !this.mValueEdit.getText().equals(""));
        }
    }

    private void enableAllComponents(boolean bl) {
        for (JComponent jComponent : this.mAllComponents) {
            jComponent.setEnabled(bl);
        }
        this.enableChangeValue(bl);
    }

    private JPanel setupPlotTypePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_COX_PLOT_PLOT_TYPE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        int n = 23;
        this.mSurvivalCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, SURVIVAL_CHECK));
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel2, this.mSurvivalCheck, gridBagConstraints, 0, 0, 1, 1, n, new Insets(insets.top, insets.left, insets.bottom, insets.right + 2 * n2));
        this.mSurvivalCheck.addItemListener(this);
        this.mHazardCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, HAZARD_CHECK));
        DialogUtil.addUsingGBL(jPanel2, this.mHazardCheck, gridBagConstraints, 1, 0, 1, 1, n, new Insets(insets.top, insets.left + 2 * n2, insets.bottom, insets.right + 2 * n2));
        this.mHazardCheck.addItemListener(this);
        this.mLogMinusLogCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, LOG_MINUS_LOG_CHECK));
        DialogUtil.addUsingGBL(jPanel2, this.mLogMinusLogCheck, gridBagConstraints, 2, 0, 1, 1, n, new Insets(insets.top, insets.left + 2 * n2, insets.bottom, insets.right + 2 * n2));
        this.mLogMinusLogCheck.addItemListener(this);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        this.mOneMinusSurvivalCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, ONE_MINUS_SURVIVAL_CHECK));
        DialogUtil.addUsingGBL(jPanel, this.mOneMinusSurvivalCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mOneMinusSurvivalCheck.addItemListener(this);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mSurvivalCheck);
        spssButtonGroup.add(this.mHazardCheck);
        spssButtonGroup.add(this.mLogMinusLogCheck);
        spssButtonGroup.add(this.mOneMinusSurvivalCheck);
        return jPanel;
    }

    private JPanel setupChangeValue() {
        JPanel jPanel = new JPanel();
        this.mChangeValueComponents.add(jPanel);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_COX_PLOT_CHANGE_VALUE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 21;
        DialogUtil.addUsingGBL(jPanel, this.mMeanRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        DialogUtil.addUsingGBL(jPanel2, this.mValueRadio, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)((Object)this.mValueEdit), gridBagConstraints, 2, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, null);
        gridBagConstraints.fill = 0;
        this.mChangeButton = new JButton(this.getResString("IDS_COX_PLOT_CHANGE"));
        this.mChangeButton.addActionListener(this);
        this.mChangeValueComponents.add(this.mChangeButton);
        n = 23;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mChangeButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void removeElementsNotPresentInDataSource(TargetVariableList targetVariableList) {
        for (int i = targetVariableList.getModel().getSize() - 1; i >= 0; --i) {
            boolean bl;
            ISpssVariable iSpssVariable = targetVariableList.getModel().getElementAt(i);
            LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            int n = iSpssDataSrc.findVarIndex(iSpssVariable.getName());
            if (!iSpssVariable.getName().equals("T_COV_") && iSpssVariable != null && n == -1 && !(bl = iSpssDataSrc.isVariableInCurrentSet(iSpssVariable))) {
                targetVariableList.getModel().removeElementAt(i);
            }
            if (((AbstractCoxDialog)this.mParentDlg).getVarCountInLayeredPanel(iSpssVariable.getName()) != 0) continue;
            targetVariableList.getModel().removeElement(iSpssVariable);
        }
    }

    private String getDisplayString(ISpssVariable iSpssVariable) {
        StringBuffer stringBuffer = new StringBuffer(" ");
        CoVariateAttributes coVariateAttributes = (CoVariateAttributes)this.mAttributeMap.get(this.asString(iSpssVariable));
        if (coVariateAttributes.isCategorical()) {
            stringBuffer.append("(");
            stringBuffer.append(this.getResString("IDS_COX_CAT_CAT_VALUE"));
            stringBuffer.append(") ");
        }
        if (coVariateAttributes.isMean()) {
            stringBuffer.append("(");
            stringBuffer.append(this.getResString(MEAN_CHECK));
            stringBuffer.append(") ");
        } else {
            stringBuffer.append("(");
            stringBuffer.append(coVariateAttributes.getValue());
            stringBuffer.append(") ");
        }
        return iSpssVariable.getName() + stringBuffer.toString();
    }

    private String asString(ISpssVariable iSpssVariable) {
        return String.format("%d", iSpssVariable.getId().asInt());
    }

    class PlottedAtSpssVarFormatter
    extends SpssVarFormatter {
        public PlottedAtSpssVarFormatter(TargetVariableList targetVariableList) {
            super(targetVariableList);
        }

        @Override
        public String getDisplayText(ISpssVariable iSpssVariable) {
            return CoxRegressionPlots.this.getDisplayString(iSpssVariable);
        }
    }

    public static class CoVariateAttributes
    implements SerializableObject {
        private boolean isMean = true;
        private boolean isCategorical = false;
        private String value = null;
        private boolean isStringType = false;

        public boolean isCategorical() {
            return this.isCategorical;
        }

        public void setCategorical(boolean bl) {
            this.isCategorical = bl;
        }

        public boolean isMean() {
            return this.isMean;
        }

        public void setIsMean() {
            this.isMean = true;
        }

        public String getValue() {
            return this.value;
        }

        public void setIsValue(String string) {
            this.isMean = false;
            this.value = string;
        }

        public void setIsStringType() {
            this.isStringType = true;
        }

        public boolean isStringType() {
            return this.isStringType;
        }

        public String getClassName() {
            return "com.spss.java_client.ui.dialogs.adv_stats.cox_regression.CoxRegressionPlots$CoVariateAttributes";
        }

        public boolean readVersionedObject(ObjectInputStream objectInputStream, int n) throws Exception {
            this.isMean = objectInputStream.readBoolean();
            this.isCategorical = objectInputStream.readBoolean();
            this.isStringType = objectInputStream.readBoolean();
            this.value = objectInputStream.readUTF();
            if (this.value.length() == 0) {
                this.value = null;
            }
            return true;
        }

        public boolean writeVersionedObject(ObjectOutputStream objectOutputStream, int n) throws Exception {
            objectOutputStream.writeBoolean(this.isMean);
            objectOutputStream.writeBoolean(this.isCategorical);
            objectOutputStream.writeBoolean(this.isStringType);
            objectOutputStream.writeUTF(this.value != null ? this.value : "");
            return true;
        }
    }

    private class CustomTextField
    extends SPSSTextField {
        static final int NUMERIC_TYPE = 0;
        static final int STRING_TYPE = 1;
        private int mVariableType = 0;

        public CustomTextField() {
            this.setDocumentAgain();
        }

        public int getMVariableType() {
            return this.mVariableType;
        }

        public void setDocumentAgain() {
            if (this.mVariableType == 0) {
                super.setDocument((Document)new FixedLengthNumericDocument(8, false, true));
            } else {
                super.setDocument((Document)new LimitedPlainDocument(8));
            }
        }

        public void setVariableType(int n) {
            this.mVariableType = n;
        }
    }

    class CategoricalVarMoveHandler
    implements IVarMoveHandler {
        CategoricalVarMoveHandler() {
        }

        @Override
        public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
            if (variableList.equals(CoxRegressionPlots.this.mSeparateLinesForList)) {
                ISpssVariable iSpssVariable = (ISpssVariable)CoxRegressionPlots.this.mCovariatesPlottedAtList.getSelectedValue();
                CoVariateAttributes coVariateAttributes = (CoVariateAttributes)CoxRegressionPlots.this.mAttributeMap.get(CoxRegressionPlots.this.asString(iSpssVariable));
                if (iSpssVariable.getType() > 0 || coVariateAttributes.isCategorical()) {
                    CoxRegressionPlots.this.enableChangeValue(false);
                    return true;
                }
                SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)CoxRegressionPlots.this), CoxRegressionPlots.this.getResString("ERR_ONLY_CATEGORICAL_VARIABLES_MAY_MOVE"), VersionInfo.getAppVersionString());
                return false;
            }
            return true;
        }
    }

    private class CovariatePlotModel
    extends CustomVarListModel {
        public CovariatePlotModel(SpssVarFormatter spssVarFormatter) {
            super(spssVarFormatter);
        }

        public void elementAttributesChanged(int n) {
            if (n < 0 || n >= this.mVariables.size()) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            ISpssVariable iSpssVariable = this.getElementAt(n);
            this.fireContentsChanged(iSpssVariable, n, n);
        }
    }
}

