/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats.cox_reg_w_time_dep;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.ExpressionValidator;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.SpssCalculatedScaleVar;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CalcWidget;
import com.spss.java_client.ui.controls.ExpressionAreaArrowButton;
import com.spss.java_client.ui.controls.ExpressionBuilderTextArea;
import com.spss.java_client.ui.controls.FunctionListControls;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TextAreaKeyListener;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.adv_stats.cox_reg_w_time_dep.CoxRegressionDlgTimeDep;
import com.spss.java_client.ui.dialogs.adv_stats.res.AdvStatsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ExpressionBuilderUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.ProcedureAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.doc_util.ProcedureDialogLoader;
import com.spss.uitools.controls.drag_drop.DragPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CoxRegTimeDepCovariatesDlg
extends BaseProcedureDialog
implements DocumentListener,
KeyListener {
    static final String TIME_DEPENDENT_EXPRESSION = "IDS_TIME_DEPENDENT_COV_EXPRESSION";
    private SrcVariableList mSourceVarList;
    private JButton mModelBtn;
    private ExpressionBuilderTextArea mExpressionTextArea;
    private JFrame mOwner;
    private ExpressionAreaArrowButton mArrowButton;
    private CalcWidget mCalcPanel;
    private JTextArea mDescriptionTextArea;
    private JList mFunctionGrpList;
    private JList mFunctionSpecialVarsList;
    private ArrowButton mFunctionListArrowButton;
    private FunctionListControls mFunctionListControls;
    private ISpssVariable mTimeDependentVariable;

    public CoxRegTimeDepCovariatesDlg(JFrame jFrame) {
        super(jFrame, AdvStatsResBundle.getDefaultResourceBundleName(), AdvStatsResBundle.getImageFolder());
        this.mOwner = jFrame;
        this.setTitle(this.getResString("IDS_COX_REG_TIME_DEP_COV"));
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    @Override
    public String generateSyntax() {
        return null;
    }

    @Override
    public void reset() {
        super.reset();
        this.mExpressionTextArea.setText("");
        this.mSourceVarList.getModel().removeAll();
        this.populateSourceList();
        this.mFunctionListControls.reset();
        this.mSourceVarList.setSelectedIndex(0);
        this.mSourceVarList.requestFocus();
    }

    @Override
    public String getIActionKey() {
        return "analyze_survival_cox_time_cov";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_coxt";
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateModelButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateModelButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateModelButton();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 9) {
            DialogFocusTraversalPolicy dialogFocusTraversalPolicy = (DialogFocusTraversalPolicy)this.getFocusTraversalPolicy();
            Component component = (Component)keyEvent.getSource();
            Component component2 = keyEvent.isShiftDown() ? dialogFocusTraversalPolicy.getComponentBefore((Container)((Object)this), component) : dialogFocusTraversalPolicy.getComponentAfter((Container)((Object)this), component);
            keyEvent.consume();
            if (component2 != null) {
                component2.requestFocus();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSourceVarList.getModel().removeAll();
        this.populateSourceList();
        this.mSourceVarList.setSelectedIndex(0);
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        String string = dialogDataModel.getString(TIME_DEPENDENT_EXPRESSION);
        if (string != null && string.length() > 0) {
            this.mExpressionTextArea.setText(string);
        }
        this.mFunctionListControls.loadFunctionState(dialogDataModel);
        this.mSourceVarList.requestFocus();
        this.mSourceVarList.setSelectedIndex(0);
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        dialogDataModel.putString(TIME_DEPENDENT_EXPRESSION, this.mExpressionTextArea.getText());
        this.mFunctionListControls.saveFunctionState(dialogDataModel);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, n, 0);
        this.mArrowButton.registerComponents(this.mSourceVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerComponents((JComponent)((Object)this.mExpressionTextArea), SpssArrowButton.ButtonOrientation.left);
        JScrollPane jScrollPane = new JScrollPane(this.mSourceVarList);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setPreferredSize(this.mSourceVarList.getMinimumSize());
        JScrollPane jScrollPane2 = new JScrollPane((Component)((Object)this.mExpressionTextArea));
        jScrollPane2.setVerticalScrollBarPolicy(20);
        jScrollPane2.setHorizontalScrollBarPolicy(30);
        jScrollPane2.setPreferredSize(this.mExpressionTextArea.getMinimumSize());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_EXPRESSION_FOR_COV");
        jLabel.setLabelFor((Component)((Object)this.mExpressionTextArea));
        JScrollPane jScrollPane3 = new JScrollPane(this.mDescriptionTextArea);
        jScrollPane3.setVerticalScrollBarPolicy(20);
        JLabel jLabel2 = DialogUtil.createLabel("IDS_FUNCTION_GROUP_LABEL");
        jLabel2.setLabelFor(this.mFunctionGrpList);
        JLabel jLabel3 = DialogUtil.createLabel("IDS_FUNCTION_SPECIAL_VARIABLES_LABEL");
        jLabel3.setLabelFor(this.mFunctionSpecialVarsList);
        JScrollPane jScrollPane4 = new JScrollPane(this.mFunctionGrpList);
        jScrollPane4.setVerticalScrollBarPolicy(20);
        jScrollPane4.setPreferredSize(new Dimension(DialogUtil.getFunctionGroupListWidth(), DialogUtil.getFunctionGroupListHeight()));
        JScrollPane jScrollPane5 = new JScrollPane(this.mFunctionSpecialVarsList);
        jScrollPane5.setPreferredSize(new Dimension(DialogUtil.getFunctionGroupListWidth(), DialogUtil.getFunctionGroupListHeight() * 2));
        jScrollPane5.setVerticalScrollBarPolicy(20);
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_COX_REG_TIME_DEP_SOURCE_LIST_LABEL");
        jLabel4.setLabelFor(this.mSourceVarList);
        int n2 = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 0, 0, 1, 1, n2, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 7, n2, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n2, DialogUtil.getArrowButtonInsets());
        gridBagConstraints.fill = 1;
        n2 = 21;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n2, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 3, 1, n2, null);
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        insets.set(n3 * 2, insets2.left, 0, n3 * 3);
        n2 = 23;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane3, gridBagConstraints, 1, 6, 3, 1, n2, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mCalcPanel, gridBagConstraints, 2, 3, 1, 3, n2, null);
        insets.set(n3 * 2, insets2.left, 0, n3 * 3);
        gridBagConstraints.fill = 0;
        n2 = 21;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mFunctionListArrowButton, gridBagConstraints, 3, 4, 1, 2, n2, insets);
        n2 = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 4, 2, 1, 1, n2, null);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane4, gridBagConstraints, 4, 3, 1, 1, n2, null);
        insets.set(n3, 0, 0, 0);
        n2 = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 4, 4, 1, 1, n2, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane5, gridBagConstraints, 4, 5, 1, 2, n2, null);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.mDescriptionTextArea.addKeyListener(new TextAreaKeyListener(this.mDescriptionTextArea, this, dialogFocusTraversalPolicy, false));
        if (this.getGlassPane() instanceof DragPane) {
            ExpressionBuilderUtil.addExpressionTextAreaDragAdapter((DragPane)this.getGlassPane(), this.mExpressionTextArea);
            ExpressionBuilderUtil.addDragAdapterToList((DragPane)this.getGlassPane(), this.mFunctionSpecialVarsList);
        }
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CoxRegTimeDepCovariatesDlg.this.runCategoricalCovariatesDialog();
            }
        };
        String string = "IDS_COX_REG_MODEL_3DOT";
        abstractAction.putValue("Name", this.getResString(string));
        this.mModelBtn = new JButton(abstractAction);
        this.addOptionsPanelButton(jPanel, this.mModelBtn);
        return jPanel;
    }

    @Override
    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = super.setupCmdButtonPanel();
        jPanel.remove(this.getOkButton());
        jPanel.remove(this.getPasteButton());
        return jPanel;
    }

    protected void runCategoricalCovariatesDialog() {
        DialogDataModel dialogDataModel;
        ProcedureDialogLoader.ProcDialogListener procDialogListener;
        boolean bl;
        String string = this.mExpressionTextArea.getText();
        if (!this.check(string) && 0 != SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_TIME_DEP_VAR_NOT_PRESENT_MSG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
            this.setFocusOnExpressionField();
            return;
        }
        ExpressionValidator expressionValidator = new ExpressionValidator();
        if (!string.contains("T_") && !(bl = expressionValidator.validateComputeExpressionWithTime(string, "T_COV_", false))) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), expressionValidator.checkError(), VersionInfo.getAppVersionString());
            this.restoreTimeVarInSourceList();
            this.setFocusOnExpressionField();
            return;
        }
        this.saveDialogState();
        ProcedureDlgMgr.getMgr().addRecallItem(this.getTitle(), this.getIActionKey());
        if (BaseProcedureDialog.saveState(this.getDialogDataModel(), (Container)((Object)this))) {
            ProcedureDlgMgr.getMgr().savePersistentState(this.getIActionKey(), this.getDialogDataModel());
            this.dispose();
        }
        ProcedureAction procedureAction = (ProcedureAction)ActionCatalog.getActionCatalog().getSpssAction("analyze_survival_cox_reg_time_cov");
        if (CommandLine.isClementineCaller() && (procDialogListener = (ProcedureDialogLoader.ProcDialogListener)(dialogDataModel = this.getDialogDataModel()).getUserObject()) != null) {
            procedureAction.setProcDialogListener(procDialogListener);
        }
        ProcedureDialogLoader.dialogLaunching(procedureAction, null);
        new CoxRegressionDlgTimeDep(this.mOwner, string);
    }

    private void setFocusOnExpressionField() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CoxRegTimeDepCovariatesDlg.this.mExpressionTextArea.setSelectionStart(0);
                CoxRegTimeDepCovariatesDlg.this.mExpressionTextArea.setSelectionEnd(CoxRegTimeDepCovariatesDlg.this.mExpressionTextArea.getText().length());
                CoxRegTimeDepCovariatesDlg.this.mExpressionTextArea.requestFocus();
            }
        });
    }

    private void restoreTimeVarInSourceList() {
        VarListModel varListModel = this.mSourceVarList.getModel();
        if (!varListModel.getElementAt(0).getName().equals(this.mTimeDependentVariable.getName())) {
            this.mSourceVarList.removeAllVarFilters();
            varListModel.insertElementAt(this.mTimeDependentVariable, 0);
            this.mSourceVarList.setModel(varListModel);
        }
    }

    private void initVars() {
        this.mSourceVarList = new SrcVariableList();
        this.mSourceVarList.setModel(new SrcListModel(this.mSourceVarList));
        this.mSourceVarList.setSelectionMode(0);
        this.mTimeDependentVariable = new SpssCalculatedScaleVar();
        this.mTimeDependentVariable.setName("T_");
        this.mTimeDependentVariable.setLabel("Time");
        SPSS_Format sPSS_Format = new SPSS_Format();
        sPSS_Format.setFormatType(FormatType.TIME);
        this.mTimeDependentVariable.setFormat(sPSS_Format);
        this.mExpressionTextArea = new ExpressionBuilderTextArea();
        this.mExpressionTextArea.setValidateOnFocusLost(true);
        this.mExpressionTextArea.setLineWrap(true);
        this.mExpressionTextArea.setWrapStyleWord(true);
        this.mExpressionTextArea.getDocument().addDocumentListener(this);
        this.mExpressionTextArea.addKeyListener(this);
        this.mCalcPanel = new CalcWidget((JTextArea)((Object)this.mExpressionTextArea), CalcWidget.CalcType.eRelationalWithTilde);
        this.mArrowButton = new ExpressionAreaArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mFunctionListControls = new FunctionListControls(true, true);
        this.mFunctionListControls.setSrcList(this.mSourceVarList);
        this.mFunctionListControls.setExpressionArea((JTextArea)((Object)this.mExpressionTextArea));
        this.mFunctionListControls.setFunctionGroupIdentifier("Function Grp in If");
        this.mFunctionListArrowButton = this.mFunctionListControls.getFunctionArrow();
        this.mDescriptionTextArea = this.mFunctionListControls.getFunctionDescArea();
        this.mDescriptionTextArea.setLineWrap(true);
        this.mDescriptionTextArea.setWrapStyleWord(true);
        this.mDescriptionTextArea.setOpaque(false);
        this.mFunctionGrpList = this.mFunctionListControls.getFunctionGroupList();
        this.mFunctionGrpList.setSelectionMode(0);
        this.mFunctionSpecialVarsList = this.mFunctionListControls.getFunctionList();
        this.mFunctionSpecialVarsList.setSelectionMode(0);
        this.mFunctionListControls.setFunctionListIdentifier("Function list in If");
    }

    private void populateSourceList() {
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
            if (locallyUniqueId == null || locallyUniqueId.isNull()) {
                return;
            }
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            if (iSpssDataSrc != null) {
                VarListModel varListModel = this.mSourceVarList.getModel();
                int n = iSpssDataSrc.columnCount();
                for (int i = 0; i < n; ++i) {
                    ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
                    ISpssVariable iSpssVariable2 = null;
                    try {
                        iSpssVariable2 = iSpssVariable.clone();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    varListModel.addElement(iSpssVariable2, false);
                }
                varListModel.sort();
                this.mSourceVarList.setModel(varListModel);
            }
        }
    }

    private void setDefaults() {
        VarListModel varListModel = this.mSourceVarList.getModel();
        if (varListModel.getSize() > 0) {
            SpssVariable spssVariable = new SpssVariable();
            spssVariable.setName("T_");
            varListModel.addElement((ISpssVariable)spssVariable);
        }
        this.mSourceVarList.setSelectedIndex(0);
        this.mModelBtn.setEnabled(false);
    }

    private void updateModelButton() {
        String string = this.mExpressionTextArea.getText().trim();
        this.mModelBtn.setEnabled(string.length() > 0 && !string.contains("?"));
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSourceVarList);
        vector.add(this.mArrowButton);
        vector.add((Object)this.mExpressionTextArea);
        vector.add(this.mCalcPanel.getDefaultFocusButton());
        vector.add(this.mFunctionGrpList);
        vector.add(this.mFunctionSpecialVarsList);
        vector.add(this.mFunctionListArrowButton);
        vector.add(this.mDescriptionTextArea);
        vector.add(this.mModelBtn);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private boolean check(String string) {
        int n = string.indexOf("T_");
        return string.contains("T_") && (n > 0 && n + 2 < string.length() ? !Character.isLetter(string.charAt(n - 1)) && !Character.isLetter(string.charAt(n + 2)) : (n > 0 ? !Character.isLetter(string.charAt(n - 1)) : (n + 2 < string.length() ? !Character.isLetter(string.charAt(n + 2)) : string.equals("T_"))));
    }

    class SrcListModel
    extends VarListModel {
        protected SrcListModel(VariableList variableList) {
            super(variableList);
        }

        @Override
        public void sort() {
            super.sort();
            ISpssVariable[] iSpssVariableArray = new ISpssVariable[this.getSize()];
            for (int i = iSpssVariableArray.length - 1; i >= 0; --i) {
                iSpssVariableArray[i] = this.getElementAt(i);
            }
            this.removeAll();
            this.addElement(CoxRegTimeDepCovariatesDlg.this.mTimeDependentVariable, false);
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                if (iSpssVariable.getName().equals("T_")) continue;
                this.addElement(iSpssVariable, false);
            }
        }
    }
}

