/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.adv_stats.AuxRegressionBrschDlg;
import com.spss.java_client.ui.dialogs.adv_stats.AuxRegressionFtestDlg;
import com.spss.java_client.ui.dialogs.adv_stats.AuxRegressionModBrschDlg;
import com.spss.java_client.ui.dialogs.adv_stats.GLMCommonContrast;
import com.spss.java_client.ui.dialogs.adv_stats.GLMCommonEMMeans;
import com.spss.java_client.ui.dialogs.adv_stats.GLMCommonModel;
import com.spss.java_client.ui.dialogs.adv_stats.GLMCommonOptions;
import com.spss.java_client.ui.dialogs.adv_stats.GLMCommonPlots;
import com.spss.java_client.ui.dialogs.adv_stats.GLMCommonPostHoc;
import com.spss.java_client.ui.dialogs.adv_stats.GLMCommonSave;
import com.spss.java_client.ui.dialogs.adv_stats.res.AdvStatsResBundle;
import com.spss.java_client.ui.dialogs.common.AbstractModelSubDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BootstrapDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class UnivariateDlg
extends BaseProcedureDialog
implements ListDataListener {
    public static final String OVERALL = "(OVERALL)";
    static final String DEP_VAR_LIST = "IDS_DEP_VAR_LIST";
    static final String FIX_FACTOR_LIST = "IDS_FIX_FACTOR_LIST";
    static final String RAND_FACTOR_LIST = "IDS_RAND_FACTOR_LIST";
    static final String COVARIATE_LIST = "IDS_COVARIATE_LIST";
    static final String WLSWEIGHT_LIST = "IDS_WLSWEIGHT_LIST";
    static final String MODEL_BUTTON = "IDS_COMMON_MODEL_BUTTON";
    static final String CONTRAST_BUTTON = "IDS_COMMON_CONTRASTS_BUTTON";
    static final String PLOTS_BUTTON = "IDS_COMMON_PLOTS_BUTTON";
    static final String POST_HOC_BUTTON = "IDS_COMMON_POSTHOC_BUTTON";
    static final String EM_MEANS_BUTTON = "IDS_COMMON_EMMEANS_BUTTON";
    static final String SAVE_BUTTON = "IDS_COMMON_SAVE_BUTTON";
    static final String OPTIONS_BUTTON = "IDS_COMMON_OPTIONS_3DOT";
    private ArrowButton mFixFactorListArrow;
    private ArrowButton mDepVarListArrow;
    private ArrowButton mRandFactorListArrow;
    private ArrowButton mCovarListArrow;
    private ArrowButton mWlsWtListArrow;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mDepVarList;
    private TargetVariableList mFixFactorList;
    private TargetVariableList mRandFactorList;
    private TargetVariableList mCovarList;
    private TargetVariableList mWlsWtList;
    private JScrollPane mDepVarListScroll;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mCovarScrollPane;
    private JScrollPane mRandScrollPane;
    private JScrollPane mFixScrollPane;
    private JScrollPane mWlsWtListScroll;
    private JButton mPostHocButton;
    private JButton mBootStrappingButton;
    private LinkedHashMap<String, String> mSavemap;
    private boolean mIsBootstrapOK;

    public UnivariateDlg(JFrame jFrame) {
        super(jFrame, false, AdvStatsResBundle.getDefaultResourceBundleName(), AdvStatsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_UNIVARIATE"));
        this.setLocationRelativeTo(this.getParent());
    }

    public String getFixedFacterList() {
        return this.mFixFactorList.getVariablesStringList();
    }

    public String getRandFacterList() {
        return this.mRandFactorList.getVariablesStringList();
    }

    public Vector<String> getFactorCombinations() {
        int n;
        Vector<String> vector = new Vector<String>();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean(AbstractModelSubDialog.MODEL_CUSTOM_KEY);
        if (bl != null && bl.booleanValue()) {
            vector = this.getCustomModelFactorVarList();
        }
        if (vector.size() != 0) {
            return vector;
        }
        int n2 = this.mFixFactorList.getModel().getSize();
        for (n = 0; n < n2; ++n) {
            vector.add(this.mFixFactorList.getModel().getElementAt(n).getName());
        }
        n = this.mRandFactorList.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mRandFactorList.getModel().getElementAt(i).getName());
        }
        if (vector.size() > 0 && vector.size() <= 8) {
            Combinations combinations = new Combinations();
            return combinations.generateCombinations(vector);
        }
        return vector;
    }

    public Vector<String> getFixFactorVarList() {
        String string = this.mFixFactorList.getVariablesStringList();
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        return vector;
    }

    private Vector<String> getRandFactorVarList() {
        String string = this.mRandFactorList.getVariablesStringList();
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        return vector;
    }

    public Vector<String> getFixAndRandFactorVarList() {
        Vector<String> vector = this.getFixFactorVarList();
        vector.addAll(this.getRandFactorVarList());
        return vector;
    }

    public Vector<String> getFullFactorialFixAndRandFactorVarList() {
        return this.getFixAndRandFactorVarList();
    }

    public Vector<String> getCustomFactorialFixAndRandFactorVarList() {
        return this.getCustomModelFactorVarList();
    }

    protected Vector<String> getCustomModelFactorVarList() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = this.getFixFactorVarList();
        Vector<String> vector3 = this.getRandFactorVarList();
        Object[] objectArray = dialogDataModel.getArray(AbstractModelSubDialog.MODEL_TERMS_KEY);
        if (objectArray != null) {
            for (Object object : objectArray) {
                String string;
                String string2 = object.toString();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "*");
                int n = stringTokenizer.countTokens();
                for (int i = 0; i < n && (vector2.contains(string = stringTokenizer.nextToken()) || vector3.contains(string)); ++i) {
                    if (i < n - 1) continue;
                    vector.add(string2);
                }
            }
        }
        return vector;
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mDepVarList.getModel()) {
            this.enableOkPaste(true);
        }
        if (listDataEvent.getSource() == this.mCovarList.getModel()) {
            this.mPostHocButton.setEnabled(false);
        }
        if (listDataEvent.getSource() == this.mWlsWtList.getModel()) {
            this.mSavemap.put("IDS_PRE_WEIGHTED", "WPRED");
            this.mSavemap.put("IDS_RES_WEIGHTED", "WRESID");
        }
        this.enableBootstrappingButton();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mDepVarList.getModel()) {
            this.enableOkPaste(false);
        }
        if (listDataEvent.getSource() == this.mCovarList.getModel() && this.mCovarList.getModel().getSize() == 0) {
            this.mPostHocButton.setEnabled(true);
        }
        if (listDataEvent.getSource() == this.mWlsWtList.getModel()) {
            this.mSavemap.remove("IDS_PRE_WEIGHTED");
            this.mSavemap.remove("IDS_RES_WEIGHTED");
        }
        this.validateDialogDataModel();
        this.enableBootstrappingButton();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    public boolean isVariablePresentInModel(String string) {
        boolean bl = false;
        Object[] objectArray = this.getDialogDataModel().getArray(AbstractModelSubDialog.MODEL_TERMS_KEY);
        if (objectArray != null) {
            for (Object object : objectArray) {
                String string2 = object.toString();
                if (string2.contains("*") || string2.contains("(")) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, "*");
                    int n = stringTokenizer.countTokens();
                    for (int i = 0; i < n; ++i) {
                        StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "(");
                        while (stringTokenizer2.hasMoreTokens()) {
                            String string3 = stringTokenizer2.nextToken();
                            if (!stringTokenizer2.hasMoreTokens()) {
                                string3 = string3.replace(")", "");
                                string3 = string3.trim();
                            }
                            if (!string3.equals(string)) continue;
                            return true;
                        }
                    }
                    continue;
                }
                if (!string2.equals(string)) continue;
                return true;
            }
        }
        return bl;
    }

    @Override
    public String generateSyntax() {
        Object object;
        StringBuffer stringBuffer;
        Map.Entry<String, String> entry2;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        StringBuffer stringBuffer2 = SyntaxUtil.startSyntax();
        boolean bl = false;
        String string7 = "";
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        boolean bl2 = false;
        DialogDataModel dialogDataModel2 = (DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY);
        if (this.mIsBootstrapOK && this.mBootStrappingButton.isEnabled() && dialogDataModel2 != null) {
            string6 = this.mDepVarList.getVariablesStringList();
            string5 = this.mFixFactorList.getVariablesStringList() + " " + this.mCovarList.getVariablesStringList() + " " + this.mWlsWtList.getVariablesStringList();
            stringBuffer2.append(BootstrapDlg.getBootstrapSyntax(string6, string5, dialogDataModel2));
            bl2 = true;
        }
        stringBuffer2.append(SyntaxUtil.getMainCommand("UNIANOVA"));
        stringBuffer2.append(SyntaxUtil.getMainCommandParamters(this.mDepVarList.getVariablesStringList()));
        string6 = "";
        string5 = this.mFixFactorList.getVariablesStringList();
        if (!string5.equals("")) {
            string6 = string6 + string5;
        }
        if (!(string4 = this.mRandFactorList.getVariablesStringList()).equals("")) {
            string6 = string6 + " " + string4;
        }
        if (!string6.equals("")) {
            stringBuffer2.append(" BY ").append(string6);
        }
        if (!(string3 = this.mCovarList.getVariablesStringList()).equals("")) {
            stringBuffer2.append(" WITH ").append(string3);
        }
        if (!(string2 = this.mWlsWtList.getVariablesStringList()).equals("")) {
            stringBuffer2.append("\n").append(SyntaxUtil.getSubCommand("/REGWGT="));
            stringBuffer2.append(string2);
        }
        if (!string4.equals("")) {
            stringBuffer2.append("\n").append(SyntaxUtil.getSubCommand("/RANDOM="));
            stringBuffer2.append(string4);
        }
        if (!(string = GLMCommonContrast.getGLMContrastSyntax(this, dialogDataModel)).equals("")) {
            stringBuffer2.append("\n").append(string);
        } else {
            stringBuffer2.append("\n");
        }
        if (dialogDataModel.getInteger("IDS_SUM_OF_SQUARE_COMBO") != null) {
            stringBuffer2.append(SyntaxUtil.getSubCommand("/METHOD=")).append("SSTYPE(").append(dialogDataModel.getInteger("IDS_SUM_OF_SQUARE_COMBO") + 1).append(")\n");
        } else {
            stringBuffer2.append(SyntaxUtil.getSubCommand("/METHOD=")).append("SSTYPE(3)\n");
        }
        Boolean bl3 = dialogDataModel.getBoolean("IDS_INCLUDE_INTERCEPT");
        if (bl3 != null && !bl3.booleanValue()) {
            stringBuffer2.append(SyntaxUtil.getSubCommand("/INTERCEPT=")).append("EXCLUDE\n");
        } else {
            stringBuffer2.append(SyntaxUtil.getSubCommand("/INTERCEPT=")).append("INCLUDE\n");
        }
        String string8 = "";
        String string9 = "";
        this.getSaveCheckMap();
        for (Map.Entry<String, String> entry2 : this.mSavemap.entrySet()) {
            bl3 = dialogDataModel.getBoolean(entry2.getKey());
            if (bl3 == null || !bl3.booleanValue()) continue;
            string9 = string9 + (String)entry2.getValue() + " ";
        }
        if ((string9 = string9.trim()).length() > 0) {
            string8 = string8 + SyntaxUtil.getSubCommand("/SAVE=").toString() + string9 + "\n";
        }
        Object object2 = null;
        bl3 = dialogDataModel.getBoolean("IDS_CREATE_COEFFICIENT_STATS");
        if (bl3 != null && bl3.booleanValue()) {
            entry2 = "COVB";
            if (dialogDataModel.getBoolean("IDS_HETEROSKEDASTICITY_STATISTICS").booleanValue()) {
                entry2 = "HCCOVB";
            }
            string8 = string8 + SyntaxUtil.getSubCommand("/OUTFILE=").toString();
            bl3 = dialogDataModel.getBoolean("IDS_CREATE_NEW_DATASET");
            if (bl3 != null && bl3.booleanValue()) {
                string7 = dialogDataModel.getString("IDS_DATASET_NAME_EDIT");
                string8 = string8 + (String)((Object)entry2) + "(" + string7 + ")\n";
                bl = true;
            }
            if ((bl3 = dialogDataModel.getBoolean("IDS_WRITE_NEW_DATA_FILE")) != null && bl3.booleanValue()) {
                object2 = dialogDataModel.getString("IDS_FILE_PATH");
                string8 = string8 + (String)((Object)entry2) + "(" + CharacterUtil.smartQuote((String)object2) + ")\n";
            }
        }
        stringBuffer2.append(string8);
        if (this.mPostHocButton.isEnabled()) {
            stringBuffer2.append(GLMCommonPostHoc.getPostHocDlgSyntax(this, dialogDataModel));
        }
        if (!((String)((Object)(entry2 = GLMCommonPlots.getCommonPlotDlgSyntax(dialogDataModel)))).equals("")) {
            stringBuffer2.append(SyntaxUtil.getSubCommand("/PLOT=")).append((String)((Object)entry2)).append("\n");
        }
        stringBuffer2.append(this.getOptionsDlgSyntax(dialogDataModel));
        if (this.mFixFactorList.getModel().getSize() > 0 || this.mRandFactorList.getModel().getSize() > 0 || this.mCovarList.getModel().getSize() > 0) {
            stringBuffer2.append("\n");
            stringBuffer2.append(SyntaxUtil.getSubCommand("/DESIGN="));
            stringBuffer = new StringBuffer();
            bl3 = null;
            if (dialogDataModel.getBoolean(AbstractModelSubDialog.MODEL_CUSTOM_KEY) != null && dialogDataModel.getBoolean(AbstractModelSubDialog.MODEL_BUILD_CUSTOM_TERM_KEY) != null) {
                bl3 = dialogDataModel.getBoolean(AbstractModelSubDialog.MODEL_CUSTOM_KEY) != false || dialogDataModel.getBoolean(AbstractModelSubDialog.MODEL_BUILD_CUSTOM_TERM_KEY) != false;
            }
            if (bl3 != null && bl3.booleanValue() && (object = dialogDataModel.getArray(AbstractModelSubDialog.MODEL_TERMS_KEY)) != null) {
                for (Object object3 : object) {
                    String string10 = object3.toString();
                    stringBuffer.append(string10).append(" ");
                }
            }
            object = this.mCovarList.getVariablesStringList() + " ";
            if (stringBuffer.length() > 0) {
                stringBuffer2.append(stringBuffer.toString().trim());
            } else {
                stringBuffer = new StringBuffer();
                stringBuffer.append(this.mCovarList.getVariablesStringList()).append(" ");
                Vector<String> vector = this.getFactorCombinations();
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append((String)vector.get(i)).append(" ");
                }
                stringBuffer2.append(stringBuffer.toString().trim());
            }
        }
        stringBuffer2.append(SyntaxUtil.terminateSyntax());
        if (bl) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(SyntaxUtil.getMainCommand("DATASET DECLARE "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(string7));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(stringBuffer2);
            stringBuffer2 = stringBuffer;
        }
        if ((stringBuffer = PES_Repository.getPesFile((String)object2)) != null && (object = stringBuffer.getPerAttributesSyntax()) != null) {
            stringBuffer2.append((String)object);
        }
        if (bl2) {
            stringBuffer2.append(BootstrapDlg.getRestoreSyntax((DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY)));
        }
        if (bl && CommandLine.isClementineCaller() && RemoteFileChooser.enableSaveInModeler()) {
            stringBuffer2.append("\nDATASET ACTIVATE " + string7);
            stringBuffer2.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String getOptionsDlgSyntax(DialogDataModel dialogDataModel) {
        boolean bl;
        void var8_33;
        Object object;
        Object object2;
        Object object3;
        Map.Entry<String, String> entry2;
        Boolean bl2;
        String[] stringArray = new String[]{"LSD", "BONFERRONI", "SIDAK"};
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        Object[] objectArray = dialogDataModel.getArray("IDS_OPTIONS_TARGET_LIST");
        if (objectArray != null) {
            for (Object object4 : objectArray) {
                stringBuffer.append(SyntaxUtil.getSubCommand("/EMMEANS="));
                String string2 = object4.toString();
                string = string2.contains(OVERALL) ? string + "TABLES" + string2 + " " : string + "TABLES(" + string2 + ") ";
                if (this.mCovarList.getModel().getSize() > 0) {
                    string = string + "WITH(";
                    for (int i = 0; i < this.mCovarList.getModel().getSize(); ++i) {
                        string = string + this.mCovarList.getModel().getElementAt(i).getName() + "=" + "MEAN" + " ";
                    }
                    string = string.trim() + ") ";
                }
                if (!string2.contains("*") && !string2.contains(OVERALL) && (bl2 = dialogDataModel.getBoolean("IDS_GLM_COMPARE_MAIN_EFFECTS")) != null && bl2.booleanValue()) {
                    string = string + "COMPARE ADJ(";
                    string = string + stringArray[dialogDataModel.getInteger("IDS_CONFIDENCE_INTERVAL_COMBO")];
                    string = string + ")";
                }
                stringBuffer.append(string).append("\n");
                string = "";
            }
        }
        String string3 = "";
        String string4 = "";
        String string5 = "/PRINT";
        HashMap<String, String> hashMap = this.getHeteroTestsMap();
        for (Map.Entry<String, String> entry2 : hashMap.entrySet()) {
            bl2 = dialogDataModel.getBoolean(entry2.getKey());
            if (bl2 == null || !bl2.booleanValue()) continue;
            string5 = string5 + " " + entry2.getValue();
        }
        HashMap<String, String> hashMap2 = this.getDisplayMap();
        Object object5 = hashMap2.entrySet().iterator();
        while (object5.hasNext()) {
            entry2 = object5.next();
            bl2 = dialogDataModel.getBoolean(entry2.getKey());
            if (bl2 == null || !bl2.booleanValue()) continue;
            string4 = string4 + entry2.getValue() + " ";
        }
        if ((string4 = string4.trim()).length() > 0) {
            String string6 = string3 + SyntaxUtil.getSubCommand(string5 + " ").toString() + string4 + "\n";
        } else if (!string5.equals("/PRINT")) {
            String string7 = string3 + SyntaxUtil.getSubCommand(string5).toString() + "\n";
        }
        bl2 = dialogDataModel.getBoolean(AuxRegressionModBrschDlg.USE_UNIVARIATE_MODEL_KEY);
        if (bl2 != null && bl2.booleanValue() && dialogDataModel.getBoolean("IDS_MODIFIED_BREUSCH_PAGAN_TEST").booleanValue()) {
            void var8_10;
            String string8 = (String)var8_10 + SyntaxUtil.getSubCommand("/MBPDESIGN") + "\n";
        }
        if ((bl2 = dialogDataModel.getBoolean(AuxRegressionBrschDlg.USE_UNIVARIATE_MODEL_KEY)) != null && bl2.booleanValue() && dialogDataModel.getBoolean("IDS_BREUSCH_PAGAN_TEST").booleanValue()) {
            void var8_12;
            String string9 = (String)var8_12 + SyntaxUtil.getSubCommand("/BPDESIGN") + "\n";
        }
        if ((bl2 = dialogDataModel.getBoolean(AuxRegressionFtestDlg.USE_UNIVARIATE_MODEL_KEY)) != null && bl2.booleanValue() && dialogDataModel.getBoolean("IDS_F_TEST").booleanValue()) {
            void var8_14;
            String string10 = (String)var8_14 + SyntaxUtil.getSubCommand("/FDESIGN") + "\n";
        }
        if ((object5 = dialogDataModel.getBoolean("IDS_MODIFIED_BREUSCH_PAGAN_TEST")) != null && ((Boolean)object5).booleanValue() && (bl2 = dialogDataModel.getBoolean("IDS_AUX_CUSTOM_MODEL_MOD")) != null && bl2.booleanValue() && ((HashSet)((Object)(entry2 = (LinkedHashSet)dialogDataModel.getObject("IDS_AUX_MODEL_LIST_MODBRSCH_KEY")))).size() > 0) {
            void var8_18;
            void var8_16;
            String string11 = (String)var8_16 + SyntaxUtil.getSubCommand("/MBPDESIGN=");
            object3 = ((HashSet)((Object)entry2)).iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                String string12 = (String)var8_18 + object2.toString() + " ";
            }
            String string13 = (String)var8_18 + "\n";
        }
        if ((entry2 = dialogDataModel.getBoolean("IDS_BREUSCH_PAGAN_TEST")) != null && ((Boolean)((Object)entry2)).booleanValue() && (bl2 = dialogDataModel.getBoolean("IDS_AUX_CUSTOM_MODEL_BRSCH")) != null && bl2.booleanValue() && ((HashSet)(object3 = (LinkedHashSet)dialogDataModel.getObject("IDS_AUX_MODEL_LIST_BRSCH_KEY"))).size() > 0) {
            void var8_23;
            void var8_21;
            String string14 = (String)var8_21 + SyntaxUtil.getSubCommand("/BPDESIGN=");
            object2 = ((HashSet)object3).iterator();
            while (object2.hasNext()) {
                object = object2.next();
                String string15 = (String)var8_23 + object.toString() + " ";
            }
            String string16 = (String)var8_23 + "\n";
        }
        if ((object3 = dialogDataModel.getBoolean("IDS_F_TEST")) != null && ((Boolean)object3).booleanValue() && (bl2 = dialogDataModel.getBoolean("IDS_AUX_CUSTOM_MODEL_F")) != null && bl2.booleanValue() && ((HashSet)(object2 = (LinkedHashSet)dialogDataModel.getObject("IDS_AUX_MODEL_LIST_F_KEY"))).size() > 0) {
            void var8_28;
            void var8_26;
            String string17 = (String)var8_26 + SyntaxUtil.getSubCommand("/FDESIGN=");
            object = ((HashSet)object2).iterator();
            while (object.hasNext()) {
                Object e = object.next();
                String string18 = (String)var8_28 + e.toString() + " ";
            }
            String string19 = (String)var8_28 + "\n";
        }
        object2 = "";
        bl2 = dialogDataModel.getBoolean("IDS_SPREAD_VS_LEVEL_PLOT");
        if (bl2 != null && bl2.booleanValue()) {
            object2 = (String)object2 + "SPREADLEVEL";
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_RESIDUAL_PLOT")) != null && bl2.booleanValue()) {
            object2 = (String)object2 + (((String)object2).trim().length() > 0 ? " " : "") + "RESIDUALS";
        }
        if (((String)object2).length() > 0) {
            void var8_31;
            String string20 = (String)var8_31 + SyntaxUtil.getSubCommand("/PLOT=").toString() + object2 + "\n";
        }
        stringBuffer.append((String)var8_33);
        object = dialogDataModel.getString("IDS_SIGNIFICANCE_LEVEL_EDIT");
        if (object != null) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/CRITERIA=ALPHA(")).append((String)object).append(")");
        } else {
            stringBuffer.append(SyntaxUtil.getSubCommand("/CRITERIA=ALPHA(0.05)"));
        }
        if (dialogDataModel.getBoolean("IDS_UNIVARIATE_PARAMETER_ESTIMATES_WITH_ROBUST_STANDARD_ERROR") != null && (bl = dialogDataModel.getBoolean("IDS_UNIVARIATE_PARAMETER_ESTIMATES_WITH_ROBUST_STANDARD_ERROR").booleanValue())) {
            String string21 = "HC3";
            if (dialogDataModel.getBoolean("IDS_UNIVARIATE_PARAMETER_ESTIMATES_WITH_ROBUST_STANDARD_ERROR_HC0").booleanValue()) {
                string21 = "HC0";
            } else if (dialogDataModel.getBoolean("IDS_UNIVARIATE_PARAMETER_ESTIMATES_WITH_ROBUST_STANDARD_ERROR_HC1").booleanValue()) {
                string21 = "HC1";
            } else if (dialogDataModel.getBoolean("IDS_UNIVARIATE_PARAMETER_ESTIMATES_WITH_ROBUST_STANDARD_ERROR_HC2").booleanValue()) {
                string21 = "HC2";
            } else if (dialogDataModel.getBoolean("IDS_UNIVARIATE_PARAMETER_ESTIMATES_WITH_ROBUST_STANDARD_ERROR_HC4").booleanValue()) {
                string21 = "HC4";
            }
            stringBuffer.append(SyntaxUtil.getSubCommand("\n  /ROBUST=")).append(string21);
        }
        return stringBuffer.toString();
    }

    public Boolean isWLSListEmpty() {
        return this.mWlsWtList.getModel().getSize() == 0;
    }

    public String getFixedFactorListModel() {
        return this.mFixFactorList.getVariablesStringList();
    }

    public VarListModel getRandFactorListModel() {
        return this.mRandFactorList.getModel();
    }

    public VarListModel getCovarListModel() {
        return this.mCovarList.getModel();
    }

    public VarListModel getFixFactorListModel() {
        return this.mFixFactorList.getModel();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_glmu";
    }

    @Override
    public String getIActionKey() {
        return "analyze_gen_linear_univariate";
    }

    @Override
    public boolean okPastePressed() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean(AbstractModelSubDialog.MODEL_CUSTOM_KEY);
        Boolean bl2 = dialogDataModel.getBoolean(AbstractModelSubDialog.MODEL_BUILD_CUSTOM_TERM_KEY);
        if (bl != null && bl.booleanValue() || bl2 != null && bl2.booleanValue()) {
            if (dialogDataModel.getArray(AbstractModelSubDialog.MODEL_TERMS_KEY).length == 0) {
                this.showErrorDialog(this.getResString("ERR_MODEL_NOT_SPECIFIED_MESSAGE"));
                return false;
            }
            if (this.mFixFactorList.getModel().getSize() > 0 || this.mRandFactorList.getModel().getSize() > 0 || this.mCovarList.getModel().getSize() > 0) {
                ISpssVariable iSpssVariable;
                int n;
                String string = "";
                for (n = 0; n < this.mFixFactorList.getModel().getSize(); ++n) {
                    iSpssVariable = this.mFixFactorList.getModel().getElementAt(n);
                    if (this.isVariablePresentInModel(iSpssVariable.getName())) continue;
                    string = string + iSpssVariable.getName() + " ";
                }
                for (n = 0; n < this.mRandFactorList.getModel().getSize(); ++n) {
                    iSpssVariable = this.mRandFactorList.getModel().getElementAt(n);
                    if (this.isVariablePresentInModel(iSpssVariable.getName())) continue;
                    string = string + iSpssVariable.getName() + " ";
                }
                for (n = 0; n < this.mCovarList.getModel().getSize(); ++n) {
                    iSpssVariable = this.mCovarList.getModel().getElementAt(n);
                    if (this.isVariablePresentInModel(iSpssVariable.getName())) continue;
                    string = string + iSpssVariable.getName() + " ";
                }
                string = string.trim();
                if (!(string = string.replace(" ", ", ")).equals("")) {
                    String string2 = String.format(this.getResString("ERR_GLM_UNUSED_FACTORS_AND_COVARIATE_MESSAGE"), string);
                    return SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), string2, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION) == 0;
                }
            }
            if (this.mIsBootstrapOK && this.mBootStrappingButton.isEnabled() && BootstrapDlg.isStrataVariableListEmpty(this)) {
                this.runSubDialog(new BootstrapDlg(this));
                return false;
            }
        }
        return true;
    }

    public void showErrorDialog(String string) {
        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
    }

    public void validateDialogDataModel() {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        int n5;
        Object object2;
        Object object3;
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        String string = this.mFixFactorList.getVariablesStringList();
        String string2 = this.mRandFactorList.getVariablesStringList();
        String string3 = this.mCovarList.getVariablesStringList();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        stringTokenizer = new StringTokenizer(string2, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector2.add(stringTokenizer.nextToken());
        }
        stringTokenizer = new StringTokenizer(string3, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector3.add(stringTokenizer.nextToken());
        }
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray("IDS_SOURCE_LIST");
        boolean bl = iSpssVariableArray != null && iSpssVariableArray.length > 0;
        ISpssVariable[] iSpssVariableArray2 = !bl ? null : new ISpssVariable[this.mFixFactorList.getModel().getSize()];
        HashMap<Integer, Object> hashMap = GLMCommonContrast.loadLuidKeyMap(dialogDataModel, "IDS_SOURCE_LIST", false);
        HashMap<Integer, Object> hashMap2 = new HashMap<Integer, Object>();
        if (bl) {
            int n6 = 0;
            for (int i = 0; i < iSpssVariableArray.length; ++i) {
                object3 = iSpssVariableArray[i];
                if (!vector.contains(object3.getName()) && !vector2.contains(object3.getName())) continue;
                iSpssVariableArray2[n6++] = object3;
                hashMap2.put(object3.getId().asInt(), hashMap.get(object3.getId().asInt()));
            }
        }
        dialogDataModel.putVarArray("IDS_SOURCE_LIST", iSpssVariableArray2);
        GLMCommonContrast.saveLuidKeyMap(dialogDataModel, hashMap2, "IDS_SOURCE_LIST", null);
        object3 = new Vector();
        Object[] objectArray = dialogDataModel.getArray("IDS_REP_MEA_PLOT_TARGET_LIST");
        if (objectArray != null) {
            object2 = objectArray;
            int n7 = ((Object[])object2).length;
            for (n5 = 0; n5 < n7; ++n5) {
                Object object4 = object2[n5];
                String string4 = object4.toString();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string4, "*");
                int n8 = stringTokenizer2.countTokens();
                for (int i = 0; i < n8 && (vector.contains(object = stringTokenizer2.nextToken()) || vector2.contains(object)); ++i) {
                    if (i < n8 - 1) continue;
                    ((Vector)object3).add(string4);
                }
            }
        }
        dialogDataModel.putArray("IDS_REP_MEA_PLOT_TARGET_LIST", ((Vector)object3).toArray());
        Vector<String> vector4 = new Vector<String>();
        object = dialogDataModel.getArray("IDS_OPTIONS_TARGET_LIST");
        if (object != null) {
            boolean bl2 = true;
            Object[] objectArray2 = object;
            n4 = objectArray2.length;
            for (n3 = 0; n3 < n4; ++n3) {
                Object object5 = objectArray2[n3];
                String string5 = object5.toString();
                StringTokenizer stringTokenizer3 = new StringTokenizer(string5, "*");
                int n9 = stringTokenizer3.countTokens();
                block7: for (n5 = 0; n5 < n9; ++n5) {
                    object2 = new StringTokenizer(stringTokenizer3.nextToken(), "(");
                    int n10 = ((StringTokenizer)object2).countTokens();
                    for (int i = 0; i < n10; ++i) {
                        String string6 = ((StringTokenizer)object2).nextToken();
                        if (!((StringTokenizer)object2).hasMoreTokens()) {
                            string6 = string6.replace(")", "");
                            string6 = string6.trim();
                        }
                        if (vector.contains(string6) || vector2.contains(string6) || string6.equals(OVERALL)) {
                            if (n5 >= n9 - 1) continue;
                            continue;
                        }
                        bl2 = false;
                        continue block7;
                    }
                }
                if (!bl2) continue;
                vector4.add(string5);
            }
        }
        dialogDataModel.putArray("IDS_OPTIONS_TARGET_LIST", vector4.toArray());
        Vector<String> vector5 = new Vector<String>();
        object2 = dialogDataModel.getArray(AbstractModelSubDialog.MODEL_TERMS_KEY);
        if (object2 != null) {
            n4 = 1;
            for (Object object6 : object2) {
                String string7 = object6.toString();
                StringTokenizer stringTokenizer4 = new StringTokenizer(string7, "*");
                n2 = stringTokenizer4.countTokens();
                block10: for (int i = 0; i < n2; ++i) {
                    StringTokenizer stringTokenizer5 = new StringTokenizer(stringTokenizer4.nextToken(), "(");
                    n = stringTokenizer5.countTokens();
                    for (int j = 0; j < n; ++j) {
                        String string8 = stringTokenizer5.nextToken();
                        if (!stringTokenizer5.hasMoreTokens()) {
                            string8 = string8.replace(")", "");
                            string8 = string8.trim();
                        }
                        if (vector.contains(string8) || vector2.contains(string8) || vector3.contains(string8)) {
                            if (i >= n2 - 1) continue;
                            continue;
                        }
                        n4 = 0;
                        continue block10;
                    }
                }
                if (n4 == 0) continue;
                vector5.add(string7);
            }
        }
        dialogDataModel.putArray(AbstractModelSubDialog.MODEL_TERMS_KEY, vector5.toArray());
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        LinkedHashSet linkedHashSet2 = (LinkedHashSet)dialogDataModel.getObject("IDS_AUX_MODEL_LIST_MODBRSCH_KEY");
        if (linkedHashSet2 != null) {
            boolean bl3 = true;
            for (Object e : linkedHashSet2) {
                String string9 = e.toString();
                StringTokenizer stringTokenizer6 = new StringTokenizer(string9, "*");
                n2 = stringTokenizer6.countTokens();
                block13: for (n4 = 0; n4 < n2; ++n4) {
                    StringTokenizer stringTokenizer7 = new StringTokenizer(stringTokenizer6.nextToken(), "(");
                    n = stringTokenizer7.countTokens();
                    for (n3 = 0; n3 < n; ++n3) {
                        String string10 = stringTokenizer7.nextToken();
                        if (!stringTokenizer7.hasMoreTokens()) {
                            string10 = string10.replace(")", "");
                            string10 = string10.trim();
                        }
                        if (vector.contains(string10) || vector2.contains(string10) || vector3.contains(string10)) {
                            if (n4 >= n2 - 1) continue;
                            continue;
                        }
                        bl3 = false;
                        continue block13;
                    }
                }
                if (!bl3) continue;
                linkedHashSet.add(string9);
            }
        }
        dialogDataModel.putObject("IDS_AUX_MODEL_LIST_MODBRSCH_KEY", linkedHashSet);
        LinkedHashSet<String> linkedHashSet3 = new LinkedHashSet<String>();
        LinkedHashSet linkedHashSet4 = (LinkedHashSet)dialogDataModel.getObject("IDS_AUX_MODEL_LIST_BRSCH_KEY");
        if (linkedHashSet4 != null) {
            boolean bl4 = true;
            for (Object e : linkedHashSet4) {
                String string11 = e.toString();
                StringTokenizer stringTokenizer8 = new StringTokenizer(string11, "*");
                int n11 = stringTokenizer8.countTokens();
                block16: for (int i = 0; i < n11; ++i) {
                    StringTokenizer stringTokenizer9 = new StringTokenizer(stringTokenizer8.nextToken(), "(");
                    int n12 = stringTokenizer9.countTokens();
                    for (int j = 0; j < n12; ++j) {
                        String string12 = stringTokenizer9.nextToken();
                        if (!stringTokenizer9.hasMoreTokens()) {
                            string12 = string12.replace(")", "");
                            string12 = string12.trim();
                        }
                        if (vector.contains(string12) || vector2.contains(string12) || vector3.contains(string12)) {
                            if (i >= n11 - 1) continue;
                            continue;
                        }
                        bl4 = false;
                        continue block16;
                    }
                }
                if (!bl4) continue;
                linkedHashSet3.add(string11);
            }
        }
        dialogDataModel.putObject("IDS_AUX_MODEL_LIST_BRSCH_KEY", linkedHashSet3);
        LinkedHashSet<String> linkedHashSet5 = new LinkedHashSet<String>();
        LinkedHashSet linkedHashSet6 = (LinkedHashSet)dialogDataModel.getObject("IDS_AUX_MODEL_LIST_F_KEY");
        if (linkedHashSet6 != null) {
            boolean bl5 = true;
            for (Object e : linkedHashSet6) {
                String string13 = e.toString();
                StringTokenizer stringTokenizer10 = new StringTokenizer(string13, "*");
                int n13 = stringTokenizer10.countTokens();
                block19: for (int i = 0; i < n13; ++i) {
                    StringTokenizer stringTokenizer11 = new StringTokenizer(stringTokenizer10.nextToken(), "(");
                    int n14 = stringTokenizer11.countTokens();
                    for (int j = 0; j < n14; ++j) {
                        String string14 = stringTokenizer11.nextToken();
                        if (!stringTokenizer11.hasMoreTokens()) {
                            string14 = string14.replace(")", "");
                            string14 = string14.trim();
                        }
                        if (vector.contains(string14) || vector2.contains(string14) || vector3.contains(string14)) {
                            if (i >= n13 - 1) continue;
                            continue;
                        }
                        bl5 = false;
                        continue block19;
                    }
                }
                if (!bl5) continue;
                linkedHashSet5.add(string13);
            }
        }
        dialogDataModel.putObject("IDS_AUX_MODEL_LIST_F_KEY", linkedHashSet5);
        Vector<ISpssVariable> vector6 = new Vector<ISpssVariable>();
        ISpssVariable[] iSpssVariableArray3 = dialogDataModel.getVarArray("IDS_POSTHOC_TARGET_LIST");
        if (iSpssVariableArray3 != null) {
            for (ISpssVariable iSpssVariable : iSpssVariableArray3) {
                if (!vector.contains(iSpssVariable.getName())) continue;
                vector6.add(iSpssVariable);
            }
        }
        int n15 = vector6.size();
        iSpssVariableArray3 = new ISpssVariable[n15];
        for (int i = 0; i < n15; ++i) {
            ISpssVariable iSpssVariable;
            iSpssVariableArray3[i] = iSpssVariable = (ISpssVariable)vector6.get(i);
        }
        dialogDataModel.putVarArray("IDS_POSTHOC_TARGET_LIST", iSpssVariableArray3);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.validateDialogDataModel();
        this.enableBootstrappingButton();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(MODEL_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UnivariateDlg.this.runModelSubDlg();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton);
        toggleButtonAction = new ToggleButtonAction(CONTRAST_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UnivariateDlg.this.runContrastSubDlg();
            }
        };
        JButton jButton2 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton2);
        toggleButtonAction = new ToggleButtonAction(PLOTS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UnivariateDlg.this.runPlotsSubDlg();
            }
        };
        JButton jButton3 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton3);
        toggleButtonAction = new ToggleButtonAction(POST_HOC_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UnivariateDlg.this.runPostHocSubDlg();
            }
        };
        this.mPostHocButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mPostHocButton);
        toggleButtonAction = new ToggleButtonAction(EM_MEANS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UnivariateDlg.this.runEMMeansSubDlg();
            }
        };
        JButton jButton4 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton4);
        toggleButtonAction = new ToggleButtonAction(SAVE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UnivariateDlg.this.runSaveSubDlg();
            }
        };
        JButton jButton5 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton5);
        toggleButtonAction = new ToggleButtonAction(OPTIONS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UnivariateDlg.this.runOptionsSubDlg();
            }
        };
        JButton jButton6 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton6);
        this.mIsBootstrapOK = false;
        if (VersionInfo.allowBootstrapping()) {
            this.mIsBootstrapOK = true;
            toggleButtonAction = new ToggleButtonAction("IDS_COMMON_BOOTSTRAPPING_BUTTON"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UnivariateDlg.this.runSubDialog(new BootstrapDlg(UnivariateDlg.this));
                }
            };
            this.mBootStrappingButton = new JButton(toggleButtonAction);
            this.addOptionsPanelButton(jPanel, this.mBootStrappingButton);
            if (BootstrapDlg.isCurrentDatasetInMIMode()) {
                this.mBootStrappingButton.setEnabled(false);
                this.mIsBootstrapOK = false;
            }
        }
        return jPanel;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mDepVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mDepVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mDepVarList.getModel().addListDataListener(this);
        this.mDepVarListScroll = new JScrollPane(this.mDepVarList);
        this.mDepVarListScroll.setHorizontalScrollBarPolicy(31);
        this.mDepVarListScroll.setVerticalScrollBarPolicy(21);
        this.mDepVarListScroll.setPreferredSize(this.mDepVarList.getMinimumSize());
        this.mDepVarList.setIdentifier(DEP_VAR_LIST);
        this.mDepVarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mFixFactorList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mFixFactorList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mFixFactorList.getModel().addListDataListener(this);
        this.mFixFactorList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mFixFactorList.getFixedCellHeight() * 2 + 2));
        this.mFixScrollPane = new JScrollPane(this.mFixFactorList);
        this.mFixScrollPane.setPreferredSize(this.mFixFactorList.getMinimumSize());
        this.mFixFactorList.setIdentifier(FIX_FACTOR_LIST);
        this.mRandFactorList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mRandFactorList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mRandFactorList.getModel().addListDataListener(this);
        this.mRandFactorList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mRandFactorList.getFixedCellHeight() * 2 + 2));
        this.mRandScrollPane = new JScrollPane(this.mRandFactorList);
        this.mRandScrollPane.setPreferredSize(this.mRandFactorList.getMinimumSize());
        this.mRandFactorList.setIdentifier(RAND_FACTOR_LIST);
        this.mCovarList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mCovarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mCovarList.getModel().addListDataListener(this);
        this.mCovarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mCovarList.getFixedCellHeight() * 2 + 2));
        this.mCovarScrollPane = new JScrollPane(this.mCovarList);
        this.mCovarScrollPane.setPreferredSize(this.mCovarList.getMinimumSize());
        this.mCovarList.setIdentifier(COVARIATE_LIST);
        this.mCovarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mWlsWtList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mWlsWtList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mWlsWtList.getModel().addListDataListener(this);
        this.mWlsWtListScroll = new JScrollPane(this.mWlsWtList);
        this.mWlsWtListScroll.setHorizontalScrollBarPolicy(31);
        this.mWlsWtListScroll.setVerticalScrollBarPolicy(21);
        this.mWlsWtListScroll.setPreferredSize(this.mWlsWtList.getMinimumSize());
        this.mWlsWtList.setIdentifier(WLSWEIGHT_LIST);
        this.mWlsWtList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mDepVarListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mDepVarListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mDepVarListArrow.registerVariableList(this.mDepVarList, SpssArrowButton.ButtonOrientation.left);
        this.mFixFactorListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mFixFactorListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mFixFactorListArrow.registerVariableList(this.mFixFactorList, SpssArrowButton.ButtonOrientation.left);
        this.mRandFactorListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mRandFactorListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mRandFactorListArrow.registerVariableList(this.mRandFactorList, SpssArrowButton.ButtonOrientation.left);
        this.mCovarListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCovarListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mCovarListArrow.registerVariableList(this.mCovarList, SpssArrowButton.ButtonOrientation.left);
        this.mWlsWtListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mWlsWtListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mWlsWtListArrow.registerVariableList(this.mWlsWtList, SpssArrowButton.ButtonOrientation.left);
        this.mSrcVarList.setSelectedIndex(0);
        this.mSavemap = new LinkedHashMap();
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mDepVarList.removeAll();
        this.mFixFactorList.removeAll();
        this.mRandFactorList.removeAll();
        this.mCovarList.removeAll();
        this.mWlsWtList.removeAll();
        this.enableOkPaste(false);
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mDepVarListArrow);
        if (this.mDepVarList.getModel().getSize() > 0) {
            vector.add(this.mDepVarList);
        }
        vector.add(this.mFixFactorListArrow);
        if (this.mFixFactorList.getModel().getSize() > 0) {
            vector.add(this.mFixFactorList);
        }
        vector.add(this.mRandFactorListArrow);
        if (this.mRandFactorList.getModel().getSize() > 0) {
            vector.add(this.mRandFactorList);
        }
        vector.add(this.mCovarListArrow);
        if (this.mCovarList.getModel().getSize() > 0) {
            vector.add(this.mCovarList);
        }
        vector.add(this.mWlsWtListArrow);
        if (this.mWlsWtList.getModel().getSize() > 0) {
            vector.add(this.mWlsWtList);
        }
        int n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setupViewPanel(JPanel jPanel) {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_DEPENDENT_VARIABLE");
        jLabel.setLabelFor(this.mDepVarList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_FIXED_FACTOR");
        jLabel2.setLabelFor(this.mFixFactorList);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_RANDOM_FACTOR");
        jLabel3.setLabelFor(this.mRandFactorList);
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_UNIVARIATE_COVARIATE");
        jLabel4.setLabelFor(this.mCovarList);
        JLabel jLabel5 = DialogUtil.createLabel(this, "IDS_WLSWEIGHT");
        jLabel5.setLabelFor(this.mWlsWtList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel6 = DialogUtil.createLabel(this, "IDS_UNIVARIATE_SOURCE_LIST_LABEL");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel6, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        Insets insets = DialogUtil.getArrowButtonInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(0, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 9, n, null);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mDepVarListArrow, gridBagConstraints, 1, 0, 1, 2, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.mDepVarListScroll, gridBagConstraints, 2, 1, 1, 1, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mFixFactorListArrow, gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        Insets insets3 = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 2, 1, 1, n, insets3);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mFixScrollPane, gridBagConstraints, 2, 3, 1, 1, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mRandFactorListArrow, gridBagConstraints, 1, 5, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 4, 1, 1, n, insets3);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mRandScrollPane, gridBagConstraints, 2, 5, 1, 1, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mCovarListArrow, gridBagConstraints, 1, 7, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 2, 6, 1, 1, n, insets3);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mCovarScrollPane, gridBagConstraints, 2, 7, 1, 1, n, null);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mWlsWtListArrow, gridBagConstraints, 1, 8, 1, 2, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel5, gridBagConstraints, 2, 8, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mWlsWtListScroll, gridBagConstraints, 2, 9, 1, 1, n, null);
    }

    private void runModelSubDlg() {
        this.runSubDialog(new GLMCommonModel(this, this.getResString("IDS_UNIVARIATE_MODEL_TITLE"), this.mFixFactorList.getModel(), this.mCovarList.getModel(), this.mRandFactorList.getModel(), "IDS_UNIVARIATE_FULL_FACTORIAL"));
    }

    private void runContrastSubDlg() {
        this.runSubDialog(new GLMCommonContrast((BaseProcedureDialog)this, this.getResString("IDS_UNIVARIATE_CONTRASTS_TITLE"), null, this.mFixFactorList.getModel(), this.mRandFactorList.getModel()));
    }

    private void runPlotsSubDlg() {
        this.runSubDialog(new GLMCommonPlots((BaseProcedureDialog)this, this.getResString("IDS_UNIVARIATE_PROFILEPLOTS_TITLE"), null, this.mFixFactorList.getModel(), this.mRandFactorList.getModel()));
    }

    private void runPostHocSubDlg() {
        this.runSubDialog(new GLMCommonPostHoc(this.mFixFactorList.getModel(), this));
    }

    private void runEMMeansSubDlg() {
        this.runSubDialog(new GLMCommonEMMeans(this));
    }

    private void runSaveSubDlg() {
        this.runSubDialog(new GLMCommonSave(this));
    }

    private void runOptionsSubDlg() {
        this.runSubDialog(new GLMCommonOptions(this));
    }

    private void enableBootstrappingButton() {
        if (this.mBootStrappingButton != null && this.mIsBootstrapOK) {
            if (this.mRandFactorList.getModel().getSize() != 0) {
                this.mBootStrappingButton.setEnabled(false);
            } else {
                this.mBootStrappingButton.setEnabled(true);
            }
        }
    }

    private HashMap<String, String> getDisplayMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("IDS_DISCRIPTIVE_STATITICS", "DESCRIPTIVE");
        hashMap.put("IDS_ESTIMATE_OF_EFFECT_SIZE", "ETASQ");
        hashMap.put("IDS_OBSERVED_POWER", "OPOWER");
        hashMap.put("IDS_UNIVARIATE_PARAMETER_ESTIMATES", "PARAMETER");
        hashMap.put("IDS_CONTRACT_COEFFICIENT_MATRIX", "TEST(LMATRIX)");
        hashMap.put("IDS_HOMOGENEITY_TESTS", "HOMOGENEITY");
        hashMap.put("IDS_LACK_OF_FIT", "LOF");
        hashMap.put("IDS_GENERAL_ESTIMABLE_FUNCTION", "GEF");
        return hashMap;
    }

    private HashMap<String, String> getHeteroTestsMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("IDS_MODIFIED_BREUSCH_PAGAN_TEST", "MBP");
        hashMap.put("IDS_BREUSCH_PAGAN_TEST", "BP");
        hashMap.put("IDS_F_TEST", "F");
        hashMap.put("IDS_WHITE_TEST", "WHITE");
        return hashMap;
    }

    private void getSaveCheckMap() {
        this.mSavemap.put("IDS_PRE_UNSTANDARDIZED", "PRED");
        this.mSavemap.put("IDS_STANDARD_ERROR", "SEPRED");
        this.mSavemap.put("IDS_RES_UNSTANDARDIZED", "RESID");
        this.mSavemap.put("IDS_RES_STANDARDIZED", "ZRESID");
        this.mSavemap.put("IDS_STUDIENTIZED", "SRESID");
        this.mSavemap.put("IDS_DELETED", "DRESID");
        this.mSavemap.put("IDS_COOKS_DISTANCE", "COOK");
        this.mSavemap.put("IDS_LEVERAGE_VALUES", "LEVER");
    }

    public class Combinations {
        private Object[] objects;
        private int numInGroup;
        private int[] index;
        private boolean isDone = false;

        public Combinations() {
        }

        private Combinations(Object[] objectArray, int n) {
            this.objects = objectArray;
            this.numInGroup = n;
            this.index = new int[this.numInGroup];
            for (int i = 0; i < this.numInGroup; ++i) {
                this.index[i] = i;
            }
        }

        public boolean isDone() {
            return this.isDone;
        }

        private void moveIndex() {
            int n = this.indexBelowMax();
            if (n >= 0) {
                this.index[n] = this.index[n] + 1;
                for (int i = n + 1; i < this.numInGroup; ++i) {
                    this.index[i] = this.index[i - 1] + 1;
                }
            } else {
                this.isDone = true;
            }
        }

        public Object nextElement() {
            if (this.isDone) {
                return null;
            }
            Object[] objectArray = new Object[this.numInGroup];
            for (int i = 0; i < this.numInGroup; ++i) {
                objectArray[i] = this.objects[this.index[i]];
            }
            this.moveIndex();
            return objectArray;
        }

        private int indexBelowMax() {
            for (int i = this.numInGroup - 1; i >= 0; --i) {
                if (this.index[i] >= this.objects.length - this.numInGroup + i) continue;
                return i;
            }
            return -1;
        }

        public Vector<String> generateCombinations(Vector<String> vector) {
            Vector<String> vector2 = new Vector<String>();
            Object[] objectArray = vector.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Combinations combinations = new Combinations(objectArray, i + 1);
                while (!combinations.isDone()) {
                    Object[] objectArray2 = (Object[])combinations.nextElement();
                    StringBuffer stringBuffer = new StringBuffer("");
                    for (Object object : objectArray2) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append("*");
                        }
                        stringBuffer.append(object.toString());
                    }
                    vector2.add(stringBuffer.toString());
                }
            }
            return vector2;
        }
    }

    class CombinationSorter
    implements Comparator<String> {
        CombinationSorter() {
        }

        @Override
        public int compare(String string, String string2) {
            int n;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "*");
            int n2 = stringTokenizer.countTokens();
            if (n2 == (n = (stringTokenizer = new StringTokenizer(string2, "*")).countTokens())) {
                return string.compareTo(string2);
            }
            if (n2 < n) {
                return -1;
            }
            return 1;
        }
    }
}

