/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats;

import com.spss.java_client.ui.dialogs.adv_stats.logit.LogitDlg;
import com.spss.java_client.ui.dialogs.common.AbstractModelSubDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormatSymbols;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LoglinearCommonOptions
extends BaseSubDialog
implements DocumentListener,
FocusListener {
    public static String[] CONVERGENCE_COMBO = new String[]{"0.1", "0.01", "0.001", "0.0001", "0.00001", "0.000001"};
    static final String FREQUNCY_CHECK = "IDS_OPT_FREQ_CHECK";
    static final String RESIDUAL_CHECK = "IDS_OPT_RESIDU_CHECK";
    static final String DES_MATRIX_CHECK = "IDS_OPT_MATRIX_CHECK";
    static final String ESTIMATE_CHECK = "IDS_OPT_ESTIMAT_CHECK";
    static final String ITERATION_CHECK = "IDS_OPT_ITERATE_CHECK";
    static final String ADJUST_CHECK = "IDS_OPT_ADJUST_CHECK";
    static final String NORM_ADJUST_CHECK = "IDS_OPT_NORM_ADJUST";
    static final String DEVIANCE_CHECK = "IDS_OPT_DEVIANCE_CHECK";
    static final String NORM_DEVIANCE = "IDS_OPT_NORM_DEVIANCE";
    static final String CONFI_INTERVAL = "IDS_OPT_CONFI_INTER";
    static final String MAX_ITER_TEXT = "IDS_OPT_MAX_ITER_TEXT";
    static final String DELTA_TEXT = "IDS_OPT_DELTA_TEXT";
    static final String CONVERGE_CHOICE = "IDS_OPT_CONVERG_CHOICE";
    private static final double CONFI_MINVALUE = 50.0;
    private static final double CONFI_MAXVALUE = 99.99;
    private static final int CONFI_PRECISION = 3;
    private static final String CONFI_PERCENT_DEFAULT_VALUES = "95";
    private static final String MAX_IT_DEFAULT_VALUE = "20";
    private static final double DELTA_MINVAL = 0.0;
    private static final double DELTA_MAXVAL = 1.0;
    private static final String DELTA_DEFAULT_VALUE = ".5";
    private JCheckBox mFrequencies;
    private JCheckBox mResiduals;
    private JCheckBox mDesignMatrix;
    private JCheckBox mEstimates;
    private JCheckBox mItHistory;
    private JCheckBox mAdResidual;
    private JCheckBox mNormAdjust;
    private JCheckBox mDeviance;
    private JCheckBox mNormDeviance;
    private JTextField mConfiText;
    private JTextField mMaxItText;
    private JTextField mDeltaText;
    private JComboBox mConvergCombo;

    public LoglinearCommonOptions(BaseProcedureDialog baseProcedureDialog, String string) {
        super(baseProcedureDialog, string, true);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mConfiText)) {
            this.mConfiText.selectAll();
        } else if (focusEvent.getSource().equals(this.mDeltaText)) {
            this.mDeltaText.selectAll();
        } else if (focusEvent.getSource().equals(this.mMaxItText)) {
            this.mMaxItText.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mConfiText.getText().length() > 0 && this.mMaxItText.getText().length() > 0 && this.mDeltaText.getText().length() > 0) {
            this.enableContinue(true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mConfiText.getText().length() == 0 || this.mMaxItText.getText().length() == 0 || this.mDeltaText.getText().length() == 0) {
            this.enableContinue(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public String getDialogHelpID() {
        if (this.getParent() instanceof LogitDlg) {
            return "idh_logt_opt";
        }
        return "idh_logl_opt";
    }

    public static String getOptionSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        Boolean bl2 = dialogDataModel.getBoolean(FREQUNCY_CHECK);
        if (bl2 == null || bl2.booleanValue()) {
            stringBuffer.append("FREQ");
            bl = true;
        }
        if ((bl2 = dialogDataModel.getBoolean(RESIDUAL_CHECK)) == null || bl2.booleanValue()) {
            stringBuffer.append(" RESID ADJRESID ZRESID DEV");
            bl = true;
        }
        if ((bl2 = dialogDataModel.getBoolean(DES_MATRIX_CHECK)) != null) {
            if (bl2.booleanValue()) {
                stringBuffer.append(" DESIGN");
                bl = true;
            }
            if ((bl2 = dialogDataModel.getBoolean(ESTIMATE_CHECK)).booleanValue()) {
                stringBuffer.append(" ESTIM CORR COV");
                bl = true;
            }
            if ((bl2 = dialogDataModel.getBoolean(ITERATION_CHECK)).booleanValue()) {
                stringBuffer.append(" ITERATION");
                bl = true;
            }
        }
        if (!bl) {
            stringBuffer.append("NONE\n");
        } else {
            stringBuffer.append("\n");
        }
        bl2 = dialogDataModel.getBoolean(AbstractModelSubDialog.MODEL_CUSTOM_KEY);
        if (bl2 != null && bl2.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/PLOT="));
            if (bl2.booleanValue()) {
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                bl2 = dialogDataModel.getBoolean(ADJUST_CHECK);
                if (bl2 == null || bl2.booleanValue()) {
                    stringBuffer.append("RESID(ADJRESID");
                    bl4 = true;
                    bl3 = true;
                }
                if ((bl2 = dialogDataModel.getBoolean(DEVIANCE_CHECK)) != null && bl2.booleanValue()) {
                    if (bl4) {
                        stringBuffer.append(" DEV)");
                    } else {
                        stringBuffer.append("RESID(DEV)");
                        bl3 = true;
                    }
                } else if (bl4) {
                    stringBuffer.append(")");
                }
                bl2 = dialogDataModel.getBoolean(NORM_ADJUST_CHECK);
                int n = stringBuffer.length();
                Character c = new Character(stringBuffer.charAt(n - 1));
                if (bl2 == null || bl2.booleanValue()) {
                    if (c.equals(Character.valueOf('='))) {
                        stringBuffer.append("NORMPROB(ADJRESID");
                    } else {
                        stringBuffer.append(" NORMPROB(ADJRESID");
                    }
                    bl5 = true;
                    bl3 = true;
                }
                if ((bl2 = dialogDataModel.getBoolean(NORM_DEVIANCE)) != null && bl2.booleanValue()) {
                    if (bl5) {
                        stringBuffer.append(" DEV)");
                    } else {
                        if (c.equals(Character.valueOf('='))) {
                            stringBuffer.append("NORMPROB(DEV)");
                        } else {
                            stringBuffer.append(" NORMPROB(DEV)");
                        }
                        bl3 = true;
                    }
                } else if (bl5) {
                    stringBuffer.append(")");
                }
                if (!bl3) {
                    stringBuffer.append("NONE\n");
                } else {
                    stringBuffer.append("\n");
                }
            }
        } else {
            stringBuffer.append(SyntaxUtil.getSubCommand("/PLOT=NONE"));
            stringBuffer.append("\n");
        }
        String string = CONFI_PERCENT_DEFAULT_VALUES;
        String string2 = MAX_IT_DEFAULT_VALUE;
        String string3 = "0.001";
        String string4 = DELTA_DEFAULT_VALUE;
        int n = 0;
        if (dialogDataModel.getString(CONFI_INTERVAL) != null) {
            string = dialogDataModel.getString(CONFI_INTERVAL);
            string2 = dialogDataModel.getString(MAX_ITER_TEXT);
            n = dialogDataModel.getInteger(CONVERGE_CHOICE);
            string4 = dialogDataModel.getString(DELTA_TEXT);
            Object[] objectArray = dialogDataModel.getArray("comboValues");
            string3 = objectArray[n].toString();
        }
        stringBuffer.append(SyntaxUtil.getSubCommand("/CRITERIA=CIN("));
        stringBuffer.append(string + ") " + "ITERATE(" + string2 + ") CONVERGE(" + string3 + ") DELTA(" + string4 + ")\n");
        return stringBuffer.toString();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.setDefault();
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void initVars() {
        ControlAction controlAction = new ToggleButtonAction(this.mParentDlg, FREQUNCY_CHECK);
        this.mFrequencies = new JCheckBox(controlAction);
        controlAction = new ToggleButtonAction(this.mParentDlg, RESIDUAL_CHECK);
        this.mResiduals = new JCheckBox(controlAction);
        controlAction = new ToggleButtonAction(this.mParentDlg, DES_MATRIX_CHECK);
        this.mDesignMatrix = new JCheckBox(controlAction);
        controlAction = new ToggleButtonAction(this.mParentDlg, ESTIMATE_CHECK);
        this.mEstimates = new JCheckBox(controlAction);
        controlAction = new ToggleButtonAction(this.mParentDlg, ITERATION_CHECK);
        this.mItHistory = new JCheckBox(controlAction);
        controlAction = new ToggleButtonAction(this.mParentDlg, ADJUST_CHECK);
        this.mAdResidual = new JCheckBox(controlAction);
        controlAction = new ToggleButtonAction(this.mParentDlg, NORM_ADJUST_CHECK);
        this.mNormAdjust = new JCheckBox(controlAction);
        controlAction = new ToggleButtonAction(this.mParentDlg, DEVIANCE_CHECK);
        this.mDeviance = new JCheckBox(controlAction);
        controlAction = new ToggleButtonAction(this.mParentDlg, NORM_DEVIANCE);
        this.mNormDeviance = new JCheckBox(controlAction);
        controlAction = new ToggleButtonAction(this.mParentDlg, ITERATION_CHECK);
        this.mItHistory = new JCheckBox(controlAction);
        controlAction = new TextFieldAction(this.mParentDlg, CONFI_INTERVAL);
        this.mConfiText = new FloatTextField(50.0, 99.99, 3);
        this.mConfiText.setAction(controlAction);
        this.mConfiText.setColumns(6);
        this.mConfiText.getDocument().addDocumentListener(this);
        this.mConfiText.addFocusListener(this);
        controlAction = new TextFieldAction(this.mParentDlg, MAX_ITER_TEXT);
        this.mMaxItText = new IntTextField(1, 999, true);
        this.mMaxItText.setColumns(6);
        this.mMaxItText.setAction(controlAction);
        this.mMaxItText.getDocument().addDocumentListener(this);
        this.mMaxItText.addFocusListener(this);
        controlAction = new TextFieldAction(this.mParentDlg, DELTA_TEXT);
        this.mDeltaText = new FloatTextField(0.0, 1.0, 3);
        this.mDeltaText.setAction(controlAction);
        this.mDeltaText.setColumns(6);
        this.mDeltaText.getDocument().addDocumentListener(this);
        this.mDeltaText.addFocusListener(this);
        ComboboxAction comboboxAction = new ComboboxAction(this.mParentDlg, CONVERGE_CHOICE);
        Vector<String> vector = new Vector<String>();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(UIToolResUtil.getSPSSLocale());
        String string = null;
        String[] stringArray = CONVERGENCE_COMBO;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2;
            string = string2 = stringArray[i];
            if (decimalFormatSymbols.getDecimalSeparator() != '.') {
                string = string2.replace('.', decimalFormatSymbols.getDecimalSeparator());
            }
            vector.add(string);
        }
        this.mConvergCombo = new JComboBox(vector);
        this.mConvergCombo.setAction(comboboxAction);
        this.mParentDlg.getDialogDataModel().putArray("comboValues", CONVERGENCE_COMBO);
        this.mConvergCombo.setMaximumRowCount(5);
    }

    private void setDefault() {
        Boolean bl = this.mParentDlg.getDialogDataModel().getBoolean(AbstractModelSubDialog.MODEL_CUSTOM_KEY);
        if (bl != null && bl.booleanValue()) {
            this.mAdResidual.setEnabled(true);
            this.mNormAdjust.setEnabled(true);
            this.mDeviance.setEnabled(true);
            this.mNormDeviance.setEnabled(true);
        } else {
            this.mAdResidual.setEnabled(false);
            this.mNormAdjust.setEnabled(false);
            this.mDeviance.setEnabled(false);
            this.mNormDeviance.setEnabled(false);
        }
        this.mFrequencies.setSelected(true);
        this.mResiduals.setSelected(true);
        this.mAdResidual.setSelected(true);
        this.mNormAdjust.setSelected(true);
        this.mConfiText.setText(CONFI_PERCENT_DEFAULT_VALUES);
        this.mMaxItText.setText(MAX_IT_DEFAULT_VALUE);
        this.mDeltaText.setText(DELTA_DEFAULT_VALUE);
        this.mConvergCombo.setSelectedIndex(2);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mFrequencies);
        vector.add(this.mResiduals);
        vector.add(this.mDesignMatrix);
        vector.add(this.mEstimates);
        vector.add(this.mItHistory);
        vector.add(this.mAdResidual);
        vector.add(this.mNormAdjust);
        vector.add(this.mDeviance);
        vector.add(this.mNormDeviance);
        vector.add(this.mConfiText);
        vector.add(this.mMaxItText);
        vector.add(this.mConvergCombo);
        vector.add(this.mDeltaText);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setupPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = this.setupDisplayPanel();
        JPanel jPanel3 = this.setupPercentPanel();
        JPanel jPanel4 = this.setupCriteriaPanel();
        JPanel jPanel5 = this.setupPlotPanel();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_OPT_CONFI_INTER_LABEL");
        jLabel.setLabelFor(this.mConfiText);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        Insets insets = new Insets(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, 3, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 2, 2, 1, n, null);
    }

    private JPanel setupDisplayPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_OPT_DISPLAY_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        insets = new Insets(insets.top, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mFrequencies, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mResiduals, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mDesignMatrix, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mEstimates, gridBagConstraints, 0, 3, 1, 1, n, insets);
        insets = new Insets(insets.top, insets.left, DialogUtil.getGroupBoxInnerMargin(), 0);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mItHistory, gridBagConstraints, 0, 4, 1, 1, n, insets);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupPlotPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_OPT_PLOT_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mAdResidual, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mNormAdjust, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mDeviance, gridBagConstraints, 0, 2, 1, 1, n, insets);
        insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mNormDeviance, gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupPercentPanel() {
        Insets insets = DialogUtil.getStandardControlInsets();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_OPT_CONFI_INTER_LABEL");
        jLabel.setLabelFor(this.mConfiText);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel2 = new JLabel(this.getResString("IDS_OPT_PERCENT_LABEL"), 10);
        gridBagConstraints.fill = 0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        Insets insets2 = new Insets(0, DialogUtil.getGroupBoxInnerMargin() * 2 - insets.bottom * 3, DialogUtil.getGroupBoxInnerMargin(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mConfiText, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupCriteriaPanel() {
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, 0, 0, 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_OPT_CRITERIA_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_OPT_MAX_ITER_LABEL");
        jLabel.setLabelFor(this.mMaxItText);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_OPT_CONVERG_LABEL");
        jLabel2.setLabelFor(this.mConvergCombo);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_OPT_DELTA_LABEL");
        jLabel3.setLabelFor(this.mDeltaText);
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mMaxItText, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        insets2.set(DialogUtil.getGroupBoxInnerMargin(), insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mConvergCombo, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.set(DialogUtil.getGroupBoxInnerMargin(), insets.left, DialogUtil.getGroupBoxInnerMargin(), insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mDeltaText, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        return jPanel;
    }
}

