/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats;

import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.DatasetNameValidator;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.adv_stats.UnivariateDlg;
import com.spss.java_client.ui.dialogs.adv_stats.multivariate.MultivariateDlg;
import com.spss.java_client.ui.dialogs.adv_stats.rep_measures.RepeatedMeasureDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class GLMCommonSave
extends BaseSubDialog
implements ItemListener,
DocumentListener {
    public static final String FILE_BUTTON = "IDS_FILE_BUTTON";
    public static final String PRE_WEIGHTED = "IDS_PRE_WEIGHTED";
    public static final String PRE_UNSTANDARDIZED = "IDS_PRE_UNSTANDARDIZED";
    public static final String RES_WEIGHTED = "IDS_RES_WEIGHTED";
    public static final String RES_UNSTANDARDIZED = "IDS_RES_UNSTANDARDIZED";
    public static final String PRE_STANDARD_ERROR = "IDS_STANDARD_ERROR";
    public static final String RES_DELETED = "IDS_DELETED";
    public static final String RES_STUDENTIZED = "IDS_STUDIENTIZED";
    public static final String RES_STANDARDIZED = "IDS_RES_STANDARDIZED";
    public static final String LEVERAGE = "IDS_LEVERAGE_VALUES";
    public static final String COOKS = "IDS_COOKS_DISTANCE";
    public static final String COEFF_STATS = "IDS_CREATE_COEFFICIENT_STATS";
    public static final String WRITE_DATASET = "IDS_WRITE_NEW_DATA_FILE";
    public static final String CREATE_DATASET = "IDS_CREATE_NEW_DATASET";
    public static final String DATASET = "IDS_DATASET_NAME_EDIT";
    public static final String FILE_PATH = "IDS_FILE_PATH";
    public static final String STD_STATISTICS = "IDS_STD_STATISTICS";
    public static final String HETEROSKEDASTICITY_STATISTICS = "IDS_HETEROSKEDASTICITY_STATISTICS";
    private JButton mFileButton;
    private JLabel mDataSetLabel;
    private JTextField mFilePath;
    private StringTextField mDataset;
    private JCheckBox mResWeightedCheck;
    private JCheckBox mPreWeightedCheck;
    private JCheckBox mCoeffStatsCheck;
    private JRadioButton mNewDataSetRadio;
    private JRadioButton mWriteNewDataSetRadio;
    private String mPath;
    private JPanel mPredictValPanel;
    private JPanel mResidualPanel;
    private JPanel mDiagnosticsPanel;
    private JPanel mDestinationPanel;
    private JPanel mTypePanel;
    private SpssButtonGroup mRadioButtonGroup;
    private DialogDataModel mModel;
    private boolean mParamEstRobStdErr;
    private JRadioButton mStdStatisticsRadio;
    private JRadioButton mHeteroSkedasticityStatisticsRadio;
    private SpssButtonGroup mTypeRadioButtonGroup;
    private FocusableTextArea mRequirementInfoLabel;
    private JLabel iconLabel;
    private String mSaveDialogTitle;

    public GLMCommonSave(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, "", true);
        String string = "";
        if (baseProcedureDialog instanceof UnivariateDlg) {
            string = baseProcedureDialog.getResString("IDS_UNIVARIATE_SAVE_TITLE");
            this.mModel = ((UnivariateDlg)((Object)this.getParent())).getDialogDataModel();
            this.mSaveDialogTitle = this.getResString("IDS_UNIVARIATE_FILE_CHOOSER_TITLE");
        } else if (baseProcedureDialog instanceof MultivariateDlg) {
            string = baseProcedureDialog.getResString("IDS_MULTIVARIATE_SAVE_TITLE");
            this.mModel = ((MultivariateDlg)((Object)this.getParent())).getDialogDataModel();
            this.mSaveDialogTitle = this.getResString("IDS_MULTIVARIATE_FILE_CHOOSER_TITLE");
        } else {
            string = baseProcedureDialog.getResString("IDS_REP_MEA_SAVE_TITLE");
            this.mModel = ((RepeatedMeasureDlg)((Object)this.getParent())).getDialogDataModel();
            this.mSaveDialogTitle = this.getResString("IDS_REPEATED_MEASURES_FILE_CHOOSER_TITLE");
        }
        this.setTitle(string);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = this.mCoeffStatsCheck.isSelected();
        this.mStdStatisticsRadio.setEnabled(bl);
        if (this.mParentDlg instanceof UnivariateDlg) {
            this.iconLabel.setEnabled(bl);
            this.mRequirementInfoLabel.setEnabled(bl);
            this.mHeteroSkedasticityStatisticsRadio.setEnabled(bl && this.mParamEstRobStdErr);
        }
        boolean bl2 = this.mHeteroSkedasticityStatisticsRadio.isSelected() && !this.mHeteroSkedasticityStatisticsRadio.isEnabled() && this.mParentDlg instanceof UnivariateDlg;
        this.mNewDataSetRadio.setEnabled(bl && !bl2);
        this.mWriteNewDataSetRadio.setEnabled(bl && !bl2);
        this.mDataSetLabel.setEnabled(this.mNewDataSetRadio.isSelected() && bl && !bl2);
        this.mDataset.setEnabled(this.mNewDataSetRadio.isSelected() && bl && !bl2);
        this.mDataset.setOpaque(this.mDataset.isEnabled());
        this.mFileButton.setEnabled(this.mWriteNewDataSetRadio.isSelected() && bl && !bl2);
        this.mFilePath.setEnabled(this.mWriteNewDataSetRadio.isSelected() && bl && !bl2);
        this.mDestinationPanel.setEnabled(bl && !bl2);
        this.mTypePanel.setEnabled(bl);
        this.enableContinue(this.canEnableContinue());
    }

    public boolean canEnableContinue() {
        if (this.mHeteroSkedasticityStatisticsRadio.isSelected() && !this.mHeteroSkedasticityStatisticsRadio.isEnabled()) {
            return false;
        }
        if (this.mCoeffStatsCheck.isSelected()) {
            if (this.mNewDataSetRadio.isSelected() && this.mDataset.getText().length() > 0) {
                return true;
            }
            if (this.mWriteNewDataSetRadio.isSelected() && this.mFilePath.getText().length() > 0) {
                return true;
            }
            if (this.mWriteNewDataSetRadio.isSelected() && this.mCoeffStatsCheck.isSelected() && (this.mFilePath.getText() == null || this.mFilePath.getText().trim().length() == 0)) {
                return this.mModel.getString(FILE_PATH) != null && this.mModel.getString(FILE_PATH).length() != 0;
            }
            return false;
        }
        return true;
    }

    public void paint(Graphics graphics) {
        if (this.mPath != null) {
            this.mFilePath.setText(this.mPath);
        }
        super.paint(graphics);
    }

    @Override
    public boolean continuePressed() {
        if (this.mCoeffStatsCheck.isSelected() && this.mNewDataSetRadio.isSelected()) {
            int n = DatasetNameValidator.validateDatasetName((String)this.mDataset.getText(), (Component)((Object)this));
            if (n == 1) {
                return true;
            }
            this.mDataset.requestFocus();
            this.mDataset.selectAll();
            return false;
        }
        return true;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.mDataset.getText().length() > 0);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.mDataset.getText().length() > 0);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.mDataset.getText().length() > 0);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_glmu_sav";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.mPredictValPanel = this.getPredictedValPanel();
        this.mResidualPanel = this.getResidualPanel();
        this.mDiagnosticsPanel = this.getDiagnosticsPanel();
        this.mDestinationPanel = new JPanel();
        this.mTypePanel = new JPanel();
        JPanel jPanel2 = this.getCoeffStatsPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, n, n);
        int n2 = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.createButtonGroup(this.mPredictValPanel);
        DialogUtil.addUsingGBL(jPanel, this.mPredictValPanel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        insets = new Insets(0, 0, n, n);
        DialogUtil.createButtonGroup(this.mDiagnosticsPanel);
        DialogUtil.addUsingGBL(jPanel, this.mDiagnosticsPanel, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        insets = new Insets(0, 0, n, 0);
        DialogUtil.createButtonGroup(this.mResidualPanel);
        DialogUtil.addUsingGBL(jPanel, this.mResidualPanel, gridBagConstraints, 1, 0, 1, 2, n2, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 2, 1, n2, null);
        if (this.mParentDlg instanceof UnivariateDlg) {
            if (((UnivariateDlg)this.mParentDlg).isWLSListEmpty().booleanValue()) {
                this.mPreWeightedCheck.setEnabled(false);
                this.mResWeightedCheck.setEnabled(false);
            }
        } else if (this.mParentDlg instanceof MultivariateDlg && ((MultivariateDlg)this.mParentDlg).isWLSListEmpty().booleanValue()) {
            this.mPreWeightedCheck.setEnabled(false);
            this.mResWeightedCheck.setEnabled(false);
        }
        this.pack();
        this.setFocusTraversalPolicy();
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, PRE_WEIGHTED);
        this.mPreWeightedCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, RES_WEIGHTED);
        this.mResWeightedCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, COEFF_STATS);
        this.mCoeffStatsCheck = new JCheckBox(toggleButtonAction);
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mCoeffStatsCheck.setSelected(false);
            this.mCoeffStatsCheck.setEnabled(false);
        } else {
            this.mCoeffStatsCheck.addItemListener(this);
        }
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, CREATE_DATASET);
        this.mNewDataSetRadio = new JRadioButton(toggleButtonAction);
        this.mNewDataSetRadio.setEnabled(false);
        this.mNewDataSetRadio.setSelected(true);
        this.mNewDataSetRadio.addItemListener(this);
        this.mDataSetLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_DATASET_NAME");
        this.mDataSetLabel.setEnabled(false);
        this.mDataset = new StringTextField();
        this.mDataset.setAction(new TextFieldAction(this.mParentDlg, DATASET));
        this.mDataset.setEnabled(false);
        this.mDataset.setOpaque(false);
        this.mDataset.setColumns(14);
        this.mDataset.setPreferredSize((Dimension)this.mDataset.getPreferredSize().clone());
        this.mDataset.getDocument().addDocumentListener(this);
        this.mDataSetLabel.setLabelFor((Component)((Object)this.mDataset));
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, WRITE_DATASET);
        this.mWriteNewDataSetRadio = new JRadioButton(toggleButtonAction);
        this.mWriteNewDataSetRadio.setEnabled(false);
        this.mWriteNewDataSetRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, FILE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GLMCommonSave.this.showSaveDialog();
            }
        };
        this.mFileButton = new JButton(toggleButtonAction);
        this.mFileButton.setEnabled(false);
        this.mFilePath = new FileTextField();
        this.mFilePath.setAction(new TextFieldAction(this.mParentDlg, FILE_PATH));
        this.mFilePath.setOpaque(false);
        this.mFilePath.setEditable(false);
        this.mFilePath.setColumns(20);
        this.mFilePath.setEnabled(false);
        this.mFilePath.setFocusTraversalKeysEnabled(false);
        this.mFilePath.setBorder(BorderFactory.createEmptyBorder());
        this.mFilePath.setText("");
        this.mRadioButtonGroup = new SpssButtonGroup();
        this.mRadioButtonGroup.add(this.mNewDataSetRadio);
        this.mRadioButtonGroup.add(this.mWriteNewDataSetRadio);
        this.mParamEstRobStdErr = false;
        this.mParamEstRobStdErr = this.mParentDlg.getDialogDataModel().getBoolean("IDS_UNIVARIATE_PARAMETER_ESTIMATES_WITH_ROBUST_STANDARD_ERROR") == null ? false : this.mParentDlg.getDialogDataModel().getBoolean("IDS_UNIVARIATE_PARAMETER_ESTIMATES_WITH_ROBUST_STANDARD_ERROR");
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, STD_STATISTICS);
        this.mStdStatisticsRadio = new JRadioButton(toggleButtonAction);
        this.mStdStatisticsRadio.setEnabled(false);
        this.mStdStatisticsRadio.setSelected(true);
        this.mStdStatisticsRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, HETEROSKEDASTICITY_STATISTICS);
        this.mHeteroSkedasticityStatisticsRadio = new JRadioButton(toggleButtonAction);
        this.mHeteroSkedasticityStatisticsRadio.setEnabled(this.mParamEstRobStdErr && this.mCoeffStatsCheck.isSelected());
        this.mHeteroSkedasticityStatisticsRadio.setSelected(false);
        this.mHeteroSkedasticityStatisticsRadio.addItemListener(this);
        this.mTypeRadioButtonGroup = new SpssButtonGroup();
        this.mTypeRadioButtonGroup.add(this.mStdStatisticsRadio);
        this.mTypeRadioButtonGroup.add(this.mHeteroSkedasticityStatisticsRadio);
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        int n2 = this.mPredictValPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            vector.add(this.mPredictValPanel.getComponent(n));
        }
        n2 = this.mDiagnosticsPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            vector.add(this.mDiagnosticsPanel.getComponent(n));
        }
        n2 = this.mResidualPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            vector.add(this.mResidualPanel.getComponent(n));
        }
        vector.add(this.mCoeffStatsCheck);
        vector.add(this.mTypeRadioButtonGroup);
        vector.add(this.mRequirementInfoLabel);
        n2 = this.mDestinationPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            vector.add(this.mDestinationPanel.getComponent(n));
        }
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void showSaveDialog() {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        remoteFileChooser.setDialogTitle(this.mSaveDialogTitle);
        RefFileFilter refFileFilter = new RefFileFilter(this.getResString("IDS_FILE_FILTER_DESC"), this.getResString("IDS_SAVE_FILE_EXTENSION"));
        remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
        int n = remoteFileChooser.showSaveDialog((Component)((Object)this.mParentDlg));
        if (n == 0) {
            this.mPath = remoteFileChooser.getSelectedFilePath();
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            if (!this.mPath.endsWith(this.getResString("IDS_SAVE_FILE_EXTENSION"))) {
                this.mPath = this.mPath + this.getResString("IDS_SAVE_FILE_EXTENSION");
            }
            this.mFilePath.setText(this.mPath);
            this.enableContinue(true);
        }
    }

    private JPanel getPredictedValPanel() {
        JPanel jPanel = null;
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, PRE_UNSTANDARDIZED);
        JCheckBox jCheckBox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, PRE_STANDARD_ERROR);
        JCheckBox jCheckBox2 = new JCheckBox(toggleButtonAction);
        if (this.mParentDlg instanceof RepeatedMeasureDlg) {
            JComponent[] jComponentArray = new JComponent[]{jCheckBox, jCheckBox2};
            jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_GLM_PREDICTED_VALUES"), 2);
        } else {
            JComponent[] jComponentArray = new JComponent[]{jCheckBox, this.mPreWeightedCheck, jCheckBox2};
            jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_GLM_PREDICTED_VALUES"), 3);
        }
        return jPanel;
    }

    private JPanel getResidualPanel() {
        JPanel jPanel = null;
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, RES_UNSTANDARDIZED);
        JCheckBox jCheckBox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, RES_STANDARDIZED);
        JCheckBox jCheckBox2 = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, RES_STUDENTIZED);
        JCheckBox jCheckBox3 = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, RES_DELETED);
        JCheckBox jCheckBox4 = new JCheckBox(toggleButtonAction);
        if (this.mParentDlg instanceof RepeatedMeasureDlg) {
            JComponent[] jComponentArray = new JComponent[]{jCheckBox, jCheckBox2, jCheckBox3, jCheckBox4};
            jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_GLM_RESIDUALS"), 4);
        } else {
            JComponent[] jComponentArray = new JComponent[]{jCheckBox, this.mResWeightedCheck, jCheckBox2, jCheckBox3, jCheckBox4};
            jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_GLM_RESIDUALS"), 5);
        }
        return jPanel;
    }

    private JPanel getDiagnosticsPanel() {
        JPanel jPanel = null;
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, COOKS);
        JCheckBox jCheckBox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, LEVERAGE);
        JCheckBox jCheckBox2 = new JCheckBox(toggleButtonAction);
        JComponent[] jComponentArray = new JComponent[]{jCheckBox, jCheckBox2};
        jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_DIAGNOSTICS"), 2);
        return jPanel;
    }

    private JPanel getCoeffStatsPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_COEFFICIENT_STATS"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mCoeffStatsCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        if (this.mParentDlg instanceof UnivariateDlg) {
            this.mTypePanel = this.getTypePanel(gridBagConstraints, insets, n);
            DialogUtil.addUsingGBL(jPanel, this.mTypePanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        }
        this.mDestinationPanel = this.getDestinationPanel(gridBagConstraints, insets, n);
        DialogUtil.addUsingGBL(jPanel, this.mDestinationPanel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel getTypePanel(GridBagConstraints gridBagConstraints, Insets insets, int n) {
        this.mTypePanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_COEFFICIENT_STATS_TYPE"));
        this.mTypePanel.setBorder(titledBorder);
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(this.mTypePanel, this.mStdStatisticsRadio, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        int n2 = DialogUtil.getComponentGroupGap();
        insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mTypePanel, this.mHeteroSkedasticityStatisticsRadio, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        this.iconLabel = new JLabel(new ImageIcon(uRL));
        this.iconLabel.setEnabled(false);
        this.mRequirementInfoLabel = new FocusableTextArea(this.getResString("IDS_COEFFICIENT_STATS_TYPE_REQUIREMENT"), null);
        this.mRequirementInfoLabel.setEnabled(false);
        int n3 = 1;
        if (this.mRequirementInfoLabel.getText().length() > 40) {
            this.mRequirementInfoLabel.setRows(2);
            n3 = 2;
        }
        this.mRequirementInfoLabel.setMinimumSize(this.mRequirementInfoLabel.getPreferredSize());
        insets2 = new Insets(insets.top, insets.left + 20, n2, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mTypePanel, this.iconLabel, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        gridBagConstraints.fill = 2;
        insets2 = new Insets(insets.top, insets.left + 20 + this.iconLabel.getMaximumSize().width + n2, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(this.mTypePanel, this.mRequirementInfoLabel, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        return this.mTypePanel;
    }

    private JPanel getDestinationPanel(GridBagConstraints gridBagConstraints, Insets insets, int n) {
        this.mDestinationPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_COEFFICIENT_STATS_DESTINATION"));
        this.mDestinationPanel.setBorder(titledBorder);
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(this.mDestinationPanel, this.mNewDataSetRadio, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        insets2 = new Insets(insets.top, insets.left + 20, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(this.mDestinationPanel, this.mDataSetLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.fill = 0;
        insets2 = new Insets(insets.top, insets.left + 20 + this.mDataSetLabel.getPreferredSize().width + n2, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(this.mDestinationPanel, (JComponent)((Object)this.mDataset), gridBagConstraints, 0, 2, 1, 1, n, insets2);
        insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mDestinationPanel, this.mWriteNewDataSetRadio, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        insets2 = new Insets(insets.top, insets.left + 20, n2, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mDestinationPanel, this.mFileButton, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        DialogUtil.normalizeButtonWidths((JPanel)this.mDestinationPanel);
        gridBagConstraints.fill = 2;
        insets2 = new Insets(insets.top, insets.left + 20 + this.mFileButton.getMaximumSize().width + n2, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(this.mDestinationPanel, this.mFilePath, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        return this.mDestinationPanel;
    }
}

