/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.ListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.VarListDropListener;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GLMCommonPlots
extends BaseSubDialog
implements ListDataListener,
ListSelectionListener,
FocusListener,
MouseListener {
    public static final String TARGET_LIST = "IDS_REP_MEA_PLOT_TARGET_LIST";
    public static final String ADD_BUTTON = "IDS_REP_MEA_PLOT_ADD_BUTTON";
    public static final String CHANGE_BUTTON = "IDS_REP_MEA_PLOT_CHANGE";
    public static final String REMOVE_BUTTON = "IDS_REP_MEA_PLOT_REMOVE_BUTTON";
    public static final String HORIZONTAL_AXIS_LIST = "IDS_REP_MEA_PLOT_HORIZONTAL_AXIS_LIST";
    public static final String SEPRATE_LINE_LIST = "IDS_REP_MEA_PLOT_SEP_LINE_LIST";
    public static final String SEPRATE_PLOT_LIST = "IDS_REP_MEA_PLOT_SEP_PLOT_LIST";
    public static final String PLOTS_SRC_LIST = "IDS_REP_MEA_PLOT_PLOTS_SOURCE_LIST";
    public static final String LINECHART_RADIO = "IDS_REP_MEA_PLOT_LINECHART";
    public static final String BARCHART_RADIO = "IDS_REP_MEA_PLOT_BARCHART";
    public static final String ERRORBARS_CHECK = "IDS_REP_MEA_PLOT_INCLUDE_ERROR";
    public static final String CONFI_INTERVAL_RADIO = "IDS_REP_MEA_PLOT_CONFI_INTERVAL";
    public static final String STANDARD_ERROR_RADIO = "IDS_REP_MEA_PLOT_STAND_ERROR";
    public static final String MEANREFERENCE_CHECK = "IDS_REP_MEA_PLOT_INCLUDE_REFLINE";
    public static final String YAXIS_CHECK = "IDS_REP_MEA_PLOT_YAXIS_START0";
    public static final String MULTIPLIER_FIELD = "IDS_MULTIPLIER_EDIT";
    private DefaultListModel mModel;
    private TargetVariableList mSrcList;
    private TargetVariableList mAxisList;
    private TargetVariableList mLineList;
    private TargetVariableList mPlotList;
    private PlainList mTargetList;
    private JScrollPane mSrcScrollPane;
    private ArrowButton mLineListArrow;
    private ArrowButton mPlotListArrow;
    private ArrowButton mAxisListArrow;
    private JButton mAddButton;
    private JButton mChangeButton;
    private JButton mRemoveButton;
    private JScrollPane mTargetScrollPane;
    private JScrollPane mAxisListScroll;
    private JScrollPane mLineListScroll;
    private JScrollPane mPlotListScroll;
    private VarListModel mFixFactorVars;
    private VarListModel mRandFactorVars;
    private Vector<String> mRepMeasuresFactors;
    boolean isSourceSrcList = true;
    private JRadioButton mLineChartTypeRadio;
    private JRadioButton mBarChartTypeRadio;
    private JCheckBox mIncludeErrorBarsCheck;
    private JRadioButton mConfidenceIntervalRadio;
    private JRadioButton mStandardErrorRadio;
    private JCheckBox mIncludeRefLineForGrandMeanCheck;
    private JCheckBox mYAxisStart0Check;
    private JLabel mMultiplierLabel;
    private FloatTextField mMultiplierField;
    private SpssButtonGroup mChartTypeGroup;
    private SpssButtonGroup mIncludeGroup;

    public GLMCommonPlots(BaseProcedureDialog baseProcedureDialog, String string, Vector<String> vector, VarListModel varListModel, VarListModel varListModel2) {
        super(baseProcedureDialog, string, true);
        this.mFixFactorVars = varListModel;
        this.mRandFactorVars = varListModel2;
        this.mRepMeasuresFactors = vector;
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_glmu_plot";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateAdd();
        this.callToEnableArrowButton();
        if (listDataEvent.getSource() == this.mAxisList.getModel()) {
            this.mAxisListArrow.setEnabled(true);
        }
        if (listDataEvent.getSource() == this.mLineList.getModel()) {
            this.mLineListArrow.setEnabled(true);
        }
        if (listDataEvent.getSource() == this.mPlotList.getModel()) {
            this.mPlotListArrow.setEnabled(true);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updateAdd();
        this.mRemoveButton.setEnabled(false);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateAdd();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.mTargetList) {
            this.canEnableACRButton();
        }
        if (mouseEvent.getSource() == this.mSrcList) {
            this.callToEnableArrowButton();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource().equals(this.mSrcList)) {
            this.isSourceSrcList = true;
        }
        if (mouseEvent.getSource().equals(this.mAxisList)) {
            this.isSourceSrcList = false;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (listSelectionEvent.getSource() == this.mTargetList) {
            this.canEnableACRButton();
            this.mTargetList.requestFocusInWindow();
        } else if (listSelectionEvent.getSource() == this.mSrcList) {
            this.callToEnableArrowButton();
        }
    }

    @Override
    public boolean continuePressed() {
        boolean bl = true;
        if (this.mAddButton.isEnabled()) {
            bl = this.showInfoDialog(this.getResString("ERR_REP_MEA_PLOT_MESSAGE"));
        }
        return bl;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mSrcList) {
            this.callToEnableArrowButton();
        }
        if (focusEvent.getSource() == this.mAxisList && this.mAxisList.getModel().getSize() > 0) {
            this.mAxisList.setSelectedValue(this.mAxisList.getModel().getElementAt(0), false);
        }
        if (focusEvent.getSource() == this.mLineList && this.mLineList.getModel().getSize() > 0) {
            this.mLineList.setSelectedValue(this.mLineList.getModel().getElementAt(0), false);
        }
        if (focusEvent.getSource() == this.mPlotList && this.mPlotList.getModel().getSize() > 0) {
            this.mPlotList.setSelectedValue(this.mPlotList.getModel().getElementAt(0), false);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        this.setFactorListModel();
        this.setDefaults(true);
        if (this.mTargetList.getModel().getSize() > 0 && this.mTargetList.getSelectedIndex() < 0) {
            this.mTargetList.removeListSelectionListener(this);
            ListSelectionModel listSelectionModel = this.mTargetList.getSelectionModel();
            listSelectionModel.setAnchorSelectionIndex(0);
            listSelectionModel.setLeadSelectionIndex(0);
            listSelectionModel.clearSelection();
            this.mTargetList.addListSelectionListener(this);
        }
        this.setEnableStateForMinorControls(this.mModel.getSize() > 0);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.setDefaults(false);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    @Override
    public void pack() {
        super.pack();
        DialogUtil.removeDragAdapters((DragPane)this.getGlassPane(), (Component)((Object)this));
        if (this.getGlassPane() instanceof DragPane) {
            this.addDragAdapters((DragPane)this.getGlassPane(), (Component)((Object)this), this.mVarMoveHandler);
        }
    }

    public static String getCommonPlotDlgSyntax(DialogDataModel dialogDataModel) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = dialogDataModel.getArray(TARGET_LIST);
        String string = "";
        if (objectArray != null) {
            Object[] objectArray2 = objectArray;
            n = objectArray2.length;
            for (int i = 0; i < n; ++i) {
                Object object = objectArray2[i];
                String string2 = object.toString();
                string = string + string2 + " ";
            }
        }
        if ((string = string.trim()).length() > 0) {
            stringBuffer.append("PROFILE(").append(string).append(")");
            boolean bl = dialogDataModel.containsBooleanKey(LINECHART_RADIO) ? dialogDataModel.getBoolean(LINECHART_RADIO) : true;
            stringBuffer.append(" TYPE=").append(bl ? "LINE" : "BAR");
            stringBuffer.append(" ERRORBAR=");
            boolean bl2 = bl = dialogDataModel.containsBooleanKey(ERRORBARS_CHECK) ? dialogDataModel.getBoolean(ERRORBARS_CHECK) : false;
            if (!bl) {
                stringBuffer.append("NO");
            } else {
                int n2 = n = dialogDataModel.containsBooleanKey(CONFI_INTERVAL_RADIO) ? (int)(dialogDataModel.getBoolean(CONFI_INTERVAL_RADIO).booleanValue() ? 1 : 0) : 1;
                if (n != 0) {
                    stringBuffer.append("CI");
                } else {
                    stringBuffer.append("SE(");
                    stringBuffer.append(dialogDataModel.getString(MULTIPLIER_FIELD));
                    stringBuffer.append(")");
                }
            }
            bl = dialogDataModel.containsBooleanKey(MEANREFERENCE_CHECK) ? dialogDataModel.getBoolean(MEANREFERENCE_CHECK) : false;
            stringBuffer.append(" MEANREFERENCE=").append(bl ? "YES" : "NO");
            int n3 = n = dialogDataModel.containsBooleanKey(BARCHART_RADIO) ? (int)(dialogDataModel.getBoolean(BARCHART_RADIO).booleanValue() ? 1 : 0) : 0;
            if (n == 0) {
                bl = dialogDataModel.containsBooleanKey(YAXIS_CHECK) ? dialogDataModel.getBoolean(YAXIS_CHECK) : false;
                stringBuffer.append(" YAXIS=").append(bl ? "0" : "AUTO");
            }
        }
        return stringBuffer.toString();
    }

    protected void initVars() {
        this.mSrcList = new TargetVariableList();
        this.mSrcList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mSrcList.setDataSource(true);
        this.mSrcList.setShowIcon(false);
        this.mSrcList.setShowVarLabels(false, true);
        this.mSrcList.setLoadFromPersistent(false);
        this.mSrcScrollPane = new JScrollPane(this.mSrcList);
        Dimension dimension = this.mSrcList.getMinimumSize();
        this.mSrcScrollPane.setPreferredSize(dimension);
        this.mSrcList.setSelectionMode(0);
        this.mSrcList.getModel().addListDataListener(this);
        this.mSrcList.addFocusListener(this);
        this.mSrcList.addListSelectionListener(this);
        this.mAxisListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mAxisList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mAxisList.setIdentifier(HORIZONTAL_AXIS_LIST);
        this.mAxisList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mAxisList.setShowIcon(false);
        this.mAxisList.setShowVarLabels(false, true);
        this.mAxisList.addMouseListener(this);
        this.mAxisListScroll = new JScrollPane(this.mAxisList);
        this.mAxisListScroll.setHorizontalScrollBarPolicy(31);
        this.mAxisListScroll.setVerticalScrollBarPolicy(21);
        Dimension dimension2 = this.mAxisList.getMinimumSize();
        if (dimension2.height < 20) {
            dimension2.height = 24;
        }
        this.mAxisListScroll.setPreferredSize(dimension2);
        this.mAxisList.getModel().addListDataListener(this);
        this.mAxisList.addFocusListener(this);
        this.mLineListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mLineList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mLineList.setIdentifier(SEPRATE_LINE_LIST);
        this.mLineList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mLineList.setShowIcon(false);
        this.mLineList.setShowVarLabels(false, true);
        this.mLineListScroll = new JScrollPane(this.mLineList);
        this.mLineListScroll.setHorizontalScrollBarPolicy(31);
        this.mLineListScroll.setVerticalScrollBarPolicy(21);
        this.mLineListScroll.setPreferredSize(dimension2);
        this.mLineList.getModel().addListDataListener(this);
        this.mLineList.addFocusListener(this);
        this.mPlotListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mPlotList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mPlotList.setIdentifier(SEPRATE_PLOT_LIST);
        this.mPlotList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mPlotList.setShowIcon(false);
        this.mPlotList.setShowVarLabels(false, true);
        this.mPlotListScroll = new JScrollPane(this.mPlotList);
        this.mPlotListScroll.setHorizontalScrollBarPolicy(31);
        this.mPlotListScroll.setVerticalScrollBarPolicy(21);
        this.mPlotListScroll.setPreferredSize(dimension2);
        this.mPlotList.getModel().addListDataListener(this);
        this.mPlotList.addFocusListener(this);
        this.mAxisListArrow.registerVariableList(this.mSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mAxisListArrow.registerVariableList(this.mAxisList, SpssArrowButton.ButtonOrientation.left);
        this.mLineListArrow.registerVariableList(this.mSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mLineListArrow.registerVariableList(this.mLineList, SpssArrowButton.ButtonOrientation.left);
        this.mPlotListArrow.registerVariableList(this.mSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mPlotListArrow.registerVariableList(this.mPlotList, SpssArrowButton.ButtonOrientation.left);
        this.mModel = new DefaultListModel();
        this.mTargetList = new PlainList(TARGET_LIST);
        this.mTargetList.setModel(this.mModel);
        this.mTargetList.setDragEnabled(true);
        this.mTargetList.setSerializable(true);
        this.mTargetList.setSelectionMode(0);
        this.mTargetScrollPane = new JScrollPane(this.mTargetList);
        this.mTargetScrollPane.setPreferredSize(new Dimension(this.mTargetList.getMinimumSize().width, 60));
        this.mTargetList.addListSelectionListener(this);
        this.mTargetList.addFocusListener(this);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, ADD_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GLMCommonPlots.this.addAction();
                GLMCommonPlots.this.setEnableStateForMinorControls(GLMCommonPlots.this.mModel.getSize() > 0);
            }
        };
        this.mAddButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, CHANGE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GLMCommonPlots.this.changeAction();
            }
        };
        this.mChangeButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, REMOVE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GLMCommonPlots.this.removeAction();
                GLMCommonPlots.this.setEnableStateForMinorControls(GLMCommonPlots.this.mModel.getSize() > 0);
            }
        };
        this.mRemoveButton = new JButton(toggleButtonAction);
        this.mTargetList.addMouseListener(this);
        this.mSrcList.addMouseListener(this);
        this.mChartTypeGroup = new SpssButtonGroup();
        this.mLineChartTypeRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, LINECHART_RADIO){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GLMCommonPlots.this.onChartTypeRadio();
            }
        });
        this.mBarChartTypeRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, BARCHART_RADIO){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GLMCommonPlots.this.mYAxisStart0Check.setEnabled(!GLMCommonPlots.this.mBarChartTypeRadio.isSelected());
            }
        });
        this.mChartTypeGroup.add(this.mLineChartTypeRadio);
        this.mChartTypeGroup.add(this.mBarChartTypeRadio);
        this.mIncludeErrorBarsCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, ERRORBARS_CHECK){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GLMCommonPlots.this.onIncludeErrorBarsCheck();
            }
        });
        this.mConfidenceIntervalRadio = new JRadioButton(new CIToggleButtonAction(this.mParentDlg, CONFI_INTERVAL_RADIO){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GLMCommonPlots.this.onStandardErrorRadio();
            }
        });
        this.mStandardErrorRadio = new JRadioButton(new ToggleButtonAction(this.mParentDlg, STANDARD_ERROR_RADIO){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GLMCommonPlots.this.onStandardErrorRadio();
            }
        });
        this.mMultiplierLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_REP_MEA_PLOT_MULTIPLIER");
        this.mMultiplierField = new FloatTextField(0.0, Double.NaN, 1, true);
        this.mMultiplierField.setAllowMinMax(false, false);
        this.mMultiplierField.setIncludeMaxRange(false);
        this.mMultiplierField.setIncludeMinRange(false);
        this.mMultiplierField.setAction((Action)new TextFieldAction(this.mParentDlg, MULTIPLIER_FIELD));
        this.mMultiplierLabel.setLabelFor((Component)this.mMultiplierField);
        this.mIncludeGroup = new SpssButtonGroup();
        this.mIncludeGroup.add(this.mConfidenceIntervalRadio);
        this.mIncludeGroup.add(this.mStandardErrorRadio);
        this.mIncludeRefLineForGrandMeanCheck = new JCheckBox(new ToggleButtonAction(this.mParentDlg, MEANREFERENCE_CHECK));
        this.mYAxisStart0Check = new JCheckBox(new ToggleButtonAction(this.mParentDlg, YAXIS_CHECK));
    }

    private boolean canEnableArrowButton(ISpssVariable iSpssVariable, TargetVariableList targetVariableList) {
        boolean bl = true;
        if (iSpssVariable != null && targetVariableList != null && targetVariableList.getModel().getSize() > 0 && iSpssVariable == targetVariableList.getModel().getElementAt(0)) {
            bl = false;
        }
        return bl;
    }

    private void setDefaults(boolean bl) {
        this.mAxisList.getModel().removeAll();
        this.mLineList.getModel().removeAll();
        this.mPlotList.getModel().removeAll();
        this.mAxisListArrow.setEnabled(!this.mSrcList.isSelectionEmpty());
        this.mLineListArrow.setEnabled(!this.mSrcList.isSelectionEmpty());
        this.mPlotListArrow.setEnabled(!this.mSrcList.isSelectionEmpty());
        this.setACRButtonFalse();
        this.mSrcList.requestFocus();
        this.mSrcList.setSelectedIndex(0);
        if (!bl) {
            this.mLineChartTypeRadio.setSelected(true);
            this.mIncludeErrorBarsCheck.setSelected(false);
            this.mConfidenceIntervalRadio.setSelected(true);
            this.mMultiplierField.setText("2");
        }
    }

    private void setupPanel(JPanel jPanel) {
        JPanel jPanel2 = this.setupListPanel();
        JPanel jPanel3 = this.setupButtonPanel();
        JPanel jPanel4 = this.setupPlotPanel();
        UIToolDialogUtil.normalizeButtonWidths((JPanel)jPanel3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, n, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 2, 1, n2, insets);
        JLabel jLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_REP_MEA_PLOTS");
        jLabel.setText(this.getResString("IDS_REP_MEA_PLOTS"));
        jLabel.setLabelFor(this.mTargetList);
        gridBagConstraints.weightx = 0.0;
        n2 = 10;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, n2, DialogUtil.getStandardControlInsets());
        gridBagConstraints.fill = 2;
        n2 = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 1, 1, 1, n2, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 2, 2, 1, n2, insets);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_REP_MEA_PLOT_CHARTTYPE")));
        jPanel5.add(this.mLineChartTypeRadio);
        jPanel5.add(this.mBarChartTypeRadio);
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 0, 3, 2, 1, n2, insets);
        JPanel jPanel6 = this.setupErrorBarsPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel6, gridBagConstraints, 0, 4, 2, 1, n2, insets);
        insets.bottom = 0;
        DialogUtil.addUsingGBL(jPanel, this.mIncludeRefLineForGrandMeanCheck, gridBagConstraints, 0, 5, 2, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mYAxisStart0Check, gridBagConstraints, 0, 6, 2, 1, n2, null);
    }

    private JPanel setupErrorBarsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_REP_MEA_PLOT_ERRORBARS")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mIncludeErrorBarsCheck, gridBagConstraints, 0, 0, 3, 1, n, insets);
        insets.left += 15;
        DialogUtil.addUsingGBL(jPanel, this.mConfidenceIntervalRadio, gridBagConstraints, 0, 1, 3, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mStandardErrorRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        insets.left += 5;
        DialogUtil.addUsingGBL(jPanel, this.mMultiplierLabel, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.left = 3;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMultiplierField, gridBagConstraints, 2, 2, 1, 1, n, insets);
        return jPanel;
    }

    private void addAction() {
        String string = "";
        if (this.mAxisList.getModel().getSize() > 0) {
            string = string + this.mAxisList.getModel().getElementAt(0).getName();
            this.mAxisList.getModel().removeAll();
        }
        if (this.mLineList.getModel().getSize() > 0) {
            string = string + "*" + this.mLineList.getModel().getElementAt(0).getName();
            this.mLineList.getModel().removeAll();
        }
        if (this.mPlotList.getModel().getSize() > 0) {
            string = string + "*" + this.mPlotList.getModel().getElementAt(0).getName();
            this.mPlotList.getModel().removeAll();
        }
        if (!this.mModel.contains(string)) {
            this.mModel.addElement(string);
            this.mTargetList.removeListSelectionListener(this);
            ListSelectionModel listSelectionModel = this.mTargetList.getSelectionModel();
            int n = this.mTargetList.getModel().getSize() - 1;
            listSelectionModel.setAnchorSelectionIndex(n);
            listSelectionModel.setLeadSelectionIndex(n);
            listSelectionModel.clearSelection();
            this.mTargetList.addListSelectionListener(this);
        }
        this.setACRButtonFalse();
        this.mAxisListArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mLineListArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mPlotListArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
    }

    private void callToEnableArrowButton() {
        ISpssVariable iSpssVariable = (ISpssVariable)this.mSrcList.getSelectedValue();
        if (!(!this.mSrcList.isFocusOwner() || this.canEnableArrowButton(iSpssVariable, this.mAxisList) && this.canEnableArrowButton(iSpssVariable, this.mLineList) && this.canEnableArrowButton(iSpssVariable, this.mPlotList))) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GLMCommonPlots.this.mAxisListArrow.setEnabled(false);
                    GLMCommonPlots.this.mLineListArrow.setEnabled(false);
                    GLMCommonPlots.this.mPlotListArrow.setEnabled(false);
                }
            });
        } else if (this.mSrcList != null && this.mSrcList.getModel().getSize() == 0) {
            this.mAxisListArrow.setEnabled(false);
            this.mLineListArrow.setEnabled(false);
            this.mPlotListArrow.setEnabled(false);
        } else {
            this.mAxisListArrow.setEnabled(this.mAxisList.getModel().getSize() == 0);
            this.mLineListArrow.setEnabled(this.mLineList.getModel().getSize() == 0);
            this.mPlotListArrow.setEnabled(this.mPlotList.getModel().getSize() == 0);
        }
    }

    private void canEnableACRButton() {
        this.mRemoveButton.setEnabled(true);
        if (this.mTargetList.getSelectedValue() != null) {
            this.mAxisList.getModel().removeAll();
            this.mLineList.getModel().removeAll();
            this.mPlotList.getModel().removeAll();
            String string = this.mTargetList.getSelectedValue().toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "*");
            int n = stringTokenizer.countTokens();
            switch (n) {
                case 1: {
                    String string2 = stringTokenizer.nextToken();
                    this.mAxisList.getModel().addElement(this.getVariableFromSrcList(string2));
                    this.mAxisList.setSelectedIndex(0);
                    this.mAxisListArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
                    break;
                }
                case 2: {
                    String string3 = stringTokenizer.nextToken();
                    this.mAxisList.getModel().addElement(this.getVariableFromSrcList(string3));
                    string3 = stringTokenizer.nextToken();
                    this.mLineList.getModel().addElement(this.getVariableFromSrcList(string3));
                    this.mLineList.setSelectedIndex(0);
                    this.mLineListArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
                    break;
                }
                case 3: {
                    String string4 = stringTokenizer.nextToken();
                    this.mAxisList.getModel().addElement(this.getVariableFromSrcList(string4));
                    string4 = stringTokenizer.nextToken();
                    this.mLineList.getModel().addElement(this.getVariableFromSrcList(string4));
                    string4 = stringTokenizer.nextToken();
                    this.mPlotList.getModel().addElement(this.getVariableFromSrcList(string4));
                    this.mPlotList.setSelectedIndex(0);
                    this.mPlotListArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
                }
            }
            this.mAddButton.setEnabled(false);
        }
        this.mChangeButton.setEnabled(false);
        this.mRemoveButton.setEnabled(this.mTargetList.getSelectedIndex() != -1);
    }

    private ISpssVariable getVariableFromSrcList(String string) {
        VarListModel varListModel = this.mSrcList.getModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            ISpssVariable iSpssVariable = varListModel.getElementAt(i);
            if (!iSpssVariable.getName().equals(string)) continue;
            return iSpssVariable;
        }
        return null;
    }

    private void setACRButtonFalse() {
        this.mAddButton.setEnabled(false);
        this.mChangeButton.setEnabled(false);
        this.mRemoveButton.setEnabled(false);
    }

    private void changeAction() {
        this.mModel.remove(this.mTargetList.getSelectedIndex());
        this.addAction();
        this.mAxisList.getModel().removeAll();
        this.mLineList.getModel().removeAll();
        this.mPlotList.getModel().removeAll();
        this.mChangeButton.setEnabled(false);
        this.mAxisListArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mLineListArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mPlotListArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mRemoveButton.setEnabled(false);
    }

    private void removeAction() {
        this.mAxisList.getModel().removeAll();
        this.mLineList.getModel().removeAll();
        this.mPlotList.getModel().removeAll();
        this.mModel.removeElementAt(this.mTargetList.getSelectedIndex());
        this.mTargetList.repaint();
        this.mAxisListArrow.setEnabled(true);
        this.mLineListArrow.setEnabled(true);
        this.mPlotListArrow.setEnabled(true);
        this.setACRButtonFalse();
    }

    private void updateAdd() {
        if (this.mPlotList.getModel().getSize() > 0) {
            boolean bl = this.mLineList.getModel().getSize() > 0 && this.mAxisList.getModel().getSize() > 0;
            this.mAddButton.setEnabled(bl);
            this.mChangeButton.setEnabled(this.mTargetList.getSelectedIndex() != -1 && bl);
            this.mRemoveButton.setEnabled(this.mTargetList.getSelectedIndex() != -1 && !bl);
        } else if (this.mLineList.getModel().getSize() > 0) {
            boolean bl = this.mAxisList.getModel().getSize() > 0;
            this.mAddButton.setEnabled(bl);
            this.mChangeButton.setEnabled(this.mTargetList.getSelectedIndex() != -1 && bl);
            this.mRemoveButton.setEnabled(this.mTargetList.getSelectedIndex() != -1 && !bl);
        } else if (this.mAxisList.getModel().getSize() > 0) {
            this.mAddButton.setEnabled(true);
            this.mChangeButton.setEnabled(this.mTargetList.getSelectedIndex() != -1);
            this.mRemoveButton.setEnabled(false);
        } else {
            this.setACRButtonFalse();
        }
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcList);
        vector.add(this.mAxisListArrow);
        if (this.mAxisList.getModel().getSize() > 0) {
            vector.add(this.mAxisList);
        }
        vector.add(this.mLineListArrow);
        if (this.mLineList.getModel().getSize() > 0) {
            vector.add(this.mLineList);
        }
        vector.add(this.mPlotListArrow);
        if (this.mPlotList.getModel().getSize() > 0) {
            vector.add(this.mPlotList);
        }
        vector.add(this.mAddButton);
        vector.add(this.mChangeButton);
        vector.add(this.mRemoveButton);
        vector.add(this.mTargetList);
        vector.add(this.mChartTypeGroup);
        vector.add(this.mIncludeErrorBarsCheck);
        vector.add(this.mIncludeGroup);
        vector.add(this.mMultiplierField);
        vector.add(this.mIncludeRefLineForGrandMeanCheck);
        vector.add(this.mYAxisStart0Check);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private boolean showInfoDialog(String string) {
        int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
        return n == 0;
    }

    private void setFactorListModel() {
        ISpssVariable iSpssVariable;
        int n;
        VarListModel varListModel = this.mSrcList.getModel();
        if (this.mFixFactorVars != null) {
            for (n = 0; n < this.mFixFactorVars.getSize(); ++n) {
                iSpssVariable = this.mFixFactorVars.getElementAt(n);
                if (this.hasItem(iSpssVariable)) continue;
                varListModel.addElement(iSpssVariable);
            }
        }
        if (this.mRandFactorVars != null) {
            for (n = 0; n < this.mRandFactorVars.getSize(); ++n) {
                iSpssVariable = this.mRandFactorVars.getElementAt(n);
                if (this.hasItem(iSpssVariable)) continue;
                varListModel.addElement(iSpssVariable);
            }
        }
        if (this.mRepMeasuresFactors != null && this.mRepMeasuresFactors.size() > 0) {
            for (String string : this.mRepMeasuresFactors) {
                iSpssVariable = new SpssVariable();
                iSpssVariable.setName(string);
                if (this.hasItemWithName(iSpssVariable)) continue;
                varListModel.addElement(iSpssVariable);
            }
        }
    }

    private boolean hasItem(ISpssVariable iSpssVariable) {
        boolean bl = false;
        VarListModel varListModel = this.mSrcList.getModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            ISpssVariable iSpssVariable2 = varListModel.getElementAt(i);
            if (iSpssVariable != iSpssVariable2) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean hasItemWithName(ISpssVariable iSpssVariable) {
        boolean bl = false;
        VarListModel varListModel = this.mSrcList.getModel();
        for (int i = 0; i < varListModel.getSize(); ++i) {
            ISpssVariable iSpssVariable2 = varListModel.getElementAt(i);
            if (!iSpssVariable2.getName().equals(iSpssVariable.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private JPanel setupPlotPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTargetScrollPane, gridBagConstraints, 1, 0, 2, 1, n, null);
        return jPanel;
    }

    private JPanel setupListPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_REP_MEA_PLOT_FACTOR");
        jLabel.setLabelFor(this.mSrcList);
        JLabel jLabel2 = DialogUtil.createLabel(this.mParentDlg, "IDS_REP_MEA_PLOT_HORIZONTAL_AXIS");
        jLabel2.setLabelFor(this.mAxisList);
        JLabel jLabel3 = DialogUtil.createLabel(this.mParentDlg, "IDS_REP_MEA_PLOT_SEPARATE_LINES");
        jLabel3.setLabelFor(this.mLineList);
        JLabel jLabel4 = DialogUtil.createLabel(this.mParentDlg, "IDS_REP_MEA_PLOT_SEPARATE_PLOTS");
        jLabel4.setLabelFor(this.mPlotList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap() + 4, 0, 0, 0);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 2, 1, n, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 5, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = new Insets(0, DialogUtil.getArrowButtonInsets().left, 0, DialogUtil.getArrowButtonInsets().right);
        n = 20;
        DialogUtil.addUsingGBL(jPanel, this.mAxisListArrow, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.mAxisListScroll, gridBagConstraints, 2, 1, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 20;
        DialogUtil.addUsingGBL(jPanel, this.mLineListArrow, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mLineListScroll, gridBagConstraints, 2, 3, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 20;
        insets2.set(0, insets2.left, 0, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.mPlotListArrow, gridBagConstraints, 1, 5, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 2, 4, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mPlotListScroll, gridBagConstraints, 2, 5, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setupButtonPanel() {
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 10;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mAddButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mChangeButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mRemoveButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void onIncludeErrorBarsCheck() {
        boolean bl = this.mIncludeErrorBarsCheck.isEnabled() && this.mIncludeErrorBarsCheck.isSelected();
        this.mConfidenceIntervalRadio.setEnabled(bl);
        this.mStandardErrorRadio.setEnabled(bl);
        this.onStandardErrorRadio();
    }

    private void onStandardErrorRadio() {
        boolean bl = this.mStandardErrorRadio.isEnabled() && this.mStandardErrorRadio.isSelected();
        this.mMultiplierLabel.setEnabled(bl);
        this.mMultiplierField.setEnabled(bl);
    }

    private void onChartTypeRadio() {
        if (this.mBarChartTypeRadio.isEnabled()) {
            this.mYAxisStart0Check.setEnabled(!this.mBarChartTypeRadio.isSelected());
        }
    }

    private void addDragAdapters(DragPane dragPane, Component component, IVarMoveHandler iVarMoveHandler) {
        if (component instanceof VariableList) {
            VariableList variableList = (VariableList)component;
            ListDragAdapter listDragAdapter = new ListDragAdapter(variableList, dragPane, "VariableList");
            DialogUtil.modifyMouseInputListeners(variableList, listDragAdapter);
            dragPane.addDropListener((IDropListener)new GLMCommanPlotsDropListener(variableList, iVarMoveHandler));
        } else if (component instanceof Container) {
            Container container = (Container)component;
            for (Component component2 : container.getComponents()) {
                this.addDragAdapters(dragPane, component2, iVarMoveHandler);
            }
        }
    }

    private String getFormattedConfidenceInterval(String string) {
        String string2;
        if (string == null) {
            string = "0.05";
        }
        if (string.length() > 0 && !string.equals(".")) {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(UIToolResUtil.getSPSSLocale());
            Double d = 100.0 - Double.parseDouble(string) * 100.0;
            string2 = d > 0.0 ? d.toString().replace('.', decimalFormatSymbols.getDecimalSeparator()) : Character.toString(decimalFormatSymbols.getDecimalSeparator());
        } else {
            string2 = "100";
        }
        return string2;
    }

    private void setEnableStateForMinorControls(boolean bl) {
        this.mLineChartTypeRadio.setEnabled(bl);
        this.mBarChartTypeRadio.setEnabled(bl);
        this.mIncludeErrorBarsCheck.setEnabled(bl);
        this.mIncludeRefLineForGrandMeanCheck.setEnabled(bl);
        this.mYAxisStart0Check.setEnabled(bl);
        this.onChartTypeRadio();
        this.onIncludeErrorBarsCheck();
        this.onStandardErrorRadio();
    }

    class CIToggleButtonAction
    extends ToggleButtonAction {
        public CIToggleButtonAction(BaseDialog baseDialog, String string) {
            super(baseDialog, string);
            if (baseDialog instanceof BaseProcedureDialog) {
                String string2 = ((BaseProcedureDialog)baseDialog).getDialogDataModel().getString("IDS_SIGNIFICANCE_LEVEL_EDIT");
                String string3 = GLMCommonPlots.this.getFormattedConfidenceInterval(string2);
                String string4 = MessageFormat.format(GLMCommonPlots.this.getResString(string), string3);
                this.putValue("Name", string4);
                String string5 = GLMCommonPlots.this.getResString("IDS_REP_MEA_PLOT_CONFI_INTERVA_TOOLTIP");
                this.putValue("ShortDescription", string5);
            }
        }
    }

    private class GLMCommanPlotsDropListener
    extends VarListDropListener {
        public GLMCommanPlotsDropListener(VariableList variableList) {
            super(variableList);
        }

        public GLMCommanPlotsDropListener(VariableList variableList, IVarMoveHandler iVarMoveHandler) {
            super(variableList, iVarMoveHandler);
        }

        @Override
        public boolean canDrop(DragDropAdapter dragDropAdapter) {
            boolean bl = false;
            if (!(this.mDropTarget.isEnabled() && this.mDropTarget.isShowing() && this.mDropTarget.isDragSupported())) {
                return bl;
            }
            Object object = dragDropAdapter.getTransferData();
            if (object instanceof VariableList.TransferData) {
                VariableList.TransferData transferData = (VariableList.TransferData)object;
                ISpssVariable[] iSpssVariableArray = transferData.getVariables();
                if (GLMCommonPlots.this.isSourceSrcList) {
                    if (GLMCommonPlots.this.mAxisList.getModel().getSize() > 0 && iSpssVariableArray[0] == GLMCommonPlots.this.mAxisList.getModel().getElementAt(0)) {
                        return false;
                    }
                    if (GLMCommonPlots.this.mLineList.getModel().getSize() > 0 && iSpssVariableArray[0] == GLMCommonPlots.this.mLineList.getModel().getElementAt(0)) {
                        return false;
                    }
                    if (GLMCommonPlots.this.mPlotList.getModel().getSize() > 0 && iSpssVariableArray[0] == GLMCommonPlots.this.mPlotList.getModel().getElementAt(0)) {
                        return false;
                    }
                    bl = true;
                } else {
                    bl = true;
                }
            }
            return bl;
        }
    }
}

