/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats;

import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.adv_stats.AuxRegressionBrschDlg;
import com.spss.java_client.ui.dialogs.adv_stats.AuxRegressionFtestDlg;
import com.spss.java_client.ui.dialogs.adv_stats.AuxRegressionModBrschDlg;
import com.spss.java_client.ui.dialogs.adv_stats.UnivariateDlg;
import com.spss.java_client.ui.dialogs.adv_stats.multivariate.MultivariateDlg;
import com.spss.java_client.ui.dialogs.adv_stats.rep_measures.RepeatedMeasureDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormatSymbols;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class GLMCommonOptions
extends BaseSubDialog
implements ItemListener,
DocumentListener {
    public static final String SIGNIFICANCE_LEVEL = "IDS_SIGNIFICANCE_LEVEL_EDIT";
    public static final String CONFI_LEVEL_LABEL = "IDS_GLM_CONFIDENCE_INTERVAL";
    public static final String SSCP_MAT = "IDS_MULTIVARIATE_SSCP_MATRICES";
    public static final String GEN_EST_FUN = "IDS_GENERAL_ESTIMABLE_FUNCTION";
    public static final String LACK_OF_FIT = "IDS_LACK_OF_FIT";
    public static final String RESIDUAL_PLOT = "IDS_RESIDUAL_PLOT";
    public static final String SPREAD_VS_LEVEL = "IDS_SPREAD_VS_LEVEL_PLOT";
    public static final String HOMOGEN_TESTS = "IDS_HOMOGENEITY_TESTS";
    public static final String CONTRAST_MAT = "IDS_CONTRACT_COEFFICIENT_MATRIX";
    public static final String PARAM_EST = "IDS_UNIVARIATE_PARAMETER_ESTIMATES";
    public static final String OBSERVED_POWER = "IDS_OBSERVED_POWER";
    public static final String EST_EFFECT_SIZE = "IDS_ESTIMATE_OF_EFFECT_SIZE";
    public static final String DESC_STATS = "IDS_DISCRIPTIVE_STATITICS";
    public static final String RESIDUAL_SSCP_MAT = "IDS_MULTIVARIATE_RESIDUAL_SSCP_MAT";
    public static final String TRANSFORM_MAT = "IDS_MULTIVARIATE_TRANSFORM_MATRIX";
    private JLabel mConfiPercentLabel;
    private JCheckBox mHomogenTest;
    private JCheckBox mCoefficientMatrix;
    private JCheckBox mDescStats;
    private JCheckBox mEstEffectSize;
    private JCheckBox mObsPower;
    private JCheckBox mSprVsLevel;
    private JCheckBox mResSscpMat;
    private JCheckBox mResPlot;
    private JCheckBox mLackOfFit;
    private JCheckBox mGeneralFun;
    private JCheckBox mParamEst;
    private JCheckBox mSscpMat;
    private JCheckBox mTransformMat;
    private FloatTextField mSigLevel;
    private JPanel mDisplayPanel;
    private JPanel robustStdErrPanel;
    private JSeparator mSeparator;
    private JCheckBox mParamEstRobStdErr;
    public static final String PARAM_EST_ROB_STD_ERR = "IDS_UNIVARIATE_PARAMETER_ESTIMATES_WITH_ROBUST_STANDARD_ERROR";
    private SpssButtonGroup mRadioButtonGroup;
    private JRadioButton mHC0;
    private JRadioButton mHC1;
    private JRadioButton mHC2;
    private JRadioButton mHC3;
    private JRadioButton mHC4;
    public static final String HC0 = "IDS_UNIVARIATE_PARAMETER_ESTIMATES_WITH_ROBUST_STANDARD_ERROR_HC0";
    public static final String HC1 = "IDS_UNIVARIATE_PARAMETER_ESTIMATES_WITH_ROBUST_STANDARD_ERROR_HC1";
    public static final String HC2 = "IDS_UNIVARIATE_PARAMETER_ESTIMATES_WITH_ROBUST_STANDARD_ERROR_HC2";
    public static final String HC3 = "IDS_UNIVARIATE_PARAMETER_ESTIMATES_WITH_ROBUST_STANDARD_ERROR_HC3";
    public static final String HC4 = "IDS_UNIVARIATE_PARAMETER_ESTIMATES_WITH_ROBUST_STANDARD_ERROR_HC4";
    private JPanel mHeteroTestsPanel;
    private JCheckBox mModBruschPagan;
    private JCheckBox mFTest;
    private JCheckBox mBruschPagan;
    private JCheckBox mWhiteTest;
    private JButton mModel1;
    private JButton mModel2;
    private JButton mModel3;
    public static final String HETEROTEST = "IDS_HETEROTEST";
    public static final String MODIFIED_BREUSCH_PAGAN_TEST = "IDS_MODIFIED_BREUSCH_PAGAN_TEST";
    public static final String F_TEST = "IDS_F_TEST";
    public static final String BREUSCH_PAGAN_TEST = "IDS_BREUSCH_PAGAN_TEST";
    public static final String WHITE_TEST = "IDS_WHITE_TEST";
    public static final String MODELBTN = "IDS_MODELBTN";

    public GLMCommonOptions(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, "", true);
        String string = "";
        string = baseProcedureDialog instanceof UnivariateDlg ? baseProcedureDialog.getResString("IDS_UNIVARIATE_OPTIONS_TITLE") : (baseProcedureDialog instanceof MultivariateDlg ? baseProcedureDialog.getResString("IDS_MULTIVARIATE_OPTIONS_TITLE") : baseProcedureDialog.getResString("IDS_REP_MEA_OPTIONS_TITLE"));
        this.setTitle(string);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.mHC0.setEnabled(this.mParamEstRobStdErr.isSelected());
        this.mHC1.setEnabled(this.mParamEstRobStdErr.isSelected());
        this.mHC2.setEnabled(this.mParamEstRobStdErr.isSelected());
        this.mHC3.setEnabled(this.mParamEstRobStdErr.isSelected());
        this.mHC4.setEnabled(this.mParamEstRobStdErr.isSelected());
        DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
        if (!this.mParamEstRobStdErr.isSelected()) {
            dialogDataModel.putBoolean("IDS_CREATE_COEFFICIENT_STATS", this.mParamEstRobStdErr.isSelected());
        }
        this.mParentDlg.setDialogDataModel(dialogDataModel);
        if (dialogDataModel.getBoolean("IDS_COMMON_BOOTSTRAP_PERFORM_BOOTSTRAP") != null && dialogDataModel.getBoolean("IDS_COMMON_BOOTSTRAP_PERFORM_BOOTSTRAP").booleanValue()) {
            this.mModBruschPagan.setSelected(false);
            this.mBruschPagan.setSelected(false);
            this.mFTest.setSelected(false);
            this.mWhiteTest.setSelected(false);
        }
        this.mModel1.setEnabled(this.mModBruschPagan.isSelected());
        this.mModel2.setEnabled(this.mBruschPagan.isSelected());
        this.mModel3.setEnabled(this.mFTest.isSelected());
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.formateConfidencePercentage();
        this.enableContinue(this.mSigLevel.getText().length() > 0);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.formateConfidencePercentage();
        this.enableContinue(this.mSigLevel.getText().length() > 0);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.formateConfidencePercentage();
        this.enableContinue(this.mSigLevel.getText().length() > 0);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_glmu_opt";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.robustStdErrPanel = this.setupRobustStandarErrorPanel();
        this.mHeteroTestsPanel = this.setupHeteroTestsPanel();
        JPanel jPanel = this.getViewPanel();
        this.mDisplayPanel = this.setupDisplayPanel();
        JPanel jPanel2 = this.setupSigLevelPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, n, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = 23;
        insets = new Insets(0, 0, n, 0);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.createButtonGroup(this.mDisplayPanel);
        DialogUtil.addUsingGBL(jPanel, this.mDisplayPanel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n2, null);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        Vector<String> vector = this.mParentDlg instanceof UnivariateDlg ? ((UnivariateDlg)this.mParentDlg).getFactorCombinations() : (this.mParentDlg instanceof MultivariateDlg ? ((MultivariateDlg)this.mParentDlg).getFactorCombinations() : ((RepeatedMeasureDlg)this.mParentDlg).getFactorCombinations("OPTIONS"));
        if (vector != null) {
            this.mHomogenTest.setEnabled(true);
            this.mSprVsLevel.setEnabled(true);
        }
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, HOMOGEN_TESTS);
        this.mHomogenTest = new JCheckBox(toggleButtonAction);
        this.mHomogenTest.setEnabled(false);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, SPREAD_VS_LEVEL);
        this.mSprVsLevel = new JCheckBox(toggleButtonAction);
        this.mSprVsLevel.setEnabled(false);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, DESC_STATS);
        this.mDescStats = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, EST_EFFECT_SIZE);
        this.mEstEffectSize = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, OBSERVED_POWER);
        this.mObsPower = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, PARAM_EST);
        this.mParamEst = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, SSCP_MAT);
        this.mSscpMat = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, RESIDUAL_SSCP_MAT);
        this.mResSscpMat = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, CONTRAST_MAT);
        this.mCoefficientMatrix = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, TRANSFORM_MAT);
        this.mTransformMat = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, RESIDUAL_PLOT);
        this.mResPlot = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, LACK_OF_FIT);
        this.mLackOfFit = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, GEN_EST_FUN);
        this.mGeneralFun = new JCheckBox(toggleButtonAction);
        this.mConfiPercentLabel = new JLabel();
        this.mConfiPercentLabel.setText("95");
        this.mSigLevel = new FloatTextField(1.0E-7, 0.9999999, 7, true);
        this.mSigLevel.setAction((Action)new TextFieldAction(this.mParentDlg, SIGNIFICANCE_LEVEL));
        this.mSigLevel.setPreferredSize(new Dimension(50, 20));
        this.mSigLevel.setDocument((Document)new FixedLengthNumericDocument(8, true, true));
        this.mSigLevel.getDocument().addDocumentListener(this);
        this.mSigLevel.setText(".05");
        this.mSeparator = new JSeparator();
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, PARAM_EST_ROB_STD_ERR);
        this.mParamEstRobStdErr = new JCheckBox(toggleButtonAction);
        this.mParamEstRobStdErr.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, HC0);
        this.mHC0 = new JRadioButton(toggleButtonAction);
        this.mHC0.setEnabled(false);
        this.mHC0.setSelected(false);
        this.mHC0.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, HC1);
        this.mHC1 = new JRadioButton(toggleButtonAction);
        this.mHC1.setEnabled(false);
        this.mHC1.setSelected(false);
        this.mHC1.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, HC2);
        this.mHC2 = new JRadioButton(toggleButtonAction);
        this.mHC2.setEnabled(false);
        this.mHC2.setSelected(false);
        this.mHC2.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, HC3);
        this.mHC3 = new JRadioButton(toggleButtonAction);
        this.mHC3.setEnabled(false);
        this.mHC3.setSelected(true);
        this.mHC3.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, HC4);
        this.mHC4 = new JRadioButton(toggleButtonAction);
        this.mHC4.setEnabled(false);
        this.mHC4.setSelected(false);
        this.mHC4.addItemListener(this);
        this.mRadioButtonGroup = new SpssButtonGroup();
        this.mRadioButtonGroup.add(this.mHC0);
        this.mRadioButtonGroup.add(this.mHC1);
        this.mRadioButtonGroup.add(this.mHC2);
        this.mRadioButtonGroup.add(this.mHC3);
        this.mRadioButtonGroup.add(this.mHC4);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, MODIFIED_BREUSCH_PAGAN_TEST);
        this.mModBruschPagan = new JCheckBox(toggleButtonAction);
        this.mModBruschPagan.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, F_TEST);
        this.mFTest = new JCheckBox(toggleButtonAction);
        this.mFTest.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, BREUSCH_PAGAN_TEST);
        this.mBruschPagan = new JCheckBox(toggleButtonAction);
        this.mBruschPagan.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, WHITE_TEST);
        this.mWhiteTest = new JCheckBox(toggleButtonAction);
        this.mWhiteTest.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, MODELBTN){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AuxRegressionModBrschDlg auxRegressionModBrschDlg = new AuxRegressionModBrschDlg(GLMCommonOptions.this.mParentDlg);
                ((Dialog)((Object)auxRegressionModBrschDlg)).setVisible(true);
            }
        };
        this.mModel1 = new JButton(toggleButtonAction);
        this.mModel1.setEnabled(false);
        this.mModel1.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, MODELBTN){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AuxRegressionBrschDlg auxRegressionBrschDlg = new AuxRegressionBrschDlg(GLMCommonOptions.this.mParentDlg);
                ((Dialog)((Object)auxRegressionBrschDlg)).setVisible(true);
            }
        };
        this.mModel2 = new JButton(toggleButtonAction);
        this.mModel2.setEnabled(false);
        this.mModel2.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, MODELBTN){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AuxRegressionFtestDlg auxRegressionFtestDlg = new AuxRegressionFtestDlg(GLMCommonOptions.this.mParentDlg);
                ((Dialog)((Object)auxRegressionFtestDlg)).setVisible(true);
            }
        };
        this.mModel3 = new JButton(toggleButtonAction);
        this.mModel3.setEnabled(false);
        this.mModel3.addItemListener(this);
        DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
        if (dialogDataModel.getBoolean("IDS_COMMON_BOOTSTRAP_PERFORM_BOOTSTRAP") != null) {
            this.mModBruschPagan.setEnabled(dialogDataModel.getBoolean("IDS_COMMON_BOOTSTRAP_PERFORM_BOOTSTRAP") == false);
            this.mBruschPagan.setEnabled(dialogDataModel.getBoolean("IDS_COMMON_BOOTSTRAP_PERFORM_BOOTSTRAP") == false);
            this.mFTest.setEnabled(dialogDataModel.getBoolean("IDS_COMMON_BOOTSTRAP_PERFORM_BOOTSTRAP") == false);
            this.mWhiteTest.setEnabled(dialogDataModel.getBoolean("IDS_COMMON_BOOTSTRAP_PERFORM_BOOTSTRAP") == false);
        }
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        int n2 = this.mDisplayPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            vector.add(this.mDisplayPanel.getComponent(n));
        }
        n2 = this.mHeteroTestsPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            vector.add(this.mHeteroTestsPanel.getComponent(n));
        }
        vector.add(this.mParamEstRobStdErr);
        vector.add(this.mRadioButtonGroup);
        vector.add(this.mSigLevel);
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private JPanel setupDisplayPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        int n3 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, n2, 0, 0);
        if (this.mParentDlg instanceof UnivariateDlg) {
            JComponent[] jComponentArray = new JComponent[]{this.mDescStats, this.mEstEffectSize, this.mObsPower, this.mParamEst, this.mCoefficientMatrix, this.mHomogenTest, this.mSprVsLevel, this.mResPlot, this.mLackOfFit, this.mGeneralFun};
            jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_REP_MEA_OPT_DISPLAY"), 5, false, 25);
            DialogUtil.addUsingGBL(jPanel, this.mHeteroTestsPanel, gridBagConstraints, 0, 6, 2, 1, n, null);
            DialogUtil.addUsingGBL(jPanel, this.robustStdErrPanel, gridBagConstraints, 0, 7, 2, 1, n, null);
        } else {
            JComponent[] jComponentArray = new JComponent[]{this.mDescStats, this.mEstEffectSize, this.mObsPower, this.mParamEst, this.mSscpMat, this.mResSscpMat, this.mTransformMat, this.mHomogenTest, this.mSprVsLevel, this.mResPlot, this.mLackOfFit, this.mGeneralFun};
            jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_REP_MEA_OPT_DISPLAY"), 6, false, 25);
        }
        return jPanel;
    }

    private JPanel setupHeteroTestsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        JComponent[] jComponentArray = new JComponent[]{this.mModBruschPagan, this.mModel1, this.mBruschPagan, this.mModel2, this.mFTest, this.mModel3, this.mWhiteTest};
        jPanel = PanelFactory.getGridPanel(jComponentArray, this.getResString(HETEROTEST), 4, false, 25);
        return jPanel;
    }

    private JPanel setupSigLevelPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_SIGNIFICANCE_LEVEL_EDIT_LABEL");
        jLabel.setLabelFor((Component)this.mSigLevel);
        JLabel jLabel2 = new JLabel(this.getResString(CONFI_LEVEL_LABEL));
        JLabel jLabel3 = new JLabel(this.getResString("IDS_CONFIDENCE_INTERVAL_PERCENT_SIGN"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 10;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        n = 23;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mSigLevel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        n = 10;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mConfiPercentLabel, gridBagConstraints, 3, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 4, 0, 1, 1, n, null);
        return jPanel;
    }

    private void formateConfidencePercentage() {
        if (!this.mSigLevel.getText().equals("") && !this.mSigLevel.getText().equals(".")) {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(UIToolResUtil.getSPSSLocale());
            Double d = new Double(100.0 - Double.parseDouble(this.mSigLevel.getText()) * 100.0);
            if (d > 0.0) {
                this.mConfiPercentLabel.setText(d.toString().replace('.', decimalFormatSymbols.getDecimalSeparator()));
            } else {
                this.mConfiPercentLabel.setText(Character.toString(decimalFormatSymbols.getDecimalSeparator()));
            }
        } else {
            this.mConfiPercentLabel.setText("100");
        }
    }

    private JPanel setupRobustStandarErrorPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        int n3 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getArrowButtonInsets();
        Insets insets2 = DialogUtil.getStandardControlInsets();
        Insets insets3 = new Insets(insets2.top, insets2.left + 10, insets2.bottom, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.mSeparator, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mParamEstRobStdErr, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mHC0, gridBagConstraints, 0, 2, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mHC1, gridBagConstraints, 0, 3, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mHC2, gridBagConstraints, 0, 4, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mHC3, gridBagConstraints, 0, 5, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mHC4, gridBagConstraints, 0, 6, 1, 1, n, insets3);
        return jPanel;
    }
}

