/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats;

import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.PlainListArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.drag_drop.PlainListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PlainListDropListener;
import com.spss.java_client.ui.dialogs.adv_stats.UnivariateDlg;
import com.spss.java_client.ui.dialogs.adv_stats.multivariate.MultivariateDlg;
import com.spss.java_client.ui.dialogs.adv_stats.rep_measures.RepeatedMeasureDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class GLMCommonEMMeans
extends BaseSubDialog
implements ListDataListener,
ItemListener {
    public static final String OVERALL = "(OVERALL)";
    public static final String OPTIONS_SOURCE_LIST = "IDS_OPTIONS_SRC_LIST";
    public static final String OPTIONS_TARGET_LIST = "IDS_OPTIONS_TARGET_LIST";
    public static final String COMPARE_MAIN_EFFECT = "IDS_GLM_COMPARE_MAIN_EFFECTS";
    public static final String CONFI_INTERVAL = "IDS_CONFIDENCE_INTERVAL_COMBO";
    static final String OPTIONS = "OPTIONS";
    private PlainList mSrcList;
    private JScrollPane mSrcScrollPane;
    private PlainList mTargetList;
    private JScrollPane mTargetScrollPane;
    private PlainListArrowButton mArrowButton;
    private JCheckBox mCompMainEffect;
    private JLabel mConfiIntervalLabel;
    private JComboBox mConfiInterval;

    public GLMCommonEMMeans(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, "", true);
        String string = "";
        string = baseProcedureDialog instanceof UnivariateDlg ? baseProcedureDialog.getResString("IDS_UNIVARIATE_EMMEANS_TITLE") : (baseProcedureDialog instanceof MultivariateDlg ? baseProcedureDialog.getResString("IDS_MULTIVARIATE_EMMEANS_TITLE") : baseProcedureDialog.getResString("IDS_REP_MEA_EMMEANS_TITLE"));
        this.setTitle(string);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_glm_emmeans";
    }

    @Override
    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            this.addDragAdapters();
        }
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        ((DefaultListModel)this.mSrcList.getModel()).removeAllElements();
        this.mSrcList.setModel(this.getSrcListModel());
        this.mSrcList.setSelectedIndex(0);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.mCompMainEffect.setEnabled(this.canCompareMainEffectEnabled());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        boolean bl = this.canCompareMainEffectEnabled();
        if (!bl) {
            this.mCompMainEffect.setSelected(false);
            this.mConfiInterval.setSelectedIndex(0);
        }
        this.mCompMainEffect.setEnabled(bl);
    }

    public boolean canCompareMainEffectEnabled() {
        boolean bl = false;
        for (int i = 0; i < this.mTargetList.getModel().getSize(); ++i) {
            String string = this.mTargetList.getModel().getElementAt(i).toString();
            if (string.equals(OVERALL) || string.contains("*")) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.mCompMainEffect.setEnabled(this.canCompareMainEffectEnabled());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.mConfiIntervalLabel.setEnabled(this.mCompMainEffect.isSelected());
        this.mConfiInterval.setEnabled(this.mCompMainEffect.isSelected());
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupMeanPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, n, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    private void initVars() {
        this.mSrcList = new PlainList(OPTIONS_SOURCE_LIST, PlainList.DragType.eAutoDragCopy);
        this.mSrcList.setDataSource(true);
        this.mSrcScrollPane = new JScrollPane(this.mSrcList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcList.getMinimumSize());
        this.mSrcList.getModel().addListDataListener(this);
        this.mTargetList = new PlainList(OPTIONS_TARGET_LIST, PlainList.DragType.eAutoDragCopy);
        this.mTargetScrollPane = new JScrollPane(this.mTargetList);
        Dimension dimension = this.mTargetList.getMinimumSize();
        dimension.height = 40;
        this.mTargetScrollPane.setPreferredSize(dimension);
        this.mTargetList.getModel().addListDataListener(this);
        this.mArrowButton = new PlainListArrowButton(SpssArrowButton.ButtonOrientation.right);
        ControlAction controlAction = new ToggleButtonAction(this.mParentDlg, COMPARE_MAIN_EFFECT);
        this.mCompMainEffect = new JCheckBox(controlAction);
        this.mCompMainEffect.setEnabled(false);
        this.mCompMainEffect.addItemListener(this);
        controlAction = new ComboboxAction(this.mParentDlg, CONFI_INTERVAL);
        this.mConfiInterval = new JComboBox<String>(this.getResStringArray("IDS_REP_MEA_OPT_CONFIDENCE_COMBO_ITEMS"));
        this.mConfiInterval.setAction(controlAction);
        this.mConfiInterval.setEnabled(false);
        this.mConfiIntervalLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_CONFIDENCE_INTERVAL_ADJUSTMENT");
        this.mConfiIntervalLabel.setEnabled(false);
        this.mConfiIntervalLabel.setLabelFor(this.mConfiInterval);
        this.mArrowButton.registerVariableList(this.mSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetList, SpssArrowButton.ButtonOrientation.left);
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(DialogUtil.applyMultiLines(this.getResString("IDS_UNIVARIATE_OPTIONS_FACTORS_TOOLTIP")));
        jPopupMenu.add(jMenuItem);
        this.mSrcList.addMouseListener(new VariablesDlgPopupListener(jPopupMenu));
        JPopupMenu jPopupMenu2 = new JPopupMenu();
        JMenuItem jMenuItem2 = new JMenuItem(DialogUtil.applyMultiLines(this.getResString("IDS_UNIVARIATE_OPTIONS_TEST_TOOLTIP")));
        jPopupMenu2.add(jMenuItem2);
        this.mTargetList.addMouseListener(new VariablesDlgPopupListener(jPopupMenu2));
    }

    private JPanel setupMeanPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_ESTIMATED_MARGINAL_MEANS"));
        jPanel.setBorder(titledBorder);
        JLabel jLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_FACTORS_AND_FACTOR_INTERACTIONS");
        jLabel.setLabelFor(this.mSrcList);
        JLabel jLabel2 = DialogUtil.createLabel(this.mParentDlg, "IDS_DISPLAY_MEANS_FOR");
        jLabel2.setLabelFor(this.mTargetList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        int n3 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, n2, 0, 0);
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        Insets insets3 = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        insets = new Insets(0, n2, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 4, n, insets);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 2;
        insets = new Insets(n2, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        insets = new Insets(0, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mTargetScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets = new Insets(n3, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mCompMainEffect, gridBagConstraints, 2, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets = new Insets(n3, 0, insets3.bottom, n2);
        DialogUtil.addUsingGBL(jPanel, this.mConfiIntervalLabel, gridBagConstraints, 2, 3, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        insets = new Insets(0, 0, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mConfiInterval, gridBagConstraints, 2, 4, 1, 1, n, insets);
        return jPanel;
    }

    private DefaultListModel getSrcListModel() {
        DefaultListModel defaultListModel = (DefaultListModel)this.mSrcList.getModel();
        Vector<String> vector = this.mParentDlg instanceof UnivariateDlg ? ((UnivariateDlg)this.mParentDlg).getFactorCombinations() : (this.mParentDlg instanceof MultivariateDlg ? ((MultivariateDlg)this.mParentDlg).getFactorCombinations() : ((RepeatedMeasureDlg)this.mParentDlg).getFactorCombinations(OPTIONS));
        String string = OVERALL;
        defaultListModel.addElement(string);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                string = vector.get(i);
                defaultListModel.addElement(string);
            }
        }
        return defaultListModel;
    }

    private void addDragAdapters() {
        DragPane dragPane = (DragPane)this.getGlassPane();
        PlainListDragAdapter plainListDragAdapter = new PlainListDragAdapter(this.mSrcList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(this.mSrcList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mSrcList, this.mPlainListVarMoveHandler));
        plainListDragAdapter = new PlainListDragAdapter(this.mTargetList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(this.mTargetList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mTargetList, this.mPlainListVarMoveHandler));
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetList);
        vector.add(this.mCompMainEffect);
        vector.add(this.mConfiInterval);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    class VariablesDlgPopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        VariablesDlgPopupListener(JPopupMenu jPopupMenu) {
            this.popup = jPopupMenu;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

