/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.adv_stats;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssPseudoVariable;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFormatter;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.adv_stats.GLMContrastFormatter;
import com.spss.java_client.ui.dialogs.adv_stats.GLMContrastListModel;
import com.spss.java_client.ui.dialogs.adv_stats.UnivariateDlg;
import com.spss.java_client.ui.dialogs.adv_stats.multivariate.MultivariateDlg;
import com.spss.java_client.ui.dialogs.adv_stats.rep_measures.RepeatedMeasureDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GLMCommonContrast
extends BaseSubDialog
implements ItemListener,
ListSelectionListener {
    public static final String CHANGE_BUTTON = "IDS_CHANGE_BUTTON";
    public static final String SRC_LIST = "IDS_SOURCE_LIST";
    public static final String LAST_RADIO = "IDS_CONTRAST_LAST";
    public static final String RADIO_FIRST = "IDS_CONTRAST_FIRST";
    public static final String CONTRAST_COMBO = "IDS_CONTRAST_COMBO";
    public static String GLM_CONTRAST_INDEX_MAP = "IDS_GLM_CONTRAST_INDEX_MAP";
    private static int mLocalId = -1;
    private JLabel mRefCategorylabel;
    private JButton mChangeButton;
    private JComboBox mContrastCombo;
    private JScrollPane mFactorSrollPane;
    private JRadioButton mLastRadio;
    private JRadioButton mFirstRadio;
    private SpssButtonGroup mRadioGroup;
    private TargetVariableList mFactorList;
    private VarListModel mFixFactorVars;
    private VarListModel mRandFactorVars;
    private Vector<String> mRepMeasuresFactors;
    private GLMContrastFormatter mFormatter;
    private String[] mContrastItems;
    private String[] mContrastItemsWithoutNone;
    private HashMap<Integer, Object> mContrastIndexMap;
    private BaseProcedureDialog mParent;

    public GLMCommonContrast(BaseProcedureDialog baseProcedureDialog, String string, Vector<String> vector, VarListModel varListModel, VarListModel varListModel2) {
        super(baseProcedureDialog, string, true);
        this.mParent = baseProcedureDialog;
        this.mFixFactorVars = varListModel;
        this.mRandFactorVars = varListModel2;
        this.mRepMeasuresFactors = vector;
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            int n = 1;
            int n2 = 2;
            if (this.isOnlyWithinSubjectsFactorsSelected()) {
                --n;
                --n2;
            }
            boolean bl = this.mContrastCombo.getSelectedIndex() == n || this.mContrastCombo.getSelectedIndex() == n2;
            this.mRefCategorylabel.setEnabled(bl);
            this.mLastRadio.setEnabled(bl);
            this.mFirstRadio.setEnabled(bl);
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_glmu_con";
    }

    public static String getGLMContrastSyntax(BaseDialog baseDialog, DialogDataModel dialogDataModel) {
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray(SRC_LIST);
        HashMap<Integer, Object> hashMap = GLMCommonContrast.loadLuidKeyMap(dialogDataModel, SRC_LIST, false);
        HashMap<Integer, Object> hashMap2 = GLMCommonContrast.loadLuidKeyMap(dialogDataModel, GLM_CONTRAST_INDEX_MAP, true);
        String string = "";
        if (iSpssVariableArray != null) {
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                if (iSpssVariable instanceof SpssPseudoVariable) continue;
                String string2 = hashMap.get(iSpssVariable.getId().asInt()).toString();
                String string3 = hashMap2.get(iSpssVariable.getId().asInt()).toString();
                if (string2.equals(baseDialog.getResString("IDS_CONTRAST_DEFAULT_SUFFIX"))) continue;
                if ((string2 = string2.substring(string2.indexOf("(") + 1, string2.indexOf(")"))).indexOf("(") != -1) {
                    string3 = string3 + "(1)";
                }
                string = string + SyntaxUtil.getSubCommand("/CONTRAST(") + iSpssVariable.getName() + ")=" + string3 + "\n";
            }
        }
        return string;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        Integer n;
        if (dialogDataModel.getMap(GLM_CONTRAST_INDEX_MAP) != null) {
            this.mContrastIndexMap = GLMCommonContrast.loadLuidKeyMap(dialogDataModel, GLM_CONTRAST_INDEX_MAP, true);
        }
        this.mFormatter.setVarMap(GLMCommonContrast.loadLuidKeyMap(dialogDataModel, this.mFactorList.getIdentifier(), false));
        this.mFactorList.removeAll();
        this.loadTargetList(this.mFactorList, dialogDataModel);
        this.setListModel();
        this.mFactorList.setSelectedIndex(0);
        Boolean bl = dialogDataModel.getBoolean(RADIO_FIRST);
        if (bl != null && bl.booleanValue()) {
            this.mFirstRadio.setSelected(true);
        }
        if ((bl = dialogDataModel.getBoolean(LAST_RADIO)) != null && bl.booleanValue()) {
            this.mLastRadio.setSelected(true);
        }
        if ((n = dialogDataModel.getInteger(CONTRAST_COMBO)) != null) {
            this.mContrastCombo.setSelectedIndex(n);
        }
        this.mContrastCombo.setEnabled(this.getNumItemsInFactorList() > 0);
        this.mChangeButton.setEnabled(this.getNumItemsInFactorList() > 0);
    }

    private void updateContrastComboboxItems() {
        if (this.isOnlyWithinSubjectsFactorsSelected()) {
            this.mContrastCombo.setModel(new DefaultComboBoxModel<String>(this.mContrastItemsWithoutNone));
        } else {
            this.mContrastCombo.setModel(new DefaultComboBoxModel<String>(this.mContrastItems));
        }
    }

    protected int getNumItemsInFactorList() {
        return this.mFactorList.getModel().getSize();
    }

    protected boolean isOnlyWithinSubjectsFactorsSelected() {
        if (this.mParent instanceof RepeatedMeasureDlg) {
            int n = 0;
            int n2 = 0;
            for (ISpssVariable iSpssVariable : this.mFactorList.getSelectedValues()) {
                if (this.fixFactorsContainsVar(iSpssVariable)) {
                    ++n;
                    continue;
                }
                ++n2;
            }
            return n == 0 && n2 > 0;
        }
        return false;
    }

    protected boolean isMixedFactorsSelected() {
        if (this.mParent instanceof RepeatedMeasureDlg) {
            int n = 0;
            int n2 = 0;
            for (ISpssVariable iSpssVariable : this.mFactorList.getSelectedValues()) {
                if (this.fixFactorsContainsVar(iSpssVariable)) {
                    ++n;
                    continue;
                }
                ++n2;
            }
            return n > 0 && n2 > 0;
        }
        return false;
    }

    private boolean fixFactorsContainsVar(ISpssVariable iSpssVariable) {
        Vector<String> vector;
        boolean bl = false;
        if (this.mParentDlg instanceof RepeatedMeasureDlg) {
            vector = ((RepeatedMeasureDlg)this.mParentDlg).getFixFactorVarList();
        } else if (this.mParentDlg instanceof UnivariateDlg) {
            vector = ((UnivariateDlg)this.mParentDlg).getFixFactorVarList();
        } else if (this.mParentDlg instanceof MultivariateDlg) {
            vector = ((MultivariateDlg)this.mParentDlg).getFixFactorVarList();
        } else {
            assert (false);
            return false;
        }
        for (String string : vector) {
            if (!string.equals(iSpssVariable.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        GLMCommonContrast.saveTargetList(this.mFactorList, dialogDataModel);
        GLMCommonContrast.saveLuidKeyMap(dialogDataModel, this.mFormatter.getVarMapForSerialization(), this.mFactorList.getIdentifier(), this.mContrastIndexMap);
        GLMCommonContrast.saveLuidKeyMap(dialogDataModel, this.mContrastIndexMap, GLM_CONTRAST_INDEX_MAP, this.mContrastIndexMap);
        dialogDataModel.putInteger(CONTRAST_COMBO, this.mContrastCombo.getSelectedIndex());
        dialogDataModel.putBoolean(LAST_RADIO, this.mLastRadio.isSelected());
        dialogDataModel.putBoolean(RADIO_FIRST, this.mFirstRadio.isSelected());
        return true;
    }

    public static void saveLuidKeyMap(DialogDataModel dialogDataModel, HashMap<Integer, Object> hashMap, String string, HashMap<Integer, Object> hashMap2) {
        dialogDataModel.putMap(string, hashMap);
        if (CommandLine.isClementineCaller()) {
            LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            HashMap<Integer, Object> hashMap3 = new HashMap<Integer, Object>();
            for (Map.Entry<Integer, Object> entry : hashMap.entrySet()) {
                int n = iSpssDataSrc.findVarIndex(new LocallyUniqueId(entry.getKey().intValue()));
                if (n > -1) {
                    ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(n);
                    hashMap3.put(entry.getKey(), iSpssVariable.getName());
                    continue;
                }
                if (entry.getKey() < 0 && hashMap2 != null) {
                    hashMap3.put(entry.getKey(), hashMap2.get(entry.getKey()));
                    continue;
                }
                assert (false);
            }
            dialogDataModel.putMap(string + "_index", hashMap3);
        }
    }

    public static HashMap<Integer, Object> loadLuidKeyMap(DialogDataModel dialogDataModel, String string, boolean bl) {
        HashMap<Integer, Object> hashMap = dialogDataModel.getMap(string);
        if (hashMap != null && CommandLine.isClementineCaller()) {
            hashMap = SpssVarFormatter.updateLuids(dialogDataModel, string, hashMap);
            if (bl) {
                LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
                ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
                HashMap<Integer, Object> hashMap2 = new HashMap<Integer, Object>();
                HashMap<Integer, Object> hashMap3 = dialogDataModel.getMap(string + "_index");
                for (Map.Entry<Integer, Object> entry : hashMap.entrySet()) {
                    String string2 = hashMap3.get(entry.getKey()).toString();
                    if (entry.getKey() < 0) {
                        hashMap2.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    int n = iSpssDataSrc.findVarIndex(string2);
                    if (n <= -1) continue;
                    ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(n);
                    hashMap2.put(iSpssVariable.getId().asInt(), entry.getValue());
                }
                hashMap = hashMap2;
            }
        }
        return hashMap;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupPlotPanel();
        JPanel jPanel3 = this.setupContrastPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 2, 1, 1, n, insets);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    private void loadTargetList(VariableList variableList, DialogDataModel dialogDataModel) {
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray(variableList.getIdentifier());
        if (iSpssVariableArray != null && iSpssVariableArray.length > 0) {
            variableList.getModel().removeAll();
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                variableList.getModel().addElement(iSpssVariable);
            }
        }
    }

    private static void saveTargetList(VariableList variableList, DialogDataModel dialogDataModel) {
        VarListModel varListModel = variableList.getModel();
        int n = varListModel.getSize();
        ISpssVariable[] iSpssVariableArray = new ISpssVariable[n];
        int n2 = 0;
        for (int i = 0; i < varListModel.getSize(); ++i) {
            ISpssVariable iSpssVariable = variableList.getModel().getElementAt(i);
            iSpssVariableArray[n2] = iSpssVariable.getId().asInt() < 0 ? iSpssVariable : iSpssVariable;
            ++n2;
        }
        dialogDataModel.putVarArray(variableList.getIdentifier(), iSpssVariableArray);
    }

    private void initVars() {
        this.mContrastItems = this.getResStringArray("IDS_CONTRAST_COMBO_ITEMS");
        this.mContrastItemsWithoutNone = this.getResStringArray("IDS_CONTRAST_COMBO_ITEMS_WITHOUT_NONE");
        this.mFactorList = new TargetVariableList();
        this.mFactorList.setIdentifier(SRC_LIST);
        this.mFactorList.setShowIcon(false);
        this.mFactorList.setShowVarLabels(false, true);
        this.mFactorList.setAllowDuplicates(false);
        this.mFormatter = new GLMContrastFormatter(this.mFactorList);
        this.mFactorList.setModel(new GLMContrastListModel(this.mFormatter));
        this.mFactorList.setCellRenderer(new CustomVarListCellRenderer(this.mFormatter));
        this.mFactorSrollPane = new JScrollPane(this.mFactorList);
        this.mFactorSrollPane.setPreferredSize(new Dimension(150, 80));
        this.mRefCategorylabel = new JLabel(this.getResString("IDS_UNIVARIATE_REFERENCE_CATEGORY"));
        this.mRefCategorylabel.setEnabled(false);
        ControlAction controlAction = new ToggleButtonAction(this.mParentDlg, LAST_RADIO);
        this.mLastRadio = new JRadioButton(controlAction);
        this.mLastRadio.setSelected(true);
        this.mLastRadio.setEnabled(false);
        controlAction = new ToggleButtonAction(this.mParentDlg, RADIO_FIRST);
        this.mFirstRadio = new JRadioButton(controlAction);
        this.mFirstRadio.setEnabled(false);
        this.mRadioGroup = new SpssButtonGroup();
        this.mRadioGroup.add(this.mLastRadio);
        this.mRadioGroup.add(this.mFirstRadio);
        controlAction = new ComboboxAction(this.mParentDlg, CONTRAST_COMBO);
        this.mContrastCombo = new JComboBox<String>(this.mContrastItems);
        this.mContrastCombo.setAction(controlAction);
        this.mContrastCombo.addItemListener(this);
        controlAction = new ToggleButtonAction(this.mParentDlg, CHANGE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GLMCommonContrast.this.changeListData();
            }
        };
        this.mFactorList.addListSelectionListener(this);
        this.mChangeButton = new JButton(controlAction);
        this.mChangeButton.addItemListener(this);
        this.mContrastIndexMap = new HashMap();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mFactorList);
        vector.add(this.mContrastCombo);
        vector.add(this.mRadioGroup);
        vector.add(this.mChangeButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.mFactorList) {
            this.updateContrastComboboxItems();
            this.mChangeButton.setEnabled(!this.isMixedFactorsSelected());
            this.mContrastCombo.setEnabled(!this.isMixedFactorsSelected());
            ISpssVariable iSpssVariable = (ISpssVariable)this.mFactorList.getSelectedValue();
            String string = this.mContrastIndexMap.get(iSpssVariable.getId().asInt()).toString();
            this.mContrastCombo.setSelectedItem(null);
            this.mContrastCombo.setSelectedItem(string);
        }
    }

    private void changeListData() {
        String[] stringArray = this.isOnlyWithinSubjectsFactorsSelected() ? new String[]{"Deviation", "Simple", "Difference", "Helmert", "Repeated", "Polynomial"} : new String[]{"None", "Deviation", "Simple", "Difference", "Helmert", "Repeated", "Polynomial"};
        String string = this.mContrastCombo.getSelectedItem().toString();
        if (this.mFirstRadio.isEnabled() && this.mFirstRadio.isSelected()) {
            string = string + "(" + this.mFirstRadio.getText().toLowerCase() + ")";
        }
        for (ISpssVariable iSpssVariable : this.mFactorList.getSelectedValues()) {
            if (iSpssVariable.getType() > 0 && this.mContrastCombo.getSelectedIndex() == this.mContrastCombo.getItemCount() - 1) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_CONTRAST_POLYNOMIAL_MAY_NOT_BE_SPECIFIED_FOR_STRING_VAR_MSG"), VersionInfo.getAppVersionString());
                continue;
            }
            ((GLMContrastListModel)this.mFactorList.getModel()).setElementPropertyAt(iSpssVariable, string);
            this.mContrastIndexMap.put(iSpssVariable.getId().asInt(), stringArray[this.mContrastCombo.getSelectedIndex()]);
        }
    }

    private void setListModel() {
        ISpssVariable iSpssVariable;
        String[] stringArray = new String[]{"None", "Deviation", "Simple", "Difference", "Helmert", "Repeated", "Polynomial"};
        GLMContrastListModel gLMContrastListModel = (GLMContrastListModel)this.mFactorList.getModel();
        if (this.mRepMeasuresFactors != null && this.mRepMeasuresFactors.size() > 0) {
            block0: for (String string : this.mRepMeasuresFactors) {
                iSpssVariable = new SpssPseudoVariable();
                iSpssVariable.setName(string);
                if (!this.hasItemWithName(iSpssVariable)) {
                    iSpssVariable.setId(new LocallyUniqueId(mLocalId--));
                    gLMContrastListModel.addElement(iSpssVariable, this.getResString("IDS_CONTRAST_COMBO_POLYNOMIAL_ITEM"));
                    this.mContrastIndexMap.put(iSpssVariable.getId().asInt(), stringArray[stringArray.length - 1]);
                    continue;
                }
                for (int i = 0; i < gLMContrastListModel.getSize(); ++i) {
                    ISpssVariable iSpssVariable2 = gLMContrastListModel.getElementAt(i);
                    if (!iSpssVariable2.getName().equals(string)) continue;
                    String string2 = this.mContrastIndexMap.get(iSpssVariable2.getId().asInt()).toString();
                    this.mFormatter.getVarMap().put(iSpssVariable2.getId().asInt(), "(" + string2 + ")");
                    continue block0;
                }
            }
        }
        if (this.mFixFactorVars != null) {
            for (int i = 0; i < this.mFixFactorVars.getSize(); ++i) {
                iSpssVariable = this.mFixFactorVars.getElementAt(i);
                if (this.hasItem(iSpssVariable)) continue;
                gLMContrastListModel.addElement(iSpssVariable, this.getResString("IDS_CONTRAST_DEFAULT_SUFFIX"));
                this.mContrastIndexMap.put(iSpssVariable.getId().asInt(), stringArray[0]);
            }
        }
        if (this.mRandFactorVars != null) {
            for (int i = 0; i < this.mRandFactorVars.getSize(); ++i) {
                iSpssVariable = this.mRandFactorVars.getElementAt(i);
                if (this.hasItem(iSpssVariable)) continue;
                gLMContrastListModel.addElement(iSpssVariable, this.getResString("IDS_CONTRAST_DEFAULT_SUFFIX"));
                this.mContrastIndexMap.put(iSpssVariable.getId().asInt(), stringArray[0]);
            }
        }
    }

    private boolean hasItem(ISpssVariable iSpssVariable) {
        boolean bl = false;
        boolean bl2 = CommandLine.isClementineCaller();
        GLMContrastListModel gLMContrastListModel = (GLMContrastListModel)this.mFactorList.getModel();
        for (int i = 0; i < gLMContrastListModel.getSize(); ++i) {
            ISpssVariable iSpssVariable2 = gLMContrastListModel.getElementAt(i);
            bl = bl2 ? iSpssVariable.getName().equals(iSpssVariable2.getName()) : iSpssVariable.getId().equals((Object)iSpssVariable2.getId());
            if (bl) break;
        }
        return bl;
    }

    private boolean hasItemWithName(ISpssVariable iSpssVariable) {
        boolean bl = false;
        GLMContrastListModel gLMContrastListModel = (GLMContrastListModel)this.mFactorList.getModel();
        for (int i = 0; i < gLMContrastListModel.getSize(); ++i) {
            ISpssVariable iSpssVariable2 = gLMContrastListModel.getElementAt(i);
            if (!iSpssVariable2.getName().equals(iSpssVariable.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private JPanel setupPlotPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_CONTRAST_FACTORS");
        jLabel.setLabelFor(this.mFactorList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mFactorSrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setupContrastPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_CHANGE_CONTRASTS"));
        jPanel.setBorder(titledBorder);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_CONTRAST");
        jLabel.setLabelFor(this.mContrastCombo);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 10;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mContrastCombo, gridBagConstraints, 1, 0, 2, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        insets = new Insets(insets.top, n2, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mChangeButton, gridBagConstraints, 3, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        insets = new Insets(3, 3, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mRefCategorylabel, gridBagConstraints, 0, 1, 2, 0, n, insets);
        insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mLastRadio, gridBagConstraints, 2, 1, 1, 0, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mFirstRadio, gridBagConstraints, 3, 1, 1, 0, n, insets);
        return jPanel;
    }
}

